/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.UnwrappingBeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;

public class BeanPropertyWriter
extends PropertyWriter
implements BeanProperty {
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final AnnotatedMember _member;
    protected final Annotations _contextAnnotations;
    protected final JavaType _declaredType;
    protected final Method _accessorMethod;
    protected final Field _field;
    protected HashMap<Object, Object> _internalSettings;
    protected final SerializedString _name;
    protected final PropertyName _wrapperName;
    protected final JavaType _cfgSerializationType;
    protected JsonSerializer<Object> _serializer;
    protected JsonSerializer<Object> _nullSerializer;
    protected transient PropertySerializerMap _dynamicSerializers;
    protected final boolean _suppressNulls;
    protected final Object _suppressableValue;
    protected final Class<?>[] _includeInViews;
    protected TypeSerializer _typeSerializer;
    protected JavaType _nonTrivialBaseType;
    protected final PropertyMetadata _metadata;

    public BeanPropertyWriter(BeanPropertyDefinition propDef, AnnotatedMember member, Annotations contextAnnotations, JavaType declaredType, JsonSerializer<?> ser, TypeSerializer typeSer, JavaType serType, boolean suppressNulls, Object suppressableValue) {
        this._member = member;
        this._contextAnnotations = contextAnnotations;
        this._name = new SerializedString(propDef.getName());
        this._wrapperName = propDef.getWrapperName();
        this._metadata = propDef.getMetadata();
        this._includeInViews = propDef.findViews();
        this._declaredType = declaredType;
        this._serializer = ser;
        this._dynamicSerializers = ser == null ? PropertySerializerMap.emptyForProperties() : null;
        this._typeSerializer = typeSer;
        this._cfgSerializationType = serType;
        if (member instanceof AnnotatedField) {
            this._accessorMethod = null;
            this._field = (Field)member.getMember();
        } else if (member instanceof AnnotatedMethod) {
            this._accessorMethod = (Method)member.getMember();
            this._field = null;
        } else {
            this._accessorMethod = null;
            this._field = null;
        }
        this._suppressNulls = suppressNulls;
        this._suppressableValue = suppressableValue;
        this._nullSerializer = null;
    }

    protected BeanPropertyWriter() {
        this._member = null;
        this._contextAnnotations = null;
        this._name = null;
        this._wrapperName = null;
        this._metadata = null;
        this._includeInViews = null;
        this._declaredType = null;
        this._serializer = null;
        this._dynamicSerializers = null;
        this._typeSerializer = null;
        this._cfgSerializationType = null;
        this._accessorMethod = null;
        this._field = null;
        this._suppressNulls = false;
        this._suppressableValue = null;
        this._nullSerializer = null;
    }

    protected BeanPropertyWriter(BeanPropertyWriter base) {
        this(base, base._name);
    }

    protected BeanPropertyWriter(BeanPropertyWriter base, PropertyName name2) {
        this._name = new SerializedString(name2.getSimpleName());
        this._wrapperName = base._wrapperName;
        this._member = base._member;
        this._contextAnnotations = base._contextAnnotations;
        this._declaredType = base._declaredType;
        this._accessorMethod = base._accessorMethod;
        this._field = base._field;
        this._serializer = base._serializer;
        this._nullSerializer = base._nullSerializer;
        if (base._internalSettings != null) {
            this._internalSettings = new HashMap<Object, Object>(base._internalSettings);
        }
        this._cfgSerializationType = base._cfgSerializationType;
        this._dynamicSerializers = base._dynamicSerializers;
        this._suppressNulls = base._suppressNulls;
        this._suppressableValue = base._suppressableValue;
        this._includeInViews = base._includeInViews;
        this._typeSerializer = base._typeSerializer;
        this._nonTrivialBaseType = base._nonTrivialBaseType;
        this._metadata = base._metadata;
    }

    protected BeanPropertyWriter(BeanPropertyWriter base, SerializedString name2) {
        this._name = name2;
        this._wrapperName = base._wrapperName;
        this._member = base._member;
        this._contextAnnotations = base._contextAnnotations;
        this._declaredType = base._declaredType;
        this._accessorMethod = base._accessorMethod;
        this._field = base._field;
        this._serializer = base._serializer;
        this._nullSerializer = base._nullSerializer;
        if (base._internalSettings != null) {
            this._internalSettings = new HashMap<Object, Object>(base._internalSettings);
        }
        this._cfgSerializationType = base._cfgSerializationType;
        this._dynamicSerializers = base._dynamicSerializers;
        this._suppressNulls = base._suppressNulls;
        this._suppressableValue = base._suppressableValue;
        this._includeInViews = base._includeInViews;
        this._typeSerializer = base._typeSerializer;
        this._nonTrivialBaseType = base._nonTrivialBaseType;
        this._metadata = base._metadata;
    }

    public BeanPropertyWriter rename(NameTransformer transformer) {
        String newName = transformer.transform(this._name.getValue());
        if (newName.equals(this._name.toString())) {
            return this;
        }
        return new BeanPropertyWriter(this, new PropertyName(newName));
    }

    public void assignSerializer(JsonSerializer<Object> ser) {
        if (this._serializer != null && this._serializer != ser) {
            throw new IllegalStateException("Can not override serializer");
        }
        this._serializer = ser;
    }

    public void assignNullSerializer(JsonSerializer<Object> nullSer) {
        if (this._nullSerializer != null && this._nullSerializer != nullSer) {
            throw new IllegalStateException("Can not override null serializer");
        }
        this._nullSerializer = nullSer;
    }

    public BeanPropertyWriter unwrappingWriter(NameTransformer unwrapper) {
        return new UnwrappingBeanPropertyWriter(this, unwrapper);
    }

    public void setNonTrivialBaseType(JavaType t) {
        this._nonTrivialBaseType = t;
    }

    @Override
    public String getName() {
        return this._name.getValue();
    }

    @Override
    public PropertyName getFullName() {
        return new PropertyName(this._name.getValue());
    }

    @Override
    public JavaType getType() {
        return this._declaredType;
    }

    @Override
    public PropertyName getWrapperName() {
        return this._wrapperName;
    }

    @Override
    public boolean isRequired() {
        return this._metadata.isRequired();
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._member == null ? null : (A)this._member.getAnnotation(acls);
    }

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return this._contextAnnotations == null ? null : (A)this._contextAnnotations.get(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._member;
    }

    protected void _depositSchemaProperty(ObjectNode propertiesNode, JsonNode schemaNode) {
        propertiesNode.set(this.getName(), schemaNode);
    }

    public boolean isVirtual() {
        return false;
    }

    public Object getInternalSetting(Object key2) {
        return this._internalSettings == null ? null : this._internalSettings.get(key2);
    }

    public Object setInternalSetting(Object key2, Object value) {
        if (this._internalSettings == null) {
            this._internalSettings = new HashMap();
        }
        return this._internalSettings.put(key2, value);
    }

    public Object removeInternalSetting(Object key2) {
        Object removed = null;
        if (this._internalSettings != null) {
            removed = this._internalSettings.remove(key2);
            if (this._internalSettings.size() == 0) {
                this._internalSettings = null;
            }
        }
        return removed;
    }

    public SerializableString getSerializedName() {
        return this._name;
    }

    public boolean hasSerializer() {
        return this._serializer != null;
    }

    public boolean hasNullSerializer() {
        return this._nullSerializer != null;
    }

    public boolean isUnwrapping() {
        return false;
    }

    public boolean willSuppressNulls() {
        return this._suppressNulls;
    }

    public JsonSerializer<Object> getSerializer() {
        return this._serializer;
    }

    public JavaType getSerializationType() {
        return this._cfgSerializationType;
    }

    public Class<?> getRawSerializationType() {
        return this._cfgSerializationType == null ? null : this._cfgSerializationType.getRawClass();
    }

    public Class<?> getPropertyType() {
        return this._accessorMethod != null ? this._accessorMethod.getReturnType() : this._field.getType();
    }

    public Type getGenericPropertyType() {
        if (this._accessorMethod != null) {
            return this._accessorMethod.getGenericReturnType();
        }
        if (this._field != null) {
            return this._field.getGenericType();
        }
        return null;
    }

    public Class<?>[] getViews() {
        return this._includeInViews;
    }

    @Override
    public void serializeAsField(Object bean2, JsonGenerator gen2, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap m;
        Object value;
        Object object = value = this._accessorMethod == null ? this._field.get(bean2) : this._accessorMethod.invoke(bean2, new Object[0]);
        if (value == null) {
            if (this._nullSerializer != null) {
                gen2.writeFieldName(this._name);
                this._nullSerializer.serialize(null, gen2, prov);
            }
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (m = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(m, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean2 && this._handleSelfReference(bean2, gen2, prov, ser)) {
            return;
        }
        gen2.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            ser.serialize(value, gen2, prov);
        } else {
            ser.serializeWithType(value, gen2, prov, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsOmittedField(Object bean2, JsonGenerator gen2, SerializerProvider prov) throws Exception {
        if (!gen2.canOmitFields()) {
            gen2.writeOmittedField(this._name.getValue());
        }
    }

    @Override
    public void serializeAsElement(Object bean2, JsonGenerator gen2, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map2;
        Object value;
        Object object = value = this._accessorMethod == null ? this._field.get(bean2) : this._accessorMethod.invoke(bean2, new Object[0]);
        if (value == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, gen2, prov);
            } else {
                gen2.writeNull();
            }
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (map2 = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map2, cls, prov);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (ser.isEmpty(prov, value)) {
                    this.serializeAsPlaceholder(bean2, gen2, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsPlaceholder(bean2, gen2, prov);
                return;
            }
        }
        if (value == bean2 && this._handleSelfReference(bean2, gen2, prov, ser)) {
            return;
        }
        if (this._typeSerializer == null) {
            ser.serialize(value, gen2, prov);
        } else {
            ser.serializeWithType(value, gen2, prov, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsPlaceholder(Object bean2, JsonGenerator gen2, SerializerProvider prov) throws Exception {
        if (this._nullSerializer != null) {
            this._nullSerializer.serialize(null, gen2, prov);
        } else {
            gen2.writeNull();
        }
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor v) throws JsonMappingException {
        if (v != null) {
            if (this.isRequired()) {
                v.property(this);
            } else {
                v.optionalProperty(this);
            }
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
        JavaType propType = this.getSerializationType();
        Class<?> hint = propType == null ? this.getGenericPropertyType() : propType.getRawClass();
        JsonSerializer<Object> ser = this.getSerializer();
        if (ser == null) {
            ser = provider.findValueSerializer(this.getType(), (BeanProperty)this);
        }
        boolean isOptional = !this.isRequired();
        JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, hint, isOptional) : JsonSchema.getDefaultSchemaNode();
        this._depositSchemaProperty(propertiesNode, schemaNode);
    }

    protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map2, Class<?> type2, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result;
        if (this._nonTrivialBaseType != null) {
            JavaType t = provider.constructSpecializedType(this._nonTrivialBaseType, type2);
            result = map2.findAndAddPrimarySerializer(t, provider, (BeanProperty)this);
        } else {
            result = map2.findAndAddPrimarySerializer(type2, provider, (BeanProperty)this);
        }
        if (map2 != result.map) {
            this._dynamicSerializers = result.map;
        }
        return result.serializer;
    }

    public final Object get(Object bean2) throws Exception {
        return this._accessorMethod == null ? this._field.get(bean2) : this._accessorMethod.invoke(bean2, new Object[0]);
    }

    protected boolean _handleSelfReference(Object bean2, JsonGenerator gen2, SerializerProvider prov, JsonSerializer<?> ser) throws JsonMappingException {
        if (prov.isEnabled(SerializationFeature.FAIL_ON_SELF_REFERENCES) && !ser.usesObjectId() && ser instanceof BeanSerializerBase) {
            throw new JsonMappingException("Direct self-reference leading to cycle");
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("property '").append(this.getName()).append("' (");
        if (this._accessorMethod != null) {
            sb.append("via method ").append(this._accessorMethod.getDeclaringClass().getName()).append("#").append(this._accessorMethod.getName());
        } else if (this._field != null) {
            sb.append("field \"").append(this._field.getDeclaringClass().getName()).append("#").append(this._field.getName());
        } else {
            sb.append("virtual");
        }
        if (this._serializer == null) {
            sb.append(", no static serializer");
        } else {
            sb.append(", static serializer of type " + this._serializer.getClass().getName());
        }
        sb.append(')');
        return sb.toString();
    }
}

