/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import java.io.IOException;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public class BlameResult {
    private final String resultPath;
    private final RevCommit[] sourceCommits;
    private final PersonIdent[] sourceAuthors;
    private final PersonIdent[] sourceCommitters;
    private final String[] sourcePaths;
    private final int[] sourceLines;
    private RawText resultContents;
    private BlameGenerator generator;
    private int lastLength;

    public static BlameResult create(BlameGenerator gen2) throws IOException {
        String path2 = gen2.getResultPath();
        RawText contents = gen2.getResultContents();
        if (contents == null) {
            gen2.close();
            return null;
        }
        return new BlameResult(gen2, path2, contents);
    }

    BlameResult(BlameGenerator bg, String path2, RawText text) {
        this.generator = bg;
        this.resultPath = path2;
        this.resultContents = text;
        int cnt = text.size();
        this.sourceCommits = new RevCommit[cnt];
        this.sourceAuthors = new PersonIdent[cnt];
        this.sourceCommitters = new PersonIdent[cnt];
        this.sourceLines = new int[cnt];
        this.sourcePaths = new String[cnt];
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public RawText getResultContents() {
        return this.resultContents;
    }

    public void discardResultContents() {
        this.resultContents = null;
    }

    public boolean hasSourceData(int idx) {
        return this.sourceLines[idx] != 0;
    }

    public boolean hasSourceData(int start, int end) {
        while (start < end) {
            if (this.sourceLines[start] == 0) {
                return false;
            }
            ++start;
        }
        return true;
    }

    public RevCommit getSourceCommit(int idx) {
        return this.sourceCommits[idx];
    }

    public PersonIdent getSourceAuthor(int idx) {
        return this.sourceAuthors[idx];
    }

    public PersonIdent getSourceCommitter(int idx) {
        return this.sourceCommitters[idx];
    }

    public String getSourcePath(int idx) {
        return this.sourcePaths[idx];
    }

    public int getSourceLine(int idx) {
        return this.sourceLines[idx] - 1;
    }

    public void computeAll() throws IOException {
        BlameGenerator gen2 = this.generator;
        if (gen2 == null) {
            return;
        }
        try {
            while (gen2.next()) {
                this.loadFrom(gen2);
            }
        }
        finally {
            gen2.close();
            this.generator = null;
        }
    }

    public int computeNext() throws IOException {
        BlameGenerator gen2 = this.generator;
        if (gen2 == null) {
            return -1;
        }
        if (gen2.next()) {
            this.loadFrom(gen2);
            this.lastLength = gen2.getRegionLength();
            return gen2.getResultStart();
        }
        gen2.close();
        this.generator = null;
        return -1;
    }

    public int lastLength() {
        return this.lastLength;
    }

    public void computeRange(int start, int end) throws IOException {
        BlameGenerator gen2 = this.generator;
        if (gen2 == null) {
            return;
        }
        if (start == 0 && end == this.resultContents.size()) {
            this.computeAll();
            return;
        }
        while (start < end) {
            if (this.hasSourceData(start, end)) {
                return;
            }
            if (!gen2.next()) {
                gen2.close();
                this.generator = null;
                return;
            }
            this.loadFrom(gen2);
            int resLine = gen2.getResultStart();
            int resEnd = gen2.getResultEnd();
            if (resLine <= start && start < resEnd) {
                start = resEnd;
            }
            if (resLine > end || end >= resEnd) continue;
            end = resLine;
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("BlameResult: ");
        r.append(this.getResultPath());
        return r.toString();
    }

    private void loadFrom(BlameGenerator gen2) {
        RevCommit srcCommit = gen2.getSourceCommit();
        PersonIdent srcAuthor = gen2.getSourceAuthor();
        PersonIdent srcCommitter = gen2.getSourceCommitter();
        String srcPath = gen2.getSourcePath();
        int srcLine = gen2.getSourceStart();
        int resEnd = gen2.getResultEnd();
        for (int resLine = gen2.getResultStart(); resLine < resEnd; ++resLine) {
            if (this.sourceLines[resLine] != 0) continue;
            this.sourceCommits[resLine] = srcCommit;
            this.sourceAuthors[resLine] = srcAuthor;
            this.sourceCommitters[resLine] = srcCommitter;
            this.sourcePaths[resLine] = srcPath;
            this.sourceLines[resLine] = ++srcLine;
        }
    }
}

