/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.watermarkpack.flamefractal;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.watermarkpack.flamefractal.FractalFlameFactory;
import org.pushingpixels.substance.watermarkpack.flamefractal.IteratedFunctionSystem;

public class SubstanceFlameFractalWatermark
implements SubstanceWatermark {
    private Image watermarkImage = null;
    protected String displayName;
    protected IteratedFunctionSystem functionSystem;

    public SubstanceFlameFractalWatermark(String displayName, IteratedFunctionSystem functionSystem) {
        this.displayName = displayName;
        this.functionSystem = functionSystem;
    }

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(this.watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage(SubstanceSkin skin) {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        this.watermarkImage = SubstanceCoreUtilities.getBlankImage((int)screenWidth, (int)screenHeight);
        Graphics2D graphics = (Graphics2D)this.watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(skin, graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
    }

    private boolean drawWatermarkImage(SubstanceSkin skin, Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        if (!isPreview) {
            SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
            int alpha = scheme.isDark() ? 200 : 250;
            graphics.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            graphics.drawImage((Image)FractalFlameFactory.getFractalFlameImage(scheme, scheme, width, height, 25000000, this.functionSystem), x, y, null);
        }
        return true;
    }

    public void dispose() {
        this.watermarkImage = null;
    }
}

