/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.PathExecLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.lang.JavaVersion;

public class SystemInfo
extends SystemInfoRt {
    public static final String OS_NAME = SystemInfoRt.OS_NAME;
    public static final String OS_VERSION = SystemInfoRt.OS_VERSION;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = SystemInfo.getRtVersion(JAVA_VERSION);
    public static final String JAVA_VENDOR = System.getProperty("java.vm.vendor", "Unknown");
    @Deprecated
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop", "");
    public static final boolean isWindows = SystemInfoRt.isWindows;
    public static final boolean isMac = SystemInfoRt.isMac;
    public static final boolean isLinux = SystemInfoRt.isLinux;
    public static final boolean isFreeBSD = SystemInfoRt.isFreeBSD;
    public static final boolean isSolaris = SystemInfoRt.isSolaris;
    public static final boolean isUnix = SystemInfoRt.isUnix;
    public static final boolean isAppleJvm = StringUtil.containsIgnoreCase(JAVA_VENDOR, "Apple");
    public static final boolean isOracleJvm = StringUtil.containsIgnoreCase(JAVA_VENDOR, "Oracle");
    public static final boolean isSunJvm = StringUtil.containsIgnoreCase(JAVA_VENDOR, "Sun") && StringUtil.containsIgnoreCase(JAVA_VENDOR, "Microsystems");
    public static final boolean isIbmJvm = StringUtil.containsIgnoreCase(JAVA_VENDOR, "IBM");
    public static final boolean isJetBrainsJvm = StringUtil.containsIgnoreCase(JAVA_VENDOR, "JetBrains");
    public static final boolean IS_AT_LEAST_JAVA9 = SystemInfo.isModularJava();
    public static final boolean isWin2kOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.0");
    public static final boolean isWinXpOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.1");
    public static final boolean isWinVistaOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.0");
    public static final boolean isWin7OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.1");
    public static final boolean isWin8OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.2");
    public static final boolean isWin10OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("10.0");
    public static final boolean isXWindow = isUnix && !isMac;
    public static final boolean isWayland = isXWindow && !StringUtil.isEmpty(System.getenv("WAYLAND_DISPLAY"));
    public static final boolean isGNOME = isXWindow && (ObjectUtils.notNull(System.getenv("GDMSESSION"), "").startsWith("gnome") || ObjectUtils.notNull(System.getenv("XDG_CURRENT_DESKTOP"), "").toLowerCase(Locale.ENGLISH).endsWith("gnome"));
    public static final boolean isKDE = isXWindow && !StringUtil.isEmpty(System.getenv("KDE_FULL_SESSION"));
    public static final boolean isMacSystemMenu = isMac && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
    public static final boolean isFileSystemCaseSensitive = SystemInfoRt.isFileSystemCaseSensitive;
    public static final boolean areSymLinksSupported = isUnix || isWinVistaOrNewer;
    public static final boolean is32Bit = SystemInfoRt.is32Bit;
    public static final boolean is64Bit = SystemInfoRt.is64Bit;
    public static final boolean isMacIntel64 = isMac && "x86_64".equals(OS_ARCH);
    private static final NotNullLazyValue<Boolean> ourHasXdgOpen = new PathExecLazyValue("xdg-open");
    private static final NotNullLazyValue<Boolean> ourHasXdgMime = new PathExecLazyValue("xdg-mime");
    public static final boolean isMacOSTiger = isMac && SystemInfo.isOsVersionAtLeast("10.4");
    public static final boolean isMacOSLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.5");
    public static final boolean isMacOSSnowLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.6");
    public static final boolean isMacOSLion = isMac && SystemInfo.isOsVersionAtLeast("10.7");
    public static final boolean isMacOSMountainLion = isMac && SystemInfo.isOsVersionAtLeast("10.8");
    public static final boolean isMacOSMavericks = isMac && SystemInfo.isOsVersionAtLeast("10.9");
    public static final boolean isMacOSYosemite = isMac && SystemInfo.isOsVersionAtLeast("10.10");
    public static final boolean isMacOSElCapitan = isMac && SystemInfo.isOsVersionAtLeast("10.11");
    public static final boolean isMacOSSierra = isMac && SystemInfo.isOsVersionAtLeast("10.12");
    public static final boolean isMacOSHighSierra = isMac && SystemInfo.isOsVersionAtLeast("10.13");
    public static final boolean isMacOSMojave = isMac && SystemInfo.isOsVersionAtLeast("10.14");
    @Deprecated
    public static final boolean isWindowsXP = isWindows && (OS_VERSION.equals("5.1") || OS_VERSION.equals("5.2"));
    @Deprecated
    public static final boolean isAMD64 = "amd64".equals(OS_ARCH);

    private static String getRtVersion(String fallback) {
        String rtVersion = System.getProperty("java.runtime.version");
        return Character.isDigit(rtVersion.charAt(0)) ? rtVersion : fallback;
    }

    private static boolean isModularJava() {
        try {
            Class.class.getMethod("getModule", new Class[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isOsVersionAtLeast(@NotNull String version) {
        if (version == null) {
            SystemInfo.$$$reportNull$$$0(0);
        }
        return StringUtil.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    public static boolean hasXdgOpen() {
        return isXWindow && ourHasXdgOpen.getValue() != false;
    }

    public static boolean isJavaVersionAtLeast(int major, int minor, int update) {
        return JavaVersion.current().compareTo(JavaVersion.compose(major, minor, update, 0, false)) >= 0;
    }

    @Deprecated
    public static boolean isJavaVersionAtLeast(String v2) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v2) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/SystemInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/SystemInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMajorVersion";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSVersionCode";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMajorVersionCode";
                break;
            }
            case 4: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacOSMinorVersionCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOsVersionAtLeast";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSVersionCode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSMajorVersionCode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSMinorVersionCode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMacOSVersionParts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

