/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingData;

public class ClassSetAnalysis {
    private final ClassSetAnalysisData classAnalysis;
    private final AnnotationProcessingData annotationProcessingData;
    private final ImmutableSetMultimap<String, String> dependenciesFromAnnotationProcessing;

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis) {
        this(classAnalysis, new AnnotationProcessingData());
    }

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis, AnnotationProcessingData annotationProcessingData) {
        this.classAnalysis = classAnalysis;
        this.annotationProcessingData = annotationProcessingData;
        ImmutableSetMultimap.Builder dependenciesFromAnnotationProcessing = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Set<String>> entry : annotationProcessingData.getGeneratedTypesByOrigin().entrySet()) {
            for (String generated : entry.getValue()) {
                String origin = entry.getKey();
                dependenciesFromAnnotationProcessing.put((Object)origin, (Object)generated);
                dependenciesFromAnnotationProcessing.put((Object)generated, (Object)origin);
            }
        }
        this.dependenciesFromAnnotationProcessing = dependenciesFromAnnotationProcessing.build();
    }

    public ClassSetAnalysis withAnnotationProcessingData(AnnotationProcessingData annotationProcessingData) {
        return new ClassSetAnalysis(this.classAnalysis, annotationProcessingData);
    }

    public DependentsSet getRelevantDependents(Iterable<String> classes, IntSet constants) {
        LinkedHashSet result = null;
        for (String cls : classes) {
            DependentsSet d = this.getRelevantDependents(cls, constants);
            if (d.isDependencyToAll()) {
                return d;
            }
            Set<String> dependentClasses = d.getDependentClasses();
            if (dependentClasses.isEmpty()) continue;
            if (result == null) {
                result = Sets.newLinkedHashSet();
            }
            result.addAll(dependentClasses);
        }
        return result == null ? DependentsSet.empty() : DependentsSet.dependents(result);
    }

    public DependentsSet getRelevantDependents(String className, IntSet constants) {
        String fullRebuildCause = this.annotationProcessingData.getFullRebuildCause();
        if (fullRebuildCause != null) {
            return DependentsSet.dependencyToAll(fullRebuildCause);
        }
        DependentsSet deps = this.getDependents(className);
        if (deps.isDependencyToAll()) {
            return deps;
        }
        if (!constants.isEmpty()) {
            return DependentsSet.dependencyToAll();
        }
        Set<String> dependingOnAllOthers = this.annotationProcessingData.getGeneratedTypesDependingOnAllOthers();
        if (deps.getDependentClasses().isEmpty() && dependingOnAllOthers.isEmpty()) {
            return deps;
        }
        HashSet<String> result = new HashSet<String>();
        this.recurseDependents(new HashSet<String>(), result, deps.getDependentClasses());
        this.recurseDependents(new HashSet<String>(), result, dependingOnAllOthers);
        result.remove(className);
        return DependentsSet.dependents(result);
    }

    public Set<String> getTypesToReprocess() {
        return this.annotationProcessingData.getAggregatedTypes();
    }

    public boolean isDependencyToAll(String className) {
        return this.classAnalysis.getDependents(className).isDependencyToAll();
    }

    private void recurseDependents(Set<String> visited, Set<String> result, Iterable<String> dependentClasses) {
        for (String d : dependentClasses) {
            DependentsSet currentDependents;
            if (!visited.add(d)) continue;
            if (!this.isNestedClass(d)) {
                result.add(d);
            }
            if ((currentDependents = this.getDependents(d)).isDependencyToAll()) continue;
            this.recurseDependents(visited, result, currentDependents.getDependentClasses());
        }
    }

    private DependentsSet getDependents(String className) {
        DependentsSet dependents = this.classAnalysis.getDependents(className);
        if (dependents.isDependencyToAll()) {
            return dependents;
        }
        ImmutableSet additionalDeps = this.dependenciesFromAnnotationProcessing.get((Object)className);
        if (additionalDeps.isEmpty()) {
            return dependents;
        }
        return DependentsSet.dependents((Set<String>)Sets.union(dependents.getDependentClasses(), (Set)additionalDeps));
    }

    private boolean isNestedClass(String d) {
        return d.contains("$");
    }

    public IntSet getConstants(String className) {
        return this.classAnalysis.getConstants(className);
    }
}

