/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import com.headius.backport9.modules.Modules;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicInteger;
import jnr.enxio.channels.NativeSelectableChannel;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.util.collections.NonBlockingHashMapLong;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class FilenoUtil {
    public static final int FIRST_FAKE_FD = 100000;
    protected final AtomicInteger internalFilenoIndex = new AtomicInteger(100000);
    private final NonBlockingHashMapLong<ChannelFD> filenoMap = new NonBlockingHashMapLong();
    private final POSIX posix;
    static final Logger LOG = LoggerFactory.getLogger(FilenoUtil.class);

    public FilenoUtil(POSIX posix) {
        this.posix = posix;
    }

    public static FileDescriptor getDescriptorFromChannel(Channel channel) {
        block11: {
            if (ReflectiveAccess.SEL_CH_IMPL_GET_FD != null && ReflectiveAccess.SEL_CH_IMPL.isInstance(channel)) {
                try {
                    return (FileDescriptor)ReflectiveAccess.SEL_CH_IMPL_GET_FD.invoke((Object)channel, new Object[0]);
                }
                catch (Exception exception2) {
                    break block11;
                }
            }
            if (ReflectiveAccess.FILE_CHANNEL_IMPL_FD != null && ReflectiveAccess.FILE_CHANNEL_IMPL.isInstance(channel)) {
                try {
                    return (FileDescriptor)ReflectiveAccess.FILE_CHANNEL_IMPL_FD.get(channel);
                }
                catch (Exception exception3) {
                    break block11;
                }
            }
            if (ReflectiveAccess.FILE_DESCRIPTOR_FD != null) {
                FileDescriptor unixFD = new FileDescriptor();
                try {
                    if (channel instanceof UnixSocketChannel) {
                        ReflectiveAccess.FILE_DESCRIPTOR_FD.set(unixFD, ((UnixSocketChannel)channel).getFD());
                        return unixFD;
                    }
                    if (channel instanceof UnixServerSocketChannel) {
                        ReflectiveAccess.FILE_DESCRIPTOR_FD.set(unixFD, ((UnixServerSocketChannel)channel).getFD());
                        return unixFD;
                    }
                }
                catch (Exception exception4) {
                    // empty catch block
                }
            }
        }
        return new FileDescriptor();
    }

    public ChannelFD getWrapperFromFileno(int fileno2) {
        FileStat stat2;
        ChannelFD fd = this.filenoMap.get(fileno2);
        if (fd != null && !fd.ch.isOpen() && !FilenoUtil.isFake(fileno2) && this.posix.fstat(fileno2, stat2 = this.posix.allocateStat()) >= 0) {
            this.filenoMap.remove(fileno2);
            fd = null;
        }
        return fd;
    }

    public void registerWrapper(int fileno2, ChannelFD wrapper) {
        if (fileno2 == -1) {
            return;
        }
        this.filenoMap.put(fileno2, wrapper);
    }

    public void unregisterWrapper(int fileno2) {
        if (fileno2 == -1) {
            return;
        }
        this.filenoMap.remove(fileno2);
    }

    public int getNumberOfWrappers() {
        return this.filenoMap.size();
    }

    public int getNewFileno() {
        return this.internalFilenoIndex.getAndIncrement();
    }

    public static boolean isFake(int fileno2) {
        return fileno2 < 0 || fileno2 >= 100000;
    }

    public static int filenoFrom(Channel channel) {
        if (channel instanceof NativeSelectableChannel) {
            return ((NativeSelectableChannel)channel).getFD();
        }
        return FilenoUtil.getFilenoUsingReflection(channel);
    }

    private static int getFilenoUsingReflection(Channel channel) {
        if (ReflectiveAccess.FILE_DESCRIPTOR_FD != null) {
            return FilenoUtil.filenoFrom(FilenoUtil.getDescriptorFromChannel(channel));
        }
        return -1;
    }

    public static int filenoFrom(FileDescriptor fd) {
        if (fd.valid()) {
            try {
                return (Integer)ReflectiveAccess.FILE_DESCRIPTOR_FD.get(fd);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return -1;
    }

    private static class ReflectiveAccess {
        private static final Class SEL_CH_IMPL;
        private static final Method SEL_CH_IMPL_GET_FD;
        private static final Class FILE_CHANNEL_IMPL;
        private static final Field FILE_CHANNEL_IMPL_FD;
        private static final Field FILE_DESCRIPTOR_FD;

        private ReflectiveAccess() {
        }

        static {
            Field ffd;
            Field fd;
            Class<?> fileChannelImpl;
            Method getFD;
            Class<?> selChImpl;
            try {
                Modules.addOpens(FileDescriptor.class, "sun.nio.ch", ReflectiveAccess.class);
            }
            catch (RuntimeException re) {
                LOG.warn("Native subprocess control requires open access to sun.nio.ch\nPass '--add-opens java.base/sun.nio.ch=org.jruby.dist' or '=org.jruby.core' to enable.", re);
            }
            try {
                selChImpl = Class.forName("sun.nio.ch.SelChImpl");
                try {
                    getFD = selChImpl.getMethod("getFD", new Class[0]);
                    if (!Modules.trySetAccessible(getFD, ReflectiveAccess.class)) {
                        getFD = null;
                    }
                }
                catch (Exception e) {
                    getFD = null;
                }
            }
            catch (Exception e) {
                selChImpl = null;
                getFD = null;
            }
            SEL_CH_IMPL = selChImpl;
            SEL_CH_IMPL_GET_FD = getFD;
            try {
                fileChannelImpl = Class.forName("sun.nio.ch.FileChannelImpl");
                try {
                    fd = fileChannelImpl.getDeclaredField("fd");
                    if (!Modules.trySetAccessible(fd, ReflectiveAccess.class)) {
                        fd = null;
                    }
                }
                catch (Exception e) {
                    fd = null;
                }
            }
            catch (Exception e) {
                fileChannelImpl = null;
                fd = null;
            }
            FILE_CHANNEL_IMPL = fileChannelImpl;
            FILE_CHANNEL_IMPL_FD = fd;
            try {
                ffd = FileDescriptor.class.getDeclaredField("fd");
                if (!Modules.trySetAccessible(ffd, ReflectiveAccess.class)) {
                    ffd = null;
                }
            }
            catch (Exception e) {
                ffd = null;
            }
            FILE_DESCRIPTOR_FD = ffd;
        }
    }
}

