/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Configuration;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.ParserSettings;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.ResourceHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.repository.url.URLResource;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractModuleDescriptorParser
implements ModuleDescriptorParser {
    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL descriptorURL, boolean validate) throws ParseException, IOException {
        return this.parseDescriptor(ivySettings, descriptorURL, new URLResource(descriptorURL), validate);
    }

    @Override
    public String getType() {
        return "ivy";
    }

    @Override
    public Artifact getMetadataArtifact(ModuleRevisionId mrid, Resource res) {
        return DefaultArtifact.newIvyArtifact(mrid, new Date(res.getLastModified()));
    }

    protected static abstract class AbstractParser
    extends DefaultHandler {
        private static final String DEFAULT_CONF_MAPPING = "*->*";
        private String defaultConf;
        private String defaultConfMapping;
        private DefaultDependencyDescriptor defaultConfMappingDescriptor;
        private Resource res;
        private List errors = new ArrayList();
        private DefaultModuleDescriptor md;
        private ModuleDescriptorParser parser;

        protected AbstractParser(ModuleDescriptorParser parser) {
            this.parser = parser;
        }

        public ModuleDescriptorParser getModuleDescriptorParser() {
            return this.parser;
        }

        protected void checkErrors() throws ParseException {
            if (!this.errors.isEmpty()) {
                throw new ParseException(this.errors.toString(), 0);
            }
        }

        public void setResource(Resource res) {
            this.res = res;
            this.md = new DefaultModuleDescriptor(this.parser, res);
            this.md.setLastModified(ResourceHelper.getLastModifiedOrDefault(res));
        }

        protected Resource getResource() {
            return this.res;
        }

        protected String getDefaultConfMapping() {
            return this.defaultConfMapping;
        }

        protected void setDefaultConfMapping(String defaultConf) {
            this.defaultConfMapping = defaultConf;
            this.getMd().setDefaultConfMapping(defaultConf);
        }

        protected void parseDepsConfs(String confs, DefaultDependencyDescriptor dd) {
            this.parseDepsConfs(confs, dd, this.defaultConfMapping != null);
        }

        protected void parseDepsConfs(String confs, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperande) {
            this.parseDepsConfs(confs, dd, useDefaultMappingToGuessRightOperande, true);
        }

        protected void parseDepsConfs(String confs, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperande, boolean evaluateConditions) {
            if (confs == null) {
                return;
            }
            String[] conf = confs.split(";");
            this.parseDepsConfs(conf, dd, useDefaultMappingToGuessRightOperande, evaluateConditions);
        }

        protected void parseDepsConfs(String[] conf, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperande) {
            this.parseDepsConfs(conf, dd, useDefaultMappingToGuessRightOperande, true);
        }

        protected void parseDepsConfs(String[] conf, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperande, boolean evaluateConditions) {
            this.replaceConfigurationWildcards(this.md);
            for (int i = 0; i < conf.length; ++i) {
                String mappedDependency;
                int k;
                String[] modConfs;
                String[] ops = conf[i].split("->");
                if (ops.length == 1) {
                    int j;
                    modConfs = ops[0].split(",");
                    if (!useDefaultMappingToGuessRightOperande) {
                        for (j = 0; j < modConfs.length; ++j) {
                            dd.addDependencyConfiguration(modConfs[j].trim(), modConfs[j].trim());
                        }
                        continue;
                    }
                    for (j = 0; j < modConfs.length; ++j) {
                        String[] depConfs = this.getDefaultConfMappingDescriptor().getDependencyConfigurations(modConfs[j]);
                        if (depConfs.length > 0) {
                            for (k = 0; k < depConfs.length; ++k) {
                                String string = mappedDependency = evaluateConditions ? this.evaluateCondition(depConfs[k].trim(), dd) : depConfs[k].trim();
                                if (mappedDependency == null) continue;
                                dd.addDependencyConfiguration(modConfs[j].trim(), mappedDependency);
                            }
                            continue;
                        }
                        dd.addDependencyConfiguration(modConfs[j].trim(), modConfs[j].trim());
                    }
                    continue;
                }
                if (ops.length == 2) {
                    modConfs = ops[0].split(",");
                    String[] depConfs = ops[1].split(",");
                    for (int j = 0; j < modConfs.length; ++j) {
                        for (k = 0; k < depConfs.length; ++k) {
                            String string = mappedDependency = evaluateConditions ? this.evaluateCondition(depConfs[k].trim(), dd) : depConfs[k].trim();
                            if (mappedDependency == null) continue;
                            dd.addDependencyConfiguration(modConfs[j].trim(), mappedDependency);
                        }
                    }
                    continue;
                }
                this.addError("invalid conf " + conf[i] + " for " + dd);
            }
            if (this.md.isMappingOverride()) {
                this.addExtendingConfigurations(conf, dd, useDefaultMappingToGuessRightOperande);
            }
        }

        private String evaluateCondition(String conf, DefaultDependencyDescriptor dd) {
            if (conf.charAt(0) != '[') {
                return conf;
            }
            int endConditionIndex = conf.indexOf(93);
            if (endConditionIndex == -1) {
                this.addError("invalid conf " + conf + " for " + dd);
                return null;
            }
            String condition = conf.substring(1, endConditionIndex);
            int notEqualIndex = condition.indexOf("!=");
            if (notEqualIndex == -1) {
                String attrValue;
                int equalIndex = condition.indexOf(61);
                if (equalIndex == -1) {
                    this.addError("invalid conf " + conf + " for " + dd.getDependencyRevisionId());
                    return null;
                }
                String leftOp = condition.substring(0, equalIndex).trim();
                String rightOp = condition.substring(equalIndex + 1).trim();
                if (leftOp.equals("org") || leftOp.equals("organization")) {
                    leftOp = "organisation";
                }
                if (!rightOp.equals(attrValue = dd.getAttribute(leftOp))) {
                    return null;
                }
            } else {
                String attrValue;
                String leftOp = condition.substring(0, notEqualIndex).trim();
                String rightOp = condition.substring(notEqualIndex + 2).trim();
                if (leftOp.equals("org") || leftOp.equals("organization")) {
                    leftOp = "organisation";
                }
                if (rightOp.equals(attrValue = dd.getAttribute(leftOp))) {
                    return null;
                }
            }
            return conf.substring(endConditionIndex + 1);
        }

        private void addExtendingConfigurations(String[] confs, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperande) {
            for (int i = 0; i < confs.length; ++i) {
                this.addExtendingConfigurations(confs[i], dd, useDefaultMappingToGuessRightOperande);
            }
        }

        private void addExtendingConfigurations(String conf, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperande) {
            HashSet<String> configsToAdd = new HashSet<String>();
            Configuration[] configs = this.md.getConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                String[] ext = configs[i].getExtends();
                for (int j = 0; j < ext.length; ++j) {
                    if (!conf.equals(ext[j])) continue;
                    String configName = configs[i].getName();
                    configsToAdd.add(configName);
                    this.addExtendingConfigurations(configName, dd, useDefaultMappingToGuessRightOperande);
                }
            }
            String[] confs = configsToAdd.toArray(new String[configsToAdd.size()]);
            this.parseDepsConfs(confs, dd, useDefaultMappingToGuessRightOperande);
        }

        protected DependencyDescriptor getDefaultConfMappingDescriptor() {
            if (this.defaultConfMappingDescriptor == null) {
                this.defaultConfMappingDescriptor = new DefaultDependencyDescriptor(ModuleRevisionId.newInstance("", "", ""), false);
                this.parseDepsConfs(this.defaultConfMapping, this.defaultConfMappingDescriptor, false, false);
            }
            return this.defaultConfMappingDescriptor;
        }

        protected void addError(String msg) {
            if (this.res != null) {
                this.errors.add(msg + " in " + this.res + "\n");
            } else {
                this.errors.add(msg + "\n");
            }
        }

        @Override
        public void warning(SAXParseException ex) {
            Message.warn("xml parsing: " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        @Override
        public void error(SAXParseException ex) {
            this.addError("xml parsing: " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.addError("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        private String getLocationString(SAXParseException ex) {
            StringBuffer str = new StringBuffer();
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            } else if (this.getResource() != null) {
                str.append(this.getResource().toString());
            }
            str.append(':');
            str.append(ex.getLineNumber());
            str.append(':');
            str.append(ex.getColumnNumber());
            return str.toString();
        }

        protected String getDefaultConf() {
            return this.defaultConf != null ? this.defaultConf : (this.defaultConfMapping != null ? this.defaultConfMapping : DEFAULT_CONF_MAPPING);
        }

        protected void setDefaultConf(String defaultConf) {
            this.defaultConf = defaultConf;
            this.getMd().setDefaultConf(defaultConf);
        }

        public ModuleDescriptor getModuleDescriptor() throws ParseException {
            this.checkErrors();
            return this.md;
        }

        protected Date getDefaultPubDate() {
            return new Date(this.md.getLastModified());
        }

        private void replaceConfigurationWildcards(ModuleDescriptor md) {
            Configuration[] configs = md.getConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                configs[i].replaceWildcards(md);
            }
        }

        protected void setMd(DefaultModuleDescriptor md) {
            this.md = md;
        }

        protected DefaultModuleDescriptor getMd() {
            return this.md;
        }
    }
}

