/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.languagetool.tools.BuilderOptions;
import org.languagetool.tools.DictionaryBuilder;

public final class POSDictionaryBuilder
extends DictionaryBuilder {
    public POSDictionaryBuilder(File infoFile) throws IOException {
        super(infoFile);
    }

    public static void main(String[] args) throws Exception {
        BuilderOptions builderOptions = new BuilderOptions();
        builderOptions.addOption("i", true, "tab-separated plain-text dictionary file with format: wordform<tab>lemma<tab>postag", true);
        builderOptions.addOption("info", true, "*.info properties file, see http://wiki.languagetool.org/developing-a-tagger-dictionary", true);
        builderOptions.addOption("freq", true, "optional .xml file with a frequency wordlist, see http://wiki.languagetool.org/developing-a-tagger-dictionary", false);
        CommandLine cmdLine = builderOptions.parseArguments(args, POSDictionaryBuilder.class);
        POSDictionaryBuilder builder = new POSDictionaryBuilder(new File(cmdLine.getOptionValue("info")));
        builder.setOutputFilename(cmdLine.getOptionValue("o"));
        File inputFile = new File(cmdLine.getOptionValue("i"));
        if (cmdLine.hasOption("freq")) {
            builder.readFreqList(new File(cmdLine.getOptionValue("freq")));
            inputFile = builder.addFreqData(inputFile, false);
        }
        builder.build(inputFile);
    }

    public File build(File dictFile) throws Exception {
        return this.buildDict(this.convertTabToSeparator(dictFile));
    }
}

