/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.suggestions.SuggestionsChanges;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrderer;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrdererFeatureExtractor;
import org.languagetool.rules.spelling.symspell.implementation.SuggestItem;
import org.languagetool.rules.spelling.symspell.implementation.SuggestionStage;
import org.languagetool.rules.spelling.symspell.implementation.SymSpell;

@Experimental
public class SymSpellRule
extends SpellingCheckRule {
    private static final LoadingCache<Language, SymSpell> spellerCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Language, SymSpell>(){

        public SymSpell load(Language lang) {
            return SymSpellRule.initDefaultDictSpeller(lang);
        }
    });
    private static final LoadingCache<Language, Set<String>> ignoredWordsCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Language, Set<String>>(){

        public Set<String> load(Language lang) throws Exception {
            return SymSpellRule.getWordList(lang, "ignore.txt");
        }
    });
    public static final int INITIAL_CAPACITY = 50000;
    private static final LoadingCache<Language, Set<String>> prohibitedWordsCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Language, Set<String>>(){

        public Set<String> load(Language lang) throws Exception {
            return SymSpellRule.getWordList(lang, "probibit.txt");
        }
    });
    protected final SymSpell defaultDictSpeller;
    protected final SymSpell userDictSpeller;
    private int editDistance = 3;
    private SymSpell.Verbosity verbosity = SymSpell.Verbosity.Closest;
    private SuggestionsOrderer orderer = null;

    @NotNull
    private static Set<String> getWordList(Language lang, String file) {
        String base = SymSpellRule.getSpellingDictBaseDir(lang);
        List<String> paths = Collections.singletonList(base + file);
        HashSet words = new HashSet();
        SymSpellRule.forEachLineInResources(paths, words::add);
        return Collections.unmodifiableSet(words);
    }

    protected static String getSpellingDictBaseDir(Language lang) {
        return lang.getShortCode() + "/hunspell/";
    }

    private static void forEachLineInResources(List<String> resources, Consumer<String> function) {
        ResourceDataBroker broker = JLanguageTool.getDataBroker();
        for (String resource : resources) {
            if (!broker.resourceExists(resource)) continue;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(broker.getFromResourceDirAsStream(resource)));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        function.accept(line);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read resource " + resource, e);
            }
        }
    }

    @Nullable
    protected static SymSpell initUserDictSpeller(UserConfig config) {
        if (config != null && config.getAcceptedWords() != null && !config.getAcceptedWords().isEmpty()) {
            List<String> dict = config.getAcceptedWords();
            SymSpell speller = new SymSpell(0, 3, -1, 0);
            SuggestionStage stage = new SuggestionStage(dict.size());
            dict.forEach(word -> speller.createDictionaryEntry((String)word, 1L, stage));
            speller.commitStaged(stage);
            return speller;
        }
        return null;
    }

    protected static SymSpell initDefaultDictSpeller(Language lang) {
        SymSpell speller = new SymSpell(50000, 3, -1, 0);
        System.out.println("Initalizing symspell");
        Set prohibitedWords = (Set)prohibitedWordsCache.getUnchecked((Object)lang);
        long startTime = System.currentTimeMillis();
        String base = SymSpellRule.getSpellingDictBaseDir(lang);
        List<String> additional = Arrays.asList(base + "spelling.txt", base + "spelling_" + lang.getShortCodeWithCountryAndVariant() + ".txt");
        List<String> dict = Collections.singletonList(base + lang.getShortCodeWithCountryAndVariant().replaceFirst("-", "_") + ".dic");
        SuggestionStage stage = new SuggestionStage(100000);
        SymSpellRule.forEachLineInResources(additional, word -> {
            if (!prohibitedWords.contains(word)) {
                speller.createDictionaryEntry((String)word, 1L, stage);
            }
        });
        AtomicInteger dictWords = new AtomicInteger(0);
        SymSpellRule.forEachLineInResources(dict, line -> {
            int split = line.lastIndexOf("+");
            if (split == -1 || line.length() <= split + 1) {
                throw new RuntimeException(String.format("Could not parse frequency dictionary line '%s'.", line));
            }
            String word = line.substring(0, split);
            char freqClass = line.charAt(split + 1);
            int freq = 1 + (freqClass - 65);
            if (!prohibitedWords.contains(word)) {
                speller.createDictionaryEntry(word, freq, stage);
                dictWords.incrementAndGet();
            }
        });
        System.out.printf("Loaded %d words from dictionary.%n", dictWords.intValue());
        speller.commitStaged(stage);
        long delta = System.currentTimeMillis() - startTime;
        System.out.printf("Reading dictionaries took %f seconds.%n", (double)delta / 1000.0);
        return speller;
    }

    private void initParameters() {
        if (SuggestionsChanges.getInstance() != null && SuggestionsChanges.getInstance().getCurrentExperiment() != null) {
            if (SuggestionsChanges.getInstance().getCurrentExperiment().parameters.get("candidates") != null) {
                String candidatesParam = (String)SuggestionsChanges.getInstance().getCurrentExperiment().parameters.get("candidates");
                this.verbosity = SymSpell.Verbosity.valueOf(candidatesParam);
            }
            if (SuggestionsChanges.getInstance().getCurrentExperiment().parameters.get("editDistance") != null) {
                this.editDistance = (Integer)SuggestionsChanges.getInstance().getCurrentExperiment().parameters.get("editDistance");
            }
            if (SuggestionsChanges.isRunningExperiment("SymSpell+NewSuggestionsOrderer")) {
                this.orderer = new SuggestionsOrdererFeatureExtractor(this.language, this.languageModel);
            }
        }
    }

    public SymSpellRule(ResourceBundle messages, Language language, UserConfig userConfig) {
        this(messages, language, userConfig, Collections.emptyList());
    }

    public SymSpellRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) {
        this(messages, language, userConfig, altLanguages, null);
    }

    public SymSpellRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages, @Nullable LanguageModel languageModel) {
        super(messages, language, userConfig, altLanguages, languageModel);
        this.initParameters();
        this.defaultDictSpeller = (SymSpell)spellerCache.getUnchecked((Object)language);
        this.userDictSpeller = SymSpellRule.initUserDictSpeller(userConfig);
    }

    @Override
    public String getId() {
        return "SYMSPELL_RULE";
    }

    @Override
    public String getDescription() {
        return "Spell checking rule using SymSpell algorithm";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        Set ignoredWords = (Set)ignoredWordsCache.getUnchecked((Object)this.language);
        for (AnalyzedTokenReadings token : sentence.getTokensWithoutWhitespace()) {
            String word;
            if (token.isSentenceStart() || token.isImmunized() || token.isIgnoredBySpeller() || token.isNonWord() || ignoredWords.contains(word = token.getToken())) continue;
            List<String> candidates = this.filterCandidates(this.getSpellerMatches(word, this.defaultDictSpeller));
            List<String> userCandidates = this.getSpellerMatches(word, this.userDictSpeller);
            RuleMatch match = null;
            if (candidates.size() + userCandidates.size() == 0) {
                match = new RuleMatch(this, sentence, token.getStartPos(), token.getEndPos(), "Misspelling or unknown word!");
            } else if (!(candidates.size() > 0 && candidates.get(0).equals(word) || userCandidates.size() > 0 && userCandidates.get(0).equals(word))) {
                match = new RuleMatch(this, sentence, token.getStartPos(), token.getEndPos(), "Misspelling!");
                SymSpellRule.addSuggestionsToRuleMatch(token.getToken(), userCandidates, candidates, this.orderer, match);
            }
            if (match == null) continue;
            matches.add(match);
        }
        return matches.toArray(new RuleMatch[0]);
    }

    @NotNull
    private List<String> filterCandidates(List<String> candidates) {
        Set ignoredWords = (Set)ignoredWordsCache.getUnchecked((Object)this.language);
        Set prohibitedWords = (Set)prohibitedWordsCache.getUnchecked((Object)this.language);
        return candidates.stream().filter(c -> !ignoredWords.contains(c)).filter(c -> !prohibitedWords.contains(c)).collect(Collectors.toList());
    }

    @NotNull
    private List<String> getSpellerMatches(String word, SymSpell speller) {
        if (speller == null) {
            return Collections.emptyList();
        }
        List<SuggestItem> candidatesData = speller.lookup(word, this.verbosity, this.editDistance);
        return candidatesData.stream().map(candidate -> candidate.term).collect(Collectors.toList());
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Language lang = Languages.getLanguageForShortCode("en-US");
        JLanguageTool lt = new JLanguageTool(lang);
        SymSpellRule r = new SymSpellRule(JLanguageTool.getMessageBundle(), lang, new UserConfig());
        SymSpell speller = r.defaultDictSpeller;
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        long timeStart = System.currentTimeMillis();
        ObjectOutputStream serializer = new ObjectOutputStream(outBuffer);
        serializer.writeObject(speller);
        serializer.close();
        System.out.printf("Serializing took %d ms.%n", System.currentTimeMillis() - timeStart);
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(outBuffer.toByteArray());
        timeStart = System.currentTimeMillis();
        ObjectInputStream deserializer = new ObjectInputStream(inBuffer);
        SymSpell speller2 = (SymSpell)deserializer.readObject();
        System.out.printf("Deserializing took %d ms.%n", System.currentTimeMillis() - timeStart);
        deserializer.close();
        System.out.println(speller.lookupCompound("This is a mistak."));
        System.out.println(speller2.lookupCompound("This is a mistak."));
    }
}

