/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetIndexTemplatesRequest
extends MasterNodeReadRequest<GetIndexTemplatesRequest> {
    private String[] names;

    public GetIndexTemplatesRequest() {
    }

    public GetIndexTemplatesRequest(String ... names) {
        this.names = names;
    }

    public GetIndexTemplatesRequest(StreamInput in) throws IOException {
        super(in);
        this.names = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.names);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.names == null) {
            validationException = ValidateActions.addValidationError("names is null or empty", validationException);
        } else {
            for (String name : this.names) {
                if (name != null && Strings.hasText(name)) continue;
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
        }
        return validationException;
    }

    public GetIndexTemplatesRequest names(String ... names) {
        this.names = names;
        return this;
    }

    public String[] names() {
        return this.names;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }
}

