/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.concurrent.CompletableContext;
import org.elasticsearch.http.HttpServerChannel;

public class Netty4HttpServerChannel
implements HttpServerChannel {
    private final Channel channel;
    private final CompletableContext<Void> closeContext = new CompletableContext();

    Netty4HttpServerChannel(Channel channel) {
        this.channel = channel;
        this.channel.closeFuture().addListener(f -> {
            if (f.isSuccess()) {
                this.closeContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                    this.closeContext.completeExceptionally(new Exception(cause));
                } else {
                    this.closeContext.completeExceptionally((Exception)cause);
                }
            }
        });
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        this.channel.close();
    }

    public String toString() {
        return "Netty4HttpChannel{localAddress=" + this.getLocalAddress() + "}";
    }
}

