/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolverImpl;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionSpecificBehaviorKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmModuleProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BinaryModuleData;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ModuleMappingKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.PackageParts;
import kotlin.reflect.jvm.internal.impl.protobuf.ProtocolStringList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    private final BinaryModuleData moduleData;
    private final String debugName;
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData2, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData2;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        EMPTY = new ModuleMapping(MapsKt.emptyMap(), new BinaryModuleData(CollectionsKt.emptyList()), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.emptyMap(), new BinaryModuleData(CollectionsKt.emptyList()), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(Map packageFqName2Parts, BinaryModuleData moduleData2, String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, moduleData2, debugName);
    }

    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping loadModuleMapping(@Nullable byte[] bytes, @NotNull String debugName, boolean skipMetadataVersionCheck, boolean isJvmPackageNameSupported, @NotNull Function1<? super JvmMetadataVersion, Unit> reportIncompatibleVersionError) {
            void $this$mapTo$iv$iv;
            Object packageParts;
            int[] size$iv22;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
            Intrinsics.checkParameterIsNotNull(reportIncompatibleVersionError, (String)"reportIncompatibleVersionError");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size$iv22 = stream.readInt();
                boolean $i$f$IntArray = false;
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var13_16 = i$iv;
                    void var25_23 = i$iv++;
                    object = result$iv;
                    boolean bl = false;
                    object[var25_23] = n3 = stream.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            JvmMetadataVersion preVersion = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (!skipMetadataVersionCheck && !preVersion.isCompatible()) {
                reportIncompatibleVersionError.invoke((Object)preVersion);
                return EMPTY;
            }
            int flags = VersionSpecificBehaviorKt.isKotlin1Dot4OrLater(preVersion) ? stream.readInt() : 0;
            JvmMetadataVersion version = new JvmMetadataVersion(versionNumber, (flags & 1) != 0);
            if (!skipMetadataVersionCheck && !version.isCompatible()) {
                reportIncompatibleVersionError.invoke((Object)version);
                return EMPTY;
            }
            JvmModuleProtoBuf.Module module = JvmModuleProtoBuf.Module.parseFrom(stream);
            if (module == null) {
                return EMPTY;
            }
            JvmModuleProtoBuf.Module moduleProto = module;
            boolean it = false;
            LinkedHashMap result2 = new LinkedHashMap();
            Iterator<JvmModuleProtoBuf.PackageParts> bl = moduleProto.getPackagePartsList().iterator();
            while (bl.hasNext()) {
                int index;
                Object object2;
                String key$iv;
                void $this$getOrPut$iv22;
                JvmModuleProtoBuf.PackageParts proto;
                JvmModuleProtoBuf.PackageParts packageParts2 = proto = bl.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)packageParts2, (String)"proto");
                String packageFqName = packageParts2.getPackageFqName();
                Map map2 = result2;
                Intrinsics.checkExpressionValueIsNotNull((Object)packageFqName, (String)"packageFqName");
                boolean $i$f$getOrPut22 = false;
                Object value$iv = $this$getOrPut$iv22.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    PackageParts answer$iv = new PackageParts(packageFqName);
                    $this$getOrPut$iv22.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                packageParts = (PackageParts)object2;
                boolean $this$getOrPut$iv22 = false;
                ProtocolStringList protocolStringList = proto.getShortClassNameList();
                Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"proto.shortClassNameList");
                Iterator $i$f$getOrPut22 = ((Iterable)protocolStringList).iterator();
                while ($i$f$getOrPut22.hasNext()) {
                    String partShortName;
                    String string = partShortName = (String)$i$f$getOrPut22.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"partShortName");
                    String string2 = ModuleMappingKt.access$internalNameOf(packageFqName, string);
                    List<Integer> list = proto.getMultifileFacadeShortNameIdList();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"proto.multifileFacadeShortNameIdList");
                    ProtocolStringList protocolStringList2 = proto.getMultifileFacadeShortNameList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList2, (String)"proto.multifileFacadeShortNameList");
                    ((PackageParts)packageParts).addPart(string2, this.loadMultiFileFacadeInternalName(list, protocolStringList2, index, packageFqName));
                    ++index;
                }
                if (!isJvmPackageNameSupported) continue;
                index = 0;
                ProtocolStringList protocolStringList3 = proto.getClassWithJvmPackageNameShortNameList();
                Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList3, (String)"proto.classWithJvmPackageNameShortNameList");
                for (String partShortName : (Iterable)protocolStringList3) {
                    List<Integer> list = proto.getClassWithJvmPackageNamePackageIdList();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"proto.classWithJvmPackageNamePackageIdList");
                    Integer n = (Integer)CollectionsKt.getOrNull(list, (int)index);
                    if (n == null) {
                        List<Integer> list2 = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.classWithJvmPackageNamePackageIdList");
                        n = (Integer)CollectionsKt.lastOrNull(list2);
                    }
                    if (n == null) {
                    } else {
                        int packageId = n;
                        ProtocolStringList protocolStringList4 = moduleProto.getJvmPackageNameList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList4, (String)"moduleProto.jvmPackageNameList");
                        if ((String)CollectionsKt.getOrNull((List)protocolStringList4, (int)packageId) == null) {
                        } else {
                            String jvmPackageName;
                            String string = partShortName;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"partShortName");
                            String string3 = ModuleMappingKt.access$internalNameOf(jvmPackageName, string);
                            List<Integer> list3 = proto.getClassWithJvmPackageNameMultifileFacadeShortNameIdList();
                            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"proto.classWithJvmPackag\u2026fileFacadeShortNameIdList");
                            ProtocolStringList protocolStringList5 = proto.getMultifileFacadeShortNameList();
                            Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList5, (String)"proto.multifileFacadeShortNameList");
                            ((PackageParts)packageParts).addPart(string3, this.loadMultiFileFacadeInternalName(list3, protocolStringList5, index, jvmPackageName));
                        }
                    }
                    ++index;
                }
            }
            for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getMetadataPartsList()) {
                Object object3;
                String key$iv;
                void $this$getOrPut$iv;
                packageParts = result2;
                JvmModuleProtoBuf.PackageParts packageParts3 = proto;
                Intrinsics.checkExpressionValueIsNotNull((Object)packageParts3, (String)"proto");
                Intrinsics.checkExpressionValueIsNotNull((Object)packageParts3.getPackageFqName(), (String)"proto.packageFqName");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    String string = proto.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"proto.packageFqName");
                    PackageParts answer$iv = new PackageParts(string);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                PackageParts packageParts4 = (PackageParts)object3;
                ProtocolStringList protocolStringList = proto.getShortClassNameList();
                Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"proto.shortClassNameList");
                Iterable $this$forEach$iv = protocolStringList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p1 = (String)element$iv;
                    boolean bl4 = false;
                    packageParts4.addMetadataPart(p1);
                }
            }
            ProtoBuf.StringTable stringTable = moduleProto.getStringTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)stringTable, (String)"moduleProto.stringTable");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = moduleProto.getQualifiedNameTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedNameTable, (String)"moduleProto.qualifiedNameTable");
            NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
            List<ProtoBuf.Annotation> list = moduleProto.getAnnotationList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"moduleProto.annotationList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$forEach = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void proto;
                ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item$iv$iv;
                object = destination$iv$iv;
                boolean bl5 = false;
                void v24 = proto;
                Intrinsics.checkExpressionValueIsNotNull((Object)v24, (String)"proto");
                String string = nameResolver.getQualifiedClassName(v24.getId());
                object.add(string);
            }
            List annotations2 = (List)destination$iv$iv;
            return new ModuleMapping(result2, new BinaryModuleData(annotations2), debugName, null);
        }

        private final String loadMultiFileFacadeInternalName(List<Integer> multifileFacadeIds, List<String> multifileFacadeShortNames, int index, String packageFqName) {
            String string;
            String facadeShortName;
            String string2;
            boolean bl;
            boolean bl2;
            Integer n;
            Integer multifileFacadeId;
            Integer n2 = (Integer)CollectionsKt.getOrNull(multifileFacadeIds, (int)index);
            Integer n3 = multifileFacadeId = n2 != null ? Integer.valueOf(n2 - 1) : null;
            if (n3 != null) {
                n = n3;
                bl2 = false;
                bl = false;
                int p1 = ((Number)n).intValue();
                boolean bl3 = false;
                string2 = (String)CollectionsKt.getOrNull(multifileFacadeShortNames, (int)p1);
            } else {
                string2 = null;
            }
            String string3 = facadeShortName = string2;
            if (string3 != null) {
                n = string3;
                bl2 = false;
                bl = false;
                Integer it = n;
                boolean bl4 = false;
                string = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it));
            } else {
                string = null;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

