/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AbstractTypeParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.Variance;

public class TypeParameterDescriptorImpl
extends AbstractTypeParameterDescriptor {
    @Nullable
    private final Function1<KotlinType, Void> reportCycleError;
    private final List<KotlinType> upperBounds;
    private boolean initialized;

    @NotNull
    public static TypeParameterDescriptor createWithDefaultBound(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean reified, @NotNull Variance variance, @NotNull Name name, int index2) {
        if (containingDeclaration == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (annotations2 == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (variance == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (name == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(3);
        }
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, annotations2, reified, variance, name, index2, SourceElement.NO_SOURCE);
        typeParameterDescriptor.addUpperBound(DescriptorUtilsKt.getBuiltIns(containingDeclaration).getDefaultBound());
        typeParameterDescriptor.setInitialized();
        TypeParameterDescriptorImpl typeParameterDescriptorImpl = typeParameterDescriptor;
        if (typeParameterDescriptorImpl == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(4);
        }
        return typeParameterDescriptorImpl;
    }

    public static TypeParameterDescriptorImpl createForFurtherModification(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean reified, @NotNull Variance variance, @NotNull Name name, int index2, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(5);
        }
        if (annotations2 == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(6);
        }
        if (variance == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(7);
        }
        if (name == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(8);
        }
        if (source == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(9);
        }
        return TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, annotations2, reified, variance, name, index2, source, null, SupertypeLoopChecker.EMPTY.INSTANCE);
    }

    public static TypeParameterDescriptorImpl createForFurtherModification(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean reified, @NotNull Variance variance, @NotNull Name name, int index2, @NotNull SourceElement source, @Nullable Function1<KotlinType, Void> reportCycleError, @NotNull SupertypeLoopChecker supertypeLoopsResolver) {
        if (containingDeclaration == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(10);
        }
        if (annotations2 == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(11);
        }
        if (variance == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(12);
        }
        if (name == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(13);
        }
        if (source == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(14);
        }
        if (supertypeLoopsResolver == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(15);
        }
        return new TypeParameterDescriptorImpl(containingDeclaration, annotations2, reified, variance, name, index2, source, reportCycleError, supertypeLoopsResolver);
    }

    private TypeParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean reified, @NotNull Variance variance, @NotNull Name name, int index2, @NotNull SourceElement source, @Nullable Function1<KotlinType, Void> reportCycleError, @NotNull SupertypeLoopChecker supertypeLoopsChecker) {
        if (containingDeclaration == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(16);
        }
        if (annotations2 == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(17);
        }
        if (variance == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(18);
        }
        if (name == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(19);
        }
        if (source == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(20);
        }
        if (supertypeLoopsChecker == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(21);
        }
        super(LockBasedStorageManager.NO_LOCKS, containingDeclaration, annotations2, name, variance, reified, index2, source, supertypeLoopsChecker);
        this.upperBounds = new ArrayList<KotlinType>(1);
        this.initialized = false;
        this.reportCycleError = reportCycleError;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Type parameter descriptor is not initialized: " + this.nameForAssertions());
        }
    }

    private void checkUninitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Type parameter descriptor is already initialized: " + this.nameForAssertions());
        }
    }

    private String nameForAssertions() {
        return this.getName() + " declared in " + DescriptorUtils.getFqName(this.getContainingDeclaration());
    }

    public void setInitialized() {
        this.checkUninitialized();
        this.initialized = true;
    }

    public void addUpperBound(@NotNull KotlinType bound) {
        if (bound == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(22);
        }
        this.checkUninitialized();
        this.doAddUpperBound(bound);
    }

    private void doAddUpperBound(KotlinType bound) {
        if (KotlinTypeKt.isError(bound)) {
            return;
        }
        this.upperBounds.add(bound);
    }

    public void addDefaultUpperBound() {
        this.checkUninitialized();
        if (this.upperBounds.isEmpty()) {
            this.doAddUpperBound(DescriptorUtilsKt.getBuiltIns(this.getContainingDeclaration()).getDefaultBound());
        }
    }

    @Override
    protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(23);
        }
        if (this.reportCycleError == null) {
            return;
        }
        this.reportCycleError.invoke(type2);
    }

    @Override
    @NotNull
    protected List<KotlinType> resolveUpperBounds() {
        this.checkInitialized();
        List<KotlinType> list2 = this.upperBounds;
        if (list2 == null) {
            TypeParameterDescriptorImpl.$$$reportNull$$$0(24);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variance";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/descriptors/impl/TypeParameterDescriptorImpl";
                break;
            }
            case 9: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypeLoopsResolver";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypeLoopsChecker";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bound";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/descriptors/impl/TypeParameterDescriptorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createWithDefaultBound";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveUpperBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWithDefaultBound";
                break;
            }
            case 4: 
            case 24: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createForFurtherModification";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addUpperBound";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reportSupertypeLoopError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

