/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class CaptureBinding
extends TypeVariableBinding {
    public TypeBinding lowerBound;
    public WildcardBinding wildcard;
    public int captureID;
    public ReferenceBinding sourceType;
    public int start;
    public int end;
    public ASTNode cud;
    TypeBinding pendingSubstitute;

    public CaptureBinding(WildcardBinding wildcardBinding, ReferenceBinding referenceBinding, int n, int n2, ASTNode aSTNode, int n3) {
        super(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX, wildcardBinding.environment);
        this.wildcard = wildcardBinding;
        this.modifiers = 0x40000001;
        this.fPackage = wildcardBinding.fPackage;
        this.sourceType = referenceBinding;
        this.start = n;
        this.end = n2;
        this.captureID = n3;
        this.tagBits |= 0x2000000000000000L;
        this.cud = aSTNode;
        if (wildcardBinding.hasTypeAnnotations()) {
            CaptureBinding captureBinding = (CaptureBinding)this.clone(null);
            captureBinding.wildcard = (WildcardBinding)this.wildcard.unannotated();
            this.environment.getUnannotatedType(captureBinding);
            this.id = captureBinding.id;
            this.environment.typeSystem.cacheDerivedType(this, captureBinding, this);
            super.setTypeAnnotations(wildcardBinding.getTypeAnnotations(), wildcardBinding.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled);
            if (wildcardBinding.hasNullTypeAnnotations()) {
                this.tagBits |= 0x100000L;
            }
        } else {
            this.computeId(this.environment);
        }
    }

    protected CaptureBinding(ReferenceBinding referenceBinding, char[] cArray, int n, int n2, int n3, LookupEnvironment lookupEnvironment) {
        super(cArray, null, 0, lookupEnvironment);
        this.modifiers = 0x40000001;
        this.sourceType = referenceBinding;
        this.start = n;
        this.end = n2;
        this.captureID = n3;
    }

    public CaptureBinding(CaptureBinding captureBinding) {
        super(captureBinding);
        this.wildcard = captureBinding.wildcard;
        this.sourceType = captureBinding.sourceType;
        this.start = captureBinding.start;
        this.end = captureBinding.end;
        this.captureID = captureBinding.captureID;
        this.lowerBound = captureBinding.lowerBound;
        this.tagBits |= captureBinding.tagBits & 0x2000000000000000L;
        this.cud = captureBinding.cud;
    }

    @Override
    public TypeBinding clone(TypeBinding typeBinding) {
        return new CaptureBinding(this);
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.sourceType.computeUniqueKey(false));
            stringBuffer.append('&');
        }
        stringBuffer.append(TypeConstants.WILDCARD_CAPTURE);
        stringBuffer.append(this.wildcard.computeUniqueKey(false));
        stringBuffer.append(this.end);
        stringBuffer.append(';');
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public String debugName() {
        if (this.wildcard != null) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(10);
            AnnotationBinding[] annotationBindingArray = this.getTypeAnnotations();
            int n2 = n = annotationBindingArray == null ? 0 : annotationBindingArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(annotationBindingArray[i]);
                stringBuffer.append(' ');
            }
            stringBuffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard.debugName());
            return stringBuffer.toString();
        }
        return super.debugName();
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            this.genericTypeSignature = CharOperation.concat(TypeConstants.WILDCARD_CAPTURE, this.wildcard.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    public void initializeBounds(Scope scope, ParameterizedTypeBinding parameterizedTypeBinding) {
        ReferenceBinding[] referenceBindingArray;
        ReferenceBinding[] referenceBindingArray2;
        TypeVariableBinding typeVariableBinding = this.wildcard.typeVariable();
        if (typeVariableBinding == null) {
            TypeBinding typeBinding = this.wildcard.bound;
            switch (this.wildcard.boundKind) {
                case 1: {
                    TypeBinding typeBinding2 = typeBinding.capture(scope, this.start, this.end);
                    if (typeBinding.isInterface()) {
                        this.setSuperClass(scope.getJavaLangObject());
                        this.setSuperInterfaces(new ReferenceBinding[]{(ReferenceBinding)typeBinding2});
                    } else {
                        if (typeBinding2.isArrayType() || TypeBinding.equalsEquals(typeBinding2, this)) {
                            this.setSuperClass(scope.getJavaLangObject());
                        } else {
                            this.setSuperClass((ReferenceBinding)typeBinding2);
                        }
                        this.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                    }
                    this.setFirstBound(typeBinding2);
                    if ((typeBinding2.tagBits & 0x20000000L) != 0L) break;
                    this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                    break;
                }
                case 0: {
                    this.setSuperClass(scope.getJavaLangObject());
                    this.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                    this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                    break;
                }
                case 2: {
                    this.setSuperClass(scope.getJavaLangObject());
                    this.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                    this.lowerBound = this.wildcard.bound;
                    if ((typeBinding.tagBits & 0x20000000L) != 0L) break;
                    this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                }
            }
            return;
        }
        ReferenceBinding referenceBinding = typeVariableBinding.superclass;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)Scope.substitute((Substitution)parameterizedTypeBinding, referenceBinding);
        if (TypeBinding.equalsEquals(referenceBinding2, this)) {
            referenceBinding2 = referenceBinding;
        }
        if ((referenceBindingArray2 = Scope.substitute((Substitution)parameterizedTypeBinding, referenceBindingArray = typeVariableBinding.superInterfaces())) != referenceBindingArray) {
            int n = referenceBindingArray2.length;
            for (int i = 0; i < n; ++i) {
                if (!TypeBinding.equalsEquals(referenceBindingArray2[i], this)) continue;
                referenceBindingArray2[i] = referenceBindingArray[i];
            }
        }
        TypeBinding typeBinding = this.wildcard.bound;
        switch (this.wildcard.boundKind) {
            case 1: {
                TypeBinding typeBinding3 = typeBinding.capture(scope, this.start, this.end);
                if (typeBinding.isInterface()) {
                    this.setSuperClass(referenceBinding2);
                    if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) {
                        this.setSuperInterfaces(new ReferenceBinding[]{(ReferenceBinding)typeBinding3});
                    } else {
                        int n = referenceBindingArray2.length;
                        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n + 1];
                        System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 1, n);
                        referenceBindingArray2[0] = (ReferenceBinding)typeBinding3;
                        this.setSuperInterfaces(Scope.greaterLowerBound(referenceBindingArray2));
                    }
                } else {
                    if (typeBinding3.isArrayType() || TypeBinding.equalsEquals(typeBinding3, this)) {
                        this.setSuperClass(referenceBinding2);
                    } else {
                        this.setSuperClass((ReferenceBinding)typeBinding3);
                        if (this.superclass.isSuperclassOf(referenceBinding2)) {
                            this.setSuperClass(referenceBinding2);
                        }
                    }
                    this.setSuperInterfaces(referenceBindingArray2);
                }
                this.setFirstBound(typeBinding3);
                if ((typeBinding3.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 0: {
                this.setSuperClass(referenceBinding2);
                this.setSuperInterfaces(referenceBindingArray2);
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 2: {
                this.setSuperClass(referenceBinding2);
                if (TypeBinding.equalsEquals(typeVariableBinding.firstBound, referenceBinding2) || TypeBinding.equalsEquals(typeBinding, referenceBinding2)) {
                    this.setFirstBound(referenceBinding2);
                }
                this.setSuperInterfaces(referenceBindingArray2);
                this.lowerBound = typeBinding;
                if ((typeBinding.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
            }
        }
        if (scope.environment().usesNullTypeAnnotations()) {
            this.evaluateNullAnnotations(scope, null);
        }
    }

    @Override
    public boolean isCapture() {
        return true;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (CaptureBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        if (this.firstBound != null && this.firstBound.isArrayType() && this.firstBound.isCompatibleWith(typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
        }
        return false;
    }

    @Override
    public boolean isProperType(boolean bl) {
        if (this.lowerBound != null && !this.lowerBound.isProperType(bl)) {
            return false;
        }
        if (this.wildcard != null && !this.wildcard.isProperType(bl)) {
            return false;
        }
        return super.isProperType(bl);
    }

    @Override
    public char[] readableName() {
        if (this.wildcard != null) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard.readableName());
            int n = stringBuffer.length();
            char[] cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
            return cArray;
        }
        return super.readableName();
    }

    @Override
    public char[] signableName() {
        if (this.wildcard != null) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(TypeConstants.WILDCARD_CAPTURE_SIGNABLE_NAME_SUFFIX).append(this.wildcard.readableName());
            int n = stringBuffer.length();
            char[] cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
            return cArray;
        }
        return super.readableName();
    }

    @Override
    public char[] shortReadableName() {
        if (this.wildcard != null) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard.shortReadableName());
            int n = stringBuffer.length();
            char[] cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
            return cArray;
        }
        return super.shortReadableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(10);
        this.appendNullAnnotation(stringBuffer, compilerOptions);
        stringBuffer.append(this.sourceName());
        if (!this.inRecursiveFunction) {
            this.inRecursiveFunction = true;
            try {
                if (this.wildcard != null) {
                    stringBuffer.append("of ");
                    stringBuffer.append(this.wildcard.withoutToplevelNullAnnotation().nullAnnotatedReadableName(compilerOptions, bl));
                } else if (this.lowerBound != null) {
                    stringBuffer.append(" super ");
                    stringBuffer.append(this.lowerBound.nullAnnotatedReadableName(compilerOptions, bl));
                } else if (this.firstBound != null) {
                    stringBuffer.append(" extends ");
                    stringBuffer.append(this.firstBound.nullAnnotatedReadableName(compilerOptions, bl));
                    TypeBinding[] typeBindingArray = this.otherUpperBounds();
                    if (typeBindingArray != NO_TYPES) {
                        stringBuffer.append(" & ...");
                    }
                }
            }
            finally {
                this.inRecursiveFunction = false;
            }
        }
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public TypeBinding withoutToplevelNullAnnotation() {
        WildcardBinding wildcardBinding;
        if (!this.hasNullTypeAnnotations()) {
            return this;
        }
        if (this.wildcard != null && this.wildcard.hasNullTypeAnnotations() && (wildcardBinding = (WildcardBinding)this.wildcard.withoutToplevelNullAnnotation()) != this.wildcard) {
            CaptureBinding captureBinding = (CaptureBinding)this.environment.getUnannotatedType(this).clone(null);
            if (wildcardBinding.hasTypeAnnotations()) {
                captureBinding.tagBits |= 0x200000L;
            }
            captureBinding.wildcard = wildcardBinding;
            captureBinding.superclass = this.superclass;
            captureBinding.superInterfaces = this.superInterfaces;
            AnnotationBinding[] annotationBindingArray = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
            return this.environment.createAnnotatedType((TypeBinding)captureBinding, annotationBindingArray);
        }
        return super.withoutToplevelNullAnnotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        if (this.pendingSubstitute != null) {
            return this.pendingSubstitute;
        }
        try {
            TypeBinding typeBinding2 = this.wildcard.substituteInferenceVariable(inferenceVariable, typeBinding);
            if (typeBinding2 != this.wildcard) {
                CaptureBinding captureBinding = (CaptureBinding)this.clone(this.enclosingType());
                captureBinding.wildcard = (WildcardBinding)typeBinding2;
                this.pendingSubstitute = captureBinding;
                if (this.lowerBound != null) {
                    captureBinding.lowerBound = this.lowerBound.substituteInferenceVariable(inferenceVariable, typeBinding);
                }
                if (this.firstBound != null) {
                    captureBinding.firstBound = this.firstBound.substituteInferenceVariable(inferenceVariable, typeBinding);
                }
                if (this.superclass != null) {
                    captureBinding.superclass = (ReferenceBinding)this.superclass.substituteInferenceVariable(inferenceVariable, typeBinding);
                }
                if (this.superInterfaces != null) {
                    int n = this.superInterfaces.length;
                    captureBinding.superInterfaces = new ReferenceBinding[n];
                    for (int i = 0; i < n; ++i) {
                        captureBinding.superInterfaces[i] = (ReferenceBinding)this.superInterfaces[i].substituteInferenceVariable(inferenceVariable, typeBinding);
                    }
                }
                CaptureBinding captureBinding2 = captureBinding;
                return captureBinding2;
            }
            CaptureBinding captureBinding = this;
            return captureBinding;
        }
        finally {
            this.pendingSubstitute = null;
        }
    }

    @Override
    public void setTypeAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        super.setTypeAnnotations(annotationBindingArray, bl);
        if (annotationBindingArray != Binding.NO_ANNOTATIONS && this.wildcard != null) {
            this.wildcard = (WildcardBinding)this.wildcard.environment.createAnnotatedType((TypeBinding)this.wildcard, annotationBindingArray);
        }
    }

    @Override
    public TypeBinding uncapture(Scope scope) {
        return this.wildcard;
    }

    @Override
    protected TypeBinding[] getDerivedTypesForDeferredInitialization() {
        TypeBinding[] typeBindingArray = this.environment.typeSystem.getDerivedTypes(this);
        if (typeBindingArray.length > 0) {
            int n = 0;
            for (int i = 0; i < typeBindingArray.length; ++i) {
                if (typeBindingArray[i] == null || typeBindingArray[i].id != this.id) continue;
                typeBindingArray[n++] = typeBindingArray[i];
            }
            if (n < typeBindingArray.length) {
                TypeBinding[] typeBindingArray2 = typeBindingArray;
                typeBindingArray = new TypeBinding[n];
                System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n);
            }
        }
        return typeBindingArray;
    }

    @Override
    public String toString() {
        if (this.wildcard != null) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(10);
            AnnotationBinding[] annotationBindingArray = this.getTypeAnnotations();
            int n2 = n = annotationBindingArray == null ? 0 : annotationBindingArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(annotationBindingArray[i]);
                stringBuffer.append(' ');
            }
            stringBuffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard);
            return stringBuffer.toString();
        }
        return super.toString();
    }
}

