/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class AllocMemoryResultsSnapshot
extends MemoryResultsSnapshot {
    private static final String MEMORY_ALLOC_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("AllocMemoryResultsSnapshot_MemoryAllocMsg");
    private int[] objectsCounts;

    public AllocMemoryResultsSnapshot() {
    }

    public AllocMemoryResultsSnapshot(long l, long l2, MemoryCCTProvider memoryCCTProvider, ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        super(l, l2, memoryCCTProvider, profilerClient);
    }

    public int[] getObjectsCounts() {
        return this.objectsCounts;
    }

    @Override
    public void performInit(ProfilerClient profilerClient, MemoryCCTProvider memoryCCTProvider) throws ClientUtils.TargetAppOrVMTerminated {
        super.performInit(profilerClient, memoryCCTProvider);
        int[] nArray = profilerClient.getAllocatedObjectsCountResults();
        this.objectsCounts = new int[nArray.length];
        System.arraycopy(nArray, 0, this.objectsCounts, 0, nArray.length);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public AllocMemoryResultsSnapshot createDiff(MemoryResultsSnapshot memoryResultsSnapshot) {
        if (!(memoryResultsSnapshot instanceof AllocMemoryResultsSnapshot)) {
            return null;
        }
        return new AllocMemoryResultsDiff(this, (AllocMemoryResultsSnapshot)memoryResultsSnapshot);
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        super.readFromStream(dataInputStream);
        int n = dataInputStream.readInt();
        this.objectsCounts = new int[n];
        for (int i = 0; i < n; ++i) {
            this.objectsCounts[i] = dataInputStream.readInt();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public String toString() {
        return MessageFormat.format(MEMORY_ALLOC_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeInt(this.objectsCounts.length);
        for (int i = 0; i < this.objectsCounts.length; ++i) {
            dataOutputStream.writeInt(this.objectsCounts[i]);
        }
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode runtimeMemoryCCTNode, int n, boolean bl) {
        return PresoObjAllocCCTNode.createPresentationCCTFromSnapshot(this.getJMethodIdTable(), runtimeMemoryCCTNode, this.getClassName(n));
    }

    @Override
    void debugValues() {
        super.debugValues();
        LOGGER.finest("objectsCounts.length: " + this.debugLength(this.objectsCounts));
    }
}

