/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public final class ProtocolName {
    public static final ProtocolName HTTP_1_1 = ProtocolName.asUtf8Encoding("http/1.1");
    public static final ProtocolName SPDY_1 = ProtocolName.asUtf8Encoding("spdy/1");
    public static final ProtocolName SPDY_2 = ProtocolName.asUtf8Encoding("spdy/2");
    public static final ProtocolName SPDY_3 = ProtocolName.asUtf8Encoding("spdy/3");
    public static final ProtocolName STUN_TURN = ProtocolName.asUtf8Encoding("stun.turn");
    public static final ProtocolName STUN_NAT_DISCOVERY = ProtocolName.asUtf8Encoding("stun.nat-discovery");
    public static final ProtocolName HTTP_2_TLS = ProtocolName.asUtf8Encoding("h2");
    public static final ProtocolName HTTP_2_TCP = ProtocolName.asUtf8Encoding("h2c");
    public static final ProtocolName WEBRTC = ProtocolName.asUtf8Encoding("webrtc");
    public static final ProtocolName WEBRTC_CONFIDENTIAL = ProtocolName.asUtf8Encoding("c-webrtc");
    public static final ProtocolName FTP = ProtocolName.asUtf8Encoding("ftp");
    public static final ProtocolName IMAP = ProtocolName.asUtf8Encoding("imap");
    public static final ProtocolName POP3 = ProtocolName.asUtf8Encoding("pop3");
    public static final ProtocolName MANAGESIEVE = ProtocolName.asUtf8Encoding("managesieve");
    public static final ProtocolName COAP = ProtocolName.asUtf8Encoding("coap");
    public static final ProtocolName XMPP_CLIENT = ProtocolName.asUtf8Encoding("xmpp-client");
    public static final ProtocolName XMPP_SERVER = ProtocolName.asUtf8Encoding("xmpp-server");
    private final byte[] bytes;

    public static final ProtocolName asRawBytes(byte[] byArray) {
        return new ProtocolName(Arrays.clone((byte[])byArray));
    }

    public static final ProtocolName asUtf8Encoding(String string) {
        return new ProtocolName(Strings.toUTF8ByteArray((String)string));
    }

    private ProtocolName(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("'bytes' cannot be null");
        }
        if (byArray.length < 1 || byArray.length > 255) {
            throw new IllegalArgumentException("'bytes' must have length from 1 to 255");
        }
        this.bytes = byArray;
    }

    public byte[] getBytes() {
        return Arrays.clone((byte[])this.bytes);
    }

    public String getUtf8Decoding() {
        return Strings.fromUTF8ByteArray((byte[])this.bytes);
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeOpaque8(this.bytes, outputStream);
    }

    public static ProtocolName parse(InputStream inputStream) throws IOException {
        return new ProtocolName(TlsUtils.readOpaque8(inputStream, 1));
    }

    public boolean equals(Object object) {
        return object instanceof ProtocolName && Arrays.areEqual((byte[])this.bytes, (byte[])((ProtocolName)object).bytes);
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.bytes);
    }
}

