/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class Encoding {
    private static byte[] _base64en;
    private static byte[] _base64de;
    private static final byte B64INV = -128;

    private Encoding() {
    }

    public static String base64encode(byte[] code) {
        byte b1;
        byte b0;
        int spos;
        if (null == code) {
            return null;
        }
        if (0 == code.length) {
            return new String();
        }
        int len = code.length;
        int rem = len % 3;
        byte[] dst = new byte[4 + ((len - 1) / 3 << 2) + len / 57];
        int column = 0;
        int dpos = 0;
        len -= 2;
        for (spos = 0; spos < len; spos += 3) {
            b0 = code[spos];
            b1 = code[spos + 1];
            byte b2 = code[spos + 2];
            dst[dpos++] = _base64en[0x3F & b0 >>> 2];
            dst[dpos++] = _base64en[(0x30 & b0 << 4) + (0xF & b1 >>> 4)];
            dst[dpos++] = _base64en[(0x3C & b1 << 2) + (3 & b2 >>> 6)];
            dst[dpos++] = _base64en[0x3F & b2];
            if (57 != (column += 3)) continue;
            dst[dpos++] = 10;
            column = 0;
        }
        if (0 != rem) {
            b0 = code[spos];
            dst[dpos++] = _base64en[0x3F & b0 >>> 2];
            if (1 == rem) {
                dst[dpos++] = _base64en[0x30 & b0 << 4];
                dst[dpos++] = 61;
            } else {
                b1 = code[spos + 1];
                dst[dpos++] = _base64en[(0x30 & b0 << 4) + (0xF & b1 >>> 4)];
                dst[dpos++] = _base64en[0x3C & b1 << 2];
            }
            dst[dpos++] = 61;
        }
        return new String(dst);
    }

    public static byte[] base64decode(String coded) {
        byte b3;
        byte b2;
        byte b1;
        byte b0;
        if (null == coded) {
            return null;
        }
        byte[] src = coded.getBytes();
        int len = src.length;
        int dlen = len - len / 77;
        dlen = (dlen >>> 2) + (dlen >>> 1);
        int rem = 0;
        if (61 == src[len - 1]) {
            ++rem;
        }
        if (61 == src[len - 2]) {
            ++rem;
        }
        byte[] dst = new byte[dlen -= rem];
        int pos = 0;
        int dpos = 0;
        int col = 0;
        len -= 4;
        while (pos < len) {
            b0 = _base64de[src[pos++]];
            b1 = _base64de[src[pos++]];
            b2 = _base64de[src[pos++]];
            b3 = _base64de[src[pos++]];
            if (-128 == b0 || -128 == b1 || -128 == b2 || -128 == b3) {
                throw new RuntimeException("Invalid character at or around position " + pos);
            }
            dst[dpos++] = (byte)(b0 << 2 | b1 >>> 4 & 3);
            dst[dpos++] = (byte)(b1 << 4 | b2 >>> 2 & 0xF);
            dst[dpos++] = (byte)(b2 << 6 | b3 & 0x3F);
            if (76 != (col += 4)) continue;
            if (10 != src[pos++]) {
                throw new RuntimeException("No linefeed found at position " + (pos - 1));
            }
            col = 0;
        }
        b0 = _base64de[src[pos++]];
        b1 = _base64de[src[pos++]];
        b2 = _base64de[src[pos++]];
        b3 = _base64de[src[pos++]];
        if (-128 == b0 || -128 == b1 || -128 == b2 || -128 == b3) {
            throw new RuntimeException("Invalid character at or around position " + pos);
        }
        dst[dpos++] = (byte)(b0 << 2 | b1 >>> 4 & 3);
        if (2 == rem) {
            return dst;
        }
        dst[dpos++] = (byte)(b1 << 4 | b2 >>> 2 & 0xF);
        if (1 == rem) {
            return dst;
        }
        dst[dpos++] = (byte)(b2 << 6 | b3 & 0x3F);
        return dst;
    }

    public static String toHexString(byte[] b) {
        if (null == b) {
            return null;
        }
        int len = b.length;
        byte[] hex = new byte[len << 1];
        int i = 0;
        int j = 0;
        while (i < len) {
            hex[j] = (byte)((b[i] & 0xF0) >> 4);
            int n = j;
            hex[n] = (byte)(hex[n] + (10 > hex[j] ? 48 : 87));
            hex[j + 1] = (byte)(b[i] & 0xF);
            int n2 = j + 1;
            hex[n2] = (byte)(hex[n2] + (10 > hex[j + 1] ? 48 : 87));
            ++i;
            j += 2;
        }
        return new String(hex);
    }

    public static String hashMD5(String str) {
        return Encoding.hashMD5(str.getBytes());
    }

    public static String hashMD5(byte[] bytes) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return Encoding.toHexString(md.digest());
    }

    public static String hashSHA(String str) {
        byte[] b = str.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
            md.update(b);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return Encoding.toHexString(md.digest());
    }

    public static synchronized String rot13(String input) {
        StringBuffer output = new StringBuffer();
        if (input != null) {
            for (int i = 0; i < input.length(); ++i) {
                char inChar = input.charAt(i);
                if (inChar >= 'A' & inChar <= 'Z' && (inChar = (char)(inChar + 13)) > 'Z') {
                    inChar = (char)(inChar - 26);
                }
                if (inChar >= 'a' & inChar <= 'z' && (inChar = (char)(inChar + 13)) > 'z') {
                    inChar = (char)(inChar - 26);
                }
                output.append(inChar);
            }
        }
        return output.toString();
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, "utf-8");
        }
        catch (Exception e) {
            return "Decoding error";
        }
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (Exception e) {
            return "Encoding error";
        }
    }

    static {
        int i;
        _base64en = new byte[65];
        _base64de = new byte[256];
        Arrays.fill(_base64de, (byte)-128);
        for (i = 0; i < 26; i = (int)((byte)(i + 1))) {
            Encoding._base64en[i] = (byte)(65 + i);
            Encoding._base64en[26 + i] = (byte)(97 + i);
            Encoding._base64de[65 + i] = i;
            Encoding._base64de[97 + i] = (byte)(26 + i);
        }
        for (i = 48; i < 58; i = (int)((byte)(i + 1))) {
            Encoding._base64en[4 + i] = i;
            Encoding._base64de[i] = (byte)(4 + i);
        }
        Encoding._base64en[62] = 43;
        Encoding._base64en[63] = 47;
        Encoding._base64en[64] = 61;
        Encoding._base64de[43] = 62;
        Encoding._base64de[47] = 63;
        Encoding._base64de[61] = 0;
    }
}

