/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantCookie
implements Variant {
    private List<NameValuePair> params = Collections.emptyList();

    @Override
    public void setMessage(HttpMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter message must not be null.");
        }
        Vector<String> cookieLines = message.getRequestHeader().getHeaders("Cookie");
        if (cookieLines == null) {
            this.params = Collections.emptyList();
            return;
        }
        ArrayList<NameValuePair> extractedParameters = new ArrayList<NameValuePair>();
        for (String cookieLine : cookieLines) {
            String[] cookieArray;
            if (cookieLine.trim().isEmpty()) continue;
            for (String cookie : cookieArray = cookieLine.split("; ?")) {
                String[] nameValuePair = cookie.split("=", 2);
                String name = nameValuePair[0];
                String value = null;
                if (nameValuePair.length == 2) {
                    value = this.getUnescapedValue(nameValuePair[1]);
                }
                extractedParameters.add(new NameValuePair(4, name, value, extractedParameters.size()));
            }
        }
        if (extractedParameters.isEmpty()) {
            this.params = Collections.emptyList();
        } else {
            extractedParameters.trimToSize();
            this.params = Collections.unmodifiableList(extractedParameters);
        }
    }

    private static String getEscapedValue(String value) {
        return AbstractPlugin.getURLEncode(value);
    }

    private String getUnescapedValue(String value) {
        return AbstractPlugin.getURLDecode(value);
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, true);
    }

    private String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value, boolean escaped) {
        String escapedValue = value == null ? null : (escaped ? value : VariantCookie.getEscapedValue(value));
        StringBuilder cookieString = new StringBuilder();
        for (int idx = 0; idx < this.params.size(); ++idx) {
            String cookieName = null;
            String cookieValue = null;
            if (idx == originalPair.getPosition()) {
                if (name != null || escapedValue != null) {
                    cookieName = name;
                    if (escapedValue != null) {
                        cookieValue = escapedValue;
                    }
                }
            } else {
                NameValuePair param = this.params.get(idx);
                cookieName = param.getName();
                cookieValue = param.getValue();
                if (cookieValue != null) {
                    cookieValue = VariantCookie.getEscapedValue(cookieValue);
                }
            }
            if (cookieString.length() != 0 && (cookieName != null || cookieValue != null)) {
                cookieString.append("; ");
            }
            if (cookieName != null) {
                cookieString.append(cookieName);
            }
            if (cookieValue == null) continue;
            cookieString.append('=');
            cookieString.append(cookieValue);
        }
        msg.getRequestHeader().setHeader("Cookie", null);
        if (cookieString.length() != 0) {
            msg.getRequestHeader().setHeader("Cookie", cookieString.toString());
        }
        if (escapedValue == null) {
            return name;
        }
        if (name == null) {
            return "=" + escapedValue;
        }
        return name + "=" + escapedValue;
    }
}

