if not modules then modules = { } end modules ['char-def'] = {
    version   = 1.001,
    comment   = "companion to char-ini.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "PRAGMA ADE / ConTeXt Development Team",
    license   = "see context related readme files",
    dataonly  = true,
}

--[[
The first version of this table was generated from unicode tables but after that was
mostly updated manual using data present in ConTeXt and elsewhere. I did my best to
make this table as complete as needed for proper use in ConTeXt MkIV. All errors are
mine. If you find an error or ommision, just let me know.  This file is updated every
now and then using mtx-unicode where we check against the latest unicode txt files
(normally once per year around the tex live code freeze) and checked afterwards for
differences. We could save some bytes by sharing variant tables but it's not worth
the trouble. Some additional data is kept in other files.

For a generic subset of the data here, run "context luatex-basics-prepare.tex" after
adapting this file.
]]--

local variants_emoji={
  [0xFE0E]="text style",
  [0xFE0F]="emoji style",
}

characters = characters or { }

characters.data={
 [0x0]={
  category="cc",
  description="NULL",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0,
 },
 {
  adobename="controlSTX",
  category="cc",
  description="START OF HEADING",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x1,
 },
 {
  adobename="controlSOT",
  category="cc",
  description="START OF TEXT",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x2,
 },
 {
  adobename="controlETX",
  category="cc",
  description="END OF TEXT",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x3,
 },
 {
  adobename="controlEOT",
  category="cc",
  description="END OF TRANSMISSION",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x4,
 },
 {
  adobename="controlENQ",
  category="cc",
  description="ENQUIRY",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x5,
 },
 {
  adobename="controlACK",
  category="cc",
  description="ACKNOWLEDGE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x6,
 },
 {
  adobename="controlBEL",
  category="cc",
  description="BELL",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x7,
 },
 {
  adobename="controlBS",
  category="cc",
  description="BACKSPACE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x8,
 },
 {
  adobename="controlHT",
  category="cc",
  description="CHARACTER TABULATION",
  direction="s",
  linebreak="ba",
  synonyms={ "horizontal tabulation", "ht", "tab" },
  unicodeslot=0x9,
 },
 {
  adobename="controlLF",
  category="cc",
  description="LINE FEED (LF)",
  direction="b",
  linebreak="lf",
  synonyms={ "end of line", "eol", "lf", "new line", "nl" },
  unicodeslot=0xA,
 },
 {
  adobename="controlVT",
  category="cc",
  description="LINE TABULATION",
  direction="s",
  linebreak="bk",
  synonyms={ "vertical tabulation", "vt" },
  unicodeslot=0xB,
 },
 {
  adobename="controlFF",
  category="cc",
  description="FORM FEED (FF)",
  direction="ws",
  linebreak="bk",
  synonyms={ "ff" },
  unicodeslot=0xC,
 },
 {
  adobename="controlCR",
  category="cc",
  description="CARRIAGE RETURN (CR)",
  direction="b",
  linebreak="cr",
  synonyms={ "cr" },
  unicodeslot=0xD,
 },
 {
  adobename="controlSO",
  category="cc",
  description="SHIFT OUT",
  direction="bn",
  linebreak="cm",
  unicodeslot=0xE,
 },
 {
  adobename="controlSI",
  category="cc",
  description="SHIFT IN",
  direction="bn",
  linebreak="cm",
  unicodeslot=0xF,
 },
 {
  adobename="controlDLE",
  category="cc",
  description="DATA LINK ESCAPE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x10,
 },
 {
  adobename="controlDC1",
  category="cc",
  description="DEVICE CONTROL ONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x11,
 },
 {
  adobename="controlDC2",
  category="cc",
  description="DEVICE CONTROL TWO",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x12,
 },
 {
  adobename="controlDC3",
  category="cc",
  description="DEVICE CONTROL THREE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x13,
 },
 {
  adobename="controlDC4",
  category="cc",
  description="DEVICE CONTROL FOUR",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x14,
 },
 {
  adobename="controlNAK",
  category="cc",
  description="NEGATIVE ACKNOWLEDGE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x15,
 },
 {
  adobename="controlSYN",
  category="cc",
  description="SYNCHRONOUS IDLE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x16,
 },
 {
  adobename="controlETB",
  category="cc",
  description="END OF TRANSMISSION BLOCK",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x17,
 },
 {
  adobename="controlCAN",
  category="cc",
  description="CANCEL",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x18,
 },
 {
  adobename="controlEM",
  category="cc",
  description="END OF MEDIUM",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x19,
 },
 {
  adobename="controlSUB",
  category="cc",
  description="SUBSTITUTE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x1A,
 },
 {
  adobename="controlESC",
  category="cc",
  description="ESCAPE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x1B,
 },
 {
  adobename="controlFS",
  category="cc",
  description="INFORMATION SEPARATOR FOUR",
  direction="b",
  linebreak="cm",
  synonyms={ "file separator" },
  unicodeslot=0x1C,
 },
 {
  adobename="controlGS",
  category="cc",
  description="INFORMATION SEPARATOR THREE",
  direction="b",
  linebreak="cm",
  synonyms={ "group separator" },
  unicodeslot=0x1D,
 },
 {
  adobename="controlRS",
  category="cc",
  description="INFORMATION SEPARATOR TWO",
  direction="b",
  linebreak="cm",
  synonyms={ "record separator" },
  unicodeslot=0x1E,
 },
 {
  adobename="controlUS",
  category="cc",
  description="INFORMATION SEPARATOR ONE",
  direction="s",
  linebreak="cm",
  synonyms={ "unit separator" },
  unicodeslot=0x1F,
 },
 {
  adobename="space",
  category="zs",
  cjkwd="na",
  description="SPACE",
  direction="ws",
  linebreak="sp",
  unicodeslot=0x20,
 },
 {
  adobename="exclam",
  category="po",
  cjkwd="na",
  description="EXCLAMATION MARK",
  direction="on",
  linebreak="ex",
  mathclass="close",
  synonyms={ "bang", "factorial" },
  unicodeslot=0x21,
 },
 {
  adobename="quotedbl",
  category="po",
  cjkwd="na",
  contextname="quotedbl",
  description="QUOTATION MARK",
  direction="on",
  linebreak="qu",
  mathclass="default",
  synonyms={ "neutral quotation mark" },
  unicodeslot=0x22,
 },
 {
  adobename="numbersign",
  category="po",
  cjkwd="na",
  contextname="texthash",
  description="NUMBER SIGN",
  direction="et",
  linebreak="al",
  mathclass="binary",
  mathname="mathhash",
  synonyms={ "crosshatch", "hash", "octothorpe", "pound sign" },
  unicodeslot=0x23,
  variants=variants_emoji,
 },
 {
  adobename="dollar",
  category="sc",
  cjkwd="na",
  contextname="textdollar",
  description="DOLLAR SIGN",
  direction="et",
  linebreak="pr",
  mathclass="binary",
  mathname="mathdollar",
  synonyms={ "escudo", "milreis" },
  unicodeslot=0x24,
 },
 {
  adobename="percent",
  category="po",
  cjkwd="na",
  contextname="textpercent",
  description="PERCENT SIGN",
  direction="et",
  linebreak="po",
  mathclass="binary",
  mathname="mathpercent",
  unicodeslot=0x25,
 },
 {
  adobename="ampersand",
  category="po",
  cjkwd="na",
  contextname="textampersand",
  description="AMPERSAND",
  direction="on",
  linebreak="al",
  mathclass="binary",
  mathname="mathampersand",
  unicodeslot=0x26,
 },
 {
  adobename="quotesingle",
  category="po",
  cjkwd="na",
  contextname="quotesingle",
  description="APOSTROPHE",
  direction="on",
  linebreak="qu",
  mathclass="default",
  synonyms={ "apl quote", "apostrophe-quote", "neutral single quotation mark" },
  unicodeslot=0x27,
 },
 {
  adobename="parenleft",
  category="ps",
  cjkwd="na",
  description="LEFT PARENTHESIS",
  direction="on",
  linebreak="op",
  mathclass="open",
  mathname="lparent",
  mirror=0x29,
  synonyms={ "opening parenthesis" },
  textclass="open",
  unicodeslot=0x28,
 },
 {
  adobename="parenright",
  category="pe",
  cjkwd="na",
  description="RIGHT PARENTHESIS",
  direction="on",
  linebreak="cp",
  mathclass="close",
  mathname="rparent",
  mirror=0x28,
  synonyms={ "closing parenthesis" },
  textclass="close",
  unicodeslot=0x29,
 },
 {
  adobename="asterisk",
  category="po",
  cjkwd="na",
  description="ASTERISK",
  direction="on",
  linebreak="al",
  mathclass="binary",
  mathname="ast",
  mathsymbol=0x2217,
  synonyms={ "star" },
  unicodeslot=0x2A,
  variants=variants_emoji,
 },
 {
  adobename="plus",
  category="sm",
  cjkwd="na",
  description="PLUS SIGN",
  direction="es",
  linebreak="pr",
  mathclass="binary",
  unicodeslot=0x2B,
 },
 {
  adobename="comma",
  category="po",
  cjkwd="na",
  contextname="textcomma",
  description="COMMA",
  direction="cs",
  linebreak="is",
  mathclass="punctuation",
  synonyms={ "decimal separator" },
  unicodeslot=0x2C,
 },
 {
  adobename="hyphen",
  category="pd",
  cjkwd="na",
  contextname="texthyphen",
  description="HYPHEN-MINUS",
  direction="es",
  linebreak="hy",
  mathclass="nothing",
  mathextensible="h",
  mathfiller="relfill",
  mathname="mathhyphen",
  mathsymbol=0x2212,
  synonyms={ "hyphen or minus sign", "hyphus" },
  unicodeslot=0x2D,
 },
 {
  adobename="period",
  category="po",
  cjkwd="na",
  comment="class needed for autopunctuation",
  contextname="textperiod",
  description="FULL STOP",
  direction="cs",
  linebreak="is",
  mathclass="punctuation",
  mathname="ldotp",
  synonyms={ "decimal point", "dot", "period" },
  unicodeslot=0x2E,
 },
 {
  adobename="slash",
  category="po",
  cjkwd="na",
  contextname="textslash",
  description="SOLIDUS",
  direction="cs",
  linebreak="sy",
  mathclass="middle",
  synonyms={ "slash", "virgule" },
  unicodeslot=0x2F,
 },
 {
  adobename="zero",
  category="nd",
  cjkwd="na",
  description="DIGIT ZERO",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x30,
  variants={
   [0xFE00]="short diagonal stroke form",
   [0xFE0E]="text style",
   [0xFE0F]="emoji style",
  },
 },
 {
  adobename="one",
  category="nd",
  cjkwd="na",
  description="DIGIT ONE",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x31,
  variants=variants_emoji,
 },
 {
  adobename="two",
  category="nd",
  cjkwd="na",
  description="DIGIT TWO",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x32,
  variants=variants_emoji,
 },
 {
  adobename="three",
  category="nd",
  cjkwd="na",
  description="DIGIT THREE",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x33,
  variants=variants_emoji,
 },
 {
  adobename="four",
  category="nd",
  cjkwd="na",
  description="DIGIT FOUR",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x34,
  variants=variants_emoji,
 },
 {
  adobename="five",
  category="nd",
  cjkwd="na",
  description="DIGIT FIVE",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x35,
  variants=variants_emoji,
 },
 {
  adobename="six",
  category="nd",
  cjkwd="na",
  description="DIGIT SIX",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x36,
  variants=variants_emoji,
 },
 {
  adobename="seven",
  category="nd",
  cjkwd="na",
  description="DIGIT SEVEN",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x37,
  variants=variants_emoji,
 },
 {
  adobename="eight",
  category="nd",
  cjkwd="na",
  description="DIGIT EIGHT",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x38,
  variants=variants_emoji,
 },
 {
  adobename="nine",
  category="nd",
  cjkwd="na",
  description="DIGIT NINE",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x39,
  variants=variants_emoji,
 },
 {
  adobename="colon",
  category="po",
  cjkwd="na",
  comment="mathclass=punctuation,mathname=colon,mathsymbol=0x2236",
  description="COLON",
  direction="cs",
  linebreak="is",
  mathclass="relation",
  unicodeslot=0x3A,
 },
 {
  adobename="semicolon",
  category="po",
  cjkwd="na",
  description="SEMICOLON",
  direction="on",
  linebreak="is",
  mathclass="punctuation",
  synonyms={ "greek question mark" },
  unicodeslot=0x3B,
 },
 {
  adobename="less",
  category="sm",
  cjkwd="na",
  description="LESS-THAN SIGN",
  direction="on",
  linebreak="al",
  mathclass="relation",
  mathname="lt",
  mirror=0x3E,
  textclass="open",
  unicodeslot=0x3C,
 },
 {
  adobename="equal",
  category="sm",
  cjkwd="na",
  comment="mathclass=binary",
  description="EQUALS SIGN",
  direction="on",
  linebreak="al",
  mathextensible="h",
  mathfiller="equalfill",
  mathspec={
   {
    class="relation",
    name="eq",
   },
   {
    class="relation",
    name="Relbar",
   },
  },
  unicodeslot=0x3D,
 },
 {
  adobename="greater",
  category="sm",
  cjkwd="na",
  description="GREATER-THAN SIGN",
  direction="on",
  linebreak="al",
  mathclass="relation",
  mathname="gt",
  mirror=0x3C,
  textclass="close",
  unicodeslot=0x3E,
 },
 {
  adobename="question",
  category="po",
  cjkwd="na",
  description="QUESTION MARK",
  direction="on",
  linebreak="ex",
  mathclass="close",
  unicodeslot=0x3F,
 },
 {
  adobename="at",
  category="po",
  cjkwd="na",
  contextname="textat",
  description="COMMERCIAL AT",
  direction="on",
  linebreak="al",
  synonyms={ "at sign" },
  unicodeslot=0x40,
 },
 {
  adobename="A",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER A",
  direction="l",
  lccode=0x61,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x41,
 },
 {
  adobename="B",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER B",
  direction="l",
  lccode=0x62,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x42,
 },
 {
  adobename="C",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER C",
  direction="l",
  lccode=0x63,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x43,
 },
 {
  adobename="D",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER D",
  direction="l",
  lccode=0x64,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x44,
 },
 {
  adobename="E",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER E",
  direction="l",
  lccode=0x65,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x45,
 },
 {
  adobename="F",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER F",
  direction="l",
  lccode=0x66,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x46,
 },
 {
  adobename="G",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER G",
  direction="l",
  lccode=0x67,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x47,
 },
 {
  adobename="H",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER H",
  direction="l",
  lccode=0x68,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x48,
 },
 {
  adobename="I",
  category="lu",
  cjkwd="na",
  contextname="dotlessI",
  description="LATIN CAPITAL LETTER I",
  direction="l",
  lccode=0x69,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x49,
 },
 {
  adobename="J",
  category="lu",
  cjkwd="na",
  contextname="dotlessJ",
  description="LATIN CAPITAL LETTER J",
  direction="l",
  lccode=0x6A,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x4A,
 },
 {
  adobename="K",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER K",
  direction="l",
  lccode=0x6B,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x4B,
 },
 {
  adobename="L",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER L",
  direction="l",
  lccode=0x6C,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x4C,
 },
 {
  adobename="M",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER M",
  direction="l",
  lccode=0x6D,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x4D,
 },
 {
  adobename="N",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER N",
  direction="l",
  lccode=0x6E,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x4E,
 },
 {
  adobename="O",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER O",
  direction="l",
  lccode=0x6F,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x4F,
 },
 {
  adobename="P",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER P",
  direction="l",
  lccode=0x70,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x50,
 },
 {
  adobename="Q",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER Q",
  direction="l",
  lccode=0x71,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x51,
 },
 {
  adobename="R",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER R",
  direction="l",
  lccode=0x72,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x52,
 },
 {
  adobename="S",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER S",
  direction="l",
  lccode=0x73,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x53,
 },
 {
  adobename="T",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER T",
  direction="l",
  lccode=0x74,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x54,
 },
 {
  adobename="U",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER U",
  direction="l",
  lccode=0x75,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x55,
 },
 {
  adobename="V",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER V",
  direction="l",
  lccode=0x76,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x56,
 },
 {
  adobename="W",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER W",
  direction="l",
  lccode=0x77,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x57,
 },
 {
  adobename="X",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER X",
  direction="l",
  lccode=0x78,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x58,
 },
 {
  adobename="Y",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER Y",
  direction="l",
  lccode=0x79,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x59,
 },
 {
  adobename="Z",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER Z",
  direction="l",
  lccode=0x7A,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x5A,
 },
 {
  adobename="bracketleft",
  category="ps",
  cjkwd="na",
  description="LEFT SQUARE BRACKET",
  direction="on",
  linebreak="op",
  mathclass="open",
  mathname="lbracket",
  mirror=0x5D,
  synonyms={ "opening square bracket" },
  textclass="open",
  unicodeslot=0x5B,
 },
 {
  adobename="backslash",
  category="po",
  cjkwd="na",
  contextname="textbackslash",
  description="REVERSE SOLIDUS",
  direction="on",
  linebreak="pr",
  mathclass="nothing",
  mathname="backslash",
  synonyms={ "backslash" },
  unicodeslot=0x5C,
 },
 {
  adobename="bracketright",
  category="pe",
  cjkwd="na",
  description="RIGHT SQUARE BRACKET",
  direction="on",
  linebreak="cp",
  mathclass="close",
  mathname="rbracket",
  mirror=0x5B,
  synonyms={ "closing square bracket" },
  textclass="close",
  unicodeslot=0x5D,
 },
 {
  adobename="asciicircum",
  category="sk",
  cjkwd="na",
  contextname="textasciicircum",
  description="CIRCUMFLEX ACCENT",
  direction="on",
  linebreak="al",
  mathclass="topaccent",
  mathname="Hat",
  synonyms={ "spacing circumflex accent" },
  unicodeslot=0x5E,
 },
 {
  adobename="underscore",
  category="pc",
  cjkwd="na",
  contextname="textunderscore",
  description="LOW LINE",
  direction="on",
  linebreak="al",
  synonyms={ "spacing underscore" },
  unicodeslot=0x5F,
 },
 {
  adobename="grave",
  category="sk",
  cjkwd="na",
  contextname="textgrave",
  description="GRAVE ACCENT",
  direction="on",
  linebreak="al",
  mathclass="topaccent",
  mathname="grave",
  synonyms={ "spacing grave accent" },
  unicodeslot=0x60,
 },
 {
  adobename="a",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER A",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x41,
  unicodeslot=0x61,
 },
 {
  adobename="b",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER B",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x42,
  unicodeslot=0x62,
 },
 {
  adobename="c",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER C",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x43,
  unicodeslot=0x63,
 },
 {
  adobename="d",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER D",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x44,
  unicodeslot=0x64,
 },
 {
  adobename="e",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER E",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x45,
  unicodeslot=0x65,
 },
 {
  adobename="f",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER F",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x46,
  unicodeslot=0x66,
 },
 {
  adobename="g",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER G",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x47,
  unicodeslot=0x67,
 },
 {
  adobename="h",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER H",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x48,
  unicodeslot=0x68,
 },
 {
  adobename="i",
  category="ll",
  cjkwd="na",
  contextname="idotaccent",
  description="LATIN SMALL LETTER I",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x49,
  unicodeslot=0x69,
 },
 {
  adobename="j",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER J",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x4A,
  unicodeslot=0x6A,
 },
 {
  adobename="k",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER K",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x4B,
  unicodeslot=0x6B,
 },
 {
  adobename="l",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER L",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x4C,
  unicodeslot=0x6C,
 },
 {
  adobename="m",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER M",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x4D,
  unicodeslot=0x6D,
 },
 {
  adobename="n",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER N",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x4E,
  unicodeslot=0x6E,
 },
 {
  adobename="o",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER O",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x4F,
  unicodeslot=0x6F,
 },
 {
  adobename="p",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER P",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x50,
  unicodeslot=0x70,
 },
 {
  adobename="q",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER Q",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x51,
  unicodeslot=0x71,
 },
 {
  adobename="r",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER R",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x52,
  unicodeslot=0x72,
 },
 {
  adobename="s",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER S",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x53,
  unicodeslot=0x73,
 },
 {
  adobename="t",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER T",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x54,
  unicodeslot=0x74,
 },
 {
  adobename="u",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER U",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x55,
  unicodeslot=0x75,
 },
 {
  adobename="v",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER V",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x56,
  unicodeslot=0x76,
 },
 {
  adobename="w",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER W",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x57,
  unicodeslot=0x77,
 },
 {
  adobename="x",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER X",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x58,
  unicodeslot=0x78,
 },
 {
  adobename="y",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER Y",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x59,
  unicodeslot=0x79,
 },
 {
  adobename="z",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER Z",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x5A,
  unicodeslot=0x7A,
 },
 {
  adobename="braceleft",
  category="ps",
  cjkwd="na",
  contextname="textbraceleft",
  description="LEFT CURLY BRACKET",
  direction="on",
  linebreak="op",
  mathclass="open",
  mathname="lbrace",
  mirror=0x7D,
  synonyms={ "opening brace", "opening curly bracket" },
  textclass="open",
  unicodeslot=0x7B,
 },
 {
  adobename="verticalbar",
  category="sm",
  cjkwd="na",
  comment="mathclass=binary,mathname=bar",
  contextname="textbar",
  description="VERTICAL LINE",
  direction="on",
  linebreak="ba",
  mathspec={
   {
    class="nothing",
    name="arrowvert",
   },
   {
    class="delimiter",
    name="vert",
   },
   {
    class="open",
    name="lvert",
   },
   {
    class="close",
    name="rvert",
   },
   {
    class="relation",
    name="mid",
   },
   {
    class="delimiter",
    name="singleverticalbar",
   },
  },
  synonyms={ "absolute value", "vertical bar" },
  unicodeslot=0x7C,
 },
 {
  adobename="braceright",
  category="pe",
  cjkwd="na",
  contextname="textbraceright",
  description="RIGHT CURLY BRACKET",
  direction="on",
  linebreak="cl",
  mathclass="close",
  mathname="rbrace",
  mirror=0x7B,
  synonyms={ "closing brace", "closing curly bracket" },
  textclass="close",
  unicodeslot=0x7D,
 },
 {
  adobename="asciitilde",
  category="sm",
  cjkwd="na",
  contextname="textasciitilde",
  description="TILDE",
  direction="on",
  linebreak="al",
  synonyms={ "spacing tilde" },
  unicodeslot=0x7E,
 },
 {
  adobename="controlDEL",
  category="cc",
  description="DELETE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x7F,
 },
 {
  category="cc",
  description="NONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x80,
 },
 {
  category="cc",
  description="NONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x81,
 },
 {
  category="cc",
  description="BREAK PERMITTED HERE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x82,
 },
 {
  category="cc",
  description="NO BREAK HERE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x83,
 },
 {
  category="cc",
  description="NONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x84,
 },
 {
  category="cc",
  description="NEXT LINE (NEL)",
  direction="b",
  linebreak="nl",
  synonyms={ "nel" },
  unicodeslot=0x85,
 },
 {
  category="cc",
  description="START OF SELECTED AREA",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x86,
 },
 {
  category="cc",
  description="END OF SELECTED AREA",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x87,
 },
 {
  category="cc",
  description="CHARACTER TABULATION SET",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x88,
 },
 {
  category="cc",
  description="CHARACTER TABULATION WITH JUSTIFICATION",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x89,
 },
 {
  category="cc",
  description="LINE TABULATION SET",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x8A,
 },
 {
  category="cc",
  description="PARTIAL LINE FORWARD",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x8B,
 },
 {
  category="cc",
  description="PARTIAL LINE BACKWARD",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x8C,
 },
 {
  category="cc",
  description="REVERSE LINE FEED",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x8D,
 },
 {
  category="cc",
  description="SINGLE SHIFT TWO",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x8E,
 },
 {
  category="cc",
  description="SINGLE SHIFT THREE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x8F,
 },
 {
  category="cc",
  description="DEVICE CONTROL STRING",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x90,
 },
 {
  category="cc",
  description="PRIVATE USE ONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x91,
 },
 {
  category="cc",
  description="PRIVATE USE TWO",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x92,
 },
 {
  category="cc",
  description="SET TRANSMIT STATE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x93,
 },
 {
  category="cc",
  description="CANCEL CHARACTER",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x94,
 },
 {
  category="cc",
  description="MESSAGE WAITING",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x95,
 },
 {
  category="cc",
  description="START OF GUARDED AREA",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x96,
 },
 {
  category="cc",
  description="END OF GUARDED AREA",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x97,
 },
 {
  category="cc",
  description="START OF STRING",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x98,
 },
 {
  category="cc",
  description="NONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x99,
 },
 {
  category="cc",
  description="SINGLE CHARACTER INTRODUCER",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x9A,
 },
 {
  category="cc",
  description="CONTROL SEQUENCE INTRODUCER",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x9B,
 },
 {
  category="cc",
  description="STRING TERMINATOR",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x9C,
 },
 {
  category="cc",
  description="OPERATING SYSTEM COMMAND",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x9D,
 },
 {
  category="cc",
  description="PRIVACY MESSAGE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x9E,
 },
 {
  category="cc",
  description="APPLICATION PROGRAM COMMAND",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x9F,
 },
 {
  adobename="nonbreakingspace",
  category="zs",
  contextname="nobreakspace",
  description="NO-BREAK SPACE",
  direction="cs",
  linebreak="gl",
  specials={ "nobreak", 0x20 },
  synonyms={ "nbsp", "non-breaking space" },
  unicodeslot=0xA0,
 },
 {
  adobename="exclamdown",
  category="po",
  cjkwd="a",
  contextname="exclamdown",
  description="INVERTED EXCLAMATION MARK",
  direction="on",
  linebreak="op",
  unicodeslot=0xA1,
 },
 {
  adobename="cent",
  category="sc",
  cjkwd="na",
  contextname="textcent",
  description="CENT SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0xA2,
 },
 {
  adobename="sterling",
  category="sc",
  cjkwd="na",
  contextname="textsterling",
  description="POUND SIGN",
  direction="et",
  linebreak="pr",
  synonyms={ "irish punt", "italian lira", "pound sterling" },
  unicodeslot=0xA3,
 },
 {
  adobename="currency",
  category="sc",
  cjkwd="a",
  contextname="textcurrency",
  description="CURRENCY SIGN",
  direction="et",
  linebreak="pr",
  unicodeslot=0xA4,
 },
 {
  adobename="yen",
  category="sc",
  cjkwd="na",
  contextname="textyen",
  description="YEN SIGN",
  direction="et",
  linebreak="pr",
  mathclass="nothing",
  mathname="yen",
  synonyms={ "yuan sign" },
  unicodeslot=0xA5,
 },
 {
  adobename="brokenbar",
  category="so",
  cjkwd="na",
  contextname="textbrokenbar",
  description="BROKEN BAR",
  direction="on",
  linebreak="al",
  synonyms={ "broken vertical bar", "parted rule" },
  unicodeslot=0xA6,
 },
 {
  adobename="section",
  category="so",
  cjkwd="a",
  contextname="sectionmark",
  description="SECTION SIGN",
  direction="on",
  linebreak="ai",
  mathclass="box",
  mathname="S",
  synonyms={ "european paragraph sign" },
  unicodeslot=0xA7,
 },
 {
  adobename="dieresis",
  category="sk",
  cjkwd="a",
  contextname="textdiaeresis",
  description="DIAERESIS",
  direction="on",
  linebreak="ai",
  mathclass="topaccent",
  mathname="ddot",
  specials={ "compat", 0x20, 0x308 },
  synonyms={ "spacing diaeresis" },
  unicodeslot=0xA8,
 },
 {
  adobename="copyright",
  category="so",
  contextname="copyright",
  description="COPYRIGHT SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0xA9,
  variants=variants_emoji,
 },
 {
  adobename="ordfeminine",
  category="ll",
  cjkwd="a",
  contextname="ordfeminine",
  description="FEMININE ORDINAL INDICATOR",
  direction="l",
  linebreak="ai",
  specials={ "super", 0x61 },
  unicodeslot=0xAA,
 },
 {
  adobename="guillemotleft",
  category="pi",
  contextname="leftguillemot",
  description="LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",
  direction="on",
  linebreak="qu",
  mirror=0xBB,
  synonyms={ "chevrons", "left pointing guillemet" },
  textclass="open",
  unicodeslot=0xAB,
 },
 {
  adobename="logicalnot",
  category="sm",
  cjkwd="na",
  contextname="textlognot",
  description="NOT SIGN",
  direction="on",
  linebreak="al",
  mathspec={
   {
    class="ordinary",
    name="lnot",
   },
   {
    class="ordinary",
    name="neg",
   },
  },
  synonyms={ "angled dash" },
  unicodeslot=0xAC,
 },
 {
  adobename="softhyphen",
  category="cf",
  cjkwd="a",
  contextname="softhyphen",
  description="SOFT HYPHEN",
  direction="bn",
  linebreak="ba",
  synonyms={ "discretionary hyphen", "shy" },
  unicodeslot=0xAD,
 },
 {
  adobename="registered",
  category="so",
  cjkwd="a",
  contextname="registered",
  description="REGISTERED SIGN",
  direction="on",
  linebreak="al",
  synonyms={ "registered trade mark sign" },
  unicodeslot=0xAE,
  variants=variants_emoji,
 },
 {
  adobename="macron",
  category="sk",
  cjkwd="na",
  contextname="textmacron",
  description="MACRON",
  direction="on",
  linebreak="al",
  mathclass="topaccent",
  mathfiller="barfill",
  mathmleq=0x203E,
  mathname="bar",
  specials={ "compat", 0x20, 0x304 },
  synonyms={ "apl overbar", "overline", "spacing macron" },
  unicodeslot=0xAF,
 },
 {
  adobename="degree",
  category="so",
  cjkwd="a",
  contextname="textdegree",
  description="DEGREE SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0xB0,
 },
 {
  adobename="plusminus",
  category="sm",
  cjkwd="a",
  contextname="textpm",
  description="PLUS-MINUS SIGN",
  direction="et",
  linebreak="pr",
  mathclass="binary",
  mathname="pm",
  unicodeslot=0xB1,
 },
 {
  adobename="twosuperior",
  category="no",
  cjkwd="a",
  contextname="twosuperior",
  description="SUPERSCRIPT TWO",
  direction="en",
  linebreak="ai",
  specials={ "super", 0x32 },
  synonyms={ "squared" },
  unicodeslot=0xB2,
 },
 {
  adobename="threesuperior",
  category="no",
  cjkwd="a",
  contextname="threesuperior",
  description="SUPERSCRIPT THREE",
  direction="en",
  linebreak="ai",
  specials={ "super", 0x33 },
  synonyms={ "cubed" },
  unicodeslot=0xB3,
 },
 {
  adobename="acute",
  category="sk",
  cjkwd="a",
  contextname="textacute",
  description="ACUTE ACCENT",
  direction="on",
  linebreak="bb",
  mathclass="topaccent",
  mathname="acute",
  specials={ "compat", 0x20, 0x301 },
  synonyms={ "spacing acute accent" },
  unicodeslot=0xB4,
 },
 {
  adobename="mu1",
  category="ll",
  contextname="textmu",
  description="MICRO SIGN",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x3BC },
  uccode=0x39C,
  unicodeslot=0xB5,
 },
 {
  adobename="paragraph",
  category="so",
  cjkwd="a",
  contextname="paragraphmark",
  description="PILCROW SIGN",
  direction="on",
  linebreak="ai",
  mathclass="box",
  mathname="P",
  synonyms={ "european section sign", "paragraph sign" },
  unicodeslot=0xB6,
 },
 {
  adobename="periodcentered",
  category="po",
  cjkwd="a",
  contextname="periodcentered",
  description="MIDDLE DOT",
  direction="on",
  linebreak="ai",
  mathclass="binary",
  mathname="centerdot",
  synonyms={ "georgian comma", "greek ano teleia", "greek middle dot", "midpoint" },
  unicodeslot=0xB7,
 },
 {
  adobename="cedilla",
  category="sk",
  cjkwd="a",
  contextname="textcedilla",
  description="CEDILLA",
  direction="on",
  linebreak="ai",
  specials={ "compat", 0x20, 0x327 },
  synonyms={ "spacing cedilla" },
  unicodeslot=0xB8,
 },
 {
  adobename="onesuperior",
  category="no",
  cjkwd="a",
  contextname="onesuperior",
  description="SUPERSCRIPT ONE",
  direction="en",
  linebreak="ai",
  specials={ "super", 0x31 },
  unicodeslot=0xB9,
 },
 {
  adobename="ordmasculine",
  category="ll",
  cjkwd="a",
  contextname="ordmasculine",
  description="MASCULINE ORDINAL INDICATOR",
  direction="l",
  linebreak="ai",
  specials={ "super", 0x6F },
  unicodeslot=0xBA,
 },
 {
  adobename="guillemotright",
  category="pf",
  contextname="rightguillemot",
  description="RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK",
  direction="on",
  linebreak="qu",
  mirror=0xAB,
  synonyms={ "right pointing guillemet" },
  textclass="close",
  unicodeslot=0xBB,
 },
 {
  adobename="onequarter",
  category="no",
  cjkwd="a",
  contextname="onequarter",
  description="VULGAR FRACTION ONE QUARTER",
  direction="on",
  linebreak="ai",
  specials={ "fraction", 0x31, 0x2044, 0x34 },
  unicodeslot=0xBC,
 },
 {
  adobename="onehalf",
  category="no",
  cjkwd="a",
  contextname="onehalf",
  description="VULGAR FRACTION ONE HALF",
  direction="on",
  linebreak="ai",
  specials={ "fraction", 0x31, 0x2044, 0x32 },
  unicodeslot=0xBD,
 },
 {
  adobename="threequarters",
  category="no",
  cjkwd="a",
  contextname="threequarter",
  description="VULGAR FRACTION THREE QUARTERS",
  direction="on",
  linebreak="ai",
  specials={ "fraction", 0x33, 0x2044, 0x34 },
  unicodeslot=0xBE,
 },
 {
  adobename="questiondown",
  category="po",
  cjkwd="a",
  contextname="questiondown",
  description="INVERTED QUESTION MARK",
  direction="on",
  linebreak="op",
  synonyms={ "turned question mark" },
  unicodeslot=0xBF,
 },
 {
  adobename="Agrave",
  category="lu",
  contextname="Agrave",
  description="LATIN CAPITAL LETTER A WITH GRAVE",
  direction="l",
  lccode=0xE0,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x300 },
  unicodeslot=0xC0,
 },
 {
  adobename="Aacute",
  category="lu",
  contextname="Aacute",
  description="LATIN CAPITAL LETTER A WITH ACUTE",
  direction="l",
  lccode=0xE1,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x301 },
  unicodeslot=0xC1,
 },
 {
  adobename="Acircumflex",
  category="lu",
  contextname="Acircumflex",
  description="LATIN CAPITAL LETTER A WITH CIRCUMFLEX",
  direction="l",
  lccode=0xE2,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x302 },
  unicodeslot=0xC2,
 },
 {
  adobename="Atilde",
  category="lu",
  contextname="Atilde",
  description="LATIN CAPITAL LETTER A WITH TILDE",
  direction="l",
  lccode=0xE3,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x303 },
  unicodeslot=0xC3,
 },
 {
  adobename="Adieresis",
  category="lu",
  contextname="Adiaeresis",
  description="LATIN CAPITAL LETTER A WITH DIAERESIS",
  direction="l",
  lccode=0xE4,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x308 },
  unicodeslot=0xC4,
 },
 {
  adobename="Aring",
  category="lu",
  contextname="Aring",
  description="LATIN CAPITAL LETTER A WITH RING ABOVE",
  direction="l",
  lccode=0xE5,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x30A },
  unicodeslot=0xC5,
 },
 {
  adobename="AE",
  category="lu",
  cjkwd="a",
  contextname="AEligature",
  description="LATIN CAPITAL LETTER AE",
  direction="l",
  lccode=0xE6,
  linebreak="al",
  shcode={ 0x41, 0x45 },
  synonyms={ "latin capital ligature ae" },
  unicodeslot=0xC6,
 },
 {
  adobename="Ccedilla",
  category="lu",
  contextname="Ccedilla",
  description="LATIN CAPITAL LETTER C WITH CEDILLA",
  direction="l",
  lccode=0xE7,
  linebreak="al",
  shcode=0x43,
  specials={ "char", 0x43, 0x327 },
  unicodeslot=0xC7,
 },
 {
  adobename="Egrave",
  category="lu",
  contextname="Egrave",
  description="LATIN CAPITAL LETTER E WITH GRAVE",
  direction="l",
  lccode=0xE8,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x300 },
  unicodeslot=0xC8,
 },
 {
  adobename="Eacute",
  category="lu",
  contextname="Eacute",
  description="LATIN CAPITAL LETTER E WITH ACUTE",
  direction="l",
  lccode=0xE9,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x301 },
  unicodeslot=0xC9,
 },
 {
  adobename="Ecircumflex",
  category="lu",
  contextname="Ecircumflex",
  description="LATIN CAPITAL LETTER E WITH CIRCUMFLEX",
  direction="l",
  lccode=0xEA,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x302 },
  unicodeslot=0xCA,
 },
 {
  adobename="Edieresis",
  category="lu",
  contextname="Ediaeresis",
  description="LATIN CAPITAL LETTER E WITH DIAERESIS",
  direction="l",
  lccode=0xEB,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x308 },
  unicodeslot=0xCB,
 },
 {
  adobename="Igrave",
  category="lu",
  contextname="Igrave",
  description="LATIN CAPITAL LETTER I WITH GRAVE",
  direction="l",
  lccode=0xEC,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x300 },
  unicodeslot=0xCC,
 },
 {
  adobename="Iacute",
  category="lu",
  contextname="Iacute",
  description="LATIN CAPITAL LETTER I WITH ACUTE",
  direction="l",
  lccode=0xED,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x301 },
  unicodeslot=0xCD,
 },
 {
  adobename="Icircumflex",
  category="lu",
  contextname="Icircumflex",
  description="LATIN CAPITAL LETTER I WITH CIRCUMFLEX",
  direction="l",
  lccode=0xEE,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x302 },
  unicodeslot=0xCE,
 },
 {
  adobename="Idieresis",
  category="lu",
  contextname="Idiaeresis",
  description="LATIN CAPITAL LETTER I WITH DIAERESIS",
  direction="l",
  lccode=0xEF,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x308 },
  unicodeslot=0xCF,
 },
 {
  adobename="Eth",
  category="lu",
  cjkwd="a",
  contextname="Eth",
  description="LATIN CAPITAL LETTER ETH",
  direction="l",
  lccode=0xF0,
  linebreak="al",
  unicodeslot=0xD0,
 },
 {
  adobename="Ntilde",
  category="lu",
  contextname="Ntilde",
  description="LATIN CAPITAL LETTER N WITH TILDE",
  direction="l",
  lccode=0xF1,
  linebreak="al",
  shcode=0x4E,
  specials={ "char", 0x4E, 0x303 },
  unicodeslot=0xD1,
 },
 {
  adobename="Ograve",
  category="lu",
  contextname="Ograve",
  description="LATIN CAPITAL LETTER O WITH GRAVE",
  direction="l",
  lccode=0xF2,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x300 },
  unicodeslot=0xD2,
 },
 {
  adobename="Oacute",
  category="lu",
  contextname="Oacute",
  description="LATIN CAPITAL LETTER O WITH ACUTE",
  direction="l",
  lccode=0xF3,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x301 },
  unicodeslot=0xD3,
 },
 {
  adobename="Ocircumflex",
  category="lu",
  contextname="Ocircumflex",
  description="LATIN CAPITAL LETTER O WITH CIRCUMFLEX",
  direction="l",
  lccode=0xF4,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x302 },
  unicodeslot=0xD4,
 },
 {
  adobename="Otilde",
  category="lu",
  contextname="Otilde",
  description="LATIN CAPITAL LETTER O WITH TILDE",
  direction="l",
  lccode=0xF5,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x303 },
  unicodeslot=0xD5,
 },
 {
  adobename="Odieresis",
  category="lu",
  contextname="Odiaeresis",
  description="LATIN CAPITAL LETTER O WITH DIAERESIS",
  direction="l",
  lccode=0xF6,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x308 },
  unicodeslot=0xD6,
 },
 {
  adobename="multiply",
  category="sm",
  cjkwd="a",
  contextname="textmultiply",
  description="MULTIPLICATION SIGN",
  direction="on",
  linebreak="ai",
  mathclass="binary",
  mathname="times",
  synonyms={ "cartesian product" },
  unicodeslot=0xD7,
 },
 {
  adobename="Oslash",
  category="lu",
  cjkwd="a",
  contextname="Ostroke",
  description="LATIN CAPITAL LETTER O WITH STROKE",
  direction="l",
  lccode=0xF8,
  linebreak="al",
  shcode=0x4F,
  synonyms={ "latin capital letter o slash" },
  unicodeslot=0xD8,
 },
 {
  adobename="Ugrave",
  category="lu",
  contextname="Ugrave",
  description="LATIN CAPITAL LETTER U WITH GRAVE",
  direction="l",
  lccode=0xF9,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x300 },
  unicodeslot=0xD9,
 },
 {
  adobename="Uacute",
  category="lu",
  contextname="Uacute",
  description="LATIN CAPITAL LETTER U WITH ACUTE",
  direction="l",
  lccode=0xFA,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x301 },
  unicodeslot=0xDA,
 },
 {
  adobename="Ucircumflex",
  category="lu",
  contextname="Ucircumflex",
  description="LATIN CAPITAL LETTER U WITH CIRCUMFLEX",
  direction="l",
  lccode=0xFB,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x302 },
  unicodeslot=0xDB,
 },
 {
  adobename="Udieresis",
  category="lu",
  contextname="Udiaeresis",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS",
  direction="l",
  lccode=0xFC,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x308 },
  unicodeslot=0xDC,
 },
 {
  adobename="Yacute",
  category="lu",
  contextname="Yacute",
  description="LATIN CAPITAL LETTER Y WITH ACUTE",
  direction="l",
  lccode=0xFD,
  linebreak="al",
  shcode=0x59,
  specials={ "char", 0x59, 0x301 },
  unicodeslot=0xDD,
 },
 {
  adobename="Thorn",
  category="lu",
  cjkwd="a",
  contextname="Thorn",
  description="LATIN CAPITAL LETTER THORN",
  direction="l",
  lccode=0xFE,
  linebreak="al",
  unicodeslot=0xDE,
 },
 {
  adobename="germandbls",
  category="ll",
  cjkwd="a",
  comment="uppercase can be 0x1E9E",
  contextname="ssharp",
  description="LATIN SMALL LETTER SHARP S",
  direction="l",
  linebreak="al",
  shcode={ 0x73, 0x73 },
  synonyms={ "eszett" },
  uccode={ 0x53, 0x53 },
  unicodeslot=0xDF,
 },
 {
  adobename="agrave",
  category="ll",
  cjkwd="a",
  contextname="agrave",
  description="LATIN SMALL LETTER A WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x300 },
  uccode=0xC0,
  unicodeslot=0xE0,
 },
 {
  adobename="aacute",
  category="ll",
  cjkwd="a",
  contextname="aacute",
  description="LATIN SMALL LETTER A WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x301 },
  uccode=0xC1,
  unicodeslot=0xE1,
 },
 {
  adobename="acircumflex",
  category="ll",
  contextname="acircumflex",
  description="LATIN SMALL LETTER A WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x302 },
  uccode=0xC2,
  unicodeslot=0xE2,
 },
 {
  adobename="atilde",
  category="ll",
  contextname="atilde",
  description="LATIN SMALL LETTER A WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x303 },
  uccode=0xC3,
  unicodeslot=0xE3,
 },
 {
  adobename="adieresis",
  category="ll",
  contextname="adiaeresis",
  description="LATIN SMALL LETTER A WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x308 },
  uccode=0xC4,
  unicodeslot=0xE4,
 },
 {
  adobename="aring",
  category="ll",
  contextname="aring",
  description="LATIN SMALL LETTER A WITH RING ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x30A },
  uccode=0xC5,
  unicodeslot=0xE5,
 },
 {
  adobename="ae",
  category="ll",
  cjkwd="a",
  contextname="aeligature",
  description="LATIN SMALL LETTER AE",
  direction="l",
  linebreak="al",
  shcode={ 0x61, 0x65 },
  synonyms={ "ash", "latin small ligature ae" },
  uccode=0xC6,
  unicodeslot=0xE6,
 },
 {
  adobename="ccedilla",
  category="ll",
  contextname="ccedilla",
  description="LATIN SMALL LETTER C WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x63,
  specials={ "char", 0x63, 0x327 },
  uccode=0xC7,
  unicodeslot=0xE7,
 },
 {
  adobename="egrave",
  category="ll",
  cjkwd="a",
  contextname="egrave",
  description="LATIN SMALL LETTER E WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x300 },
  uccode=0xC8,
  unicodeslot=0xE8,
 },
 {
  adobename="eacute",
  category="ll",
  cjkwd="a",
  contextname="eacute",
  description="LATIN SMALL LETTER E WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x301 },
  uccode=0xC9,
  unicodeslot=0xE9,
 },
 {
  adobename="ecircumflex",
  category="ll",
  cjkwd="a",
  contextname="ecircumflex",
  description="LATIN SMALL LETTER E WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x302 },
  uccode=0xCA,
  unicodeslot=0xEA,
 },
 {
  adobename="edieresis",
  category="ll",
  contextname="ediaeresis",
  description="LATIN SMALL LETTER E WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x308 },
  uccode=0xCB,
  unicodeslot=0xEB,
 },
 {
  adobename="igrave",
  category="ll",
  cjkwd="a",
  contextname="igrave",
  description="LATIN SMALL LETTER I WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x300 },
  uccode=0xCC,
  unicodeslot=0xEC,
 },
 {
  adobename="iacute",
  category="ll",
  cjkwd="a",
  contextname="iacute",
  description="LATIN SMALL LETTER I WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x301 },
  uccode=0xCD,
  unicodeslot=0xED,
 },
 {
  adobename="icircumflex",
  category="ll",
  contextname="icircumflex",
  description="LATIN SMALL LETTER I WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x302 },
  uccode=0xCE,
  unicodeslot=0xEE,
 },
 {
  adobename="idieresis",
  category="ll",
  contextname="idiaeresis",
  description="LATIN SMALL LETTER I WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x308 },
  uccode=0xCF,
  unicodeslot=0xEF,
 },
 {
  adobename="eth",
  category="ll",
  cjkwd="a",
  comment="contextname=eth",
  description="LATIN SMALL LETTER ETH",
  direction="l",
  linebreak="al",
  mathclass="ordinary",
  mathname="eth",
  uccode=0xD0,
  unicodeslot=0xF0,
 },
 {
  adobename="ntilde",
  category="ll",
  contextname="ntilde",
  description="LATIN SMALL LETTER N WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x6E,
  specials={ "char", 0x6E, 0x303 },
  uccode=0xD1,
  unicodeslot=0xF1,
 },
 {
  adobename="ograve",
  category="ll",
  cjkwd="a",
  contextname="ograve",
  description="LATIN SMALL LETTER O WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x300 },
  uccode=0xD2,
  unicodeslot=0xF2,
 },
 {
  adobename="oacute",
  category="ll",
  cjkwd="a",
  contextname="oacute",
  description="LATIN SMALL LETTER O WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x301 },
  uccode=0xD3,
  unicodeslot=0xF3,
 },
 {
  adobename="ocircumflex",
  category="ll",
  contextname="ocircumflex",
  description="LATIN SMALL LETTER O WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x302 },
  uccode=0xD4,
  unicodeslot=0xF4,
 },
 {
  adobename="otilde",
  category="ll",
  contextname="otilde",
  description="LATIN SMALL LETTER O WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x303 },
  uccode=0xD5,
  unicodeslot=0xF5,
 },
 {
  adobename="odieresis",
  category="ll",
  contextname="odiaeresis",
  description="LATIN SMALL LETTER O WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x308 },
  uccode=0xD6,
  unicodeslot=0xF6,
 },
 {
  adobename="divide",
  category="sm",
  cjkwd="a",
  contextname="textdiv",
  description="DIVISION SIGN",
  direction="on",
  linebreak="ai",
  mathclass="binary",
  mathname="div",
  synonyms={ "obelus" },
  unicodeslot=0xF7,
 },
 {
  adobename="oslash",
  category="ll",
  cjkwd="a",
  contextname="ostroke",
  description="LATIN SMALL LETTER O WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  synonyms={ "latin small letter o slash" },
  uccode=0xD8,
  unicodeslot=0xF8,
 },
 {
  adobename="ugrave",
  category="ll",
  cjkwd="a",
  contextname="ugrave",
  description="LATIN SMALL LETTER U WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x300 },
  uccode=0xD9,
  unicodeslot=0xF9,
 },
 {
  adobename="uacute",
  category="ll",
  cjkwd="a",
  contextname="uacute",
  description="LATIN SMALL LETTER U WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x301 },
  uccode=0xDA,
  unicodeslot=0xFA,
 },
 {
  adobename="ucircumflex",
  category="ll",
  contextname="ucircumflex",
  description="LATIN SMALL LETTER U WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x302 },
  uccode=0xDB,
  unicodeslot=0xFB,
 },
 {
  adobename="udieresis",
  category="ll",
  cjkwd="a",
  contextname="udiaeresis",
  description="LATIN SMALL LETTER U WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x308 },
  uccode=0xDC,
  unicodeslot=0xFC,
 },
 {
  adobename="yacute",
  category="ll",
  contextname="yacute",
  description="LATIN SMALL LETTER Y WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x79,
  specials={ "char", 0x79, 0x301 },
  uccode=0xDD,
  unicodeslot=0xFD,
 },
 {
  adobename="thorn",
  category="ll",
  cjkwd="a",
  contextname="thorn",
  description="LATIN SMALL LETTER THORN",
  direction="l",
  linebreak="al",
  uccode=0xDE,
  unicodeslot=0xFE,
 },
 {
  adobename="ydieresis",
  category="ll",
  contextname="ydiaeresis",
  description="LATIN SMALL LETTER Y WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x79,
  specials={ "char", 0x79, 0x308 },
  uccode=0x178,
  unicodeslot=0xFF,
 },
 {
  adobename="Amacron",
  category="lu",
  contextname="Amacron",
  description="LATIN CAPITAL LETTER A WITH MACRON",
  direction="l",
  lccode=0x101,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x304 },
  unicodeslot=0x100,
 },
 {
  adobename="amacron",
  category="ll",
  cjkwd="a",
  contextname="amacron",
  description="LATIN SMALL LETTER A WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x304 },
  uccode=0x100,
  unicodeslot=0x101,
 },
 {
  adobename="Abreve",
  category="lu",
  contextname="Abreve",
  description="LATIN CAPITAL LETTER A WITH BREVE",
  direction="l",
  lccode=0x103,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x306 },
  unicodeslot=0x102,
 },
 {
  adobename="abreve",
  category="ll",
  contextname="abreve",
  description="LATIN SMALL LETTER A WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x306 },
  uccode=0x102,
  unicodeslot=0x103,
 },
 {
  adobename="Aogonek",
  category="lu",
  contextname="Aogonek",
  description="LATIN CAPITAL LETTER A WITH OGONEK",
  direction="l",
  lccode=0x105,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x328 },
  unicodeslot=0x104,
 },
 {
  adobename="aogonek",
  category="ll",
  contextname="aogonek",
  description="LATIN SMALL LETTER A WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x328 },
  uccode=0x104,
  unicodeslot=0x105,
 },
 {
  adobename="Cacute",
  category="lu",
  contextname="Cacute",
  description="LATIN CAPITAL LETTER C WITH ACUTE",
  direction="l",
  lccode=0x107,
  linebreak="al",
  shcode=0x43,
  specials={ "char", 0x43, 0x301 },
  unicodeslot=0x106,
 },
 {
  adobename="cacute",
  category="ll",
  contextname="cacute",
  description="LATIN SMALL LETTER C WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x63,
  specials={ "char", 0x63, 0x301 },
  uccode=0x106,
  unicodeslot=0x107,
 },
 {
  adobename="Ccircumflex",
  category="lu",
  contextname="Ccircumflex",
  description="LATIN CAPITAL LETTER C WITH CIRCUMFLEX",
  direction="l",
  lccode=0x109,
  linebreak="al",
  shcode=0x43,
  specials={ "char", 0x43, 0x302 },
  unicodeslot=0x108,
 },
 {
  adobename="ccircumflex",
  category="ll",
  contextname="ccircumflex",
  description="LATIN SMALL LETTER C WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x63,
  specials={ "char", 0x63, 0x302 },
  uccode=0x108,
  unicodeslot=0x109,
 },
 {
  adobename="Cdotaccent",
  category="lu",
  contextname="Cdotaccent",
  description="LATIN CAPITAL LETTER C WITH DOT ABOVE",
  direction="l",
  lccode=0x10B,
  linebreak="al",
  shcode=0x43,
  specials={ "char", 0x43, 0x307 },
  unicodeslot=0x10A,
 },
 {
  adobename="cdotaccent",
  category="ll",
  contextname="cdotaccent",
  description="LATIN SMALL LETTER C WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x63,
  specials={ "char", 0x63, 0x307 },
  uccode=0x10A,
  unicodeslot=0x10B,
 },
 {
  adobename="Ccaron",
  category="lu",
  contextname="Ccaron",
  description="LATIN CAPITAL LETTER C WITH CARON",
  direction="l",
  lccode=0x10D,
  linebreak="al",
  shcode=0x43,
  specials={ "char", 0x43, 0x30C },
  unicodeslot=0x10C,
 },
 {
  adobename="ccaron",
  category="ll",
  contextname="ccaron",
  description="LATIN SMALL LETTER C WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x63,
  specials={ "char", 0x63, 0x30C },
  uccode=0x10C,
  unicodeslot=0x10D,
 },
 {
  adobename="Dcaron",
  category="lu",
  contextname="Dcaron",
  description="LATIN CAPITAL LETTER D WITH CARON",
  direction="l",
  lccode=0x10F,
  linebreak="al",
  shcode=0x44,
  specials={ "char", 0x44, 0x30C },
  unicodeslot=0x10E,
 },
 {
  adobename="dcaron",
  category="ll",
  contextname="dcaron",
  description="LATIN SMALL LETTER D WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x64,
  specials={ "char", 0x64, 0x30C },
  uccode=0x10E,
  unicodeslot=0x10F,
 },
 {
  adobename="Dslash",
  category="lu",
  contextname="Dstroke",
  description="LATIN CAPITAL LETTER D WITH STROKE",
  direction="l",
  lccode=0x111,
  linebreak="al",
  shcode=0x44,
  unicodeslot=0x110,
 },
 {
  adobename="dmacron",
  category="ll",
  cjkwd="a",
  contextname="dstroke",
  description="LATIN SMALL LETTER D WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x64,
  uccode=0x110,
  unicodeslot=0x111,
 },
 {
  adobename="Emacron",
  category="lu",
  contextname="Emacron",
  description="LATIN CAPITAL LETTER E WITH MACRON",
  direction="l",
  lccode=0x113,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x304 },
  unicodeslot=0x112,
 },
 {
  adobename="emacron",
  category="ll",
  cjkwd="a",
  contextname="emacron",
  description="LATIN SMALL LETTER E WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x304 },
  uccode=0x112,
  unicodeslot=0x113,
 },
 {
  adobename="Ebreve",
  category="lu",
  contextname="Ebreve",
  description="LATIN CAPITAL LETTER E WITH BREVE",
  direction="l",
  lccode=0x115,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x306 },
  unicodeslot=0x114,
 },
 {
  adobename="ebreve",
  category="ll",
  contextname="ebreve",
  description="LATIN SMALL LETTER E WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x306 },
  uccode=0x114,
  unicodeslot=0x115,
 },
 {
  adobename="Edotaccent",
  category="lu",
  contextname="Edotaccent",
  description="LATIN CAPITAL LETTER E WITH DOT ABOVE",
  direction="l",
  lccode=0x117,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x307 },
  unicodeslot=0x116,
 },
 {
  adobename="edotaccent",
  category="ll",
  contextname="edotaccent",
  description="LATIN SMALL LETTER E WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x307 },
  uccode=0x116,
  unicodeslot=0x117,
 },
 {
  adobename="Eogonek",
  category="lu",
  contextname="Eogonek",
  description="LATIN CAPITAL LETTER E WITH OGONEK",
  direction="l",
  lccode=0x119,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x328 },
  unicodeslot=0x118,
 },
 {
  adobename="eogonek",
  category="ll",
  contextname="eogonek",
  description="LATIN SMALL LETTER E WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x328 },
  uccode=0x118,
  unicodeslot=0x119,
 },
 {
  adobename="Ecaron",
  category="lu",
  contextname="Ecaron",
  description="LATIN CAPITAL LETTER E WITH CARON",
  direction="l",
  lccode=0x11B,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x30C },
  unicodeslot=0x11A,
 },
 {
  adobename="ecaron",
  category="ll",
  cjkwd="a",
  contextname="ecaron",
  description="LATIN SMALL LETTER E WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x30C },
  uccode=0x11A,
  unicodeslot=0x11B,
 },
 {
  adobename="Gcircumflex",
  category="lu",
  contextname="Gcircumflex",
  description="LATIN CAPITAL LETTER G WITH CIRCUMFLEX",
  direction="l",
  lccode=0x11D,
  linebreak="al",
  shcode=0x47,
  specials={ "char", 0x47, 0x302 },
  unicodeslot=0x11C,
 },
 {
  adobename="gcircumflex",
  category="ll",
  contextname="gcircumflex",
  description="LATIN SMALL LETTER G WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x67,
  specials={ "char", 0x67, 0x302 },
  uccode=0x11C,
  unicodeslot=0x11D,
 },
 {
  adobename="Gbreve",
  category="lu",
  contextname="Gbreve",
  description="LATIN CAPITAL LETTER G WITH BREVE",
  direction="l",
  lccode=0x11F,
  linebreak="al",
  shcode=0x47,
  specials={ "char", 0x47, 0x306 },
  unicodeslot=0x11E,
 },
 {
  adobename="gbreve",
  category="ll",
  contextname="gbreve",
  description="LATIN SMALL LETTER G WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x67,
  specials={ "char", 0x67, 0x306 },
  uccode=0x11E,
  unicodeslot=0x11F,
 },
 {
  adobename="Gdotaccent",
  category="lu",
  contextname="Gdotaccent",
  description="LATIN CAPITAL LETTER G WITH DOT ABOVE",
  direction="l",
  lccode=0x121,
  linebreak="al",
  shcode=0x47,
  specials={ "char", 0x47, 0x307 },
  unicodeslot=0x120,
 },
 {
  adobename="gdotaccent",
  category="ll",
  contextname="gdotaccent",
  description="LATIN SMALL LETTER G WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x67,
  specials={ "char", 0x67, 0x307 },
  uccode=0x120,
  unicodeslot=0x121,
 },
 {
  adobename="Gcommaaccent",
  category="lu",
  contextname="Gcommaaccent",
  description="LATIN CAPITAL LETTER G WITH CEDILLA",
  direction="l",
  lccode=0x123,
  linebreak="al",
  shcode=0x47,
  specials={ "char", 0x47, 0x327 },
  unicodeslot=0x122,
 },
 {
  adobename="gcommaaccent",
  category="ll",
  contextname="gcommaaccent",
  description="LATIN SMALL LETTER G WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x67,
  specials={ "char", 0x67, 0x327 },
  uccode=0x122,
  unicodeslot=0x123,
 },
 {
  adobename="Hcircumflex",
  category="lu",
  contextname="Hcircumflex",
  description="LATIN CAPITAL LETTER H WITH CIRCUMFLEX",
  direction="l",
  lccode=0x125,
  linebreak="al",
  shcode=0x48,
  specials={ "char", 0x48, 0x302 },
  unicodeslot=0x124,
 },
 {
  adobename="hcircumflex",
  category="ll",
  contextname="hcircumflex",
  description="LATIN SMALL LETTER H WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x68,
  specials={ "char", 0x68, 0x302 },
  uccode=0x124,
  unicodeslot=0x125,
 },
 {
  adobename="Hbar",
  category="lu",
  cjkwd="a",
  contextname="Hstroke",
  description="LATIN CAPITAL LETTER H WITH STROKE",
  direction="l",
  lccode=0x127,
  linebreak="al",
  shcode=0x48,
  unicodeslot=0x126,
 },
 {
  adobename="hbar",
  category="ll",
  cjkwd="a",
  contextname="hstroke",
  description="LATIN SMALL LETTER H WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x68,
  uccode=0x126,
  unicodeslot=0x127,
 },
 {
  adobename="Itilde",
  category="lu",
  contextname="Itilde",
  description="LATIN CAPITAL LETTER I WITH TILDE",
  direction="l",
  lccode=0x129,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x303 },
  unicodeslot=0x128,
 },
 {
  adobename="itilde",
  category="ll",
  contextname="itilde",
  description="LATIN SMALL LETTER I WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x303 },
  uccode=0x128,
  unicodeslot=0x129,
 },
 {
  adobename="Imacron",
  category="lu",
  contextname="Imacron",
  description="LATIN CAPITAL LETTER I WITH MACRON",
  direction="l",
  lccode=0x12B,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x304 },
  unicodeslot=0x12A,
 },
 {
  adobename="imacron",
  category="ll",
  cjkwd="a",
  contextname="imacron",
  description="LATIN SMALL LETTER I WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x304 },
  uccode=0x12A,
  unicodeslot=0x12B,
 },
 {
  adobename="Ibreve",
  category="lu",
  contextname="Ibreve",
  description="LATIN CAPITAL LETTER I WITH BREVE",
  direction="l",
  lccode=0x12D,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x306 },
  unicodeslot=0x12C,
 },
 {
  adobename="ibreve",
  category="ll",
  contextname="ibreve",
  description="LATIN SMALL LETTER I WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x306 },
  uccode=0x12C,
  unicodeslot=0x12D,
 },
 {
  adobename="Iogonek",
  category="lu",
  contextname="Iogonek",
  description="LATIN CAPITAL LETTER I WITH OGONEK",
  direction="l",
  lccode=0x12F,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x328 },
  unicodeslot=0x12E,
 },
 {
  adobename="iogonek",
  category="ll",
  contextname="iogonek",
  description="LATIN SMALL LETTER I WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x328 },
  uccode=0x12E,
  unicodeslot=0x12F,
 },
 {
  adobename="Idotaccent",
  category="lu",
  contextname="Idotaccent",
  description="LATIN CAPITAL LETTER I WITH DOT ABOVE",
  direction="l",
  lccode=0x69,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x307 },
  synonyms={ "latin capital letter i dot" },
  unicodeslot=0x130,
 },
 {
  adobename="dotlessi",
  category="ll",
  cjkwd="a",
  contextname="dotlessi",
  description="LATIN SMALL LETTER DOTLESS I",
  direction="l",
  linebreak="al",
  uccode=0x49,
  unicodeslot=0x131,
 },
 {
  adobename="IJ",
  category="lu",
  cjkwd="a",
  contextname="IJligature",
  description="LATIN CAPITAL LIGATURE IJ",
  direction="l",
  lccode=0x133,
  linebreak="al",
  shcode={ 0x49, 0x4A },
  specials={ "compat", 0x49, 0x4A },
  unicodeslot=0x132,
 },
 {
  adobename="ij",
  category="ll",
  cjkwd="a",
  contextname="ijligature",
  description="LATIN SMALL LIGATURE IJ",
  direction="l",
  linebreak="al",
  shcode={ 0x69, 0x6A },
  specials={ "compat", 0x69, 0x6A },
  uccode=0x132,
  unicodeslot=0x133,
 },
 {
  adobename="Jcircumflex",
  category="lu",
  contextname="Jcircumflex",
  description="LATIN CAPITAL LETTER J WITH CIRCUMFLEX",
  direction="l",
  lccode=0x135,
  linebreak="al",
  shcode=0x4A,
  specials={ "char", 0x4A, 0x302 },
  unicodeslot=0x134,
 },
 {
  adobename="jcircumflex",
  category="ll",
  contextname="jcircumflex",
  description="LATIN SMALL LETTER J WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x6A,
  specials={ "char", 0x6A, 0x302 },
  uccode=0x134,
  unicodeslot=0x135,
 },
 {
  adobename="Kcommaaccent",
  category="lu",
  contextname="Kcommaaccent",
  description="LATIN CAPITAL LETTER K WITH CEDILLA",
  direction="l",
  lccode=0x137,
  linebreak="al",
  shcode=0x4B,
  specials={ "char", 0x4B, 0x327 },
  unicodeslot=0x136,
 },
 {
  adobename="kcommaaccent",
  category="ll",
  contextname="kcommaaccent",
  description="LATIN SMALL LETTER K WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x6B,
  specials={ "char", 0x6B, 0x327 },
  uccode=0x136,
  unicodeslot=0x137,
 },
 {
  adobename="kgreenlandic",
  category="ll",
  cjkwd="a",
  contextname="kkra",
  description="LATIN SMALL LETTER KRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x138,
 },
 {
  adobename="Lacute",
  category="lu",
  contextname="Lacute",
  description="LATIN CAPITAL LETTER L WITH ACUTE",
  direction="l",
  lccode=0x13A,
  linebreak="al",
  shcode=0x4C,
  specials={ "char", 0x4C, 0x301 },
  unicodeslot=0x139,
 },
 {
  adobename="lacute",
  category="ll",
  contextname="lacute",
  description="LATIN SMALL LETTER L WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  specials={ "char", 0x6C, 0x301 },
  uccode=0x139,
  unicodeslot=0x13A,
 },
 {
  adobename="Lcommaaccent",
  category="lu",
  contextname="Lcommaaccent",
  description="LATIN CAPITAL LETTER L WITH CEDILLA",
  direction="l",
  lccode=0x13C,
  linebreak="al",
  shcode=0x4C,
  specials={ "char", 0x4C, 0x327 },
  unicodeslot=0x13B,
 },
 {
  adobename="lcommaaccent",
  category="ll",
  contextname="lcommaaccent",
  description="LATIN SMALL LETTER L WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  specials={ "char", 0x6C, 0x327 },
  uccode=0x13B,
  unicodeslot=0x13C,
 },
 {
  adobename="Lcaron",
  category="lu",
  contextname="Lcaron",
  description="LATIN CAPITAL LETTER L WITH CARON",
  direction="l",
  lccode=0x13E,
  linebreak="al",
  shcode=0x4C,
  specials={ "char", 0x4C, 0x30C },
  unicodeslot=0x13D,
 },
 {
  adobename="lcaron",
  category="ll",
  contextname="lcaron",
  description="LATIN SMALL LETTER L WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  specials={ "char", 0x6C, 0x30C },
  uccode=0x13D,
  unicodeslot=0x13E,
 },
 {
  adobename="Ldotaccent",
  category="lu",
  cjkwd="a",
  contextname="Ldotmiddle",
  description="LATIN CAPITAL LETTER L WITH MIDDLE DOT",
  direction="l",
  lccode=0x140,
  linebreak="al",
  shcode=0x4C,
  specials={ "compat", 0x4C, 0xB7 },
  unicodeslot=0x13F,
 },
 {
  adobename="ldotaccent",
  category="ll",
  cjkwd="a",
  contextname="ldotmiddle",
  description="LATIN SMALL LETTER L WITH MIDDLE DOT",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  specials={ "compat", 0x6C, 0xB7 },
  uccode=0x13F,
  unicodeslot=0x140,
 },
 {
  adobename="Lslash",
  category="lu",
  cjkwd="a",
  contextname="Lstroke",
  description="LATIN CAPITAL LETTER L WITH STROKE",
  direction="l",
  lccode=0x142,
  linebreak="al",
  shcode=0x4C,
  unicodeslot=0x141,
 },
 {
  adobename="lslash",
  category="ll",
  cjkwd="a",
  contextname="lstroke",
  description="LATIN SMALL LETTER L WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  uccode=0x141,
  unicodeslot=0x142,
 },
 {
  adobename="Nacute",
  category="lu",
  contextname="Nacute",
  description="LATIN CAPITAL LETTER N WITH ACUTE",
  direction="l",
  lccode=0x144,
  linebreak="al",
  shcode=0x4E,
  specials={ "char", 0x4E, 0x301 },
  unicodeslot=0x143,
 },
 {
  adobename="nacute",
  category="ll",
  cjkwd="a",
  contextname="nacute",
  description="LATIN SMALL LETTER N WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x6E,
  specials={ "char", 0x6E, 0x301 },
  uccode=0x143,
  unicodeslot=0x144,
 },
 {
  adobename="Ncommaaccent",
  category="lu",
  contextname="Ncommaaccent",
  description="LATIN CAPITAL LETTER N WITH CEDILLA",
  direction="l",
  lccode=0x146,
  linebreak="al",
  shcode=0x4E,
  specials={ "char", 0x4E, 0x327 },
  unicodeslot=0x145,
 },
 {
  adobename="ncommaaccent",
  category="ll",
  contextname="ncommaaccent",
  description="LATIN SMALL LETTER N WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x6E,
  specials={ "char", 0x6E, 0x327 },
  uccode=0x145,
  unicodeslot=0x146,
 },
 {
  adobename="Ncaron",
  category="lu",
  contextname="Ncaron",
  description="LATIN CAPITAL LETTER N WITH CARON",
  direction="l",
  lccode=0x148,
  linebreak="al",
  shcode=0x4E,
  specials={ "char", 0x4E, 0x30C },
  unicodeslot=0x147,
 },
 {
  adobename="ncaron",
  category="ll",
  cjkwd="a",
  contextname="ncaron",
  description="LATIN SMALL LETTER N WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x6E,
  specials={ "char", 0x6E, 0x30C },
  uccode=0x147,
  unicodeslot=0x148,
 },
 {
  adobename="quoterightn",
  category="ll",
  cjkwd="a",
  contextname="napostrophe",
  description="LATIN SMALL LETTER N PRECEDED BY APOSTROPHE",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x2BC, 0x6E },
  unicodeslot=0x149,
 },
 {
  adobename="Eng",
  category="lu",
  cjkwd="a",
  contextname="Neng",
  description="LATIN CAPITAL LETTER ENG",
  direction="l",
  lccode=0x14B,
  linebreak="al",
  unicodeslot=0x14A,
 },
 {
  adobename="eng",
  category="ll",
  cjkwd="a",
  contextname="neng",
  description="LATIN SMALL LETTER ENG",
  direction="l",
  linebreak="al",
  uccode=0x14A,
  unicodeslot=0x14B,
 },
 {
  adobename="Omacron",
  category="lu",
  contextname="Omacron",
  description="LATIN CAPITAL LETTER O WITH MACRON",
  direction="l",
  lccode=0x14D,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x304 },
  unicodeslot=0x14C,
 },
 {
  adobename="omacron",
  category="ll",
  cjkwd="a",
  contextname="omacron",
  description="LATIN SMALL LETTER O WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x304 },
  uccode=0x14C,
  unicodeslot=0x14D,
 },
 {
  adobename="Obreve",
  category="lu",
  contextname="Obreve",
  description="LATIN CAPITAL LETTER O WITH BREVE",
  direction="l",
  lccode=0x14F,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x306 },
  unicodeslot=0x14E,
 },
 {
  adobename="obreve",
  category="ll",
  contextname="obreve",
  description="LATIN SMALL LETTER O WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x306 },
  uccode=0x14E,
  unicodeslot=0x14F,
 },
 {
  adobename="Ohungarumlaut",
  category="lu",
  contextname="Ohungarumlaut",
  description="LATIN CAPITAL LETTER O WITH DOUBLE ACUTE",
  direction="l",
  lccode=0x151,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x30B },
  unicodeslot=0x150,
 },
 {
  adobename="ohungarumlaut",
  category="ll",
  contextname="ohungarumlaut",
  description="LATIN SMALL LETTER O WITH DOUBLE ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x30B },
  uccode=0x150,
  unicodeslot=0x151,
 },
 {
  adobename="OE",
  category="lu",
  cjkwd="a",
  contextname="OEligature",
  description="LATIN CAPITAL LIGATURE OE",
  direction="l",
  lccode=0x153,
  linebreak="al",
  shcode={ 0x4F, 0x45 },
  unicodeslot=0x152,
 },
 {
  adobename="oe",
  category="ll",
  cjkwd="a",
  contextname="oeligature",
  description="LATIN SMALL LIGATURE OE",
  direction="l",
  linebreak="al",
  shcode={ 0x6F, 0x65 },
  synonyms={ "ethel", "latin small letter o e" },
  uccode=0x152,
  unicodeslot=0x153,
 },
 {
  adobename="Racute",
  category="lu",
  contextname="Racute",
  description="LATIN CAPITAL LETTER R WITH ACUTE",
  direction="l",
  lccode=0x155,
  linebreak="al",
  shcode=0x52,
  specials={ "char", 0x52, 0x301 },
  unicodeslot=0x154,
 },
 {
  adobename="racute",
  category="ll",
  contextname="racute",
  description="LATIN SMALL LETTER R WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x72,
  specials={ "char", 0x72, 0x301 },
  uccode=0x154,
  unicodeslot=0x155,
 },
 {
  adobename="Rcommaaccent",
  category="lu",
  contextname="Rcommaaccent",
  description="LATIN CAPITAL LETTER R WITH CEDILLA",
  direction="l",
  lccode=0x157,
  linebreak="al",
  shcode=0x52,
  specials={ "char", 0x52, 0x327 },
  unicodeslot=0x156,
 },
 {
  adobename="rcommaaccent",
  category="ll",
  contextname="rcommaaccent",
  description="LATIN SMALL LETTER R WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x72,
  specials={ "char", 0x72, 0x327 },
  uccode=0x156,
  unicodeslot=0x157,
 },
 {
  adobename="Rcaron",
  category="lu",
  contextname="Rcaron",
  description="LATIN CAPITAL LETTER R WITH CARON",
  direction="l",
  lccode=0x159,
  linebreak="al",
  shcode=0x52,
  specials={ "char", 0x52, 0x30C },
  unicodeslot=0x158,
 },
 {
  adobename="rcaron",
  category="ll",
  contextname="rcaron",
  description="LATIN SMALL LETTER R WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x72,
  specials={ "char", 0x72, 0x30C },
  uccode=0x158,
  unicodeslot=0x159,
 },
 {
  adobename="Sacute",
  category="lu",
  contextname="Sacute",
  description="LATIN CAPITAL LETTER S WITH ACUTE",
  direction="l",
  lccode=0x15B,
  linebreak="al",
  shcode=0x53,
  specials={ "char", 0x53, 0x301 },
  unicodeslot=0x15A,
 },
 {
  adobename="sacute",
  category="ll",
  contextname="sacute",
  description="LATIN SMALL LETTER S WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x73,
  specials={ "char", 0x73, 0x301 },
  uccode=0x15A,
  unicodeslot=0x15B,
 },
 {
  adobename="Scircumflex",
  category="lu",
  contextname="Scircumflex",
  description="LATIN CAPITAL LETTER S WITH CIRCUMFLEX",
  direction="l",
  lccode=0x15D,
  linebreak="al",
  shcode=0x53,
  specials={ "char", 0x53, 0x302 },
  unicodeslot=0x15C,
 },
 {
  adobename="scircumflex",
  category="ll",
  contextname="scircumflex",
  description="LATIN SMALL LETTER S WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x73,
  specials={ "char", 0x73, 0x302 },
  uccode=0x15C,
  unicodeslot=0x15D,
 },
 {
  adobename="Scedilla",
  category="lu",
  contextname="Scedilla",
  description="LATIN CAPITAL LETTER S WITH CEDILLA",
  direction="l",
  lccode=0x15F,
  linebreak="al",
  shcode=0x53,
  specials={ "char", 0x53, 0x327 },
  unicodeslot=0x15E,
 },
 {
  adobename="scedilla",
  category="ll",
  contextname="scedilla",
  description="LATIN SMALL LETTER S WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x73,
  specials={ "char", 0x73, 0x327 },
  uccode=0x15E,
  unicodeslot=0x15F,
 },
 {
  adobename="Scaron",
  category="lu",
  contextname="Scaron",
  description="LATIN CAPITAL LETTER S WITH CARON",
  direction="l",
  lccode=0x161,
  linebreak="al",
  shcode=0x53,
  specials={ "char", 0x53, 0x30C },
  unicodeslot=0x160,
 },
 {
  adobename="scaron",
  category="ll",
  contextname="scaron",
  description="LATIN SMALL LETTER S WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x73,
  specials={ "char", 0x73, 0x30C },
  uccode=0x160,
  unicodeslot=0x161,
 },
 {
  adobename="Tcommaaccent",
  category="lu",
  contextname="Tcedilla",
  description="LATIN CAPITAL LETTER T WITH CEDILLA",
  direction="l",
  lccode=0x163,
  linebreak="al",
  shcode=0x54,
  specials={ "char", 0x54, 0x327 },
  unicodeslot=0x162,
 },
 {
  adobename="tcommaaccent",
  category="ll",
  contextname="tcedilla",
  description="LATIN SMALL LETTER T WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x74,
  specials={ "char", 0x74, 0x327 },
  uccode=0x162,
  unicodeslot=0x163,
 },
 {
  adobename="Tcaron",
  category="lu",
  contextname="Tcaron",
  description="LATIN CAPITAL LETTER T WITH CARON",
  direction="l",
  lccode=0x165,
  linebreak="al",
  shcode=0x54,
  specials={ "char", 0x54, 0x30C },
  unicodeslot=0x164,
 },
 {
  adobename="tcaron",
  category="ll",
  contextname="tcaron",
  description="LATIN SMALL LETTER T WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x74,
  specials={ "char", 0x74, 0x30C },
  uccode=0x164,
  unicodeslot=0x165,
 },
 {
  adobename="Tbar",
  category="lu",
  cjkwd="a",
  contextname="Tstroke",
  description="LATIN CAPITAL LETTER T WITH STROKE",
  direction="l",
  lccode=0x167,
  linebreak="al",
  shcode=0x54,
  unicodeslot=0x166,
 },
 {
  adobename="tbar",
  category="ll",
  cjkwd="a",
  contextname="tstroke",
  description="LATIN SMALL LETTER T WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x74,
  uccode=0x166,
  unicodeslot=0x167,
 },
 {
  adobename="Utilde",
  category="lu",
  contextname="Utilde",
  description="LATIN CAPITAL LETTER U WITH TILDE",
  direction="l",
  lccode=0x169,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x303 },
  unicodeslot=0x168,
 },
 {
  adobename="utilde",
  category="ll",
  contextname="utilde",
  description="LATIN SMALL LETTER U WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x303 },
  uccode=0x168,
  unicodeslot=0x169,
 },
 {
  adobename="Umacron",
  category="lu",
  contextname="Umacron",
  description="LATIN CAPITAL LETTER U WITH MACRON",
  direction="l",
  lccode=0x16B,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x304 },
  unicodeslot=0x16A,
 },
 {
  adobename="umacron",
  category="ll",
  cjkwd="a",
  contextname="umacron",
  description="LATIN SMALL LETTER U WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x304 },
  uccode=0x16A,
  unicodeslot=0x16B,
 },
 {
  adobename="Ubreve",
  category="lu",
  contextname="Ubreve",
  description="LATIN CAPITAL LETTER U WITH BREVE",
  direction="l",
  lccode=0x16D,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x306 },
  unicodeslot=0x16C,
 },
 {
  adobename="ubreve",
  category="ll",
  contextname="ubreve",
  description="LATIN SMALL LETTER U WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x306 },
  uccode=0x16C,
  unicodeslot=0x16D,
 },
 {
  adobename="Uring",
  category="lu",
  contextname="Uring",
  description="LATIN CAPITAL LETTER U WITH RING ABOVE",
  direction="l",
  lccode=0x16F,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x30A },
  unicodeslot=0x16E,
 },
 {
  adobename="uring",
  category="ll",
  contextname="uring",
  description="LATIN SMALL LETTER U WITH RING ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x30A },
  uccode=0x16E,
  unicodeslot=0x16F,
 },
 {
  adobename="Uhungarumlaut",
  category="lu",
  contextname="Uhungarumlaut",
  description="LATIN CAPITAL LETTER U WITH DOUBLE ACUTE",
  direction="l",
  lccode=0x171,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x30B },
  unicodeslot=0x170,
 },
 {
  adobename="uhungarumlaut",
  category="ll",
  contextname="uhungarumlaut",
  description="LATIN SMALL LETTER U WITH DOUBLE ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x30B },
  uccode=0x170,
  unicodeslot=0x171,
 },
 {
  adobename="Uogonek",
  category="lu",
  contextname="Uogonek",
  description="LATIN CAPITAL LETTER U WITH OGONEK",
  direction="l",
  lccode=0x173,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x328 },
  unicodeslot=0x172,
 },
 {
  adobename="uogonek",
  category="ll",
  contextname="uogonek",
  description="LATIN SMALL LETTER U WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x328 },
  uccode=0x172,
  unicodeslot=0x173,
 },
 {
  adobename="Wcircumflex",
  category="lu",
  contextname="Wcircumflex",
  description="LATIN CAPITAL LETTER W WITH CIRCUMFLEX",
  direction="l",
  lccode=0x175,
  linebreak="al",
  shcode=0x57,
  specials={ "char", 0x57, 0x302 },
  unicodeslot=0x174,
 },
 {
  adobename="wcircumflex",
  category="ll",
  contextname="wcircumflex",
  description="LATIN SMALL LETTER W WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x77,
  specials={ "char", 0x77, 0x302 },
  uccode=0x174,
  unicodeslot=0x175,
 },
 {
  adobename="Ycircumflex",
  category="lu",
  contextname="Ycircumflex",
  description="LATIN CAPITAL LETTER Y WITH CIRCUMFLEX",
  direction="l",
  lccode=0x177,
  linebreak="al",
  shcode=0x59,
  specials={ "char", 0x59, 0x302 },
  unicodeslot=0x176,
 },
 {
  adobename="ycircumflex",
  category="ll",
  contextname="ycircumflex",
  description="LATIN SMALL LETTER Y WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x79,
  specials={ "char", 0x79, 0x302 },
  uccode=0x176,
  unicodeslot=0x177,
 },
 {
  adobename="Ydieresis",
  category="lu",
  contextname="Ydiaeresis",
  description="LATIN CAPITAL LETTER Y WITH DIAERESIS",
  direction="l",
  lccode=0xFF,
  linebreak="al",
  shcode=0x59,
  specials={ "char", 0x59, 0x308 },
  unicodeslot=0x178,
 },
 {
  adobename="Zacute",
  category="lu",
  contextname="Zacute",
  description="LATIN CAPITAL LETTER Z WITH ACUTE",
  direction="l",
  lccode=0x17A,
  linebreak="al",
  shcode=0x5A,
  specials={ "char", 0x5A, 0x301 },
  unicodeslot=0x179,
 },
 {
  adobename="zacute",
  category="ll",
  contextname="zacute",
  description="LATIN SMALL LETTER Z WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x7A,
  specials={ "char", 0x7A, 0x301 },
  uccode=0x179,
  unicodeslot=0x17A,
 },
 {
  adobename="Zdotaccent",
  category="lu",
  contextname="Zdotaccent",
  description="LATIN CAPITAL LETTER Z WITH DOT ABOVE",
  direction="l",
  lccode=0x17C,
  linebreak="al",
  shcode=0x5A,
  specials={ "char", 0x5A, 0x307 },
  unicodeslot=0x17B,
 },
 {
  adobename="zdotaccent",
  category="ll",
  contextname="zdotaccent",
  description="LATIN SMALL LETTER Z WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x7A,
  specials={ "char", 0x7A, 0x307 },
  uccode=0x17B,
  unicodeslot=0x17C,
 },
 {
  adobename="Zcaron",
  category="lu",
  contextname="Zcaron",
  description="LATIN CAPITAL LETTER Z WITH CARON",
  direction="l",
  lccode=0x17E,
  linebreak="al",
  shcode=0x5A,
  specials={ "char", 0x5A, 0x30C },
  unicodeslot=0x17D,
 },
 {
  adobename="zcaron",
  category="ll",
  contextname="zcaron",
  description="LATIN SMALL LETTER Z WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x7A,
  specials={ "char", 0x7A, 0x30C },
  uccode=0x17D,
  unicodeslot=0x17E,
 },
 {
  adobename="slong",
  category="ll",
  contextname="slong",
  description="LATIN SMALL LETTER LONG S",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x73 },
  uccode=0x53,
  unicodeslot=0x17F,
 },
 {
  adobename="bstroke",
  category="ll",
  contextname="bstroke",
  description="LATIN SMALL LETTER B WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x62,
  uccode=0x243,
  unicodeslot=0x180,
 },
 {
  adobename="Bhook",
  category="lu",
  contextname="Bhook",
  description="LATIN CAPITAL LETTER B WITH HOOK",
  direction="l",
  lccode=0x253,
  linebreak="al",
  shcode=0x42,
  unicodeslot=0x181,
 },
 {
  adobename="Btopbar",
  category="lu",
  description="LATIN CAPITAL LETTER B WITH TOPBAR",
  direction="l",
  lccode=0x183,
  linebreak="al",
  shcode=0x42,
  unicodeslot=0x182,
 },
 {
  adobename="btopbar",
  category="ll",
  description="LATIN SMALL LETTER B WITH TOPBAR",
  direction="l",
  linebreak="al",
  shcode=0x62,
  uccode=0x182,
  unicodeslot=0x183,
 },
 {
  adobename="Tonesix",
  category="lu",
  description="LATIN CAPITAL LETTER TONE SIX",
  direction="l",
  lccode=0x185,
  linebreak="al",
  unicodeslot=0x184,
 },
 {
  adobename="tonesix",
  category="ll",
  description="LATIN SMALL LETTER TONE SIX",
  direction="l",
  linebreak="al",
  uccode=0x184,
  unicodeslot=0x185,
 },
 {
  adobename="Oopen",
  category="lu",
  description="LATIN CAPITAL LETTER OPEN O",
  direction="l",
  lccode=0x254,
  linebreak="al",
  unicodeslot=0x186,
 },
 {
  adobename="Chook",
  category="lu",
  contextname="Chook",
  description="LATIN CAPITAL LETTER C WITH HOOK",
  direction="l",
  lccode=0x188,
  linebreak="al",
  shcode=0x43,
  unicodeslot=0x187,
 },
 {
  adobename="chook",
  category="ll",
  contextname="chook",
  description="LATIN SMALL LETTER C WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x63,
  uccode=0x187,
  unicodeslot=0x188,
 },
 {
  adobename="Dafrican",
  category="lu",
  contextname="Dafrican",
  description="LATIN CAPITAL LETTER AFRICAN D",
  direction="l",
  lccode=0x256,
  linebreak="al",
  unicodeslot=0x189,
 },
 {
  adobename="Dhook",
  category="lu",
  contextname="Dhook",
  description="LATIN CAPITAL LETTER D WITH HOOK",
  direction="l",
  lccode=0x257,
  linebreak="al",
  shcode=0x44,
  unicodeslot=0x18A,
 },
 {
  adobename="Dtopbar",
  category="lu",
  description="LATIN CAPITAL LETTER D WITH TOPBAR",
  direction="l",
  lccode=0x18C,
  linebreak="al",
  shcode=0x44,
  unicodeslot=0x18B,
 },
 {
  adobename="dtopbar",
  category="ll",
  description="LATIN SMALL LETTER D WITH TOPBAR",
  direction="l",
  linebreak="al",
  shcode=0x64,
  uccode=0x18B,
  unicodeslot=0x18C,
 },
 {
  adobename="deltaturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED DELTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D,
 },
 {
  adobename="Ereversed",
  category="lu",
  description="LATIN CAPITAL LETTER REVERSED E",
  direction="l",
  lccode=0x1DD,
  linebreak="al",
  synonyms={ "latin capital letter turned e" },
  unicodeslot=0x18E,
 },
 {
  adobename="Schwa",
  category="lu",
  contextname="Schwa",
  description="LATIN CAPITAL LETTER SCHWA",
  direction="l",
  lccode=0x259,
  linebreak="al",
  unicodeslot=0x18F,
 },
 {
  adobename="Eopen",
  category="lu",
  description="LATIN CAPITAL LETTER OPEN E",
  direction="l",
  lccode=0x25B,
  linebreak="al",
  synonyms={ "latin capital letter epsilon" },
  unicodeslot=0x190,
 },
 {
  adobename="Fhook",
  category="lu",
  contextname="Fhook",
  description="LATIN CAPITAL LETTER F WITH HOOK",
  direction="l",
  lccode=0x192,
  linebreak="al",
  shcode=0x46,
  unicodeslot=0x191,
 },
 {
  adobename="florin",
  category="ll",
  contextname="fhook",
  description="LATIN SMALL LETTER F WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x66,
  synonyms={ "florin currency symbol", "folder", "function symbol", "latin small letter script f" },
  uccode=0x191,
  unicodeslot=0x192,
 },
 {
  adobename="Ghook",
  category="lu",
  contextname="Ghook",
  description="LATIN CAPITAL LETTER G WITH HOOK",
  direction="l",
  lccode=0x260,
  linebreak="al",
  shcode=0x47,
  unicodeslot=0x193,
 },
 {
  adobename="Gammaafrican",
  category="lu",
  description="LATIN CAPITAL LETTER GAMMA",
  direction="l",
  lccode=0x263,
  linebreak="al",
  unicodeslot=0x194,
 },
 {
  adobename="hv",
  category="ll",
  description="LATIN SMALL LETTER HV",
  direction="l",
  linebreak="al",
  uccode=0x1F6,
  unicodeslot=0x195,
 },
 {
  adobename="Iotaafrican",
  category="lu",
  description="LATIN CAPITAL LETTER IOTA",
  direction="l",
  lccode=0x269,
  linebreak="al",
  unicodeslot=0x196,
 },
 {
  adobename="Istroke",
  category="lu",
  contextname="Istroke",
  description="LATIN CAPITAL LETTER I WITH STROKE",
  direction="l",
  lccode=0x268,
  linebreak="al",
  shcode=0x49,
  synonyms={ "latin capital letter i bar" },
  unicodeslot=0x197,
 },
 {
  adobename="Khook",
  category="lu",
  contextname="Khook",
  description="LATIN CAPITAL LETTER K WITH HOOK",
  direction="l",
  lccode=0x199,
  linebreak="al",
  shcode=0x4B,
  unicodeslot=0x198,
 },
 {
  adobename="khook",
  category="ll",
  contextname="khook",
  description="LATIN SMALL LETTER K WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x6B,
  uccode=0x198,
  unicodeslot=0x199,
 },
 {
  adobename="lbar",
  category="ll",
  contextname="lbar",
  description="LATIN SMALL LETTER L WITH BAR",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  uccode=0x23D,
  unicodeslot=0x19A,
 },
 {
  adobename="lambdastroke",
  category="ll",
  description="LATIN SMALL LETTER LAMBDA WITH STROKE",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="lambdabar",
  synonyms={ "latin letter lambda bar" },
  unicodeslot=0x19B,
 },
 {
  adobename="Mturned",
  category="lu",
  description="LATIN CAPITAL LETTER TURNED M",
  direction="l",
  lccode=0x26F,
  linebreak="al",
  unicodeslot=0x19C,
 },
 {
  adobename="Nhookleft",
  category="lu",
  description="LATIN CAPITAL LETTER N WITH LEFT HOOK",
  direction="l",
  lccode=0x272,
  linebreak="al",
  shcode=0x4E,
  unicodeslot=0x19D,
 },
 {
  adobename="nlegrightlong",
  category="ll",
  description="LATIN SMALL LETTER N WITH LONG RIGHT LEG",
  direction="l",
  linebreak="al",
  shcode=0x6E,
  uccode=0x220,
  unicodeslot=0x19E,
 },
 {
  adobename="Ocenteredtilde",
  category="lu",
  description="LATIN CAPITAL LETTER O WITH MIDDLE TILDE",
  direction="l",
  lccode=0x275,
  linebreak="al",
  shcode=0x4F,
  synonyms={ "latin capital letter barred o", "latin capital letter o bar" },
  unicodeslot=0x19F,
 },
 {
  adobename="Ohorn",
  category="lu",
  contextname="Ohorn",
  description="LATIN CAPITAL LETTER O WITH HORN",
  direction="l",
  lccode=0x1A1,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x31B },
  unicodeslot=0x1A0,
 },
 {
  adobename="ohorn",
  category="ll",
  contextname="ohorn",
  description="LATIN SMALL LETTER O WITH HORN",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x31B },
  uccode=0x1A0,
  unicodeslot=0x1A1,
 },
 {
  adobename="Oi",
  category="lu",
  description="LATIN CAPITAL LETTER OI",
  direction="l",
  lccode=0x1A3,
  linebreak="al",
  unicodeslot=0x1A2,
 },
 {
  adobename="oi",
  category="ll",
  description="LATIN SMALL LETTER OI",
  direction="l",
  linebreak="al",
  uccode=0x1A2,
  unicodeslot=0x1A3,
 },
 {
  adobename="Phook",
  category="lu",
  contextname="Phook",
  description="LATIN CAPITAL LETTER P WITH HOOK",
  direction="l",
  lccode=0x1A5,
  linebreak="al",
  shcode=0x50,
  unicodeslot=0x1A4,
 },
 {
  adobename="phook",
  category="ll",
  contextname="phook",
  description="LATIN SMALL LETTER P WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x70,
  uccode=0x1A4,
  unicodeslot=0x1A5,
 },
 {
  adobename="yr",
  category="lu",
  description="LATIN LETTER YR",
  direction="l",
  lccode=0x280,
  linebreak="al",
  unicodeslot=0x1A6,
 },
 {
  adobename="Tonetwo",
  category="lu",
  description="LATIN CAPITAL LETTER TONE TWO",
  direction="l",
  lccode=0x1A8,
  linebreak="al",
  unicodeslot=0x1A7,
 },
 {
  adobename="tonetwo",
  category="ll",
  description="LATIN SMALL LETTER TONE TWO",
  direction="l",
  linebreak="al",
  uccode=0x1A7,
  unicodeslot=0x1A8,
 },
 {
  adobename="Esh",
  category="lu",
  description="LATIN CAPITAL LETTER ESH",
  direction="l",
  lccode=0x283,
  linebreak="al",
  unicodeslot=0x1A9,
 },
 {
  adobename="eshreversedloop",
  category="ll",
  description="LATIN LETTER REVERSED ESH LOOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x1AA,
 },
 {
  adobename="tpalatalhook",
  category="ll",
  description="LATIN SMALL LETTER T WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x74,
  unicodeslot=0x1AB,
 },
 {
  adobename="Thook",
  category="lu",
  contextname="Thook",
  description="LATIN CAPITAL LETTER T WITH HOOK",
  direction="l",
  lccode=0x1AD,
  linebreak="al",
  shcode=0x54,
  unicodeslot=0x1AC,
 },
 {
  adobename="thook",
  category="ll",
  contextname="thook",
  description="LATIN SMALL LETTER T WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x74,
  uccode=0x1AC,
  unicodeslot=0x1AD,
 },
 {
  adobename="Tretroflexhook",
  category="lu",
  description="LATIN CAPITAL LETTER T WITH RETROFLEX HOOK",
  direction="l",
  lccode=0x288,
  linebreak="al",
  shcode=0x54,
  unicodeslot=0x1AE,
 },
 {
  adobename="Uhorn",
  category="lu",
  contextname="Uhorn",
  description="LATIN CAPITAL LETTER U WITH HORN",
  direction="l",
  lccode=0x1B0,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x31B },
  unicodeslot=0x1AF,
 },
 {
  adobename="uhorn",
  category="ll",
  contextname="uhorn",
  description="LATIN SMALL LETTER U WITH HORN",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x31B },
  uccode=0x1AF,
  unicodeslot=0x1B0,
 },
 {
  adobename="Upsilonafrican",
  category="lu",
  description="LATIN CAPITAL LETTER UPSILON",
  direction="l",
  lccode=0x28A,
  linebreak="al",
  unicodeslot=0x1B1,
 },
 {
  adobename="Vhook",
  category="lu",
  contextname="Uhook",
  description="LATIN CAPITAL LETTER V WITH HOOK",
  direction="l",
  lccode=0x28B,
  linebreak="al",
  shcode=0x56,
  synonyms={ "latin capital letter script v" },
  unicodeslot=0x1B2,
 },
 {
  adobename="Yhook",
  category="lu",
  contextname="Yhook",
  description="LATIN CAPITAL LETTER Y WITH HOOK",
  direction="l",
  lccode=0x1B4,
  linebreak="al",
  shcode=0x59,
  unicodeslot=0x1B3,
 },
 {
  adobename="yhook",
  category="ll",
  contextname="yhook",
  description="LATIN SMALL LETTER Y WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x79,
  uccode=0x1B3,
  unicodeslot=0x1B4,
 },
 {
  adobename="Zstroke",
  category="lu",
  contextname="Zstroke",
  description="LATIN CAPITAL LETTER Z WITH STROKE",
  direction="l",
  lccode=0x1B6,
  linebreak="al",
  shcode=0x5A,
  unicodeslot=0x1B5,
 },
 {
  adobename="zstroke",
  category="ll",
  contextname="zstroke",
  description="LATIN SMALL LETTER Z WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x7A,
  synonyms={ "latin small letter z bar" },
  uccode=0x1B5,
  unicodeslot=0x1B6,
 },
 {
  adobename="Ezh",
  category="lu",
  description="LATIN CAPITAL LETTER EZH",
  direction="l",
  lccode=0x292,
  linebreak="al",
  unicodeslot=0x1B7,
 },
 {
  adobename="Ezhreversed",
  category="lu",
  description="LATIN CAPITAL LETTER EZH REVERSED",
  direction="l",
  lccode=0x1B9,
  linebreak="al",
  unicodeslot=0x1B8,
 },
 {
  adobename="ezhreversed",
  category="ll",
  description="LATIN SMALL LETTER EZH REVERSED",
  direction="l",
  linebreak="al",
  uccode=0x1B8,
  unicodeslot=0x1B9,
 },
 {
  adobename="ezhtail",
  category="ll",
  description="LATIN SMALL LETTER EZH WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x292,
  unicodeslot=0x1BA,
 },
 {
  adobename="twostroke",
  category="lo",
  description="LATIN LETTER TWO WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BB,
 },
 {
  adobename="Tonefive",
  category="lu",
  description="LATIN CAPITAL LETTER TONE FIVE",
  direction="l",
  lccode=0x1BD,
  linebreak="al",
  unicodeslot=0x1BC,
 },
 {
  adobename="tonefive",
  category="ll",
  description="LATIN SMALL LETTER TONE FIVE",
  direction="l",
  linebreak="al",
  uccode=0x1BC,
  unicodeslot=0x1BD,
 },
 {
  adobename="glottalinvertedstroke",
  category="ll",
  description="LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE,
 },
 {
  adobename="wynn",
  category="ll",
  description="LATIN LETTER WYNN",
  direction="l",
  linebreak="al",
  uccode=0x1F7,
  unicodeslot=0x1BF,
 },
 {
  adobename="clickdental",
  category="lo",
  description="LATIN LETTER DENTAL CLICK",
  direction="l",
  linebreak="al",
  synonyms={ "pipe" },
  unicodeslot=0x1C0,
 },
 {
  adobename="clicklateral",
  category="lo",
  description="LATIN LETTER LATERAL CLICK",
  direction="l",
  linebreak="al",
  synonyms={ "double pipe" },
  unicodeslot=0x1C1,
 },
 {
  adobename="clickalveolar",
  category="lo",
  description="LATIN LETTER ALVEOLAR CLICK",
  direction="l",
  linebreak="al",
  synonyms={ "double-barred pipe" },
  unicodeslot=0x1C2,
 },
 {
  adobename="clickretroflex",
  category="lo",
  description="LATIN LETTER RETROFLEX CLICK",
  direction="l",
  linebreak="al",
  synonyms={ "latin letter exclamation mark" },
  unicodeslot=0x1C3,
 },
 {
  adobename="DZcaron",
  category="lu",
  contextname="DZcaronligature",
  description="LATIN CAPITAL LETTER DZ WITH CARON",
  direction="l",
  lccode=0x1C6,
  linebreak="al",
  shcode=0x1F1,
  specials={ "compat", 0x44, 0x17D },
  uccode=0x1C5,
  unicodeslot=0x1C4,
 },
 {
  adobename="Dzcaron",
  category="lt",
  contextname="Dzcaronligature",
  description="LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON",
  direction="l",
  lccode=0x1C6,
  linebreak="al",
  shcode=0x1F2,
  specials={ "compat", 0x44, 0x17E },
  uccode=0x1C4,
  unicodeslot=0x1C5,
 },
 {
  adobename="dzcaron",
  category="ll",
  contextname="dzcaronligature",
  description="LATIN SMALL LETTER DZ WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x1F3,
  specials={ "compat", 0x64, 0x17E },
  uccode=0x1C4,
  unicodeslot=0x1C6,
 },
 {
  adobename="LJ",
  category="lu",
  contextname="LJligature",
  description="LATIN CAPITAL LETTER LJ",
  direction="l",
  lccode=0x1C9,
  linebreak="al",
  shcode={ 0x4C, 0x4A },
  specials={ "compat", 0x4C, 0x4A },
  uccode=0x1C8,
  unicodeslot=0x1C7,
 },
 {
  adobename="Lj",
  category="lt",
  contextname="Ljligature",
  description="LATIN CAPITAL LETTER L WITH SMALL LETTER J",
  direction="l",
  lccode=0x1C9,
  linebreak="al",
  shcode={ 0x4C, 0x6A },
  specials={ "compat", 0x4C, 0x6A },
  uccode=0x1C7,
  unicodeslot=0x1C8,
 },
 {
  adobename="lj",
  category="ll",
  contextname="ljligature",
  description="LATIN SMALL LETTER LJ",
  direction="l",
  linebreak="al",
  shcode={ 0x6C, 0x6A },
  specials={ "compat", 0x6C, 0x6A },
  uccode=0x1C7,
  unicodeslot=0x1C9,
 },
 {
  adobename="NJ",
  category="lu",
  contextname="NJligature",
  description="LATIN CAPITAL LETTER NJ",
  direction="l",
  lccode=0x1CC,
  linebreak="al",
  shcode={ 0x4E, 0x4A },
  specials={ "compat", 0x4E, 0x4A },
  uccode=0x1CB,
  unicodeslot=0x1CA,
 },
 {
  adobename="Nj",
  category="lt",
  contextname="Njligature",
  description="LATIN CAPITAL LETTER N WITH SMALL LETTER J",
  direction="l",
  lccode=0x1CC,
  linebreak="al",
  shcode=0x4E,
  specials={ "compat", 0x4E, 0x6A },
  uccode=0x1CA,
  unicodeslot=0x1CB,
 },
 {
  adobename="nj",
  category="ll",
  contextname="njligature",
  description="LATIN SMALL LETTER NJ",
  direction="l",
  linebreak="al",
  shcode={ 0x6E, 0x6A },
  specials={ "compat", 0x6E, 0x6A },
  uccode=0x1CA,
  unicodeslot=0x1CC,
 },
 {
  adobename="Acaron",
  category="lu",
  contextname="Acaron",
  description="LATIN CAPITAL LETTER A WITH CARON",
  direction="l",
  lccode=0x1CE,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x30C },
  unicodeslot=0x1CD,
 },
 {
  adobename="acaron",
  category="ll",
  cjkwd="a",
  contextname="acaron",
  description="LATIN SMALL LETTER A WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x30C },
  uccode=0x1CD,
  unicodeslot=0x1CE,
 },
 {
  adobename="Icaron",
  category="lu",
  contextname="Icaron",
  description="LATIN CAPITAL LETTER I WITH CARON",
  direction="l",
  lccode=0x1D0,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x30C },
  unicodeslot=0x1CF,
 },
 {
  adobename="icaron",
  category="ll",
  cjkwd="a",
  contextname="icaron",
  description="LATIN SMALL LETTER I WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x30C },
  uccode=0x1CF,
  unicodeslot=0x1D0,
 },
 {
  adobename="Ocaron",
  category="lu",
  contextname="Ocaron",
  description="LATIN CAPITAL LETTER O WITH CARON",
  direction="l",
  lccode=0x1D2,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x30C },
  unicodeslot=0x1D1,
 },
 {
  adobename="ocaron",
  category="ll",
  cjkwd="a",
  contextname="ocaron",
  description="LATIN SMALL LETTER O WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x30C },
  uccode=0x1D1,
  unicodeslot=0x1D2,
 },
 {
  adobename="Ucaron",
  category="lu",
  contextname="Ucaron",
  description="LATIN CAPITAL LETTER U WITH CARON",
  direction="l",
  lccode=0x1D4,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x30C },
  unicodeslot=0x1D3,
 },
 {
  adobename="ucaron",
  category="ll",
  cjkwd="a",
  contextname="ucaron",
  description="LATIN SMALL LETTER U WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x30C },
  uccode=0x1D3,
  unicodeslot=0x1D4,
 },
 {
  adobename="Udieresismacron",
  category="lu",
  contextname="Udiaeresismacron",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON",
  direction="l",
  lccode=0x1D6,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0xDC, 0x304 },
  unicodeslot=0x1D5,
 },
 {
  adobename="udieresismacron",
  category="ll",
  cjkwd="a",
  contextname="udiaeresismacron",
  description="LATIN SMALL LETTER U WITH DIAERESIS AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0xFC, 0x304 },
  uccode=0x1D5,
  unicodeslot=0x1D6,
 },
 {
  adobename="Udieresisacute",
  category="lu",
  contextname="Udiaeresisacute",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE",
  direction="l",
  lccode=0x1D8,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0xDC, 0x301 },
  unicodeslot=0x1D7,
 },
 {
  adobename="udieresisacute",
  category="ll",
  cjkwd="a",
  contextname="udiaeresisacute",
  description="LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0xFC, 0x301 },
  uccode=0x1D7,
  unicodeslot=0x1D8,
 },
 {
  adobename="Udieresiscaron",
  category="lu",
  contextname="Udiaeresiscaron",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON",
  direction="l",
  lccode=0x1DA,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0xDC, 0x30C },
  unicodeslot=0x1D9,
 },
 {
  adobename="udieresiscaron",
  category="ll",
  cjkwd="a",
  contextname="udiaeresiscaron",
  description="LATIN SMALL LETTER U WITH DIAERESIS AND CARON",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0xFC, 0x30C },
  uccode=0x1D9,
  unicodeslot=0x1DA,
 },
 {
  adobename="Udieresisgrave",
  category="lu",
  contextname="Udiaeresisgrave",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE",
  direction="l",
  lccode=0x1DC,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0xDC, 0x300 },
  unicodeslot=0x1DB,
 },
 {
  adobename="udieresisgrave",
  category="ll",
  cjkwd="a",
  contextname="udiaeresisgrave",
  description="LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0xFC, 0x300 },
  uccode=0x1DB,
  unicodeslot=0x1DC,
 },
 {
  adobename="eturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED E",
  direction="l",
  linebreak="al",
  uccode=0x18E,
  unicodeslot=0x1DD,
 },
 {
  adobename="Adieresismacron",
  category="lu",
  contextname="Adiaeresismacron",
  description="LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON",
  direction="l",
  lccode=0x1DF,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0xC4, 0x304 },
  unicodeslot=0x1DE,
 },
 {
  adobename="adieresismacron",
  category="ll",
  contextname="adiaeresismacron",
  description="LATIN SMALL LETTER A WITH DIAERESIS AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0xE4, 0x304 },
  uccode=0x1DE,
  unicodeslot=0x1DF,
 },
 {
  adobename="Adotmacron",
  category="lu",
  contextname="Adotaccentmacron",
  description="LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON",
  direction="l",
  lccode=0x1E1,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x226, 0x304 },
  unicodeslot=0x1E0,
 },
 {
  adobename="adotmacron",
  category="ll",
  contextname="adotaccentmacron",
  description="LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x227, 0x304 },
  uccode=0x1E0,
  unicodeslot=0x1E1,
 },
 {
  adobename="AEmacron",
  category="lu",
  contextname="AEmacron",
  description="LATIN CAPITAL LETTER AE WITH MACRON",
  direction="l",
  lccode=0x1E3,
  linebreak="al",
  shcode=0xC6,
  specials={ "char", 0xC6, 0x304 },
  unicodeslot=0x1E2,
 },
 {
  adobename="aemacron",
  category="ll",
  contextname="aemacron",
  description="LATIN SMALL LETTER AE WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0xE6,
  specials={ "char", 0xE6, 0x304 },
  uccode=0x1E2,
  unicodeslot=0x1E3,
 },
 {
  adobename="Gstroke",
  category="lu",
  contextname="Gstroke",
  description="LATIN CAPITAL LETTER G WITH STROKE",
  direction="l",
  lccode=0x1E5,
  linebreak="al",
  shcode=0x47,
  unicodeslot=0x1E4,
 },
 {
  adobename="gstroke",
  category="ll",
  contextname="gstroke",
  description="LATIN SMALL LETTER G WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x67,
  uccode=0x1E4,
  unicodeslot=0x1E5,
 },
 {
  adobename="Gcaron",
  category="lu",
  contextname="Gcaron",
  description="LATIN CAPITAL LETTER G WITH CARON",
  direction="l",
  lccode=0x1E7,
  linebreak="al",
  shcode=0x47,
  specials={ "char", 0x47, 0x30C },
  unicodeslot=0x1E6,
 },
 {
  adobename="gcaron",
  category="ll",
  contextname="gcaron",
  description="LATIN SMALL LETTER G WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x67,
  specials={ "char", 0x67, 0x30C },
  uccode=0x1E6,
  unicodeslot=0x1E7,
 },
 {
  adobename="Kcaron",
  category="lu",
  contextname="Kcaron",
  description="LATIN CAPITAL LETTER K WITH CARON",
  direction="l",
  lccode=0x1E9,
  linebreak="al",
  shcode=0x4B,
  specials={ "char", 0x4B, 0x30C },
  unicodeslot=0x1E8,
 },
 {
  adobename="kcaron",
  category="ll",
  contextname="kcaron",
  description="LATIN SMALL LETTER K WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x6B,
  specials={ "char", 0x6B, 0x30C },
  uccode=0x1E8,
  unicodeslot=0x1E9,
 },
 {
  adobename="Oogonek",
  category="lu",
  contextname="Oogonek",
  description="LATIN CAPITAL LETTER O WITH OGONEK",
  direction="l",
  lccode=0x1EB,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x328 },
  unicodeslot=0x1EA,
 },
 {
  adobename="oogonek",
  category="ll",
  contextname="oogonek",
  description="LATIN SMALL LETTER O WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x328 },
  uccode=0x1EA,
  unicodeslot=0x1EB,
 },
 {
  adobename="Oogonekmacron",
  category="lu",
  contextname="Oogonekmacron",
  description="LATIN CAPITAL LETTER O WITH OGONEK AND MACRON",
  direction="l",
  lccode=0x1ED,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x1EA, 0x304 },
  unicodeslot=0x1EC,
 },
 {
  adobename="oogonekmacron",
  category="ll",
  contextname="oogonekmacron",
  description="LATIN SMALL LETTER O WITH OGONEK AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x1EB, 0x304 },
  uccode=0x1EC,
  unicodeslot=0x1ED,
 },
 {
  adobename="Ezhcaron",
  category="lu",
  description="LATIN CAPITAL LETTER EZH WITH CARON",
  direction="l",
  lccode=0x1EF,
  linebreak="al",
  shcode=0x1B7,
  specials={ "char", 0x1B7, 0x30C },
  unicodeslot=0x1EE,
 },
 {
  adobename="ezhcaron",
  category="ll",
  description="LATIN SMALL LETTER EZH WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x292,
  specials={ "char", 0x292, 0x30C },
  uccode=0x1EE,
  unicodeslot=0x1EF,
 },
 {
  adobename="jcaron",
  category="ll",
  contextname="jcaron",
  description="LATIN SMALL LETTER J WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x6A,
  specials={ "char", 0x6A, 0x30C },
  unicodeslot=0x1F0,
 },
 {
  adobename="DZ",
  category="lu",
  contextname="DZligature",
  description="LATIN CAPITAL LETTER DZ",
  direction="l",
  lccode=0x1F3,
  linebreak="al",
  specials={ "compat", 0x44, 0x5A },
  uccode=0x1F2,
  unicodeslot=0x1F1,
 },
 {
  adobename="Dz",
  category="lt",
  contextname="Dzligature",
  description="LATIN CAPITAL LETTER D WITH SMALL LETTER Z",
  direction="l",
  lccode=0x1F3,
  linebreak="al",
  shcode=0x44,
  specials={ "compat", 0x44, 0x7A },
  uccode=0x1F1,
  unicodeslot=0x1F2,
 },
 {
  adobename="dz",
  category="ll",
  contextname="dzligature",
  description="LATIN SMALL LETTER DZ",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x64, 0x7A },
  uccode=0x1F1,
  unicodeslot=0x1F3,
 },
 {
  adobename="Gacute",
  category="lu",
  contextname="Gacute",
  description="LATIN CAPITAL LETTER G WITH ACUTE",
  direction="l",
  lccode=0x1F5,
  linebreak="al",
  shcode=0x47,
  specials={ "char", 0x47, 0x301 },
  unicodeslot=0x1F4,
 },
 {
  adobename="gacute",
  category="ll",
  contextname="gacute",
  description="LATIN SMALL LETTER G WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x67,
  specials={ "char", 0x67, 0x301 },
  uccode=0x1F4,
  unicodeslot=0x1F5,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER HWAIR",
  direction="l",
  lccode=0x195,
  linebreak="al",
  unicodeslot=0x1F6,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER WYNN",
  direction="l",
  lccode=0x1BF,
  linebreak="al",
  unicodeslot=0x1F7,
 },
 {
  category="lu",
  contextname="Ngrave",
  description="LATIN CAPITAL LETTER N WITH GRAVE",
  direction="l",
  lccode=0x1F9,
  linebreak="al",
  shcode=0x4E,
  specials={ "char", 0x4E, 0x300 },
  unicodeslot=0x1F8,
 },
 {
  category="ll",
  contextname="ngrave",
  description="LATIN SMALL LETTER N WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x6E,
  specials={ "char", 0x6E, 0x300 },
  uccode=0x1F8,
  unicodeslot=0x1F9,
 },
 {
  adobename="Aringacute",
  category="lu",
  contextname="Aringacute",
  description="LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE",
  direction="l",
  lccode=0x1FB,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0xC5, 0x301 },
  unicodeslot=0x1FA,
 },
 {
  adobename="aringacute",
  category="ll",
  contextname="aringacute",
  description="LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0xE5, 0x301 },
  uccode=0x1FA,
  unicodeslot=0x1FB,
 },
 {
  adobename="AEacute",
  category="lu",
  contextname="AEacute",
  description="LATIN CAPITAL LETTER AE WITH ACUTE",
  direction="l",
  lccode=0x1FD,
  linebreak="al",
  shcode=0xC6,
  specials={ "char", 0xC6, 0x301 },
  unicodeslot=0x1FC,
 },
 {
  adobename="aeacute",
  category="ll",
  contextname="aeacute",
  description="LATIN SMALL LETTER AE WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0xE6,
  specials={ "char", 0xE6, 0x301 },
  uccode=0x1FC,
  unicodeslot=0x1FD,
 },
 {
  adobename="Ostrokeacute",
  category="lu",
  contextname="Ostrokeacute",
  description="LATIN CAPITAL LETTER O WITH STROKE AND ACUTE",
  direction="l",
  lccode=0x1FF,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0xD8, 0x301 },
  unicodeslot=0x1FE,
 },
 {
  adobename="ostrokeacute",
  category="ll",
  contextname="ostrokeacute",
  description="LATIN SMALL LETTER O WITH STROKE AND ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0xF8, 0x301 },
  uccode=0x1FE,
  unicodeslot=0x1FF,
 },
 {
  adobename="Adblgrave",
  category="lu",
  contextname="Adoublegrave",
  description="LATIN CAPITAL LETTER A WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x201,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x30F },
  unicodeslot=0x200,
 },
 {
  adobename="adblgrave",
  category="ll",
  contextname="adoublegrave",
  description="LATIN SMALL LETTER A WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x30F },
  uccode=0x200,
  unicodeslot=0x201,
 },
 {
  adobename="Ainvertedbreve",
  category="lu",
  contextname="Ainvertedbreve",
  description="LATIN CAPITAL LETTER A WITH INVERTED BREVE",
  direction="l",
  lccode=0x203,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x311 },
  unicodeslot=0x202,
 },
 {
  adobename="ainvertedbreve",
  category="ll",
  contextname="ainvertedbreve",
  description="LATIN SMALL LETTER A WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x311 },
  uccode=0x202,
  unicodeslot=0x203,
 },
 {
  adobename="Edblgrave",
  category="lu",
  contextname="Edoublegrave",
  description="LATIN CAPITAL LETTER E WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x205,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x30F },
  unicodeslot=0x204,
 },
 {
  adobename="edblgrave",
  category="ll",
  contextname="edoublegrave",
  description="LATIN SMALL LETTER E WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x30F },
  uccode=0x204,
  unicodeslot=0x205,
 },
 {
  adobename="Einvertedbreve",
  category="lu",
  contextname="Einvertedbreve",
  description="LATIN CAPITAL LETTER E WITH INVERTED BREVE",
  direction="l",
  lccode=0x207,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x311 },
  unicodeslot=0x206,
 },
 {
  adobename="einvertedbreve",
  category="ll",
  contextname="einvertedbreve",
  description="LATIN SMALL LETTER E WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x311 },
  uccode=0x206,
  unicodeslot=0x207,
 },
 {
  adobename="Idblgrave",
  category="lu",
  contextname="Idoublegrave",
  description="LATIN CAPITAL LETTER I WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x209,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x30F },
  unicodeslot=0x208,
 },
 {
  adobename="idblgrave",
  category="ll",
  contextname="idoublegrave",
  description="LATIN SMALL LETTER I WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x30F },
  uccode=0x208,
  unicodeslot=0x209,
 },
 {
  adobename="Iinvertedbreve",
  category="lu",
  contextname="Iinvertedbreve",
  description="LATIN CAPITAL LETTER I WITH INVERTED BREVE",
  direction="l",
  lccode=0x20B,
  linebreak="al",
  shcode=0x49,
  specials={ "char", 0x49, 0x311 },
  unicodeslot=0x20A,
 },
 {
  adobename="iinvertedbreve",
  category="ll",
  contextname="iinvertedbreve",
  description="LATIN SMALL LETTER I WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x69,
  specials={ "char", 0x69, 0x311 },
  uccode=0x20A,
  unicodeslot=0x20B,
 },
 {
  adobename="Odblgrave",
  category="lu",
  contextname="Odoublegrave",
  description="LATIN CAPITAL LETTER O WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x20D,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x30F },
  unicodeslot=0x20C,
 },
 {
  adobename="odblgrave",
  category="ll",
  contextname="odoublegrave",
  description="LATIN SMALL LETTER O WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x30F },
  uccode=0x20C,
  unicodeslot=0x20D,
 },
 {
  adobename="Oinvertedbreve",
  category="lu",
  contextname="Oinvertedbreve",
  description="LATIN CAPITAL LETTER O WITH INVERTED BREVE",
  direction="l",
  lccode=0x20F,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x311 },
  unicodeslot=0x20E,
 },
 {
  adobename="oinvertedbreve",
  category="ll",
  contextname="oinvertedbreve",
  description="LATIN SMALL LETTER O WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x311 },
  uccode=0x20E,
  unicodeslot=0x20F,
 },
 {
  adobename="Rdblgrave",
  category="lu",
  contextname="Rdoublegrave",
  description="LATIN CAPITAL LETTER R WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x211,
  linebreak="al",
  shcode=0x52,
  specials={ "char", 0x52, 0x30F },
  unicodeslot=0x210,
 },
 {
  adobename="rdblgrave",
  category="ll",
  contextname="rdoublegrave",
  description="LATIN SMALL LETTER R WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x72,
  specials={ "char", 0x72, 0x30F },
  uccode=0x210,
  unicodeslot=0x211,
 },
 {
  adobename="Rinvertedbreve",
  category="lu",
  contextname="Rinvertedbreve",
  description="LATIN CAPITAL LETTER R WITH INVERTED BREVE",
  direction="l",
  lccode=0x213,
  linebreak="al",
  shcode=0x52,
  specials={ "char", 0x52, 0x311 },
  unicodeslot=0x212,
 },
 {
  adobename="rinvertedbreve",
  category="ll",
  contextname="rinvertedbreve",
  description="LATIN SMALL LETTER R WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x72,
  specials={ "char", 0x72, 0x311 },
  uccode=0x212,
  unicodeslot=0x213,
 },
 {
  adobename="Udblgrave",
  category="lu",
  contextname="Udoublegrave",
  description="LATIN CAPITAL LETTER U WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x215,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x30F },
  unicodeslot=0x214,
 },
 {
  adobename="udblgrave",
  category="ll",
  contextname="udoublegrave",
  description="LATIN SMALL LETTER U WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x30F },
  uccode=0x214,
  unicodeslot=0x215,
 },
 {
  adobename="Uinvertedbreve",
  category="lu",
  contextname="Uinvertedbreve",
  description="LATIN CAPITAL LETTER U WITH INVERTED BREVE",
  direction="l",
  lccode=0x217,
  linebreak="al",
  shcode=0x55,
  specials={ "char", 0x55, 0x311 },
  unicodeslot=0x216,
 },
 {
  adobename="uinvertedbreve",
  category="ll",
  contextname="uinvertedbreve",
  description="LATIN SMALL LETTER U WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x75,
  specials={ "char", 0x75, 0x311 },
  uccode=0x216,
  unicodeslot=0x217,
 },
 {
  adobename="Scommaaccent",
  category="lu",
  contextname="Scommaaccent",
  description="LATIN CAPITAL LETTER S WITH COMMA BELOW",
  direction="l",
  lccode=0x219,
  linebreak="al",
  shcode=0x53,
  specials={ "char", 0x53, 0x326 },
  unicodeslot=0x218,
 },
 {
  adobename="scommaaccent",
  category="ll",
  contextname="scommaaccent",
  description="LATIN SMALL LETTER S WITH COMMA BELOW",
  direction="l",
  linebreak="al",
  shcode=0x73,
  specials={ "char", 0x73, 0x326 },
  uccode=0x218,
  unicodeslot=0x219,
 },
 {
  category="lu",
  contextname="Tcommaaccent",
  description="LATIN CAPITAL LETTER T WITH COMMA BELOW",
  direction="l",
  lccode=0x21B,
  linebreak="al",
  shcode=0x54,
  specials={ "char", 0x54, 0x326 },
  unicodeslot=0x21A,
 },
 {
  category="ll",
  contextname="tcommaaccent",
  description="LATIN SMALL LETTER T WITH COMMA BELOW",
  direction="l",
  linebreak="al",
  shcode=0x74,
  specials={ "char", 0x74, 0x326 },
  uccode=0x21A,
  unicodeslot=0x21B,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER YOGH",
  direction="l",
  lccode=0x21D,
  linebreak="al",
  unicodeslot=0x21C,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER YOGH",
  direction="l",
  linebreak="al",
  uccode=0x21C,
  unicodeslot=0x21D,
 },
 {
  category="lu",
  contextname="Hcaron",
  description="LATIN CAPITAL LETTER H WITH CARON",
  direction="l",
  lccode=0x21F,
  linebreak="al",
  shcode=0x48,
  specials={ "char", 0x48, 0x30C },
  unicodeslot=0x21E,
 },
 {
  category="ll",
  contextname="hcaron",
  description="LATIN SMALL LETTER H WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x68,
  specials={ "char", 0x68, 0x30C },
  uccode=0x21E,
  unicodeslot=0x21F,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER N WITH LONG RIGHT LEG",
  direction="l",
  lccode=0x19E,
  linebreak="al",
  shcode=0x4E,
  unicodeslot=0x220,
 },
 {
  category="ll",
  contextname="dcurl",
  description="LATIN SMALL LETTER D WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x64,
  unicodeslot=0x221,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER OU",
  direction="l",
  lccode=0x223,
  linebreak="al",
  unicodeslot=0x222,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER OU",
  direction="l",
  linebreak="al",
  uccode=0x222,
  unicodeslot=0x223,
 },
 {
  category="lu",
  contextname="Zhook",
  description="LATIN CAPITAL LETTER Z WITH HOOK",
  direction="l",
  lccode=0x225,
  linebreak="al",
  shcode=0x5A,
  unicodeslot=0x224,
 },
 {
  category="ll",
  contextname="zhook",
  description="LATIN SMALL LETTER Z WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x7A,
  uccode=0x224,
  unicodeslot=0x225,
 },
 {
  category="lu",
  contextname="Adotaccent",
  description="LATIN CAPITAL LETTER A WITH DOT ABOVE",
  direction="l",
  lccode=0x227,
  linebreak="al",
  shcode=0x41,
  specials={ "char", 0x41, 0x307 },
  unicodeslot=0x226,
 },
 {
  category="ll",
  contextname="adotaccent",
  description="LATIN SMALL LETTER A WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x61,
  specials={ "char", 0x61, 0x307 },
  uccode=0x226,
  unicodeslot=0x227,
 },
 {
  category="lu",
  contextname="Ecedilla",
  description="LATIN CAPITAL LETTER E WITH CEDILLA",
  direction="l",
  lccode=0x229,
  linebreak="al",
  shcode=0x45,
  specials={ "char", 0x45, 0x327 },
  unicodeslot=0x228,
 },
 {
  category="ll",
  contextname="ecedilla",
  description="LATIN SMALL LETTER E WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x65,
  specials={ "char", 0x65, 0x327 },
  uccode=0x228,
  unicodeslot=0x229,
 },
 {
  category="lu",
  contextname="Odiaeresismacron",
  description="LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON",
  direction="l",
  lccode=0x22B,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0xD6, 0x304 },
  unicodeslot=0x22A,
 },
 {
  category="ll",
  contextname="odiaeresismacron",
  description="LATIN SMALL LETTER O WITH DIAERESIS AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0xF6, 0x304 },
  uccode=0x22A,
  unicodeslot=0x22B,
 },
 {
  category="lu",
  contextname="Otildemacron",
  description="LATIN CAPITAL LETTER O WITH TILDE AND MACRON",
  direction="l",
  lccode=0x22D,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0xD5, 0x304 },
  unicodeslot=0x22C,
 },
 {
  category="ll",
  contextname="otildemacron",
  description="LATIN SMALL LETTER O WITH TILDE AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0xF5, 0x304 },
  uccode=0x22C,
  unicodeslot=0x22D,
 },
 {
  category="lu",
  contextname="Odotaccent",
  description="LATIN CAPITAL LETTER O WITH DOT ABOVE",
  direction="l",
  lccode=0x22F,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x4F, 0x307 },
  unicodeslot=0x22E,
 },
 {
  category="ll",
  contextname="odotaccent",
  description="LATIN SMALL LETTER O WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x6F, 0x307 },
  uccode=0x22E,
  unicodeslot=0x22F,
 },
 {
  category="lu",
  contextname="Odotaccentmacron",
  description="LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON",
  direction="l",
  lccode=0x231,
  linebreak="al",
  shcode=0x4F,
  specials={ "char", 0x22E, 0x304 },
  unicodeslot=0x230,
 },
 {
  category="ll",
  contextname="odotaccentmacron",
  description="LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x6F,
  specials={ "char", 0x22F, 0x304 },
  uccode=0x230,
  unicodeslot=0x231,
 },
 {
  category="lu",
  contextname="Ymacron",
  description="LATIN CAPITAL LETTER Y WITH MACRON",
  direction="l",
  lccode=0x233,
  linebreak="al",
  shcode=0x59,
  specials={ "char", 0x59, 0x304 },
  unicodeslot=0x232,
 },
 {
  category="ll",
  contextname="ymacron",
  description="LATIN SMALL LETTER Y WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x79,
  specials={ "char", 0x79, 0x304 },
  uccode=0x232,
  unicodeslot=0x233,
 },
 {
  category="ll",
  contextname="lcurl",
  description="LATIN SMALL LETTER L WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  unicodeslot=0x234,
 },
 {
  category="ll",
  contextname="ncurl",
  description="LATIN SMALL LETTER N WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x6E,
  unicodeslot=0x235,
 },
 {
  category="ll",
  contextname="tcurl",
  description="LATIN SMALL LETTER T WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x74,
  unicodeslot=0x236,
 },
 {
  category="ll",
  contextname="dotlessj",
  description="LATIN SMALL LETTER DOTLESS J",
  direction="l",
  linebreak="al",
  unicodeslot=0x237,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER DB DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x238,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER QP DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x239,
 },
 {
  category="lu",
  contextname="Astroke",
  description="LATIN CAPITAL LETTER A WITH STROKE",
  direction="l",
  lccode=0x2C65,
  linebreak="al",
  shcode=0x41,
  unicodeslot=0x23A,
 },
 {
  category="lu",
  contextname="Cstroke",
  description="LATIN CAPITAL LETTER C WITH STROKE",
  direction="l",
  lccode=0x23C,
  linebreak="al",
  shcode=0x43,
  unicodeslot=0x23B,
 },
 {
  category="ll",
  contextname="cstroke",
  description="LATIN SMALL LETTER C WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x63,
  uccode=0x23B,
  unicodeslot=0x23C,
 },
 {
  category="lu",
  contextname="Lbar",
  description="LATIN CAPITAL LETTER L WITH BAR",
  direction="l",
  lccode=0x19A,
  linebreak="al",
  shcode=0x4C,
  unicodeslot=0x23D,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER T WITH DIAGONAL STROKE",
  direction="l",
  lccode=0x2C66,
  linebreak="al",
  shcode=0x54,
  unicodeslot=0x23E,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER S WITH SWASH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x73,
  unicodeslot=0x23F,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER Z WITH SWASH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x7A,
  unicodeslot=0x240,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER GLOTTAL STOP",
  direction="l",
  lccode=0x242,
  linebreak="al",
  unicodeslot=0x241,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER GLOTTAL STOP",
  direction="l",
  linebreak="al",
  uccode=0x241,
  unicodeslot=0x242,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER B WITH STROKE",
  direction="l",
  lccode=0x180,
  linebreak="al",
  shcode=0x42,
  unicodeslot=0x243,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER U BAR",
  direction="l",
  lccode=0x289,
  linebreak="al",
  unicodeslot=0x244,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER TURNED V",
  direction="l",
  lccode=0x28C,
  linebreak="al",
  unicodeslot=0x245,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER E WITH STROKE",
  direction="l",
  lccode=0x247,
  linebreak="al",
  shcode=0x45,
  unicodeslot=0x246,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER E WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x65,
  uccode=0x246,
  unicodeslot=0x247,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER J WITH STROKE",
  direction="l",
  lccode=0x249,
  linebreak="al",
  shcode=0x4A,
  unicodeslot=0x248,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER J WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x6A,
  uccode=0x248,
  unicodeslot=0x249,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL",
  direction="l",
  lccode=0x24B,
  linebreak="al",
  unicodeslot=0x24A,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER Q WITH HOOK TAIL",
  direction="l",
  linebreak="al",
  shcode=0x71,
  uccode=0x24A,
  unicodeslot=0x24B,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER R WITH STROKE",
  direction="l",
  lccode=0x24D,
  linebreak="al",
  shcode=0x52,
  unicodeslot=0x24C,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER R WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x72,
  uccode=0x24C,
  unicodeslot=0x24D,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER Y WITH STROKE",
  direction="l",
  lccode=0x24F,
  linebreak="al",
  shcode=0x59,
  unicodeslot=0x24E,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER Y WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x79,
  uccode=0x24E,
  unicodeslot=0x24F,
 },
 {
  adobename="aturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED A",
  direction="l",
  linebreak="al",
  unicodeslot=0x250,
 },
 {
  adobename="ascript",
  category="ll",
  cjkwd="a",
  description="LATIN SMALL LETTER ALPHA",
  direction="l",
  linebreak="al",
  synonyms={ "latin small letter script a" },
  unicodeslot=0x251,
 },
 {
  adobename="ascriptturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED ALPHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x252,
 },
 {
  adobename="bhook",
  category="ll",
  contextname="bhook",
  description="LATIN SMALL LETTER B WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x62,
  uccode=0x181,
  unicodeslot=0x253,
 },
 {
  adobename="oopen",
  category="ll",
  description="LATIN SMALL LETTER OPEN O",
  direction="l",
  linebreak="al",
  uccode=0x186,
  unicodeslot=0x254,
 },
 {
  adobename="ccurl",
  category="ll",
  contextname="ccurl",
  description="LATIN SMALL LETTER C WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x63,
  unicodeslot=0x255,
 },
 {
  adobename="dtail",
  category="ll",
  contextname="dtail",
  description="LATIN SMALL LETTER D WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x64,
  synonyms={ "latin small letter d retroflex hook" },
  uccode=0x189,
  unicodeslot=0x256,
 },
 {
  adobename="dhook",
  category="ll",
  contextname="dhook",
  description="LATIN SMALL LETTER D WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x64,
  uccode=0x18A,
  unicodeslot=0x257,
 },
 {
  adobename="ereversed",
  category="ll",
  description="LATIN SMALL LETTER REVERSED E",
  direction="l",
  linebreak="al",
  unicodeslot=0x258,
 },
 {
  adobename="schwa",
  category="ll",
  contextname="schwa",
  description="LATIN SMALL LETTER SCHWA",
  direction="l",
  linebreak="al",
  uccode=0x18F,
  unicodeslot=0x259,
 },
 {
  adobename="schwahook",
  category="ll",
  contextname="schwahook",
  description="LATIN SMALL LETTER SCHWA WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x259,
  unicodeslot=0x25A,
 },
 {
  adobename="eopen",
  category="ll",
  description="LATIN SMALL LETTER OPEN E",
  direction="l",
  linebreak="al",
  synonyms={ "latin small letter epsilon" },
  uccode=0x190,
  unicodeslot=0x25B,
 },
 {
  adobename="eopenreversed",
  category="ll",
  description="LATIN SMALL LETTER REVERSED OPEN E",
  direction="l",
  linebreak="al",
  unicodeslot=0x25C,
 },
 {
  adobename="eopenreversedhook",
  category="ll",
  description="LATIN SMALL LETTER REVERSED OPEN E WITH HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x25D,
 },
 {
  adobename="eopenreversedclosed",
  category="ll",
  description="LATIN SMALL LETTER CLOSED REVERSED OPEN E",
  direction="l",
  linebreak="al",
  synonyms={ "latin small letter closed reversed epsilon" },
  unicodeslot=0x25E,
 },
 {
  adobename="jdotlessstroke",
  category="ll",
  contextname="dotlessjstroke",
  description="LATIN SMALL LETTER DOTLESS J WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x25F,
 },
 {
  adobename="ghook",
  category="ll",
  description="LATIN SMALL LETTER G WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x67,
  uccode=0x193,
  unicodeslot=0x260,
 },
 {
  adobename="gscript",
  category="ll",
  cjkwd="a",
  description="LATIN SMALL LETTER SCRIPT G",
  direction="l",
  linebreak="al",
  unicodeslot=0x261,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL G",
  direction="l",
  linebreak="al",
  unicodeslot=0x262,
 },
 {
  adobename="gammalatinsmall",
  category="ll",
  description="LATIN SMALL LETTER GAMMA",
  direction="l",
  linebreak="al",
  uccode=0x194,
  unicodeslot=0x263,
 },
 {
  adobename="ramshorn",
  category="ll",
  description="LATIN SMALL LETTER RAMS HORN",
  direction="l",
  linebreak="al",
  synonyms={ "latin small letter baby gamma" },
  unicodeslot=0x264,
 },
 {
  adobename="hturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED H",
  direction="l",
  linebreak="al",
  unicodeslot=0x265,
 },
 {
  adobename="hhook",
  category="ll",
  description="LATIN SMALL LETTER H WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x68,
  unicodeslot=0x266,
 },
 {
  adobename="henghook",
  category="ll",
  description="LATIN SMALL LETTER HENG WITH HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x267,
 },
 {
  adobename="istroke",
  category="ll",
  description="LATIN SMALL LETTER I WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x69,
  uccode=0x197,
  unicodeslot=0x268,
 },
 {
  adobename="iotalatin",
  category="ll",
  description="LATIN SMALL LETTER IOTA",
  direction="l",
  linebreak="al",
  uccode=0x196,
  unicodeslot=0x269,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL I",
  direction="l",
  linebreak="al",
  unicodeslot=0x26A,
 },
 {
  adobename="lmiddletilde",
  category="ll",
  description="LATIN SMALL LETTER L WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  uccode=0x2C62,
  unicodeslot=0x26B,
 },
 {
  adobename="lbelt",
  category="ll",
  description="LATIN SMALL LETTER L WITH BELT",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  unicodeslot=0x26C,
 },
 {
  adobename="lhookretroflex",
  category="ll",
  description="LATIN SMALL LETTER L WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x6C,
  unicodeslot=0x26D,
 },
 {
  adobename="lezh",
  category="ll",
  description="LATIN SMALL LETTER LEZH",
  direction="l",
  linebreak="al",
  unicodeslot=0x26E,
 },
 {
  adobename="mturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED M",
  direction="l",
  linebreak="al",
  uccode=0x19C,
  unicodeslot=0x26F,
 },
 {
  adobename="mlonglegturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED M WITH LONG LEG",
  direction="l",
  linebreak="al",
  unicodeslot=0x270,
 },
 {
  adobename="mhook",
  category="ll",
  description="LATIN SMALL LETTER M WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x6D,
  unicodeslot=0x271,
 },
 {
  adobename="nhookleft",
  category="ll",
  description="LATIN SMALL LETTER N WITH LEFT HOOK",
  direction="l",
  linebreak="al",
  shcode=0x6E,
  uccode=0x19D,
  unicodeslot=0x272,
 },
 {
  adobename="nhookretroflex",
  category="ll",
  description="LATIN SMALL LETTER N WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x6E,
  unicodeslot=0x273,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL N",
  direction="l",
  linebreak="al",
  unicodeslot=0x274,
 },
 {
  adobename="obarred",
  category="ll",
  description="LATIN SMALL LETTER BARRED O",
  direction="l",
  linebreak="al",
  synonyms={ "latin small letter o bar" },
  uccode=0x19F,
  unicodeslot=0x275,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x276,
 },
 {
  adobename="omegalatinclosed",
  category="ll",
  description="LATIN SMALL LETTER CLOSED OMEGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x277,
 },
 {
  adobename="philatin",
  category="ll",
  description="LATIN SMALL LETTER PHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x278,
 },
 {
  adobename="rturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED R",
  direction="l",
  linebreak="al",
  unicodeslot=0x279,
 },
 {
  adobename="rlonglegturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED R WITH LONG LEG",
  direction="l",
  linebreak="al",
  unicodeslot=0x27A,
 },
 {
  adobename="rhookturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED R WITH HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x27B,
 },
 {
  adobename="rlongleg",
  category="ll",
  description="LATIN SMALL LETTER R WITH LONG LEG",
  direction="l",
  linebreak="al",
  shcode=0x72,
  unicodeslot=0x27C,
 },
 {
  adobename="rhook",
  category="ll",
  description="LATIN SMALL LETTER R WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x72,
  uccode=0x2C64,
  unicodeslot=0x27D,
 },
 {
  adobename="rfishhook",
  category="ll",
  description="LATIN SMALL LETTER R WITH FISHHOOK",
  direction="l",
  linebreak="al",
  shcode=0x72,
  unicodeslot=0x27E,
 },
 {
  adobename="rfishhookreversed",
  category="ll",
  description="LATIN SMALL LETTER REVERSED R WITH FISHHOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x27F,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL R",
  direction="l",
  linebreak="al",
  uccode=0x1A6,
  unicodeslot=0x280,
 },
 {
  adobename="Rsmallinverted",
  category="ll",
  description="LATIN LETTER SMALL CAPITAL INVERTED R",
  direction="l",
  linebreak="al",
  unicodeslot=0x281,
 },
 {
  adobename="shook",
  category="ll",
  description="LATIN SMALL LETTER S WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x73,
  unicodeslot=0x282,
 },
 {
  adobename="esh",
  category="ll",
  description="LATIN SMALL LETTER ESH",
  direction="l",
  linebreak="al",
  uccode=0x1A9,
  unicodeslot=0x283,
 },
 {
  adobename="dotlessjstrokehook",
  category="ll",
  description="LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x284,
 },
 {
  adobename="eshsquatreversed",
  category="ll",
  description="LATIN SMALL LETTER SQUAT REVERSED ESH",
  direction="l",
  linebreak="al",
  unicodeslot=0x285,
 },
 {
  adobename="eshcurl",
  category="ll",
  description="LATIN SMALL LETTER ESH WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x283,
  unicodeslot=0x286,
 },
 {
  adobename="tturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED T",
  direction="l",
  linebreak="al",
  unicodeslot=0x287,
 },
 {
  adobename="tretroflexhook",
  category="ll",
  description="LATIN SMALL LETTER T WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x74,
  uccode=0x1AE,
  unicodeslot=0x288,
 },
 {
  adobename="ubar",
  category="ll",
  description="LATIN SMALL LETTER U BAR",
  direction="l",
  linebreak="al",
  uccode=0x244,
  unicodeslot=0x289,
 },
 {
  adobename="upsilonlatin",
  category="ll",
  description="LATIN SMALL LETTER UPSILON",
  direction="l",
  linebreak="al",
  uccode=0x1B1,
  unicodeslot=0x28A,
 },
 {
  adobename="vhook",
  category="ll",
  description="LATIN SMALL LETTER V WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x76,
  synonyms={ "latin small letter script v" },
  uccode=0x1B2,
  unicodeslot=0x28B,
 },
 {
  adobename="vturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED V",
  direction="l",
  linebreak="al",
  synonyms={ "caret" },
  uccode=0x245,
  unicodeslot=0x28C,
 },
 {
  adobename="wturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED W",
  direction="l",
  linebreak="al",
  unicodeslot=0x28D,
 },
 {
  adobename="yturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x28E,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x28F,
 },
 {
  adobename="zretroflexhook",
  category="ll",
  description="LATIN SMALL LETTER Z WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x7A,
  unicodeslot=0x290,
 },
 {
  adobename="zcurl",
  category="ll",
  description="LATIN SMALL LETTER Z WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x7A,
  unicodeslot=0x291,
 },
 {
  adobename="ezh",
  category="ll",
  description="LATIN SMALL LETTER EZH",
  direction="l",
  linebreak="al",
  synonyms={ "dram" },
  uccode=0x1B7,
  unicodeslot=0x292,
 },
 {
  adobename="ezhcurl",
  category="ll",
  description="LATIN SMALL LETTER EZH WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x292,
  unicodeslot=0x293,
 },
 {
  adobename="glottalstop",
  category="lo",
  description="LATIN LETTER GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x294,
 },
 {
  adobename="glottalstopreversed",
  category="ll",
  description="LATIN LETTER PHARYNGEAL VOICED FRICATIVE",
  direction="l",
  linebreak="al",
  synonyms={ "latin letter reversed glottal stop" },
  unicodeslot=0x295,
 },
 {
  adobename="glottalstopinverted",
  category="ll",
  description="LATIN LETTER INVERTED GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x296,
 },
 {
  adobename="cstretched",
  category="ll",
  description="LATIN LETTER STRETCHED C",
  direction="l",
  linebreak="al",
  unicodeslot=0x297,
 },
 {
  adobename="bilabialclick",
  category="ll",
  description="LATIN LETTER BILABIAL CLICK",
  direction="l",
  linebreak="al",
  synonyms={ "latin letter bullseye" },
  unicodeslot=0x298,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL B",
  direction="l",
  linebreak="al",
  unicodeslot=0x299,
 },
 {
  adobename="eopenclosed",
  category="ll",
  description="LATIN SMALL LETTER CLOSED OPEN E",
  direction="l",
  linebreak="al",
  synonyms={ "latin small letter closed epsilon" },
  unicodeslot=0x29A,
 },
 {
  adobename="Gsmallhook",
  category="ll",
  description="LATIN LETTER SMALL CAPITAL G WITH HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x29B,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL H",
  direction="l",
  linebreak="al",
  unicodeslot=0x29C,
 },
 {
  adobename="jcrossedtail",
  category="ll",
  description="LATIN SMALL LETTER J WITH CROSSED-TAIL",
  direction="l",
  linebreak="al",
  shcode=0x6A,
  unicodeslot=0x29D,
 },
 {
  adobename="kturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED K",
  direction="l",
  linebreak="al",
  unicodeslot=0x29E,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL L",
  direction="l",
  linebreak="al",
  unicodeslot=0x29F,
 },
 {
  adobename="qhook",
  category="ll",
  description="LATIN SMALL LETTER Q WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x71,
  unicodeslot=0x2A0,
 },
 {
  adobename="glottalstopstroke",
  category="ll",
  description="LATIN LETTER GLOTTAL STOP WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x2A1,
 },
 {
  adobename="glottalstopstrokereversed",
  category="ll",
  description="LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x2A2,
 },
 {
  adobename="dzaltone",
  category="ll",
  description="LATIN SMALL LETTER DZ DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x2A3,
 },
 {
  adobename="dezh",
  category="ll",
  description="LATIN SMALL LETTER DEZH DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x2A4,
 },
 {
  adobename="dzcurl",
  category="ll",
  description="LATIN SMALL LETTER DZ DIGRAPH WITH CURL",
  direction="l",
  linebreak="al",
  unicodeslot=0x2A5,
 },
 {
  adobename="ts",
  category="ll",
  description="LATIN SMALL LETTER TS DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x2A6,
 },
 {
  adobename="tesh",
  category="ll",
  description="LATIN SMALL LETTER TESH DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x2A7,
 },
 {
  adobename="tccurl",
  category="ll",
  description="LATIN SMALL LETTER TC DIGRAPH WITH CURL",
  direction="l",
  linebreak="al",
  unicodeslot=0x2A8,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER FENG DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x2A9,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER LS DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x2AA,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER LZ DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x2AB,
 },
 {
  category="ll",
  description="LATIN LETTER BILABIAL PERCUSSIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x2AC,
 },
 {
  category="ll",
  description="LATIN LETTER BIDENTAL PERCUSSIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x2AD,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER TURNED H WITH FISHHOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x2AE,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x2AF,
 },
 {
  adobename="hsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL H",
  direction="l",
  linebreak="al",
  specials={ "super", 0x68 },
  unicodeslot=0x2B0,
 },
 {
  adobename="hhooksuperior",
  category="lm",
  description="MODIFIER LETTER SMALL H WITH HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x266 },
  unicodeslot=0x2B1,
 },
 {
  adobename="jsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL J",
  direction="l",
  linebreak="al",
  specials={ "super", 0x6A },
  unicodeslot=0x2B2,
 },
 {
  category="lm",
  description="MODIFIER LETTER SMALL R",
  direction="l",
  linebreak="al",
  specials={ "super", 0x72 },
  unicodeslot=0x2B3,
 },
 {
  adobename="rturnedsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL TURNED R",
  direction="l",
  linebreak="al",
  specials={ "super", 0x279 },
  unicodeslot=0x2B4,
 },
 {
  adobename="rhookturnedsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL TURNED R WITH HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x27B },
  unicodeslot=0x2B5,
 },
 {
  adobename="Rsmallinvertedsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL CAPITAL INVERTED R",
  direction="l",
  linebreak="al",
  specials={ "super", 0x281 },
  unicodeslot=0x2B6,
 },
 {
  adobename="wsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL W",
  direction="l",
  linebreak="al",
  specials={ "super", 0x77 },
  unicodeslot=0x2B7,
 },
 {
  adobename="ysuperior",
  category="lm",
  description="MODIFIER LETTER SMALL Y",
  direction="l",
  linebreak="al",
  specials={ "super", 0x79 },
  unicodeslot=0x2B8,
 },
 {
  adobename="primemod",
  category="lm",
  description="MODIFIER LETTER PRIME",
  direction="on",
  linebreak="al",
  unicodeslot=0x2B9,
 },
 {
  adobename="dblprimemod",
  category="lm",
  description="MODIFIER LETTER DOUBLE PRIME",
  direction="on",
  linebreak="al",
  unicodeslot=0x2BA,
 },
 {
  adobename="commaturnedmod",
  category="lm",
  description="MODIFIER LETTER TURNED COMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x2BB,
 },
 {
  adobename="apostrophemod",
  category="lm",
  description="MODIFIER LETTER APOSTROPHE",
  direction="l",
  linebreak="al",
  synonyms={ "glottal stop", "neutral apostrophe" },
  unicodeslot=0x2BC,
 },
 {
  adobename="commareversedmod",
  category="lm",
  description="MODIFIER LETTER REVERSED COMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x2BD,
 },
 {
  adobename="ringhalfright",
  category="lm",
  description="MODIFIER LETTER RIGHT HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x2BE,
 },
 {
  adobename="ringhalfleft",
  category="lm",
  description="MODIFIER LETTER LEFT HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x2BF,
 },
 {
  adobename="glottalstopmod",
  category="lm",
  description="MODIFIER LETTER GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x2C0,
 },
 {
  adobename="glottalstopreversedmod",
  category="lm",
  description="MODIFIER LETTER REVERSED GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x2C1,
 },
 {
  adobename="arrowheadleftmod",
  category="sk",
  description="MODIFIER LETTER LEFT ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x2C2,
 },
 {
  adobename="arrowheadrightmod",
  category="sk",
  description="MODIFIER LETTER RIGHT ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x2C3,
 },
 {
  adobename="arrowheadupmod",
  category="sk",
  cjkwd="a",
  description="MODIFIER LETTER UP ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x2C4,
 },
 {
  adobename="arrowheaddownmod",
  category="sk",
  description="MODIFIER LETTER DOWN ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x2C5,
 },
 {
  adobename="circumflex",
  category="lm",
  comment="check special",
  contextname="textcircumflex",
  description="MODIFIER LETTER CIRCUMFLEX ACCENT",
  direction="on",
  linebreak="al",
  mathclass="topaccent",
  mathname="hat",
  specials={ "compat", 0x20, 0x302 },
  unicodeslot=0x2C6,
 },
 {
  adobename="caron",
  category="lm",
  cjkwd="a",
  comment="check special",
  contextname="textcaron",
  description="CARON",
  direction="on",
  linebreak="ai",
  mathclass="topaccent",
  mathname="check",
  specials={ "compat", 0x20, 0x30C },
  synonyms={ "mandarin chinese third tone", "modifier letter hacek" },
  unicodeslot=0x2C7,
 },
 {
  adobename="verticallinemod",
  category="lm",
  description="MODIFIER LETTER VERTICAL LINE",
  direction="on",
  linebreak="bb",
  unicodeslot=0x2C8,
 },
 {
  adobename="firsttonechinese",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER MACRON",
  direction="on",
  linebreak="ai",
  synonyms={ "mandarin chinese first tone" },
  unicodeslot=0x2C9,
 },
 {
  adobename="secondtonechinese",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER ACUTE ACCENT",
  direction="on",
  linebreak="ai",
  synonyms={ "mandarin chinese second tone" },
  unicodeslot=0x2CA,
 },
 {
  adobename="fourthtonechinese",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER GRAVE ACCENT",
  direction="on",
  linebreak="ai",
  synonyms={ "mandarin chinese fourth tone" },
  unicodeslot=0x2CB,
 },
 {
  adobename="verticallinelowmod",
  category="lm",
  description="MODIFIER LETTER LOW VERTICAL LINE",
  direction="on",
  linebreak="bb",
  unicodeslot=0x2CC,
 },
 {
  adobename="macronlowmod",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER LOW MACRON",
  direction="on",
  linebreak="ai",
  unicodeslot=0x2CD,
 },
 {
  adobename="gravelowmod",
  category="lm",
  description="MODIFIER LETTER LOW GRAVE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x2CE,
 },
 {
  adobename="acutelowmod",
  category="lm",
  description="MODIFIER LETTER LOW ACUTE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x2CF,
 },
 {
  adobename="colontriangularmod",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER TRIANGULAR COLON",
  direction="l",
  linebreak="ai",
  unicodeslot=0x2D0,
 },
 {
  adobename="colontriangularhalfmod",
  category="lm",
  description="MODIFIER LETTER HALF TRIANGULAR COLON",
  direction="l",
  linebreak="al",
  unicodeslot=0x2D1,
 },
 {
  adobename="ringhalfrightcentered",
  category="sk",
  description="MODIFIER LETTER CENTRED RIGHT HALF RING",
  direction="on",
  linebreak="al",
  unicodeslot=0x2D2,
 },
 {
  adobename="ringhalfleftcentered",
  category="sk",
  description="MODIFIER LETTER CENTRED LEFT HALF RING",
  direction="on",
  linebreak="al",
  unicodeslot=0x2D3,
 },
 {
  adobename="uptackmod",
  category="sk",
  description="MODIFIER LETTER UP TACK",
  direction="on",
  linebreak="al",
  unicodeslot=0x2D4,
 },
 {
  adobename="downtackmod",
  category="sk",
  description="MODIFIER LETTER DOWN TACK",
  direction="on",
  linebreak="al",
  unicodeslot=0x2D5,
 },
 {
  adobename="plusmod",
  category="sk",
  description="MODIFIER LETTER PLUS SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x2D6,
 },
 {
  adobename="minusmod",
  category="sk",
  description="MODIFIER LETTER MINUS SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x2D7,
 },
 {
  adobename="breve",
  category="sk",
  cjkwd="a",
  contextname="textbreve",
  description="BREVE",
  direction="on",
  linebreak="ai",
  mathclass="topaccent",
  mathname="breve",
  specials={ "compat", 0x20, 0x306 },
  unicodeslot=0x2D8,
 },
 {
  adobename="dotaccent",
  category="sk",
  cjkwd="a",
  contextname="textdotaccent",
  description="DOT ABOVE",
  direction="on",
  linebreak="ai",
  mathclass="topaccent",
  mathname="dot",
  specials={ "compat", 0x20, 0x307 },
  synonyms={ "mandarin chinese fifth or neutral tone" },
  unicodeslot=0x2D9,
 },
 {
  adobename="ring",
  category="sk",
  cjkwd="a",
  contextname="textring",
  description="RING ABOVE",
  direction="on",
  linebreak="ai",
  mathclass="topaccent",
  mathname="ring",
  specials={ "compat", 0x20, 0x30A },
  unicodeslot=0x2DA,
 },
 {
  adobename="ogonek",
  category="sk",
  cjkwd="a",
  contextname="textogonek",
  description="OGONEK",
  direction="on",
  linebreak="ai",
  specials={ "compat", 0x20, 0x328 },
  unicodeslot=0x2DB,
 },
 {
  adobename="tilde",
  category="sk",
  contextname="texttilde",
  description="SMALL TILDE",
  direction="on",
  linebreak="al",
  mathclass="topaccent",
  mathname="tilde",
  specials={ "compat", 0x20, 0x303 },
  unicodeslot=0x2DC,
 },
 {
  adobename="hungarumlaut",
  category="sk",
  cjkwd="a",
  contextname="texthungarumlaut",
  description="DOUBLE ACUTE ACCENT",
  direction="on",
  linebreak="ai",
  specials={ "compat", 0x20, 0x30B },
  unicodeslot=0x2DD,
 },
 {
  adobename="rhotichookmod",
  category="sk",
  description="MODIFIER LETTER RHOTIC HOOK",
  direction="on",
  linebreak="al",
  unicodeslot=0x2DE,
 },
 {
  category="sk",
  cjkwd="a",
  description="MODIFIER LETTER CROSS ACCENT",
  direction="on",
  linebreak="bb",
  synonyms={ "swedish grave accent" },
  unicodeslot=0x2DF,
 },
 {
  adobename="gammasuperior",
  category="lm",
  description="MODIFIER LETTER SMALL GAMMA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x263 },
  unicodeslot=0x2E0,
 },
 {
  category="lm",
  description="MODIFIER LETTER SMALL L",
  direction="l",
  linebreak="al",
  specials={ "super", 0x6C },
  unicodeslot=0x2E1,
 },
 {
  category="lm",
  description="MODIFIER LETTER SMALL S",
  direction="l",
  linebreak="al",
  specials={ "super", 0x73 },
  unicodeslot=0x2E2,
 },
 {
  adobename="xsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL X",
  direction="l",
  linebreak="al",
  specials={ "super", 0x78 },
  unicodeslot=0x2E3,
 },
 {
  adobename="glottalstopreversedsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL REVERSED GLOTTAL STOP",
  direction="l",
  linebreak="al",
  specials={ "super", 0x295 },
  unicodeslot=0x2E4,
 },
 {
  adobename="tonebarextrahighmod",
  category="sk",
  description="MODIFIER LETTER EXTRA-HIGH TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x2E5,
 },
 {
  adobename="tonebarhighmod",
  category="sk",
  description="MODIFIER LETTER HIGH TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x2E6,
 },
 {
  adobename="tonebarmidmod",
  category="sk",
  description="MODIFIER LETTER MID TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x2E7,
 },
 {
  adobename="tonebarlowmod",
  category="sk",
  description="MODIFIER LETTER LOW TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x2E8,
 },
 {
  adobename="tonebarextralowmod",
  category="sk",
  description="MODIFIER LETTER EXTRA-LOW TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x2E9,
 },
 {
  category="sk",
  description="MODIFIER LETTER YIN DEPARTING TONE MARK",
  direction="on",
  linebreak="al",
  unicodeslot=0x2EA,
 },
 {
  category="sk",
  description="MODIFIER LETTER YANG DEPARTING TONE MARK",
  direction="on",
  linebreak="al",
  unicodeslot=0x2EB,
 },
 {
  category="sk",
  description="MODIFIER LETTER VOICING",
  direction="on",
  linebreak="al",
  unicodeslot=0x2EC,
 },
 {
  category="sk",
  description="MODIFIER LETTER UNASPIRATED",
  direction="on",
  linebreak="al",
  unicodeslot=0x2ED,
 },
 {
  category="lm",
  description="MODIFIER LETTER DOUBLE APOSTROPHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x2EE,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW DOWN ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x2EF,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW UP ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F0,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW LEFT ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F1,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW RIGHT ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F2,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW RING",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F3,
 },
 {
  category="sk",
  description="MODIFIER LETTER MIDDLE GRAVE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F4,
 },
 {
  category="sk",
  description="MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F5,
 },
 {
  category="sk",
  description="MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F6,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW TILDE",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F7,
 },
 {
  category="sk",
  description="MODIFIER LETTER RAISED COLON",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F8,
 },
 {
  category="sk",
  description="MODIFIER LETTER BEGIN HIGH TONE",
  direction="on",
  linebreak="al",
  unicodeslot=0x2F9,
 },
 {
  category="sk",
  description="MODIFIER LETTER END HIGH TONE",
  direction="on",
  linebreak="al",
  unicodeslot=0x2FA,
 },
 {
  category="sk",
  description="MODIFIER LETTER BEGIN LOW TONE",
  direction="on",
  linebreak="al",
  unicodeslot=0x2FB,
 },
 {
  category="sk",
  description="MODIFIER LETTER END LOW TONE",
  direction="on",
  linebreak="al",
  unicodeslot=0x2FC,
 },
 {
  category="sk",
  description="MODIFIER LETTER SHELF",
  direction="on",
  linebreak="al",
  unicodeslot=0x2FD,
 },
 {
  category="sk",
  description="MODIFIER LETTER OPEN SHELF",
  direction="on",
  linebreak="al",
  unicodeslot=0x2FE,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW LEFT ARROW",
  direction="on",
  linebreak="al",
  unicodeslot=0x2FF,
 },
 {
  adobename="gravecomb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING GRAVE ACCENT",
  direction="nsm",
  linebreak="cm",
  synonyms={ "greek varia" },
  unicodeslot=0x300,
 },
 {
  adobename="acutecomb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING ACUTE ACCENT",
  direction="nsm",
  linebreak="cm",
  synonyms={ "greek oxia", "greek tonos", "stress mark" },
  unicodeslot=0x301,
 },
 {
  adobename="circumflexcmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING CIRCUMFLEX ACCENT",
  direction="nsm",
  linebreak="cm",
  mathclass="topaccent",
  mathname="widehat",
  mathstretch="h",
  unicodeslot=0x302,
 },
 {
  adobename="tildecomb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING TILDE",
  direction="nsm",
  linebreak="cm",
  mathclass="topaccent",
  mathname="widetilde",
  mathstretch="h",
  unicodeslot=0x303,
 },
 {
  adobename="macroncmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING MACRON",
  direction="nsm",
  linebreak="cm",
  synonyms={ "long" },
  unicodeslot=0x304,
 },
 {
  adobename="overlinecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING OVERLINE",
  direction="nsm",
  linebreak="cm",
  synonyms={ "overscore", "vinculum" },
  unicodeslot=0x305,
 },
 {
  adobename="brevecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING BREVE",
  direction="nsm",
  linebreak="cm",
  synonyms={ "greek vrachy", "short" },
  unicodeslot=0x306,
 },
 {
  adobename="dotaccentcmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING DOT ABOVE",
  direction="nsm",
  linebreak="cm",
  synonyms={ "derivative" },
  unicodeslot=0x307,
 },
 {
  adobename="dieresiscmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING DIAERESIS",
  direction="nsm",
  linebreak="cm",
  synonyms={ "double derivative", "double dot above", "greek dialytika", "umlaut" },
  unicodeslot=0x308,
 },
 {
  adobename="hookcmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING HOOK ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x309,
 },
 {
  adobename="ringcmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING RING ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x30A,
 },
 {
  adobename="hungarumlautcmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING DOUBLE ACUTE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x30B,
 },
 {
  adobename="caroncmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING CARON",
  direction="nsm",
  linebreak="cm",
  synonyms={ "combining hacek", "v above" },
  unicodeslot=0x30C,
 },
 {
  adobename="verticallineabovecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING VERTICAL LINE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x30D,
 },
 {
  adobename="dblverticallineabovecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING DOUBLE VERTICAL LINE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x30E,
 },
 {
  adobename="dblgravecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING DOUBLE GRAVE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x30F,
 },
 {
  adobename="candrabinducmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING CANDRABINDU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x310,
 },
 {
  adobename="breveinvertedcmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING INVERTED BREVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x311,
 },
 {
  adobename="commaturnedabovecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING TURNED COMMA ABOVE",
  direction="nsm",
  linebreak="cm",
  synonyms={ "cedilla above" },
  unicodeslot=0x312,
 },
 {
  adobename="commaabovecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING COMMA ABOVE",
  direction="nsm",
  linebreak="cm",
  synonyms={ "greek psili", "greek smooth breathing mark" },
  unicodeslot=0x313,
 },
 {
  adobename="commareversedabovecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING REVERSED COMMA ABOVE",
  direction="nsm",
  linebreak="cm",
  synonyms={ "greek dasia", "greek rough breathing mark" },
  unicodeslot=0x314,
 },
 {
  adobename="commaaboverightcmb",
  category="mn",
  cjkwd="a",
  combining=0xE8,
  description="COMBINING COMMA ABOVE RIGHT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x315,
 },
 {
  adobename="gravebelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING GRAVE ACCENT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x316,
 },
 {
  adobename="acutebelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING ACUTE ACCENT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x317,
 },
 {
  adobename="lefttackbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING LEFT TACK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x318,
 },
 {
  adobename="righttackbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING RIGHT TACK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x319,
 },
 {
  adobename="leftangleabovecmb",
  category="mn",
  cjkwd="a",
  combining=0xE8,
  description="COMBINING LEFT ANGLE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x31A,
 },
 {
  adobename="horncmb",
  category="mn",
  cjkwd="a",
  combining=0xD8,
  description="COMBINING HORN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x31B,
 },
 {
  adobename="ringhalfleftbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING LEFT HALF RING BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x31C,
 },
 {
  adobename="uptackbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING UP TACK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x31D,
 },
 {
  adobename="downtackbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING DOWN TACK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x31E,
 },
 {
  adobename="plusbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING PLUS SIGN BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x31F,
 },
 {
  adobename="minusbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING MINUS SIGN BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x320,
 },
 {
  adobename="hookpalatalizedbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xCA,
  description="COMBINING PALATALIZED HOOK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x321,
 },
 {
  adobename="hookretroflexbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xCA,
  description="COMBINING RETROFLEX HOOK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x322,
 },
 {
  adobename="dotbelowcomb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  contextname="textbottomdot",
  description="COMBINING DOT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x323,
 },
 {
  adobename="dieresisbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING DIAERESIS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x324,
 },
 {
  adobename="ringbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING RING BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x325,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  contextname="textbottomcomma",
  description="COMBINING COMMA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x326,
 },
 {
  adobename="cedillacmb",
  category="mn",
  cjkwd="a",
  combining=0xCA,
  description="COMBINING CEDILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x327,
 },
 {
  adobename="ogonekcmb",
  category="mn",
  cjkwd="a",
  combining=0xCA,
  description="COMBINING OGONEK",
  direction="nsm",
  linebreak="cm",
  synonyms={ "nasal hook" },
  unicodeslot=0x328,
 },
 {
  adobename="verticallinebelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING VERTICAL LINE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x329,
 },
 {
  adobename="bridgebelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING BRIDGE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x32A,
 },
 {
  adobename="dblarchinvertedbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING INVERTED DOUBLE ARCH BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x32B,
 },
 {
  adobename="caronbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING CARON BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x32C,
 },
 {
  adobename="circumflexbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING CIRCUMFLEX ACCENT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x32D,
 },
 {
  adobename="brevebelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING BREVE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x32E,
 },
 {
  adobename="breveinvertedbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING INVERTED BREVE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x32F,
 },
 {
  adobename="tildebelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING TILDE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x330,
 },
 {
  adobename="macronbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING MACRON BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x331,
 },
 {
  adobename="lowlinecmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING LOW LINE",
  direction="nsm",
  linebreak="cm",
  synonyms={ "underline", "underscore" },
  unicodeslot=0x332,
 },
 {
  adobename="dbllowlinecmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING DOUBLE LOW LINE",
  direction="nsm",
  linebreak="cm",
  synonyms={ "double underline", "double underscore" },
  unicodeslot=0x333,
 },
 {
  adobename="tildeoverlaycmb",
  category="mn",
  cjkwd="a",
  combining=0x1,
  description="COMBINING TILDE OVERLAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x334,
 },
 {
  adobename="strokeshortoverlaycmb",
  category="mn",
  cjkwd="a",
  combining=0x1,
  description="COMBINING SHORT STROKE OVERLAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x335,
 },
 {
  adobename="strokelongoverlaycmb",
  category="mn",
  cjkwd="a",
  combining=0x1,
  description="COMBINING LONG STROKE OVERLAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x336,
 },
 {
  adobename="solidusshortoverlaycmb",
  category="mn",
  cjkwd="a",
  combining=0x1,
  description="COMBINING SHORT SOLIDUS OVERLAY",
  direction="nsm",
  linebreak="cm",
  synonyms={ "short slash overlay" },
  unicodeslot=0x337,
 },
 {
  adobename="soliduslongoverlaycmb",
  category="mn",
  cjkwd="a",
  combining=0x1,
  description="COMBINING LONG SOLIDUS OVERLAY",
  direction="nsm",
  linebreak="cm",
  mathclass="relation",
  mathname="not",
  synonyms={ "long slash overlay" },
  unicodeslot=0x338,
 },
 {
  adobename="ringhalfrightbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING RIGHT HALF RING BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x339,
 },
 {
  adobename="bridgeinvertedbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING INVERTED BRIDGE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x33A,
 },
 {
  adobename="squarebelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING SQUARE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x33B,
 },
 {
  adobename="seagullbelowcmb",
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING SEAGULL BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x33C,
 },
 {
  adobename="xabovecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING X ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x33D,
 },
 {
  adobename="tildeverticalcmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING VERTICAL TILDE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x33E,
 },
 {
  adobename="dbloverlinecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING DOUBLE OVERLINE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x33F,
 },
 {
  adobename="gravetonecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING GRAVE TONE MARK",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x300 },
  unicodeslot=0x340,
 },
 {
  adobename="acutetonecmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING ACUTE TONE MARK",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x301 },
  unicodeslot=0x341,
 },
 {
  adobename="perispomenigreekcmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING GREEK PERISPOMENI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x342,
 },
 {
  adobename="koroniscmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING GREEK KORONIS",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x313 },
  unicodeslot=0x343,
 },
 {
  adobename="dialytikatonoscmb",
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING GREEK DIALYTIKA TONOS",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x308, 0x301 },
  unicodeslot=0x344,
 },
 {
  adobename="ypogegrammenigreekcmb",
  category="mn",
  cjkwd="a",
  combining=0xF0,
  description="COMBINING GREEK YPOGEGRAMMENI",
  direction="nsm",
  linebreak="cm",
  synonyms={ "greek iota subscript", "greek non-spacing iota below" },
  uccode=0x399,
  unicodeslot=0x345,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING BRIDGE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x346,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING EQUALS SIGN BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x347,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING DOUBLE VERTICAL LINE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x348,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING LEFT ANGLE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x349,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING NOT TILDE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x34A,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING HOMOTHETIC ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x34B,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING ALMOST EQUAL TO ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x34C,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING LEFT RIGHT ARROW BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x34D,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING UPWARDS ARROW BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x34E,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING GRAPHEME JOINER",
  direction="nsm",
  linebreak="gl",
  synonyms={ "cgj" },
  unicodeslot=0x34F,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING RIGHT ARROWHEAD ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x350,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LEFT HALF RING ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x351,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING FERMATA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x352,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING X BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x353,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING LEFT ARROWHEAD BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x354,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING RIGHT ARROWHEAD BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x355,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x356,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING RIGHT HALF RING ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x357,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE8,
  description="COMBINING DOT ABOVE RIGHT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x358,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING ASTERISK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x359,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xDC,
  description="COMBINING DOUBLE RING BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x35A,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING ZIGZAG ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x35B,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE9,
  description="COMBINING DOUBLE BREVE BELOW",
  direction="nsm",
  linebreak="gl",
  synonyms={ "ligature tie below", "papyrological hyphen" },
  unicodeslot=0x35C,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xEA,
  description="COMBINING DOUBLE BREVE",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x35D,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xEA,
  description="COMBINING DOUBLE MACRON",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x35E,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE9,
  description="COMBINING DOUBLE MACRON BELOW",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x35F,
 },
 {
  adobename="tildedoublecmb",
  category="mn",
  cjkwd="a",
  combining=0xEA,
  description="COMBINING DOUBLE TILDE",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x360,
 },
 {
  adobename="breveinverteddoublecmb",
  category="mn",
  cjkwd="a",
  combining=0xEA,
  description="COMBINING DOUBLE INVERTED BREVE",
  direction="nsm",
  linebreak="gl",
  synonyms={ "ligature tie" },
  unicodeslot=0x361,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE9,
  description="COMBINING DOUBLE RIGHTWARDS ARROW BELOW",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x362,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x363,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x364,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x365,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x366,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x367,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER C",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x368,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER D",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x369,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER H",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x36A,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER M",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x36B,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x36C,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER T",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x36D,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER V",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x36E,
 },
 {
  category="mn",
  cjkwd="a",
  combining=0xE6,
  description="COMBINING LATIN SMALL LETTER X",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x36F,
 },
 {
  category="lu",
  description="GREEK CAPITAL LETTER HETA",
  direction="l",
  linebreak="al",
  unicodeslot=0x370,
 },
 {
  category="ll",
  description="GREEK SMALL LETTER HETA",
  direction="l",
  linebreak="al",
  unicodeslot=0x371,
 },
 {
  category="lu",
  description="GREEK CAPITAL LETTER ARCHAIC SAMPI",
  direction="l",
  linebreak="al",
  unicodeslot=0x372,
 },
 {
  category="ll",
  description="GREEK SMALL LETTER ARCHAIC SAMPI",
  direction="l",
  linebreak="al",
  unicodeslot=0x373,
 },
 {
  adobename="numeralsigngreek",
  category="sk",
  description="GREEK NUMERAL SIGN",
  direction="on",
  linebreak="al",
  specials={ "char", 0x2B9 },
  unicodeslot=0x374,
 },
 {
  adobename="numeralsignlowergreek",
  category="sk",
  description="GREEK LOWER NUMERAL SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x375,
 },
 {
  category="lu",
  description="GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x376,
 },
 {
  category="ll",
  description="GREEK SMALL LETTER PAMPHYLIAN DIGAMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x377,
 },
 [0x37A]={
  adobename="ypogegrammeni",
  category="lm",
  description="GREEK YPOGEGRAMMENI",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x20, 0x345 },
  unicodeslot=0x37A,
 },
 [0x37B]={
  category="ll",
  description="GREEK SMALL REVERSED LUNATE SIGMA SYMBOL",
  direction="l",
  linebreak="al",
  uccode=0x3FD,
  unicodeslot=0x37B,
 },
 [0x37C]={
  category="ll",
  description="GREEK SMALL DOTTED LUNATE SIGMA SYMBOL",
  direction="l",
  linebreak="al",
  uccode=0x3FE,
  unicodeslot=0x37C,
 },
 [0x37D]={
  category="ll",
  description="GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL",
  direction="l",
  linebreak="al",
  uccode=0x3FF,
  unicodeslot=0x37D,
 },
 [0x37E]={
  adobename="questiongreek",
  category="po",
  description="GREEK QUESTION MARK",
  direction="on",
  linebreak="is",
  specials={ "char", 0x3B },
  unicodeslot=0x37E,
 },
 [0x37F]={
  category="lu",
  description="GREEK CAPITAL LETTER YOT",
  direction="l",
  linebreak="al",
  unicodeslot=0x37F,
 },
 [0x384]={
  adobename="tonos",
  category="sk",
  contextname="greektonos",
  description="GREEK TONOS",
  direction="on",
  linebreak="al",
  specials={ "compat", 0x20, 0x301 },
  unicodeslot=0x384,
 },
 [0x385]={
  adobename="dieresistonos",
  category="sk",
  contextname="greekdialytikatonos",
  description="GREEK DIALYTIKA TONOS",
  direction="on",
  linebreak="al",
  specials={ "char", 0xA8, 0x301 },
  unicodeslot=0x385,
 },
 [0x386]={
  adobename="Alphatonos",
  category="lu",
  contextname="greekAlphatonos",
  description="GREEK CAPITAL LETTER ALPHA WITH TONOS",
  direction="l",
  lccode=0x3AC,
  linebreak="al",
  shcode=0x391,
  specials={ "char", 0x391, 0x301 },
  unicodeslot=0x386,
 },
 [0x387]={
  adobename="anoteleia",
  category="po",
  description="GREEK ANO TELEIA",
  direction="on",
  linebreak="al",
  specials={ "char", 0xB7 },
  unicodeslot=0x387,
 },
 [0x388]={
  adobename="Epsilontonos",
  category="lu",
  contextname="greekEpsilontonos",
  description="GREEK CAPITAL LETTER EPSILON WITH TONOS",
  direction="l",
  lccode=0x3AD,
  linebreak="al",
  shcode=0x395,
  specials={ "char", 0x395, 0x301 },
  unicodeslot=0x388,
 },
 [0x389]={
  adobename="Etatonos",
  category="lu",
  contextname="greekEtatonos",
  description="GREEK CAPITAL LETTER ETA WITH TONOS",
  direction="l",
  lccode=0x3AE,
  linebreak="al",
  shcode=0x397,
  specials={ "char", 0x397, 0x301 },
  unicodeslot=0x389,
 },
 [0x38A]={
  adobename="Iotatonos",
  category="lu",
  contextname="greekIotatonos",
  description="GREEK CAPITAL LETTER IOTA WITH TONOS",
  direction="l",
  lccode=0x3AF,
  linebreak="al",
  shcode=0x399,
  specials={ "char", 0x399, 0x301 },
  unicodeslot=0x38A,
 },
 [0x38C]={
  adobename="Omicrontonos",
  category="lu",
  contextname="greekOmicrontonos",
  description="GREEK CAPITAL LETTER OMICRON WITH TONOS",
  direction="l",
  lccode=0x3CC,
  linebreak="al",
  shcode=0x39F,
  specials={ "char", 0x39F, 0x301 },
  unicodeslot=0x38C,
 },
 [0x38E]={
  adobename="Upsilontonos",
  category="lu",
  contextname="greekUpsilontonos",
  description="GREEK CAPITAL LETTER UPSILON WITH TONOS",
  direction="l",
  lccode=0x3CD,
  linebreak="al",
  shcode=0x3A5,
  specials={ "char", 0x3A5, 0x301 },
  unicodeslot=0x38E,
 },
 [0x38F]={
  adobename="Omegatonos",
  category="lu",
  contextname="greekOmegatonos",
  description="GREEK CAPITAL LETTER OMEGA WITH TONOS",
  direction="l",
  lccode=0x3CE,
  linebreak="al",
  shcode=0x3A9,
  specials={ "char", 0x3A9, 0x301 },
  unicodeslot=0x38F,
 },
 [0x390]={
  adobename="iotadieresistonos",
  category="ll",
  contextname="greekiotadialytikatonos",
  description="GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS",
  direction="l",
  linebreak="al",
  shcode=0x3B9,
  specials={ "char", 0x3CA, 0x301 },
  unicodeslot=0x390,
 },
 [0x391]={
  adobename="Alpha",
  category="lu",
  cjkwd="a",
  contextname="greekAlpha",
  description="GREEK CAPITAL LETTER ALPHA",
  direction="l",
  lccode=0x3B1,
  linebreak="al",
  mathclass="variable",
  mathname="Alpha",
  unicodeslot=0x391,
 },
 [0x392]={
  adobename="Beta",
  category="lu",
  cjkwd="a",
  contextname="greekBeta",
  description="GREEK CAPITAL LETTER BETA",
  direction="l",
  lccode=0x3B2,
  linebreak="al",
  mathclass="variable",
  mathname="Beta",
  unicodeslot=0x392,
 },
 [0x393]={
  adobename="Gamma",
  category="lu",
  cjkwd="a",
  contextname="greekGamma",
  description="GREEK CAPITAL LETTER GAMMA",
  direction="l",
  lccode=0x3B3,
  linebreak="al",
  mathclass="variable",
  mathname="Gamma",
  synonyms={ "gamma function" },
  unicodeslot=0x393,
 },
 [0x394]={
  adobename="Deltagreek",
  category="lu",
  cjkwd="a",
  contextname="greekDelta",
  description="GREEK CAPITAL LETTER DELTA",
  direction="l",
  lccode=0x3B4,
  linebreak="al",
  mathclass="variable",
  mathname="Delta",
  unicodeslot=0x394,
 },
 [0x395]={
  adobename="Epsilon",
  category="lu",
  cjkwd="a",
  contextname="greekEpsilon",
  description="GREEK CAPITAL LETTER EPSILON",
  direction="l",
  lccode=0x3B5,
  linebreak="al",
  mathclass="variable",
  mathname="Epsilon",
  unicodeslot=0x395,
 },
 [0x396]={
  adobename="Zeta",
  category="lu",
  cjkwd="a",
  contextname="greekZeta",
  description="GREEK CAPITAL LETTER ZETA",
  direction="l",
  lccode=0x3B6,
  linebreak="al",
  mathclass="variable",
  mathname="Zeta",
  unicodeslot=0x396,
 },
 [0x397]={
  adobename="Eta",
  category="lu",
  cjkwd="a",
  contextname="greekEta",
  description="GREEK CAPITAL LETTER ETA",
  direction="l",
  lccode=0x3B7,
  linebreak="al",
  mathclass="variable",
  mathname="Eta",
  unicodeslot=0x397,
 },
 [0x398]={
  adobename="Theta",
  category="lu",
  cjkwd="a",
  contextname="greekTheta",
  description="GREEK CAPITAL LETTER THETA",
  direction="l",
  lccode=0x3B8,
  linebreak="al",
  mathclass="variable",
  mathname="Theta",
  unicodeslot=0x398,
 },
 [0x399]={
  adobename="Iota",
  category="lu",
  cjkwd="a",
  contextname="greekIota",
  description="GREEK CAPITAL LETTER IOTA",
  direction="l",
  lccode=0x3B9,
  linebreak="al",
  mathclass="variable",
  mathname="Iota",
  unicodeslot=0x399,
 },
 [0x39A]={
  adobename="Kappa",
  category="lu",
  cjkwd="a",
  contextname="greekKappa",
  description="GREEK CAPITAL LETTER KAPPA",
  direction="l",
  lccode=0x3BA,
  linebreak="al",
  mathclass="variable",
  mathname="Kappa",
  unicodeslot=0x39A,
 },
 [0x39B]={
  adobename="Lambda",
  category="lu",
  cjkwd="a",
  contextname="greekLambda",
  description="GREEK CAPITAL LETTER LAMDA",
  direction="l",
  lccode=0x3BB,
  linebreak="al",
  mathclass="variable",
  mathname="Lambda",
  unicodeslot=0x39B,
 },
 [0x39C]={
  adobename="Mu",
  category="lu",
  cjkwd="a",
  contextname="greekMu",
  description="GREEK CAPITAL LETTER MU",
  direction="l",
  lccode=0x3BC,
  linebreak="al",
  mathclass="variable",
  mathname="Mu",
  unicodeslot=0x39C,
 },
 [0x39D]={
  adobename="Nu",
  category="lu",
  cjkwd="a",
  contextname="greekNu",
  description="GREEK CAPITAL LETTER NU",
  direction="l",
  lccode=0x3BD,
  linebreak="al",
  mathclass="variable",
  mathname="Nu",
  unicodeslot=0x39D,
 },
 [0x39E]={
  adobename="Xi",
  category="lu",
  cjkwd="a",
  contextname="greekXi",
  description="GREEK CAPITAL LETTER XI",
  direction="l",
  lccode=0x3BE,
  linebreak="al",
  mathclass="variable",
  mathname="Xi",
  unicodeslot=0x39E,
 },
 [0x39F]={
  adobename="Omicron",
  category="lu",
  cjkwd="a",
  contextname="greekOmicron",
  description="GREEK CAPITAL LETTER OMICRON",
  direction="l",
  lccode=0x3BF,
  linebreak="al",
  mathclass="variable",
  mathname="Omicron",
  unicodeslot=0x39F,
 },
 [0x3A0]={
  adobename="Pi",
  category="lu",
  cjkwd="a",
  contextname="greekPi",
  description="GREEK CAPITAL LETTER PI",
  direction="l",
  lccode=0x3C0,
  linebreak="al",
  mathclass="variable",
  mathname="Pi",
  unicodeslot=0x3A0,
 },
 [0x3A1]={
  adobename="Rho",
  category="lu",
  cjkwd="a",
  contextname="greekRho",
  description="GREEK CAPITAL LETTER RHO",
  direction="l",
  lccode=0x3C1,
  linebreak="al",
  mathclass="variable",
  mathname="Rho",
  unicodeslot=0x3A1,
 },
 [0x3A3]={
  adobename="Sigma",
  category="lu",
  cjkwd="a",
  contextname="greekSigma",
  description="GREEK CAPITAL LETTER SIGMA",
  direction="l",
  lccode=0x3C3,
  linebreak="al",
  mathclass="variable",
  mathname="Sigma",
  unicodeslot=0x3A3,
 },
 [0x3A4]={
  adobename="Tau",
  category="lu",
  cjkwd="a",
  contextname="greekTau",
  description="GREEK CAPITAL LETTER TAU",
  direction="l",
  lccode=0x3C4,
  linebreak="al",
  mathclass="variable",
  mathname="Tau",
  unicodeslot=0x3A4,
 },
 [0x3A5]={
  adobename="Upsilon",
  category="lu",
  cjkwd="a",
  contextname="greekUpsilon",
  description="GREEK CAPITAL LETTER UPSILON",
  direction="l",
  lccode=0x3C5,
  linebreak="al",
  mathclass="variable",
  mathname="Upsilon",
  unicodeslot=0x3A5,
 },
 [0x3A6]={
  adobename="Phi",
  category="lu",
  cjkwd="a",
  contextname="greekPhi",
  description="GREEK CAPITAL LETTER PHI",
  direction="l",
  lccode=0x3C6,
  linebreak="al",
  mathclass="variable",
  mathname="Phi",
  unicodeslot=0x3A6,
 },
 [0x3A7]={
  adobename="Chi",
  category="lu",
  cjkwd="a",
  contextname="greekChi",
  description="GREEK CAPITAL LETTER CHI",
  direction="l",
  lccode=0x3C7,
  linebreak="al",
  mathclass="variable",
  mathname="Chi",
  unicodeslot=0x3A7,
 },
 [0x3A8]={
  adobename="Psi",
  category="lu",
  cjkwd="a",
  contextname="greekPsi",
  description="GREEK CAPITAL LETTER PSI",
  direction="l",
  lccode=0x3C8,
  linebreak="al",
  mathclass="variable",
  mathname="Psi",
  unicodeslot=0x3A8,
 },
 [0x3A9]={
  adobename="Omegagreek",
  category="lu",
  cjkwd="a",
  contextname="greekOmega",
  description="GREEK CAPITAL LETTER OMEGA",
  direction="l",
  lccode=0x3C9,
  linebreak="al",
  mathclass="variable",
  mathname="Omega",
  unicodeslot=0x3A9,
 },
 [0x3AA]={
  adobename="Iotadieresis",
  category="lu",
  contextname="greekIotadialytika",
  description="GREEK CAPITAL LETTER IOTA WITH DIALYTIKA",
  direction="l",
  lccode=0x3CA,
  linebreak="al",
  shcode=0x399,
  specials={ "char", 0x399, 0x308 },
  unicodeslot=0x3AA,
 },
 [0x3AB]={
  adobename="Upsilondieresis",
  category="lu",
  contextname="greekUpsilondialytika",
  description="GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA",
  direction="l",
  lccode=0x3CB,
  linebreak="al",
  shcode=0x3A5,
  specials={ "char", 0x3A5, 0x308 },
  unicodeslot=0x3AB,
 },
 [0x3AC]={
  adobename="alphatonos",
  category="ll",
  contextname="greekalphatonos",
  description="GREEK SMALL LETTER ALPHA WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x3B1,
  specials={ "char", 0x3B1, 0x301 },
  uccode=0x386,
  unicodeslot=0x3AC,
 },
 [0x3AD]={
  adobename="epsilontonos",
  category="ll",
  contextname="greekepsilontonos",
  description="GREEK SMALL LETTER EPSILON WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x3B5,
  specials={ "char", 0x3B5, 0x301 },
  uccode=0x388,
  unicodeslot=0x3AD,
 },
 [0x3AE]={
  adobename="etatonos",
  category="ll",
  contextname="greeketatonos",
  description="GREEK SMALL LETTER ETA WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x3B7,
  specials={ "char", 0x3B7, 0x301 },
  uccode=0x389,
  unicodeslot=0x3AE,
 },
 [0x3AF]={
  adobename="iotatonos",
  category="ll",
  contextname="greekiotatonos",
  description="GREEK SMALL LETTER IOTA WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x3B9,
  specials={ "char", 0x3B9, 0x301 },
  uccode=0x38A,
  unicodeslot=0x3AF,
 },
 [0x3B0]={
  adobename="upsilondieresistonos",
  category="ll",
  contextname="greekupsilondialytikatonos",
  description="GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS",
  direction="l",
  linebreak="al",
  shcode=0x3C5,
  specials={ "char", 0x3CB, 0x301 },
  unicodeslot=0x3B0,
 },
 [0x3B1]={
  adobename="alpha",
  category="ll",
  cjkwd="a",
  contextname="greekalpha",
  description="GREEK SMALL LETTER ALPHA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="alpha",
  uccode=0x391,
  unicodeslot=0x3B1,
 },
 [0x3B2]={
  adobename="beta",
  category="ll",
  cjkwd="a",
  contextname="greekbeta",
  description="GREEK SMALL LETTER BETA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="beta",
  uccode=0x392,
  unicodeslot=0x3B2,
 },
 [0x3B3]={
  adobename="gamma",
  category="ll",
  cjkwd="a",
  contextname="greekgamma",
  description="GREEK SMALL LETTER GAMMA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="gamma",
  uccode=0x393,
  unicodeslot=0x3B3,
 },
 [0x3B4]={
  adobename="delta",
  category="ll",
  cjkwd="a",
  contextname="greekdelta",
  description="GREEK SMALL LETTER DELTA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="delta",
  uccode=0x394,
  unicodeslot=0x3B4,
 },
 [0x3B5]={
  adobename="epsilon",
  category="ll",
  cjkwd="a",
  contextname="greekepsilon",
  description="GREEK SMALL LETTER EPSILON",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varepsilon",
  uccode=0x395,
  unicodeslot=0x3B5,
 },
 [0x3B6]={
  adobename="zeta",
  category="ll",
  cjkwd="a",
  contextname="greekzeta",
  description="GREEK SMALL LETTER ZETA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="zeta",
  uccode=0x396,
  unicodeslot=0x3B6,
 },
 [0x3B7]={
  adobename="eta",
  category="ll",
  cjkwd="a",
  contextname="greeketa",
  description="GREEK SMALL LETTER ETA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="eta",
  uccode=0x397,
  unicodeslot=0x3B7,
 },
 [0x3B8]={
  adobename="theta",
  category="ll",
  cjkwd="a",
  contextname="greektheta",
  description="GREEK SMALL LETTER THETA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="theta",
  uccode=0x398,
  unicodeslot=0x3B8,
 },
 [0x3B9]={
  adobename="iota",
  category="ll",
  cjkwd="a",
  contextname="greekiota",
  description="GREEK SMALL LETTER IOTA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="iota",
  uccode=0x399,
  unicodeslot=0x3B9,
 },
 [0x3BA]={
  adobename="kappa",
  category="ll",
  cjkwd="a",
  contextname="greekkappa",
  description="GREEK SMALL LETTER KAPPA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="kappa",
  uccode=0x39A,
  unicodeslot=0x3BA,
 },
 [0x3BB]={
  adobename="lambda",
  category="ll",
  cjkwd="a",
  contextname="greeklambda",
  description="GREEK SMALL LETTER LAMDA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="lambda",
  uccode=0x39B,
  unicodeslot=0x3BB,
 },
 [0x3BC]={
  adobename="mugreek",
  category="ll",
  cjkwd="a",
  contextname="greekmu",
  description="GREEK SMALL LETTER MU",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="mu",
  uccode=0x39C,
  unicodeslot=0x3BC,
 },
 [0x3BD]={
  adobename="nu",
  category="ll",
  cjkwd="a",
  contextname="greeknu",
  description="GREEK SMALL LETTER NU",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="nu",
  uccode=0x39D,
  unicodeslot=0x3BD,
 },
 [0x3BE]={
  adobename="xi",
  category="ll",
  cjkwd="a",
  contextname="greekxi",
  description="GREEK SMALL LETTER XI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="xi",
  uccode=0x39E,
  unicodeslot=0x3BE,
 },
 [0x3BF]={
  adobename="omicron",
  category="ll",
  cjkwd="a",
  contextname="greekomicron",
  description="GREEK SMALL LETTER OMICRON",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="omicron",
  uccode=0x39F,
  unicodeslot=0x3BF,
 },
 [0x3C0]={
  adobename="pi",
  category="ll",
  cjkwd="a",
  contextname="greekpi",
  description="GREEK SMALL LETTER PI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="pi",
  synonyms={ "mathematical constant 3.141592... pi", "mathematical constant pi" },
  uccode=0x3A0,
  unicodeslot=0x3C0,
 },
 [0x3C1]={
  adobename="rho",
  category="ll",
  cjkwd="a",
  contextname="greekrho",
  description="GREEK SMALL LETTER RHO",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="rho",
  uccode=0x3A1,
  unicodeslot=0x3C1,
 },
 [0x3C2]={
  adobename="sigmafinal",
  category="ll",
  contextname="greekfinalsigma",
  description="GREEK SMALL LETTER FINAL SIGMA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varsigma",
  uccode=0x3A3,
  unicodeslot=0x3C2,
 },
 [0x3C3]={
  adobename="sigma",
  category="ll",
  cjkwd="a",
  contextname="greeksigma",
  description="GREEK SMALL LETTER SIGMA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="sigma",
  uccode=0x3A3,
  unicodeslot=0x3C3,
 },
 [0x3C4]={
  adobename="tau",
  category="ll",
  cjkwd="a",
  contextname="greektau",
  description="GREEK SMALL LETTER TAU",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="tau",
  uccode=0x3A4,
  unicodeslot=0x3C4,
 },
 [0x3C5]={
  adobename="upsilon",
  category="ll",
  cjkwd="a",
  contextname="greekupsilon",
  description="GREEK SMALL LETTER UPSILON",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="upsilon",
  uccode=0x3A5,
  unicodeslot=0x3C5,
 },
 [0x3C6]={
  adobename="phi",
  category="ll",
  cjkwd="a",
  contextname="greekphi",
  description="GREEK SMALL LETTER PHI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varphi",
  uccode=0x3A6,
  unicodeslot=0x3C6,
 },
 [0x3C7]={
  adobename="chi",
  category="ll",
  cjkwd="a",
  contextname="greekchi",
  description="GREEK SMALL LETTER CHI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="chi",
  uccode=0x3A7,
  unicodeslot=0x3C7,
 },
 [0x3C8]={
  adobename="psi",
  category="ll",
  cjkwd="a",
  contextname="greekpsi",
  description="GREEK SMALL LETTER PSI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="psi",
  uccode=0x3A8,
  unicodeslot=0x3C8,
 },
 [0x3C9]={
  adobename="omega",
  category="ll",
  cjkwd="a",
  contextname="greekomega",
  description="GREEK SMALL LETTER OMEGA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="omega",
  uccode=0x3A9,
  unicodeslot=0x3C9,
 },
 [0x3CA]={
  adobename="iotadieresis",
  category="ll",
  contextname="greekiotadialytika",
  description="GREEK SMALL LETTER IOTA WITH DIALYTIKA",
  direction="l",
  linebreak="al",
  shcode=0x3B9,
  specials={ "char", 0x3B9, 0x308 },
  uccode=0x3AA,
  unicodeslot=0x3CA,
 },
 [0x3CB]={
  adobename="upsilondieresis",
  category="ll",
  contextname="greekupsilondiaeresis",
  description="GREEK SMALL LETTER UPSILON WITH DIALYTIKA",
  direction="l",
  linebreak="al",
  shcode=0x3C5,
  specials={ "char", 0x3C5, 0x308 },
  uccode=0x3AB,
  unicodeslot=0x3CB,
 },
 [0x3CC]={
  adobename="omicrontonos",
  category="ll",
  contextname="greekomicrontonos",
  description="GREEK SMALL LETTER OMICRON WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x3BF,
  specials={ "char", 0x3BF, 0x301 },
  uccode=0x38C,
  unicodeslot=0x3CC,
 },
 [0x3CD]={
  adobename="upsilontonos",
  category="ll",
  contextname="greekupsilontonos",
  description="GREEK SMALL LETTER UPSILON WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x3C5,
  specials={ "char", 0x3C5, 0x301 },
  uccode=0x38E,
  unicodeslot=0x3CD,
 },
 [0x3CE]={
  adobename="omegatonos",
  category="ll",
  contextname="greekomegatonos",
  description="GREEK SMALL LETTER OMEGA WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x3C9,
  specials={ "char", 0x3C9, 0x301 },
  uccode=0x38F,
  unicodeslot=0x3CE,
 },
 [0x3CF]={
  category="lu",
  description="GREEK CAPITAL KAI SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x3CF,
 },
 [0x3D0]={
  adobename="betasymbolgreek",
  category="ll",
  description="GREEK BETA SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x3B2 },
  synonyms={ "curled beta" },
  uccode=0x392,
  unicodeslot=0x3D0,
 },
 [0x3D1]={
  adobename="thetasymbolgreek",
  category="ll",
  contextname="greekthetaalt",
  description="GREEK THETA SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varTheta",
  specials={ "compat", 0x3B8 },
  synonyms={ "script theta" },
  uccode=0x398,
  unicodeslot=0x3D1,
 },
 [0x3D2]={
  adobename="Upsilonhooksymbol",
  category="lu",
  description="GREEK UPSILON WITH HOOK SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x3A5 },
  unicodeslot=0x3D2,
 },
 [0x3D3]={
  adobename="Upsilonacutehooksymbolgreek",
  category="lu",
  description="GREEK UPSILON WITH ACUTE AND HOOK SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "char", 0x3D2, 0x301 },
  unicodeslot=0x3D3,
 },
 [0x3D4]={
  adobename="Upsilondieresishooksymbolgreek",
  category="lu",
  description="GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "char", 0x3D2, 0x308 },
  unicodeslot=0x3D4,
 },
 [0x3D5]={
  adobename="phisymbolgreek",
  category="ll",
  contextname="greekphialt",
  description="GREEK PHI SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="phi",
  specials={ "compat", 0x3C6 },
  uccode=0x3A6,
  unicodeslot=0x3D5,
 },
 [0x3D6]={
  adobename="pisymbolgreek",
  category="ll",
  contextname="greekpialt",
  description="GREEK PI SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varpi",
  specials={ "compat", 0x3C0 },
  synonyms={ "omega pi" },
  uccode=0x3A0,
  unicodeslot=0x3D6,
 },
 [0x3D7]={
  category="ll",
  description="GREEK KAI SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x3D7,
 },
 [0x3D8]={
  category="lu",
  description="GREEK LETTER ARCHAIC KOPPA",
  direction="l",
  lccode=0x3D9,
  linebreak="al",
  unicodeslot=0x3D8,
 },
 [0x3D9]={
  category="ll",
  contextname="greekkoppa",
  description="GREEK SMALL LETTER ARCHAIC KOPPA",
  direction="l",
  linebreak="al",
  uccode=0x3D8,
  unicodeslot=0x3D9,
 },
 [0x3DA]={
  adobename="Stigmagreek",
  category="lu",
  description="GREEK LETTER STIGMA",
  direction="l",
  lccode=0x3DB,
  linebreak="al",
  unicodeslot=0x3DA,
 },
 [0x3DB]={
  category="ll",
  contextname="greekstigma",
  description="GREEK SMALL LETTER STIGMA",
  direction="l",
  linebreak="al",
  uccode=0x3DA,
  unicodeslot=0x3DB,
 },
 [0x3DC]={
  adobename="Digammagreek",
  category="lu",
  description="GREEK LETTER DIGAMMA",
  direction="l",
  lccode=0x3DD,
  linebreak="al",
  mathclass="variable",
  mathname="digamma",
  unicodeslot=0x3DC,
 },
 [0x3DD]={
  category="ll",
  contextname="greekdigamma",
  description="GREEK SMALL LETTER DIGAMMA",
  direction="l",
  linebreak="al",
  uccode=0x3DC,
  unicodeslot=0x3DD,
 },
 [0x3DE]={
  adobename="Koppagreek",
  category="lu",
  description="GREEK LETTER KOPPA",
  direction="l",
  lccode=0x3DF,
  linebreak="al",
  unicodeslot=0x3DE,
 },
 [0x3DF]={
  category="ll",
  contextname="greeknumkoppa",
  description="GREEK SMALL LETTER KOPPA",
  direction="l",
  linebreak="al",
  uccode=0x3DE,
  unicodeslot=0x3DF,
 },
 [0x3E0]={
  adobename="Sampigreek",
  category="lu",
  description="GREEK LETTER SAMPI",
  direction="l",
  lccode=0x3E1,
  linebreak="al",
  unicodeslot=0x3E0,
 },
 [0x3E1]={
  category="ll",
  contextname="greeksampi",
  description="GREEK SMALL LETTER SAMPI",
  direction="l",
  linebreak="al",
  uccode=0x3E0,
  unicodeslot=0x3E1,
 },
 [0x3E2]={
  adobename="Sheicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER SHEI",
  direction="l",
  lccode=0x3E3,
  linebreak="al",
  unicodeslot=0x3E2,
 },
 [0x3E3]={
  adobename="sheicoptic",
  category="ll",
  description="COPTIC SMALL LETTER SHEI",
  direction="l",
  linebreak="al",
  uccode=0x3E2,
  unicodeslot=0x3E3,
 },
 [0x3E4]={
  adobename="Feicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER FEI",
  direction="l",
  lccode=0x3E5,
  linebreak="al",
  unicodeslot=0x3E4,
 },
 [0x3E5]={
  adobename="feicoptic",
  category="ll",
  description="COPTIC SMALL LETTER FEI",
  direction="l",
  linebreak="al",
  uccode=0x3E4,
  unicodeslot=0x3E5,
 },
 [0x3E6]={
  adobename="Kheicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER KHEI",
  direction="l",
  lccode=0x3E7,
  linebreak="al",
  unicodeslot=0x3E6,
 },
 [0x3E7]={
  adobename="kheicoptic",
  category="ll",
  description="COPTIC SMALL LETTER KHEI",
  direction="l",
  linebreak="al",
  uccode=0x3E6,
  unicodeslot=0x3E7,
 },
 [0x3E8]={
  adobename="Horicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER HORI",
  direction="l",
  lccode=0x3E9,
  linebreak="al",
  unicodeslot=0x3E8,
 },
 [0x3E9]={
  adobename="horicoptic",
  category="ll",
  description="COPTIC SMALL LETTER HORI",
  direction="l",
  linebreak="al",
  uccode=0x3E8,
  unicodeslot=0x3E9,
 },
 [0x3EA]={
  adobename="Gangiacoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER GANGIA",
  direction="l",
  lccode=0x3EB,
  linebreak="al",
  unicodeslot=0x3EA,
 },
 [0x3EB]={
  adobename="gangiacoptic",
  category="ll",
  description="COPTIC SMALL LETTER GANGIA",
  direction="l",
  linebreak="al",
  uccode=0x3EA,
  unicodeslot=0x3EB,
 },
 [0x3EC]={
  adobename="Shimacoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER SHIMA",
  direction="l",
  lccode=0x3ED,
  linebreak="al",
  unicodeslot=0x3EC,
 },
 [0x3ED]={
  adobename="shimacoptic",
  category="ll",
  description="COPTIC SMALL LETTER SHIMA",
  direction="l",
  linebreak="al",
  uccode=0x3EC,
  unicodeslot=0x3ED,
 },
 [0x3EE]={
  adobename="Deicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER DEI",
  direction="l",
  lccode=0x3EF,
  linebreak="al",
  unicodeslot=0x3EE,
 },
 [0x3EF]={
  adobename="deicoptic",
  category="ll",
  description="COPTIC SMALL LETTER DEI",
  direction="l",
  linebreak="al",
  uccode=0x3EE,
  unicodeslot=0x3EF,
 },
 [0x3F0]={
  adobename="kappasymbolgreek",
  category="ll",
  description="GREEK KAPPA SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="ordinary",
  mathname="varkappa",
  specials={ "compat", 0x3BA },
  uccode=0x39A,
  unicodeslot=0x3F0,
 },
 [0x3F1]={
  adobename="rhosymbolgreek",
  category="ll",
  contextname="greekrhoalt",
  description="GREEK RHO SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x3C1 },
  uccode=0x3A1,
  unicodeslot=0x3F1,
 },
 [0x3F2]={
  adobename="sigmalunatesymbolgreek",
  category="ll",
  contextname="greeksigmalunate",
  description="GREEK LUNATE SIGMA SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x3C2 },
  synonyms={ "greek small letter lunate sigma" },
  uccode=0x3F9,
  unicodeslot=0x3F2,
 },
 [0x3F3]={
  adobename="yotgreek",
  category="ll",
  description="GREEK LETTER YOT",
  direction="l",
  linebreak="al",
  unicodeslot=0x3F3,
 },
 [0x3F4]={
  category="lu",
  description="GREEK CAPITAL THETA SYMBOL",
  direction="l",
  lccode=0x3B8,
  linebreak="al",
  specials={ "compat", 0x398 },
  unicodeslot=0x3F4,
 },
 [0x3F5]={
  category="ll",
  contextname="greekepsilonalt",
  description="GREEK LUNATE EPSILON SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="epsilon",
  specials={ "compat", 0x3B5 },
  synonyms={ "straight epsilon" },
  uccode=0x395,
  unicodeslot=0x3F5,
 },
 [0x3F6]={
  category="sm",
  description="GREEK REVERSED LUNATE EPSILON SYMBOL",
  direction="on",
  linebreak="al",
  mathclass="variable",
  mathname="backepsilon",
  synonyms={ "reversed straight epsilon" },
  unicodeslot=0x3F6,
 },
 [0x3F7]={
  category="lu",
  description="GREEK CAPITAL LETTER SHO",
  direction="l",
  lccode=0x3F8,
  linebreak="al",
  unicodeslot=0x3F7,
 },
 [0x3F8]={
  category="ll",
  description="GREEK SMALL LETTER SHO",
  direction="l",
  linebreak="al",
  uccode=0x3F7,
  unicodeslot=0x3F8,
 },
 [0x3F9]={
  category="lu",
  contextname="greekSigmalunate",
  description="GREEK CAPITAL LUNATE SIGMA SYMBOL",
  direction="l",
  lccode=0x3F2,
  linebreak="al",
  specials={ "compat", 0x3A3 },
  unicodeslot=0x3F9,
 },
 [0x3FA]={
  category="lu",
  description="GREEK CAPITAL LETTER SAN",
  direction="l",
  lccode=0x3FB,
  linebreak="al",
  unicodeslot=0x3FA,
 },
 [0x3FB]={
  category="ll",
  description="GREEK SMALL LETTER SAN",
  direction="l",
  linebreak="al",
  uccode=0x3FA,
  unicodeslot=0x3FB,
 },
 [0x3FC]={
  category="ll",
  description="GREEK RHO WITH STROKE SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x3FC,
 },
 [0x3FD]={
  category="lu",
  description="GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL",
  direction="l",
  lccode=0x37B,
  linebreak="al",
  unicodeslot=0x3FD,
 },
 [0x3FE]={
  category="lu",
  description="GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL",
  direction="l",
  lccode=0x37C,
  linebreak="al",
  unicodeslot=0x3FE,
 },
 [0x3FF]={
  category="lu",
  description="GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL",
  direction="l",
  lccode=0x37D,
  linebreak="al",
  unicodeslot=0x3FF,
 },
 [0x400]={
  category="lu",
  contextname="cyrillicEgrave",
  description="CYRILLIC CAPITAL LETTER IE WITH GRAVE",
  direction="l",
  lccode=0x450,
  linebreak="al",
  shcode=0x415,
  specials={ "char", 0x415, 0x300 },
  unicodeslot=0x400,
 },
 [0x401]={
  adobename="afii10023",
  category="lu",
  cjkwd="a",
  contextname="cyrillicYO",
  description="CYRILLIC CAPITAL LETTER IO",
  direction="l",
  lccode=0x451,
  linebreak="al",
  specials={ "char", 0x415, 0x308 },
  unicodeslot=0x401,
 },
 [0x402]={
  adobename="afii10051",
  category="lu",
  contextname="cyrillicDJE",
  description="CYRILLIC CAPITAL LETTER DJE",
  direction="l",
  lccode=0x452,
  linebreak="al",
  unicodeslot=0x402,
 },
 [0x403]={
  adobename="afii10052",
  category="lu",
  contextname="cyrillicGJE",
  description="CYRILLIC CAPITAL LETTER GJE",
  direction="l",
  lccode=0x453,
  linebreak="al",
  specials={ "char", 0x413, 0x301 },
  unicodeslot=0x403,
 },
 [0x404]={
  adobename="afii10053",
  category="lu",
  contextname="cyrillicIE",
  description="CYRILLIC CAPITAL LETTER UKRAINIAN IE",
  direction="l",
  lccode=0x454,
  linebreak="al",
  unicodeslot=0x404,
 },
 [0x405]={
  adobename="afii10054",
  category="lu",
  contextname="cyrillicDZE",
  description="CYRILLIC CAPITAL LETTER DZE",
  direction="l",
  lccode=0x455,
  linebreak="al",
  unicodeslot=0x405,
 },
 [0x406]={
  adobename="afii10055",
  category="lu",
  contextname="cyrillicII",
  description="CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I",
  direction="l",
  lccode=0x456,
  linebreak="al",
  unicodeslot=0x406,
 },
 [0x407]={
  adobename="afii10056",
  category="lu",
  contextname="cyrillicYI",
  description="CYRILLIC CAPITAL LETTER YI",
  direction="l",
  lccode=0x457,
  linebreak="al",
  specials={ "char", 0x406, 0x308 },
  unicodeslot=0x407,
 },
 [0x408]={
  adobename="afii10057",
  category="lu",
  contextname="cyrillicJE",
  description="CYRILLIC CAPITAL LETTER JE",
  direction="l",
  lccode=0x458,
  linebreak="al",
  unicodeslot=0x408,
 },
 [0x409]={
  adobename="afii10058",
  category="lu",
  contextname="cyrillicLJE",
  description="CYRILLIC CAPITAL LETTER LJE",
  direction="l",
  lccode=0x459,
  linebreak="al",
  unicodeslot=0x409,
 },
 [0x40A]={
  adobename="afii10059",
  category="lu",
  contextname="cyrillicNJE",
  description="CYRILLIC CAPITAL LETTER NJE",
  direction="l",
  lccode=0x45A,
  linebreak="al",
  unicodeslot=0x40A,
 },
 [0x40B]={
  adobename="afii10060",
  category="lu",
  contextname="cyrillicTSHE",
  description="CYRILLIC CAPITAL LETTER TSHE",
  direction="l",
  lccode=0x45B,
  linebreak="al",
  unicodeslot=0x40B,
 },
 [0x40C]={
  adobename="afii10061",
  category="lu",
  contextname="cyrillicKJE",
  description="CYRILLIC CAPITAL LETTER KJE",
  direction="l",
  lccode=0x45C,
  linebreak="al",
  specials={ "char", 0x41A, 0x301 },
  unicodeslot=0x40C,
 },
 [0x40D]={
  category="lu",
  contextname="cyrillicIgrave",
  description="CYRILLIC CAPITAL LETTER I WITH GRAVE",
  direction="l",
  lccode=0x45D,
  linebreak="al",
  shcode=0x418,
  specials={ "char", 0x418, 0x300 },
  unicodeslot=0x40D,
 },
 [0x40E]={
  adobename="afii10062",
  category="lu",
  contextname="cyrillicUSHRT",
  description="CYRILLIC CAPITAL LETTER SHORT U",
  direction="l",
  lccode=0x45E,
  linebreak="al",
  specials={ "char", 0x423, 0x306 },
  unicodeslot=0x40E,
 },
 [0x40F]={
  adobename="afii10145",
  category="lu",
  contextname="cyrillicDZHE",
  description="CYRILLIC CAPITAL LETTER DZHE",
  direction="l",
  lccode=0x45F,
  linebreak="al",
  unicodeslot=0x40F,
 },
 [0x410]={
  adobename="afii10017",
  category="lu",
  cjkwd="a",
  contextname="cyrillicA",
  description="CYRILLIC CAPITAL LETTER A",
  direction="l",
  lccode=0x430,
  linebreak="al",
  unicodeslot=0x410,
 },
 [0x411]={
  adobename="afii10018",
  category="lu",
  cjkwd="a",
  contextname="cyrillicB",
  description="CYRILLIC CAPITAL LETTER BE",
  direction="l",
  lccode=0x431,
  linebreak="al",
  unicodeslot=0x411,
 },
 [0x412]={
  adobename="afii10019",
  category="lu",
  cjkwd="a",
  contextname="cyrillicV",
  description="CYRILLIC CAPITAL LETTER VE",
  direction="l",
  lccode=0x432,
  linebreak="al",
  unicodeslot=0x412,
 },
 [0x413]={
  adobename="afii10020",
  category="lu",
  cjkwd="a",
  contextname="cyrillicG",
  description="CYRILLIC CAPITAL LETTER GHE",
  direction="l",
  lccode=0x433,
  linebreak="al",
  unicodeslot=0x413,
 },
 [0x414]={
  adobename="afii10021",
  category="lu",
  cjkwd="a",
  contextname="cyrillicD",
  description="CYRILLIC CAPITAL LETTER DE",
  direction="l",
  lccode=0x434,
  linebreak="al",
  unicodeslot=0x414,
 },
 [0x415]={
  adobename="afii10022",
  category="lu",
  cjkwd="a",
  contextname="cyrillicE",
  description="CYRILLIC CAPITAL LETTER IE",
  direction="l",
  lccode=0x435,
  linebreak="al",
  unicodeslot=0x415,
 },
 [0x416]={
  adobename="afii10024",
  category="lu",
  cjkwd="a",
  contextname="cyrillicZH",
  description="CYRILLIC CAPITAL LETTER ZHE",
  direction="l",
  lccode=0x436,
  linebreak="al",
  unicodeslot=0x416,
 },
 [0x417]={
  adobename="afii10025",
  category="lu",
  cjkwd="a",
  contextname="cyrillicZ",
  description="CYRILLIC CAPITAL LETTER ZE",
  direction="l",
  lccode=0x437,
  linebreak="al",
  unicodeslot=0x417,
 },
 [0x418]={
  adobename="afii10026",
  category="lu",
  cjkwd="a",
  contextname="cyrillicI",
  description="CYRILLIC CAPITAL LETTER I",
  direction="l",
  lccode=0x438,
  linebreak="al",
  unicodeslot=0x418,
 },
 [0x419]={
  adobename="afii10027",
  category="lu",
  cjkwd="a",
  contextname="cyrillicISHRT",
  description="CYRILLIC CAPITAL LETTER SHORT I",
  direction="l",
  lccode=0x439,
  linebreak="al",
  specials={ "char", 0x418, 0x306 },
  unicodeslot=0x419,
 },
 [0x41A]={
  adobename="afii10028",
  category="lu",
  cjkwd="a",
  contextname="cyrillicK",
  description="CYRILLIC CAPITAL LETTER KA",
  direction="l",
  lccode=0x43A,
  linebreak="al",
  unicodeslot=0x41A,
 },
 [0x41B]={
  adobename="afii10029",
  category="lu",
  cjkwd="a",
  contextname="cyrillicL",
  description="CYRILLIC CAPITAL LETTER EL",
  direction="l",
  lccode=0x43B,
  linebreak="al",
  unicodeslot=0x41B,
 },
 [0x41C]={
  adobename="afii10030",
  category="lu",
  cjkwd="a",
  contextname="cyrillicM",
  description="CYRILLIC CAPITAL LETTER EM",
  direction="l",
  lccode=0x43C,
  linebreak="al",
  unicodeslot=0x41C,
 },
 [0x41D]={
  adobename="afii10031",
  category="lu",
  cjkwd="a",
  contextname="cyrillicN",
  description="CYRILLIC CAPITAL LETTER EN",
  direction="l",
  lccode=0x43D,
  linebreak="al",
  unicodeslot=0x41D,
 },
 [0x41E]={
  adobename="afii10032",
  category="lu",
  cjkwd="a",
  contextname="cyrillicO",
  description="CYRILLIC CAPITAL LETTER O",
  direction="l",
  lccode=0x43E,
  linebreak="al",
  unicodeslot=0x41E,
 },
 [0x41F]={
  adobename="afii10033",
  category="lu",
  cjkwd="a",
  contextname="cyrillicP",
  description="CYRILLIC CAPITAL LETTER PE",
  direction="l",
  lccode=0x43F,
  linebreak="al",
  unicodeslot=0x41F,
 },
 [0x420]={
  adobename="afii10034",
  category="lu",
  cjkwd="a",
  contextname="cyrillicR",
  description="CYRILLIC CAPITAL LETTER ER",
  direction="l",
  lccode=0x440,
  linebreak="al",
  unicodeslot=0x420,
 },
 [0x421]={
  adobename="afii10035",
  category="lu",
  cjkwd="a",
  contextname="cyrillicS",
  description="CYRILLIC CAPITAL LETTER ES",
  direction="l",
  lccode=0x441,
  linebreak="al",
  unicodeslot=0x421,
 },
 [0x422]={
  adobename="afii10036",
  category="lu",
  cjkwd="a",
  contextname="cyrillicT",
  description="CYRILLIC CAPITAL LETTER TE",
  direction="l",
  lccode=0x442,
  linebreak="al",
  unicodeslot=0x422,
 },
 [0x423]={
  adobename="afii10037",
  category="lu",
  cjkwd="a",
  contextname="cyrillicU",
  description="CYRILLIC CAPITAL LETTER U",
  direction="l",
  lccode=0x443,
  linebreak="al",
  unicodeslot=0x423,
 },
 [0x424]={
  adobename="afii10038",
  category="lu",
  cjkwd="a",
  contextname="cyrillicF",
  description="CYRILLIC CAPITAL LETTER EF",
  direction="l",
  lccode=0x444,
  linebreak="al",
  unicodeslot=0x424,
 },
 [0x425]={
  adobename="afii10039",
  category="lu",
  cjkwd="a",
  contextname="cyrillicH",
  description="CYRILLIC CAPITAL LETTER HA",
  direction="l",
  lccode=0x445,
  linebreak="al",
  unicodeslot=0x425,
 },
 [0x426]={
  adobename="afii10040",
  category="lu",
  cjkwd="a",
  contextname="cyrillicC",
  description="CYRILLIC CAPITAL LETTER TSE",
  direction="l",
  lccode=0x446,
  linebreak="al",
  unicodeslot=0x426,
 },
 [0x427]={
  adobename="afii10041",
  category="lu",
  cjkwd="a",
  contextname="cyrillicCH",
  description="CYRILLIC CAPITAL LETTER CHE",
  direction="l",
  lccode=0x447,
  linebreak="al",
  unicodeslot=0x427,
 },
 [0x428]={
  adobename="afii10042",
  category="lu",
  cjkwd="a",
  contextname="cyrillicSH",
  description="CYRILLIC CAPITAL LETTER SHA",
  direction="l",
  lccode=0x448,
  linebreak="al",
  unicodeslot=0x428,
 },
 [0x429]={
  adobename="afii10043",
  category="lu",
  cjkwd="a",
  contextname="cyrillicSHCH",
  description="CYRILLIC CAPITAL LETTER SHCHA",
  direction="l",
  lccode=0x449,
  linebreak="al",
  unicodeslot=0x429,
 },
 [0x42A]={
  adobename="afii10044",
  category="lu",
  cjkwd="a",
  contextname="cyrillicHRDSN",
  description="CYRILLIC CAPITAL LETTER HARD SIGN",
  direction="l",
  lccode=0x44A,
  linebreak="al",
  unicodeslot=0x42A,
 },
 [0x42B]={
  adobename="afii10045",
  category="lu",
  cjkwd="a",
  contextname="cyrillicERY",
  description="CYRILLIC CAPITAL LETTER YERU",
  direction="l",
  lccode=0x44B,
  linebreak="al",
  unicodeslot=0x42B,
 },
 [0x42C]={
  adobename="afii10046",
  category="lu",
  cjkwd="a",
  contextname="cyrillicSFTSN",
  description="CYRILLIC CAPITAL LETTER SOFT SIGN",
  direction="l",
  lccode=0x44C,
  linebreak="al",
  unicodeslot=0x42C,
 },
 [0x42D]={
  adobename="afii10047",
  category="lu",
  cjkwd="a",
  contextname="cyrillicEREV",
  description="CYRILLIC CAPITAL LETTER E",
  direction="l",
  lccode=0x44D,
  linebreak="al",
  unicodeslot=0x42D,
 },
 [0x42E]={
  adobename="afii10048",
  category="lu",
  cjkwd="a",
  contextname="cyrillicYU",
  description="CYRILLIC CAPITAL LETTER YU",
  direction="l",
  lccode=0x44E,
  linebreak="al",
  unicodeslot=0x42E,
 },
 [0x42F]={
  adobename="afii10049",
  category="lu",
  cjkwd="a",
  contextname="cyrillicYA",
  description="CYRILLIC CAPITAL LETTER YA",
  direction="l",
  lccode=0x44F,
  linebreak="al",
  unicodeslot=0x42F,
 },
 [0x430]={
  adobename="afii10065",
  category="ll",
  cjkwd="a",
  contextname="cyrillica",
  description="CYRILLIC SMALL LETTER A",
  direction="l",
  linebreak="al",
  uccode=0x410,
  unicodeslot=0x430,
 },
 [0x431]={
  adobename="becyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicb",
  description="CYRILLIC SMALL LETTER BE",
  direction="l",
  linebreak="al",
  uccode=0x411,
  unicodeslot=0x431,
 },
 [0x432]={
  adobename="vecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicv",
  description="CYRILLIC SMALL LETTER VE",
  direction="l",
  linebreak="al",
  uccode=0x412,
  unicodeslot=0x432,
 },
 [0x433]={
  adobename="gecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicg",
  description="CYRILLIC SMALL LETTER GHE",
  direction="l",
  linebreak="al",
  uccode=0x413,
  unicodeslot=0x433,
 },
 [0x434]={
  adobename="decyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicd",
  description="CYRILLIC SMALL LETTER DE",
  direction="l",
  linebreak="al",
  uccode=0x414,
  unicodeslot=0x434,
 },
 [0x435]={
  adobename="iecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillice",
  description="CYRILLIC SMALL LETTER IE",
  direction="l",
  linebreak="al",
  uccode=0x415,
  unicodeslot=0x435,
 },
 [0x436]={
  adobename="zhecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrilliczh",
  description="CYRILLIC SMALL LETTER ZHE",
  direction="l",
  linebreak="al",
  uccode=0x416,
  unicodeslot=0x436,
 },
 [0x437]={
  adobename="zecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicz",
  description="CYRILLIC SMALL LETTER ZE",
  direction="l",
  linebreak="al",
  uccode=0x417,
  unicodeslot=0x437,
 },
 [0x438]={
  adobename="iicyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillici",
  description="CYRILLIC SMALL LETTER I",
  direction="l",
  linebreak="al",
  uccode=0x418,
  unicodeslot=0x438,
 },
 [0x439]={
  adobename="iishortcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicishrt",
  description="CYRILLIC SMALL LETTER SHORT I",
  direction="l",
  linebreak="al",
  specials={ "char", 0x438, 0x306 },
  uccode=0x419,
  unicodeslot=0x439,
 },
 [0x43A]={
  adobename="kacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillick",
  description="CYRILLIC SMALL LETTER KA",
  direction="l",
  linebreak="al",
  uccode=0x41A,
  unicodeslot=0x43A,
 },
 [0x43B]={
  adobename="elcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicl",
  description="CYRILLIC SMALL LETTER EL",
  direction="l",
  linebreak="al",
  uccode=0x41B,
  unicodeslot=0x43B,
 },
 [0x43C]={
  adobename="emcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicm",
  description="CYRILLIC SMALL LETTER EM",
  direction="l",
  linebreak="al",
  uccode=0x41C,
  unicodeslot=0x43C,
 },
 [0x43D]={
  adobename="encyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicn",
  description="CYRILLIC SMALL LETTER EN",
  direction="l",
  linebreak="al",
  uccode=0x41D,
  unicodeslot=0x43D,
 },
 [0x43E]={
  adobename="ocyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillico",
  description="CYRILLIC SMALL LETTER O",
  direction="l",
  linebreak="al",
  uccode=0x41E,
  unicodeslot=0x43E,
 },
 [0x43F]={
  adobename="pecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicp",
  description="CYRILLIC SMALL LETTER PE",
  direction="l",
  linebreak="al",
  uccode=0x41F,
  unicodeslot=0x43F,
 },
 [0x440]={
  adobename="ercyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicr",
  description="CYRILLIC SMALL LETTER ER",
  direction="l",
  linebreak="al",
  uccode=0x420,
  unicodeslot=0x440,
 },
 [0x441]={
  adobename="escyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillics",
  description="CYRILLIC SMALL LETTER ES",
  direction="l",
  linebreak="al",
  uccode=0x421,
  unicodeslot=0x441,
 },
 [0x442]={
  adobename="tecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillict",
  description="CYRILLIC SMALL LETTER TE",
  direction="l",
  linebreak="al",
  uccode=0x422,
  unicodeslot=0x442,
 },
 [0x443]={
  adobename="ucyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicu",
  description="CYRILLIC SMALL LETTER U",
  direction="l",
  linebreak="al",
  uccode=0x423,
  unicodeslot=0x443,
 },
 [0x444]={
  adobename="efcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicf",
  description="CYRILLIC SMALL LETTER EF",
  direction="l",
  linebreak="al",
  uccode=0x424,
  unicodeslot=0x444,
 },
 [0x445]={
  adobename="khacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillich",
  description="CYRILLIC SMALL LETTER HA",
  direction="l",
  linebreak="al",
  uccode=0x425,
  unicodeslot=0x445,
 },
 [0x446]={
  adobename="tsecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicc",
  description="CYRILLIC SMALL LETTER TSE",
  direction="l",
  linebreak="al",
  uccode=0x426,
  unicodeslot=0x446,
 },
 [0x447]={
  adobename="checyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicch",
  description="CYRILLIC SMALL LETTER CHE",
  direction="l",
  linebreak="al",
  uccode=0x427,
  unicodeslot=0x447,
 },
 [0x448]={
  adobename="shacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicsh",
  description="CYRILLIC SMALL LETTER SHA",
  direction="l",
  linebreak="al",
  uccode=0x428,
  unicodeslot=0x448,
 },
 [0x449]={
  adobename="shchacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicshch",
  description="CYRILLIC SMALL LETTER SHCHA",
  direction="l",
  linebreak="al",
  uccode=0x429,
  unicodeslot=0x449,
 },
 [0x44A]={
  adobename="hardsigncyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillichrdsn",
  description="CYRILLIC SMALL LETTER HARD SIGN",
  direction="l",
  linebreak="al",
  uccode=0x42A,
  unicodeslot=0x44A,
 },
 [0x44B]={
  adobename="yericyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicery",
  description="CYRILLIC SMALL LETTER YERU",
  direction="l",
  linebreak="al",
  uccode=0x42B,
  unicodeslot=0x44B,
 },
 [0x44C]={
  adobename="softsigncyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicsftsn",
  description="CYRILLIC SMALL LETTER SOFT SIGN",
  direction="l",
  linebreak="al",
  uccode=0x42C,
  unicodeslot=0x44C,
 },
 [0x44D]={
  adobename="ereversedcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicerev",
  description="CYRILLIC SMALL LETTER E",
  direction="l",
  linebreak="al",
  uccode=0x42D,
  unicodeslot=0x44D,
 },
 [0x44E]={
  adobename="iucyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicyu",
  description="CYRILLIC SMALL LETTER YU",
  direction="l",
  linebreak="al",
  uccode=0x42E,
  unicodeslot=0x44E,
 },
 [0x44F]={
  adobename="iacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicya",
  description="CYRILLIC SMALL LETTER YA",
  direction="l",
  linebreak="al",
  uccode=0x42F,
  unicodeslot=0x44F,
 },
 [0x450]={
  category="ll",
  contextname="cyrillicegrave",
  description="CYRILLIC SMALL LETTER IE WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x435,
  specials={ "char", 0x435, 0x300 },
  uccode=0x400,
  unicodeslot=0x450,
 },
 [0x451]={
  adobename="iocyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicyo",
  description="CYRILLIC SMALL LETTER IO",
  direction="l",
  linebreak="al",
  specials={ "char", 0x435, 0x308 },
  uccode=0x401,
  unicodeslot=0x451,
 },
 [0x452]={
  adobename="djecyrillic",
  category="ll",
  contextname="cyrillicdje",
  description="CYRILLIC SMALL LETTER DJE",
  direction="l",
  linebreak="al",
  uccode=0x402,
  unicodeslot=0x452,
 },
 [0x453]={
  adobename="gjecyrillic",
  category="ll",
  contextname="cyrillicgje",
  description="CYRILLIC SMALL LETTER GJE",
  direction="l",
  linebreak="al",
  specials={ "char", 0x433, 0x301 },
  uccode=0x403,
  unicodeslot=0x453,
 },
 [0x454]={
  adobename="ecyrillic",
  category="ll",
  contextname="cyrillicie",
  description="CYRILLIC SMALL LETTER UKRAINIAN IE",
  direction="l",
  linebreak="al",
  uccode=0x404,
  unicodeslot=0x454,
 },
 [0x455]={
  adobename="dzecyrillic",
  category="ll",
  contextname="cyrillicdze",
  description="CYRILLIC SMALL LETTER DZE",
  direction="l",
  linebreak="al",
  uccode=0x405,
  unicodeslot=0x455,
 },
 [0x456]={
  adobename="icyrillic",
  category="ll",
  contextname="cyrillicii",
  description="CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I",
  direction="l",
  linebreak="al",
  uccode=0x406,
  unicodeslot=0x456,
 },
 [0x457]={
  adobename="yicyrillic",
  category="ll",
  contextname="cyrillicyi",
  description="CYRILLIC SMALL LETTER YI",
  direction="l",
  linebreak="al",
  specials={ "char", 0x456, 0x308 },
  uccode=0x407,
  unicodeslot=0x457,
 },
 [0x458]={
  adobename="jecyrillic",
  category="ll",
  contextname="cyrillicje",
  description="CYRILLIC SMALL LETTER JE",
  direction="l",
  linebreak="al",
  uccode=0x408,
  unicodeslot=0x458,
 },
 [0x459]={
  adobename="ljecyrillic",
  category="ll",
  contextname="cyrilliclje",
  description="CYRILLIC SMALL LETTER LJE",
  direction="l",
  linebreak="al",
  uccode=0x409,
  unicodeslot=0x459,
 },
 [0x45A]={
  adobename="njecyrillic",
  category="ll",
  contextname="cyrillicnje",
  description="CYRILLIC SMALL LETTER NJE",
  direction="l",
  linebreak="al",
  uccode=0x40A,
  unicodeslot=0x45A,
 },
 [0x45B]={
  adobename="tshecyrillic",
  category="ll",
  contextname="cyrillictshe",
  description="CYRILLIC SMALL LETTER TSHE",
  direction="l",
  linebreak="al",
  uccode=0x40B,
  unicodeslot=0x45B,
 },
 [0x45C]={
  adobename="kjecyrillic",
  category="ll",
  contextname="cyrillickje",
  description="CYRILLIC SMALL LETTER KJE",
  direction="l",
  linebreak="al",
  specials={ "char", 0x43A, 0x301 },
  uccode=0x40C,
  unicodeslot=0x45C,
 },
 [0x45D]={
  category="ll",
  contextname="cyrillicigrave",
  description="CYRILLIC SMALL LETTER I WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x438,
  specials={ "char", 0x438, 0x300 },
  uccode=0x40D,
  unicodeslot=0x45D,
 },
 [0x45E]={
  adobename="ushortcyrillic",
  category="ll",
  contextname="cyrillicushrt",
  description="CYRILLIC SMALL LETTER SHORT U",
  direction="l",
  linebreak="al",
  specials={ "char", 0x443, 0x306 },
  uccode=0x40E,
  unicodeslot=0x45E,
 },
 [0x45F]={
  adobename="dzhecyrillic",
  category="ll",
  contextname="cyrillicdzhe",
  description="CYRILLIC SMALL LETTER DZHE",
  direction="l",
  linebreak="al",
  uccode=0x40F,
  unicodeslot=0x45F,
 },
 [0x460]={
  adobename="Omegacyrillic",
  category="lu",
  contextname="cyrillicOMEGA",
  description="CYRILLIC CAPITAL LETTER OMEGA",
  direction="l",
  lccode=0x461,
  linebreak="al",
  unicodeslot=0x460,
 },
 [0x461]={
  adobename="omegacyrillic",
  category="ll",
  contextname="cyrillicomega",
  description="CYRILLIC SMALL LETTER OMEGA",
  direction="l",
  linebreak="al",
  uccode=0x460,
  unicodeslot=0x461,
 },
 [0x462]={
  adobename="afii10146",
  category="lu",
  contextname="cyrillicYAT",
  description="CYRILLIC CAPITAL LETTER YAT",
  direction="l",
  lccode=0x463,
  linebreak="al",
  unicodeslot=0x462,
 },
 [0x463]={
  adobename="yatcyrillic",
  category="ll",
  contextname="cyrillicyat",
  description="CYRILLIC SMALL LETTER YAT",
  direction="l",
  linebreak="al",
  uccode=0x462,
  unicodeslot=0x463,
 },
 [0x464]={
  adobename="Eiotifiedcyrillic",
  category="lu",
  contextname="cyrillicEiotified",
  description="CYRILLIC CAPITAL LETTER IOTIFIED E",
  direction="l",
  lccode=0x465,
  linebreak="al",
  unicodeslot=0x464,
 },
 [0x465]={
  adobename="eiotifiedcyrillic",
  category="ll",
  contextname="cyrilliceiotified",
  description="CYRILLIC SMALL LETTER IOTIFIED E",
  direction="l",
  linebreak="al",
  uccode=0x464,
  unicodeslot=0x465,
 },
 [0x466]={
  adobename="Yuslittlecyrillic",
  category="lu",
  contextname="cyrillicLITTLEYUS",
  description="CYRILLIC CAPITAL LETTER LITTLE YUS",
  direction="l",
  lccode=0x467,
  linebreak="al",
  unicodeslot=0x466,
 },
 [0x467]={
  adobename="yuslittlecyrillic",
  category="ll",
  contextname="cyrilliclittleyus",
  description="CYRILLIC SMALL LETTER LITTLE YUS",
  direction="l",
  linebreak="al",
  uccode=0x466,
  unicodeslot=0x467,
 },
 [0x468]={
  adobename="Yuslittleiotifiedcyrillic",
  category="lu",
  contextname="cyrillicLITTLEYUSiotified",
  description="CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS",
  direction="l",
  lccode=0x469,
  linebreak="al",
  unicodeslot=0x468,
 },
 [0x469]={
  adobename="yuslittleiotifiedcyrillic",
  category="ll",
  contextname="cyrilliclittleyusiotified",
  description="CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS",
  direction="l",
  linebreak="al",
  uccode=0x468,
  unicodeslot=0x469,
 },
 [0x46A]={
  adobename="Yusbigcyrillic",
  category="lu",
  contextname="cyrillicBIGYUS",
  description="CYRILLIC CAPITAL LETTER BIG YUS",
  direction="l",
  lccode=0x46B,
  linebreak="al",
  unicodeslot=0x46A,
 },
 [0x46B]={
  adobename="yusbigcyrillic",
  category="ll",
  contextname="cyrillicbigyus",
  description="CYRILLIC SMALL LETTER BIG YUS",
  direction="l",
  linebreak="al",
  uccode=0x46A,
  unicodeslot=0x46B,
 },
 [0x46C]={
  adobename="Yusbigiotifiedcyrillic",
  category="lu",
  contextname="cyrillicBIGYUSiotified",
  description="CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS",
  direction="l",
  lccode=0x46D,
  linebreak="al",
  unicodeslot=0x46C,
 },
 [0x46D]={
  adobename="yusbigiotifiedcyrillic",
  category="ll",
  contextname="cyrillicbigyusiotified",
  description="CYRILLIC SMALL LETTER IOTIFIED BIG YUS",
  direction="l",
  linebreak="al",
  uccode=0x46C,
  unicodeslot=0x46D,
 },
 [0x46E]={
  adobename="Ksicyrillic",
  category="lu",
  contextname="cyrillicKSI",
  description="CYRILLIC CAPITAL LETTER KSI",
  direction="l",
  lccode=0x46F,
  linebreak="al",
  unicodeslot=0x46E,
 },
 [0x46F]={
  adobename="ksicyrillic",
  category="ll",
  contextname="cyrillicksi",
  description="CYRILLIC SMALL LETTER KSI",
  direction="l",
  linebreak="al",
  uccode=0x46E,
  unicodeslot=0x46F,
 },
 [0x470]={
  adobename="Psicyrillic",
  category="lu",
  contextname="cyrillicPSI",
  description="CYRILLIC CAPITAL LETTER PSI",
  direction="l",
  lccode=0x471,
  linebreak="al",
  unicodeslot=0x470,
 },
 [0x471]={
  adobename="psicyrillic",
  category="ll",
  contextname="cyrillicpsi",
  description="CYRILLIC SMALL LETTER PSI",
  direction="l",
  linebreak="al",
  uccode=0x470,
  unicodeslot=0x471,
 },
 [0x472]={
  adobename="afii10147",
  category="lu",
  contextname="cyrillicFITA",
  description="CYRILLIC CAPITAL LETTER FITA",
  direction="l",
  lccode=0x473,
  linebreak="al",
  unicodeslot=0x472,
 },
 [0x473]={
  adobename="fitacyrillic",
  category="ll",
  contextname="cyrillicfita",
  description="CYRILLIC SMALL LETTER FITA",
  direction="l",
  linebreak="al",
  uccode=0x472,
  unicodeslot=0x473,
 },
 [0x474]={
  adobename="afii10148",
  category="lu",
  contextname="cyrillicIZHITSA",
  description="CYRILLIC CAPITAL LETTER IZHITSA",
  direction="l",
  lccode=0x475,
  linebreak="al",
  unicodeslot=0x474,
 },
 [0x475]={
  adobename="izhitsacyrillic",
  category="ll",
  contextname="cyrillicizhitsa",
  description="CYRILLIC SMALL LETTER IZHITSA",
  direction="l",
  linebreak="al",
  uccode=0x474,
  unicodeslot=0x475,
 },
 [0x476]={
  adobename="Izhitsadblgravecyrillic",
  category="lu",
  contextname="cyrillicIZHITSAdoublegrave",
  description="CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
  direction="l",
  lccode=0x477,
  linebreak="al",
  shcode=0x474,
  specials={ "char", 0x474, 0x30F },
  unicodeslot=0x476,
 },
 [0x477]={
  adobename="izhitsadblgravecyrillic",
  category="ll",
  contextname="cyrillicizhitsadoublegrave",
  description="CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
  direction="l",
  linebreak="al",
  shcode=0x475,
  specials={ "char", 0x475, 0x30F },
  uccode=0x476,
  unicodeslot=0x477,
 },
 [0x478]={
  adobename="Ukcyrillic",
  category="lu",
  contextname="cyrillicUK",
  description="CYRILLIC CAPITAL LETTER UK",
  direction="l",
  lccode=0x479,
  linebreak="al",
  unicodeslot=0x478,
 },
 [0x479]={
  adobename="ukcyrillic",
  category="ll",
  contextname="cyrillicuk",
  description="CYRILLIC SMALL LETTER UK",
  direction="l",
  linebreak="al",
  uccode=0x478,
  unicodeslot=0x479,
 },
 [0x47A]={
  adobename="Omegaroundcyrillic",
  category="lu",
  contextname="cyrillicOMEGAround",
  description="CYRILLIC CAPITAL LETTER ROUND OMEGA",
  direction="l",
  lccode=0x47B,
  linebreak="al",
  unicodeslot=0x47A,
 },
 [0x47B]={
  adobename="omegaroundcyrillic",
  category="ll",
  contextname="cyrillicomegaround",
  description="CYRILLIC SMALL LETTER ROUND OMEGA",
  direction="l",
  linebreak="al",
  uccode=0x47A,
  unicodeslot=0x47B,
 },
 [0x47C]={
  adobename="Omegatitlocyrillic",
  category="lu",
  contextname="cyrillicOMEGAtitlo",
  description="CYRILLIC CAPITAL LETTER OMEGA WITH TITLO",
  direction="l",
  lccode=0x47D,
  linebreak="al",
  shcode=0x460,
  unicodeslot=0x47C,
 },
 [0x47D]={
  adobename="omegatitlocyrillic",
  category="ll",
  contextname="cyrillicomegatitlo",
  description="CYRILLIC SMALL LETTER OMEGA WITH TITLO",
  direction="l",
  linebreak="al",
  shcode=0x461,
  uccode=0x47C,
  unicodeslot=0x47D,
 },
 [0x47E]={
  adobename="Otcyrillic",
  category="lu",
  contextname="cyrillicOT",
  description="CYRILLIC CAPITAL LETTER OT",
  direction="l",
  lccode=0x47F,
  linebreak="al",
  unicodeslot=0x47E,
 },
 [0x47F]={
  adobename="otcyrillic",
  category="ll",
  contextname="cyrillicot",
  description="CYRILLIC SMALL LETTER OT",
  direction="l",
  linebreak="al",
  uccode=0x47E,
  unicodeslot=0x47F,
 },
 [0x480]={
  adobename="Koppacyrillic",
  category="lu",
  contextname="cyrillicKOPPA",
  description="CYRILLIC CAPITAL LETTER KOPPA",
  direction="l",
  lccode=0x481,
  linebreak="al",
  unicodeslot=0x480,
 },
 [0x481]={
  adobename="koppacyrillic",
  category="ll",
  contextname="cyrillickoppa",
  description="CYRILLIC SMALL LETTER KOPPA",
  direction="l",
  linebreak="al",
  uccode=0x480,
  unicodeslot=0x481,
 },
 [0x482]={
  adobename="thousandcyrillic",
  category="so",
  description="CYRILLIC THOUSANDS SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x482,
 },
 [0x483]={
  adobename="titlocyrilliccmb",
  category="mn",
  combining=0xE6,
  contextname="cyrillicTITLO",
  description="COMBINING CYRILLIC TITLO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x483,
 },
 [0x484]={
  adobename="palatalizationcyrilliccmb",
  category="mn",
  combining=0xE6,
  contextname="cyrillicPALATALIZATION",
  description="COMBINING CYRILLIC PALATALIZATION",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x484,
 },
 [0x485]={
  adobename="dasiapneumatacyrilliccmb",
  category="mn",
  combining=0xE6,
  contextname="cyrillicDASIAPNEUMATA",
  description="COMBINING CYRILLIC DASIA PNEUMATA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x485,
 },
 [0x486]={
  adobename="psilipneumatacyrilliccmb",
  category="mn",
  combining=0xE6,
  contextname="cyrillicPSILIPNEUMATA",
  description="COMBINING CYRILLIC PSILI PNEUMATA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x486,
 },
 [0x487]={
  category="mn",
  combining=0xE6,
  description="COMBINING CYRILLIC POKRYTIE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x487,
 },
 [0x488]={
  category="me",
  description="COMBINING CYRILLIC HUNDRED THOUSANDS SIGN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x488,
 },
 [0x489]={
  category="me",
  description="COMBINING CYRILLIC MILLIONS SIGN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x489,
 },
 [0x48A]={
  category="lu",
  contextname="cyrillicISHRTtail",
  description="CYRILLIC CAPITAL LETTER SHORT I WITH TAIL",
  direction="l",
  lccode=0x48B,
  linebreak="al",
  unicodeslot=0x48A,
 },
 [0x48B]={
  category="ll",
  contextname="cyrillicishrttail",
  description="CYRILLIC SMALL LETTER SHORT I WITH TAIL",
  direction="l",
  linebreak="al",
  uccode=0x48A,
  unicodeslot=0x48B,
 },
 [0x48C]={
  category="lu",
  contextname="cyrillicSEMISOFT",
  description="CYRILLIC CAPITAL LETTER SEMISOFT SIGN",
  direction="l",
  lccode=0x48D,
  linebreak="al",
  unicodeslot=0x48C,
 },
 [0x48D]={
  category="ll",
  contextname="cyrillicsemisoft",
  description="CYRILLIC SMALL LETTER SEMISOFT SIGN",
  direction="l",
  linebreak="al",
  uccode=0x48C,
  unicodeslot=0x48D,
 },
 [0x48E]={
  category="lu",
  contextname="cyrillicERtick",
  description="CYRILLIC CAPITAL LETTER ER WITH TICK",
  direction="l",
  lccode=0x48F,
  linebreak="al",
  shcode=0x420,
  unicodeslot=0x48E,
 },
 [0x48F]={
  category="ll",
  contextname="cyrillicertick",
  description="CYRILLIC SMALL LETTER ER WITH TICK",
  direction="l",
  linebreak="al",
  shcode=0x440,
  uccode=0x48E,
  unicodeslot=0x48F,
 },
 [0x490]={
  adobename="afii10050",
  category="lu",
  contextname="cyrillicGHEupturn",
  description="CYRILLIC CAPITAL LETTER GHE WITH UPTURN",
  direction="l",
  lccode=0x491,
  linebreak="al",
  shcode=0x413,
  unicodeslot=0x490,
 },
 [0x491]={
  adobename="gheupturncyrillic",
  category="ll",
  contextname="cyrillicgheupturn",
  description="CYRILLIC SMALL LETTER GHE WITH UPTURN",
  direction="l",
  linebreak="al",
  shcode=0x433,
  uccode=0x490,
  unicodeslot=0x491,
 },
 [0x492]={
  adobename="Ghestrokecyrillic",
  category="lu",
  contextname="cyrillicGHEstroke",
  description="CYRILLIC CAPITAL LETTER GHE WITH STROKE",
  direction="l",
  lccode=0x493,
  linebreak="al",
  shcode=0x413,
  unicodeslot=0x492,
 },
 [0x493]={
  adobename="ghestrokecyrillic",
  category="ll",
  contextname="cyrillicghestroke",
  description="CYRILLIC SMALL LETTER GHE WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x433,
  uccode=0x492,
  unicodeslot=0x493,
 },
 [0x494]={
  adobename="Ghemiddlehookcyrillic",
  category="lu",
  contextname="cyrillicGHEmidhook",
  description="CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK",
  direction="l",
  lccode=0x495,
  linebreak="al",
  shcode=0x413,
  unicodeslot=0x494,
 },
 [0x495]={
  adobename="ghemiddlehookcyrillic",
  category="ll",
  contextname="cyrillicghemidhook",
  description="CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  shcode=0x433,
  uccode=0x494,
  unicodeslot=0x495,
 },
 [0x496]={
  adobename="Zhedescendercyrillic",
  category="lu",
  contextname="cyrillicZHEdescender",
  description="CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER",
  direction="l",
  lccode=0x497,
  linebreak="al",
  shcode=0x416,
  unicodeslot=0x496,
 },
 [0x497]={
  adobename="zhedescendercyrillic",
  category="ll",
  contextname="cyrilliczhedescender",
  description="CYRILLIC SMALL LETTER ZHE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x436,
  uccode=0x496,
  unicodeslot=0x497,
 },
 [0x498]={
  adobename="Zedescendercyrillic",
  category="lu",
  contextname="cyrillicZDSC",
  description="CYRILLIC CAPITAL LETTER ZE WITH DESCENDER",
  direction="l",
  lccode=0x499,
  linebreak="al",
  shcode=0x417,
  unicodeslot=0x498,
 },
 [0x499]={
  adobename="zedescendercyrillic",
  category="ll",
  contextname="cyrilliczdsc",
  description="CYRILLIC SMALL LETTER ZE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x437,
  uccode=0x498,
  unicodeslot=0x499,
 },
 [0x49A]={
  adobename="Kadescendercyrillic",
  category="lu",
  contextname="cyrillicKADC",
  description="CYRILLIC CAPITAL LETTER KA WITH DESCENDER",
  direction="l",
  lccode=0x49B,
  linebreak="al",
  shcode=0x41A,
  unicodeslot=0x49A,
 },
 [0x49B]={
  adobename="kadescendercyrillic",
  category="ll",
  contextname="cyrillickadc",
  description="CYRILLIC SMALL LETTER KA WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x43A,
  uccode=0x49A,
  unicodeslot=0x49B,
 },
 [0x49C]={
  adobename="Kaverticalstrokecyrillic",
  category="lu",
  contextname="cyrillicKAvertstroke",
  description="CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE",
  direction="l",
  lccode=0x49D,
  linebreak="al",
  shcode=0x41A,
  unicodeslot=0x49C,
 },
 [0x49D]={
  adobename="kaverticalstrokecyrillic",
  category="ll",
  contextname="cyrillickavertstroke",
  description="CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE",
  direction="l",
  linebreak="al",
  shcode=0x43A,
  uccode=0x49C,
  unicodeslot=0x49D,
 },
 [0x49E]={
  adobename="Kastrokecyrillic",
  category="lu",
  contextname="cyrillicKAstroke",
  description="CYRILLIC CAPITAL LETTER KA WITH STROKE",
  direction="l",
  lccode=0x49F,
  linebreak="al",
  shcode=0x41A,
  unicodeslot=0x49E,
 },
 [0x49F]={
  adobename="kastrokecyrillic",
  category="ll",
  contextname="cyrillickastroke",
  description="CYRILLIC SMALL LETTER KA WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x43A,
  uccode=0x49E,
  unicodeslot=0x49F,
 },
 [0x4A0]={
  adobename="Kabashkircyrillic",
  category="lu",
  contextname="cyrillicKAbashkir",
  description="CYRILLIC CAPITAL LETTER BASHKIR KA",
  direction="l",
  lccode=0x4A1,
  linebreak="al",
  unicodeslot=0x4A0,
 },
 [0x4A1]={
  adobename="kabashkircyrillic",
  category="ll",
  contextname="cyrillickabashkir",
  description="CYRILLIC SMALL LETTER BASHKIR KA",
  direction="l",
  linebreak="al",
  uccode=0x4A0,
  unicodeslot=0x4A1,
 },
 [0x4A2]={
  adobename="Endescendercyrillic",
  category="lu",
  contextname="cyrillicENDC",
  description="CYRILLIC CAPITAL LETTER EN WITH DESCENDER",
  direction="l",
  lccode=0x4A3,
  linebreak="al",
  shcode=0x41D,
  unicodeslot=0x4A2,
 },
 [0x4A3]={
  adobename="endescendercyrillic",
  category="ll",
  contextname="cyrillicendc",
  description="CYRILLIC SMALL LETTER EN WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x43D,
  uccode=0x4A2,
  unicodeslot=0x4A3,
 },
 [0x4A4]={
  adobename="Enghecyrillic",
  category="lu",
  contextname="cyrillicENGHE",
  description="CYRILLIC CAPITAL LIGATURE EN GHE",
  direction="l",
  lccode=0x4A5,
  linebreak="al",
  unicodeslot=0x4A4,
 },
 [0x4A5]={
  adobename="enghecyrillic",
  category="ll",
  contextname="cyrillicenghe",
  description="CYRILLIC SMALL LIGATURE EN GHE",
  direction="l",
  linebreak="al",
  uccode=0x4A4,
  unicodeslot=0x4A5,
 },
 [0x4A6]={
  adobename="Pemiddlehookcyrillic",
  category="lu",
  contextname="cyrillicPEmidhook",
  description="CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK",
  direction="l",
  lccode=0x4A7,
  linebreak="al",
  shcode=0x41F,
  unicodeslot=0x4A6,
 },
 [0x4A7]={
  adobename="pemiddlehookcyrillic",
  category="ll",
  contextname="cyrillicpemidhook",
  description="CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  shcode=0x43F,
  uccode=0x4A6,
  unicodeslot=0x4A7,
 },
 [0x4A8]={
  adobename="Haabkhasiancyrillic",
  category="lu",
  contextname="cyrillicHA",
  description="CYRILLIC CAPITAL LETTER ABKHASIAN HA",
  direction="l",
  lccode=0x4A9,
  linebreak="al",
  unicodeslot=0x4A8,
 },
 [0x4A9]={
  adobename="haabkhasiancyrillic",
  category="ll",
  contextname="cyrillicha",
  description="CYRILLIC SMALL LETTER ABKHASIAN HA",
  direction="l",
  linebreak="al",
  uccode=0x4A8,
  unicodeslot=0x4A9,
 },
 [0x4AA]={
  adobename="Esdescendercyrillic",
  category="lu",
  contextname="cyrillicSDSC",
  description="CYRILLIC CAPITAL LETTER ES WITH DESCENDER",
  direction="l",
  lccode=0x4AB,
  linebreak="al",
  shcode=0x421,
  unicodeslot=0x4AA,
 },
 [0x4AB]={
  adobename="esdescendercyrillic",
  category="ll",
  contextname="cyrillicsdsc",
  description="CYRILLIC SMALL LETTER ES WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x441,
  uccode=0x4AA,
  unicodeslot=0x4AB,
 },
 [0x4AC]={
  adobename="Tedescendercyrillic",
  category="lu",
  contextname="cyrillicTEDC",
  description="CYRILLIC CAPITAL LETTER TE WITH DESCENDER",
  direction="l",
  lccode=0x4AD,
  linebreak="al",
  shcode=0x422,
  unicodeslot=0x4AC,
 },
 [0x4AD]={
  adobename="tedescendercyrillic",
  category="ll",
  contextname="cyrillictedc",
  description="CYRILLIC SMALL LETTER TE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x442,
  uccode=0x4AC,
  unicodeslot=0x4AD,
 },
 [0x4AE]={
  adobename="Ustraightcyrillic",
  category="lu",
  contextname="cyrillicYstr",
  description="CYRILLIC CAPITAL LETTER STRAIGHT U",
  direction="l",
  lccode=0x4AF,
  linebreak="al",
  unicodeslot=0x4AE,
 },
 [0x4AF]={
  adobename="ustraightcyrillic",
  category="ll",
  contextname="cyrillicystr",
  description="CYRILLIC SMALL LETTER STRAIGHT U",
  direction="l",
  linebreak="al",
  uccode=0x4AE,
  unicodeslot=0x4AF,
 },
 [0x4B0]={
  adobename="Ustraightstrokecyrillic",
  category="lu",
  contextname="cyrillicYstrstroke",
  description="CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE",
  direction="l",
  lccode=0x4B1,
  linebreak="al",
  unicodeslot=0x4B0,
 },
 [0x4B1]={
  adobename="ustraightstrokecyrillic",
  category="ll",
  contextname="cyrillicystrstroke",
  description="CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE",
  direction="l",
  linebreak="al",
  uccode=0x4B0,
  unicodeslot=0x4B1,
 },
 [0x4B2]={
  adobename="Hadescendercyrillic",
  category="lu",
  contextname="cyrillicHADC",
  description="CYRILLIC CAPITAL LETTER HA WITH DESCENDER",
  direction="l",
  lccode=0x4B3,
  linebreak="al",
  shcode=0x425,
  unicodeslot=0x4B2,
 },
 [0x4B3]={
  adobename="hadescendercyrillic",
  category="ll",
  contextname="cyrillichadc",
  description="CYRILLIC SMALL LETTER HA WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x445,
  uccode=0x4B2,
  unicodeslot=0x4B3,
 },
 [0x4B4]={
  adobename="Tetsecyrillic",
  category="lu",
  contextname="cyrillicTETSE",
  description="CYRILLIC CAPITAL LIGATURE TE TSE",
  direction="l",
  lccode=0x4B5,
  linebreak="al",
  unicodeslot=0x4B4,
 },
 [0x4B5]={
  adobename="tetsecyrillic",
  category="ll",
  contextname="cyrillictetse",
  description="CYRILLIC SMALL LIGATURE TE TSE",
  direction="l",
  linebreak="al",
  uccode=0x4B4,
  unicodeslot=0x4B5,
 },
 [0x4B6]={
  adobename="Chedescendercyrillic",
  category="lu",
  contextname="cyrillicCHEDC",
  description="CYRILLIC CAPITAL LETTER CHE WITH DESCENDER",
  direction="l",
  lccode=0x4B7,
  linebreak="al",
  shcode=0x427,
  unicodeslot=0x4B6,
 },
 [0x4B7]={
  adobename="chedescendercyrillic",
  category="ll",
  contextname="cyrillicchedc",
  description="CYRILLIC SMALL LETTER CHE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x447,
  uccode=0x4B6,
  unicodeslot=0x4B7,
 },
 [0x4B8]={
  adobename="Cheverticalstrokecyrillic",
  category="lu",
  contextname="cyrillicCHEvertstroke",
  description="CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE",
  direction="l",
  lccode=0x4B9,
  linebreak="al",
  shcode=0x427,
  unicodeslot=0x4B8,
 },
 [0x4B9]={
  adobename="cheverticalstrokecyrillic",
  category="ll",
  contextname="cyrillicchevertstroke",
  description="CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE",
  direction="l",
  linebreak="al",
  shcode=0x447,
  uccode=0x4B8,
  unicodeslot=0x4B9,
 },
 [0x4BA]={
  adobename="Shhacyrillic",
  category="lu",
  contextname="cyrillicSHHA",
  description="CYRILLIC CAPITAL LETTER SHHA",
  direction="l",
  lccode=0x4BB,
  linebreak="al",
  unicodeslot=0x4BA,
 },
 [0x4BB]={
  adobename="shhacyrillic",
  category="ll",
  contextname="cyrillicshha",
  description="CYRILLIC SMALL LETTER SHHA",
  direction="l",
  linebreak="al",
  uccode=0x4BA,
  unicodeslot=0x4BB,
 },
 [0x4BC]={
  adobename="Cheabkhasiancyrillic",
  category="lu",
  contextname="cyrillicCHEabkhasian",
  description="CYRILLIC CAPITAL LETTER ABKHASIAN CHE",
  direction="l",
  lccode=0x4BD,
  linebreak="al",
  unicodeslot=0x4BC,
 },
 [0x4BD]={
  adobename="cheabkhasiancyrillic",
  category="ll",
  contextname="cyrilliccheabkhasian",
  description="CYRILLIC SMALL LETTER ABKHASIAN CHE",
  direction="l",
  linebreak="al",
  uccode=0x4BC,
  unicodeslot=0x4BD,
 },
 [0x4BE]={
  adobename="Chedescenderabkhasiancyrillic",
  category="lu",
  contextname="cyrillicCHEDCabkhasian",
  description="CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER",
  direction="l",
  lccode=0x4BF,
  linebreak="al",
  unicodeslot=0x4BE,
 },
 [0x4BF]={
  adobename="chedescenderabkhasiancyrillic",
  category="ll",
  contextname="cyrillicchedcabkhasian",
  description="CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER",
  direction="l",
  linebreak="al",
  uccode=0x4BE,
  unicodeslot=0x4BF,
 },
 [0x4C0]={
  adobename="palochkacyrillic",
  category="lu",
  contextname="cyrillicPALOCHKA",
  description="CYRILLIC LETTER PALOCHKA",
  direction="l",
  lccode=0x4CF,
  linebreak="al",
  unicodeslot=0x4C0,
 },
 [0x4C1]={
  adobename="Zhebrevecyrillic",
  category="lu",
  contextname="cyrillicZHEbreve",
  description="CYRILLIC CAPITAL LETTER ZHE WITH BREVE",
  direction="l",
  lccode=0x4C2,
  linebreak="al",
  shcode=0x416,
  specials={ "char", 0x416, 0x306 },
  unicodeslot=0x4C1,
 },
 [0x4C2]={
  adobename="zhebrevecyrillic",
  category="ll",
  contextname="cyrilliczhebreve",
  description="CYRILLIC SMALL LETTER ZHE WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x436,
  specials={ "char", 0x436, 0x306 },
  uccode=0x4C1,
  unicodeslot=0x4C2,
 },
 [0x4C3]={
  adobename="Kahookcyrillic",
  category="lu",
  contextname="cyrillicKAhook",
  description="CYRILLIC CAPITAL LETTER KA WITH HOOK",
  direction="l",
  lccode=0x4C4,
  linebreak="al",
  shcode=0x41A,
  unicodeslot=0x4C3,
 },
 [0x4C4]={
  adobename="kahookcyrillic",
  category="ll",
  contextname="cyrillickahook",
  description="CYRILLIC SMALL LETTER KA WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x43A,
  uccode=0x4C3,
  unicodeslot=0x4C4,
 },
 [0x4C5]={
  category="lu",
  contextname="cyrillicELtail",
  description="CYRILLIC CAPITAL LETTER EL WITH TAIL",
  direction="l",
  lccode=0x4C6,
  linebreak="al",
  shcode=0x41B,
  unicodeslot=0x4C5,
 },
 [0x4C6]={
  category="ll",
  contextname="cyrilliceltail",
  description="CYRILLIC SMALL LETTER EL WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x43B,
  uccode=0x4C5,
  unicodeslot=0x4C6,
 },
 [0x4C7]={
  adobename="Enhookcyrillic",
  category="lu",
  contextname="cyrillicENhook",
  description="CYRILLIC CAPITAL LETTER EN WITH HOOK",
  direction="l",
  lccode=0x4C8,
  linebreak="al",
  shcode=0x41D,
  unicodeslot=0x4C7,
 },
 [0x4C8]={
  adobename="enhookcyrillic",
  category="ll",
  contextname="cyrillicenhook",
  description="CYRILLIC SMALL LETTER EN WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x43D,
  uccode=0x4C7,
  unicodeslot=0x4C8,
 },
 [0x4C9]={
  category="lu",
  contextname="cyrillicENtail",
  description="CYRILLIC CAPITAL LETTER EN WITH TAIL",
  direction="l",
  lccode=0x4CA,
  linebreak="al",
  shcode=0x41D,
  unicodeslot=0x4C9,
 },
 [0x4CA]={
  category="ll",
  contextname="cyrillicentail",
  description="CYRILLIC SMALL LETTER EN WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x43D,
  uccode=0x4C9,
  unicodeslot=0x4CA,
 },
 [0x4CB]={
  adobename="Chekhakassiancyrillic",
  category="lu",
  contextname="cyrillicCHEkhakassian",
  description="CYRILLIC CAPITAL LETTER KHAKASSIAN CHE",
  direction="l",
  lccode=0x4CC,
  linebreak="al",
  unicodeslot=0x4CB,
 },
 [0x4CC]={
  adobename="chekhakassiancyrillic",
  category="ll",
  contextname="cyrillicchekhakassian",
  description="CYRILLIC SMALL LETTER KHAKASSIAN CHE",
  direction="l",
  linebreak="al",
  uccode=0x4CB,
  unicodeslot=0x4CC,
 },
 [0x4CD]={
  category="lu",
  contextname="cyrillicEMtail",
  description="CYRILLIC CAPITAL LETTER EM WITH TAIL",
  direction="l",
  lccode=0x4CE,
  linebreak="al",
  shcode=0x41C,
  unicodeslot=0x4CD,
 },
 [0x4CE]={
  category="ll",
  contextname="cyrillicemtail",
  description="CYRILLIC SMALL LETTER EM WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x43C,
  uccode=0x4CD,
  unicodeslot=0x4CE,
 },
 [0x4CF]={
  category="ll",
  description="CYRILLIC SMALL LETTER PALOCHKA",
  direction="l",
  linebreak="al",
  uccode=0x4C0,
  unicodeslot=0x4CF,
 },
 [0x4D0]={
  adobename="Abrevecyrillic",
  category="lu",
  contextname="cyrillicAbreve",
  description="CYRILLIC CAPITAL LETTER A WITH BREVE",
  direction="l",
  lccode=0x4D1,
  linebreak="al",
  shcode=0x410,
  specials={ "char", 0x410, 0x306 },
  unicodeslot=0x4D0,
 },
 [0x4D1]={
  adobename="abrevecyrillic",
  category="ll",
  contextname="cyrillicabreve",
  description="CYRILLIC SMALL LETTER A WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x430,
  specials={ "char", 0x430, 0x306 },
  uccode=0x4D0,
  unicodeslot=0x4D1,
 },
 [0x4D2]={
  adobename="Adieresiscyrillic",
  category="lu",
  contextname="cyrillicAdiaeresis",
  description="CYRILLIC CAPITAL LETTER A WITH DIAERESIS",
  direction="l",
  lccode=0x4D3,
  linebreak="al",
  shcode=0x410,
  specials={ "char", 0x410, 0x308 },
  unicodeslot=0x4D2,
 },
 [0x4D3]={
  adobename="adieresiscyrillic",
  category="ll",
  contextname="cyrillicadiaeresis",
  description="CYRILLIC SMALL LETTER A WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x430,
  specials={ "char", 0x430, 0x308 },
  uccode=0x4D2,
  unicodeslot=0x4D3,
 },
 [0x4D4]={
  adobename="Aiecyrillic",
  category="lu",
  contextname="cyrillicAE",
  description="CYRILLIC CAPITAL LIGATURE A IE",
  direction="l",
  lccode=0x4D5,
  linebreak="al",
  unicodeslot=0x4D4,
 },
 [0x4D5]={
  adobename="aiecyrillic",
  category="ll",
  contextname="cyrillicae",
  description="CYRILLIC SMALL LIGATURE A IE",
  direction="l",
  linebreak="al",
  uccode=0x4D4,
  unicodeslot=0x4D5,
 },
 [0x4D6]={
  adobename="Iebrevecyrillic",
  category="lu",
  contextname="cyrillicEbreve",
  description="CYRILLIC CAPITAL LETTER IE WITH BREVE",
  direction="l",
  lccode=0x4D7,
  linebreak="al",
  shcode=0x415,
  specials={ "char", 0x415, 0x306 },
  unicodeslot=0x4D6,
 },
 [0x4D7]={
  adobename="iebrevecyrillic",
  category="ll",
  contextname="cyrillicebreve",
  description="CYRILLIC SMALL LETTER IE WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x435,
  specials={ "char", 0x435, 0x306 },
  uccode=0x4D6,
  unicodeslot=0x4D7,
 },
 [0x4D8]={
  adobename="Schwacyrillic",
  category="lu",
  contextname="cyrillicSCHWA",
  description="CYRILLIC CAPITAL LETTER SCHWA",
  direction="l",
  lccode=0x4D9,
  linebreak="al",
  unicodeslot=0x4D8,
 },
 [0x4D9]={
  adobename="schwacyrillic",
  category="ll",
  contextname="cyrillicschwa",
  description="CYRILLIC SMALL LETTER SCHWA",
  direction="l",
  linebreak="al",
  uccode=0x4D8,
  unicodeslot=0x4D9,
 },
 [0x4DA]={
  adobename="Schwadieresiscyrillic",
  category="lu",
  contextname="cyrillicSCHWAdiaeresis",
  description="CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS",
  direction="l",
  lccode=0x4DB,
  linebreak="al",
  shcode=0x4D8,
  specials={ "char", 0x4D8, 0x308 },
  unicodeslot=0x4DA,
 },
 [0x4DB]={
  adobename="schwadieresiscyrillic",
  category="ll",
  contextname="cyrillicschwadiaeresis",
  description="CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x4D9,
  specials={ "char", 0x4D9, 0x308 },
  uccode=0x4DA,
  unicodeslot=0x4DB,
 },
 [0x4DC]={
  adobename="Zhedieresiscyrillic",
  category="lu",
  contextname="cyrillicZHEdiaeresis",
  description="CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS",
  direction="l",
  lccode=0x4DD,
  linebreak="al",
  shcode=0x416,
  specials={ "char", 0x416, 0x308 },
  unicodeslot=0x4DC,
 },
 [0x4DD]={
  adobename="zhedieresiscyrillic",
  category="ll",
  contextname="cyrilliczhediaeresis",
  description="CYRILLIC SMALL LETTER ZHE WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x436,
  specials={ "char", 0x436, 0x308 },
  uccode=0x4DC,
  unicodeslot=0x4DD,
 },
 [0x4DE]={
  adobename="Zedieresiscyrillic",
  category="lu",
  contextname="cyrillicZEdiaeresis",
  description="CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS",
  direction="l",
  lccode=0x4DF,
  linebreak="al",
  shcode=0x417,
  specials={ "char", 0x417, 0x308 },
  unicodeslot=0x4DE,
 },
 [0x4DF]={
  adobename="zedieresiscyrillic",
  category="ll",
  contextname="cyrilliczediaeresis",
  description="CYRILLIC SMALL LETTER ZE WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x437,
  specials={ "char", 0x437, 0x308 },
  uccode=0x4DE,
  unicodeslot=0x4DF,
 },
 [0x4E0]={
  adobename="Dzeabkhasiancyrillic",
  category="lu",
  contextname="cyrillicDZEabkhasian",
  description="CYRILLIC CAPITAL LETTER ABKHASIAN DZE",
  direction="l",
  lccode=0x4E1,
  linebreak="al",
  unicodeslot=0x4E0,
 },
 [0x4E1]={
  adobename="dzeabkhasiancyrillic",
  category="ll",
  contextname="cyrillicdzeabkhasian",
  description="CYRILLIC SMALL LETTER ABKHASIAN DZE",
  direction="l",
  linebreak="al",
  uccode=0x4E0,
  unicodeslot=0x4E1,
 },
 [0x4E2]={
  adobename="Imacroncyrillic",
  category="lu",
  contextname="cyrillicImacron",
  description="CYRILLIC CAPITAL LETTER I WITH MACRON",
  direction="l",
  lccode=0x4E3,
  linebreak="al",
  shcode=0x418,
  specials={ "char", 0x418, 0x304 },
  unicodeslot=0x4E2,
 },
 [0x4E3]={
  adobename="imacroncyrillic",
  category="ll",
  contextname="cyrillicimacron",
  description="CYRILLIC SMALL LETTER I WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x438,
  specials={ "char", 0x438, 0x304 },
  uccode=0x4E2,
  unicodeslot=0x4E3,
 },
 [0x4E4]={
  adobename="Idieresiscyrillic",
  category="lu",
  contextname="cyrillicIdiaeresis",
  description="CYRILLIC CAPITAL LETTER I WITH DIAERESIS",
  direction="l",
  lccode=0x4E5,
  linebreak="al",
  shcode=0x418,
  specials={ "char", 0x418, 0x308 },
  unicodeslot=0x4E4,
 },
 [0x4E5]={
  adobename="idieresiscyrillic",
  category="ll",
  contextname="cyrillicidiaeresis",
  description="CYRILLIC SMALL LETTER I WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x438,
  specials={ "char", 0x438, 0x308 },
  uccode=0x4E4,
  unicodeslot=0x4E5,
 },
 [0x4E6]={
  adobename="Odieresiscyrillic",
  category="lu",
  contextname="cyrillicOdiaeresis",
  description="CYRILLIC CAPITAL LETTER O WITH DIAERESIS",
  direction="l",
  lccode=0x4E7,
  linebreak="al",
  shcode=0x41E,
  specials={ "char", 0x41E, 0x308 },
  unicodeslot=0x4E6,
 },
 [0x4E7]={
  adobename="odieresiscyrillic",
  category="ll",
  contextname="cyrillicodiaeresis",
  description="CYRILLIC SMALL LETTER O WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x43E,
  specials={ "char", 0x43E, 0x308 },
  uccode=0x4E6,
  unicodeslot=0x4E7,
 },
 [0x4E8]={
  adobename="Obarredcyrillic",
  category="lu",
  contextname="cyrillicObarred",
  description="CYRILLIC CAPITAL LETTER BARRED O",
  direction="l",
  lccode=0x4E9,
  linebreak="al",
  unicodeslot=0x4E8,
 },
 [0x4E9]={
  adobename="obarredcyrillic",
  category="ll",
  contextname="cyrillicobarred",
  description="CYRILLIC SMALL LETTER BARRED O",
  direction="l",
  linebreak="al",
  uccode=0x4E8,
  unicodeslot=0x4E9,
 },
 [0x4EA]={
  adobename="Obarreddieresiscyrillic",
  category="lu",
  contextname="cyrillicObarreddiaeresis",
  description="CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS",
  direction="l",
  lccode=0x4EB,
  linebreak="al",
  specials={ "char", 0x4E8, 0x308 },
  unicodeslot=0x4EA,
 },
 [0x4EB]={
  adobename="obarreddieresiscyrillic",
  category="ll",
  contextname="cyrillicobarreddiaeresis",
  description="CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS",
  direction="l",
  linebreak="al",
  specials={ "char", 0x4E9, 0x308 },
  uccode=0x4EA,
  unicodeslot=0x4EB,
 },
 [0x4EC]={
  category="lu",
  contextname="cyrillicEdiaeresis",
  description="CYRILLIC CAPITAL LETTER E WITH DIAERESIS",
  direction="l",
  lccode=0x4ED,
  linebreak="al",
  shcode=0x42D,
  specials={ "char", 0x42D, 0x308 },
  unicodeslot=0x4EC,
 },
 [0x4ED]={
  category="ll",
  contextname="cyrillicediaeresis",
  description="CYRILLIC SMALL LETTER E WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x44D,
  specials={ "char", 0x44D, 0x308 },
  uccode=0x4EC,
  unicodeslot=0x4ED,
 },
 [0x4EE]={
  adobename="Umacroncyrillic",
  category="lu",
  contextname="cyrillicUmacron",
  description="CYRILLIC CAPITAL LETTER U WITH MACRON",
  direction="l",
  lccode=0x4EF,
  linebreak="al",
  shcode=0x423,
  specials={ "char", 0x423, 0x304 },
  unicodeslot=0x4EE,
 },
 [0x4EF]={
  adobename="umacroncyrillic",
  category="ll",
  contextname="cyrillicumacron",
  description="CYRILLIC SMALL LETTER U WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x443,
  specials={ "char", 0x443, 0x304 },
  uccode=0x4EE,
  unicodeslot=0x4EF,
 },
 [0x4F0]={
  adobename="Udieresiscyrillic",
  category="lu",
  contextname="cyrillicUdiaeresis",
  description="CYRILLIC CAPITAL LETTER U WITH DIAERESIS",
  direction="l",
  lccode=0x4F1,
  linebreak="al",
  shcode=0x423,
  specials={ "char", 0x423, 0x308 },
  unicodeslot=0x4F0,
 },
 [0x4F1]={
  adobename="udieresiscyrillic",
  category="ll",
  contextname="cyrillicudiaeresis",
  description="CYRILLIC SMALL LETTER U WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x443,
  specials={ "char", 0x443, 0x308 },
  uccode=0x4F0,
  unicodeslot=0x4F1,
 },
 [0x4F2]={
  adobename="Uhungarumlautcyrillic",
  category="lu",
  contextname="cyrillicUdoubleacute",
  description="CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE",
  direction="l",
  lccode=0x4F3,
  linebreak="al",
  shcode=0x423,
  specials={ "char", 0x423, 0x30B },
  unicodeslot=0x4F2,
 },
 [0x4F3]={
  adobename="uhungarumlautcyrillic",
  category="ll",
  contextname="cyrillicudoubleacute",
  description="CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x443,
  specials={ "char", 0x443, 0x30B },
  uccode=0x4F2,
  unicodeslot=0x4F3,
 },
 [0x4F4]={
  adobename="Chedieresiscyrillic",
  category="lu",
  contextname="cyrillicCHEdiaeresis",
  description="CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS",
  direction="l",
  lccode=0x4F5,
  linebreak="al",
  shcode=0x427,
  specials={ "char", 0x427, 0x308 },
  unicodeslot=0x4F4,
 },
 [0x4F5]={
  adobename="chedieresiscyrillic",
  category="ll",
  contextname="cyrillicchediaeresis",
  description="CYRILLIC SMALL LETTER CHE WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x447,
  specials={ "char", 0x447, 0x308 },
  uccode=0x4F4,
  unicodeslot=0x4F5,
 },
 [0x4F6]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER GHE WITH DESCENDER",
  direction="l",
  lccode=0x4F7,
  linebreak="al",
  shcode=0x413,
  unicodeslot=0x4F6,
 },
 [0x4F7]={
  category="ll",
  description="CYRILLIC SMALL LETTER GHE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x433,
  uccode=0x4F6,
  unicodeslot=0x4F7,
 },
 [0x4F8]={
  adobename="Yerudieresiscyrillic",
  category="lu",
  contextname="cyrillicYERUdiaeresis",
  description="CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS",
  direction="l",
  lccode=0x4F9,
  linebreak="al",
  shcode=0x42B,
  specials={ "char", 0x42B, 0x308 },
  unicodeslot=0x4F8,
 },
 [0x4F9]={
  adobename="yerudieresiscyrillic",
  category="ll",
  contextname="cyrillicyerudiaeresis",
  description="CYRILLIC SMALL LETTER YERU WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x44B,
  specials={ "char", 0x44B, 0x308 },
  uccode=0x4F8,
  unicodeslot=0x4F9,
 },
 [0x4FA]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK",
  direction="l",
  lccode=0x4FB,
  linebreak="al",
  shcode=0x413,
  unicodeslot=0x4FA,
 },
 [0x4FB]={
  category="ll",
  description="CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK",
  direction="l",
  linebreak="al",
  shcode=0x433,
  uccode=0x4FA,
  unicodeslot=0x4FB,
 },
 [0x4FC]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER HA WITH HOOK",
  direction="l",
  lccode=0x4FD,
  linebreak="al",
  shcode=0x425,
  unicodeslot=0x4FC,
 },
 [0x4FD]={
  category="ll",
  description="CYRILLIC SMALL LETTER HA WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x445,
  uccode=0x4FC,
  unicodeslot=0x4FD,
 },
 [0x4FE]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER HA WITH STROKE",
  direction="l",
  lccode=0x4FF,
  linebreak="al",
  shcode=0x425,
  unicodeslot=0x4FE,
 },
 [0x4FF]={
  category="ll",
  description="CYRILLIC SMALL LETTER HA WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x445,
  uccode=0x4FE,
  unicodeslot=0x4FF,
 },
 [0x500]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI DE",
  direction="l",
  lccode=0x501,
  linebreak="al",
  unicodeslot=0x500,
 },
 [0x501]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI DE",
  direction="l",
  linebreak="al",
  uccode=0x500,
  unicodeslot=0x501,
 },
 [0x502]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI DJE",
  direction="l",
  lccode=0x503,
  linebreak="al",
  unicodeslot=0x502,
 },
 [0x503]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI DJE",
  direction="l",
  linebreak="al",
  uccode=0x502,
  unicodeslot=0x503,
 },
 [0x504]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI ZJE",
  direction="l",
  lccode=0x505,
  linebreak="al",
  unicodeslot=0x504,
 },
 [0x505]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI ZJE",
  direction="l",
  linebreak="al",
  uccode=0x504,
  unicodeslot=0x505,
 },
 [0x506]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI DZJE",
  direction="l",
  lccode=0x507,
  linebreak="al",
  unicodeslot=0x506,
 },
 [0x507]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI DZJE",
  direction="l",
  linebreak="al",
  uccode=0x506,
  unicodeslot=0x507,
 },
 [0x508]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI LJE",
  direction="l",
  lccode=0x509,
  linebreak="al",
  unicodeslot=0x508,
 },
 [0x509]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI LJE",
  direction="l",
  linebreak="al",
  uccode=0x508,
  unicodeslot=0x509,
 },
 [0x50A]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI NJE",
  direction="l",
  lccode=0x50B,
  linebreak="al",
  unicodeslot=0x50A,
 },
 [0x50B]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI NJE",
  direction="l",
  linebreak="al",
  uccode=0x50A,
  unicodeslot=0x50B,
 },
 [0x50C]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI SJE",
  direction="l",
  lccode=0x50D,
  linebreak="al",
  unicodeslot=0x50C,
 },
 [0x50D]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI SJE",
  direction="l",
  linebreak="al",
  uccode=0x50C,
  unicodeslot=0x50D,
 },
 [0x50E]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI TJE",
  direction="l",
  lccode=0x50F,
  linebreak="al",
  unicodeslot=0x50E,
 },
 [0x50F]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI TJE",
  direction="l",
  linebreak="al",
  uccode=0x50E,
  unicodeslot=0x50F,
 },
 [0x510]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER REVERSED ZE",
  direction="l",
  lccode=0x511,
  linebreak="al",
  unicodeslot=0x510,
 },
 [0x511]={
  category="ll",
  description="CYRILLIC SMALL LETTER REVERSED ZE",
  direction="l",
  linebreak="al",
  uccode=0x510,
  unicodeslot=0x511,
 },
 [0x512]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER EL WITH HOOK",
  direction="l",
  lccode=0x513,
  linebreak="al",
  shcode=0x41B,
  unicodeslot=0x512,
 },
 [0x513]={
  category="ll",
  description="CYRILLIC SMALL LETTER EL WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x43B,
  uccode=0x512,
  unicodeslot=0x513,
 },
 [0x514]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x514,
 },
 [0x515]={
  category="ll",
  description="CYRILLIC SMALL LETTER LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x515,
 },
 [0x516]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER RHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x516,
 },
 [0x517]={
  category="ll",
  description="CYRILLIC SMALL LETTER RHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x517,
 },
 [0x518]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER YAE",
  direction="l",
  linebreak="al",
  unicodeslot=0x518,
 },
 [0x519]={
  category="ll",
  description="CYRILLIC SMALL LETTER YAE",
  direction="l",
  linebreak="al",
  unicodeslot=0x519,
 },
 [0x51A]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x51A,
 },
 [0x51B]={
  category="ll",
  description="CYRILLIC SMALL LETTER QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x51B,
 },
 [0x51C]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x51C,
 },
 [0x51D]={
  category="ll",
  description="CYRILLIC SMALL LETTER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x51D,
 },
 [0x51E]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER ALEUT KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x51E,
 },
 [0x51F]={
  category="ll",
  description="CYRILLIC SMALL LETTER ALEUT KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x51F,
 },
 [0x520]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x520,
 },
 [0x521]={
  category="ll",
  description="CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x521,
 },
 [0x522]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x522,
 },
 [0x523]={
  category="ll",
  description="CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x523,
 },
 [0x524]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER PE WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x524,
 },
 [0x525]={
  category="ll",
  description="CYRILLIC SMALL LETTER PE WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x525,
 },
 [0x526]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x526,
 },
 [0x527]={
  category="ll",
  description="CYRILLIC SMALL LETTER SHHA WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x527,
 },
 [0x528]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x528,
 },
 [0x529]={
  category="ll",
  description="CYRILLIC SMALL LETTER EN WITH LEFT HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x529,
 },
 [0x52A]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER DZZHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x52A,
 },
 [0x52B]={
  category="ll",
  description="CYRILLIC SMALL LETTER DZZHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x52B,
 },
 [0x52C]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER DCHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x52C,
 },
 [0x52D]={
  category="ll",
  description="CYRILLIC SMALL LETTER DCHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x52D,
 },
 [0x52E]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER EL WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x52E,
 },
 [0x52F]={
  category="ll",
  description="CYRILLIC SMALL LETTER EL WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x52F,
 },
 [0x531]={
  adobename="Aybarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER AYB",
  direction="l",
  lccode=0x561,
  linebreak="al",
  unicodeslot=0x531,
 },
 [0x532]={
  adobename="Benarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER BEN",
  direction="l",
  lccode=0x562,
  linebreak="al",
  unicodeslot=0x532,
 },
 [0x533]={
  adobename="Gimarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER GIM",
  direction="l",
  lccode=0x563,
  linebreak="al",
  unicodeslot=0x533,
 },
 [0x534]={
  adobename="Daarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER DA",
  direction="l",
  lccode=0x564,
  linebreak="al",
  unicodeslot=0x534,
 },
 [0x535]={
  adobename="Echarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER ECH",
  direction="l",
  lccode=0x565,
  linebreak="al",
  unicodeslot=0x535,
 },
 [0x536]={
  adobename="Zaarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER ZA",
  direction="l",
  lccode=0x566,
  linebreak="al",
  unicodeslot=0x536,
 },
 [0x537]={
  adobename="Eharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER EH",
  direction="l",
  lccode=0x567,
  linebreak="al",
  unicodeslot=0x537,
 },
 [0x538]={
  adobename="Etarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER ET",
  direction="l",
  lccode=0x568,
  linebreak="al",
  unicodeslot=0x538,
 },
 [0x539]={
  adobename="Toarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER TO",
  direction="l",
  lccode=0x569,
  linebreak="al",
  unicodeslot=0x539,
 },
 [0x53A]={
  adobename="Zhearmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER ZHE",
  direction="l",
  lccode=0x56A,
  linebreak="al",
  unicodeslot=0x53A,
 },
 [0x53B]={
  adobename="Iniarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER INI",
  direction="l",
  lccode=0x56B,
  linebreak="al",
  unicodeslot=0x53B,
 },
 [0x53C]={
  adobename="Liwnarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER LIWN",
  direction="l",
  lccode=0x56C,
  linebreak="al",
  unicodeslot=0x53C,
 },
 [0x53D]={
  adobename="Xeharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER XEH",
  direction="l",
  lccode=0x56D,
  linebreak="al",
  unicodeslot=0x53D,
 },
 [0x53E]={
  adobename="Caarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER CA",
  direction="l",
  lccode=0x56E,
  linebreak="al",
  unicodeslot=0x53E,
 },
 [0x53F]={
  adobename="Kenarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER KEN",
  direction="l",
  lccode=0x56F,
  linebreak="al",
  unicodeslot=0x53F,
 },
 [0x540]={
  adobename="Hoarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER HO",
  direction="l",
  lccode=0x570,
  linebreak="al",
  unicodeslot=0x540,
 },
 [0x541]={
  adobename="Jaarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER JA",
  direction="l",
  lccode=0x571,
  linebreak="al",
  unicodeslot=0x541,
 },
 [0x542]={
  adobename="Ghadarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER GHAD",
  direction="l",
  lccode=0x572,
  linebreak="al",
  unicodeslot=0x542,
 },
 [0x543]={
  adobename="Cheharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER CHEH",
  direction="l",
  lccode=0x573,
  linebreak="al",
  unicodeslot=0x543,
 },
 [0x544]={
  adobename="Menarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER MEN",
  direction="l",
  lccode=0x574,
  linebreak="al",
  unicodeslot=0x544,
 },
 [0x545]={
  adobename="Yiarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER YI",
  direction="l",
  lccode=0x575,
  linebreak="al",
  unicodeslot=0x545,
 },
 [0x546]={
  adobename="Nowarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER NOW",
  direction="l",
  lccode=0x576,
  linebreak="al",
  unicodeslot=0x546,
 },
 [0x547]={
  adobename="Shaarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER SHA",
  direction="l",
  lccode=0x577,
  linebreak="al",
  unicodeslot=0x547,
 },
 [0x548]={
  adobename="Voarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER VO",
  direction="l",
  lccode=0x578,
  linebreak="al",
  unicodeslot=0x548,
 },
 [0x549]={
  adobename="Chaarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER CHA",
  direction="l",
  lccode=0x579,
  linebreak="al",
  unicodeslot=0x549,
 },
 [0x54A]={
  adobename="Peharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER PEH",
  direction="l",
  lccode=0x57A,
  linebreak="al",
  unicodeslot=0x54A,
 },
 [0x54B]={
  adobename="Jheharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER JHEH",
  direction="l",
  lccode=0x57B,
  linebreak="al",
  unicodeslot=0x54B,
 },
 [0x54C]={
  adobename="Raarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER RA",
  direction="l",
  lccode=0x57C,
  linebreak="al",
  unicodeslot=0x54C,
 },
 [0x54D]={
  adobename="Seharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER SEH",
  direction="l",
  lccode=0x57D,
  linebreak="al",
  unicodeslot=0x54D,
 },
 [0x54E]={
  adobename="Vewarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER VEW",
  direction="l",
  lccode=0x57E,
  linebreak="al",
  unicodeslot=0x54E,
 },
 [0x54F]={
  adobename="Tiwnarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER TIWN",
  direction="l",
  lccode=0x57F,
  linebreak="al",
  unicodeslot=0x54F,
 },
 [0x550]={
  adobename="Reharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER REH",
  direction="l",
  lccode=0x580,
  linebreak="al",
  unicodeslot=0x550,
 },
 [0x551]={
  adobename="Coarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER CO",
  direction="l",
  lccode=0x581,
  linebreak="al",
  unicodeslot=0x551,
 },
 [0x552]={
  adobename="Yiwnarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER YIWN",
  direction="l",
  lccode=0x582,
  linebreak="al",
  unicodeslot=0x552,
 },
 [0x553]={
  adobename="Piwrarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER PIWR",
  direction="l",
  lccode=0x583,
  linebreak="al",
  unicodeslot=0x553,
 },
 [0x554]={
  adobename="Keharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER KEH",
  direction="l",
  lccode=0x584,
  linebreak="al",
  unicodeslot=0x554,
 },
 [0x555]={
  adobename="Oharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER OH",
  direction="l",
  lccode=0x585,
  linebreak="al",
  unicodeslot=0x555,
 },
 [0x556]={
  adobename="Feharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER FEH",
  direction="l",
  lccode=0x586,
  linebreak="al",
  unicodeslot=0x556,
 },
 [0x559]={
  adobename="ringhalfleftarmenian",
  category="lm",
  description="ARMENIAN MODIFIER LETTER LEFT HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x559,
 },
 [0x55A]={
  adobename="apostrophearmenian",
  category="po",
  description="ARMENIAN APOSTROPHE",
  direction="l",
  linebreak="al",
  synonyms={ "armenian modifier letter right half ring" },
  unicodeslot=0x55A,
 },
 [0x55B]={
  adobename="emphasismarkarmenian",
  category="po",
  description="ARMENIAN EMPHASIS MARK",
  direction="l",
  linebreak="al",
  synonyms={ "armenian shesht" },
  unicodeslot=0x55B,
 },
 [0x55C]={
  adobename="exclamarmenian",
  category="po",
  description="ARMENIAN EXCLAMATION MARK",
  direction="l",
  linebreak="al",
  synonyms={ "armenian batsaganchakan nshan" },
  unicodeslot=0x55C,
 },
 [0x55D]={
  adobename="commaarmenian",
  category="po",
  description="ARMENIAN COMMA",
  direction="l",
  linebreak="al",
  synonyms={ "armenian bowt" },
  unicodeslot=0x55D,
 },
 [0x55E]={
  adobename="questionarmenian",
  category="po",
  description="ARMENIAN QUESTION MARK",
  direction="l",
  linebreak="al",
  synonyms={ "armenian hartsakan nshan" },
  unicodeslot=0x55E,
 },
 [0x55F]={
  adobename="abbreviationmarkarmenian",
  category="po",
  description="ARMENIAN ABBREVIATION MARK",
  direction="l",
  linebreak="al",
  synonyms={ "armenian patiw" },
  unicodeslot=0x55F,
 },
 [0x561]={
  adobename="aybarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER AYB",
  direction="l",
  linebreak="al",
  uccode=0x531,
  unicodeslot=0x561,
 },
 [0x562]={
  adobename="benarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER BEN",
  direction="l",
  linebreak="al",
  uccode=0x532,
  unicodeslot=0x562,
 },
 [0x563]={
  adobename="gimarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER GIM",
  direction="l",
  linebreak="al",
  uccode=0x533,
  unicodeslot=0x563,
 },
 [0x564]={
  adobename="daarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER DA",
  direction="l",
  linebreak="al",
  uccode=0x534,
  unicodeslot=0x564,
 },
 [0x565]={
  adobename="echarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER ECH",
  direction="l",
  linebreak="al",
  uccode=0x535,
  unicodeslot=0x565,
 },
 [0x566]={
  adobename="zaarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER ZA",
  direction="l",
  linebreak="al",
  uccode=0x536,
  unicodeslot=0x566,
 },
 [0x567]={
  adobename="eharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER EH",
  direction="l",
  linebreak="al",
  uccode=0x537,
  unicodeslot=0x567,
 },
 [0x568]={
  adobename="etarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER ET",
  direction="l",
  linebreak="al",
  uccode=0x538,
  unicodeslot=0x568,
 },
 [0x569]={
  adobename="toarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER TO",
  direction="l",
  linebreak="al",
  uccode=0x539,
  unicodeslot=0x569,
 },
 [0x56A]={
  adobename="zhearmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER ZHE",
  direction="l",
  linebreak="al",
  uccode=0x53A,
  unicodeslot=0x56A,
 },
 [0x56B]={
  adobename="iniarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER INI",
  direction="l",
  linebreak="al",
  uccode=0x53B,
  unicodeslot=0x56B,
 },
 [0x56C]={
  adobename="liwnarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER LIWN",
  direction="l",
  linebreak="al",
  uccode=0x53C,
  unicodeslot=0x56C,
 },
 [0x56D]={
  adobename="xeharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER XEH",
  direction="l",
  linebreak="al",
  uccode=0x53D,
  unicodeslot=0x56D,
 },
 [0x56E]={
  adobename="caarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER CA",
  direction="l",
  linebreak="al",
  uccode=0x53E,
  unicodeslot=0x56E,
 },
 [0x56F]={
  adobename="kenarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER KEN",
  direction="l",
  linebreak="al",
  uccode=0x53F,
  unicodeslot=0x56F,
 },
 [0x570]={
  adobename="hoarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER HO",
  direction="l",
  linebreak="al",
  uccode=0x540,
  unicodeslot=0x570,
 },
 [0x571]={
  adobename="jaarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER JA",
  direction="l",
  linebreak="al",
  uccode=0x541,
  unicodeslot=0x571,
 },
 [0x572]={
  adobename="ghadarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER GHAD",
  direction="l",
  linebreak="al",
  uccode=0x542,
  unicodeslot=0x572,
 },
 [0x573]={
  adobename="cheharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER CHEH",
  direction="l",
  linebreak="al",
  uccode=0x543,
  unicodeslot=0x573,
 },
 [0x574]={
  adobename="menarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER MEN",
  direction="l",
  linebreak="al",
  uccode=0x544,
  unicodeslot=0x574,
 },
 [0x575]={
  adobename="yiarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER YI",
  direction="l",
  linebreak="al",
  uccode=0x545,
  unicodeslot=0x575,
 },
 [0x576]={
  adobename="nowarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER NOW",
  direction="l",
  linebreak="al",
  uccode=0x546,
  unicodeslot=0x576,
 },
 [0x577]={
  adobename="shaarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER SHA",
  direction="l",
  linebreak="al",
  uccode=0x547,
  unicodeslot=0x577,
 },
 [0x578]={
  adobename="voarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER VO",
  direction="l",
  linebreak="al",
  uccode=0x548,
  unicodeslot=0x578,
 },
 [0x579]={
  adobename="chaarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER CHA",
  direction="l",
  linebreak="al",
  uccode=0x549,
  unicodeslot=0x579,
 },
 [0x57A]={
  adobename="peharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER PEH",
  direction="l",
  linebreak="al",
  uccode=0x54A,
  unicodeslot=0x57A,
 },
 [0x57B]={
  adobename="jheharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER JHEH",
  direction="l",
  linebreak="al",
  uccode=0x54B,
  unicodeslot=0x57B,
 },
 [0x57C]={
  adobename="raarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER RA",
  direction="l",
  linebreak="al",
  uccode=0x54C,
  unicodeslot=0x57C,
 },
 [0x57D]={
  adobename="seharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER SEH",
  direction="l",
  linebreak="al",
  uccode=0x54D,
  unicodeslot=0x57D,
 },
 [0x57E]={
  adobename="vewarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER VEW",
  direction="l",
  linebreak="al",
  uccode=0x54E,
  unicodeslot=0x57E,
 },
 [0x57F]={
  adobename="tiwnarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER TIWN",
  direction="l",
  linebreak="al",
  uccode=0x54F,
  unicodeslot=0x57F,
 },
 [0x580]={
  adobename="reharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER REH",
  direction="l",
  linebreak="al",
  uccode=0x550,
  unicodeslot=0x580,
 },
 [0x581]={
  adobename="coarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER CO",
  direction="l",
  linebreak="al",
  uccode=0x551,
  unicodeslot=0x581,
 },
 [0x582]={
  adobename="yiwnarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER YIWN",
  direction="l",
  linebreak="al",
  uccode=0x552,
  unicodeslot=0x582,
 },
 [0x583]={
  adobename="piwrarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER PIWR",
  direction="l",
  linebreak="al",
  uccode=0x553,
  unicodeslot=0x583,
 },
 [0x584]={
  adobename="keharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER KEH",
  direction="l",
  linebreak="al",
  uccode=0x554,
  unicodeslot=0x584,
 },
 [0x585]={
  adobename="oharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER OH",
  direction="l",
  linebreak="al",
  uccode=0x555,
  unicodeslot=0x585,
 },
 [0x586]={
  adobename="feharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER FEH",
  direction="l",
  linebreak="al",
  uccode=0x556,
  unicodeslot=0x586,
 },
 [0x587]={
  adobename="echyiwnarmenian",
  category="ll",
  description="ARMENIAN SMALL LIGATURE ECH YIWN",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x565, 0x582 },
  unicodeslot=0x587,
 },
 [0x589]={
  adobename="periodarmenian",
  category="po",
  description="ARMENIAN FULL STOP",
  direction="l",
  linebreak="is",
  synonyms={ "armenian vertsaket", "georgian full stop" },
  unicodeslot=0x589,
 },
 [0x58A]={
  category="pd",
  description="ARMENIAN HYPHEN",
  direction="on",
  linebreak="ba",
  synonyms={ "armenian yentamna" },
  unicodeslot=0x58A,
 },
 [0x58D]={
  category="so",
  description="RIGHT-FACING ARMENIAN ETERNITY SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x58D,
 },
 [0x58E]={
  category="so",
  description="LEFT-FACING ARMENIAN ETERNITY SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x58E,
 },
 [0x58F]={
  category="sc",
  description="ARMENIAN DRAM SIGN",
  direction="et",
  linebreak="pr",
  synonyms={ "armenian currency" },
  unicodeslot=0x58F,
 },
 [0x591]={
  adobename="etnahtalefthebrew",
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT ETNAHTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x591,
 },
 [0x592]={
  adobename="segoltahebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT SEGOL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x592,
 },
 [0x593]={
  adobename="shalshelethebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT SHALSHELET",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x593,
 },
 [0x594]={
  adobename="zaqefqatanhebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT ZAQEF QATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x594,
 },
 [0x595]={
  adobename="zaqefgadolhebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT ZAQEF GADOL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x595,
 },
 [0x596]={
  adobename="tipehalefthebrew",
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT TIPEHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x596,
 },
 [0x597]={
  adobename="reviamugrashhebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT REVIA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x597,
 },
 [0x598]={
  adobename="zarqahebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT ZARQA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x598,
 },
 [0x599]={
  adobename="pashtahebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT PASHTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x599,
 },
 [0x59A]={
  adobename="yetivhebrew",
  category="mn",
  combining=0xDE,
  description="HEBREW ACCENT YETIV",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x59A,
 },
 [0x59B]={
  adobename="tevirlefthebrew",
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT TEVIR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x59B,
 },
 [0x59C]={
  adobename="gereshaccenthebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT GERESH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x59C,
 },
 [0x59D]={
  adobename="gereshmuqdamhebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT GERESH MUQDAM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x59D,
 },
 [0x59E]={
  adobename="gershayimaccenthebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT GERSHAYIM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x59E,
 },
 [0x59F]={
  adobename="qarneyparahebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT QARNEY PARA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x59F,
 },
 [0x5A0]={
  adobename="telishagedolahebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT TELISHA GEDOLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A0,
 },
 [0x5A1]={
  adobename="pazerhebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT PAZER",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A1,
 },
 [0x5A2]={
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT ATNAH HAFUKH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A2,
 },
 [0x5A3]={
  adobename="munahlefthebrew",
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT MUNAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A3,
 },
 [0x5A4]={
  adobename="mahapakhlefthebrew",
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT MAHAPAKH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A4,
 },
 [0x5A5]={
  adobename="merkhalefthebrew",
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT MERKHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A5,
 },
 [0x5A6]={
  adobename="merkhakefulalefthebrew",
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT MERKHA KEFULA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A6,
 },
 [0x5A7]={
  adobename="dargalefthebrew",
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT DARGA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A7,
 },
 [0x5A8]={
  adobename="qadmahebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT QADMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A8,
 },
 [0x5A9]={
  adobename="telishaqetanahebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT TELISHA QETANA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5A9,
 },
 [0x5AA]={
  adobename="yerahbenyomolefthebrew",
  category="mn",
  combining=0xDC,
  description="HEBREW ACCENT YERAH BEN YOMO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5AA,
 },
 [0x5AB]={
  adobename="olehebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT OLE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5AB,
 },
 [0x5AC]={
  adobename="iluyhebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW ACCENT ILUY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5AC,
 },
 [0x5AD]={
  adobename="dehihebrew",
  category="mn",
  combining=0xDE,
  description="HEBREW ACCENT DEHI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5AD,
 },
 [0x5AE]={
  adobename="zinorhebrew",
  category="mn",
  combining=0xE4,
  description="HEBREW ACCENT ZINOR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5AE,
 },
 [0x5AF]={
  adobename="masoracirclehebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW MARK MASORA CIRCLE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5AF,
 },
 [0x5B0]={
  adobename="shevawidehebrew",
  category="mn",
  combining=0xA,
  description="HEBREW POINT SHEVA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B0,
 },
 [0x5B1]={
  adobename="hatafsegolwidehebrew",
  category="mn",
  combining=0xB,
  description="HEBREW POINT HATAF SEGOL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B1,
 },
 [0x5B2]={
  adobename="hatafpatahwidehebrew",
  category="mn",
  combining=0xC,
  description="HEBREW POINT HATAF PATAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B2,
 },
 [0x5B3]={
  adobename="hatafqamatswidehebrew",
  category="mn",
  combining=0xD,
  description="HEBREW POINT HATAF QAMATS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B3,
 },
 [0x5B4]={
  adobename="hiriqwidehebrew",
  category="mn",
  combining=0xE,
  description="HEBREW POINT HIRIQ",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B4,
 },
 [0x5B5]={
  adobename="tserewidehebrew",
  category="mn",
  combining=0xF,
  description="HEBREW POINT TSERE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B5,
 },
 [0x5B6]={
  adobename="segolwidehebrew",
  category="mn",
  combining=0x10,
  description="HEBREW POINT SEGOL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B6,
 },
 [0x5B7]={
  adobename="patahwidehebrew",
  category="mn",
  combining=0x11,
  description="HEBREW POINT PATAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B7,
 },
 [0x5B8]={
  adobename="qamatswidehebrew",
  category="mn",
  combining=0x12,
  description="HEBREW POINT QAMATS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B8,
 },
 [0x5B9]={
  adobename="holamwidehebrew",
  category="mn",
  combining=0x13,
  description="HEBREW POINT HOLAM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5B9,
 },
 [0x5BA]={
  category="mn",
  combining=0x13,
  description="HEBREW POINT HOLAM HASER FOR VAV",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5BA,
 },
 [0x5BB]={
  adobename="qubutswidehebrew",
  category="mn",
  combining=0x14,
  description="HEBREW POINT QUBUTS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5BB,
 },
 [0x5BC]={
  adobename="dageshhebrew",
  category="mn",
  combining=0x15,
  description="HEBREW POINT DAGESH OR MAPIQ",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5BC,
 },
 [0x5BD]={
  adobename="siluqlefthebrew",
  category="mn",
  combining=0x16,
  description="HEBREW POINT METEG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5BD,
 },
 [0x5BE]={
  adobename="maqafhebrew",
  category="po",
  description="HEBREW PUNCTUATION MAQAF",
  direction="r",
  linebreak="ba",
  unicodeslot=0x5BE,
 },
 [0x5BF]={
  adobename="rafehebrew",
  category="mn",
  combining=0x17,
  description="HEBREW POINT RAFE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5BF,
 },
 [0x5C0]={
  adobename="paseqhebrew",
  category="po",
  description="HEBREW PUNCTUATION PASEQ",
  direction="r",
  linebreak="al",
  unicodeslot=0x5C0,
 },
 [0x5C1]={
  adobename="shindothebrew",
  category="mn",
  combining=0x18,
  description="HEBREW POINT SHIN DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5C1,
 },
 [0x5C2]={
  adobename="sindothebrew",
  category="mn",
  combining=0x19,
  description="HEBREW POINT SIN DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5C2,
 },
 [0x5C3]={
  adobename="sofpasuqhebrew",
  category="po",
  description="HEBREW PUNCTUATION SOF PASUQ",
  direction="r",
  linebreak="al",
  unicodeslot=0x5C3,
 },
 [0x5C4]={
  adobename="upperdothebrew",
  category="mn",
  combining=0xE6,
  description="HEBREW MARK UPPER DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5C4,
 },
 [0x5C5]={
  category="mn",
  combining=0xDC,
  description="HEBREW MARK LOWER DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5C5,
 },
 [0x5C6]={
  category="po",
  description="HEBREW PUNCTUATION NUN HAFUKHA",
  direction="r",
  linebreak="ex",
  unicodeslot=0x5C6,
 },
 [0x5C7]={
  category="mn",
  combining=0x12,
  description="HEBREW POINT QAMATS QATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x5C7,
 },
 [0x5D0]={
  adobename="alefhebrew",
  category="lo",
  contextname="hebrewAlef",
  description="HEBREW LETTER ALEF",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D0,
 },
 [0x5D1]={
  adobename="bethebrew",
  category="lo",
  contextname="hebrewBet",
  description="HEBREW LETTER BET",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D1,
 },
 [0x5D2]={
  adobename="gimelhebrew",
  category="lo",
  contextname="hebrewGimel",
  description="HEBREW LETTER GIMEL",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D2,
 },
 [0x5D3]={
  adobename="dalettserehebrew",
  category="lo",
  contextname="hebrewDalet",
  description="HEBREW LETTER DALET",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D3,
 },
 [0x5D4]={
  adobename="hehebrew",
  category="lo",
  contextname="hebrewHe",
  description="HEBREW LETTER HE",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D4,
 },
 [0x5D5]={
  adobename="vavhebrew",
  category="lo",
  contextname="hebrewVav",
  description="HEBREW LETTER VAV",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D5,
 },
 [0x5D6]={
  adobename="zayinhebrew",
  category="lo",
  contextname="hebrewZayin",
  description="HEBREW LETTER ZAYIN",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D6,
 },
 [0x5D7]={
  adobename="hethebrew",
  category="lo",
  contextname="hebrewHet",
  description="HEBREW LETTER HET",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D7,
 },
 [0x5D8]={
  adobename="tethebrew",
  category="lo",
  contextname="hebrewTet",
  description="HEBREW LETTER TET",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D8,
 },
 [0x5D9]={
  adobename="yodhebrew",
  category="lo",
  contextname="hebrewYod",
  description="HEBREW LETTER YOD",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5D9,
 },
 [0x5DA]={
  adobename="finalkafshevahebrew",
  category="lo",
  contextname="hebrewKaffinal",
  description="HEBREW LETTER FINAL KAF",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5DA,
 },
 [0x5DB]={
  adobename="kafhebrew",
  category="lo",
  contextname="hebrewKaf",
  description="HEBREW LETTER KAF",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5DB,
 },
 [0x5DC]={
  adobename="lamedholamhebrew",
  category="lo",
  contextname="hebrewLamed",
  description="HEBREW LETTER LAMED",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5DC,
 },
 [0x5DD]={
  adobename="finalmemhebrew",
  category="lo",
  contextname="hebrewMemfinal",
  description="HEBREW LETTER FINAL MEM",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5DD,
 },
 [0x5DE]={
  adobename="memhebrew",
  category="lo",
  contextname="hebrewMem",
  description="HEBREW LETTER MEM",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5DE,
 },
 [0x5DF]={
  adobename="finalnunhebrew",
  category="lo",
  contextname="hebrewNunfinal",
  description="HEBREW LETTER FINAL NUN",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5DF,
 },
 [0x5E0]={
  adobename="nunhebrew",
  category="lo",
  contextname="hebrewNun",
  description="HEBREW LETTER NUN",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E0,
 },
 [0x5E1]={
  adobename="samekhhebrew",
  category="lo",
  contextname="hebrewSamekh",
  description="HEBREW LETTER SAMEKH",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E1,
 },
 [0x5E2]={
  adobename="ayinhebrew",
  category="lo",
  contextname="hebrewAyin",
  description="HEBREW LETTER AYIN",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E2,
 },
 [0x5E3]={
  adobename="finalpehebrew",
  category="lo",
  contextname="hebrewPefinal",
  description="HEBREW LETTER FINAL PE",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E3,
 },
 [0x5E4]={
  adobename="pehebrew",
  category="lo",
  contextname="hebrewPe",
  description="HEBREW LETTER PE",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E4,
 },
 [0x5E5]={
  adobename="finaltsadihebrew",
  category="lo",
  contextname="hebrewTsadifinal",
  description="HEBREW LETTER FINAL TSADI",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E5,
 },
 [0x5E6]={
  adobename="tsadihebrew",
  category="lo",
  contextname="hebrewTsadi",
  description="HEBREW LETTER TSADI",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E6,
 },
 [0x5E7]={
  adobename="qoftserehebrew",
  category="lo",
  contextname="hebrewQof",
  description="HEBREW LETTER QOF",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E7,
 },
 [0x5E8]={
  adobename="reshtserehebrew",
  category="lo",
  contextname="hebrewResh",
  description="HEBREW LETTER RESH",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E8,
 },
 [0x5E9]={
  adobename="shinhebrew",
  category="lo",
  contextname="hebrewShin",
  description="HEBREW LETTER SHIN",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5E9,
 },
 [0x5EA]={
  adobename="tavhebrew",
  category="lo",
  contextname="hebrewTav",
  description="HEBREW LETTER TAV",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5EA,
 },
 [0x5F0]={
  adobename="vavvavhebrew",
  category="lo",
  description="HEBREW LIGATURE YIDDISH DOUBLE VAV",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5F0,
 },
 [0x5F1]={
  adobename="vavyodhebrew",
  category="lo",
  description="HEBREW LIGATURE YIDDISH VAV YOD",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5F1,
 },
 [0x5F2]={
  adobename="yodyodhebrew",
  category="lo",
  description="HEBREW LIGATURE YIDDISH DOUBLE YOD",
  direction="r",
  linebreak="hl",
  unicodeslot=0x5F2,
 },
 [0x5F3]={
  adobename="gereshhebrew",
  category="po",
  description="HEBREW PUNCTUATION GERESH",
  direction="r",
  linebreak="al",
  unicodeslot=0x5F3,
 },
 [0x5F4]={
  adobename="gershayimhebrew",
  category="po",
  description="HEBREW PUNCTUATION GERSHAYIM",
  direction="r",
  linebreak="al",
  unicodeslot=0x5F4,
 },
 [0x600]={
  arabic="u",
  category="cf",
  contextname="arabicnumber",
  description="ARABIC NUMBER SIGN",
  direction="an",
  linebreak="al",
  unicodeslot=0x600,
  visible=true,
 },
 [0x601]={
  arabic="u",
  category="cf",
  contextname="arabicsanah",
  description="ARABIC SIGN SANAH",
  direction="an",
  linebreak="al",
  unicodeslot=0x601,
  visible=true,
 },
 [0x602]={
  arabic="u",
  category="cf",
  contextname="arabicfootnotemarker",
  description="ARABIC FOOTNOTE MARKER",
  direction="an",
  linebreak="al",
  unicodeslot=0x602,
  visible=true,
 },
 [0x603]={
  arabic="u",
  category="cf",
  contextname="arabicsafha",
  description="ARABIC SIGN SAFHA",
  direction="an",
  linebreak="al",
  unicodeslot=0x603,
  visible=true,
 },
 [0x604]={
  arabic="u",
  category="cf",
  contextname="arabicsamvat",
  description="ARABIC SIGN SAMVAT",
  direction="an",
  linebreak="al",
  unicodeslot=0x604,
 },
 [0x605]={
  arabic="u",
  category="cf",
  contextname="arabicnumberabove",
  description="ARABIC NUMBER MARK ABOVE",
  direction="an",
  linebreak="al",
  unicodeslot=0x605,
 },
 [0x606]={
  category="sm",
  contextname="arabiccuberoot",
  description="ARABIC-INDIC CUBE ROOT",
  direction="on",
  linebreak="al",
  unicodeslot=0x606,
 },
 [0x607]={
  category="sm",
  contextname="arabicfourthroot",
  description="ARABIC-INDIC FOURTH ROOT",
  direction="on",
  linebreak="al",
  unicodeslot=0x607,
 },
 [0x608]={
  arabic="u",
  category="sm",
  contextname="arabicray",
  description="ARABIC RAY",
  direction="al",
  linebreak="al",
  unicodeslot=0x608,
 },
 [0x609]={
  category="po",
  contextname="arabicpermille",
  description="ARABIC-INDIC PER MILLE SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x609,
 },
 [0x60A]={
  category="po",
  contextname="arabicpertenthousand",
  description="ARABIC-INDIC PER TEN THOUSAND SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x60A,
 },
 [0x60B]={
  arabic="u",
  category="sc",
  contextname="afghanicurrency",
  description="AFGHANI SIGN",
  direction="al",
  linebreak="po",
  unicodeslot=0x60B,
 },
 [0x60C]={
  adobename="commaarabic",
  category="po",
  contextname="arabiccomma",
  description="ARABIC COMMA",
  direction="cs",
  linebreak="is",
  unicodeslot=0x60C,
 },
 [0x60D]={
  category="po",
  contextname="arabicdateseparator",
  description="ARABIC DATE SEPARATOR",
  direction="al",
  linebreak="is",
  unicodeslot=0x60D,
 },
 [0x60E]={
  category="so",
  contextname="arabicpoeticverse",
  description="ARABIC POETIC VERSE SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x60E,
 },
 [0x60F]={
  category="so",
  contextname="arabicmisra",
  description="ARABIC SIGN MISRA",
  direction="on",
  linebreak="al",
  unicodeslot=0x60F,
 },
 [0x610]={
  category="mn",
  combining=0xE6,
  contextname="arabichighsallallahou",
  description="ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x610,
 },
 [0x611]={
  category="mn",
  combining=0xE6,
  contextname="arabichighalayheassallam",
  description="ARABIC SIGN ALAYHE ASSALLAM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x611,
 },
 [0x612]={
  category="mn",
  combining=0xE6,
  contextname="arabichighrahmatullahalayhe",
  description="ARABIC SIGN RAHMATULLAH ALAYHE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x612,
 },
 [0x613]={
  category="mn",
  combining=0xE6,
  contextname="arabichighradiallahouanhu",
  description="ARABIC SIGN RADI ALLAHOU ANHU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x613,
 },
 [0x614]={
  category="mn",
  combining=0xE6,
  contextname="arabichightakhallus",
  description="ARABIC SIGN TAKHALLUS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x614,
 },
 [0x615]={
  category="mn",
  combining=0xE6,
  contextname="arabichightah",
  description="ARABIC SMALL HIGH TAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x615,
 },
 [0x616]={
  category="mn",
  combining=0xE6,
  description="ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x616,
 },
 [0x617]={
  category="mn",
  combining=0xE6,
  contextname="arabichighzain",
  description="ARABIC SMALL HIGH ZAIN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x617,
 },
 [0x618]={
  category="mn",
  combining=0x1E,
  description="ARABIC SMALL FATHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x618,
 },
 [0x619]={
  category="mn",
  combining=0x1F,
  description="ARABIC SMALL DAMMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x619,
 },
 [0x61A]={
  category="mn",
  combining=0x20,
  description="ARABIC SMALL KASRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x61A,
 },
 [0x61B]={
  adobename="semicolonarabic",
  category="po",
  contextname="arabicsemicolon",
  description="ARABIC SEMICOLON",
  direction="al",
  linebreak="ex",
  unicodeslot=0x61B,
 },
 [0x61C]={
  category="cf",
  contextname="arabiclettermark",
  description="ARABIC LETTER MARK",
  direction="al",
  linebreak="cm",
  unicodeslot=0x61C,
 },
 [0x61E]={
  category="po",
  contextname="arabictripledot",
  description="ARABIC TRIPLE DOT PUNCTUATION MARK",
  direction="al",
  linebreak="ex",
  unicodeslot=0x61E,
 },
 [0x61F]={
  adobename="questionarabic",
  category="po",
  contextname="arabicquestion",
  description="ARABIC QUESTION MARK",
  direction="al",
  linebreak="ex",
  unicodeslot=0x61F,
 },
 [0x620]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KASHMIRI YEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x620,
 },
 [0x621]={
  adobename="hamzasukunarabic",
  arabic="u",
  category="lo",
  description="ARABIC LETTER HAMZA",
  direction="al",
  linebreak="al",
  unicodeslot=0x621,
 },
 [0x622]={
  adobename="alefmaddaabovearabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER ALEF WITH MADDA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x627,
  specials={ "char", 0x627, 0x653 },
  unicodeslot=0x622,
 },
 [0x623]={
  adobename="alefhamzaabovearabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER ALEF WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x627,
  specials={ "char", 0x627, 0x654 },
  unicodeslot=0x623,
 },
 [0x624]={
  adobename="wawhamzaabovearabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER WAW WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x648,
  specials={ "char", 0x648, 0x654 },
  unicodeslot=0x624,
 },
 [0x625]={
  adobename="alefhamzabelowarabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER ALEF WITH HAMZA BELOW",
  direction="al",
  linebreak="al",
  shcode=0x627,
  specials={ "char", 0x627, 0x655 },
  unicodeslot=0x625,
 },
 [0x626]={
  adobename="yehhamzaabovearabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER YEH WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x64A,
  specials={ "char", 0x64A, 0x654 },
  unicodeslot=0x626,
 },
 [0x627]={
  adobename="alefarabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER ALEF",
  direction="al",
  linebreak="al",
  unicodeslot=0x627,
 },
 [0x628]={
  adobename="beharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x628,
 },
 [0x629]={
  adobename="tehmarbutaarabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER TEH MARBUTA",
  direction="al",
  linebreak="al",
  unicodeslot=0x629,
 },
 [0x62A]={
  adobename="teharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER TEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x62A,
 },
 [0x62B]={
  adobename="theharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER THEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x62B,
 },
 [0x62C]={
  adobename="jeemarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER JEEM",
  direction="al",
  linebreak="al",
  unicodeslot=0x62C,
 },
 [0x62D]={
  adobename="haharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH",
  direction="al",
  linebreak="al",
  unicodeslot=0x62D,
 },
 [0x62E]={
  adobename="khaharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER KHAH",
  direction="al",
  linebreak="al",
  unicodeslot=0x62E,
 },
 [0x62F]={
  adobename="dalarabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x62F,
 },
 [0x630]={
  adobename="thalarabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER THAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x630,
 },
 [0x631]={
  adobename="rehyehaleflamarabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH",
  direction="al",
  linebreak="al",
  unicodeslot=0x631,
 },
 [0x632]={
  adobename="zainarabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER ZAIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x632,
 },
 [0x633]={
  adobename="seenarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER SEEN",
  direction="al",
  linebreak="al",
  unicodeslot=0x633,
 },
 [0x634]={
  adobename="sheenarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER SHEEN",
  direction="al",
  linebreak="al",
  unicodeslot=0x634,
 },
 [0x635]={
  adobename="sadarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER SAD",
  direction="al",
  linebreak="al",
  unicodeslot=0x635,
 },
 [0x636]={
  adobename="dadarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER DAD",
  direction="al",
  linebreak="al",
  unicodeslot=0x636,
 },
 [0x637]={
  adobename="taharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER TAH",
  direction="al",
  linebreak="al",
  unicodeslot=0x637,
 },
 [0x638]={
  adobename="zaharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER ZAH",
  direction="al",
  linebreak="al",
  unicodeslot=0x638,
 },
 [0x639]={
  adobename="ainarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER AIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x639,
 },
 [0x63A]={
  adobename="ghainarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER GHAIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x63A,
 },
 [0x63B]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KEHEH WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x63B,
 },
 [0x63C]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KEHEH WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x63C,
 },
 [0x63D]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH INVERTED V",
  direction="al",
  linebreak="al",
  unicodeslot=0x63D,
 },
 [0x63E]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x63E,
 },
 [0x63F]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x63F,
 },
 [0x640]={
  adobename="tatweelarabic",
  arabic="c",
  category="lm",
  description="ARABIC TATWEEL",
  direction="al",
  linebreak="al",
  synonyms={ "arabic kashida" },
  unicodeslot=0x640,
 },
 [0x641]={
  adobename="feharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER FEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x641,
 },
 [0x642]={
  adobename="qafarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER QAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x642,
 },
 [0x643]={
  adobename="kafarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER KAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x643,
 },
 [0x644]={
  adobename="lamarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER LAM",
  direction="al",
  linebreak="al",
  unicodeslot=0x644,
 },
 [0x645]={
  adobename="meemarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER MEEM",
  direction="al",
  linebreak="al",
  unicodeslot=0x645,
 },
 [0x646]={
  adobename="noonarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER NOON",
  direction="al",
  linebreak="al",
  unicodeslot=0x646,
 },
 [0x647]={
  adobename="heharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER HEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x647,
 },
 [0x648]={
  adobename="wawarabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER WAW",
  direction="al",
  linebreak="al",
  unicodeslot=0x648,
 },
 [0x649]={
  adobename="alefmaksuraarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER ALEF MAKSURA",
  direction="al",
  linebreak="al",
  unicodeslot=0x649,
 },
 [0x64A]={
  adobename="yeharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER YEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x64A,
 },
 [0x64B]={
  adobename="fathatanarabic",
  category="mn",
  combining=0x1B,
  description="ARABIC FATHATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x64B,
 },
 [0x64C]={
  adobename="dammatanarabic",
  category="mn",
  combining=0x1C,
  description="ARABIC DAMMATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x64C,
 },
 [0x64D]={
  adobename="kasratanarabic",
  category="mn",
  combining=0x1D,
  description="ARABIC KASRATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x64D,
 },
 [0x64E]={
  adobename="fathalowarabic",
  category="mn",
  combining=0x1E,
  description="ARABIC FATHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x64E,
 },
 [0x64F]={
  adobename="dammalowarabic",
  category="mn",
  combining=0x1F,
  description="ARABIC DAMMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x64F,
 },
 [0x650]={
  adobename="kasraarabic",
  category="mn",
  combining=0x20,
  description="ARABIC KASRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x650,
 },
 [0x651]={
  adobename="shaddafathatanarabic",
  category="mn",
  combining=0x21,
  description="ARABIC SHADDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x651,
 },
 [0x652]={
  adobename="sukunarabic",
  category="mn",
  combining=0x22,
  description="ARABIC SUKUN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x652,
 },
 [0x653]={
  category="mn",
  combining=0xE6,
  description="ARABIC MADDAH ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x653,
 },
 [0x654]={
  category="mn",
  combining=0xE6,
  description="ARABIC HAMZA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x654,
 },
 [0x655]={
  category="mn",
  combining=0xDC,
  description="ARABIC HAMZA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x655,
 },
 [0x656]={
  category="mn",
  combining=0xDC,
  description="ARABIC SUBSCRIPT ALEF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x656,
 },
 [0x657]={
  category="mn",
  combining=0xE6,
  description="ARABIC INVERTED DAMMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x657,
 },
 [0x658]={
  category="mn",
  combining=0xE6,
  description="ARABIC MARK NOON GHUNNA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x658,
 },
 [0x659]={
  category="mn",
  combining=0xE6,
  description="ARABIC ZWARAKAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x659,
 },
 [0x65A]={
  category="mn",
  combining=0xE6,
  description="ARABIC VOWEL SIGN SMALL V ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x65A,
 },
 [0x65B]={
  category="mn",
  combining=0xE6,
  description="ARABIC VOWEL SIGN INVERTED SMALL V ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x65B,
 },
 [0x65C]={
  category="mn",
  combining=0xDC,
  description="ARABIC VOWEL SIGN DOT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x65C,
 },
 [0x65D]={
  category="mn",
  combining=0xE6,
  description="ARABIC REVERSED DAMMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x65D,
 },
 [0x65E]={
  category="mn",
  combining=0xE6,
  description="ARABIC FATHA WITH TWO DOTS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x65E,
 },
 [0x65F]={
  category="mn",
  combining=0xDC,
  description="ARABIC WAVY HAMZA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x65F,
 },
 [0x660]={
  adobename="zerohackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT ZERO",
  direction="an",
  linebreak="nu",
  unicodeslot=0x660,
 },
 [0x661]={
  adobename="onehackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT ONE",
  direction="an",
  linebreak="nu",
  unicodeslot=0x661,
 },
 [0x662]={
  adobename="twohackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT TWO",
  direction="an",
  linebreak="nu",
  unicodeslot=0x662,
 },
 [0x663]={
  adobename="threehackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT THREE",
  direction="an",
  linebreak="nu",
  unicodeslot=0x663,
 },
 [0x664]={
  adobename="fourhackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT FOUR",
  direction="an",
  linebreak="nu",
  unicodeslot=0x664,
 },
 [0x665]={
  adobename="fivehackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT FIVE",
  direction="an",
  linebreak="nu",
  unicodeslot=0x665,
 },
 [0x666]={
  adobename="sixhackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT SIX",
  direction="an",
  linebreak="nu",
  unicodeslot=0x666,
 },
 [0x667]={
  adobename="sevenhackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT SEVEN",
  direction="an",
  linebreak="nu",
  unicodeslot=0x667,
 },
 [0x668]={
  adobename="eighthackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT EIGHT",
  direction="an",
  linebreak="nu",
  unicodeslot=0x668,
 },
 [0x669]={
  adobename="ninehackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT NINE",
  direction="an",
  linebreak="nu",
  unicodeslot=0x669,
 },
 [0x66A]={
  adobename="percentarabic",
  category="po",
  contextname="arabicpercent",
  description="ARABIC PERCENT SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x66A,
 },
 [0x66B]={
  adobename="decimalseparatorpersian",
  category="po",
  contextname="persiandecimalseparator",
  description="ARABIC DECIMAL SEPARATOR",
  direction="an",
  linebreak="nu",
  unicodeslot=0x66B,
 },
 [0x66C]={
  adobename="thousandsseparatorpersian",
  category="po",
  contextname="persianthousandsseparator",
  description="ARABIC THOUSANDS SEPARATOR",
  direction="an",
  linebreak="nu",
  synonyms={ "arabic phrase separator" },
  unicodeslot=0x66C,
 },
 [0x66D]={
  adobename="asteriskarabic",
  category="po",
  contextname="arabicasterisk",
  description="ARABIC FIVE POINTED STAR",
  direction="al",
  linebreak="al",
  unicodeslot=0x66D,
 },
 [0x66E]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER DOTLESS BEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x66E,
 },
 [0x66F]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER DOTLESS QAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x66F,
 },
 [0x670]={
  category="mn",
  combining=0x23,
  description="ARABIC LETTER SUPERSCRIPT ALEF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x670,
 },
 [0x671]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER ALEF WASLA",
  direction="al",
  linebreak="al",
  unicodeslot=0x671,
 },
 [0x672]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x627,
  unicodeslot=0x672,
 },
 [0x673]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER ALEF WITH WAVY HAMZA BELOW",
  direction="al",
  linebreak="al",
  shcode=0x627,
  unicodeslot=0x673,
 },
 [0x674]={
  arabic="u",
  category="lo",
  description="ARABIC LETTER HIGH HAMZA",
  direction="al",
  linebreak="al",
  unicodeslot=0x674,
 },
 [0x675]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER HIGH HAMZA ALEF",
  direction="al",
  linebreak="al",
  specials={ "compat", 0x627, 0x674 },
  unicodeslot=0x675,
 },
 [0x676]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER HIGH HAMZA WAW",
  direction="al",
  linebreak="al",
  specials={ "compat", 0x648, 0x674 },
  unicodeslot=0x676,
 },
 [0x677]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER U WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x6C7,
  specials={ "compat", 0x6C7, 0x674 },
  unicodeslot=0x677,
 },
 [0x678]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HIGH HAMZA YEH",
  direction="al",
  linebreak="al",
  specials={ "compat", 0x64A, 0x674 },
  unicodeslot=0x678,
 },
 [0x679]={
  adobename="tteharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER TTEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x679,
 },
 [0x67A]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER TTEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x67A,
 },
 [0x67B]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x67B,
 },
 [0x67C]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER TEH WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x62A,
  unicodeslot=0x67C,
 },
 [0x67D]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS",
  direction="al",
  linebreak="al",
  shcode=0x62A,
  unicodeslot=0x67D,
 },
 [0x67E]={
  adobename="peharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER PEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x67E,
 },
 [0x67F]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER TEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x67F,
 },
 [0x680]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x680,
 },
 [0x681]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x62D,
  unicodeslot=0x681,
 },
 [0x682]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x62D,
  unicodeslot=0x682,
 },
 [0x683]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER NYEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x683,
 },
 [0x684]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER DYEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x684,
 },
 [0x685]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x62D,
  unicodeslot=0x685,
 },
 [0x686]={
  adobename="tcheharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER TCHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x686,
 },
 [0x687]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER TCHEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x687,
 },
 [0x688]={
  adobename="ddalarabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER DDAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x688,
 },
 [0x689]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x62F,
  unicodeslot=0x689,
 },
 [0x68A]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x62F,
  unicodeslot=0x68A,
 },
 [0x68B]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH",
  direction="al",
  linebreak="al",
  shcode=0x62F,
  unicodeslot=0x68B,
 },
 [0x68C]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAHAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x68C,
 },
 [0x68D]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DDAHAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x68D,
 },
 [0x68E]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DUL",
  direction="al",
  linebreak="al",
  unicodeslot=0x68E,
 },
 [0x68F]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS",
  direction="al",
  linebreak="al",
  shcode=0x62F,
  unicodeslot=0x68F,
 },
 [0x690]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL WITH FOUR DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x62F,
  unicodeslot=0x690,
 },
 [0x691]={
  adobename="rreharabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER RREH",
  direction="al",
  linebreak="al",
  unicodeslot=0x691,
 },
 [0x692]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x692,
 },
 [0x693]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x693,
 },
 [0x694]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x694,
 },
 [0x695]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH SMALL V BELOW",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x695,
 },
 [0x696]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x696,
 },
 [0x697]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x697,
 },
 [0x698]={
  adobename="jeharabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER JEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x698,
 },
 [0x699]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH FOUR DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x699,
 },
 [0x69A]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x633,
  unicodeslot=0x69A,
 },
 [0x69B]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SEEN WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x633,
  unicodeslot=0x69B,
 },
 [0x69C]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x633,
  unicodeslot=0x69C,
 },
 [0x69D]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SAD WITH TWO DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x635,
  unicodeslot=0x69D,
 },
 [0x69E]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SAD WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x635,
  unicodeslot=0x69E,
 },
 [0x69F]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER TAH WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x637,
  unicodeslot=0x69F,
 },
 [0x6A0]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER AIN WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x639,
  unicodeslot=0x6A0,
 },
 [0x6A1]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER DOTLESS FEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x6A1,
 },
 [0x6A2]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FEH WITH DOT MOVED BELOW",
  direction="al",
  linebreak="al",
  shcode=0x641,
  unicodeslot=0x6A2,
 },
 [0x6A3]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FEH WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x641,
  unicodeslot=0x6A3,
 },
 [0x6A4]={
  adobename="veharabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER VEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x6A4,
 },
 [0x6A5]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FEH WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x641,
  unicodeslot=0x6A5,
 },
 [0x6A6]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER PEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x6A6,
 },
 [0x6A7]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER QAF WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x642,
  unicodeslot=0x6A7,
 },
 [0x6A8]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER QAF WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x642,
  unicodeslot=0x6A8,
 },
 [0x6A9]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x6A9,
 },
 [0x6AA]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SWASH KAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x6AA,
 },
 [0x6AB]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KAF WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x643,
  unicodeslot=0x6AB,
 },
 [0x6AC]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KAF WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x643,
  unicodeslot=0x6AC,
 },
 [0x6AD]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER NG",
  direction="al",
  linebreak="al",
  unicodeslot=0x6AD,
 },
 [0x6AE]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KAF WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x643,
  unicodeslot=0x6AE,
 },
 [0x6AF]={
  adobename="gafarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER GAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x6AF,
 },
 [0x6B0]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER GAF WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x6AF,
  unicodeslot=0x6B0,
 },
 [0x6B1]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER NGOEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x6B1,
 },
 [0x6B2]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER GAF WITH TWO DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x6AF,
  unicodeslot=0x6B2,
 },
 [0x6B3]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER GUEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x6B3,
 },
 [0x6B4]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER GAF WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x6AF,
  unicodeslot=0x6B4,
 },
 [0x6B5]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER LAM WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x644,
  unicodeslot=0x6B5,
 },
 [0x6B6]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER LAM WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x644,
  unicodeslot=0x6B6,
 },
 [0x6B7]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER LAM WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x644,
  unicodeslot=0x6B7,
 },
 [0x6B8]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER LAM WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x644,
  unicodeslot=0x6B8,
 },
 [0x6B9]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER NOON WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x646,
  unicodeslot=0x6B9,
 },
 [0x6BA]={
  adobename="noonghunnaarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER NOON GHUNNA",
  direction="al",
  linebreak="al",
  unicodeslot=0x6BA,
 },
 [0x6BB]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER RNOON",
  direction="al",
  linebreak="al",
  unicodeslot=0x6BB,
 },
 [0x6BC]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER NOON WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x646,
  unicodeslot=0x6BC,
 },
 [0x6BD]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER NOON WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x646,
  unicodeslot=0x6BD,
 },
 [0x6BE]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HEH DOACHASHMEE",
  direction="al",
  linebreak="al",
  unicodeslot=0x6BE,
 },
 [0x6BF]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER TCHEH WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x686,
  unicodeslot=0x6BF,
 },
 [0x6C0]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER HEH WITH YEH ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x647,
  specials={ "char", 0x6D5, 0x654 },
  synonyms={ "arabic letter hamzah on ha", "izafet" },
  unicodeslot=0x6C0,
 },
 [0x6C1]={
  adobename="hehaltonearabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER HEH GOAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x6C1,
 },
 [0x6C2]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HEH GOAL WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  specials={ "char", 0x6C1, 0x654 },
  unicodeslot=0x6C2,
 },
 [0x6C3]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER TEH MARBUTA GOAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x6C3,
 },
 [0x6C4]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER WAW WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x648,
  unicodeslot=0x6C4,
 },
 [0x6C5]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER KIRGHIZ OE",
  direction="al",
  linebreak="al",
  unicodeslot=0x6C5,
 },
 [0x6C6]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER OE",
  direction="al",
  linebreak="al",
  unicodeslot=0x6C6,
 },
 [0x6C7]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER U",
  direction="al",
  linebreak="al",
  unicodeslot=0x6C7,
 },
 [0x6C8]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER YU",
  direction="al",
  linebreak="al",
  unicodeslot=0x6C8,
 },
 [0x6C9]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER KIRGHIZ YU",
  direction="al",
  linebreak="al",
  unicodeslot=0x6C9,
 },
 [0x6CA]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER WAW WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x648,
  unicodeslot=0x6CA,
 },
 [0x6CB]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER VE",
  direction="al",
  linebreak="al",
  unicodeslot=0x6CB,
 },
 [0x6CC]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FARSI YEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x6CC,
 },
 [0x6CD]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER YEH WITH TAIL",
  direction="al",
  linebreak="al",
  shcode=0x64A,
  unicodeslot=0x6CD,
 },
 [0x6CE]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER YEH WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x64A,
  unicodeslot=0x6CE,
 },
 [0x6CF]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER WAW WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x648,
  unicodeslot=0x6CF,
 },
 [0x6D0]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER E",
  direction="al",
  linebreak="al",
  unicodeslot=0x6D0,
 },
 [0x6D1]={
  adobename="yehthreedotsbelowarabic",
  arabic="d",
  category="lo",
  description="ARABIC LETTER YEH WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x64A,
  unicodeslot=0x6D1,
 },
 [0x6D2]={
  adobename="yehbarreearabic",
  arabic="r",
  category="lo",
  description="ARABIC LETTER YEH BARREE",
  direction="al",
  linebreak="al",
  unicodeslot=0x6D2,
 },
 [0x6D3]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER YEH BARREE WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  specials={ "char", 0x6D2, 0x654 },
  unicodeslot=0x6D3,
 },
 [0x6D4]={
  category="po",
  contextname="arabicperiod",
  description="ARABIC FULL STOP",
  direction="al",
  linebreak="ex",
  unicodeslot=0x6D4,
 },
 [0x6D5]={
  adobename="afii57534",
  arabic="r",
  category="lo",
  description="ARABIC LETTER AE",
  direction="al",
  linebreak="al",
  unicodeslot=0x6D5,
 },
 [0x6D6]={
  category="mn",
  combining=0xE6,
  contextname="arabichighesala",
  description="ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6D6,
 },
 [0x6D7]={
  category="mn",
  combining=0xE6,
  contextname="arabichigheqala",
  description="ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6D7,
 },
 [0x6D8]={
  category="mn",
  combining=0xE6,
  contextname="arabichighmeemshort",
  description="ARABIC SMALL HIGH MEEM INITIAL FORM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6D8,
 },
 [0x6D9]={
  category="mn",
  combining=0xE6,
  contextname="arabichighlamalef",
  description="ARABIC SMALL HIGH LAM ALEF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6D9,
 },
 [0x6DA]={
  category="mn",
  combining=0xE6,
  contextname="arabichighjeem",
  description="ARABIC SMALL HIGH JEEM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6DA,
 },
 [0x6DB]={
  category="mn",
  combining=0xE6,
  contextname="arabicshighthreedots",
  description="ARABIC SMALL HIGH THREE DOTS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6DB,
 },
 [0x6DC]={
  category="mn",
  combining=0xE6,
  contextname="arabichighseen",
  description="ARABIC SMALL HIGH SEEN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6DC,
 },
 [0x6DD]={
  arabic="u",
  category="cf",
  contextname="arabicendofayah",
  description="ARABIC END OF AYAH",
  direction="an",
  linebreak="al",
  unicodeslot=0x6DD,
  visible=true,
 },
 [0x6DE]={
  category="me",
  contextname="arabicstartofrubc",
  description="ARABIC START OF RUB EL HIZB",
  direction="on",
  linebreak="al",
  unicodeslot=0x6DE,
 },
 [0x6DF]={
  category="mn",
  combining=0xE6,
  description="ARABIC SMALL HIGH ROUNDED ZERO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6DF,
 },
 [0x6E0]={
  category="mn",
  combining=0xE6,
  description="ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6E0,
 },
 [0x6E1]={
  category="mn",
  combining=0xE6,
  description="ARABIC SMALL HIGH DOTLESS HEAD OF KHAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6E1,
 },
 [0x6E2]={
  category="mn",
  combining=0xE6,
  contextname="arabichighmeemlong",
  description="ARABIC SMALL HIGH MEEM ISOLATED FORM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6E2,
 },
 [0x6E3]={
  category="mn",
  combining=0xDC,
  contextname="arabiclowseen",
  description="ARABIC SMALL LOW SEEN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6E3,
 },
 [0x6E4]={
  category="mn",
  combining=0xE6,
  contextname="arabichighmadda",
  description="ARABIC SMALL HIGH MADDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6E4,
 },
 [0x6E5]={
  category="lm",
  contextname="arabicvowelwaw",
  description="ARABIC SMALL WAW",
  direction="al",
  linebreak="al",
  unicodeslot=0x6E5,
 },
 [0x6E6]={
  category="lm",
  contextname="arabicvowelyeh",
  description="ARABIC SMALL YEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x6E6,
 },
 [0x6E7]={
  category="mn",
  combining=0xE6,
  contextname="arabichighyeh",
  description="ARABIC SMALL HIGH YEH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6E7,
 },
 [0x6E8]={
  category="mn",
  combining=0xE6,
  contextname="arabichighnoon",
  description="ARABIC SMALL HIGH NOON",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6E8,
 },
 [0x6E9]={
  category="so",
  contextname="arabicsajdah",
  description="ARABIC PLACE OF SAJDAH",
  direction="on",
  linebreak="al",
  unicodeslot=0x6E9,
 },
 [0x6EA]={
  category="mn",
  combining=0xDC,
  description="ARABIC EMPTY CENTRE LOW STOP",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6EA,
 },
 [0x6EB]={
  category="mn",
  combining=0xE6,
  description="ARABIC EMPTY CENTRE HIGH STOP",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6EB,
 },
 [0x6EC]={
  category="mn",
  combining=0xE6,
  description="ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6EC,
 },
 [0x6ED]={
  category="mn",
  combining=0xDC,
  contextname="arabiclowmeemlong",
  description="ARABIC SMALL LOW MEEM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x6ED,
 },
 [0x6EE]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL WITH INVERTED V",
  direction="al",
  linebreak="al",
  shcode=0x62F,
  unicodeslot=0x6EE,
 },
 [0x6EF]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH INVERTED V",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x6EF,
 },
 [0x6F0]={
  adobename="zeropersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT ZERO",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F0,
 },
 [0x6F1]={
  adobename="onepersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT ONE",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F1,
 },
 [0x6F2]={
  adobename="twopersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT TWO",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F2,
 },
 [0x6F3]={
  adobename="threepersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT THREE",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F3,
 },
 [0x6F4]={
  adobename="fourpersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT FOUR",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F4,
 },
 [0x6F5]={
  adobename="fivepersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT FIVE",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F5,
 },
 [0x6F6]={
  adobename="sixpersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT SIX",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F6,
 },
 [0x6F7]={
  adobename="sevenpersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT SEVEN",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F7,
 },
 [0x6F8]={
  adobename="eightpersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT EIGHT",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F8,
 },
 [0x6F9]={
  adobename="ninepersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT NINE",
  direction="en",
  linebreak="nu",
  unicodeslot=0x6F9,
 },
 [0x6FA]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SHEEN WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x634,
  unicodeslot=0x6FA,
 },
 [0x6FB]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER DAD WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x636,
  unicodeslot=0x6FB,
 },
 [0x6FC]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER GHAIN WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x63A,
  unicodeslot=0x6FC,
 },
 [0x6FD]={
  category="so",
  description="ARABIC SIGN SINDHI AMPERSAND",
  direction="al",
  linebreak="al",
  unicodeslot=0x6FD,
 },
 [0x6FE]={
  category="so",
  description="ARABIC SIGN SINDHI POSTPOSITION MEN",
  direction="al",
  linebreak="al",
  unicodeslot=0x6FE,
 },
 [0x6FF]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HEH WITH INVERTED V",
  direction="al",
  linebreak="al",
  shcode=0x647,
  unicodeslot=0x6FF,
 },
 [0x700]={
  category="po",
  description="SYRIAC END OF PARAGRAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x700,
 },
 [0x701]={
  category="po",
  description="SYRIAC SUPRALINEAR FULL STOP",
  direction="al",
  linebreak="al",
  unicodeslot=0x701,
 },
 [0x702]={
  category="po",
  description="SYRIAC SUBLINEAR FULL STOP",
  direction="al",
  linebreak="al",
  unicodeslot=0x702,
 },
 [0x703]={
  category="po",
  description="SYRIAC SUPRALINEAR COLON",
  direction="al",
  linebreak="al",
  unicodeslot=0x703,
 },
 [0x704]={
  category="po",
  description="SYRIAC SUBLINEAR COLON",
  direction="al",
  linebreak="al",
  unicodeslot=0x704,
 },
 [0x705]={
  category="po",
  description="SYRIAC HORIZONTAL COLON",
  direction="al",
  linebreak="al",
  unicodeslot=0x705,
 },
 [0x706]={
  category="po",
  description="SYRIAC COLON SKEWED LEFT",
  direction="al",
  linebreak="al",
  unicodeslot=0x706,
 },
 [0x707]={
  category="po",
  description="SYRIAC COLON SKEWED RIGHT",
  direction="al",
  linebreak="al",
  unicodeslot=0x707,
 },
 [0x708]={
  category="po",
  description="SYRIAC SUPRALINEAR COLON SKEWED LEFT",
  direction="al",
  linebreak="al",
  unicodeslot=0x708,
 },
 [0x709]={
  category="po",
  description="SYRIAC SUBLINEAR COLON SKEWED RIGHT",
  direction="al",
  linebreak="al",
  unicodeslot=0x709,
 },
 [0x70A]={
  category="po",
  description="SYRIAC CONTRACTION",
  direction="al",
  linebreak="al",
  unicodeslot=0x70A,
 },
 [0x70B]={
  category="po",
  description="SYRIAC HARKLEAN OBELUS",
  direction="al",
  linebreak="al",
  unicodeslot=0x70B,
 },
 [0x70C]={
  category="po",
  description="SYRIAC HARKLEAN METOBELUS",
  direction="al",
  linebreak="al",
  unicodeslot=0x70C,
 },
 [0x70D]={
  category="po",
  description="SYRIAC HARKLEAN ASTERISCUS",
  direction="al",
  linebreak="al",
  unicodeslot=0x70D,
 },
 [0x70F]={
  category="cf",
  description="SYRIAC ABBREVIATION MARK",
  direction="al",
  linebreak="al",
  synonyms={ "syriac sam" },
  unicodeslot=0x70F,
  visible=true,
 },
 [0x710]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER ALAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x710,
 },
 [0x711]={
  category="mn",
  combining=0x24,
  description="SYRIAC LETTER SUPERSCRIPT ALAPH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x711,
 },
 [0x712]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER BETH",
  direction="al",
  linebreak="al",
  unicodeslot=0x712,
 },
 [0x713]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER GAMAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x713,
 },
 [0x714]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER GAMAL GARSHUNI",
  direction="al",
  linebreak="al",
  unicodeslot=0x714,
 },
 [0x715]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER DALATH",
  direction="al",
  linebreak="al",
  unicodeslot=0x715,
 },
 [0x716]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER DOTLESS DALATH RISH",
  direction="al",
  linebreak="al",
  unicodeslot=0x716,
 },
 [0x717]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER HE",
  direction="al",
  linebreak="al",
  unicodeslot=0x717,
 },
 [0x718]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER WAW",
  direction="al",
  linebreak="al",
  unicodeslot=0x718,
 },
 [0x719]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER ZAIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x719,
 },
 [0x71A]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER HETH",
  direction="al",
  linebreak="al",
  unicodeslot=0x71A,
 },
 [0x71B]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER TETH",
  direction="al",
  linebreak="al",
  unicodeslot=0x71B,
 },
 [0x71C]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER TETH GARSHUNI",
  direction="al",
  linebreak="al",
  unicodeslot=0x71C,
 },
 [0x71D]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER YUDH",
  direction="al",
  linebreak="al",
  unicodeslot=0x71D,
 },
 [0x71E]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER YUDH HE",
  direction="al",
  linebreak="al",
  unicodeslot=0x71E,
 },
 [0x71F]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER KAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x71F,
 },
 [0x720]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER LAMADH",
  direction="al",
  linebreak="al",
  unicodeslot=0x720,
 },
 [0x721]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER MIM",
  direction="al",
  linebreak="al",
  unicodeslot=0x721,
 },
 [0x722]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER NUN",
  direction="al",
  linebreak="al",
  unicodeslot=0x722,
 },
 [0x723]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER SEMKATH",
  direction="al",
  linebreak="al",
  unicodeslot=0x723,
 },
 [0x724]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER FINAL SEMKATH",
  direction="al",
  linebreak="al",
  unicodeslot=0x724,
 },
 [0x725]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER E",
  direction="al",
  linebreak="al",
  unicodeslot=0x725,
 },
 [0x726]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER PE",
  direction="al",
  linebreak="al",
  unicodeslot=0x726,
 },
 [0x727]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER REVERSED PE",
  direction="al",
  linebreak="al",
  unicodeslot=0x727,
 },
 [0x728]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER SADHE",
  direction="al",
  linebreak="al",
  unicodeslot=0x728,
 },
 [0x729]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER QAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x729,
 },
 [0x72A]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER RISH",
  direction="al",
  linebreak="al",
  unicodeslot=0x72A,
 },
 [0x72B]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER SHIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x72B,
 },
 [0x72C]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER TAW",
  direction="al",
  linebreak="al",
  unicodeslot=0x72C,
 },
 [0x72D]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER PERSIAN BHETH",
  direction="al",
  linebreak="al",
  unicodeslot=0x72D,
 },
 [0x72E]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER PERSIAN GHAMAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x72E,
 },
 [0x72F]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER PERSIAN DHALATH",
  direction="al",
  linebreak="al",
  unicodeslot=0x72F,
 },
 [0x730]={
  category="mn",
  combining=0xE6,
  description="SYRIAC PTHAHA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x730,
 },
 [0x731]={
  category="mn",
  combining=0xDC,
  description="SYRIAC PTHAHA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x731,
 },
 [0x732]={
  category="mn",
  combining=0xE6,
  description="SYRIAC PTHAHA DOTTED",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x732,
 },
 [0x733]={
  category="mn",
  combining=0xE6,
  description="SYRIAC ZQAPHA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x733,
 },
 [0x734]={
  category="mn",
  combining=0xDC,
  description="SYRIAC ZQAPHA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x734,
 },
 [0x735]={
  category="mn",
  combining=0xE6,
  description="SYRIAC ZQAPHA DOTTED",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x735,
 },
 [0x736]={
  category="mn",
  combining=0xE6,
  description="SYRIAC RBASA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x736,
 },
 [0x737]={
  category="mn",
  combining=0xDC,
  description="SYRIAC RBASA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x737,
 },
 [0x738]={
  category="mn",
  combining=0xDC,
  description="SYRIAC DOTTED ZLAMA HORIZONTAL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x738,
 },
 [0x739]={
  category="mn",
  combining=0xDC,
  description="SYRIAC DOTTED ZLAMA ANGULAR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x739,
 },
 [0x73A]={
  category="mn",
  combining=0xE6,
  description="SYRIAC HBASA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x73A,
 },
 [0x73B]={
  category="mn",
  combining=0xDC,
  description="SYRIAC HBASA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x73B,
 },
 [0x73C]={
  category="mn",
  combining=0xDC,
  description="SYRIAC HBASA-ESASA DOTTED",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x73C,
 },
 [0x73D]={
  category="mn",
  combining=0xE6,
  description="SYRIAC ESASA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x73D,
 },
 [0x73E]={
  category="mn",
  combining=0xDC,
  description="SYRIAC ESASA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x73E,
 },
 [0x73F]={
  category="mn",
  combining=0xE6,
  description="SYRIAC RWAHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x73F,
 },
 [0x740]={
  category="mn",
  combining=0xE6,
  description="SYRIAC FEMININE DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x740,
 },
 [0x741]={
  category="mn",
  combining=0xE6,
  description="SYRIAC QUSHSHAYA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x741,
 },
 [0x742]={
  category="mn",
  combining=0xDC,
  description="SYRIAC RUKKAKHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x742,
 },
 [0x743]={
  category="mn",
  combining=0xE6,
  description="SYRIAC TWO VERTICAL DOTS ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x743,
 },
 [0x744]={
  category="mn",
  combining=0xDC,
  description="SYRIAC TWO VERTICAL DOTS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x744,
 },
 [0x745]={
  category="mn",
  combining=0xE6,
  description="SYRIAC THREE DOTS ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x745,
 },
 [0x746]={
  category="mn",
  combining=0xDC,
  description="SYRIAC THREE DOTS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x746,
 },
 [0x747]={
  category="mn",
  combining=0xE6,
  description="SYRIAC OBLIQUE LINE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x747,
 },
 [0x748]={
  category="mn",
  combining=0xDC,
  description="SYRIAC OBLIQUE LINE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x748,
 },
 [0x749]={
  category="mn",
  combining=0xE6,
  description="SYRIAC MUSIC",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x749,
 },
 [0x74A]={
  category="mn",
  combining=0xE6,
  description="SYRIAC BARREKH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x74A,
 },
 [0x74D]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER SOGDIAN ZHAIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x74D,
 },
 [0x74E]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER SOGDIAN KHAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x74E,
 },
 [0x74F]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER SOGDIAN FE",
  direction="al",
  linebreak="al",
  unicodeslot=0x74F,
 },
 [0x750]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW",
  direction="al",
  linebreak="al",
  shcode=0x628,
  unicodeslot=0x750,
 },
 [0x751]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x628,
  unicodeslot=0x751,
 },
 [0x752]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x628,
  unicodeslot=0x752,
 },
 [0x753]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x628,
  unicodeslot=0x753,
 },
 [0x754]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x628,
  unicodeslot=0x754,
 },
 [0x755]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH INVERTED SMALL V BELOW",
  direction="al",
  linebreak="al",
  shcode=0x628,
  unicodeslot=0x755,
 },
 [0x756]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x628,
  unicodeslot=0x756,
 },
 [0x757]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x62D,
  unicodeslot=0x757,
 },
 [0x758]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x62D,
  unicodeslot=0x758,
 },
 [0x759]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH",
  direction="al",
  linebreak="al",
  shcode=0x62F,
  unicodeslot=0x759,
 },
 [0x75A]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL WITH INVERTED SMALL V BELOW",
  direction="al",
  linebreak="al",
  shcode=0x62F,
  unicodeslot=0x75A,
 },
 [0x75B]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH STROKE",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x75B,
 },
 [0x75C]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SEEN WITH FOUR DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x633,
  unicodeslot=0x75C,
 },
 [0x75D]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER AIN WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x639,
  unicodeslot=0x75D,
 },
 [0x75E]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x639,
  unicodeslot=0x75E,
 },
 [0x75F]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x639,
  unicodeslot=0x75F,
 },
 [0x760]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FEH WITH TWO DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x641,
  unicodeslot=0x760,
 },
 [0x761]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x641,
  unicodeslot=0x761,
 },
 [0x762]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KEHEH WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x6A9,
  unicodeslot=0x762,
 },
 [0x763]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KEHEH WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x6A9,
  unicodeslot=0x763,
 },
 [0x764]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x6A9,
  unicodeslot=0x764,
 },
 [0x765]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER MEEM WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x645,
  unicodeslot=0x765,
 },
 [0x766]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER MEEM WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x645,
  unicodeslot=0x766,
 },
 [0x767]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER NOON WITH TWO DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x646,
  unicodeslot=0x767,
 },
 [0x768]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER NOON WITH SMALL TAH",
  direction="al",
  linebreak="al",
  shcode=0x646,
  unicodeslot=0x768,
 },
 [0x769]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER NOON WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x646,
  unicodeslot=0x769,
 },
 [0x76A]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER LAM WITH BAR",
  direction="al",
  linebreak="al",
  shcode=0x644,
  unicodeslot=0x76A,
 },
 [0x76B]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x76B,
 },
 [0x76C]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x631,
  unicodeslot=0x76C,
 },
 [0x76D]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x633,
  unicodeslot=0x76D,
 },
 [0x76E]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x76E,
 },
 [0x76F]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
  direction="al",
  linebreak="al",
  unicodeslot=0x76F,
 },
 [0x770]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
  direction="al",
  linebreak="al",
  unicodeslot=0x770,
 },
 [0x771]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
  direction="al",
  linebreak="al",
  unicodeslot=0x771,
 },
 [0x772]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x772,
 },
 [0x773]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x773,
 },
 [0x774]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x774,
 },
 [0x775]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x775,
 },
 [0x776]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x776,
 },
 [0x777]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x777,
 },
 [0x778]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x778,
 },
 [0x779]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x779,
 },
 [0x77A]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x77A,
 },
 [0x77B]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x77B,
 },
 [0x77C]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x77C,
 },
 [0x77D]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x77D,
 },
 [0x77E]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SEEN WITH INVERTED V",
  direction="al",
  linebreak="al",
  unicodeslot=0x77E,
 },
 [0x77F]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KAF WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x77F,
 },
 [0x780]={
  category="lo",
  description="THAANA LETTER HAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x780,
 },
 [0x781]={
  category="lo",
  description="THAANA LETTER SHAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x781,
 },
 [0x782]={
  category="lo",
  description="THAANA LETTER NOONU",
  direction="al",
  linebreak="al",
  unicodeslot=0x782,
 },
 [0x783]={
  category="lo",
  description="THAANA LETTER RAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x783,
 },
 [0x784]={
  category="lo",
  description="THAANA LETTER BAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x784,
 },
 [0x785]={
  category="lo",
  description="THAANA LETTER LHAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x785,
 },
 [0x786]={
  category="lo",
  description="THAANA LETTER KAAFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x786,
 },
 [0x787]={
  category="lo",
  description="THAANA LETTER ALIFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x787,
 },
 [0x788]={
  category="lo",
  description="THAANA LETTER VAAVU",
  direction="al",
  linebreak="al",
  unicodeslot=0x788,
 },
 [0x789]={
  category="lo",
  description="THAANA LETTER MEEMU",
  direction="al",
  linebreak="al",
  unicodeslot=0x789,
 },
 [0x78A]={
  category="lo",
  description="THAANA LETTER FAAFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x78A,
 },
 [0x78B]={
  category="lo",
  description="THAANA LETTER DHAALU",
  direction="al",
  linebreak="al",
  unicodeslot=0x78B,
 },
 [0x78C]={
  category="lo",
  description="THAANA LETTER THAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x78C,
 },
 [0x78D]={
  category="lo",
  description="THAANA LETTER LAAMU",
  direction="al",
  linebreak="al",
  unicodeslot=0x78D,
 },
 [0x78E]={
  category="lo",
  description="THAANA LETTER GAAFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x78E,
 },
 [0x78F]={
  category="lo",
  description="THAANA LETTER GNAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x78F,
 },
 [0x790]={
  category="lo",
  description="THAANA LETTER SEENU",
  direction="al",
  linebreak="al",
  unicodeslot=0x790,
 },
 [0x791]={
  category="lo",
  description="THAANA LETTER DAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x791,
 },
 [0x792]={
  category="lo",
  description="THAANA LETTER ZAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x792,
 },
 [0x793]={
  category="lo",
  description="THAANA LETTER TAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x793,
 },
 [0x794]={
  category="lo",
  description="THAANA LETTER YAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x794,
 },
 [0x795]={
  category="lo",
  description="THAANA LETTER PAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x795,
 },
 [0x796]={
  category="lo",
  description="THAANA LETTER JAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x796,
 },
 [0x797]={
  category="lo",
  description="THAANA LETTER CHAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x797,
 },
 [0x798]={
  category="lo",
  description="THAANA LETTER TTAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x798,
 },
 [0x799]={
  category="lo",
  description="THAANA LETTER HHAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x799,
 },
 [0x79A]={
  category="lo",
  description="THAANA LETTER KHAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x79A,
 },
 [0x79B]={
  category="lo",
  description="THAANA LETTER THAALU",
  direction="al",
  linebreak="al",
  unicodeslot=0x79B,
 },
 [0x79C]={
  category="lo",
  description="THAANA LETTER ZAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x79C,
 },
 [0x79D]={
  category="lo",
  description="THAANA LETTER SHEENU",
  direction="al",
  linebreak="al",
  unicodeslot=0x79D,
 },
 [0x79E]={
  category="lo",
  description="THAANA LETTER SAADHU",
  direction="al",
  linebreak="al",
  unicodeslot=0x79E,
 },
 [0x79F]={
  category="lo",
  description="THAANA LETTER DAADHU",
  direction="al",
  linebreak="al",
  unicodeslot=0x79F,
 },
 [0x7A0]={
  category="lo",
  description="THAANA LETTER TO",
  direction="al",
  linebreak="al",
  unicodeslot=0x7A0,
 },
 [0x7A1]={
  category="lo",
  description="THAANA LETTER ZO",
  direction="al",
  linebreak="al",
  unicodeslot=0x7A1,
 },
 [0x7A2]={
  category="lo",
  description="THAANA LETTER AINU",
  direction="al",
  linebreak="al",
  unicodeslot=0x7A2,
 },
 [0x7A3]={
  category="lo",
  description="THAANA LETTER GHAINU",
  direction="al",
  linebreak="al",
  unicodeslot=0x7A3,
 },
 [0x7A4]={
  category="lo",
  description="THAANA LETTER QAAFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x7A4,
 },
 [0x7A5]={
  category="lo",
  description="THAANA LETTER WAAVU",
  direction="al",
  linebreak="al",
  unicodeslot=0x7A5,
 },
 [0x7A6]={
  category="mn",
  description="THAANA ABAFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7A6,
 },
 [0x7A7]={
  category="mn",
  description="THAANA AABAAFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7A7,
 },
 [0x7A8]={
  category="mn",
  description="THAANA IBIFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7A8,
 },
 [0x7A9]={
  category="mn",
  description="THAANA EEBEEFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7A9,
 },
 [0x7AA]={
  category="mn",
  description="THAANA UBUFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7AA,
 },
 [0x7AB]={
  category="mn",
  description="THAANA OOBOOFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7AB,
 },
 [0x7AC]={
  category="mn",
  description="THAANA EBEFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7AC,
 },
 [0x7AD]={
  category="mn",
  description="THAANA EYBEYFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7AD,
 },
 [0x7AE]={
  category="mn",
  description="THAANA OBOFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7AE,
 },
 [0x7AF]={
  category="mn",
  description="THAANA OABOAFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7AF,
 },
 [0x7B0]={
  category="mn",
  description="THAANA SUKUN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7B0,
 },
 [0x7B1]={
  category="lo",
  description="THAANA LETTER NAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x7B1,
 },
 [0x7C0]={
  category="nd",
  description="NKO DIGIT ZERO",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C0,
 },
 [0x7C1]={
  category="nd",
  description="NKO DIGIT ONE",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C1,
 },
 [0x7C2]={
  category="nd",
  description="NKO DIGIT TWO",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C2,
 },
 [0x7C3]={
  category="nd",
  description="NKO DIGIT THREE",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C3,
 },
 [0x7C4]={
  category="nd",
  description="NKO DIGIT FOUR",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C4,
 },
 [0x7C5]={
  category="nd",
  description="NKO DIGIT FIVE",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C5,
 },
 [0x7C6]={
  category="nd",
  description="NKO DIGIT SIX",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C6,
 },
 [0x7C7]={
  category="nd",
  description="NKO DIGIT SEVEN",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C7,
 },
 [0x7C8]={
  category="nd",
  description="NKO DIGIT EIGHT",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C8,
 },
 [0x7C9]={
  category="nd",
  description="NKO DIGIT NINE",
  direction="r",
  linebreak="nu",
  unicodeslot=0x7C9,
 },
 [0x7CA]={
  arabic="d",
  category="lo",
  description="NKO LETTER A",
  direction="r",
  linebreak="al",
  unicodeslot=0x7CA,
 },
 [0x7CB]={
  arabic="d",
  category="lo",
  description="NKO LETTER EE",
  direction="r",
  linebreak="al",
  unicodeslot=0x7CB,
 },
 [0x7CC]={
  arabic="d",
  category="lo",
  description="NKO LETTER I",
  direction="r",
  linebreak="al",
  unicodeslot=0x7CC,
 },
 [0x7CD]={
  arabic="d",
  category="lo",
  description="NKO LETTER E",
  direction="r",
  linebreak="al",
  unicodeslot=0x7CD,
 },
 [0x7CE]={
  arabic="d",
  category="lo",
  description="NKO LETTER U",
  direction="r",
  linebreak="al",
  unicodeslot=0x7CE,
 },
 [0x7CF]={
  arabic="d",
  category="lo",
  description="NKO LETTER OO",
  direction="r",
  linebreak="al",
  unicodeslot=0x7CF,
 },
 [0x7D0]={
  arabic="d",
  category="lo",
  description="NKO LETTER O",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D0,
 },
 [0x7D1]={
  arabic="d",
  category="lo",
  description="NKO LETTER DAGBASINNA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D1,
 },
 [0x7D2]={
  arabic="d",
  category="lo",
  description="NKO LETTER N",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D2,
 },
 [0x7D3]={
  arabic="d",
  category="lo",
  description="NKO LETTER BA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D3,
 },
 [0x7D4]={
  arabic="d",
  category="lo",
  description="NKO LETTER PA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D4,
 },
 [0x7D5]={
  arabic="d",
  category="lo",
  description="NKO LETTER TA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D5,
 },
 [0x7D6]={
  arabic="d",
  category="lo",
  description="NKO LETTER JA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D6,
 },
 [0x7D7]={
  arabic="d",
  category="lo",
  description="NKO LETTER CHA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D7,
 },
 [0x7D8]={
  arabic="d",
  category="lo",
  description="NKO LETTER DA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D8,
 },
 [0x7D9]={
  arabic="d",
  category="lo",
  description="NKO LETTER RA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7D9,
 },
 [0x7DA]={
  arabic="d",
  category="lo",
  description="NKO LETTER RRA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7DA,
 },
 [0x7DB]={
  arabic="d",
  category="lo",
  description="NKO LETTER SA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7DB,
 },
 [0x7DC]={
  arabic="d",
  category="lo",
  description="NKO LETTER GBA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7DC,
 },
 [0x7DD]={
  arabic="d",
  category="lo",
  description="NKO LETTER FA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7DD,
 },
 [0x7DE]={
  arabic="d",
  category="lo",
  description="NKO LETTER KA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7DE,
 },
 [0x7DF]={
  arabic="d",
  category="lo",
  description="NKO LETTER LA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7DF,
 },
 [0x7E0]={
  arabic="d",
  category="lo",
  description="NKO LETTER NA WOLOSO",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E0,
 },
 [0x7E1]={
  arabic="d",
  category="lo",
  description="NKO LETTER MA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E1,
 },
 [0x7E2]={
  arabic="d",
  category="lo",
  description="NKO LETTER NYA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E2,
 },
 [0x7E3]={
  arabic="d",
  category="lo",
  description="NKO LETTER NA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E3,
 },
 [0x7E4]={
  arabic="d",
  category="lo",
  description="NKO LETTER HA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E4,
 },
 [0x7E5]={
  arabic="d",
  category="lo",
  description="NKO LETTER WA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E5,
 },
 [0x7E6]={
  arabic="d",
  category="lo",
  description="NKO LETTER YA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E6,
 },
 [0x7E7]={
  arabic="d",
  category="lo",
  description="NKO LETTER NYA WOLOSO",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E7,
 },
 [0x7E8]={
  arabic="d",
  category="lo",
  description="NKO LETTER JONA JA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E8,
 },
 [0x7E9]={
  arabic="d",
  category="lo",
  description="NKO LETTER JONA CHA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7E9,
 },
 [0x7EA]={
  arabic="d",
  category="lo",
  description="NKO LETTER JONA RA",
  direction="r",
  linebreak="al",
  unicodeslot=0x7EA,
 },
 [0x7EB]={
  category="mn",
  combining=0xE6,
  description="NKO COMBINING SHORT HIGH TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7EB,
 },
 [0x7EC]={
  category="mn",
  combining=0xE6,
  description="NKO COMBINING SHORT LOW TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7EC,
 },
 [0x7ED]={
  category="mn",
  combining=0xE6,
  description="NKO COMBINING SHORT RISING TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7ED,
 },
 [0x7EE]={
  category="mn",
  combining=0xE6,
  description="NKO COMBINING LONG DESCENDING TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7EE,
 },
 [0x7EF]={
  category="mn",
  combining=0xE6,
  description="NKO COMBINING LONG HIGH TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7EF,
 },
 [0x7F0]={
  category="mn",
  combining=0xE6,
  description="NKO COMBINING LONG LOW TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7F0,
 },
 [0x7F1]={
  category="mn",
  combining=0xE6,
  description="NKO COMBINING LONG RISING TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7F1,
 },
 [0x7F2]={
  category="mn",
  combining=0xDC,
  description="NKO COMBINING NASALIZATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7F2,
 },
 [0x7F3]={
  category="mn",
  combining=0xE6,
  description="NKO COMBINING DOUBLE DOT ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x7F3,
 },
 [0x7F4]={
  category="lm",
  description="NKO HIGH TONE APOSTROPHE",
  direction="r",
  linebreak="al",
  unicodeslot=0x7F4,
 },
 [0x7F5]={
  category="lm",
  description="NKO LOW TONE APOSTROPHE",
  direction="r",
  linebreak="al",
  unicodeslot=0x7F5,
 },
 [0x7F6]={
  category="so",
  description="NKO SYMBOL OO DENNEN",
  direction="on",
  linebreak="al",
  unicodeslot=0x7F6,
 },
 [0x7F7]={
  category="po",
  description="NKO SYMBOL GBAKURUNEN",
  direction="on",
  linebreak="al",
  unicodeslot=0x7F7,
 },
 [0x7F8]={
  category="po",
  description="NKO COMMA",
  direction="on",
  linebreak="is",
  unicodeslot=0x7F8,
 },
 [0x7F9]={
  category="po",
  description="NKO EXCLAMATION MARK",
  direction="on",
  linebreak="ex",
  unicodeslot=0x7F9,
 },
 [0x7FA]={
  arabic="c",
  category="lm",
  description="NKO LAJANYALAN",
  direction="r",
  linebreak="al",
  unicodeslot=0x7FA,
 },
 [0x800]={
  category="lo",
  description="SAMARITAN LETTER ALAF",
  direction="r",
  linebreak="al",
  unicodeslot=0x800,
 },
 [0x801]={
  category="lo",
  description="SAMARITAN LETTER BIT",
  direction="r",
  linebreak="al",
  unicodeslot=0x801,
 },
 [0x802]={
  category="lo",
  description="SAMARITAN LETTER GAMAN",
  direction="r",
  linebreak="al",
  unicodeslot=0x802,
 },
 [0x803]={
  category="lo",
  description="SAMARITAN LETTER DALAT",
  direction="r",
  linebreak="al",
  unicodeslot=0x803,
 },
 [0x804]={
  category="lo",
  description="SAMARITAN LETTER IY",
  direction="r",
  linebreak="al",
  unicodeslot=0x804,
 },
 [0x805]={
  category="lo",
  description="SAMARITAN LETTER BAA",
  direction="r",
  linebreak="al",
  unicodeslot=0x805,
 },
 [0x806]={
  category="lo",
  description="SAMARITAN LETTER ZEN",
  direction="r",
  linebreak="al",
  unicodeslot=0x806,
 },
 [0x807]={
  category="lo",
  description="SAMARITAN LETTER IT",
  direction="r",
  linebreak="al",
  unicodeslot=0x807,
 },
 [0x808]={
  category="lo",
  description="SAMARITAN LETTER TIT",
  direction="r",
  linebreak="al",
  unicodeslot=0x808,
 },
 [0x809]={
  category="lo",
  description="SAMARITAN LETTER YUT",
  direction="r",
  linebreak="al",
  unicodeslot=0x809,
 },
 [0x80A]={
  category="lo",
  description="SAMARITAN LETTER KAAF",
  direction="r",
  linebreak="al",
  unicodeslot=0x80A,
 },
 [0x80B]={
  category="lo",
  description="SAMARITAN LETTER LABAT",
  direction="r",
  linebreak="al",
  unicodeslot=0x80B,
 },
 [0x80C]={
  category="lo",
  description="SAMARITAN LETTER MIM",
  direction="r",
  linebreak="al",
  unicodeslot=0x80C,
 },
 [0x80D]={
  category="lo",
  description="SAMARITAN LETTER NUN",
  direction="r",
  linebreak="al",
  unicodeslot=0x80D,
 },
 [0x80E]={
  category="lo",
  description="SAMARITAN LETTER SINGAAT",
  direction="r",
  linebreak="al",
  unicodeslot=0x80E,
 },
 [0x80F]={
  category="lo",
  description="SAMARITAN LETTER IN",
  direction="r",
  linebreak="al",
  unicodeslot=0x80F,
 },
 [0x810]={
  category="lo",
  description="SAMARITAN LETTER FI",
  direction="r",
  linebreak="al",
  unicodeslot=0x810,
 },
 [0x811]={
  category="lo",
  description="SAMARITAN LETTER TSAADIY",
  direction="r",
  linebreak="al",
  unicodeslot=0x811,
 },
 [0x812]={
  category="lo",
  description="SAMARITAN LETTER QUF",
  direction="r",
  linebreak="al",
  unicodeslot=0x812,
 },
 [0x813]={
  category="lo",
  description="SAMARITAN LETTER RISH",
  direction="r",
  linebreak="al",
  unicodeslot=0x813,
 },
 [0x814]={
  category="lo",
  description="SAMARITAN LETTER SHAN",
  direction="r",
  linebreak="al",
  unicodeslot=0x814,
 },
 [0x815]={
  category="lo",
  description="SAMARITAN LETTER TAAF",
  direction="r",
  linebreak="al",
  unicodeslot=0x815,
 },
 [0x816]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN MARK IN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x816,
 },
 [0x817]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN MARK IN-ALAF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x817,
 },
 [0x818]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN MARK OCCLUSION",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x818,
 },
 [0x819]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN MARK DAGESH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x819,
 },
 [0x81A]={
  category="lm",
  description="SAMARITAN MODIFIER LETTER EPENTHETIC YUT",
  direction="r",
  linebreak="al",
  unicodeslot=0x81A,
 },
 [0x81B]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN MARK EPENTHETIC YUT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x81B,
 },
 [0x81C]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN LONG E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x81C,
 },
 [0x81D]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x81D,
 },
 [0x81E]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN OVERLONG AA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x81E,
 },
 [0x81F]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN LONG AA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x81F,
 },
 [0x820]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN AA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x820,
 },
 [0x821]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN OVERLONG A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x821,
 },
 [0x822]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN LONG A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x822,
 },
 [0x823]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x823,
 },
 [0x824]={
  category="lm",
  description="SAMARITAN MODIFIER LETTER SHORT A",
  direction="r",
  linebreak="al",
  unicodeslot=0x824,
 },
 [0x825]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN SHORT A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x825,
 },
 [0x826]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN LONG U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x826,
 },
 [0x827]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x827,
 },
 [0x828]={
  category="lm",
  description="SAMARITAN MODIFIER LETTER I",
  direction="r",
  linebreak="al",
  unicodeslot=0x828,
 },
 [0x829]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN LONG I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x829,
 },
 [0x82A]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x82A,
 },
 [0x82B]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x82B,
 },
 [0x82C]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN VOWEL SIGN SUKUN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x82C,
 },
 [0x82D]={
  category="mn",
  combining=0xE6,
  description="SAMARITAN MARK NEQUDAA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x82D,
 },
 [0x830]={
  category="po",
  description="SAMARITAN PUNCTUATION NEQUDAA",
  direction="r",
  linebreak="al",
  unicodeslot=0x830,
 },
 [0x831]={
  category="po",
  description="SAMARITAN PUNCTUATION AFSAAQ",
  direction="r",
  linebreak="al",
  unicodeslot=0x831,
 },
 [0x832]={
  category="po",
  description="SAMARITAN PUNCTUATION ANGED",
  direction="r",
  linebreak="al",
  unicodeslot=0x832,
 },
 [0x833]={
  category="po",
  description="SAMARITAN PUNCTUATION BAU",
  direction="r",
  linebreak="al",
  unicodeslot=0x833,
 },
 [0x834]={
  category="po",
  description="SAMARITAN PUNCTUATION ATMAAU",
  direction="r",
  linebreak="al",
  unicodeslot=0x834,
 },
 [0x835]={
  category="po",
  description="SAMARITAN PUNCTUATION SHIYYAALAA",
  direction="r",
  linebreak="al",
  unicodeslot=0x835,
 },
 [0x836]={
  category="po",
  description="SAMARITAN ABBREVIATION MARK",
  direction="r",
  linebreak="al",
  unicodeslot=0x836,
 },
 [0x837]={
  category="po",
  description="SAMARITAN PUNCTUATION MELODIC QITSA",
  direction="r",
  linebreak="al",
  unicodeslot=0x837,
 },
 [0x838]={
  category="po",
  description="SAMARITAN PUNCTUATION ZIQAA",
  direction="r",
  linebreak="al",
  unicodeslot=0x838,
 },
 [0x839]={
  category="po",
  description="SAMARITAN PUNCTUATION QITSA",
  direction="r",
  linebreak="al",
  unicodeslot=0x839,
 },
 [0x83A]={
  category="po",
  description="SAMARITAN PUNCTUATION ZAEF",
  direction="r",
  linebreak="al",
  unicodeslot=0x83A,
 },
 [0x83B]={
  category="po",
  description="SAMARITAN PUNCTUATION TURU",
  direction="r",
  linebreak="al",
  unicodeslot=0x83B,
 },
 [0x83C]={
  category="po",
  description="SAMARITAN PUNCTUATION ARKAANU",
  direction="r",
  linebreak="al",
  unicodeslot=0x83C,
 },
 [0x83D]={
  category="po",
  description="SAMARITAN PUNCTUATION SOF MASHFAAT",
  direction="r",
  linebreak="al",
  unicodeslot=0x83D,
 },
 [0x83E]={
  category="po",
  description="SAMARITAN PUNCTUATION ANNAAU",
  direction="r",
  linebreak="al",
  unicodeslot=0x83E,
 },
 [0x840]={
  arabic="r",
  category="lo",
  description="MANDAIC LETTER HALQA",
  direction="r",
  linebreak="al",
  unicodeslot=0x840,
 },
 [0x841]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AB",
  direction="r",
  linebreak="al",
  unicodeslot=0x841,
 },
 [0x842]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AG",
  direction="r",
  linebreak="al",
  unicodeslot=0x842,
 },
 [0x843]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AD",
  direction="r",
  linebreak="al",
  unicodeslot=0x843,
 },
 [0x844]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AH",
  direction="r",
  linebreak="al",
  unicodeslot=0x844,
 },
 [0x845]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER USHENNA",
  direction="r",
  linebreak="al",
  unicodeslot=0x845,
 },
 [0x846]={
  arabic="r",
  category="lo",
  description="MANDAIC LETTER AZ",
  direction="r",
  linebreak="al",
  unicodeslot=0x846,
 },
 [0x847]={
  arabic="r",
  category="lo",
  description="MANDAIC LETTER IT",
  direction="r",
  linebreak="al",
  unicodeslot=0x847,
 },
 [0x848]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER ATT",
  direction="r",
  linebreak="al",
  unicodeslot=0x848,
 },
 [0x849]={
  arabic="r",
  category="lo",
  description="MANDAIC LETTER AKSA",
  direction="r",
  linebreak="al",
  unicodeslot=0x849,
 },
 [0x84A]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AK",
  direction="r",
  linebreak="al",
  unicodeslot=0x84A,
 },
 [0x84B]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AL",
  direction="r",
  linebreak="al",
  unicodeslot=0x84B,
 },
 [0x84C]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AM",
  direction="r",
  linebreak="al",
  unicodeslot=0x84C,
 },
 [0x84D]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AN",
  direction="r",
  linebreak="al",
  unicodeslot=0x84D,
 },
 [0x84E]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AS",
  direction="r",
  linebreak="al",
  unicodeslot=0x84E,
 },
 [0x84F]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER IN",
  direction="r",
  linebreak="al",
  unicodeslot=0x84F,
 },
 [0x850]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AP",
  direction="r",
  linebreak="al",
  unicodeslot=0x850,
 },
 [0x851]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER ASZ",
  direction="r",
  linebreak="al",
  unicodeslot=0x851,
 },
 [0x852]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AQ",
  direction="r",
  linebreak="al",
  unicodeslot=0x852,
 },
 [0x853]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AR",
  direction="r",
  linebreak="al",
  unicodeslot=0x853,
 },
 [0x854]={
  arabic="r",
  category="lo",
  description="MANDAIC LETTER ASH",
  direction="r",
  linebreak="al",
  unicodeslot=0x854,
 },
 [0x855]={
  arabic="d",
  category="lo",
  description="MANDAIC LETTER AT",
  direction="r",
  linebreak="al",
  unicodeslot=0x855,
 },
 [0x856]={
  arabic="u",
  category="lo",
  description="MANDAIC LETTER DUSHENNA",
  direction="r",
  linebreak="al",
  unicodeslot=0x856,
 },
 [0x857]={
  arabic="u",
  category="lo",
  description="MANDAIC LETTER KAD",
  direction="r",
  linebreak="al",
  unicodeslot=0x857,
 },
 [0x858]={
  arabic="u",
  category="lo",
  description="MANDAIC LETTER AIN",
  direction="r",
  linebreak="al",
  unicodeslot=0x858,
 },
 [0x859]={
  category="mn",
  combining=0xDC,
  description="MANDAIC AFFRICATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x859,
 },
 [0x85A]={
  category="mn",
  combining=0xDC,
  description="MANDAIC VOCALIZATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x85A,
 },
 [0x85B]={
  category="mn",
  combining=0xDC,
  description="MANDAIC GEMINATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x85B,
 },
 [0x85E]={
  category="po",
  description="MANDAIC PUNCTUATION",
  direction="r",
  linebreak="al",
  unicodeslot=0x85E,
 },
 [0x860]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER MALAYALAM NGA",
  direction="al",
  linebreak="al",
  unicodeslot=0x860,
 },
 [0x861]={
  arabic="u",
  category="lo",
  description="SYRIAC LETTER MALAYALAM JA",
  direction="al",
  linebreak="al",
  unicodeslot=0x861,
 },
 [0x862]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER MALAYALAM NYA",
  direction="al",
  linebreak="al",
  unicodeslot=0x862,
 },
 [0x863]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER MALAYALAM TTA",
  direction="al",
  linebreak="al",
  unicodeslot=0x863,
 },
 [0x864]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER MALAYALAM NNA",
  direction="al",
  linebreak="al",
  unicodeslot=0x864,
 },
 [0x865]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER MALAYALAM NNNA",
  direction="al",
  linebreak="al",
  unicodeslot=0x865,
 },
 [0x866]={
  arabic="u",
  category="lo",
  description="SYRIAC LETTER MALAYALAM BHA",
  direction="al",
  linebreak="al",
  unicodeslot=0x866,
 },
 [0x867]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER MALAYALAM RA",
  direction="al",
  linebreak="al",
  unicodeslot=0x867,
 },
 [0x868]={
  arabic="d",
  category="lo",
  description="SYRIAC LETTER MALAYALAM LLA",
  direction="al",
  linebreak="al",
  unicodeslot=0x868,
 },
 [0x869]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER MALAYALAM LLLA",
  direction="al",
  linebreak="al",
  unicodeslot=0x869,
 },
 [0x86A]={
  arabic="r",
  category="lo",
  description="SYRIAC LETTER MALAYALAM SSA",
  direction="al",
  linebreak="al",
  unicodeslot=0x86A,
 },
 [0x8A0]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH SMALL V BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A0,
 },
 [0x8A1]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A1,
 },
 [0x8A2]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER JEEM WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A2,
 },
 [0x8A3]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER TAH WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A3,
 },
 [0x8A4]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER FEH WITH DOT BELOW AND THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A4,
 },
 [0x8A5]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER QAF WITH DOT BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A5,
 },
 [0x8A6]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER LAM WITH DOUBLE BAR",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A6,
 },
 [0x8A7]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER MEEM WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A7,
 },
 [0x8A8]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A8,
 },
 [0x8A9]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER YEH WITH TWO DOTS BELOW AND DOT ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8A9,
 },
 [0x8AA]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH LOOP",
  direction="al",
  linebreak="al",
  unicodeslot=0x8AA,
 },
 [0x8AB]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER WAW WITH DOT WITHIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x8AB,
 },
 [0x8AC]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER ROHINGYA YEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x8AC,
 },
 [0x8AD]={
  arabic="u",
  category="lo",
  description="ARABIC LETTER LOW ALEF",
  direction="al",
  linebreak="al",
  unicodeslot=0x8AD,
 },
 [0x8AE]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER DAL WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x8AE,
 },
 [0x8AF]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER SAD WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x8AF,
 },
 [0x8B0]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER GAF WITH INVERTED STROKE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8B0,
 },
 [0x8B1]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER STRAIGHT WAW",
  direction="al",
  linebreak="al",
  unicodeslot=0x8B1,
 },
 [0x8B2]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER ZAIN WITH INVERTED V ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8B2,
 },
 [0x8B3]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER AIN WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x8B3,
 },
 [0x8B4]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER KAF WITH DOT BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x8B4,
 },
 [0x8B6]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER BEH WITH SMALL MEEM ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8B6,
 },
 [0x8B7]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER PEH WITH SMALL MEEM ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8B7,
 },
 [0x8B8]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER TEH WITH SMALL TEH ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8B8,
 },
 [0x8B9]={
  arabic="r",
  category="lo",
  description="ARABIC LETTER REH WITH SMALL NOON ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8B9,
 },
 [0x8BA]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER YEH WITH TWO DOTS BELOW AND SMALL NOON ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x8BA,
 },
 [0x8BB]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER AFRICAN FEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x8BB,
 },
 [0x8BC]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER AFRICAN QAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x8BC,
 },
 [0x8BD]={
  arabic="d",
  category="lo",
  description="ARABIC LETTER AFRICAN NOON",
  direction="al",
  linebreak="al",
  unicodeslot=0x8BD,
 },
 [0x8D4]={
  category="mn",
  combining=0xE6,
  contextname="arabichighrubc",
  description="ARABIC SMALL HIGH WORD AR-RUB",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8D4,
 },
 [0x8D5]={
  category="mn",
  combining=0xE6,
  contextname="arabichighsad",
  description="ARABIC SMALL HIGH SAD",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8D5,
 },
 [0x8D6]={
  category="mn",
  combining=0xE6,
  contextname="arabichighain",
  description="ARABIC SMALL HIGH AIN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8D6,
 },
 [0x8D7]={
  category="mn",
  combining=0xE6,
  contextname="arabichighqaf",
  description="ARABIC SMALL HIGH QAF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8D7,
 },
 [0x8D8]={
  category="mn",
  combining=0xE6,
  contextname="arabichighnoonkasra",
  description="ARABIC SMALL HIGH NOON WITH KASRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8D8,
 },
 [0x8D9]={
  category="mn",
  combining=0xE6,
  contextname="arabiclownoonkasra",
  description="ARABIC SMALL LOW NOON WITH KASRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8D9,
 },
 [0x8DA]={
  category="mn",
  combining=0xE6,
  contextname="arabichighthalatha",
  description="ARABIC SMALL HIGH WORD ATH-THALATHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8DA,
 },
 [0x8DB]={
  category="mn",
  combining=0xE6,
  contextname="arabichighsajda",
  description="ARABIC SMALL HIGH WORD AS-SAJDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8DB,
 },
 [0x8DC]={
  category="mn",
  combining=0xE6,
  contextname="arabichighnisf",
  description="ARABIC SMALL HIGH WORD AN-NISF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8DC,
 },
 [0x8DD]={
  category="mn",
  combining=0xE6,
  contextname="arabichighsakta",
  description="ARABIC SMALL HIGH WORD SAKTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8DD,
 },
 [0x8DE]={
  category="mn",
  combining=0xE6,
  contextname="arabichighqif",
  description="ARABIC SMALL HIGH WORD QIF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8DE,
 },
 [0x8DF]={
  category="mn",
  combining=0xE6,
  contextname="arabichighwaqf",
  description="ARABIC SMALL HIGH WORD WAQFA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8DF,
 },
 [0x8E0]={
  category="mn",
  combining=0xE6,
  contextname="arabichighfootnotemarker",
  description="ARABIC SMALL HIGH FOOTNOTE MARKER",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8E0,
 },
 [0x8E1]={
  category="mn",
  combining=0xE6,
  contextname="arabichighsmallsafha",
  description="ARABIC SMALL HIGH SIGN SAFHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8E1,
 },
 [0x8E2]={
  arabic="u",
  category="cf",
  contextname="arabicdisputedendofayah",
  description="ARABIC DISPUTED END OF AYAH",
  direction="an",
  linebreak="al",
  unicodeslot=0x8E2,
 },
 [0x8E3]={
  category="mn",
  combining=0xDC,
  description="ARABIC TURNED DAMMA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8E3,
 },
 [0x8E4]={
  category="mn",
  combining=0xE6,
  description="ARABIC CURLY FATHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8E4,
 },
 [0x8E5]={
  category="mn",
  combining=0xE6,
  description="ARABIC CURLY DAMMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8E5,
 },
 [0x8E6]={
  category="mn",
  combining=0xDC,
  description="ARABIC CURLY KASRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8E6,
 },
 [0x8E7]={
  category="mn",
  combining=0xE6,
  description="ARABIC CURLY FATHATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8E7,
 },
 [0x8E8]={
  category="mn",
  combining=0xE6,
  description="ARABIC CURLY DAMMATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8E8,
 },
 [0x8E9]={
  category="mn",
  combining=0xDC,
  description="ARABIC CURLY KASRATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8E9,
 },
 [0x8EA]={
  category="mn",
  combining=0xE6,
  description="ARABIC TONE ONE DOT ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8EA,
 },
 [0x8EB]={
  category="mn",
  combining=0xE6,
  description="ARABIC TONE TWO DOTS ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8EB,
 },
 [0x8EC]={
  category="mn",
  combining=0xE6,
  description="ARABIC TONE LOOP ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8EC,
 },
 [0x8ED]={
  category="mn",
  combining=0xDC,
  description="ARABIC TONE ONE DOT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8ED,
 },
 [0x8EE]={
  category="mn",
  combining=0xDC,
  description="ARABIC TONE TWO DOTS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8EE,
 },
 [0x8EF]={
  category="mn",
  combining=0xDC,
  description="ARABIC TONE LOOP BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8EF,
 },
 [0x8F0]={
  category="mn",
  combining=0x1B,
  description="ARABIC OPEN FATHATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F0,
 },
 [0x8F1]={
  category="mn",
  combining=0x1C,
  description="ARABIC OPEN DAMMATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F1,
 },
 [0x8F2]={
  category="mn",
  combining=0x1D,
  description="ARABIC OPEN KASRATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F2,
 },
 [0x8F3]={
  category="mn",
  combining=0xE6,
  description="ARABIC SMALL HIGH WAW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F3,
 },
 [0x8F4]={
  category="mn",
  combining=0xE6,
  description="ARABIC FATHA WITH RING",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F4,
 },
 [0x8F5]={
  category="mn",
  combining=0xE6,
  description="ARABIC FATHA WITH DOT ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F5,
 },
 [0x8F6]={
  category="mn",
  combining=0xDC,
  description="ARABIC KASRA WITH DOT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F6,
 },
 [0x8F7]={
  category="mn",
  combining=0xE6,
  description="ARABIC LEFT ARROWHEAD ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F7,
 },
 [0x8F8]={
  category="mn",
  combining=0xE6,
  description="ARABIC RIGHT ARROWHEAD ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F8,
 },
 [0x8F9]={
  category="mn",
  combining=0xDC,
  description="ARABIC LEFT ARROWHEAD BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8F9,
 },
 [0x8FA]={
  category="mn",
  combining=0xDC,
  description="ARABIC RIGHT ARROWHEAD BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8FA,
 },
 [0x8FB]={
  category="mn",
  combining=0xE6,
  description="ARABIC DOUBLE RIGHT ARROWHEAD ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8FB,
 },
 [0x8FC]={
  category="mn",
  combining=0xE6,
  description="ARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8FC,
 },
 [0x8FD]={
  category="mn",
  combining=0xE6,
  description="ARABIC RIGHT ARROWHEAD ABOVE WITH DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8FD,
 },
 [0x8FE]={
  category="mn",
  combining=0xE6,
  description="ARABIC DAMMA WITH DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8FE,
 },
 [0x8FF]={
  category="mn",
  combining=0xE6,
  description="ARABIC MARK SIDEWAYS NOON GHUNNA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x8FF,
 },
 [0x900]={
  category="mn",
  description="DEVANAGARI SIGN INVERTED CANDRABINDU",
  direction="nsm",
  indic="m",
  indicmark="t",
  linebreak="cm",
  unicodeslot=0x900,
 },
 [0x901]={
  adobename="candrabindudeva",
  category="mn",
  description="DEVANAGARI SIGN CANDRABINDU",
  direction="nsm",
  indic="m",
  indicmark="t",
  linebreak="cm",
  synonyms={ "devanagari anunasika" },
  unicodeslot=0x901,
 },
 [0x902]={
  adobename="anusvaradeva",
  category="mn",
  description="DEVANAGARI SIGN ANUSVARA",
  direction="nsm",
  indic="m",
  indicmark="t",
  linebreak="cm",
  synonyms={ "devanagari bindu" },
  unicodeslot=0x902,
 },
 [0x903]={
  adobename="visargadeva",
  category="mc",
  description="DEVANAGARI SIGN VISARGA",
  direction="l",
  indic="m",
  indicmark="r",
  linebreak="cm",
  unicodeslot=0x903,
 },
 [0x904]={
  category="lo",
  description="DEVANAGARI LETTER SHORT A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x904,
 },
 [0x905]={
  adobename="adeva",
  category="lo",
  description="DEVANAGARI LETTER A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x905,
 },
 [0x906]={
  adobename="aadeva",
  category="lo",
  description="DEVANAGARI LETTER AA",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x906,
 },
 [0x907]={
  adobename="ideva",
  category="lo",
  description="DEVANAGARI LETTER I",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x907,
 },
 [0x908]={
  adobename="iideva",
  category="lo",
  description="DEVANAGARI LETTER II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x908,
 },
 [0x909]={
  adobename="udeva",
  category="lo",
  description="DEVANAGARI LETTER U",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x909,
 },
 [0x90A]={
  adobename="uudeva",
  category="lo",
  description="DEVANAGARI LETTER UU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x90A,
 },
 [0x90B]={
  adobename="rvocalicdeva",
  category="lo",
  description="DEVANAGARI LETTER VOCALIC R",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x90B,
 },
 [0x90C]={
  adobename="lvocalicdeva",
  category="lo",
  description="DEVANAGARI LETTER VOCALIC L",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x90C,
 },
 [0x90D]={
  adobename="ecandradeva",
  category="lo",
  description="DEVANAGARI LETTER CANDRA E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x90D,
 },
 [0x90E]={
  adobename="eshortdeva",
  category="lo",
  description="DEVANAGARI LETTER SHORT E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x90E,
 },
 [0x90F]={
  adobename="edeva",
  category="lo",
  description="DEVANAGARI LETTER E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x90F,
 },
 [0x910]={
  adobename="aideva",
  category="lo",
  description="DEVANAGARI LETTER AI",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x910,
 },
 [0x911]={
  adobename="ocandradeva",
  category="lo",
  description="DEVANAGARI LETTER CANDRA O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x911,
 },
 [0x912]={
  adobename="oshortdeva",
  category="lo",
  description="DEVANAGARI LETTER SHORT O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x912,
 },
 [0x913]={
  adobename="odeva",
  category="lo",
  description="DEVANAGARI LETTER O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x913,
 },
 [0x914]={
  adobename="audeva",
  category="lo",
  description="DEVANAGARI LETTER AU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x914,
 },
 [0x915]={
  adobename="kadeva",
  category="lo",
  description="DEVANAGARI LETTER KA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x915,
 },
 [0x916]={
  adobename="khadeva",
  category="lo",
  description="DEVANAGARI LETTER KHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x916,
 },
 [0x917]={
  adobename="gadeva",
  category="lo",
  description="DEVANAGARI LETTER GA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x917,
 },
 [0x918]={
  adobename="ghadeva",
  category="lo",
  description="DEVANAGARI LETTER GHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x918,
 },
 [0x919]={
  adobename="ngadeva",
  category="lo",
  description="DEVANAGARI LETTER NGA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x919,
 },
 [0x91A]={
  adobename="cadeva",
  category="lo",
  description="DEVANAGARI LETTER CA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x91A,
 },
 [0x91B]={
  adobename="chadeva",
  category="lo",
  description="DEVANAGARI LETTER CHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x91B,
 },
 [0x91C]={
  adobename="jadeva",
  category="lo",
  description="DEVANAGARI LETTER JA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x91C,
 },
 [0x91D]={
  adobename="jhadeva",
  category="lo",
  description="DEVANAGARI LETTER JHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x91D,
 },
 [0x91E]={
  adobename="nyadeva",
  category="lo",
  description="DEVANAGARI LETTER NYA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x91E,
 },
 [0x91F]={
  adobename="ttadeva",
  category="lo",
  description="DEVANAGARI LETTER TTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x91F,
 },
 [0x920]={
  adobename="tthadeva",
  category="lo",
  description="DEVANAGARI LETTER TTHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x920,
 },
 [0x921]={
  adobename="ddadeva",
  category="lo",
  description="DEVANAGARI LETTER DDA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x921,
 },
 [0x922]={
  adobename="ddhadeva",
  category="lo",
  description="DEVANAGARI LETTER DDHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x922,
 },
 [0x923]={
  adobename="nnadeva",
  category="lo",
  description="DEVANAGARI LETTER NNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x923,
 },
 [0x924]={
  adobename="tadeva",
  category="lo",
  description="DEVANAGARI LETTER TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x924,
 },
 [0x925]={
  adobename="thadeva",
  category="lo",
  description="DEVANAGARI LETTER THA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x925,
 },
 [0x926]={
  adobename="dadeva",
  category="lo",
  description="DEVANAGARI LETTER DA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x926,
 },
 [0x927]={
  adobename="dhadeva",
  category="lo",
  description="DEVANAGARI LETTER DHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x927,
 },
 [0x928]={
  adobename="nadeva",
  category="lo",
  description="DEVANAGARI LETTER NA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x928,
 },
 [0x929]={
  adobename="nnnadeva",
  category="lo",
  description="DEVANAGARI LETTER NNNA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x928, 0x93C },
  unicodeslot=0x929,
 },
 [0x92A]={
  adobename="padeva",
  category="lo",
  description="DEVANAGARI LETTER PA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x92A,
 },
 [0x92B]={
  adobename="phadeva",
  category="lo",
  description="DEVANAGARI LETTER PHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x92B,
 },
 [0x92C]={
  adobename="badeva",
  category="lo",
  description="DEVANAGARI LETTER BA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x92C,
 },
 [0x92D]={
  adobename="bhadeva",
  category="lo",
  description="DEVANAGARI LETTER BHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x92D,
 },
 [0x92E]={
  adobename="madeva",
  category="lo",
  description="DEVANAGARI LETTER MA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x92E,
 },
 [0x92F]={
  adobename="yadeva",
  category="lo",
  description="DEVANAGARI LETTER YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x92F,
 },
 [0x930]={
  adobename="radeva",
  category="lo",
  description="DEVANAGARI LETTER RA",
  direction="l",
  indic="c",
  indicclass="ra",
  indicorder="bp",
  linebreak="al",
  unicodeslot=0x930,
 },
 [0x931]={
  adobename="rradeva",
  category="lo",
  description="DEVANAGARI LETTER RRA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x930, 0x93C },
  unicodeslot=0x931,
 },
 [0x932]={
  adobename="ladeva",
  category="lo",
  description="DEVANAGARI LETTER LA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x932,
 },
 [0x933]={
  adobename="lladeva",
  category="lo",
  description="DEVANAGARI LETTER LLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x933,
 },
 [0x934]={
  adobename="llladeva",
  category="lo",
  description="DEVANAGARI LETTER LLLA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x933, 0x93C },
  unicodeslot=0x934,
 },
 [0x935]={
  adobename="vadeva",
  category="lo",
  description="DEVANAGARI LETTER VA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x935,
 },
 [0x936]={
  adobename="shadeva",
  category="lo",
  description="DEVANAGARI LETTER SHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x936,
 },
 [0x937]={
  adobename="ssadeva",
  category="lo",
  description="DEVANAGARI LETTER SSA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x937,
 },
 [0x938]={
  adobename="sadeva",
  category="lo",
  description="DEVANAGARI LETTER SA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x938,
 },
 [0x939]={
  adobename="hadeva",
  category="lo",
  description="DEVANAGARI LETTER HA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x939,
 },
 [0x93A]={
  category="mn",
  description="DEVANAGARI VOWEL SIGN OE",
  direction="nsm",
  indic="d",
  indicmark="t",
  linebreak="cm",
  unicodeslot=0x93A,
 },
 [0x93B]={
  category="mc",
  description="DEVANAGARI VOWEL SIGN OOE",
  direction="l",
  indic="d",
  indicmark="r",
  linebreak="cm",
  unicodeslot=0x93B,
 },
 [0x93C]={
  adobename="nuktadeva",
  category="mn",
  combining=0x7,
  description="DEVANAGARI SIGN NUKTA",
  direction="nsm",
  indic="o",
  indicmark="b",
  indicclass="nukta",
  linebreak="cm",
  unicodeslot=0x93C,
 },
 [0x93D]={
  adobename="avagrahadeva",
  category="lo",
  description="DEVANAGARI SIGN AVAGRAHA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x93D,
 },
 [0x93E]={
  adobename="aavowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN AA",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x93E,
 },
 [0x93F]={
  adobename="ivowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN I",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bh",
  linebreak="cm",
  unicodeslot=0x93F,
 },
 [0x940]={
  adobename="iivowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN II",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x940,
 },
 [0x941]={
  adobename="uvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN U",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x941,
 },
 [0x942]={
  adobename="uuvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN UU",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x942,
 },
 [0x943]={
  adobename="rvocalicvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN VOCALIC R",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x943,
 },
 [0x944]={
  adobename="rrvocalicvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN VOCALIC RR",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x944,
 },
 [0x945]={
  adobename="ecandravowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN CANDRA E",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x945,
 },
 [0x946]={
  adobename="eshortvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN SHORT E",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x946,
 },
 [0x947]={
  adobename="evowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN E",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x947,
 },
 [0x948]={
  adobename="aivowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN AI",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x948,
 },
 [0x949]={
  adobename="ocandravowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN CANDRA O",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x949,
 },
 [0x94A]={
  adobename="oshortvowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN SHORT O",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x94A,
 },
 [0x94B]={
  adobename="ovowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN O",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x94B,
 },
 [0x94C]={
  adobename="auvowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN AU",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x94C,
 },
 [0x94D]={
  adobename="viramadeva",
  category="mn",
  combining=0x9,
  description="DEVANAGARI SIGN VIRAMA",
  direction="nsm",
  indic="o",
  indicclass="halant",
  indicmark="b",
  linebreak="cm",
  synonyms={ "halant" },
  unicodeslot=0x94D,
 },
 [0x94E]={
  category="mc",
  description="DEVANAGARI VOWEL SIGN PRISHTHAMATRA E",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bh",
  linebreak="cm",
  unicodeslot=0x94E,
 },
 [0x94F]={
  category="mc",
  description="DEVANAGARI VOWEL SIGN AW",
  direction="l",
  indic="d",
  indicmark="r",
  linebreak="cm",
  unicodeslot=0x94F,
 },
 [0x950]={
  adobename="omdeva",
  category="lo",
  description="DEVANAGARI OM",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x950,
 },
 [0x951]={
  adobename="udattadeva",
  category="mn",
  combining=0xE6,
  description="DEVANAGARI STRESS SIGN UDATTA",
  direction="nsm",
  indic="s",
  indicmark="t",
  linebreak="cm",
  unicodeslot=0x951,
 },
 [0x952]={
  adobename="anudattadeva",
  category="mn",
  combining=0xDC,
  description="DEVANAGARI STRESS SIGN ANUDATTA",
  direction="nsm",
  indic="s",
  indicmark="b",
  indicclass="anudatta",
  linebreak="cm",
  unicodeslot=0x952,
 },
 [0x953]={
  adobename="gravedeva",
  category="mn",
  combining=0xE6,
  description="DEVANAGARI GRAVE ACCENT",
  direction="nsm",
  indic="s",
  indicmark="t",
  linebreak="cm",
  unicodeslot=0x953,
 },
 [0x954]={
  adobename="acutedeva",
  category="mn",
  combining=0xE6,
  description="DEVANAGARI ACUTE ACCENT",
  direction="nsm",
  indic="s",
  indicmark="t",
  linebreak="cm",
  unicodeslot=0x954,
 },
 [0x955]={
  category="mn",
  description="DEVANAGARI VOWEL SIGN CANDRA LONG E",
  direction="nsm",
  indic="d",
  indicmark="t",
  linebreak="cm",
  unicodeslot=0x955,
 },
 [0x956]={
  category="mn",
  description="DEVANAGARI VOWEL SIGN UE",
  direction="nsm",
  indic="d",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0x956,
 },
 [0x957]={
  category="mn",
  description="DEVANAGARI VOWEL SIGN UUE",
  direction="nsm",
  indic="d",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0x957,
 },
 [0x958]={
  adobename="qadeva",
  category="lo",
  description="DEVANAGARI LETTER QA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x915, 0x93C },
  unicodeslot=0x958,
 },
 [0x959]={
  adobename="khhadeva",
  category="lo",
  description="DEVANAGARI LETTER KHHA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x916, 0x93C },
  unicodeslot=0x959,
 },
 [0x95A]={
  adobename="ghhadeva",
  category="lo",
  description="DEVANAGARI LETTER GHHA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x917, 0x93C },
  unicodeslot=0x95A,
 },
 [0x95B]={
  adobename="zadeva",
  category="lo",
  description="DEVANAGARI LETTER ZA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x91C, 0x93C },
  unicodeslot=0x95B,
 },
 [0x95C]={
  adobename="dddhadeva",
  category="lo",
  description="DEVANAGARI LETTER DDDHA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x921, 0x93C },
  unicodeslot=0x95C,
 },
 [0x95D]={
  adobename="rhadeva",
  category="lo",
  description="DEVANAGARI LETTER RHA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x922, 0x93C },
  unicodeslot=0x95D,
 },
 [0x95E]={
  adobename="fadeva",
  category="lo",
  description="DEVANAGARI LETTER FA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x92B, 0x93C },
  unicodeslot=0x95E,
 },
 [0x95F]={
  adobename="yyadeva",
  category="lo",
  description="DEVANAGARI LETTER YYA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x92F, 0x93C },
  unicodeslot=0x95F,
 },
 [0x960]={
  adobename="rrvocalicdeva",
  category="lo",
  description="DEVANAGARI LETTER VOCALIC RR",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x960,
 },
 [0x961]={
  adobename="llvocalicdeva",
  category="lo",
  description="DEVANAGARI LETTER VOCALIC LL",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x961,
 },
 [0x962]={
  adobename="lvocalicvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN VOCALIC L",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x962,
 },
 [0x963]={
  adobename="llvocalicvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN VOCALIC LL",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x963,
 },
 [0x964]={
  adobename="danda",
  category="po",
  description="DEVANAGARI DANDA",
  direction="l",
  indic="o",
  linebreak="ba",
  synonyms={ "devanagari phrase separator", "devanagari purna viram" },
  unicodeslot=0x964,
 },
 [0x965]={
  adobename="dbldanda",
  category="po",
  description="DEVANAGARI DOUBLE DANDA",
  direction="l",
  indic="o",
  linebreak="ba",
  synonyms={ "devanagari deergh viram" },
  unicodeslot=0x965,
 },
 [0x966]={
  adobename="zerodeva",
  category="nd",
  description="DEVANAGARI DIGIT ZERO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x966,
 },
 [0x967]={
  adobename="onedeva",
  category="nd",
  description="DEVANAGARI DIGIT ONE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x967,
 },
 [0x968]={
  adobename="twodeva",
  category="nd",
  description="DEVANAGARI DIGIT TWO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x968,
 },
 [0x969]={
  adobename="threedeva",
  category="nd",
  description="DEVANAGARI DIGIT THREE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x969,
 },
 [0x96A]={
  adobename="fourdeva",
  category="nd",
  description="DEVANAGARI DIGIT FOUR",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x96A,
 },
 [0x96B]={
  adobename="fivedeva",
  category="nd",
  description="DEVANAGARI DIGIT FIVE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x96B,
 },
 [0x96C]={
  adobename="sixdeva",
  category="nd",
  description="DEVANAGARI DIGIT SIX",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x96C,
 },
 [0x96D]={
  adobename="sevendeva",
  category="nd",
  description="DEVANAGARI DIGIT SEVEN",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x96D,
 },
 [0x96E]={
  adobename="eightdeva",
  category="nd",
  description="DEVANAGARI DIGIT EIGHT",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x96E,
 },
 [0x96F]={
  adobename="ninedeva",
  category="nd",
  description="DEVANAGARI DIGIT NINE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x96F,
 },
 [0x970]={
  adobename="abbreviationsigndeva",
  category="po",
  description="DEVANAGARI ABBREVIATION SIGN",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x970,
 },
 [0x971]={
  category="lm",
  description="DEVANAGARI SIGN HIGH SPACING DOT",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x971,
 },
 [0x972]={
  category="lo",
  description="DEVANAGARI LETTER CANDRA A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x972,
 },
 [0x973]={
  category="lo",
  description="DEVANAGARI LETTER OE",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x973,
 },
 [0x974]={
  category="lo",
  description="DEVANAGARI LETTER OOE",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x974,
 },
 [0x975]={
  category="lo",
  description="DEVANAGARI LETTER AW",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x975,
 },
 [0x976]={
  category="lo",
  description="DEVANAGARI LETTER UE",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x976,
 },
 [0x977]={
  category="lo",
  description="DEVANAGARI LETTER UUE",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x977,
 },
 [0x978]={
  category="lo",
  description="DEVANAGARI LETTER MARWARI DDA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x978,
 },
 [0x979]={
  category="lo",
  description="DEVANAGARI LETTER ZHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x979,
 },
 [0x97A]={
  category="lo",
  description="DEVANAGARI LETTER HEAVY YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x97A,
 },
 [0x97B]={
  category="lo",
  description="DEVANAGARI LETTER GGA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x97B,
 },
 [0x97C]={
  category="lo",
  description="DEVANAGARI LETTER JJA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x97C,
 },
 [0x97D]={
  category="lo",
  description="DEVANAGARI LETTER GLOTTAL STOP",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x97D,
 },
 [0x97E]={
  category="lo",
  description="DEVANAGARI LETTER DDDA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x97E,
 },
 [0x97F]={
  category="lo",
  description="DEVANAGARI LETTER BBA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x97F,
 },
 [0x980]={
  category="lo",
  description="BENGALI ANJI",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x980,
 },
 [0x981]={
  adobename="candrabindubengali",
  category="mn",
  description="BENGALI SIGN CANDRABINDU",
  direction="nsm",
  indic="o",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0x981,
 },
 [0x982]={
  adobename="anusvarabengali",
  category="mc",
  description="BENGALI SIGN ANUSVARA",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0x982,
 },
 [0x983]={
  adobename="visargabengali",
  category="mc",
  description="BENGALI SIGN VISARGA",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0x983,
 },
 [0x985]={
  adobename="abengali",
  category="lo",
  description="BENGALI LETTER A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x985,
 },
 [0x986]={
  adobename="aabengali",
  category="lo",
  description="BENGALI LETTER AA",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x986,
 },
 [0x987]={
  adobename="ibengali",
  category="lo",
  description="BENGALI LETTER I",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x987,
 },
 [0x988]={
  adobename="iibengali",
  category="lo",
  description="BENGALI LETTER II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x988,
 },
 [0x989]={
  adobename="ubengali",
  category="lo",
  description="BENGALI LETTER U",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x989,
 },
 [0x98A]={
  adobename="uubengali",
  category="lo",
  description="BENGALI LETTER UU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x98A,
 },
 [0x98B]={
  adobename="rvocalicbengali",
  category="lo",
  description="BENGALI LETTER VOCALIC R",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x98B,
 },
 [0x98C]={
  adobename="lvocalicbengali",
  category="lo",
  description="BENGALI LETTER VOCALIC L",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x98C,
 },
 [0x98F]={
  adobename="ebengali",
  category="lo",
  description="BENGALI LETTER E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x98F,
 },
 [0x990]={
  adobename="aibengali",
  category="lo",
  description="BENGALI LETTER AI",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x990,
 },
 [0x993]={
  adobename="obengali",
  category="lo",
  description="BENGALI LETTER O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x993,
 },
 [0x994]={
  adobename="aubengali",
  category="lo",
  description="BENGALI LETTER AU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x994,
 },
 [0x995]={
  adobename="kabengali",
  category="lo",
  description="BENGALI LETTER KA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x995,
 },
 [0x996]={
  adobename="khabengali",
  category="lo",
  description="BENGALI LETTER KHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x996,
 },
 [0x997]={
  adobename="gabengali",
  category="lo",
  description="BENGALI LETTER GA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x997,
 },
 [0x998]={
  adobename="ghabengali",
  category="lo",
  description="BENGALI LETTER GHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x998,
 },
 [0x999]={
  adobename="ngabengali",
  category="lo",
  description="BENGALI LETTER NGA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x999,
 },
 [0x99A]={
  adobename="cabengali",
  category="lo",
  description="BENGALI LETTER CA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x99A,
 },
 [0x99B]={
  adobename="chabengali",
  category="lo",
  description="BENGALI LETTER CHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x99B,
 },
 [0x99C]={
  adobename="jabengali",
  category="lo",
  description="BENGALI LETTER JA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x99C,
 },
 [0x99D]={
  adobename="jhabengali",
  category="lo",
  description="BENGALI LETTER JHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x99D,
 },
 [0x99E]={
  adobename="nyabengali",
  category="lo",
  description="BENGALI LETTER NYA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x99E,
 },
 [0x99F]={
  adobename="ttabengali",
  category="lo",
  description="BENGALI LETTER TTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x99F,
 },
 [0x9A0]={
  adobename="tthabengali",
  category="lo",
  description="BENGALI LETTER TTHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9A0,
 },
 [0x9A1]={
  adobename="ddabengali",
  category="lo",
  description="BENGALI LETTER DDA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9A1,
 },
 [0x9A2]={
  adobename="ddhabengali",
  category="lo",
  description="BENGALI LETTER DDHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9A2,
 },
 [0x9A3]={
  adobename="nnabengali",
  category="lo",
  description="BENGALI LETTER NNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9A3,
 },
 [0x9A4]={
  adobename="tabengali",
  category="lo",
  description="BENGALI LETTER TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9A4,
 },
 [0x9A5]={
  adobename="thabengali",
  category="lo",
  description="BENGALI LETTER THA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9A5,
 },
 [0x9A6]={
  adobename="dabengali",
  category="lo",
  description="BENGALI LETTER DA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9A6,
 },
 [0x9A7]={
  adobename="dhabengali",
  category="lo",
  description="BENGALI LETTER DHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9A7,
 },
 [0x9A8]={
  adobename="nabengali",
  category="lo",
  description="BENGALI LETTER NA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9A8,
 },
 [0x9AA]={
  adobename="pabengali",
  category="lo",
  description="BENGALI LETTER PA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9AA,
 },
 [0x9AB]={
  adobename="phabengali",
  category="lo",
  description="BENGALI LETTER PHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9AB,
 },
 [0x9AC]={
  adobename="babengali",
  category="lo",
  description="BENGALI LETTER BA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9AC,
 },
 [0x9AD]={
  adobename="bhabengali",
  category="lo",
  description="BENGALI LETTER BHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9AD,
 },
 [0x9AE]={
  adobename="mabengali",
  category="lo",
  description="BENGALI LETTER MA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9AE,
 },
 [0x9AF]={
  adobename="yabengali",
  category="lo",
  description="BENGALI LETTER YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9AF,
 },
 [0x9B0]={
  adobename="rabengali",
  category="lo",
  description="BENGALI LETTER RA",
  direction="l",
  indic="c",
  indicclass="ra",
  indicorder="as",
  linebreak="al",
  unicodeslot=0x9B0,
 },
 [0x9B2]={
  adobename="labengali",
  category="lo",
  description="BENGALI LETTER LA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9B2,
 },
 [0x9B6]={
  adobename="shabengali",
  category="lo",
  description="BENGALI LETTER SHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9B6,
 },
 [0x9B7]={
  adobename="ssabengali",
  category="lo",
  description="BENGALI LETTER SSA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9B7,
 },
 [0x9B8]={
  adobename="sabengali",
  category="lo",
  description="BENGALI LETTER SA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9B8,
 },
 [0x9B9]={
  adobename="habengali",
  category="lo",
  description="BENGALI LETTER HA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9B9,
 },
 [0x9BC]={
  adobename="nuktabengali",
  category="mn",
  combining=0x7,
  description="BENGALI SIGN NUKTA",
  direction="nsm",
  indic="o",
  indicmark="b",
  indicclass="nukta",
  linebreak="cm",
  unicodeslot=0x9BC,
 },
 [0x9BD]={
  category="lo",
  description="BENGALI SIGN AVAGRAHA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x9BD,
 },
 [0x9BE]={
  adobename="aavowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN AA",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0x9BE,
 },
 [0x9BF]={
  adobename="ivowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN I",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bh",
  linebreak="cm",
  unicodeslot=0x9BF,
 },
 [0x9C0]={
  adobename="iivowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN II",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0x9C0,
 },
 [0x9C1]={
  adobename="uvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN U",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x9C1,
 },
 [0x9C2]={
  adobename="uuvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN UU",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x9C2,
 },
 [0x9C3]={
  adobename="rvocalicvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN VOCALIC R",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x9C3,
 },
 [0x9C4]={
  adobename="rrvocalicvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN VOCALIC RR",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x9C4,
 },
 [0x9C7]={
  adobename="evowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN E",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="bh",
  linebreak="cm",
  unicodeslot=0x9C7,
 },
 [0x9C8]={
  adobename="aivowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN AI",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="bh",
  linebreak="cm",
  unicodeslot=0x9C8,
 },
 [0x9CB]={
  adobename="ovowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN O",
  direction="l",
  indic="s",
  linebreak="cm",
  specials={ "char", 0x9C7, 0x9BE },
  unicodeslot=0x9CB,
 },
 [0x9CC]={
  adobename="auvowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN AU",
  direction="l",
  indic="s",
  linebreak="cm",
  specials={ "char", 0x9C7, 0x9D7 },
  unicodeslot=0x9CC,
 },
 [0x9CD]={
  adobename="viramabengali",
  category="mn",
  combining=0x9,
  description="BENGALI SIGN VIRAMA",
  direction="nsm",
  indic="o",
  indicclass="halant",
  indicmark="b",
  linebreak="cm",
  synonyms={ "bengali hasant" },
  unicodeslot=0x9CD,
 },
 [0x9CE]={
  category="lo",
  description="BENGALI LETTER KHANDA TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0x9CE,
 },
 [0x9D7]={
  adobename="aulengthmarkbengali",
  category="mc",
  description="BENGALI AU LENGTH MARK",
  direction="l",
  indic="o",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0x9D7,
 },
 [0x9DC]={
  adobename="rrabengali",
  category="lo",
  description="BENGALI LETTER RRA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x9A1, 0x9BC },
  unicodeslot=0x9DC,
 },
 [0x9DD]={
  adobename="rhabengali",
  category="lo",
  description="BENGALI LETTER RHA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x9A2, 0x9BC },
  unicodeslot=0x9DD,
 },
 [0x9DF]={
  adobename="yyabengali",
  category="lo",
  description="BENGALI LETTER YYA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0x9AF, 0x9BC },
  unicodeslot=0x9DF,
 },
 [0x9E0]={
  adobename="rrvocalicbengali",
  category="lo",
  description="BENGALI LETTER VOCALIC RR",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x9E0,
 },
 [0x9E1]={
  adobename="llvocalicbengali",
  category="lo",
  description="BENGALI LETTER VOCALIC LL",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0x9E1,
 },
 [0x9E2]={
  adobename="lvocalicvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN VOCALIC L",
  direction="nsm",
  indic="i",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x9E2,
 },
 [0x9E3]={
  adobename="llvocalicvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN VOCALIC LL",
  direction="nsm",
  indic="i",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0x9E3,
 },
 [0x9E6]={
  adobename="zerobengali",
  category="nd",
  description="BENGALI DIGIT ZERO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9E6,
 },
 [0x9E7]={
  adobename="onebengali",
  category="nd",
  description="BENGALI DIGIT ONE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9E7,
 },
 [0x9E8]={
  adobename="twobengali",
  category="nd",
  description="BENGALI DIGIT TWO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9E8,
 },
 [0x9E9]={
  adobename="threebengali",
  category="nd",
  description="BENGALI DIGIT THREE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9E9,
 },
 [0x9EA]={
  adobename="fourbengali",
  category="nd",
  description="BENGALI DIGIT FOUR",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9EA,
 },
 [0x9EB]={
  adobename="fivebengali",
  category="nd",
  description="BENGALI DIGIT FIVE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9EB,
 },
 [0x9EC]={
  adobename="sixbengali",
  category="nd",
  description="BENGALI DIGIT SIX",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9EC,
 },
 [0x9ED]={
  adobename="sevenbengali",
  category="nd",
  description="BENGALI DIGIT SEVEN",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9ED,
 },
 [0x9EE]={
  adobename="eightbengali",
  category="nd",
  description="BENGALI DIGIT EIGHT",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9EE,
 },
 [0x9EF]={
  adobename="ninebengali",
  category="nd",
  description="BENGALI DIGIT NINE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0x9EF,
 },
 [0x9F0]={
  adobename="ramiddlediagonalbengali",
  category="lo",
  description="BENGALI LETTER RA WITH MIDDLE DIAGONAL",
  direction="l",
  indic="o",
  indicorder="as",
  linebreak="al",
  shcode=0x9B0,
  unicodeslot=0x9F0,
 },
 [0x9F1]={
  adobename="ralowerdiagonalbengali",
  category="lo",
  description="BENGALI LETTER RA WITH LOWER DIAGONAL",
  direction="l",
  indic="o",
  linebreak="al",
  shcode=0x9B0,
  unicodeslot=0x9F1,
 },
 [0x9F2]={
  adobename="rupeemarkbengali",
  category="sc",
  description="BENGALI RUPEE MARK",
  direction="et",
  indic="o",
  linebreak="po",
  unicodeslot=0x9F2,
 },
 [0x9F3]={
  adobename="rupeesignbengali",
  category="sc",
  description="BENGALI RUPEE SIGN",
  direction="et",
  indic="o",
  linebreak="po",
  unicodeslot=0x9F3,
 },
 [0x9F4]={
  adobename="onenumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR ONE",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x9F4,
 },
 [0x9F5]={
  adobename="twonumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR TWO",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x9F5,
 },
 [0x9F6]={
  adobename="threenumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR THREE",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x9F6,
 },
 [0x9F7]={
  adobename="fournumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR FOUR",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x9F7,
 },
 [0x9F8]={
  adobename="denominatorminusonenumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x9F8,
 },
 [0x9F9]={
  adobename="sixteencurrencydenominatorbengali",
  category="no",
  description="BENGALI CURRENCY DENOMINATOR SIXTEEN",
  direction="l",
  indic="o",
  linebreak="po",
  unicodeslot=0x9F9,
 },
 [0x9FA]={
  adobename="issharbengali",
  category="so",
  description="BENGALI ISSHAR",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x9FA,
 },
 [0x9FB]={
  category="sc",
  description="BENGALI GANDA MARK",
  direction="et",
  indic="o",
  linebreak="pr",
  unicodeslot=0x9FB,
 },
 [0x9FC]={
  category="lo",
  description="BENGALI LETTER VEDIC ANUSVARA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x9FC,
 },
 [0x9FD]={
  category="po",
  description="BENGALI ABBREVIATION SIGN",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0x9FD,
 },
 [0xA01]={
  category="mn",
  description="GURMUKHI SIGN ADAK BINDI",
  direction="nsm",
  indic="o",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xA01,
 },
 [0xA02]={
  adobename="bindigurmukhi",
  category="mn",
  description="GURMUKHI SIGN BINDI",
  direction="nsm",
  indic="o",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xA02,
 },
 [0xA03]={
  category="mc",
  description="GURMUKHI SIGN VISARGA",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0xA03,
 },
 [0xA05]={
  adobename="agurmukhi",
  category="lo",
  description="GURMUKHI LETTER A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA05,
 },
 [0xA06]={
  adobename="aagurmukhi",
  category="lo",
  description="GURMUKHI LETTER AA",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA06,
 },
 [0xA07]={
  adobename="igurmukhi",
  category="lo",
  description="GURMUKHI LETTER I",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA07,
 },
 [0xA08]={
  adobename="iigurmukhi",
  category="lo",
  description="GURMUKHI LETTER II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA08,
 },
 [0xA09]={
  adobename="ugurmukhi",
  category="lo",
  description="GURMUKHI LETTER U",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA09,
 },
 [0xA0A]={
  adobename="uugurmukhi",
  category="lo",
  description="GURMUKHI LETTER UU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA0A,
 },
 [0xA0F]={
  adobename="eegurmukhi",
  category="lo",
  description="GURMUKHI LETTER EE",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA0F,
 },
 [0xA10]={
  adobename="aigurmukhi",
  category="lo",
  description="GURMUKHI LETTER AI",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA10,
 },
 [0xA13]={
  adobename="oogurmukhi",
  category="lo",
  description="GURMUKHI LETTER OO",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA13,
 },
 [0xA14]={
  adobename="augurmukhi",
  category="lo",
  description="GURMUKHI LETTER AU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA14,
 },
 [0xA15]={
  adobename="kagurmukhi",
  category="lo",
  description="GURMUKHI LETTER KA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA15,
 },
 [0xA16]={
  adobename="khagurmukhi",
  category="lo",
  description="GURMUKHI LETTER KHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA16,
 },
 [0xA17]={
  adobename="gagurmukhi",
  category="lo",
  description="GURMUKHI LETTER GA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA17,
 },
 [0xA18]={
  adobename="ghagurmukhi",
  category="lo",
  description="GURMUKHI LETTER GHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA18,
 },
 [0xA19]={
  adobename="ngagurmukhi",
  category="lo",
  description="GURMUKHI LETTER NGA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA19,
 },
 [0xA1A]={
  adobename="cagurmukhi",
  category="lo",
  description="GURMUKHI LETTER CA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA1A,
 },
 [0xA1B]={
  adobename="chagurmukhi",
  category="lo",
  description="GURMUKHI LETTER CHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA1B,
 },
 [0xA1C]={
  adobename="jagurmukhi",
  category="lo",
  description="GURMUKHI LETTER JA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA1C,
 },
 [0xA1D]={
  adobename="jhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER JHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA1D,
 },
 [0xA1E]={
  adobename="nyagurmukhi",
  category="lo",
  description="GURMUKHI LETTER NYA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA1E,
 },
 [0xA1F]={
  adobename="ttagurmukhi",
  category="lo",
  description="GURMUKHI LETTER TTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA1F,
 },
 [0xA20]={
  adobename="tthagurmukhi",
  category="lo",
  description="GURMUKHI LETTER TTHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA20,
 },
 [0xA21]={
  adobename="ddagurmukhi",
  category="lo",
  description="GURMUKHI LETTER DDA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA21,
 },
 [0xA22]={
  adobename="ddhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER DDHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA22,
 },
 [0xA23]={
  adobename="nnagurmukhi",
  category="lo",
  description="GURMUKHI LETTER NNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA23,
 },
 [0xA24]={
  adobename="tagurmukhi",
  category="lo",
  description="GURMUKHI LETTER TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA24,
 },
 [0xA25]={
  adobename="thagurmukhi",
  category="lo",
  description="GURMUKHI LETTER THA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA25,
 },
 [0xA26]={
  adobename="dagurmukhi",
  category="lo",
  description="GURMUKHI LETTER DA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA26,
 },
 [0xA27]={
  adobename="dhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER DHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA27,
 },
 [0xA28]={
  adobename="nagurmukhi",
  category="lo",
  description="GURMUKHI LETTER NA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA28,
 },
 [0xA2A]={
  adobename="pagurmukhi",
  category="lo",
  description="GURMUKHI LETTER PA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA2A,
 },
 [0xA2B]={
  adobename="phagurmukhi",
  category="lo",
  description="GURMUKHI LETTER PHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA2B,
 },
 [0xA2C]={
  adobename="bagurmukhi",
  category="lo",
  description="GURMUKHI LETTER BA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA2C,
 },
 [0xA2D]={
  adobename="bhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER BHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA2D,
 },
 [0xA2E]={
  adobename="magurmukhi",
  category="lo",
  description="GURMUKHI LETTER MA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA2E,
 },
 [0xA2F]={
  adobename="yagurmukhi",
  category="lo",
  description="GURMUKHI LETTER YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA2F,
 },
 [0xA30]={
  adobename="ragurmukhi",
  category="lo",
  description="GURMUKHI LETTER RA",
  direction="l",
  indic="c",
  indicclass="ra",
  indicorder="bs",
  linebreak="al",
  unicodeslot=0xA30,
 },
 [0xA32]={
  adobename="lagurmukhi",
  category="lo",
  description="GURMUKHI LETTER LA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA32,
 },
 [0xA33]={
  category="lo",
  description="GURMUKHI LETTER LLA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0xA32, 0xA3C },
  unicodeslot=0xA33,
 },
 [0xA35]={
  adobename="vagurmukhi",
  category="lo",
  description="GURMUKHI LETTER VA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA35,
 },
 [0xA36]={
  adobename="shagurmukhi",
  category="lo",
  description="GURMUKHI LETTER SHA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0xA38, 0xA3C },
  unicodeslot=0xA36,
 },
 [0xA38]={
  adobename="sagurmukhi",
  category="lo",
  description="GURMUKHI LETTER SA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA38,
 },
 [0xA39]={
  adobename="hagurmukhi",
  category="lo",
  description="GURMUKHI LETTER HA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA39,
 },
 [0xA3C]={
  adobename="nuktagurmukhi",
  category="mn",
  combining=0x7,
  description="GURMUKHI SIGN NUKTA",
  direction="nsm",
  indic="o",
  indicmark="b",
  indicclass="nukta",
  linebreak="cm",
  unicodeslot=0xA3C,
 },
 [0xA3E]={
  adobename="aamatragurmukhi",
  category="mc",
  description="GURMUKHI VOWEL SIGN AA",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xA3E,
 },
 [0xA3F]={
  adobename="imatragurmukhi",
  category="mc",
  description="GURMUKHI VOWEL SIGN I",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bh",
  linebreak="cm",
  unicodeslot=0xA3F,
 },
 [0xA40]={
  adobename="iimatragurmukhi",
  category="mc",
  description="GURMUKHI VOWEL SIGN II",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xA40,
 },
 [0xA41]={
  adobename="umatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN U",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xA41,
 },
 [0xA42]={
  adobename="uumatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN UU",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xA42,
 },
 [0xA47]={
  adobename="eematragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN EE",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xA47,
 },
 [0xA48]={
  adobename="aimatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN AI",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xA48,
 },
 [0xA4B]={
  adobename="oomatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN OO",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xA4B,
 },
 [0xA4C]={
  adobename="aumatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN AU",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xA4C,
 },
 [0xA4D]={
  adobename="halantgurmukhi",
  category="mn",
  combining=0x9,
  description="GURMUKHI SIGN VIRAMA",
  direction="nsm",
  indic="o",
  indicclass="halant",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xA4D,
 },
 [0xA51]={
  category="mn",
  description="GURMUKHI SIGN UDAAT",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xA51,
 },
 [0xA59]={
  adobename="khhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER KHHA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0xA16, 0xA3C },
  unicodeslot=0xA59,
 },
 [0xA5A]={
  adobename="ghhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER GHHA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0xA17, 0xA3C },
  unicodeslot=0xA5A,
 },
 [0xA5B]={
  adobename="zagurmukhi",
  category="lo",
  description="GURMUKHI LETTER ZA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0xA1C, 0xA3C },
  unicodeslot=0xA5B,
 },
 [0xA5C]={
  adobename="rragurmukhi",
  category="lo",
  description="GURMUKHI LETTER RRA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA5C,
 },
 [0xA5E]={
  adobename="fagurmukhi",
  category="lo",
  description="GURMUKHI LETTER FA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0xA2B, 0xA3C },
  unicodeslot=0xA5E,
 },
 [0xA66]={
  adobename="zerogurmukhi",
  category="nd",
  description="GURMUKHI DIGIT ZERO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA66,
 },
 [0xA67]={
  adobename="onegurmukhi",
  category="nd",
  description="GURMUKHI DIGIT ONE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA67,
 },
 [0xA68]={
  adobename="twogurmukhi",
  category="nd",
  description="GURMUKHI DIGIT TWO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA68,
 },
 [0xA69]={
  adobename="threegurmukhi",
  category="nd",
  description="GURMUKHI DIGIT THREE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA69,
 },
 [0xA6A]={
  adobename="fourgurmukhi",
  category="nd",
  description="GURMUKHI DIGIT FOUR",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA6A,
 },
 [0xA6B]={
  adobename="fivegurmukhi",
  category="nd",
  description="GURMUKHI DIGIT FIVE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA6B,
 },
 [0xA6C]={
  adobename="sixgurmukhi",
  category="nd",
  description="GURMUKHI DIGIT SIX",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA6C,
 },
 [0xA6D]={
  adobename="sevengurmukhi",
  category="nd",
  description="GURMUKHI DIGIT SEVEN",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA6D,
 },
 [0xA6E]={
  adobename="eightgurmukhi",
  category="nd",
  description="GURMUKHI DIGIT EIGHT",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA6E,
 },
 [0xA6F]={
  adobename="ninegurmukhi",
  category="nd",
  description="GURMUKHI DIGIT NINE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xA6F,
 },
 [0xA70]={
  adobename="tippigurmukhi",
  category="mn",
  description="GURMUKHI TIPPI",
  direction="nsm",
  indic="o",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xA70,
 },
 [0xA71]={
  adobename="addakgurmukhi",
  category="mn",
  description="GURMUKHI ADDAK",
  direction="nsm",
  indic="o",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xA71,
 },
 [0xA72]={
  adobename="irigurmukhi",
  category="lo",
  description="GURMUKHI IRI",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xA72,
 },
 [0xA73]={
  adobename="uragurmukhi",
  category="lo",
  description="GURMUKHI URA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xA73,
 },
 [0xA74]={
  adobename="ekonkargurmukhi",
  category="lo",
  description="GURMUKHI EK ONKAR",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xA74,
 },
 [0xA75]={
  category="mn",
  description="GURMUKHI SIGN YAKASH",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xA75,
 },
 [0xA81]={
  adobename="candrabindugujarati",
  category="mn",
  description="GUJARATI SIGN CANDRABINDU",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xA81,
 },
 [0xA82]={
  adobename="anusvaragujarati",
  category="mn",
  description="GUJARATI SIGN ANUSVARA",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xA82,
 },
 [0xA83]={
  adobename="visargagujarati",
  category="mc",
  description="GUJARATI SIGN VISARGA",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0xA83,
 },
 [0xA85]={
  adobename="agujarati",
  category="lo",
  description="GUJARATI LETTER A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA85,
 },
 [0xA86]={
  adobename="aagujarati",
  category="lo",
  description="GUJARATI LETTER AA",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA86,
 },
 [0xA87]={
  adobename="igujarati",
  category="lo",
  description="GUJARATI LETTER I",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA87,
 },
 [0xA88]={
  adobename="iigujarati",
  category="lo",
  description="GUJARATI LETTER II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA88,
 },
 [0xA89]={
  adobename="ugujarati",
  category="lo",
  description="GUJARATI LETTER U",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA89,
 },
 [0xA8A]={
  adobename="uugujarati",
  category="lo",
  description="GUJARATI LETTER UU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA8A,
 },
 [0xA8B]={
  adobename="rvocalicgujarati",
  category="lo",
  description="GUJARATI LETTER VOCALIC R",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA8B,
 },
 [0xA8C]={
  category="lo",
  description="GUJARATI LETTER VOCALIC L",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA8C,
 },
 [0xA8D]={
  adobename="ecandragujarati",
  category="lo",
  description="GUJARATI VOWEL CANDRA E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA8D,
 },
 [0xA8F]={
  adobename="egujarati",
  category="lo",
  description="GUJARATI LETTER E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA8F,
 },
 [0xA90]={
  adobename="aigujarati",
  category="lo",
  description="GUJARATI LETTER AI",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA90,
 },
 [0xA91]={
  adobename="ocandragujarati",
  category="lo",
  description="GUJARATI VOWEL CANDRA O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA91,
 },
 [0xA93]={
  adobename="ogujarati",
  category="lo",
  description="GUJARATI LETTER O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA93,
 },
 [0xA94]={
  adobename="augujarati",
  category="lo",
  description="GUJARATI LETTER AU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xA94,
 },
 [0xA95]={
  adobename="kagujarati",
  category="lo",
  description="GUJARATI LETTER KA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA95,
 },
 [0xA96]={
  adobename="khagujarati",
  category="lo",
  description="GUJARATI LETTER KHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA96,
 },
 [0xA97]={
  adobename="gagujarati",
  category="lo",
  description="GUJARATI LETTER GA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA97,
 },
 [0xA98]={
  adobename="ghagujarati",
  category="lo",
  description="GUJARATI LETTER GHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA98,
 },
 [0xA99]={
  adobename="ngagujarati",
  category="lo",
  description="GUJARATI LETTER NGA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA99,
 },
 [0xA9A]={
  adobename="cagujarati",
  category="lo",
  description="GUJARATI LETTER CA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA9A,
 },
 [0xA9B]={
  adobename="chagujarati",
  category="lo",
  description="GUJARATI LETTER CHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA9B,
 },
 [0xA9C]={
  adobename="jagujarati",
  category="lo",
  description="GUJARATI LETTER JA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA9C,
 },
 [0xA9D]={
  adobename="jhagujarati",
  category="lo",
  description="GUJARATI LETTER JHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA9D,
 },
 [0xA9E]={
  adobename="nyagujarati",
  category="lo",
  description="GUJARATI LETTER NYA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA9E,
 },
 [0xA9F]={
  adobename="ttagujarati",
  category="lo",
  description="GUJARATI LETTER TTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xA9F,
 },
 [0xAA0]={
  adobename="tthagujarati",
  category="lo",
  description="GUJARATI LETTER TTHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAA0,
 },
 [0xAA1]={
  adobename="ddagujarati",
  category="lo",
  description="GUJARATI LETTER DDA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAA1,
 },
 [0xAA2]={
  adobename="ddhagujarati",
  category="lo",
  description="GUJARATI LETTER DDHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAA2,
 },
 [0xAA3]={
  adobename="nnagujarati",
  category="lo",
  description="GUJARATI LETTER NNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAA3,
 },
 [0xAA4]={
  adobename="tagujarati",
  category="lo",
  description="GUJARATI LETTER TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAA4,
 },
 [0xAA5]={
  adobename="thagujarati",
  category="lo",
  description="GUJARATI LETTER THA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAA5,
 },
 [0xAA6]={
  adobename="dagujarati",
  category="lo",
  description="GUJARATI LETTER DA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAA6,
 },
 [0xAA7]={
  adobename="dhagujarati",
  category="lo",
  description="GUJARATI LETTER DHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAA7,
 },
 [0xAA8]={
  adobename="nagujarati",
  category="lo",
  description="GUJARATI LETTER NA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAA8,
 },
 [0xAAA]={
  adobename="pagujarati",
  category="lo",
  description="GUJARATI LETTER PA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAAA,
 },
 [0xAAB]={
  adobename="phagujarati",
  category="lo",
  description="GUJARATI LETTER PHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAAB,
 },
 [0xAAC]={
  adobename="bagujarati",
  category="lo",
  description="GUJARATI LETTER BA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAAC,
 },
 [0xAAD]={
  adobename="bhagujarati",
  category="lo",
  description="GUJARATI LETTER BHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAAD,
 },
 [0xAAE]={
  adobename="magujarati",
  category="lo",
  description="GUJARATI LETTER MA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAAE,
 },
 [0xAAF]={
  adobename="yagujarati",
  category="lo",
  description="GUJARATI LETTER YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAAF,
 },
 [0xAB0]={
  adobename="ragujarati",
  category="lo",
  description="GUJARATI LETTER RA",
  direction="l",
  indic="c",
  indicclass="ra",
  indicorder="bp",
  linebreak="al",
  unicodeslot=0xAB0,
 },
 [0xAB2]={
  adobename="lagujarati",
  category="lo",
  description="GUJARATI LETTER LA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAB2,
 },
 [0xAB3]={
  adobename="llagujarati",
  category="lo",
  description="GUJARATI LETTER LLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAB3,
 },
 [0xAB5]={
  adobename="vagujarati",
  category="lo",
  description="GUJARATI LETTER VA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAB5,
 },
 [0xAB6]={
  adobename="shagujarati",
  category="lo",
  description="GUJARATI LETTER SHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAB6,
 },
 [0xAB7]={
  adobename="ssagujarati",
  category="lo",
  description="GUJARATI LETTER SSA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAB7,
 },
 [0xAB8]={
  adobename="sagujarati",
  category="lo",
  description="GUJARATI LETTER SA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAB8,
 },
 [0xAB9]={
  adobename="hagujarati",
  category="lo",
  description="GUJARATI LETTER HA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xAB9,
 },
 [0xABC]={
  adobename="nuktagujarati",
  category="mn",
  combining=0x7,
  description="GUJARATI SIGN NUKTA",
  direction="nsm",
  indic="o",
  indicmark="b",
  indicclass="nukta",
  linebreak="cm",
  unicodeslot=0xABC,
 },
 [0xABD]={
  category="lo",
  description="GUJARATI SIGN AVAGRAHA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xABD,
 },
 [0xABE]={
  adobename="aavowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN AA",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xABE,
 },
 [0xABF]={
  adobename="ivowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN I",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bh",
  linebreak="cm",
  unicodeslot=0xABF,
 },
 [0xAC0]={
  adobename="iivowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN II",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xAC0,
 },
 [0xAC1]={
  adobename="uvowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN U",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xAC1,
 },
 [0xAC2]={
  adobename="uuvowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN UU",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xAC2,
 },
 [0xAC3]={
  adobename="rvocalicvowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN VOCALIC R",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xAC3,
 },
 [0xAC4]={
  adobename="rrvocalicvowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN VOCALIC RR",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xAC4,
 },
 [0xAC5]={
  adobename="ecandravowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN CANDRA E",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xAC5,
 },
 [0xAC7]={
  adobename="evowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN E",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xAC7,
 },
 [0xAC8]={
  adobename="aivowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN AI",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xAC8,
 },
 [0xAC9]={
  adobename="ocandravowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN CANDRA O",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xAC9,
 },
 [0xACB]={
  adobename="ovowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN O",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xACB,
 },
 [0xACC]={
  adobename="auvowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN AU",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xACC,
 },
 [0xACD]={
  adobename="viramagujarati",
  category="mn",
  combining=0x9,
  description="GUJARATI SIGN VIRAMA",
  direction="nsm",
  indic="o",
  indicclass="halant",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xACD,
 },
 [0xAD0]={
  adobename="omgujarati",
  category="lo",
  description="GUJARATI OM",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xAD0,
 },
 [0xAE0]={
  adobename="rrvocalicgujarati",
  category="lo",
  description="GUJARATI LETTER VOCALIC RR",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xAE0,
 },
 [0xAE1]={
  category="lo",
  description="GUJARATI LETTER VOCALIC LL",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xAE1,
 },
 [0xAE2]={
  category="mn",
  description="GUJARATI VOWEL SIGN VOCALIC L",
  direction="nsm",
  indic="i",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xAE2,
 },
 [0xAE3]={
  category="mn",
  description="GUJARATI VOWEL SIGN VOCALIC LL",
  direction="nsm",
  indic="i",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xAE3,
 },
 [0xAE6]={
  adobename="zerogujarati",
  category="nd",
  description="GUJARATI DIGIT ZERO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAE6,
 },
 [0xAE7]={
  adobename="onegujarati",
  category="nd",
  description="GUJARATI DIGIT ONE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAE7,
 },
 [0xAE8]={
  adobename="twogujarati",
  category="nd",
  description="GUJARATI DIGIT TWO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAE8,
 },
 [0xAE9]={
  adobename="threegujarati",
  category="nd",
  description="GUJARATI DIGIT THREE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAE9,
 },
 [0xAEA]={
  adobename="fourgujarati",
  category="nd",
  description="GUJARATI DIGIT FOUR",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAEA,
 },
 [0xAEB]={
  adobename="fivegujarati",
  category="nd",
  description="GUJARATI DIGIT FIVE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAEB,
 },
 [0xAEC]={
  adobename="sixgujarati",
  category="nd",
  description="GUJARATI DIGIT SIX",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAEC,
 },
 [0xAED]={
  adobename="sevengujarati",
  category="nd",
  description="GUJARATI DIGIT SEVEN",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAED,
 },
 [0xAEE]={
  adobename="eightgujarati",
  category="nd",
  description="GUJARATI DIGIT EIGHT",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAEE,
 },
 [0xAEF]={
  adobename="ninegujarati",
  category="nd",
  description="GUJARATI DIGIT NINE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xAEF,
 },
 [0xAF0]={
  category="po",
  description="GUJARATI ABBREVIATION SIGN",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xAF0,
 },
 [0xAF1]={
  category="sc",
  description="GUJARATI RUPEE SIGN",
  direction="et",
  indic="o",
  linebreak="pr",
  unicodeslot=0xAF1,
 },
 [0xAF9]={
  category="lo",
  description="GUJARATI LETTER ZHA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xAF9,
 },
 [0xAFA]={
  category="mn",
  description="GUJARATI SIGN SUKUN",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xAFA,
 },
 [0xAFB]={
  category="mn",
  description="GUJARATI SIGN SHADDA",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xAFB,
 },
 [0xAFC]={
  category="mn",
  description="GUJARATI SIGN MADDAH",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xAFC,
 },
 [0xAFD]={
  category="mn",
  description="GUJARATI SIGN THREE-DOT NUKTA ABOVE",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xAFD,
 },
 [0xAFE]={
  category="mn",
  description="GUJARATI SIGN CIRCLE NUKTA ABOVE",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xAFE,
 },
 [0xAFF]={
  category="mn",
  description="GUJARATI SIGN TWO-CIRCLE NUKTA ABOVE",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xAFF,
 },
 [0xB01]={
  category="mn",
  description="ORIYA SIGN CANDRABINDU",
  direction="nsm",
  indic="o",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xB01,
 },
 [0xB02]={
  category="mc",
  description="ORIYA SIGN ANUSVARA",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0xB02,
 },
 [0xB03]={
  category="mc",
  description="ORIYA SIGN VISARGA",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0xB03,
 },
 [0xB05]={
  category="lo",
  description="ORIYA LETTER A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB05,
 },
 [0xB06]={
  category="lo",
  description="ORIYA LETTER AA",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB06,
 },
 [0xB07]={
  category="lo",
  description="ORIYA LETTER I",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB07,
 },
 [0xB08]={
  category="lo",
  description="ORIYA LETTER II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB08,
 },
 [0xB09]={
  category="lo",
  description="ORIYA LETTER U",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB09,
 },
 [0xB0A]={
  category="lo",
  description="ORIYA LETTER UU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB0A,
 },
 [0xB0B]={
  category="lo",
  description="ORIYA LETTER VOCALIC R",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB0B,
 },
 [0xB0C]={
  category="lo",
  description="ORIYA LETTER VOCALIC L",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB0C,
 },
 [0xB0F]={
  category="lo",
  description="ORIYA LETTER E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB0F,
 },
 [0xB10]={
  category="lo",
  description="ORIYA LETTER AI",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB10,
 },
 [0xB13]={
  category="lo",
  description="ORIYA LETTER O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB13,
 },
 [0xB14]={
  category="lo",
  description="ORIYA LETTER AU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB14,
 },
 [0xB15]={
  category="lo",
  description="ORIYA LETTER KA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB15,
 },
 [0xB16]={
  category="lo",
  description="ORIYA LETTER KHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB16,
 },
 [0xB17]={
  category="lo",
  description="ORIYA LETTER GA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB17,
 },
 [0xB18]={
  category="lo",
  description="ORIYA LETTER GHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB18,
 },
 [0xB19]={
  category="lo",
  description="ORIYA LETTER NGA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB19,
 },
 [0xB1A]={
  category="lo",
  description="ORIYA LETTER CA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB1A,
 },
 [0xB1B]={
  category="lo",
  description="ORIYA LETTER CHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB1B,
 },
 [0xB1C]={
  category="lo",
  description="ORIYA LETTER JA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB1C,
 },
 [0xB1D]={
  category="lo",
  description="ORIYA LETTER JHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB1D,
 },
 [0xB1E]={
  category="lo",
  description="ORIYA LETTER NYA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB1E,
 },
 [0xB1F]={
  category="lo",
  description="ORIYA LETTER TTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB1F,
 },
 [0xB20]={
  category="lo",
  description="ORIYA LETTER TTHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB20,
 },
 [0xB21]={
  category="lo",
  description="ORIYA LETTER DDA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB21,
 },
 [0xB22]={
  category="lo",
  description="ORIYA LETTER DDHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB22,
 },
 [0xB23]={
  category="lo",
  description="ORIYA LETTER NNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB23,
 },
 [0xB24]={
  category="lo",
  description="ORIYA LETTER TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB24,
 },
 [0xB25]={
  category="lo",
  description="ORIYA LETTER THA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB25,
 },
 [0xB26]={
  category="lo",
  description="ORIYA LETTER DA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB26,
 },
 [0xB27]={
  category="lo",
  description="ORIYA LETTER DHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB27,
 },
 [0xB28]={
  category="lo",
  description="ORIYA LETTER NA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB28,
 },
 [0xB2A]={
  category="lo",
  description="ORIYA LETTER PA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB2A,
 },
 [0xB2B]={
  category="lo",
  description="ORIYA LETTER PHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB2B,
 },
 [0xB2C]={
  category="lo",
  description="ORIYA LETTER BA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB2C,
 },
 [0xB2D]={
  category="lo",
  description="ORIYA LETTER BHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB2D,
 },
 [0xB2E]={
  category="lo",
  description="ORIYA LETTER MA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB2E,
 },
 [0xB2F]={
  category="lo",
  description="ORIYA LETTER YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB2F,
 },
 [0xB30]={
  category="lo",
  description="ORIYA LETTER RA",
  direction="l",
  indic="c",
  indicclass="ra",
  indicorder="am",
  linebreak="al",
  unicodeslot=0xB30,
 },
 [0xB32]={
  category="lo",
  description="ORIYA LETTER LA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB32,
 },
 [0xB33]={
  category="lo",
  description="ORIYA LETTER LLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB33,
 },
 [0xB35]={
  category="lo",
  description="ORIYA LETTER VA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB35,
 },
 [0xB36]={
  category="lo",
  description="ORIYA LETTER SHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB36,
 },
 [0xB37]={
  category="lo",
  description="ORIYA LETTER SSA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB37,
 },
 [0xB38]={
  category="lo",
  description="ORIYA LETTER SA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB38,
 },
 [0xB39]={
  category="lo",
  description="ORIYA LETTER HA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB39,
 },
 [0xB3C]={
  category="mn",
  combining=0x7,
  description="ORIYA SIGN NUKTA",
  direction="nsm",
  indic="o",
  indicmark="b",
  indicclass="nukta",
  linebreak="cm",
  unicodeslot=0xB3C,
 },
 [0xB3D]={
  category="lo",
  description="ORIYA SIGN AVAGRAHA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xB3D,
 },
 [0xB3E]={
  category="mc",
  description="ORIYA VOWEL SIGN AA",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xB3E,
 },
 [0xB3F]={
  category="mn",
  description="ORIYA VOWEL SIGN I",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="am",
  linebreak="cm",
  unicodeslot=0xB3F,
 },
 [0xB40]={
  category="mc",
  description="ORIYA VOWEL SIGN II",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xB40,
 },
 [0xB41]={
  category="mn",
  description="ORIYA VOWEL SIGN U",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xB41,
 },
 [0xB42]={
  category="mn",
  description="ORIYA VOWEL SIGN UU",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xB42,
 },
 [0xB43]={
  category="mn",
  description="ORIYA VOWEL SIGN VOCALIC R",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xB43,
 },
 [0xB44]={
  category="mn",
  description="ORIYA VOWEL SIGN VOCALIC RR",
  direction="nsm",
  indic="d",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xB44,
 },
 [0xB47]={
  category="mc",
  description="ORIYA VOWEL SIGN E",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bh",
  linebreak="cm",
  unicodeslot=0xB47,
 },
 [0xB48]={
  category="mc",
  description="ORIYA VOWEL SIGN AI",
  direction="l",
  indic="d",
  indicmark="l",
  linebreak="cm",
  specials={ "char", 0xB47, 0xB56 },
  unicodeslot=0xB48,
 },
 [0xB4B]={
  category="mc",
  description="ORIYA VOWEL SIGN O",
  direction="l",
  indic="d",
  indicmark="s",
  linebreak="cm",
  specials={ "char", 0xB47, 0xB3E },
  unicodeslot=0xB4B,
 },
 [0xB4C]={
  category="mc",
  description="ORIYA VOWEL SIGN AU",
  direction="l",
  indic="d",
  indicmark="s",
  linebreak="cm",
  specials={ "char", 0xB47, 0xB57 },
  unicodeslot=0xB4C,
 },
 [0xB4D]={
  category="mn",
  combining=0x9,
  description="ORIYA SIGN VIRAMA",
  direction="nsm",
  indic="o",
  indicclass="halant",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xB4D,
 },
 [0xB56]={
  category="mn",
  description="ORIYA AI LENGTH MARK",
  direction="nsm",
  indic="o",
  indicorder="am",
  linebreak="cm",
  unicodeslot=0xB56,
 },
 [0xB57]={
  category="mc",
  description="ORIYA AU LENGTH MARK",
  direction="l",
  indic="o",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xB57,
 },
 [0xB5C]={
  category="lo",
  description="ORIYA LETTER RRA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0xB21, 0xB3C },
  unicodeslot=0xB5C,
 },
 [0xB5D]={
  category="lo",
  description="ORIYA LETTER RHA",
  direction="l",
  indic="c",
  linebreak="al",
  specials={ "char", 0xB22, 0xB3C },
  unicodeslot=0xB5D,
 },
 [0xB5F]={
  category="lo",
  description="ORIYA LETTER YYA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xB5F,
 },
 [0xB60]={
  category="lo",
  description="ORIYA LETTER VOCALIC RR",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB60,
 },
 [0xB61]={
  category="lo",
  description="ORIYA LETTER VOCALIC LL",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB61,
 },
 [0xB62]={
  category="mn",
  description="ORIYA VOWEL SIGN VOCALIC L",
  direction="nsm",
  indic="d",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xB62,
 },
 [0xB63]={
  category="mn",
  description="ORIYA VOWEL SIGN VOCALIC LL",
  direction="nsm",
  indic="d",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xB63,
 },
 [0xB66]={
  category="nd",
  description="ORIYA DIGIT ZERO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB66,
 },
 [0xB67]={
  category="nd",
  description="ORIYA DIGIT ONE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB67,
 },
 [0xB68]={
  category="nd",
  description="ORIYA DIGIT TWO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB68,
 },
 [0xB69]={
  category="nd",
  description="ORIYA DIGIT THREE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB69,
 },
 [0xB6A]={
  category="nd",
  description="ORIYA DIGIT FOUR",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB6A,
 },
 [0xB6B]={
  category="nd",
  description="ORIYA DIGIT FIVE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB6B,
 },
 [0xB6C]={
  category="nd",
  description="ORIYA DIGIT SIX",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB6C,
 },
 [0xB6D]={
  category="nd",
  description="ORIYA DIGIT SEVEN",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB6D,
 },
 [0xB6E]={
  category="nd",
  description="ORIYA DIGIT EIGHT",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB6E,
 },
 [0xB6F]={
  category="nd",
  description="ORIYA DIGIT NINE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xB6F,
 },
 [0xB70]={
  category="so",
  description="ORIYA ISSHAR",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xB70,
 },
 [0xB71]={
  category="lo",
  description="ORIYA LETTER WA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB71,
 },
 [0xB72]={
  category="no",
  description="ORIYA FRACTION ONE QUARTER",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xB72,
 },
 [0xB73]={
  category="no",
  description="ORIYA FRACTION ONE HALF",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xB73,
 },
 [0xB74]={
  category="no",
  description="ORIYA FRACTION THREE QUARTERS",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xB74,
 },
 [0xB75]={
  category="no",
  description="ORIYA FRACTION ONE SIXTEENTH",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xB75,
 },
 [0xB76]={
  category="no",
  description="ORIYA FRACTION ONE EIGHTH",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xB76,
 },
 [0xB77]={
  category="no",
  description="ORIYA FRACTION THREE SIXTEENTHS",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xB77,
 },
 [0xB82]={
  category="mn",
  description="TAMIL SIGN ANUSVARA",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xB82,
 },
 [0xB83]={
  category="lo",
  description="TAMIL SIGN VISARGA",
  direction="l",
  indic="o",
  linebreak="al",
  synonyms={ "tamil aytham" },
  unicodeslot=0xB83,
 },
 [0xB85]={
  category="lo",
  description="TAMIL LETTER A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB85,
 },
 [0xB86]={
  category="lo",
  description="TAMIL LETTER AA",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB86,
 },
 [0xB87]={
  category="lo",
  description="TAMIL LETTER I",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB87,
 },
 [0xB88]={
  category="lo",
  description="TAMIL LETTER II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB88,
 },
 [0xB89]={
  category="lo",
  description="TAMIL LETTER U",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB89,
 },
 [0xB8A]={
  category="lo",
  description="TAMIL LETTER UU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB8A,
 },
 [0xB8E]={
  category="lo",
  description="TAMIL LETTER E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB8E,
 },
 [0xB8F]={
  category="lo",
  description="TAMIL LETTER EE",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB8F,
 },
 [0xB90]={
  category="lo",
  description="TAMIL LETTER AI",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB90,
 },
 [0xB92]={
  category="lo",
  description="TAMIL LETTER O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB92,
 },
 [0xB93]={
  category="lo",
  description="TAMIL LETTER OO",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xB93,
 },
 [0xB94]={
  category="lo",
  description="TAMIL LETTER AU",
  direction="l",
  indic="i",
  linebreak="al",
  specials={ "char", 0xB92, 0xBD7 },
  unicodeslot=0xB94,
 },
 [0xB95]={
  category="lo",
  description="TAMIL LETTER KA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB95,
 },
 [0xB99]={
  category="lo",
  description="TAMIL LETTER NGA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB99,
 },
 [0xB9A]={
  category="lo",
  description="TAMIL LETTER CA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB9A,
 },
 [0xB9C]={
  category="lo",
  description="TAMIL LETTER JA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB9C,
 },
 [0xB9E]={
  category="lo",
  description="TAMIL LETTER NYA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB9E,
 },
 [0xB9F]={
  category="lo",
  description="TAMIL LETTER TTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xB9F,
 },
 [0xBA3]={
  category="lo",
  description="TAMIL LETTER NNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBA3,
 },
 [0xBA4]={
  category="lo",
  description="TAMIL LETTER TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBA4,
 },
 [0xBA8]={
  category="lo",
  description="TAMIL LETTER NA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBA8,
 },
 [0xBA9]={
  category="lo",
  description="TAMIL LETTER NNNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBA9,
 },
 [0xBAA]={
  category="lo",
  description="TAMIL LETTER PA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBAA,
 },
 [0xBAE]={
  category="lo",
  description="TAMIL LETTER MA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBAE,
 },
 [0xBAF]={
  category="lo",
  description="TAMIL LETTER YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBAF,
 },
 [0xBB0]={
  category="lo",
  description="TAMIL LETTER RA",
  direction="l",
  indic="c",
  indicclass="ra",
  indicorder="ap",
  linebreak="al",
  unicodeslot=0xBB0,
 },
 [0xBB1]={
  category="lo",
  description="TAMIL LETTER RRA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBB1,
 },
 [0xBB2]={
  category="lo",
  description="TAMIL LETTER LA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBB2,
 },
 [0xBB3]={
  category="lo",
  description="TAMIL LETTER LLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBB3,
 },
 [0xBB4]={
  category="lo",
  description="TAMIL LETTER LLLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBB4,
 },
 [0xBB5]={
  category="lo",
  description="TAMIL LETTER VA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBB5,
 },
 [0xBB6]={
  category="lo",
  description="TAMIL LETTER SHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBB6,
 },
 [0xBB7]={
  category="lo",
  description="TAMIL LETTER SSA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBB7,
 },
 [0xBB8]={
  category="lo",
  description="TAMIL LETTER SA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBB8,
 },
 [0xBB9]={
  category="lo",
  description="TAMIL LETTER HA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xBB9,
 },
 [0xBBE]={
  category="mc",
  description="TAMIL VOWEL SIGN AA",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xBBE,
 },
 [0xBBF]={
  category="mc",
  description="TAMIL VOWEL SIGN I",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xBBF,
 },
 [0xBC0]={
  category="mn",
  description="TAMIL VOWEL SIGN II",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xBC0,
 },
 [0xBC1]={
  category="mc",
  description="TAMIL VOWEL SIGN U",
  direction="l",
  indic="d",
  indicmark="b",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xBC1,
 },
 [0xBC2]={
  category="mc",
  description="TAMIL VOWEL SIGN UU",
  direction="l",
  indic="d",
  indicmark="b",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xBC2,
 },
 [0xBC6]={
  category="mc",
  description="TAMIL VOWEL SIGN E",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bm",
  linebreak="cm",
  unicodeslot=0xBC6,
 },
 [0xBC7]={
  category="mc",
  description="TAMIL VOWEL SIGN EE",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bm",
  linebreak="cm",
  unicodeslot=0xBC7,
 },
 [0xBC8]={
  category="mc",
  description="TAMIL VOWEL SIGN AI",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bm",
  linebreak="cm",
  unicodeslot=0xBC8,
 },
 [0xBCA]={
  category="mc",
  description="TAMIL VOWEL SIGN O",
  direction="l",
  indic="d",
  indicmark="s",
  linebreak="cm",
  specials={ "char", 0xBC6, 0xBBE },
  unicodeslot=0xBCA,
 },
 [0xBCB]={
  category="mc",
  description="TAMIL VOWEL SIGN OO",
  direction="l",
  indic="d",
  indicmark="s",
  linebreak="cm",
  specials={ "char", 0xBC7, 0xBBE },
  unicodeslot=0xBCB,
 },
 [0xBCC]={
  category="mc",
  description="TAMIL VOWEL SIGN AU",
  direction="l",
  indic="d",
  indicmark="s",
  linebreak="cm",
  specials={ "char", 0xBC6, 0xBD7 },
  unicodeslot=0xBCC,
 },
 [0xBCD]={
  category="mn",
  combining=0x9,
  description="TAMIL SIGN VIRAMA",
  direction="nsm",
  indic="o",
  indicclass="halant",
  indicmark="t",
  linebreak="cm",
  unicodeslot=0xBCD,
 },
 [0xBD0]={
  category="lo",
  description="TAMIL OM",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xBD0,
 },
 [0xBD7]={
  category="mc",
  description="TAMIL AU LENGTH MARK",
  direction="l",
  indic="o",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xBD7,
 },
 [0xBE6]={
  category="nd",
  description="TAMIL DIGIT ZERO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBE6,
 },
 [0xBE7]={
  category="nd",
  description="TAMIL DIGIT ONE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBE7,
 },
 [0xBE8]={
  category="nd",
  description="TAMIL DIGIT TWO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBE8,
 },
 [0xBE9]={
  category="nd",
  description="TAMIL DIGIT THREE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBE9,
 },
 [0xBEA]={
  category="nd",
  description="TAMIL DIGIT FOUR",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBEA,
 },
 [0xBEB]={
  category="nd",
  description="TAMIL DIGIT FIVE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBEB,
 },
 [0xBEC]={
  category="nd",
  description="TAMIL DIGIT SIX",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBEC,
 },
 [0xBED]={
  category="nd",
  description="TAMIL DIGIT SEVEN",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBED,
 },
 [0xBEE]={
  category="nd",
  description="TAMIL DIGIT EIGHT",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBEE,
 },
 [0xBEF]={
  category="nd",
  description="TAMIL DIGIT NINE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xBEF,
 },
 [0xBF0]={
  category="no",
  description="TAMIL NUMBER TEN",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xBF0,
 },
 [0xBF1]={
  category="no",
  description="TAMIL NUMBER ONE HUNDRED",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xBF1,
 },
 [0xBF2]={
  category="no",
  description="TAMIL NUMBER ONE THOUSAND",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xBF2,
 },
 [0xBF3]={
  category="so",
  description="TAMIL DAY SIGN",
  direction="on",
  indic="o",
  linebreak="al",
  synonyms={ "tamil naal" },
  unicodeslot=0xBF3,
 },
 [0xBF4]={
  category="so",
  description="TAMIL MONTH SIGN",
  direction="on",
  indic="o",
  linebreak="al",
  synonyms={ "tamil maatham" },
  unicodeslot=0xBF4,
 },
 [0xBF5]={
  category="so",
  description="TAMIL YEAR SIGN",
  direction="on",
  indic="o",
  linebreak="al",
  synonyms={ "tamil varudam" },
  unicodeslot=0xBF5,
 },
 [0xBF6]={
  category="so",
  description="TAMIL DEBIT SIGN",
  direction="on",
  indic="o",
  linebreak="al",
  synonyms={ "tamil patru" },
  unicodeslot=0xBF6,
 },
 [0xBF7]={
  category="so",
  description="TAMIL CREDIT SIGN",
  direction="on",
  indic="o",
  linebreak="al",
  synonyms={ "tamil varavu" },
  unicodeslot=0xBF7,
 },
 [0xBF8]={
  category="so",
  description="TAMIL AS ABOVE SIGN",
  direction="on",
  indic="o",
  linebreak="al",
  synonyms={ "tamil merpadi" },
  unicodeslot=0xBF8,
 },
 [0xBF9]={
  category="sc",
  description="TAMIL RUPEE SIGN",
  direction="et",
  indic="o",
  linebreak="pr",
  synonyms={ "tamil rupai" },
  unicodeslot=0xBF9,
 },
 [0xBFA]={
  category="so",
  description="TAMIL NUMBER SIGN",
  direction="on",
  indic="o",
  linebreak="al",
  synonyms={ "tamil enn" },
  unicodeslot=0xBFA,
 },
 [0xC00]={
  category="mn",
  description="TELUGU SIGN COMBINING CANDRABINDU ABOVE",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xC00,
 },
 [0xC01]={
  category="mc",
  description="TELUGU SIGN CANDRABINDU",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0xC01,
 },
 [0xC02]={
  category="mc",
  description="TELUGU SIGN ANUSVARA",
  direction="l",
  indic="o",
  linebreak="cm",
  synonyms={ "telugu sunna" },
  unicodeslot=0xC02,
 },
 [0xC03]={
  category="mc",
  description="TELUGU SIGN VISARGA",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0xC03,
 },
 [0xC05]={
  category="lo",
  description="TELUGU LETTER A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC05,
 },
 [0xC06]={
  category="lo",
  description="TELUGU LETTER AA",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC06,
 },
 [0xC07]={
  category="lo",
  description="TELUGU LETTER I",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC07,
 },
 [0xC08]={
  category="lo",
  description="TELUGU LETTER II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC08,
 },
 [0xC09]={
  category="lo",
  description="TELUGU LETTER U",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC09,
 },
 [0xC0A]={
  category="lo",
  description="TELUGU LETTER UU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC0A,
 },
 [0xC0B]={
  category="lo",
  description="TELUGU LETTER VOCALIC R",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC0B,
 },
 [0xC0C]={
  category="lo",
  description="TELUGU LETTER VOCALIC L",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC0C,
 },
 [0xC0E]={
  category="lo",
  description="TELUGU LETTER E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC0E,
 },
 [0xC0F]={
  category="lo",
  description="TELUGU LETTER EE",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC0F,
 },
 [0xC10]={
  category="lo",
  description="TELUGU LETTER AI",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC10,
 },
 [0xC12]={
  category="lo",
  description="TELUGU LETTER O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC12,
 },
 [0xC13]={
  category="lo",
  description="TELUGU LETTER OO",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC13,
 },
 [0xC14]={
  category="lo",
  description="TELUGU LETTER AU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC14,
 },
 [0xC15]={
  category="lo",
  description="TELUGU LETTER KA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC15,
 },
 [0xC16]={
  category="lo",
  description="TELUGU LETTER KHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC16,
 },
 [0xC17]={
  category="lo",
  description="TELUGU LETTER GA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC17,
 },
 [0xC18]={
  category="lo",
  description="TELUGU LETTER GHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC18,
 },
 [0xC19]={
  category="lo",
  description="TELUGU LETTER NGA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC19,
 },
 [0xC1A]={
  category="lo",
  description="TELUGU LETTER CA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC1A,
 },
 [0xC1B]={
  category="lo",
  description="TELUGU LETTER CHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC1B,
 },
 [0xC1C]={
  category="lo",
  description="TELUGU LETTER JA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC1C,
 },
 [0xC1D]={
  category="lo",
  description="TELUGU LETTER JHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC1D,
 },
 [0xC1E]={
  category="lo",
  description="TELUGU LETTER NYA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC1E,
 },
 [0xC1F]={
  category="lo",
  description="TELUGU LETTER TTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC1F,
 },
 [0xC20]={
  category="lo",
  description="TELUGU LETTER TTHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC20,
 },
 [0xC21]={
  category="lo",
  description="TELUGU LETTER DDA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC21,
 },
 [0xC22]={
  category="lo",
  description="TELUGU LETTER DDHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC22,
 },
 [0xC23]={
  category="lo",
  description="TELUGU LETTER NNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC23,
 },
 [0xC24]={
  category="lo",
  description="TELUGU LETTER TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC24,
 },
 [0xC25]={
  category="lo",
  description="TELUGU LETTER THA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC25,
 },
 [0xC26]={
  category="lo",
  description="TELUGU LETTER DA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC26,
 },
 [0xC27]={
  category="lo",
  description="TELUGU LETTER DHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC27,
 },
 [0xC28]={
  category="lo",
  description="TELUGU LETTER NA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC28,
 },
 [0xC2A]={
  category="lo",
  description="TELUGU LETTER PA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC2A,
 },
 [0xC2B]={
  category="lo",
  description="TELUGU LETTER PHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC2B,
 },
 [0xC2C]={
  category="lo",
  description="TELUGU LETTER BA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC2C,
 },
 [0xC2D]={
  category="lo",
  description="TELUGU LETTER BHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC2D,
 },
 [0xC2E]={
  category="lo",
  description="TELUGU LETTER MA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC2E,
 },
 [0xC2F]={
  category="lo",
  description="TELUGU LETTER YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC2F,
 },
 [0xC30]={
  category="lo",
  description="TELUGU LETTER RA",
  direction="l",
  indic="c",
  indicclass="ra",
  indicorder="ap",
  linebreak="al",
  unicodeslot=0xC30,
 },
 [0xC31]={
  category="lo",
  description="TELUGU LETTER RRA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC31,
 },
 [0xC32]={
  category="lo",
  description="TELUGU LETTER LA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC32,
 },
 [0xC33]={
  category="lo",
  description="TELUGU LETTER LLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC33,
 },
 [0xC34]={
  category="lo",
  description="TELUGU LETTER LLLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC34,
 },
 [0xC35]={
  category="lo",
  description="TELUGU LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0xC35,
  indic="c",
 },
 [0xC36]={
  category="lo",
  description="TELUGU LETTER SHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC36,
 },
 [0xC37]={
  category="lo",
  description="TELUGU LETTER SSA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC37,
 },
 [0xC38]={
  category="lo",
  description="TELUGU LETTER SA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC38,
 },
 [0xC39]={
  category="lo",
  description="TELUGU LETTER HA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC39,
 },
 [0xC3D]={
  category="lo",
  description="TELUGU SIGN AVAGRAHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC3D,
 },
 [0xC3E]={
  category="mn",
  description="TELUGU VOWEL SIGN AA",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC3E,
 },
 [0xC3F]={
  category="mn",
  description="TELUGU VOWEL SIGN I",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC3F,
 },
 [0xC40]={
  category="mn",
  description="TELUGU VOWEL SIGN II",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC40,
 },
 [0xC41]={
  category="mc",
  description="TELUGU VOWEL SIGN U",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC41,
 },
 [0xC42]={
  category="mc",
  description="TELUGU VOWEL SIGN UU",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC42,
 },
 [0xC43]={
  category="mc",
  description="TELUGU VOWEL SIGN VOCALIC R",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xC43,
 },
 [0xC44]={
  category="mc",
  description="TELUGU VOWEL SIGN VOCALIC RR",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xC44,
 },
 [0xC46]={
  category="mn",
  description="TELUGU VOWEL SIGN E",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC46,
 },
 [0xC47]={
  category="mn",
  description="TELUGU VOWEL SIGN EE",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC47,
 },
 [0xC48]={
  category="mn",
  description="TELUGU VOWEL SIGN AI",
  direction="nsm",
  indic="d",
  indicmark="t",
  linebreak="cm",
  specials={ "char", 0xC46, 0xC56 },
  unicodeslot=0xC48,
 },
 [0xC4A]={
  category="mn",
  description="TELUGU VOWEL SIGN O",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC4A,
 },
 [0xC4B]={
  category="mn",
  description="TELUGU VOWEL SIGN OO",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC4B,
 },
 [0xC4C]={
  category="mn",
  description="TELUGU VOWEL SIGN AU",
  direction="nsm",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC4C,
 },
 [0xC4D]={
  category="mn",
  combining=0x9,
  description="TELUGU SIGN VIRAMA",
  direction="nsm",
  indic="o",
  indicclass="halant",
  indicmark="t",
  linebreak="cm",
  unicodeslot=0xC4D,
 },
 [0xC55]={
  category="mn",
  combining=0x54,
  description="TELUGU LENGTH MARK",
  direction="nsm",
  indic="o",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC55,
 },
 [0xC56]={
  category="mn",
  combining=0x5B,
  description="TELUGU AI LENGTH MARK",
  direction="nsm",
  indic="o",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xC56,
 },
 [0xC58]={
  category="lo",
  description="TELUGU LETTER TSA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xC58,
 },
 [0xC59]={
  category="lo",
  description="TELUGU LETTER DZA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xC59,
 },
 [0xC5A]={
  category="lo",
  description="TELUGU LETTER RRRA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xC5A,
 },
 [0xC60]={
  category="lo",
  description="TELUGU LETTER VOCALIC RR",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC60,
 },
 [0xC61]={
  category="lo",
  description="TELUGU LETTER VOCALIC LL",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC61,
 },
 [0xC62]={
  category="mn",
  description="TELUGU VOWEL SIGN VOCALIC L",
  direction="nsm",
  indic="d",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xC62,
 },
 [0xC63]={
  category="mn",
  description="TELUGU VOWEL SIGN VOCALIC LL",
  direction="nsm",
  indic="d",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xC63,
 },
 [0xC66]={
  category="nd",
  description="TELUGU DIGIT ZERO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC66,
 },
 [0xC67]={
  category="nd",
  description="TELUGU DIGIT ONE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC67,
 },
 [0xC68]={
  category="nd",
  description="TELUGU DIGIT TWO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC68,
 },
 [0xC69]={
  category="nd",
  description="TELUGU DIGIT THREE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC69,
 },
 [0xC6A]={
  category="nd",
  description="TELUGU DIGIT FOUR",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC6A,
 },
 [0xC6B]={
  category="nd",
  description="TELUGU DIGIT FIVE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC6B,
 },
 [0xC6C]={
  category="nd",
  description="TELUGU DIGIT SIX",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC6C,
 },
 [0xC6D]={
  category="nd",
  description="TELUGU DIGIT SEVEN",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC6D,
 },
 [0xC6E]={
  category="nd",
  description="TELUGU DIGIT EIGHT",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC6E,
 },
 [0xC6F]={
  category="nd",
  description="TELUGU DIGIT NINE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xC6F,
 },
 [0xC78]={
  category="no",
  description="TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR",
  direction="on",
  indic="o",
  linebreak="al",
  unicodeslot=0xC78,
 },
 [0xC79]={
  category="no",
  description="TELUGU FRACTION DIGIT ONE FOR ODD POWERS OF FOUR",
  direction="on",
  indic="o",
  linebreak="al",
  unicodeslot=0xC79,
 },
 [0xC7A]={
  category="no",
  description="TELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOUR",
  direction="on",
  indic="o",
  linebreak="al",
  unicodeslot=0xC7A,
 },
 [0xC7B]={
  category="no",
  description="TELUGU FRACTION DIGIT THREE FOR ODD POWERS OF FOUR",
  direction="on",
  indic="o",
  linebreak="al",
  unicodeslot=0xC7B,
 },
 [0xC7C]={
  category="no",
  description="TELUGU FRACTION DIGIT ONE FOR EVEN POWERS OF FOUR",
  direction="on",
  indic="o",
  linebreak="al",
  unicodeslot=0xC7C,
 },
 [0xC7D]={
  category="no",
  description="TELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOUR",
  direction="on",
  indic="o",
  linebreak="al",
  unicodeslot=0xC7D,
 },
 [0xC7E]={
  category="no",
  description="TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR",
  direction="on",
  indic="o",
  linebreak="al",
  unicodeslot=0xC7E,
 },
 [0xC7F]={
  category="so",
  description="TELUGU SIGN TUUMU",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xC7F,
 },
 [0xC80]={
  category="lo",
  description="KANNADA SIGN SPACING CANDRABINDU",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xC80,
 },
 [0xC81]={
  category="mn",
  description="KANNADA SIGN CANDRABINDU",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xC81,
 },
 [0xC82]={
  category="mc",
  description="KANNADA SIGN ANUSVARA",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0xC82,
 },
 [0xC83]={
  category="mc",
  description="KANNADA SIGN VISARGA",
  direction="l",
  indic="o",
  linebreak="cm",
  unicodeslot=0xC83,
 },
 [0xC85]={
  category="lo",
  description="KANNADA LETTER A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC85,
 },
 [0xC86]={
  category="lo",
  description="KANNADA LETTER AA",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC86,
 },
 [0xC87]={
  category="lo",
  description="KANNADA LETTER I",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC87,
 },
 [0xC88]={
  category="lo",
  description="KANNADA LETTER II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC88,
 },
 [0xC89]={
  category="lo",
  description="KANNADA LETTER U",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC89,
 },
 [0xC8A]={
  category="lo",
  description="KANNADA LETTER UU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC8A,
 },
 [0xC8B]={
  category="lo",
  description="KANNADA LETTER VOCALIC R",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC8B,
 },
 [0xC8C]={
  category="lo",
  description="KANNADA LETTER VOCALIC L",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC8C,
 },
 [0xC8E]={
  category="lo",
  description="KANNADA LETTER E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC8E,
 },
 [0xC8F]={
  category="lo",
  description="KANNADA LETTER EE",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC8F,
 },
 [0xC90]={
  category="lo",
  description="KANNADA LETTER AI",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC90,
 },
 [0xC92]={
  category="lo",
  description="KANNADA LETTER O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC92,
 },
 [0xC93]={
  category="lo",
  description="KANNADA LETTER OO",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC93,
 },
 [0xC94]={
  category="lo",
  description="KANNADA LETTER AU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xC94,
 },
 [0xC95]={
  category="lo",
  description="KANNADA LETTER KA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC95,
 },
 [0xC96]={
  category="lo",
  description="KANNADA LETTER KHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC96,
 },
 [0xC97]={
  category="lo",
  description="KANNADA LETTER GA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC97,
 },
 [0xC98]={
  category="lo",
  description="KANNADA LETTER GHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC98,
 },
 [0xC99]={
  category="lo",
  description="KANNADA LETTER NGA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC99,
 },
 [0xC9A]={
  category="lo",
  description="KANNADA LETTER CA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC9A,
 },
 [0xC9B]={
  category="lo",
  description="KANNADA LETTER CHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC9B,
 },
 [0xC9C]={
  category="lo",
  description="KANNADA LETTER JA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC9C,
 },
 [0xC9D]={
  category="lo",
  description="KANNADA LETTER JHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC9D,
 },
 [0xC9E]={
  category="lo",
  description="KANNADA LETTER NYA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC9E,
 },
 [0xC9F]={
  category="lo",
  description="KANNADA LETTER TTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xC9F,
 },
 [0xCA0]={
  category="lo",
  description="KANNADA LETTER TTHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCA0,
 },
 [0xCA1]={
  category="lo",
  description="KANNADA LETTER DDA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCA1,
 },
 [0xCA2]={
  category="lo",
  description="KANNADA LETTER DDHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCA2,
 },
 [0xCA3]={
  category="lo",
  description="KANNADA LETTER NNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCA3,
 },
 [0xCA4]={
  category="lo",
  description="KANNADA LETTER TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCA4,
 },
 [0xCA5]={
  category="lo",
  description="KANNADA LETTER THA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCA5,
 },
 [0xCA6]={
  category="lo",
  description="KANNADA LETTER DA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCA6,
 },
 [0xCA7]={
  category="lo",
  description="KANNADA LETTER DHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCA7,
 },
 [0xCA8]={
  category="lo",
  description="KANNADA LETTER NA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCA8,
 },
 [0xCAA]={
  category="lo",
  description="KANNADA LETTER PA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCAA,
 },
 [0xCAB]={
  category="lo",
  description="KANNADA LETTER PHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCAB,
 },
 [0xCAC]={
  category="lo",
  description="KANNADA LETTER BA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCAC,
 },
 [0xCAD]={
  category="lo",
  description="KANNADA LETTER BHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCAD,
 },
 [0xCAE]={
  category="lo",
  description="KANNADA LETTER MA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCAE,
 },
 [0xCAF]={
  category="lo",
  description="KANNADA LETTER YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCAF,
 },
 [0xCB0]={
  category="lo",
  description="KANNADA LETTER RA",
  direction="l",
  indic="c",
  indicclass="ra",
  indicorder="ap",
  linebreak="al",
  unicodeslot=0xCB0,
 },
 [0xCB1]={
  category="lo",
  description="KANNADA LETTER RRA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCB1,
 },
 [0xCB2]={
  category="lo",
  description="KANNADA LETTER LA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCB2,
 },
 [0xCB3]={
  category="lo",
  description="KANNADA LETTER LLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCB3,
 },
 [0xCB5]={
  category="lo",
  description="KANNADA LETTER VA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCB5,
 },
 [0xCB6]={
  category="lo",
  description="KANNADA LETTER SHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCB6,
 },
 [0xCB7]={
  category="lo",
  description="KANNADA LETTER SSA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCB7,
 },
 [0xCB8]={
  category="lo",
  description="KANNADA LETTER SA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCB8,
 },
 [0xCB9]={
  category="lo",
  description="KANNADA LETTER HA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCB9,
 },
 [0xCBC]={
  category="mn",
  combining=0x7,
  description="KANNADA SIGN NUKTA",
  direction="nsm",
  indic="o",
  indicmark="b",
  indicclass="nukta",
  linebreak="cm",
  unicodeslot=0xCBC,
 },
 [0xCBD]={
  category="lo",
  description="KANNADA SIGN AVAGRAHA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xCBD,
 },
 [0xCBE]={
  category="mc",
  description="KANNADA VOWEL SIGN AA",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xCBE,
 },
 [0xCBF]={
  category="mn",
  description="KANNADA VOWEL SIGN I",
  direction="l",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xCBF,
 },
 [0xCC0]={
  category="mc",
  description="KANNADA VOWEL SIGN II",
  direction="l",
  indic="d",
  indicmark="r",
  linebreak="cm",
  specials={ "char", 0xCBF, 0xCD5 },
  unicodeslot=0xCC0,
 },
 [0xCC1]={
  category="mc",
  description="KANNADA VOWEL SIGN U",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xCC1,
 },
 [0xCC2]={
  category="mc",
  description="KANNADA VOWEL SIGN UU",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xCC2,
 },
 [0xCC3]={
  category="mc",
  description="KANNADA VOWEL SIGN VOCALIC R",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xCC3,
 },
 [0xCC4]={
  category="mc",
  description="KANNADA VOWEL SIGN VOCALIC RR",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xCC4,
 },
 [0xCC6]={
  category="mn",
  description="KANNADA VOWEL SIGN E",
  direction="l",
  indic="d",
  indicmark="t",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xCC6,
 },
 [0xCC7]={
  category="mc",
  description="KANNADA VOWEL SIGN EE",
  direction="l",
  indic="d",
  indicmark="r",
  linebreak="cm",
  specials={ "char", 0xCC6, 0xCD5 },
  unicodeslot=0xCC7,
 },
 [0xCC8]={
  category="mc",
  description="KANNADA VOWEL SIGN AI",
  direction="l",
  indic="d",
  indicmark="r",
  linebreak="cm",
  specials={ "char", 0xCC6, 0xCD6 },
  unicodeslot=0xCC8,
 },
 [0xCCA]={
  category="mc",
  description="KANNADA VOWEL SIGN O",
  direction="l",
  indic="d",
  indicmark="r",
  linebreak="cm",
  specials={ "char", 0xCC6, 0xCC2 },
  unicodeslot=0xCCA,
 },
 [0xCCB]={
  category="mc",
  description="KANNADA VOWEL SIGN OO",
  direction="l",
  indic="d",
  indicmark="r",
  linebreak="cm",
  specials={ "char", 0xCCA, 0xCD5 },
  unicodeslot=0xCCB,
 },
 [0xCCC]={
  category="mn",
  description="KANNADA VOWEL SIGN AU",
  direction="nsm",
  indic="d",
  indicmark="r",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xCCC,
 },
 [0xCCD]={
  category="mn",
  combining=0x9,
  description="KANNADA SIGN VIRAMA",
  direction="nsm",
  indic="s",
  indicclass="halant",
  linebreak="cm",
  unicodeslot=0xCCD,
 },
 [0xCD5]={
  category="mc",
  description="KANNADA LENGTH MARK",
  direction="l",
  indic="o",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xCD5,
 },
 [0xCD6]={
  category="mc",
  description="KANNADA AI LENGTH MARK",
  direction="l",
  indic="o",
  indicorder="as",
  linebreak="cm",
  unicodeslot=0xCD6,
 },
 [0xCDE]={
  category="lo",
  description="KANNADA LETTER FA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xCDE,
 },
 [0xCE0]={
  category="lo",
  description="KANNADA LETTER VOCALIC RR",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xCE0,
 },
 [0xCE1]={
  category="lo",
  description="KANNADA LETTER VOCALIC LL",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xCE1,
 },
 [0xCE2]={
  category="mn",
  description="KANNADA VOWEL SIGN VOCALIC L",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xCE2,
 },
 [0xCE3]={
  category="mn",
  description="KANNADA VOWEL SIGN VOCALIC LL",
  direction="nsm",
  indic="d",
  indicmark="b",
  indicorder="bs",
  linebreak="cm",
  unicodeslot=0xCE3,
 },
 [0xCE6]={
  category="nd",
  description="KANNADA DIGIT ZERO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCE6,
 },
 [0xCE7]={
  category="nd",
  description="KANNADA DIGIT ONE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCE7,
 },
 [0xCE8]={
  category="nd",
  description="KANNADA DIGIT TWO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCE8,
 },
 [0xCE9]={
  category="nd",
  description="KANNADA DIGIT THREE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCE9,
 },
 [0xCEA]={
  category="nd",
  description="KANNADA DIGIT FOUR",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCEA,
 },
 [0xCEB]={
  category="nd",
  description="KANNADA DIGIT FIVE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCEB,
 },
 [0xCEC]={
  category="nd",
  description="KANNADA DIGIT SIX",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCEC,
 },
 [0xCED]={
  category="nd",
  description="KANNADA DIGIT SEVEN",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCED,
 },
 [0xCEE]={
  category="nd",
  description="KANNADA DIGIT EIGHT",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCEE,
 },
 [0xCEF]={
  category="nd",
  description="KANNADA DIGIT NINE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xCEF,
 },
 [0xCF1]={
  category="so",
  description="KANNADA SIGN JIHVAMULIYA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xCF1,
 },
 [0xCF2]={
  category="so",
  description="KANNADA SIGN UPADHMANIYA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xCF2,
 },
 [0xD00]={
  category="mn",
  description="MALAYALAM SIGN COMBINING ANUSVARA ABOVE",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xD00,
 },
 [0xD01]={
  category="mn",
  description="MALAYALAM SIGN CANDRABINDU",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xD01,
 },
 [0xD02]={
  category="mc",
  description="MALAYALAM SIGN ANUSVARA",
  direction="l",
  indic="m",
  linebreak="cm",
  unicodeslot=0xD02,
 },
 [0xD03]={
  category="mc",
  description="MALAYALAM SIGN VISARGA",
  direction="l",
  indic="m",
  linebreak="cm",
  unicodeslot=0xD03,
 },
 [0xD05]={
  category="lo",
  description="MALAYALAM LETTER A",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD05,
 },
 [0xD06]={
  category="lo",
  description="MALAYALAM LETTER AA",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD06,
 },
 [0xD07]={
  category="lo",
  description="MALAYALAM LETTER I",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD07,
 },
 [0xD08]={
  category="lo",
  description="MALAYALAM LETTER II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD08,
 },
 [0xD09]={
  category="lo",
  description="MALAYALAM LETTER U",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD09,
 },
 [0xD0A]={
  category="lo",
  description="MALAYALAM LETTER UU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD0A,
 },
 [0xD0B]={
  category="lo",
  description="MALAYALAM LETTER VOCALIC R",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD0B,
 },
 [0xD0C]={
  category="lo",
  description="MALAYALAM LETTER VOCALIC L",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD0C,
 },
 [0xD0E]={
  category="lo",
  description="MALAYALAM LETTER E",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD0E,
 },
 [0xD0F]={
  category="lo",
  description="MALAYALAM LETTER EE",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD0F,
 },
 [0xD10]={
  category="lo",
  description="MALAYALAM LETTER AI",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD10,
 },
 [0xD12]={
  category="lo",
  description="MALAYALAM LETTER O",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD12,
 },
 [0xD13]={
  category="lo",
  description="MALAYALAM LETTER OO",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD13,
 },
 [0xD14]={
  category="lo",
  description="MALAYALAM LETTER AU",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD14,
 },
 [0xD15]={
  category="lo",
  description="MALAYALAM LETTER KA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD15,
 },
 [0xD16]={
  category="lo",
  description="MALAYALAM LETTER KHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD16,
 },
 [0xD17]={
  category="lo",
  description="MALAYALAM LETTER GA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD17,
 },
 [0xD18]={
  category="lo",
  description="MALAYALAM LETTER GHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD18,
 },
 [0xD19]={
  category="lo",
  description="MALAYALAM LETTER NGA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD19,
 },
 [0xD1A]={
  category="lo",
  description="MALAYALAM LETTER CA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD1A,
 },
 [0xD1B]={
  category="lo",
  description="MALAYALAM LETTER CHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD1B,
 },
 [0xD1C]={
  category="lo",
  description="MALAYALAM LETTER JA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD1C,
 },
 [0xD1D]={
  category="lo",
  description="MALAYALAM LETTER JHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD1D,
 },
 [0xD1E]={
  category="lo",
  description="MALAYALAM LETTER NYA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD1E,
 },
 [0xD1F]={
  category="lo",
  description="MALAYALAM LETTER TTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD1F,
 },
 [0xD20]={
  category="lo",
  description="MALAYALAM LETTER TTHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD20,
 },
 [0xD21]={
  category="lo",
  description="MALAYALAM LETTER DDA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD21,
 },
 [0xD22]={
  category="lo",
  description="MALAYALAM LETTER DDHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD22,
 },
 [0xD23]={
  category="lo",
  description="MALAYALAM LETTER NNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD23,
 },
 [0xD24]={
  category="lo",
  description="MALAYALAM LETTER TA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD24,
 },
 [0xD25]={
  category="lo",
  description="MALAYALAM LETTER THA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD25,
 },
 [0xD26]={
  category="lo",
  description="MALAYALAM LETTER DA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD26,
 },
 [0xD27]={
  category="lo",
  description="MALAYALAM LETTER DHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD27,
 },
 [0xD28]={
  category="lo",
  description="MALAYALAM LETTER NA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD28,
 },
 [0xD29]={
  category="lo",
  description="MALAYALAM LETTER NNNA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD29,
 },
 [0xD2A]={
  category="lo",
  description="MALAYALAM LETTER PA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD2A,
 },
 [0xD2B]={
  category="lo",
  description="MALAYALAM LETTER PHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD2B,
 },
 [0xD2C]={
  category="lo",
  description="MALAYALAM LETTER BA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD2C,
 },
 [0xD2D]={
  category="lo",
  description="MALAYALAM LETTER BHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD2D,
 },
 [0xD2E]={
  category="lo",
  description="MALAYALAM LETTER MA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD2E,
 },
 [0xD2F]={
  category="lo",
  description="MALAYALAM LETTER YA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD2F,
 },
 [0xD30]={
  category="lo",
  description="MALAYALAM LETTER RA",
  direction="l",
  indic="c",
  indicclass="ra",
  indicorder="am",
  linebreak="al",
  unicodeslot=0xD30,
 },
 [0xD31]={
  category="lo",
  description="MALAYALAM LETTER RRA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD31,
 },
 [0xD32]={
  category="lo",
  description="MALAYALAM LETTER LA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD32,
 },
 [0xD33]={
  category="lo",
  description="MALAYALAM LETTER LLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD33,
 },
 [0xD34]={
  category="lo",
  description="MALAYALAM LETTER LLLA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD34,
 },
 [0xD35]={
  category="lo",
  description="MALAYALAM LETTER VA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD35,
 },
 [0xD36]={
  category="lo",
  description="MALAYALAM LETTER SHA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD36,
 },
 [0xD37]={
  category="lo",
  description="MALAYALAM LETTER SSA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD37,
 },
 [0xD38]={
  category="lo",
  description="MALAYALAM LETTER SA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD38,
 },
 [0xD39]={
  category="lo",
  description="MALAYALAM LETTER HA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD39,
 },
 [0xD3A]={
  category="lo",
  description="MALAYALAM LETTER TTTA",
  direction="l",
  indic="c",
  linebreak="al",
  unicodeslot=0xD3A,
 },
 [0xD3B]={
  category="mn",
  combining=0x9,
  description="MALAYALAM SIGN VERTICAL BAR VIRAMA",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xD3B,
 },
 [0xD3C]={
  category="mn",
  combining=0x9,
  description="MALAYALAM SIGN CIRCULAR VIRAMA",
  direction="nsm",
  indic="o",
  linebreak="cm",
  unicodeslot=0xD3C,
 },
 [0xD3D]={
  category="lo",
  description="MALAYALAM SIGN AVAGRAHA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD3D,
 },
 [0xD3E]={
  category="mc",
  description="MALAYALAM VOWEL SIGN AA",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xD3E,
 },
 [0xD3F]={
  category="mc",
  description="MALAYALAM VOWEL SIGN I",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xD3F,
 },
 [0xD40]={
  category="mc",
  description="MALAYALAM VOWEL SIGN II",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xD40,
 },
 [0xD41]={
  category="mn",
  description="MALAYALAM VOWEL SIGN U",
  direction="nsm",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xD41,
 },
 [0xD42]={
  category="mn",
  description="MALAYALAM VOWEL SIGN UU",
  direction="nsm",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xD42,
 },
 [0xD43]={
  category="mn",
  description="MALAYALAM VOWEL SIGN VOCALIC R",
  direction="nsm",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xD43,
 },
 [0xD44]={
  category="mn",
  description="MALAYALAM VOWEL SIGN VOCALIC RR",
  direction="nsm",
  indic="d",
  indicmark="r",
  linebreak="cm",
  unicodeslot=0xD44,
 },
 [0xD46]={
  category="mc",
  description="MALAYALAM VOWEL SIGN E",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bm",
  linebreak="cm",
  unicodeslot=0xD46,
 },
 [0xD47]={
  category="mc",
  description="MALAYALAM VOWEL SIGN EE",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bm",
  linebreak="cm",
  unicodeslot=0xD47,
 },
 [0xD48]={
  category="mc",
  description="MALAYALAM VOWEL SIGN AI",
  direction="l",
  indic="d",
  indicmark="l",
  indicorder="bm",
  linebreak="cm",
  unicodeslot=0xD48,
 },
 [0xD4A]={
  category="mc",
  description="MALAYALAM VOWEL SIGN O",
  direction="l",
  indic="d",
  indicmark="s",
  linebreak="cm",
  specials={ "char", 0xD46, 0xD3E },
  unicodeslot=0xD4A,
 },
 [0xD4B]={
  category="mc",
  description="MALAYALAM VOWEL SIGN OO",
  direction="l",
  indic="d",
  indicmark="s",
  linebreak="cm",
  specials={ "char", 0xD47, 0xD3E },
  unicodeslot=0xD4B,
 },
 [0xD4C]={
  category="mc",
  description="MALAYALAM VOWEL SIGN AU",
  direction="l",
  indic="d",
  indicmark="s",
  linebreak="cm",
  specials={ "char", 0xD46, 0xD57 },
  unicodeslot=0xD4C,
 },
 [0xD4D]={
  category="mn",
  combining=0x9,
  description="MALAYALAM SIGN VIRAMA",
  direction="nsm",
  indic="s",
  indicclass="halant",
  linebreak="cm",
  synonyms={ "malayalam chandrakkala", "malayalam vowel half-u" },
  unicodeslot=0xD4D,
 },
 [0xD4E]={
  category="lo",
  description="MALAYALAM LETTER DOT REPH",
  direction="l",
  indic="o",
  indicmark="t",
  linebreak="al",
  unicodeslot=0xD4E,
 },
 [0xD4F]={
  category="so",
  description="MALAYALAM SIGN PARA",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD4F,
 },
 [0xD54]={
  category="lo",
  description="MALAYALAM LETTER CHILLU M",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD54,
 },
 [0xD55]={
  category="lo",
  description="MALAYALAM LETTER CHILLU Y",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD55,
 },
 [0xD56]={
  category="lo",
  description="MALAYALAM LETTER CHILLU LLL",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD56,
 },
 [0xD57]={
  category="mc",
  description="MALAYALAM AU LENGTH MARK",
  direction="l",
  indic="d",
  indicmark="r",
  indicorder="ap",
  linebreak="cm",
  unicodeslot=0xD57,
 },
 [0xD58]={
  category="no",
  description="MALAYALAM FRACTION ONE ONE-HUNDRED-AND-SIXTIETH",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD58,
 },
 [0xD59]={
  category="no",
  description="MALAYALAM FRACTION ONE FORTIETH",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD59,
 },
 [0xD5A]={
  category="no",
  description="MALAYALAM FRACTION THREE EIGHTIETHS",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD5A,
 },
 [0xD5B]={
  category="no",
  description="MALAYALAM FRACTION ONE TWENTIETH",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD5B,
 },
 [0xD5C]={
  category="no",
  description="MALAYALAM FRACTION ONE TENTH",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD5C,
 },
 [0xD5D]={
  category="no",
  description="MALAYALAM FRACTION THREE TWENTIETHS",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD5D,
 },
 [0xD5E]={
  category="no",
  description="MALAYALAM FRACTION ONE FIFTH",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD5E,
 },
 [0xD5F]={
  category="lo",
  description="MALAYALAM LETTER ARCHAIC II",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD5F,
 },
 [0xD60]={
  category="lo",
  description="MALAYALAM LETTER VOCALIC RR",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD60,
 },
 [0xD61]={
  category="lo",
  description="MALAYALAM LETTER VOCALIC LL",
  direction="l",
  indic="i",
  linebreak="al",
  unicodeslot=0xD61,
 },
 [0xD62]={
  category="mn",
  description="MALAYALAM VOWEL SIGN VOCALIC L",
  direction="nsm",
  indic="d",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xD62,
 },
 [0xD63]={
  category="mn",
  description="MALAYALAM VOWEL SIGN VOCALIC LL",
  direction="nsm",
  indic="d",
  indicmark="b",
  linebreak="cm",
  unicodeslot=0xD63,
 },
 [0xD66]={
  category="nd",
  description="MALAYALAM DIGIT ZERO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD66,
 },
 [0xD67]={
  category="nd",
  description="MALAYALAM DIGIT ONE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD67,
 },
 [0xD68]={
  category="nd",
  description="MALAYALAM DIGIT TWO",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD68,
 },
 [0xD69]={
  category="nd",
  description="MALAYALAM DIGIT THREE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD69,
 },
 [0xD6A]={
  category="nd",
  description="MALAYALAM DIGIT FOUR",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD6A,
 },
 [0xD6B]={
  category="nd",
  description="MALAYALAM DIGIT FIVE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD6B,
 },
 [0xD6C]={
  category="nd",
  description="MALAYALAM DIGIT SIX",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD6C,
 },
 [0xD6D]={
  category="nd",
  description="MALAYALAM DIGIT SEVEN",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD6D,
 },
 [0xD6E]={
  category="nd",
  description="MALAYALAM DIGIT EIGHT",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD6E,
 },
 [0xD6F]={
  category="nd",
  description="MALAYALAM DIGIT NINE",
  direction="l",
  indic="o",
  linebreak="nu",
  unicodeslot=0xD6F,
 },
 [0xD70]={
  category="no",
  description="MALAYALAM NUMBER TEN",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD70,
 },
 [0xD71]={
  category="no",
  description="MALAYALAM NUMBER ONE HUNDRED",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD71,
 },
 [0xD72]={
  category="no",
  description="MALAYALAM NUMBER ONE THOUSAND",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD72,
 },
 [0xD73]={
  category="no",
  description="MALAYALAM FRACTION ONE QUARTER",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD73,
 },
 [0xD74]={
  category="no",
  description="MALAYALAM FRACTION ONE HALF",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD74,
 },
 [0xD75]={
  category="no",
  description="MALAYALAM FRACTION THREE QUARTERS",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD75,
 },
 [0xD76]={
  category="no",
  description="MALAYALAM FRACTION ONE SIXTEENTH",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD76,
 },
 [0xD77]={
  category="no",
  description="MALAYALAM FRACTION ONE EIGHTH",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD77,
 },
 [0xD78]={
  category="no",
  description="MALAYALAM FRACTION THREE SIXTEENTHS",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD78,
 },
 [0xD79]={
  category="so",
  description="MALAYALAM DATE MARK",
  direction="l",
  indic="o",
  linebreak="po",
  unicodeslot=0xD79,
 },
 [0xD7A]={
  category="lo",
  description="MALAYALAM LETTER CHILLU NN",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD7A,
 },
 [0xD7B]={
  category="lo",
  description="MALAYALAM LETTER CHILLU N",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD7B,
 },
 [0xD7C]={
  category="lo",
  description="MALAYALAM LETTER CHILLU RR",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD7C,
 },
 [0xD7D]={
  category="lo",
  description="MALAYALAM LETTER CHILLU L",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD7D,
 },
 [0xD7E]={
  category="lo",
  description="MALAYALAM LETTER CHILLU LL",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD7E,
 },
 [0xD7F]={
  category="lo",
  description="MALAYALAM LETTER CHILLU K",
  direction="l",
  indic="o",
  linebreak="al",
  unicodeslot=0xD7F,
 },
 [0xD82]={
  category="mc",
  description="SINHALA SIGN ANUSVARAYA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xD82,
 },
 [0xD83]={
  category="mc",
  description="SINHALA SIGN VISARGAYA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xD83,
 },
 [0xD85]={
  category="lo",
  description="SINHALA LETTER AYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD85,
 },
 [0xD86]={
  category="lo",
  description="SINHALA LETTER AAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD86,
 },
 [0xD87]={
  category="lo",
  description="SINHALA LETTER AEYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD87,
 },
 [0xD88]={
  category="lo",
  description="SINHALA LETTER AEEYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD88,
 },
 [0xD89]={
  category="lo",
  description="SINHALA LETTER IYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD89,
 },
 [0xD8A]={
  category="lo",
  description="SINHALA LETTER IIYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD8A,
 },
 [0xD8B]={
  category="lo",
  description="SINHALA LETTER UYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD8B,
 },
 [0xD8C]={
  category="lo",
  description="SINHALA LETTER UUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD8C,
 },
 [0xD8D]={
  category="lo",
  description="SINHALA LETTER IRUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD8D,
 },
 [0xD8E]={
  category="lo",
  description="SINHALA LETTER IRUUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD8E,
 },
 [0xD8F]={
  category="lo",
  description="SINHALA LETTER ILUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD8F,
 },
 [0xD90]={
  category="lo",
  description="SINHALA LETTER ILUUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD90,
 },
 [0xD91]={
  category="lo",
  description="SINHALA LETTER EYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD91,
 },
 [0xD92]={
  category="lo",
  description="SINHALA LETTER EEYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD92,
 },
 [0xD93]={
  category="lo",
  description="SINHALA LETTER AIYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD93,
 },
 [0xD94]={
  category="lo",
  description="SINHALA LETTER OYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD94,
 },
 [0xD95]={
  category="lo",
  description="SINHALA LETTER OOYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD95,
 },
 [0xD96]={
  category="lo",
  description="SINHALA LETTER AUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD96,
 },
 [0xD9A]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA KAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD9A,
 },
 [0xD9B]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA KAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD9B,
 },
 [0xD9C]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA GAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD9C,
 },
 [0xD9D]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA GAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD9D,
 },
 [0xD9E]={
  category="lo",
  description="SINHALA LETTER KANTAJA NAASIKYAYA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD9E,
 },
 [0xD9F]={
  category="lo",
  description="SINHALA LETTER SANYAKA GAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xD9F,
 },
 [0xDA0]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA CAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA0,
 },
 [0xDA1]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA CAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA1,
 },
 [0xDA2]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA JAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA2,
 },
 [0xDA3]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA JAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA3,
 },
 [0xDA4]={
  category="lo",
  description="SINHALA LETTER TAALUJA NAASIKYAYA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA4,
 },
 [0xDA5]={
  category="lo",
  description="SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA5,
 },
 [0xDA6]={
  category="lo",
  description="SINHALA LETTER SANYAKA JAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA6,
 },
 [0xDA7]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA TTAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA7,
 },
 [0xDA8]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA TTAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA8,
 },
 [0xDA9]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA DDAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDA9,
 },
 [0xDAA]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA DDAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDAA,
 },
 [0xDAB]={
  category="lo",
  description="SINHALA LETTER MUURDHAJA NAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDAB,
 },
 [0xDAC]={
  category="lo",
  description="SINHALA LETTER SANYAKA DDAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDAC,
 },
 [0xDAD]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA TAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDAD,
 },
 [0xDAE]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA TAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDAE,
 },
 [0xDAF]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA DAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDAF,
 },
 [0xDB0]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA DAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDB0,
 },
 [0xDB1]={
  category="lo",
  description="SINHALA LETTER DANTAJA NAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDB1,
 },
 [0xDB3]={
  category="lo",
  description="SINHALA LETTER SANYAKA DAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDB3,
 },
 [0xDB4]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA PAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDB4,
 },
 [0xDB5]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA PAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDB5,
 },
 [0xDB6]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA BAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDB6,
 },
 [0xDB7]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA BAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDB7,
 },
 [0xDB8]={
  category="lo",
  description="SINHALA LETTER MAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDB8,
 },
 [0xDB9]={
  category="lo",
  description="SINHALA LETTER AMBA BAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDB9,
 },
 [0xDBA]={
  category="lo",
  description="SINHALA LETTER YAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDBA,
 },
 [0xDBB]={
  category="lo",
  description="SINHALA LETTER RAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDBB,
 },
 [0xDBD]={
  category="lo",
  description="SINHALA LETTER DANTAJA LAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDBD,
 },
 [0xDC0]={
  category="lo",
  description="SINHALA LETTER VAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDC0,
 },
 [0xDC1]={
  category="lo",
  description="SINHALA LETTER TAALUJA SAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDC1,
 },
 [0xDC2]={
  category="lo",
  description="SINHALA LETTER MUURDHAJA SAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDC2,
 },
 [0xDC3]={
  category="lo",
  description="SINHALA LETTER DANTAJA SAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDC3,
 },
 [0xDC4]={
  category="lo",
  description="SINHALA LETTER HAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDC4,
 },
 [0xDC5]={
  category="lo",
  description="SINHALA LETTER MUURDHAJA LAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDC5,
 },
 [0xDC6]={
  category="lo",
  description="SINHALA LETTER FAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDC6,
 },
 [0xDCA]={
  category="mn",
  combining=0x9,
  description="SINHALA SIGN AL-LAKUNA",
  direction="nsm",
  linebreak="cm",
  synonyms={ "sinhala virama" },
  unicodeslot=0xDCA,
 },
 [0xDCF]={
  category="mc",
  description="SINHALA VOWEL SIGN AELA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xDCF,
 },
 [0xDD0]={
  category="mc",
  description="SINHALA VOWEL SIGN KETTI AEDA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xDD0,
 },
 [0xDD1]={
  category="mc",
  description="SINHALA VOWEL SIGN DIGA AEDA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xDD1,
 },
 [0xDD2]={
  category="mn",
  description="SINHALA VOWEL SIGN KETTI IS-PILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xDD2,
 },
 [0xDD3]={
  category="mn",
  description="SINHALA VOWEL SIGN DIGA IS-PILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xDD3,
 },
 [0xDD4]={
  category="mn",
  description="SINHALA VOWEL SIGN KETTI PAA-PILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xDD4,
 },
 [0xDD6]={
  category="mn",
  description="SINHALA VOWEL SIGN DIGA PAA-PILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xDD6,
 },
 [0xDD8]={
  category="mc",
  description="SINHALA VOWEL SIGN GAETTA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xDD8,
 },
 [0xDD9]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBUVA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xDD9,
 },
 [0xDDA]={
  category="mc",
  description="SINHALA VOWEL SIGN DIGA KOMBUVA",
  direction="l",
  linebreak="cm",
  specials={ "char", 0xDD9, 0xDCA },
  unicodeslot=0xDDA,
 },
 [0xDDB]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBU DEKA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xDDB,
 },
 [0xDDC]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA",
  direction="l",
  linebreak="cm",
  specials={ "char", 0xDD9, 0xDCF },
  unicodeslot=0xDDC,
 },
 [0xDDD]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA",
  direction="l",
  linebreak="cm",
  specials={ "char", 0xDDC, 0xDCA },
  unicodeslot=0xDDD,
 },
 [0xDDE]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA",
  direction="l",
  linebreak="cm",
  specials={ "char", 0xDD9, 0xDDF },
  unicodeslot=0xDDE,
 },
 [0xDDF]={
  category="mc",
  description="SINHALA VOWEL SIGN GAYANUKITTA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xDDF,
 },
 [0xDE6]={
  category="nd",
  description="SINHALA LITH DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDE6,
 },
 [0xDE7]={
  category="nd",
  description="SINHALA LITH DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDE7,
 },
 [0xDE8]={
  category="nd",
  description="SINHALA LITH DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDE8,
 },
 [0xDE9]={
  category="nd",
  description="SINHALA LITH DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDE9,
 },
 [0xDEA]={
  category="nd",
  description="SINHALA LITH DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDEA,
 },
 [0xDEB]={
  category="nd",
  description="SINHALA LITH DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDEB,
 },
 [0xDEC]={
  category="nd",
  description="SINHALA LITH DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDEC,
 },
 [0xDED]={
  category="nd",
  description="SINHALA LITH DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDED,
 },
 [0xDEE]={
  category="nd",
  description="SINHALA LITH DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDEE,
 },
 [0xDEF]={
  category="nd",
  description="SINHALA LITH DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xDEF,
 },
 [0xDF2]={
  category="mc",
  description="SINHALA VOWEL SIGN DIGA GAETTA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xDF2,
 },
 [0xDF3]={
  category="mc",
  description="SINHALA VOWEL SIGN DIGA GAYANUKITTA",
  direction="l",
  linebreak="cm",
  unicodeslot=0xDF3,
 },
 [0xDF4]={
  category="po",
  description="SINHALA PUNCTUATION KUNDDALIYA",
  direction="l",
  linebreak="al",
  unicodeslot=0xDF4,
 },
 [0xE01]={
  adobename="kokaithai",
  category="lo",
  description="THAI CHARACTER KO KAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE01,
 },
 [0xE02]={
  adobename="khokhaithai",
  category="lo",
  description="THAI CHARACTER KHO KHAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE02,
 },
 [0xE03]={
  adobename="khokhuatthai",
  category="lo",
  description="THAI CHARACTER KHO KHUAT",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE03,
 },
 [0xE04]={
  adobename="khokhwaithai",
  category="lo",
  description="THAI CHARACTER KHO KHWAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE04,
 },
 [0xE05]={
  adobename="khokhonthai",
  category="lo",
  description="THAI CHARACTER KHO KHON",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE05,
 },
 [0xE06]={
  adobename="khorakhangthai",
  category="lo",
  description="THAI CHARACTER KHO RAKHANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE06,
 },
 [0xE07]={
  adobename="ngonguthai",
  category="lo",
  description="THAI CHARACTER NGO NGU",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE07,
 },
 [0xE08]={
  adobename="chochanthai",
  category="lo",
  description="THAI CHARACTER CHO CHAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE08,
 },
 [0xE09]={
  adobename="chochingthai",
  category="lo",
  description="THAI CHARACTER CHO CHING",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE09,
 },
 [0xE0A]={
  adobename="chochangthai",
  category="lo",
  description="THAI CHARACTER CHO CHANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE0A,
 },
 [0xE0B]={
  adobename="sosothai",
  category="lo",
  description="THAI CHARACTER SO SO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE0B,
 },
 [0xE0C]={
  adobename="chochoethai",
  category="lo",
  description="THAI CHARACTER CHO CHOE",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE0C,
 },
 [0xE0D]={
  adobename="yoyingthai",
  category="lo",
  description="THAI CHARACTER YO YING",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE0D,
 },
 [0xE0E]={
  adobename="dochadathai",
  category="lo",
  description="THAI CHARACTER DO CHADA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE0E,
 },
 [0xE0F]={
  adobename="topatakthai",
  category="lo",
  description="THAI CHARACTER TO PATAK",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE0F,
 },
 [0xE10]={
  adobename="thothanthai",
  category="lo",
  description="THAI CHARACTER THO THAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE10,
 },
 [0xE11]={
  adobename="thonangmonthothai",
  category="lo",
  description="THAI CHARACTER THO NANGMONTHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE11,
 },
 [0xE12]={
  adobename="thophuthaothai",
  category="lo",
  description="THAI CHARACTER THO PHUTHAO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE12,
 },
 [0xE13]={
  adobename="nonenthai",
  category="lo",
  description="THAI CHARACTER NO NEN",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE13,
 },
 [0xE14]={
  adobename="dodekthai",
  category="lo",
  description="THAI CHARACTER DO DEK",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE14,
 },
 [0xE15]={
  adobename="totaothai",
  category="lo",
  description="THAI CHARACTER TO TAO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE15,
 },
 [0xE16]={
  adobename="thothungthai",
  category="lo",
  description="THAI CHARACTER THO THUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE16,
 },
 [0xE17]={
  adobename="thothahanthai",
  category="lo",
  description="THAI CHARACTER THO THAHAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE17,
 },
 [0xE18]={
  adobename="thothongthai",
  category="lo",
  description="THAI CHARACTER THO THONG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE18,
 },
 [0xE19]={
  adobename="nonuthai",
  category="lo",
  description="THAI CHARACTER NO NU",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE19,
 },
 [0xE1A]={
  adobename="bobaimaithai",
  category="lo",
  description="THAI CHARACTER BO BAIMAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE1A,
 },
 [0xE1B]={
  adobename="poplathai",
  category="lo",
  description="THAI CHARACTER PO PLA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE1B,
 },
 [0xE1C]={
  adobename="phophungthai",
  category="lo",
  description="THAI CHARACTER PHO PHUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE1C,
 },
 [0xE1D]={
  adobename="fofathai",
  category="lo",
  description="THAI CHARACTER FO FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE1D,
 },
 [0xE1E]={
  adobename="phophanthai",
  category="lo",
  description="THAI CHARACTER PHO PHAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE1E,
 },
 [0xE1F]={
  adobename="fofanthai",
  category="lo",
  description="THAI CHARACTER FO FAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE1F,
 },
 [0xE20]={
  adobename="phosamphaothai",
  category="lo",
  description="THAI CHARACTER PHO SAMPHAO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE20,
 },
 [0xE21]={
  adobename="momathai",
  category="lo",
  description="THAI CHARACTER MO MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE21,
 },
 [0xE22]={
  adobename="yoyakthai",
  category="lo",
  description="THAI CHARACTER YO YAK",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE22,
 },
 [0xE23]={
  adobename="roruathai",
  category="lo",
  description="THAI CHARACTER RO RUA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE23,
 },
 [0xE24]={
  adobename="ruthai",
  category="lo",
  description="THAI CHARACTER RU",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE24,
 },
 [0xE25]={
  adobename="lolingthai",
  category="lo",
  description="THAI CHARACTER LO LING",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE25,
 },
 [0xE26]={
  adobename="luthai",
  category="lo",
  description="THAI CHARACTER LU",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE26,
 },
 [0xE27]={
  adobename="wowaenthai",
  category="lo",
  description="THAI CHARACTER WO WAEN",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE27,
 },
 [0xE28]={
  adobename="sosalathai",
  category="lo",
  description="THAI CHARACTER SO SALA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE28,
 },
 [0xE29]={
  adobename="sorusithai",
  category="lo",
  description="THAI CHARACTER SO RUSI",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE29,
 },
 [0xE2A]={
  adobename="sosuathai",
  category="lo",
  description="THAI CHARACTER SO SUA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE2A,
 },
 [0xE2B]={
  adobename="hohipthai",
  category="lo",
  description="THAI CHARACTER HO HIP",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE2B,
 },
 [0xE2C]={
  adobename="lochulathai",
  category="lo",
  description="THAI CHARACTER LO CHULA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE2C,
 },
 [0xE2D]={
  adobename="oangthai",
  category="lo",
  description="THAI CHARACTER O ANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE2D,
 },
 [0xE2E]={
  adobename="honokhukthai",
  category="lo",
  description="THAI CHARACTER HO NOKHUK",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE2E,
 },
 [0xE2F]={
  adobename="paiyannoithai",
  category="lo",
  description="THAI CHARACTER PAIYANNOI",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE2F,
 },
 [0xE30]={
  adobename="saraathai",
  category="lo",
  description="THAI CHARACTER SARA A",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE30,
 },
 [0xE31]={
  adobename="maihanakatthai",
  category="mn",
  description="THAI CHARACTER MAI HAN-AKAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE31,
 },
 [0xE32]={
  adobename="saraaathai",
  category="lo",
  description="THAI CHARACTER SARA AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE32,
 },
 [0xE33]={
  adobename="saraamthai",
  category="lo",
  description="THAI CHARACTER SARA AM",
  direction="l",
  linebreak="sa",
  specials={ "compat", 0xE4D, 0xE32 },
  unicodeslot=0xE33,
 },
 [0xE34]={
  adobename="saraithai",
  category="mn",
  description="THAI CHARACTER SARA I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE34,
 },
 [0xE35]={
  adobename="saraiithai",
  category="mn",
  description="THAI CHARACTER SARA II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE35,
 },
 [0xE36]={
  adobename="sarauethai",
  category="mn",
  description="THAI CHARACTER SARA UE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE36,
 },
 [0xE37]={
  adobename="saraueethai",
  category="mn",
  description="THAI CHARACTER SARA UEE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE37,
 },
 [0xE38]={
  adobename="sarauthai",
  category="mn",
  combining=0x67,
  description="THAI CHARACTER SARA U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE38,
 },
 [0xE39]={
  adobename="sarauuthai",
  category="mn",
  combining=0x67,
  description="THAI CHARACTER SARA UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE39,
 },
 [0xE3A]={
  adobename="phinthuthai",
  category="mn",
  combining=0x9,
  description="THAI CHARACTER PHINTHU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE3A,
 },
 [0xE3F]={
  adobename="bahtthai",
  category="sc",
  description="THAI CURRENCY SYMBOL BAHT",
  direction="et",
  linebreak="pr",
  unicodeslot=0xE3F,
 },
 [0xE40]={
  adobename="saraethai",
  category="lo",
  description="THAI CHARACTER SARA E",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE40,
 },
 [0xE41]={
  adobename="saraaethai",
  category="lo",
  description="THAI CHARACTER SARA AE",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE41,
 },
 [0xE42]={
  adobename="saraothai",
  category="lo",
  description="THAI CHARACTER SARA O",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE42,
 },
 [0xE43]={
  adobename="saraaimaimuanthai",
  category="lo",
  description="THAI CHARACTER SARA AI MAIMUAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE43,
 },
 [0xE44]={
  adobename="saraaimaimalaithai",
  category="lo",
  description="THAI CHARACTER SARA AI MAIMALAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE44,
 },
 [0xE45]={
  adobename="lakkhangyaothai",
  category="lo",
  description="THAI CHARACTER LAKKHANGYAO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE45,
 },
 [0xE46]={
  adobename="maiyamokthai",
  category="lm",
  description="THAI CHARACTER MAIYAMOK",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE46,
 },
 [0xE47]={
  adobename="maitaikhuthai",
  category="mn",
  description="THAI CHARACTER MAITAIKHU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE47,
 },
 [0xE48]={
  adobename="maiekthai",
  category="mn",
  combining=0x6B,
  description="THAI CHARACTER MAI EK",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE48,
 },
 [0xE49]={
  adobename="maithothai",
  category="mn",
  combining=0x6B,
  description="THAI CHARACTER MAI THO",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE49,
 },
 [0xE4A]={
  adobename="maitrithai",
  category="mn",
  combining=0x6B,
  description="THAI CHARACTER MAI TRI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE4A,
 },
 [0xE4B]={
  adobename="maichattawathai",
  category="mn",
  combining=0x6B,
  description="THAI CHARACTER MAI CHATTAWA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE4B,
 },
 [0xE4C]={
  adobename="thanthakhatthai",
  category="mn",
  description="THAI CHARACTER THANTHAKHAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE4C,
 },
 [0xE4D]={
  adobename="nikhahitthai",
  category="mn",
  description="THAI CHARACTER NIKHAHIT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE4D,
 },
 [0xE4E]={
  adobename="yamakkanthai",
  category="mn",
  description="THAI CHARACTER YAMAKKAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xE4E,
 },
 [0xE4F]={
  adobename="fongmanthai",
  category="po",
  description="THAI CHARACTER FONGMAN",
  direction="l",
  linebreak="al",
  unicodeslot=0xE4F,
 },
 [0xE50]={
  adobename="zerothai",
  category="nd",
  description="THAI DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE50,
 },
 [0xE51]={
  adobename="onethai",
  category="nd",
  description="THAI DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE51,
 },
 [0xE52]={
  adobename="twothai",
  category="nd",
  description="THAI DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE52,
 },
 [0xE53]={
  adobename="threethai",
  category="nd",
  description="THAI DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE53,
 },
 [0xE54]={
  adobename="fourthai",
  category="nd",
  description="THAI DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE54,
 },
 [0xE55]={
  adobename="fivethai",
  category="nd",
  description="THAI DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE55,
 },
 [0xE56]={
  adobename="sixthai",
  category="nd",
  description="THAI DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE56,
 },
 [0xE57]={
  adobename="seventhai",
  category="nd",
  description="THAI DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE57,
 },
 [0xE58]={
  adobename="eightthai",
  category="nd",
  description="THAI DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE58,
 },
 [0xE59]={
  adobename="ninethai",
  category="nd",
  description="THAI DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xE59,
 },
 [0xE5A]={
  adobename="angkhankhuthai",
  category="po",
  description="THAI CHARACTER ANGKHANKHU",
  direction="l",
  linebreak="ba",
  unicodeslot=0xE5A,
 },
 [0xE5B]={
  adobename="khomutthai",
  category="po",
  description="THAI CHARACTER KHOMUT",
  direction="l",
  linebreak="ba",
  unicodeslot=0xE5B,
 },
 [0xE81]={
  category="lo",
  description="LAO LETTER KO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE81,
 },
 [0xE82]={
  category="lo",
  description="LAO LETTER KHO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE82,
 },
 [0xE84]={
  category="lo",
  description="LAO LETTER KHO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE84,
 },
 [0xE87]={
  category="lo",
  description="LAO LETTER NGO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE87,
 },
 [0xE88]={
  category="lo",
  description="LAO LETTER CO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE88,
 },
 [0xE8A]={
  category="lo",
  description="LAO LETTER SO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE8A,
 },
 [0xE8D]={
  category="lo",
  description="LAO LETTER NYO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE8D,
 },
 [0xE94]={
  category="lo",
  description="LAO LETTER DO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE94,
 },
 [0xE95]={
  category="lo",
  description="LAO LETTER TO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE95,
 },
 [0xE96]={
  category="lo",
  description="LAO LETTER THO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE96,
 },
 [0xE97]={
  category="lo",
  description="LAO LETTER THO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE97,
 },
 [0xE99]={
  category="lo",
  description="LAO LETTER NO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE99,
 },
 [0xE9A]={
  category="lo",
  description="LAO LETTER BO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE9A,
 },
 [0xE9B]={
  category="lo",
  description="LAO LETTER PO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE9B,
 },
 [0xE9C]={
  category="lo",
  description="LAO LETTER PHO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE9C,
 },
 [0xE9D]={
  category="lo",
  description="LAO LETTER FO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE9D,
 },
 [0xE9E]={
  category="lo",
  description="LAO LETTER PHO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE9E,
 },
 [0xE9F]={
  category="lo",
  description="LAO LETTER FO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xE9F,
 },
 [0xEA1]={
  category="lo",
  description="LAO LETTER MO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEA1,
 },
 [0xEA2]={
  category="lo",
  description="LAO LETTER YO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEA2,
 },
 [0xEA3]={
  category="lo",
  description="LAO LETTER LO LING",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEA3,
 },
 [0xEA5]={
  category="lo",
  description="LAO LETTER LO LOOT",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEA5,
 },
 [0xEA7]={
  category="lo",
  description="LAO LETTER WO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEA7,
 },
 [0xEAA]={
  category="lo",
  description="LAO LETTER SO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEAA,
 },
 [0xEAB]={
  category="lo",
  description="LAO LETTER HO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEAB,
 },
 [0xEAD]={
  category="lo",
  description="LAO LETTER O",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEAD,
 },
 [0xEAE]={
  category="lo",
  description="LAO LETTER HO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEAE,
 },
 [0xEAF]={
  category="lo",
  description="LAO ELLIPSIS",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEAF,
 },
 [0xEB0]={
  category="lo",
  description="LAO VOWEL SIGN A",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEB0,
 },
 [0xEB1]={
  category="mn",
  description="LAO VOWEL SIGN MAI KAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEB1,
 },
 [0xEB2]={
  category="lo",
  description="LAO VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEB2,
 },
 [0xEB3]={
  category="lo",
  description="LAO VOWEL SIGN AM",
  direction="l",
  linebreak="sa",
  specials={ "compat", 0xECD, 0xEB2 },
  unicodeslot=0xEB3,
 },
 [0xEB4]={
  category="mn",
  description="LAO VOWEL SIGN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEB4,
 },
 [0xEB5]={
  category="mn",
  description="LAO VOWEL SIGN II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEB5,
 },
 [0xEB6]={
  category="mn",
  description="LAO VOWEL SIGN Y",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEB6,
 },
 [0xEB7]={
  category="mn",
  description="LAO VOWEL SIGN YY",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEB7,
 },
 [0xEB8]={
  category="mn",
  combining=0x76,
  description="LAO VOWEL SIGN U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEB8,
 },
 [0xEB9]={
  category="mn",
  combining=0x76,
  description="LAO VOWEL SIGN UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEB9,
 },
 [0xEBB]={
  category="mn",
  description="LAO VOWEL SIGN MAI KON",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEBB,
 },
 [0xEBC]={
  category="mn",
  description="LAO SEMIVOWEL SIGN LO",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEBC,
 },
 [0xEBD]={
  category="lo",
  description="LAO SEMIVOWEL SIGN NYO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEBD,
 },
 [0xEC0]={
  category="lo",
  description="LAO VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEC0,
 },
 [0xEC1]={
  category="lo",
  description="LAO VOWEL SIGN EI",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEC1,
 },
 [0xEC2]={
  category="lo",
  description="LAO VOWEL SIGN O",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEC2,
 },
 [0xEC3]={
  category="lo",
  description="LAO VOWEL SIGN AY",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEC3,
 },
 [0xEC4]={
  category="lo",
  description="LAO VOWEL SIGN AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEC4,
 },
 [0xEC6]={
  category="lm",
  description="LAO KO LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEC6,
 },
 [0xEC8]={
  category="mn",
  combining=0x7A,
  description="LAO TONE MAI EK",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEC8,
 },
 [0xEC9]={
  category="mn",
  combining=0x7A,
  description="LAO TONE MAI THO",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xEC9,
 },
 [0xECA]={
  category="mn",
  combining=0x7A,
  description="LAO TONE MAI TI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xECA,
 },
 [0xECB]={
  category="mn",
  combining=0x7A,
  description="LAO TONE MAI CATAWA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xECB,
 },
 [0xECC]={
  category="mn",
  description="LAO CANCELLATION MARK",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xECC,
 },
 [0xECD]={
  category="mn",
  description="LAO NIGGAHITA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0xECD,
 },
 [0xED0]={
  category="nd",
  description="LAO DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED0,
 },
 [0xED1]={
  category="nd",
  description="LAO DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED1,
 },
 [0xED2]={
  category="nd",
  description="LAO DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED2,
 },
 [0xED3]={
  category="nd",
  description="LAO DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED3,
 },
 [0xED4]={
  category="nd",
  description="LAO DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED4,
 },
 [0xED5]={
  category="nd",
  description="LAO DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED5,
 },
 [0xED6]={
  category="nd",
  description="LAO DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED6,
 },
 [0xED7]={
  category="nd",
  description="LAO DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED7,
 },
 [0xED8]={
  category="nd",
  description="LAO DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED8,
 },
 [0xED9]={
  category="nd",
  description="LAO DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xED9,
 },
 [0xEDC]={
  category="lo",
  description="LAO HO NO",
  direction="l",
  linebreak="sa",
  specials={ "compat", 0xEAB, 0xE99 },
  unicodeslot=0xEDC,
 },
 [0xEDD]={
  category="lo",
  description="LAO HO MO",
  direction="l",
  linebreak="sa",
  specials={ "compat", 0xEAB, 0xEA1 },
  unicodeslot=0xEDD,
 },
 [0xEDE]={
  category="lo",
  description="LAO LETTER KHMU GO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEDE,
 },
 [0xEDF]={
  category="lo",
  description="LAO LETTER KHMU NYO",
  direction="l",
  linebreak="sa",
  unicodeslot=0xEDF,
 },
 [0xF00]={
  category="lo",
  description="TIBETAN SYLLABLE OM",
  direction="l",
  linebreak="al",
  unicodeslot=0xF00,
 },
 [0xF01]={
  category="so",
  description="TIBETAN MARK GTER YIG MGO TRUNCATED A",
  direction="l",
  linebreak="bb",
  unicodeslot=0xF01,
 },
 [0xF02]={
  category="so",
  description="TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0xF02,
 },
 [0xF03]={
  category="so",
  description="TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0xF03,
 },
 [0xF04]={
  category="po",
  description="TIBETAN MARK INITIAL YIG MGO MDUN MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0xF04,
 },
 [0xF05]={
  category="po",
  description="TIBETAN MARK CLOSING YIG MGO SGAB MA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF05,
 },
 [0xF06]={
  category="po",
  description="TIBETAN MARK CARET YIG MGO PHUR SHAD MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0xF06,
 },
 [0xF07]={
  category="po",
  description="TIBETAN MARK YIG MGO TSHEG SHAD MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0xF07,
 },
 [0xF08]={
  category="po",
  description="TIBETAN MARK SBRUL SHAD",
  direction="l",
  linebreak="gl",
  unicodeslot=0xF08,
 },
 [0xF09]={
  category="po",
  description="TIBETAN MARK BSKUR YIG MGO",
  direction="l",
  linebreak="bb",
  unicodeslot=0xF09,
 },
 [0xF0A]={
  category="po",
  description="TIBETAN MARK BKA- SHOG YIG MGO",
  direction="l",
  linebreak="bb",
  unicodeslot=0xF0A,
 },
 [0xF0B]={
  category="po",
  description="TIBETAN MARK INTERSYLLABIC TSHEG",
  direction="l",
  linebreak="ba",
  unicodeslot=0xF0B,
 },
 [0xF0C]={
  category="po",
  description="TIBETAN MARK DELIMITER TSHEG BSTAR",
  direction="l",
  linebreak="gl",
  specials={ "nobreak", 0xF0B },
  unicodeslot=0xF0C,
 },
 [0xF0D]={
  category="po",
  description="TIBETAN MARK SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0xF0D,
 },
 [0xF0E]={
  category="po",
  description="TIBETAN MARK NYIS SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0xF0E,
 },
 [0xF0F]={
  category="po",
  description="TIBETAN MARK TSHEG SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0xF0F,
 },
 [0xF10]={
  category="po",
  description="TIBETAN MARK NYIS TSHEG SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0xF10,
 },
 [0xF11]={
  category="po",
  description="TIBETAN MARK RIN CHEN SPUNGS SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0xF11,
 },
 [0xF12]={
  category="po",
  description="TIBETAN MARK RGYA GRAM SHAD",
  direction="l",
  linebreak="gl",
  unicodeslot=0xF12,
 },
 [0xF13]={
  category="so",
  description="TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0xF13,
 },
 [0xF14]={
  category="so",
  description="TIBETAN MARK GTER TSHEG",
  direction="l",
  linebreak="ex",
  unicodeslot=0xF14,
 },
 [0xF15]={
  category="so",
  description="TIBETAN LOGOTYPE SIGN CHAD RTAGS",
  direction="l",
  linebreak="al",
  unicodeslot=0xF15,
 },
 [0xF16]={
  category="so",
  description="TIBETAN LOGOTYPE SIGN LHAG RTAGS",
  direction="l",
  linebreak="al",
  unicodeslot=0xF16,
 },
 [0xF17]={
  category="so",
  description="TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS",
  direction="l",
  linebreak="al",
  unicodeslot=0xF17,
 },
 [0xF18]={
  category="mn",
  combining=0xDC,
  description="TIBETAN ASTROLOGICAL SIGN -KHYUD PA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF18,
 },
 [0xF19]={
  category="mn",
  combining=0xDC,
  description="TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF19,
 },
 [0xF1A]={
  category="so",
  description="TIBETAN SIGN RDEL DKAR GCIG",
  direction="l",
  linebreak="al",
  unicodeslot=0xF1A,
 },
 [0xF1B]={
  category="so",
  description="TIBETAN SIGN RDEL DKAR GNYIS",
  direction="l",
  linebreak="al",
  unicodeslot=0xF1B,
 },
 [0xF1C]={
  category="so",
  description="TIBETAN SIGN RDEL DKAR GSUM",
  direction="l",
  linebreak="al",
  unicodeslot=0xF1C,
 },
 [0xF1D]={
  category="so",
  description="TIBETAN SIGN RDEL NAG GCIG",
  direction="l",
  linebreak="al",
  unicodeslot=0xF1D,
 },
 [0xF1E]={
  category="so",
  description="TIBETAN SIGN RDEL NAG GNYIS",
  direction="l",
  linebreak="al",
  unicodeslot=0xF1E,
 },
 [0xF1F]={
  category="so",
  description="TIBETAN SIGN RDEL DKAR RDEL NAG",
  direction="l",
  linebreak="al",
  unicodeslot=0xF1F,
 },
 [0xF20]={
  category="nd",
  description="TIBETAN DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF20,
 },
 [0xF21]={
  category="nd",
  description="TIBETAN DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF21,
 },
 [0xF22]={
  category="nd",
  description="TIBETAN DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF22,
 },
 [0xF23]={
  category="nd",
  description="TIBETAN DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF23,
 },
 [0xF24]={
  category="nd",
  description="TIBETAN DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF24,
 },
 [0xF25]={
  category="nd",
  description="TIBETAN DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF25,
 },
 [0xF26]={
  category="nd",
  description="TIBETAN DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF26,
 },
 [0xF27]={
  category="nd",
  description="TIBETAN DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF27,
 },
 [0xF28]={
  category="nd",
  description="TIBETAN DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF28,
 },
 [0xF29]={
  category="nd",
  description="TIBETAN DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0xF29,
 },
 [0xF2A]={
  category="no",
  description="TIBETAN DIGIT HALF ONE",
  direction="l",
  linebreak="al",
  unicodeslot=0xF2A,
 },
 [0xF2B]={
  category="no",
  description="TIBETAN DIGIT HALF TWO",
  direction="l",
  linebreak="al",
  unicodeslot=0xF2B,
 },
 [0xF2C]={
  category="no",
  description="TIBETAN DIGIT HALF THREE",
  direction="l",
  linebreak="al",
  unicodeslot=0xF2C,
 },
 [0xF2D]={
  category="no",
  description="TIBETAN DIGIT HALF FOUR",
  direction="l",
  linebreak="al",
  unicodeslot=0xF2D,
 },
 [0xF2E]={
  category="no",
  description="TIBETAN DIGIT HALF FIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0xF2E,
 },
 [0xF2F]={
  category="no",
  description="TIBETAN DIGIT HALF SIX",
  direction="l",
  linebreak="al",
  unicodeslot=0xF2F,
 },
 [0xF30]={
  category="no",
  description="TIBETAN DIGIT HALF SEVEN",
  direction="l",
  linebreak="al",
  unicodeslot=0xF30,
 },
 [0xF31]={
  category="no",
  description="TIBETAN DIGIT HALF EIGHT",
  direction="l",
  linebreak="al",
  unicodeslot=0xF31,
 },
 [0xF32]={
  category="no",
  description="TIBETAN DIGIT HALF NINE",
  direction="l",
  linebreak="al",
  unicodeslot=0xF32,
 },
 [0xF33]={
  category="no",
  description="TIBETAN DIGIT HALF ZERO",
  direction="l",
  linebreak="al",
  unicodeslot=0xF33,
 },
 [0xF34]={
  category="so",
  description="TIBETAN MARK BSDUS RTAGS",
  direction="l",
  linebreak="ba",
  unicodeslot=0xF34,
 },
 [0xF35]={
  category="mn",
  combining=0xDC,
  description="TIBETAN MARK NGAS BZUNG NYI ZLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF35,
 },
 [0xF36]={
  category="so",
  description="TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0xF36,
 },
 [0xF37]={
  category="mn",
  combining=0xDC,
  description="TIBETAN MARK NGAS BZUNG SGOR RTAGS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF37,
 },
 [0xF38]={
  category="so",
  description="TIBETAN MARK CHE MGO",
  direction="l",
  linebreak="al",
  unicodeslot=0xF38,
 },
 [0xF39]={
  category="mn",
  combining=0xD8,
  description="TIBETAN MARK TSA -PHRU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF39,
 },
 [0xF3A]={
  category="ps",
  description="TIBETAN MARK GUG RTAGS GYON",
  direction="on",
  linebreak="op",
  mirror=0xF3B,
  unicodeslot=0xF3A,
 },
 [0xF3B]={
  category="pe",
  description="TIBETAN MARK GUG RTAGS GYAS",
  direction="on",
  linebreak="cl",
  mirror=0xF3A,
  unicodeslot=0xF3B,
 },
 [0xF3C]={
  category="ps",
  description="TIBETAN MARK ANG KHANG GYON",
  direction="on",
  linebreak="op",
  mirror=0xF3D,
  unicodeslot=0xF3C,
 },
 [0xF3D]={
  category="pe",
  description="TIBETAN MARK ANG KHANG GYAS",
  direction="on",
  linebreak="cl",
  mirror=0xF3C,
  unicodeslot=0xF3D,
 },
 [0xF3E]={
  category="mc",
  description="TIBETAN SIGN YAR TSHES",
  direction="l",
  linebreak="cm",
  unicodeslot=0xF3E,
 },
 [0xF3F]={
  category="mc",
  description="TIBETAN SIGN MAR TSHES",
  direction="l",
  linebreak="cm",
  unicodeslot=0xF3F,
 },
 [0xF40]={
  category="lo",
  description="TIBETAN LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF40,
 },
 [0xF41]={
  category="lo",
  description="TIBETAN LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF41,
 },
 [0xF42]={
  category="lo",
  description="TIBETAN LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF42,
 },
 [0xF43]={
  category="lo",
  description="TIBETAN LETTER GHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0xF42, 0xFB7 },
  unicodeslot=0xF43,
 },
 [0xF44]={
  category="lo",
  description="TIBETAN LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF44,
 },
 [0xF45]={
  category="lo",
  description="TIBETAN LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF45,
 },
 [0xF46]={
  category="lo",
  description="TIBETAN LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF46,
 },
 [0xF47]={
  category="lo",
  description="TIBETAN LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF47,
 },
 [0xF49]={
  category="lo",
  description="TIBETAN LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF49,
 },
 [0xF4A]={
  category="lo",
  description="TIBETAN LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF4A,
 },
 [0xF4B]={
  category="lo",
  description="TIBETAN LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF4B,
 },
 [0xF4C]={
  category="lo",
  description="TIBETAN LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF4C,
 },
 [0xF4D]={
  category="lo",
  description="TIBETAN LETTER DDHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0xF4C, 0xFB7 },
  unicodeslot=0xF4D,
 },
 [0xF4E]={
  category="lo",
  description="TIBETAN LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF4E,
 },
 [0xF4F]={
  category="lo",
  description="TIBETAN LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF4F,
 },
 [0xF50]={
  category="lo",
  description="TIBETAN LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF50,
 },
 [0xF51]={
  category="lo",
  description="TIBETAN LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF51,
 },
 [0xF52]={
  category="lo",
  description="TIBETAN LETTER DHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0xF51, 0xFB7 },
  unicodeslot=0xF52,
 },
 [0xF53]={
  category="lo",
  description="TIBETAN LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF53,
 },
 [0xF54]={
  category="lo",
  description="TIBETAN LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF54,
 },
 [0xF55]={
  category="lo",
  description="TIBETAN LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF55,
 },
 [0xF56]={
  category="lo",
  description="TIBETAN LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF56,
 },
 [0xF57]={
  category="lo",
  description="TIBETAN LETTER BHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0xF56, 0xFB7 },
  unicodeslot=0xF57,
 },
 [0xF58]={
  category="lo",
  description="TIBETAN LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF58,
 },
 [0xF59]={
  category="lo",
  description="TIBETAN LETTER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF59,
 },
 [0xF5A]={
  category="lo",
  description="TIBETAN LETTER TSHA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF5A,
 },
 [0xF5B]={
  category="lo",
  description="TIBETAN LETTER DZA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF5B,
 },
 [0xF5C]={
  category="lo",
  description="TIBETAN LETTER DZHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0xF5B, 0xFB7 },
  unicodeslot=0xF5C,
 },
 [0xF5D]={
  category="lo",
  description="TIBETAN LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF5D,
 },
 [0xF5E]={
  category="lo",
  description="TIBETAN LETTER ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF5E,
 },
 [0xF5F]={
  category="lo",
  description="TIBETAN LETTER ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF5F,
 },
 [0xF60]={
  category="lo",
  description="TIBETAN LETTER -A",
  direction="l",
  linebreak="al",
  unicodeslot=0xF60,
 },
 [0xF61]={
  category="lo",
  description="TIBETAN LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF61,
 },
 [0xF62]={
  category="lo",
  description="TIBETAN LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF62,
 },
 [0xF63]={
  category="lo",
  description="TIBETAN LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF63,
 },
 [0xF64]={
  category="lo",
  description="TIBETAN LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF64,
 },
 [0xF65]={
  category="lo",
  description="TIBETAN LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF65,
 },
 [0xF66]={
  category="lo",
  description="TIBETAN LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF66,
 },
 [0xF67]={
  category="lo",
  description="TIBETAN LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF67,
 },
 [0xF68]={
  category="lo",
  description="TIBETAN LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0xF68,
 },
 [0xF69]={
  category="lo",
  description="TIBETAN LETTER KSSA",
  direction="l",
  linebreak="al",
  specials={ "char", 0xF40, 0xFB5 },
  unicodeslot=0xF69,
 },
 [0xF6A]={
  category="lo",
  description="TIBETAN LETTER FIXED-FORM RA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF6A,
 },
 [0xF6B]={
  category="lo",
  description="TIBETAN LETTER KKA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF6B,
 },
 [0xF6C]={
  category="lo",
  description="TIBETAN LETTER RRA",
  direction="l",
  linebreak="al",
  unicodeslot=0xF6C,
 },
 [0xF71]={
  category="mn",
  combining=0x81,
  description="TIBETAN VOWEL SIGN AA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF71,
 },
 [0xF72]={
  category="mn",
  combining=0x82,
  description="TIBETAN VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF72,
 },
 [0xF73]={
  category="mn",
  description="TIBETAN VOWEL SIGN II",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xF71, 0xF72 },
  unicodeslot=0xF73,
 },
 [0xF74]={
  category="mn",
  combining=0x84,
  description="TIBETAN VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF74,
 },
 [0xF75]={
  category="mn",
  description="TIBETAN VOWEL SIGN UU",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xF71, 0xF74 },
  unicodeslot=0xF75,
 },
 [0xF76]={
  category="mn",
  description="TIBETAN VOWEL SIGN VOCALIC R",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xFB2, 0xF80 },
  unicodeslot=0xF76,
 },
 [0xF77]={
  category="mn",
  description="TIBETAN VOWEL SIGN VOCALIC RR",
  direction="nsm",
  linebreak="cm",
  specials={ "compat", 0xFB2, 0xF81 },
  unicodeslot=0xF77,
 },
 [0xF78]={
  category="mn",
  description="TIBETAN VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xFB3, 0xF80 },
  unicodeslot=0xF78,
 },
 [0xF79]={
  category="mn",
  description="TIBETAN VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="cm",
  specials={ "compat", 0xFB3, 0xF81 },
  unicodeslot=0xF79,
 },
 [0xF7A]={
  category="mn",
  combining=0x82,
  description="TIBETAN VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF7A,
 },
 [0xF7B]={
  category="mn",
  combining=0x82,
  description="TIBETAN VOWEL SIGN EE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF7B,
 },
 [0xF7C]={
  category="mn",
  combining=0x82,
  description="TIBETAN VOWEL SIGN O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF7C,
 },
 [0xF7D]={
  category="mn",
  combining=0x82,
  description="TIBETAN VOWEL SIGN OO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF7D,
 },
 [0xF7E]={
  category="mn",
  description="TIBETAN SIGN RJES SU NGA RO",
  direction="nsm",
  linebreak="cm",
  synonyms={ "tibetan anusvara" },
  unicodeslot=0xF7E,
 },
 [0xF7F]={
  category="mc",
  description="TIBETAN SIGN RNAM BCAD",
  direction="l",
  linebreak="ba",
  synonyms={ "tibetan visarga" },
  unicodeslot=0xF7F,
 },
 [0xF80]={
  category="mn",
  combining=0x82,
  description="TIBETAN VOWEL SIGN REVERSED I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF80,
 },
 [0xF81]={
  category="mn",
  description="TIBETAN VOWEL SIGN REVERSED II",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xF71, 0xF80 },
  unicodeslot=0xF81,
 },
 [0xF82]={
  category="mn",
  combining=0xE6,
  description="TIBETAN SIGN NYI ZLA NAA DA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF82,
 },
 [0xF83]={
  category="mn",
  combining=0xE6,
  description="TIBETAN SIGN SNA LDAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF83,
 },
 [0xF84]={
  category="mn",
  combining=0x9,
  description="TIBETAN MARK HALANTA",
  direction="nsm",
  linebreak="cm",
  synonyms={ "tibetan srog med" },
  unicodeslot=0xF84,
 },
 [0xF85]={
  category="po",
  description="TIBETAN MARK PALUTA",
  direction="l",
  linebreak="ba",
  unicodeslot=0xF85,
 },
 [0xF86]={
  category="mn",
  combining=0xE6,
  description="TIBETAN SIGN LCI RTAGS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF86,
 },
 [0xF87]={
  category="mn",
  combining=0xE6,
  description="TIBETAN SIGN YANG RTAGS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF87,
 },
 [0xF88]={
  category="lo",
  description="TIBETAN SIGN LCE TSA CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0xF88,
 },
 [0xF89]={
  category="lo",
  description="TIBETAN SIGN MCHU CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0xF89,
 },
 [0xF8A]={
  category="lo",
  description="TIBETAN SIGN GRU CAN RGYINGS",
  direction="l",
  linebreak="al",
  unicodeslot=0xF8A,
 },
 [0xF8B]={
  category="lo",
  description="TIBETAN SIGN GRU MED RGYINGS",
  direction="l",
  linebreak="al",
  unicodeslot=0xF8B,
 },
 [0xF8C]={
  category="lo",
  description="TIBETAN SIGN INVERTED MCHU CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0xF8C,
 },
 [0xF8D]={
  category="mn",
  description="TIBETAN SUBJOINED SIGN LCE TSA CAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF8D,
 },
 [0xF8E]={
  category="mn",
  description="TIBETAN SUBJOINED SIGN MCHU CAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF8E,
 },
 [0xF8F]={
  category="mn",
  description="TIBETAN SUBJOINED SIGN INVERTED MCHU CAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF8F,
 },
 [0xF90]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER KA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF90,
 },
 [0xF91]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER KHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF91,
 },
 [0xF92]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER GA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF92,
 },
 [0xF93]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER GHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xF92, 0xFB7 },
  unicodeslot=0xF93,
 },
 [0xF94]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER NGA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF94,
 },
 [0xF95]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER CA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF95,
 },
 [0xF96]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER CHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF96,
 },
 [0xF97]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER JA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF97,
 },
 [0xF99]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER NYA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF99,
 },
 [0xF9A]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF9A,
 },
 [0xF9B]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TTHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF9B,
 },
 [0xF9C]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF9C,
 },
 [0xF9D]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DDHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xF9C, 0xFB7 },
  unicodeslot=0xF9D,
 },
 [0xF9E]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER NNA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF9E,
 },
 [0xF9F]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xF9F,
 },
 [0xFA0]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER THA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFA0,
 },
 [0xFA1]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFA1,
 },
 [0xFA2]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xFA1, 0xFB7 },
  unicodeslot=0xFA2,
 },
 [0xFA3]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER NA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFA3,
 },
 [0xFA4]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER PA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFA4,
 },
 [0xFA5]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER PHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFA5,
 },
 [0xFA6]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER BA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFA6,
 },
 [0xFA7]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER BHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xFA6, 0xFB7 },
  unicodeslot=0xFA7,
 },
 [0xFA8]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER MA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFA8,
 },
 [0xFA9]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TSA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFA9,
 },
 [0xFAA]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TSHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFAA,
 },
 [0xFAB]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DZA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFAB,
 },
 [0xFAC]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DZHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xFAB, 0xFB7 },
  unicodeslot=0xFAC,
 },
 [0xFAD]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER WA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFAD,
 },
 [0xFAE]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER ZHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFAE,
 },
 [0xFAF]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER ZA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFAF,
 },
 [0xFB0]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER -A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFB0,
 },
 [0xFB1]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER YA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFB1,
 },
 [0xFB2]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER RA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFB2,
 },
 [0xFB3]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER LA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFB3,
 },
 [0xFB4]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER SHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFB4,
 },
 [0xFB5]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER SSA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFB5,
 },
 [0xFB6]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER SA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFB6,
 },
 [0xFB7]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER HA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFB7,
 },
 [0xFB8]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFB8,
 },
 [0xFB9]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER KSSA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0xF90, 0xFB5 },
  unicodeslot=0xFB9,
 },
 [0xFBA]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER FIXED-FORM WA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFBA,
 },
 [0xFBB]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER FIXED-FORM YA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFBB,
 },
 [0xFBC]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER FIXED-FORM RA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFBC,
 },
 [0xFBE]={
  category="so",
  description="TIBETAN KU RU KHA",
  direction="l",
  linebreak="ba",
  unicodeslot=0xFBE,
 },
 [0xFBF]={
  category="so",
  description="TIBETAN KU RU KHA BZHI MIG CAN",
  direction="l",
  linebreak="ba",
  unicodeslot=0xFBF,
 },
 [0xFC0]={
  category="so",
  description="TIBETAN CANTILLATION SIGN HEAVY BEAT",
  direction="l",
  linebreak="al",
  unicodeslot=0xFC0,
 },
 [0xFC1]={
  category="so",
  description="TIBETAN CANTILLATION SIGN LIGHT BEAT",
  direction="l",
  linebreak="al",
  unicodeslot=0xFC1,
 },
 [0xFC2]={
  category="so",
  description="TIBETAN CANTILLATION SIGN CANG TE-U",
  direction="l",
  linebreak="al",
  unicodeslot=0xFC2,
 },
 [0xFC3]={
  category="so",
  description="TIBETAN CANTILLATION SIGN SBUB -CHAL",
  direction="l",
  linebreak="al",
  unicodeslot=0xFC3,
 },
 [0xFC4]={
  category="so",
  description="TIBETAN SYMBOL DRIL BU",
  direction="l",
  linebreak="al",
  unicodeslot=0xFC4,
 },
 [0xFC5]={
  category="so",
  description="TIBETAN SYMBOL RDO RJE",
  direction="l",
  linebreak="al",
  unicodeslot=0xFC5,
 },
 [0xFC6]={
  category="mn",
  combining=0xDC,
  description="TIBETAN SYMBOL PADMA GDAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0xFC6,
 },
 [0xFC7]={
  category="so",
  description="TIBETAN SYMBOL RDO RJE RGYA GRAM",
  direction="l",
  linebreak="al",
  unicodeslot=0xFC7,
 },
 [0xFC8]={
  category="so",
  description="TIBETAN SYMBOL PHUR PA",
  direction="l",
  linebreak="al",
  unicodeslot=0xFC8,
 },
 [0xFC9]={
  category="so",
  description="TIBETAN SYMBOL NOR BU",
  direction="l",
  linebreak="al",
  unicodeslot=0xFC9,
 },
 [0xFCA]={
  category="so",
  description="TIBETAN SYMBOL NOR BU NYIS -KHYIL",
  direction="l",
  linebreak="al",
  unicodeslot=0xFCA,
 },
 [0xFCB]={
  category="so",
  description="TIBETAN SYMBOL NOR BU GSUM -KHYIL",
  direction="l",
  linebreak="al",
  unicodeslot=0xFCB,
 },
 [0xFCC]={
  category="so",
  description="TIBETAN SYMBOL NOR BU BZHI -KHYIL",
  direction="l",
  linebreak="al",
  unicodeslot=0xFCC,
 },
 [0xFCE]={
  category="so",
  description="TIBETAN SIGN RDEL NAG RDEL DKAR",
  direction="l",
  linebreak="al",
  unicodeslot=0xFCE,
 },
 [0xFCF]={
  category="so",
  description="TIBETAN SIGN RDEL NAG GSUM",
  direction="l",
  linebreak="al",
  unicodeslot=0xFCF,
 },
 [0xFD0]={
  category="po",
  description="TIBETAN MARK BSKA- SHOG GI MGO RGYAN",
  direction="l",
  linebreak="bb",
  unicodeslot=0xFD0,
 },
 [0xFD1]={
  category="po",
  description="TIBETAN MARK MNYAM YIG GI MGO RGYAN",
  direction="l",
  linebreak="bb",
  unicodeslot=0xFD1,
 },
 [0xFD2]={
  category="po",
  description="TIBETAN MARK NYIS TSHEG",
  direction="l",
  linebreak="ba",
  unicodeslot=0xFD2,
 },
 [0xFD3]={
  category="po",
  description="TIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0xFD3,
 },
 [0xFD4]={
  category="po",
  description="TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA",
  direction="l",
  linebreak="al",
  unicodeslot=0xFD4,
 },
 [0xFD5]={
  category="so",
  description="RIGHT-FACING SVASTI SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0xFD5,
 },
 [0xFD6]={
  category="so",
  description="LEFT-FACING SVASTI SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0xFD6,
 },
 [0xFD7]={
  category="so",
  description="RIGHT-FACING SVASTI SIGN WITH DOTS",
  direction="l",
  linebreak="al",
  unicodeslot=0xFD7,
 },
 [0xFD8]={
  category="so",
  description="LEFT-FACING SVASTI SIGN WITH DOTS",
  direction="l",
  linebreak="al",
  unicodeslot=0xFD8,
 },
 [0xFD9]={
  category="po",
  description="TIBETAN MARK LEADING MCHAN RTAGS",
  direction="l",
  linebreak="gl",
  unicodeslot=0xFD9,
 },
 [0xFDA]={
  category="po",
  description="TIBETAN MARK TRAILING MCHAN RTAGS",
  direction="l",
  linebreak="gl",
  unicodeslot=0xFDA,
 },
 [0x1000]={
  category="lo",
  description="MYANMAR LETTER KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1000,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1001]={
  category="lo",
  description="MYANMAR LETTER KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1001,
 },
 [0x1002]={
  category="lo",
  description="MYANMAR LETTER GA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1002,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1003]={
  category="lo",
  description="MYANMAR LETTER GHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1003,
 },
 [0x1004]={
  category="lo",
  description="MYANMAR LETTER NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1004,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1005]={
  category="lo",
  description="MYANMAR LETTER CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1005,
 },
 [0x1006]={
  category="lo",
  description="MYANMAR LETTER CHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1006,
 },
 [0x1007]={
  category="lo",
  description="MYANMAR LETTER JA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1007,
 },
 [0x1008]={
  category="lo",
  description="MYANMAR LETTER JHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1008,
 },
 [0x1009]={
  category="lo",
  description="MYANMAR LETTER NYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1009,
 },
 [0x100A]={
  category="lo",
  description="MYANMAR LETTER NNYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100A,
 },
 [0x100B]={
  category="lo",
  description="MYANMAR LETTER TTA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100B,
 },
 [0x100C]={
  category="lo",
  description="MYANMAR LETTER TTHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100C,
 },
 [0x100D]={
  category="lo",
  description="MYANMAR LETTER DDA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100D,
 },
 [0x100E]={
  category="lo",
  description="MYANMAR LETTER DDHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100E,
 },
 [0x100F]={
  category="lo",
  description="MYANMAR LETTER NNA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100F,
 },
 [0x1010]={
  category="lo",
  description="MYANMAR LETTER TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1010,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1011]={
  category="lo",
  description="MYANMAR LETTER THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1011,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1012]={
  category="lo",
  description="MYANMAR LETTER DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1012,
 },
 [0x1013]={
  category="lo",
  description="MYANMAR LETTER DHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1013,
 },
 [0x1014]={
  category="lo",
  description="MYANMAR LETTER NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1014,
 },
 [0x1015]={
  category="lo",
  description="MYANMAR LETTER PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1015,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1016]={
  category="lo",
  description="MYANMAR LETTER PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1016,
 },
 [0x1017]={
  category="lo",
  description="MYANMAR LETTER BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1017,
 },
 [0x1018]={
  category="lo",
  description="MYANMAR LETTER BHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1018,
 },
 [0x1019]={
  category="lo",
  description="MYANMAR LETTER MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1019,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x101A]={
  category="lo",
  description="MYANMAR LETTER YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101A,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x101B]={
  category="lo",
  description="MYANMAR LETTER RA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101B,
 },
 [0x101C]={
  category="lo",
  description="MYANMAR LETTER LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101C,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x101D]={
  category="lo",
  description="MYANMAR LETTER WA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101D,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x101E]={
  category="lo",
  description="MYANMAR LETTER SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101E,
 },
 [0x101F]={
  category="lo",
  description="MYANMAR LETTER HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101F,
 },
 [0x1020]={
  category="lo",
  description="MYANMAR LETTER LLA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1020,
 },
 [0x1021]={
  category="lo",
  description="MYANMAR LETTER A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1021,
 },
 [0x1022]={
  category="lo",
  description="MYANMAR LETTER SHAN A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1022,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1023]={
  category="lo",
  description="MYANMAR LETTER I",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1023,
 },
 [0x1024]={
  category="lo",
  description="MYANMAR LETTER II",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1024,
 },
 [0x1025]={
  category="lo",
  description="MYANMAR LETTER U",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1025,
 },
 [0x1026]={
  category="lo",
  description="MYANMAR LETTER UU",
  direction="l",
  linebreak="sa",
  specials={ "char", 0x1025, 0x102E },
  unicodeslot=0x1026,
 },
 [0x1027]={
  category="lo",
  description="MYANMAR LETTER E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1027,
 },
 [0x1028]={
  category="lo",
  description="MYANMAR LETTER MON E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1028,
 },
 [0x1029]={
  category="lo",
  description="MYANMAR LETTER O",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1029,
 },
 [0x102A]={
  category="lo",
  description="MYANMAR LETTER AU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x102A,
 },
 [0x102B]={
  category="mc",
  description="MYANMAR VOWEL SIGN TALL AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x102B,
 },
 [0x102C]={
  category="mc",
  description="MYANMAR VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x102C,
 },
 [0x102D]={
  category="mn",
  description="MYANMAR VOWEL SIGN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x102D,
 },
 [0x102E]={
  category="mn",
  description="MYANMAR VOWEL SIGN II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x102E,
 },
 [0x102F]={
  category="mn",
  description="MYANMAR VOWEL SIGN U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x102F,
 },
 [0x1030]={
  category="mn",
  description="MYANMAR VOWEL SIGN UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1030,
 },
 [0x1031]={
  category="mc",
  description="MYANMAR VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1031,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1032]={
  category="mn",
  description="MYANMAR VOWEL SIGN AI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1032,
 },
 [0x1033]={
  category="mn",
  description="MYANMAR VOWEL SIGN MON II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1033,
 },
 [0x1034]={
  category="mn",
  description="MYANMAR VOWEL SIGN MON O",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1034,
 },
 [0x1035]={
  category="mn",
  description="MYANMAR VOWEL SIGN E ABOVE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1035,
 },
 [0x1036]={
  category="mn",
  description="MYANMAR SIGN ANUSVARA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1036,
 },
 [0x1037]={
  category="mn",
  combining=0x7,
  description="MYANMAR SIGN DOT BELOW",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1037,
 },
 [0x1038]={
  category="mc",
  description="MYANMAR SIGN VISARGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1038,
 },
 [0x1039]={
  category="mn",
  combining=0x9,
  description="MYANMAR SIGN VIRAMA",
  direction="nsm",
  linebreak="sa",
  synonyms={ "myanmar killer" },
  unicodeslot=0x1039,
 },
 [0x103A]={
  category="mn",
  combining=0x9,
  description="MYANMAR SIGN ASAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x103A,
 },
 [0x103B]={
  category="mc",
  description="MYANMAR CONSONANT SIGN MEDIAL YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x103B,
 },
 [0x103C]={
  category="mc",
  description="MYANMAR CONSONANT SIGN MEDIAL RA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x103C,
 },
 [0x103D]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MEDIAL WA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x103D,
 },
 [0x103E]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MEDIAL HA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x103E,
 },
 [0x103F]={
  category="lo",
  description="MYANMAR LETTER GREAT SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x103F,
 },
 [0x1040]={
  category="nd",
  description="MYANMAR DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1040,
 },
 [0x1041]={
  category="nd",
  description="MYANMAR DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1041,
 },
 [0x1042]={
  category="nd",
  description="MYANMAR DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1042,
 },
 [0x1043]={
  category="nd",
  description="MYANMAR DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1043,
 },
 [0x1044]={
  category="nd",
  description="MYANMAR DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1044,
 },
 [0x1045]={
  category="nd",
  description="MYANMAR DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1045,
 },
 [0x1046]={
  category="nd",
  description="MYANMAR DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1046,
 },
 [0x1047]={
  category="nd",
  description="MYANMAR DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1047,
 },
 [0x1048]={
  category="nd",
  description="MYANMAR DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1048,
 },
 [0x1049]={
  category="nd",
  description="MYANMAR DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1049,
 },
 [0x104A]={
  category="po",
  description="MYANMAR SIGN LITTLE SECTION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x104A,
 },
 [0x104B]={
  category="po",
  description="MYANMAR SIGN SECTION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x104B,
 },
 [0x104C]={
  category="po",
  description="MYANMAR SYMBOL LOCATIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x104C,
 },
 [0x104D]={
  category="po",
  description="MYANMAR SYMBOL COMPLETED",
  direction="l",
  linebreak="al",
  unicodeslot=0x104D,
 },
 [0x104E]={
  category="po",
  description="MYANMAR SYMBOL AFOREMENTIONED",
  direction="l",
  linebreak="al",
  unicodeslot=0x104E,
 },
 [0x104F]={
  category="po",
  description="MYANMAR SYMBOL GENITIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x104F,
 },
 [0x1050]={
  category="lo",
  description="MYANMAR LETTER SHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1050,
 },
 [0x1051]={
  category="lo",
  description="MYANMAR LETTER SSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1051,
 },
 [0x1052]={
  category="lo",
  description="MYANMAR LETTER VOCALIC R",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1052,
 },
 [0x1053]={
  category="lo",
  description="MYANMAR LETTER VOCALIC RR",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1053,
 },
 [0x1054]={
  category="lo",
  description="MYANMAR LETTER VOCALIC L",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1054,
 },
 [0x1055]={
  category="lo",
  description="MYANMAR LETTER VOCALIC LL",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1055,
 },
 [0x1056]={
  category="mc",
  description="MYANMAR VOWEL SIGN VOCALIC R",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1056,
 },
 [0x1057]={
  category="mc",
  description="MYANMAR VOWEL SIGN VOCALIC RR",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1057,
 },
 [0x1058]={
  category="mn",
  description="MYANMAR VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1058,
 },
 [0x1059]={
  category="mn",
  description="MYANMAR VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1059,
 },
 [0x105A]={
  category="lo",
  description="MYANMAR LETTER MON NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x105A,
 },
 [0x105B]={
  category="lo",
  description="MYANMAR LETTER MON JHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x105B,
 },
 [0x105C]={
  category="lo",
  description="MYANMAR LETTER MON BBA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x105C,
 },
 [0x105D]={
  category="lo",
  description="MYANMAR LETTER MON BBE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x105D,
 },
 [0x105E]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MON MEDIAL NA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x105E,
 },
 [0x105F]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MON MEDIAL MA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x105F,
 },
 [0x1060]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MON MEDIAL LA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1060,
 },
 [0x1061]={
  category="lo",
  description="MYANMAR LETTER SGAW KAREN SHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1061,
 },
 [0x1062]={
  category="mc",
  description="MYANMAR VOWEL SIGN SGAW KAREN EU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1062,
 },
 [0x1063]={
  category="mc",
  description="MYANMAR TONE MARK SGAW KAREN HATHI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1063,
 },
 [0x1064]={
  category="mc",
  description="MYANMAR TONE MARK SGAW KAREN KE PHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1064,
 },
 [0x1065]={
  category="lo",
  description="MYANMAR LETTER WESTERN PWO KAREN THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1065,
 },
 [0x1066]={
  category="lo",
  description="MYANMAR LETTER WESTERN PWO KAREN PWA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1066,
 },
 [0x1067]={
  category="mc",
  description="MYANMAR VOWEL SIGN WESTERN PWO KAREN EU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1067,
 },
 [0x1068]={
  category="mc",
  description="MYANMAR VOWEL SIGN WESTERN PWO KAREN UE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1068,
 },
 [0x1069]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-1",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1069,
 },
 [0x106A]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-2",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106A,
 },
 [0x106B]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-3",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106B,
 },
 [0x106C]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-4",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106C,
 },
 [0x106D]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-5",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106D,
 },
 [0x106E]={
  category="lo",
  description="MYANMAR LETTER EASTERN PWO KAREN NNA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106E,
 },
 [0x106F]={
  category="lo",
  description="MYANMAR LETTER EASTERN PWO KAREN YWA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106F,
 },
 [0x1070]={
  category="lo",
  description="MYANMAR LETTER EASTERN PWO KAREN GHWA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1070,
 },
 [0x1071]={
  category="mn",
  description="MYANMAR VOWEL SIGN GEBA KAREN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1071,
 },
 [0x1072]={
  category="mn",
  description="MYANMAR VOWEL SIGN KAYAH OE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1072,
 },
 [0x1073]={
  category="mn",
  description="MYANMAR VOWEL SIGN KAYAH U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1073,
 },
 [0x1074]={
  category="mn",
  description="MYANMAR VOWEL SIGN KAYAH EE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1074,
 },
 [0x1075]={
  category="lo",
  description="MYANMAR LETTER SHAN KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1075,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1076]={
  category="lo",
  description="MYANMAR LETTER SHAN KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1076,
 },
 [0x1077]={
  category="lo",
  description="MYANMAR LETTER SHAN GA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1077,
 },
 [0x1078]={
  category="lo",
  description="MYANMAR LETTER SHAN CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1078,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1079]={
  category="lo",
  description="MYANMAR LETTER SHAN ZA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1079,
 },
 [0x107A]={
  category="lo",
  description="MYANMAR LETTER SHAN NYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107A,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x107B]={
  category="lo",
  description="MYANMAR LETTER SHAN DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107B,
 },
 [0x107C]={
  category="lo",
  description="MYANMAR LETTER SHAN NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107C,
 },
 [0x107D]={
  category="lo",
  description="MYANMAR LETTER SHAN PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107D,
 },
 [0x107E]={
  category="lo",
  description="MYANMAR LETTER SHAN FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107E,
 },
 [0x107F]={
  category="lo",
  description="MYANMAR LETTER SHAN BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107F,
 },
 [0x1080]={
  category="lo",
  description="MYANMAR LETTER SHAN THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1080,
  variants={
   [0xFE00]="dotted form",
  },
 },
 [0x1081]={
  category="lo",
  description="MYANMAR LETTER SHAN HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1081,
 },
 [0x1082]={
  category="mn",
  description="MYANMAR CONSONANT SIGN SHAN MEDIAL WA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1082,
 },
 [0x1083]={
  category="mc",
  description="MYANMAR VOWEL SIGN SHAN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1083,
 },
 [0x1084]={
  category="mc",
  description="MYANMAR VOWEL SIGN SHAN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1084,
 },
 [0x1085]={
  category="mn",
  description="MYANMAR VOWEL SIGN SHAN E ABOVE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1085,
 },
 [0x1086]={
  category="mn",
  description="MYANMAR VOWEL SIGN SHAN FINAL Y",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1086,
 },
 [0x1087]={
  category="mc",
  description="MYANMAR SIGN SHAN TONE-2",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1087,
 },
 [0x1088]={
  category="mc",
  description="MYANMAR SIGN SHAN TONE-3",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1088,
 },
 [0x1089]={
  category="mc",
  description="MYANMAR SIGN SHAN TONE-5",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1089,
 },
 [0x108A]={
  category="mc",
  description="MYANMAR SIGN SHAN TONE-6",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108A,
 },
 [0x108B]={
  category="mc",
  description="MYANMAR SIGN SHAN COUNCIL TONE-2",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108B,
 },
 [0x108C]={
  category="mc",
  description="MYANMAR SIGN SHAN COUNCIL TONE-3",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108C,
 },
 [0x108D]={
  category="mn",
  combining=0xDC,
  description="MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x108D,
 },
 [0x108E]={
  category="lo",
  description="MYANMAR LETTER RUMAI PALAUNG FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108E,
 },
 [0x108F]={
  category="mc",
  description="MYANMAR SIGN RUMAI PALAUNG TONE-5",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108F,
 },
 [0x1090]={
  category="nd",
  description="MYANMAR SHAN DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1090,
 },
 [0x1091]={
  category="nd",
  description="MYANMAR SHAN DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1091,
 },
 [0x1092]={
  category="nd",
  description="MYANMAR SHAN DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1092,
 },
 [0x1093]={
  category="nd",
  description="MYANMAR SHAN DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1093,
 },
 [0x1094]={
  category="nd",
  description="MYANMAR SHAN DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1094,
 },
 [0x1095]={
  category="nd",
  description="MYANMAR SHAN DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1095,
 },
 [0x1096]={
  category="nd",
  description="MYANMAR SHAN DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1096,
 },
 [0x1097]={
  category="nd",
  description="MYANMAR SHAN DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1097,
 },
 [0x1098]={
  category="nd",
  description="MYANMAR SHAN DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1098,
 },
 [0x1099]={
  category="nd",
  description="MYANMAR SHAN DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1099,
 },
 [0x109A]={
  category="mc",
  description="MYANMAR SIGN KHAMTI TONE-1",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109A,
 },
 [0x109B]={
  category="mc",
  description="MYANMAR SIGN KHAMTI TONE-3",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109B,
 },
 [0x109C]={
  category="mc",
  description="MYANMAR VOWEL SIGN AITON A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109C,
 },
 [0x109D]={
  category="mn",
  description="MYANMAR VOWEL SIGN AITON AI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x109D,
 },
 [0x109E]={
  category="so",
  description="MYANMAR SYMBOL SHAN ONE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109E,
 },
 [0x109F]={
  category="so",
  description="MYANMAR SYMBOL SHAN EXCLAMATION",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109F,
 },
 [0x10A0]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER AN",
  direction="l",
  lccode=0x2D00,
  linebreak="al",
  unicodeslot=0x10A0,
 },
 [0x10A1]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER BAN",
  direction="l",
  lccode=0x2D01,
  linebreak="al",
  unicodeslot=0x10A1,
 },
 [0x10A2]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER GAN",
  direction="l",
  lccode=0x2D02,
  linebreak="al",
  unicodeslot=0x10A2,
 },
 [0x10A3]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER DON",
  direction="l",
  lccode=0x2D03,
  linebreak="al",
  unicodeslot=0x10A3,
 },
 [0x10A4]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER EN",
  direction="l",
  lccode=0x2D04,
  linebreak="al",
  unicodeslot=0x10A4,
 },
 [0x10A5]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER VIN",
  direction="l",
  lccode=0x2D05,
  linebreak="al",
  unicodeslot=0x10A5,
 },
 [0x10A6]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER ZEN",
  direction="l",
  lccode=0x2D06,
  linebreak="al",
  unicodeslot=0x10A6,
 },
 [0x10A7]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER TAN",
  direction="l",
  lccode=0x2D07,
  linebreak="al",
  unicodeslot=0x10A7,
 },
 [0x10A8]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER IN",
  direction="l",
  lccode=0x2D08,
  linebreak="al",
  unicodeslot=0x10A8,
 },
 [0x10A9]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER KAN",
  direction="l",
  lccode=0x2D09,
  linebreak="al",
  unicodeslot=0x10A9,
 },
 [0x10AA]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER LAS",
  direction="l",
  lccode=0x2D0A,
  linebreak="al",
  unicodeslot=0x10AA,
 },
 [0x10AB]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER MAN",
  direction="l",
  lccode=0x2D0B,
  linebreak="al",
  unicodeslot=0x10AB,
 },
 [0x10AC]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER NAR",
  direction="l",
  lccode=0x2D0C,
  linebreak="al",
  unicodeslot=0x10AC,
 },
 [0x10AD]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER ON",
  direction="l",
  lccode=0x2D0D,
  linebreak="al",
  unicodeslot=0x10AD,
 },
 [0x10AE]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER PAR",
  direction="l",
  lccode=0x2D0E,
  linebreak="al",
  unicodeslot=0x10AE,
 },
 [0x10AF]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER ZHAR",
  direction="l",
  lccode=0x2D0F,
  linebreak="al",
  unicodeslot=0x10AF,
 },
 [0x10B0]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER RAE",
  direction="l",
  lccode=0x2D10,
  linebreak="al",
  unicodeslot=0x10B0,
 },
 [0x10B1]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER SAN",
  direction="l",
  lccode=0x2D11,
  linebreak="al",
  unicodeslot=0x10B1,
 },
 [0x10B2]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER TAR",
  direction="l",
  lccode=0x2D12,
  linebreak="al",
  unicodeslot=0x10B2,
 },
 [0x10B3]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER UN",
  direction="l",
  lccode=0x2D13,
  linebreak="al",
  unicodeslot=0x10B3,
 },
 [0x10B4]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER PHAR",
  direction="l",
  lccode=0x2D14,
  linebreak="al",
  unicodeslot=0x10B4,
 },
 [0x10B5]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER KHAR",
  direction="l",
  lccode=0x2D15,
  linebreak="al",
  unicodeslot=0x10B5,
 },
 [0x10B6]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER GHAN",
  direction="l",
  lccode=0x2D16,
  linebreak="al",
  unicodeslot=0x10B6,
 },
 [0x10B7]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER QAR",
  direction="l",
  lccode=0x2D17,
  linebreak="al",
  unicodeslot=0x10B7,
 },
 [0x10B8]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER SHIN",
  direction="l",
  lccode=0x2D18,
  linebreak="al",
  unicodeslot=0x10B8,
 },
 [0x10B9]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER CHIN",
  direction="l",
  lccode=0x2D19,
  linebreak="al",
  unicodeslot=0x10B9,
 },
 [0x10BA]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER CAN",
  direction="l",
  lccode=0x2D1A,
  linebreak="al",
  unicodeslot=0x10BA,
 },
 [0x10BB]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER JIL",
  direction="l",
  lccode=0x2D1B,
  linebreak="al",
  unicodeslot=0x10BB,
 },
 [0x10BC]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER CIL",
  direction="l",
  lccode=0x2D1C,
  linebreak="al",
  unicodeslot=0x10BC,
 },
 [0x10BD]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER CHAR",
  direction="l",
  lccode=0x2D1D,
  linebreak="al",
  unicodeslot=0x10BD,
 },
 [0x10BE]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER XAN",
  direction="l",
  lccode=0x2D1E,
  linebreak="al",
  unicodeslot=0x10BE,
 },
 [0x10BF]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER JHAN",
  direction="l",
  lccode=0x2D1F,
  linebreak="al",
  unicodeslot=0x10BF,
 },
 [0x10C0]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HAE",
  direction="l",
  lccode=0x2D20,
  linebreak="al",
  unicodeslot=0x10C0,
 },
 [0x10C1]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HE",
  direction="l",
  lccode=0x2D21,
  linebreak="al",
  unicodeslot=0x10C1,
 },
 [0x10C2]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HIE",
  direction="l",
  lccode=0x2D22,
  linebreak="al",
  unicodeslot=0x10C2,
 },
 [0x10C3]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER WE",
  direction="l",
  lccode=0x2D23,
  linebreak="al",
  unicodeslot=0x10C3,
 },
 [0x10C4]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HAR",
  direction="l",
  lccode=0x2D24,
  linebreak="al",
  unicodeslot=0x10C4,
 },
 [0x10C5]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HOE",
  direction="l",
  lccode=0x2D25,
  linebreak="al",
  unicodeslot=0x10C5,
 },
 [0x10C7]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER YN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10C7,
 },
 [0x10CD]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER AEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10CD,
 },
 [0x10D0]={
  category="lo",
  description="GEORGIAN LETTER AN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D0,
 },
 [0x10D1]={
  category="lo",
  description="GEORGIAN LETTER BAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D1,
 },
 [0x10D2]={
  category="lo",
  description="GEORGIAN LETTER GAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D2,
 },
 [0x10D3]={
  category="lo",
  description="GEORGIAN LETTER DON",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D3,
 },
 [0x10D4]={
  category="lo",
  description="GEORGIAN LETTER EN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D4,
 },
 [0x10D5]={
  category="lo",
  description="GEORGIAN LETTER VIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D5,
 },
 [0x10D6]={
  category="lo",
  description="GEORGIAN LETTER ZEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D6,
 },
 [0x10D7]={
  category="lo",
  description="GEORGIAN LETTER TAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D7,
 },
 [0x10D8]={
  category="lo",
  description="GEORGIAN LETTER IN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D8,
 },
 [0x10D9]={
  category="lo",
  description="GEORGIAN LETTER KAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D9,
 },
 [0x10DA]={
  category="lo",
  description="GEORGIAN LETTER LAS",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DA,
 },
 [0x10DB]={
  category="lo",
  description="GEORGIAN LETTER MAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DB,
 },
 [0x10DC]={
  category="lo",
  description="GEORGIAN LETTER NAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DC,
 },
 [0x10DD]={
  category="lo",
  description="GEORGIAN LETTER ON",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DD,
 },
 [0x10DE]={
  category="lo",
  description="GEORGIAN LETTER PAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DE,
 },
 [0x10DF]={
  category="lo",
  description="GEORGIAN LETTER ZHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DF,
 },
 [0x10E0]={
  category="lo",
  description="GEORGIAN LETTER RAE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E0,
 },
 [0x10E1]={
  category="lo",
  description="GEORGIAN LETTER SAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E1,
 },
 [0x10E2]={
  category="lo",
  description="GEORGIAN LETTER TAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E2,
 },
 [0x10E3]={
  category="lo",
  description="GEORGIAN LETTER UN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E3,
 },
 [0x10E4]={
  category="lo",
  description="GEORGIAN LETTER PHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E4,
 },
 [0x10E5]={
  category="lo",
  description="GEORGIAN LETTER KHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E5,
 },
 [0x10E6]={
  category="lo",
  description="GEORGIAN LETTER GHAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E6,
 },
 [0x10E7]={
  category="lo",
  description="GEORGIAN LETTER QAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E7,
 },
 [0x10E8]={
  category="lo",
  description="GEORGIAN LETTER SHIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E8,
 },
 [0x10E9]={
  category="lo",
  description="GEORGIAN LETTER CHIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E9,
 },
 [0x10EA]={
  category="lo",
  description="GEORGIAN LETTER CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EA,
 },
 [0x10EB]={
  category="lo",
  description="GEORGIAN LETTER JIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EB,
 },
 [0x10EC]={
  category="lo",
  description="GEORGIAN LETTER CIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EC,
 },
 [0x10ED]={
  category="lo",
  description="GEORGIAN LETTER CHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10ED,
 },
 [0x10EE]={
  category="lo",
  description="GEORGIAN LETTER XAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EE,
 },
 [0x10EF]={
  category="lo",
  description="GEORGIAN LETTER JHAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EF,
 },
 [0x10F0]={
  category="lo",
  description="GEORGIAN LETTER HAE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F0,
 },
 [0x10F1]={
  category="lo",
  description="GEORGIAN LETTER HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F1,
 },
 [0x10F2]={
  category="lo",
  description="GEORGIAN LETTER HIE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F2,
 },
 [0x10F3]={
  category="lo",
  description="GEORGIAN LETTER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F3,
 },
 [0x10F4]={
  category="lo",
  description="GEORGIAN LETTER HAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F4,
 },
 [0x10F5]={
  category="lo",
  description="GEORGIAN LETTER HOE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F5,
 },
 [0x10F6]={
  category="lo",
  description="GEORGIAN LETTER FI",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F6,
 },
 [0x10F7]={
  category="lo",
  description="GEORGIAN LETTER YN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F7,
 },
 [0x10F8]={
  category="lo",
  description="GEORGIAN LETTER ELIFI",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F8,
 },
 [0x10F9]={
  category="lo",
  description="GEORGIAN LETTER TURNED GAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F9,
 },
 [0x10FA]={
  category="lo",
  description="GEORGIAN LETTER AIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10FA,
 },
 [0x10FB]={
  category="po",
  description="GEORGIAN PARAGRAPH SEPARATOR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10FB,
 },
 [0x10FC]={
  category="lm",
  description="MODIFIER LETTER GEORGIAN NAR",
  direction="l",
  linebreak="al",
  specials={ "super", 0x10DC },
  unicodeslot=0x10FC,
 },
 [0x10FD]={
  category="lo",
  description="GEORGIAN LETTER AEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10FD,
 },
 [0x10FE]={
  category="lo",
  description="GEORGIAN LETTER HARD SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10FE,
 },
 [0x10FF]={
  category="lo",
  description="GEORGIAN LETTER LABIAL SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10FF,
 },
 [0x1100]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1100,
 },
 [0x1101]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGKIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1101,
 },
 [0x1102]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1102,
 },
 [0x1103]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1103,
 },
 [0x1104]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGTIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1104,
 },
 [0x1105]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG RIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1105,
 },
 [0x1106]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG MIEUM",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1106,
 },
 [0x1107]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1107,
 },
 [0x1108]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGPIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1108,
 },
 [0x1109]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1109,
 },
 [0x110A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110A,
 },
 [0x110B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110B,
 },
 [0x110C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110C,
 },
 [0x110D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110D,
 },
 [0x110E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110E,
 },
 [0x110F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KHIEUKH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110F,
 },
 [0x1110]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG THIEUTH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1110,
 },
 [0x1111]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1111,
 },
 [0x1112]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1112,
 },
 [0x1113]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1113,
 },
 [0x1114]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGNIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1114,
 },
 [0x1115]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1115,
 },
 [0x1116]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1116,
 },
 [0x1117]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG TIKEUT-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1117,
 },
 [0x1118]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG RIEUL-NIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1118,
 },
 [0x1119]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGRIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1119,
 },
 [0x111A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG RIEUL-HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111A,
 },
 [0x111B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNRIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111B,
 },
 [0x111C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG MIEUM-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111C,
 },
 [0x111D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNMIEUM",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111D,
 },
 [0x111E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111E,
 },
 [0x111F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-NIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111F,
 },
 [0x1120]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1120,
 },
 [0x1121]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1121,
 },
 [0x1122]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1122,
 },
 [0x1123]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1123,
 },
 [0x1124]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1124,
 },
 [0x1125]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1125,
 },
 [0x1126]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1126,
 },
 [0x1127]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1127,
 },
 [0x1128]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-CHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1128,
 },
 [0x1129]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-THIEUTH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1129,
 },
 [0x112A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-PHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112A,
 },
 [0x112B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNPIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112B,
 },
 [0x112C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNSSANGPIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112C,
 },
 [0x112D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112D,
 },
 [0x112E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-NIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112E,
 },
 [0x112F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112F,
 },
 [0x1130]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-RIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1130,
 },
 [0x1131]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-MIEUM",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1131,
 },
 [0x1132]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1132,
 },
 [0x1133]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-PIEUP-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1133,
 },
 [0x1134]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-SSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1134,
 },
 [0x1135]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-IEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1135,
 },
 [0x1136]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1136,
 },
 [0x1137]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-CHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1137,
 },
 [0x1138]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-KHIEUKH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1138,
 },
 [0x1139]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-THIEUTH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1139,
 },
 [0x113A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-PHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113A,
 },
 [0x113B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113B,
 },
 [0x113C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113C,
 },
 [0x113D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMSSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113D,
 },
 [0x113E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113E,
 },
 [0x113F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113F,
 },
 [0x1140]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PANSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1140,
 },
 [0x1141]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1141,
 },
 [0x1142]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1142,
 },
 [0x1143]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-MIEUM",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1143,
 },
 [0x1144]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1144,
 },
 [0x1145]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-SIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1145,
 },
 [0x1146]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-PANSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1146,
 },
 [0x1147]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGIEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1147,
 },
 [0x1148]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1148,
 },
 [0x1149]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-CHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1149,
 },
 [0x114A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-THIEUTH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114A,
 },
 [0x114B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-PHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114B,
 },
 [0x114C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG YESIEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114C,
 },
 [0x114D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CIEUC-IEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114D,
 },
 [0x114E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114E,
 },
 [0x114F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMSSANGCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114F,
 },
 [0x1150]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1150,
 },
 [0x1151]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1151,
 },
 [0x1152]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHIEUCH-KHIEUKH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1152,
 },
 [0x1153]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHIEUCH-HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1153,
 },
 [0x1154]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMCHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1154,
 },
 [0x1155]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMCHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1155,
 },
 [0x1156]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PHIEUPH-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1156,
 },
 [0x1157]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNPHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1157,
 },
 [0x1158]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGHIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1158,
 },
 [0x1159]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG YEORINHIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1159,
 },
 [0x115A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KIYEOK-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115A,
 },
 [0x115B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-SIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115B,
 },
 [0x115C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115C,
 },
 [0x115D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115D,
 },
 [0x115E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG TIKEUT-RIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115E,
 },
 [0x115F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG FILLER",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115F,
 },
 [0x1160]={
  category="lo",
  description="HANGUL JUNGSEONG FILLER",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1160,
 },
 [0x1161]={
  category="lo",
  description="HANGUL JUNGSEONG A",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1161,
 },
 [0x1162]={
  category="lo",
  description="HANGUL JUNGSEONG AE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1162,
 },
 [0x1163]={
  category="lo",
  description="HANGUL JUNGSEONG YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1163,
 },
 [0x1164]={
  category="lo",
  description="HANGUL JUNGSEONG YAE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1164,
 },
 [0x1165]={
  category="lo",
  description="HANGUL JUNGSEONG EO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1165,
 },
 [0x1166]={
  category="lo",
  description="HANGUL JUNGSEONG E",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1166,
 },
 [0x1167]={
  category="lo",
  description="HANGUL JUNGSEONG YEO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1167,
 },
 [0x1168]={
  category="lo",
  description="HANGUL JUNGSEONG YE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1168,
 },
 [0x1169]={
  category="lo",
  description="HANGUL JUNGSEONG O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1169,
 },
 [0x116A]={
  category="lo",
  description="HANGUL JUNGSEONG WA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116A,
 },
 [0x116B]={
  category="lo",
  description="HANGUL JUNGSEONG WAE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116B,
 },
 [0x116C]={
  category="lo",
  description="HANGUL JUNGSEONG OE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116C,
 },
 [0x116D]={
  category="lo",
  description="HANGUL JUNGSEONG YO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116D,
 },
 [0x116E]={
  category="lo",
  description="HANGUL JUNGSEONG U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116E,
 },
 [0x116F]={
  category="lo",
  description="HANGUL JUNGSEONG WEO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116F,
 },
 [0x1170]={
  category="lo",
  description="HANGUL JUNGSEONG WE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1170,
 },
 [0x1171]={
  category="lo",
  description="HANGUL JUNGSEONG WI",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1171,
 },
 [0x1172]={
  category="lo",
  description="HANGUL JUNGSEONG YU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1172,
 },
 [0x1173]={
  category="lo",
  description="HANGUL JUNGSEONG EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1173,
 },
 [0x1174]={
  category="lo",
  description="HANGUL JUNGSEONG YI",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1174,
 },
 [0x1175]={
  category="lo",
  description="HANGUL JUNGSEONG I",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1175,
 },
 [0x1176]={
  category="lo",
  description="HANGUL JUNGSEONG A-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1176,
 },
 [0x1177]={
  category="lo",
  description="HANGUL JUNGSEONG A-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1177,
 },
 [0x1178]={
  category="lo",
  description="HANGUL JUNGSEONG YA-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1178,
 },
 [0x1179]={
  category="lo",
  description="HANGUL JUNGSEONG YA-YO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1179,
 },
 [0x117A]={
  category="lo",
  description="HANGUL JUNGSEONG EO-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117A,
 },
 [0x117B]={
  category="lo",
  description="HANGUL JUNGSEONG EO-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117B,
 },
 [0x117C]={
  category="lo",
  description="HANGUL JUNGSEONG EO-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117C,
 },
 [0x117D]={
  category="lo",
  description="HANGUL JUNGSEONG YEO-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117D,
 },
 [0x117E]={
  category="lo",
  description="HANGUL JUNGSEONG YEO-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117E,
 },
 [0x117F]={
  category="lo",
  description="HANGUL JUNGSEONG O-EO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117F,
 },
 [0x1180]={
  category="lo",
  description="HANGUL JUNGSEONG O-E",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1180,
 },
 [0x1181]={
  category="lo",
  description="HANGUL JUNGSEONG O-YE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1181,
 },
 [0x1182]={
  category="lo",
  description="HANGUL JUNGSEONG O-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1182,
 },
 [0x1183]={
  category="lo",
  description="HANGUL JUNGSEONG O-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1183,
 },
 [0x1184]={
  category="lo",
  description="HANGUL JUNGSEONG YO-YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1184,
 },
 [0x1185]={
  category="lo",
  description="HANGUL JUNGSEONG YO-YAE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1185,
 },
 [0x1186]={
  category="lo",
  description="HANGUL JUNGSEONG YO-YEO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1186,
 },
 [0x1187]={
  category="lo",
  description="HANGUL JUNGSEONG YO-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1187,
 },
 [0x1188]={
  category="lo",
  description="HANGUL JUNGSEONG YO-I",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1188,
 },
 [0x1189]={
  category="lo",
  description="HANGUL JUNGSEONG U-A",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1189,
 },
 [0x118A]={
  category="lo",
  description="HANGUL JUNGSEONG U-AE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118A,
 },
 [0x118B]={
  category="lo",
  description="HANGUL JUNGSEONG U-EO-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118B,
 },
 [0x118C]={
  category="lo",
  description="HANGUL JUNGSEONG U-YE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118C,
 },
 [0x118D]={
  category="lo",
  description="HANGUL JUNGSEONG U-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118D,
 },
 [0x118E]={
  category="lo",
  description="HANGUL JUNGSEONG YU-A",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118E,
 },
 [0x118F]={
  category="lo",
  description="HANGUL JUNGSEONG YU-EO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118F,
 },
 [0x1190]={
  category="lo",
  description="HANGUL JUNGSEONG YU-E",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1190,
 },
 [0x1191]={
  category="lo",
  description="HANGUL JUNGSEONG YU-YEO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1191,
 },
 [0x1192]={
  category="lo",
  description="HANGUL JUNGSEONG YU-YE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1192,
 },
 [0x1193]={
  category="lo",
  description="HANGUL JUNGSEONG YU-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1193,
 },
 [0x1194]={
  category="lo",
  description="HANGUL JUNGSEONG YU-I",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1194,
 },
 [0x1195]={
  category="lo",
  description="HANGUL JUNGSEONG EU-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1195,
 },
 [0x1196]={
  category="lo",
  description="HANGUL JUNGSEONG EU-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1196,
 },
 [0x1197]={
  category="lo",
  description="HANGUL JUNGSEONG YI-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1197,
 },
 [0x1198]={
  category="lo",
  description="HANGUL JUNGSEONG I-A",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1198,
 },
 [0x1199]={
  category="lo",
  description="HANGUL JUNGSEONG I-YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1199,
 },
 [0x119A]={
  category="lo",
  description="HANGUL JUNGSEONG I-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119A,
 },
 [0x119B]={
  category="lo",
  description="HANGUL JUNGSEONG I-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119B,
 },
 [0x119C]={
  category="lo",
  description="HANGUL JUNGSEONG I-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119C,
 },
 [0x119D]={
  category="lo",
  description="HANGUL JUNGSEONG I-ARAEA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119D,
 },
 [0x119E]={
  category="lo",
  description="HANGUL JUNGSEONG ARAEA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119E,
 },
 [0x119F]={
  category="lo",
  description="HANGUL JUNGSEONG ARAEA-EO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119F,
 },
 [0x11A0]={
  category="lo",
  description="HANGUL JUNGSEONG ARAEA-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A0,
 },
 [0x11A1]={
  category="lo",
  description="HANGUL JUNGSEONG ARAEA-I",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A1,
 },
 [0x11A2]={
  category="lo",
  description="HANGUL JUNGSEONG SSANGARAEA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A2,
 },
 [0x11A3]={
  category="lo",
  description="HANGUL JUNGSEONG A-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A3,
 },
 [0x11A4]={
  category="lo",
  description="HANGUL JUNGSEONG YA-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A4,
 },
 [0x11A5]={
  category="lo",
  description="HANGUL JUNGSEONG YEO-YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A5,
 },
 [0x11A6]={
  category="lo",
  description="HANGUL JUNGSEONG O-YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A6,
 },
 [0x11A7]={
  category="lo",
  description="HANGUL JUNGSEONG O-YAE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A7,
 },
 [0x11A8]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11A8,
 },
 [0x11A9]={
  category="lo",
  description="HANGUL JONGSEONG SSANGKIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11A9,
 },
 [0x11AA]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AA,
 },
 [0x11AB]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AB,
 },
 [0x11AC]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-CIEUC",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AC,
 },
 [0x11AD]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AD,
 },
 [0x11AE]={
  category="lo",
  description="HANGUL JONGSEONG TIKEUT",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AE,
 },
 [0x11AF]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AF,
 },
 [0x11B0]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B0,
 },
 [0x11B1]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-MIEUM",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B1,
 },
 [0x11B2]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B2,
 },
 [0x11B3]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B3,
 },
 [0x11B4]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-THIEUTH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B4,
 },
 [0x11B5]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PHIEUPH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B5,
 },
 [0x11B6]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B6,
 },
 [0x11B7]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B7,
 },
 [0x11B8]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B8,
 },
 [0x11B9]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B9,
 },
 [0x11BA]={
  category="lo",
  description="HANGUL JONGSEONG SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BA,
 },
 [0x11BB]={
  category="lo",
  description="HANGUL JONGSEONG SSANGSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BB,
 },
 [0x11BC]={
  category="lo",
  description="HANGUL JONGSEONG IEUNG",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BC,
 },
 [0x11BD]={
  category="lo",
  description="HANGUL JONGSEONG CIEUC",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BD,
 },
 [0x11BE]={
  category="lo",
  description="HANGUL JONGSEONG CHIEUCH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BE,
 },
 [0x11BF]={
  category="lo",
  description="HANGUL JONGSEONG KHIEUKH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BF,
 },
 [0x11C0]={
  category="lo",
  description="HANGUL JONGSEONG THIEUTH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C0,
 },
 [0x11C1]={
  category="lo",
  description="HANGUL JONGSEONG PHIEUPH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C1,
 },
 [0x11C2]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C2,
 },
 [0x11C3]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C3,
 },
 [0x11C4]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C4,
 },
 [0x11C5]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C5,
 },
 [0x11C6]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-TIKEUT",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C6,
 },
 [0x11C7]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C7,
 },
 [0x11C8]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C8,
 },
 [0x11C9]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-THIEUTH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C9,
 },
 [0x11CA]={
  category="lo",
  description="HANGUL JONGSEONG TIKEUT-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CA,
 },
 [0x11CB]={
  category="lo",
  description="HANGUL JONGSEONG TIKEUT-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CB,
 },
 [0x11CC]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-KIYEOK-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CC,
 },
 [0x11CD]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-NIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CD,
 },
 [0x11CE]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-TIKEUT",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CE,
 },
 [0x11CF]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CF,
 },
 [0x11D0]={
  category="lo",
  description="HANGUL JONGSEONG SSANGRIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D0,
 },
 [0x11D1]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D1,
 },
 [0x11D2]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-MIEUM-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D2,
 },
 [0x11D3]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PIEUP-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D3,
 },
 [0x11D4]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PIEUP-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D4,
 },
 [0x11D5]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D5,
 },
 [0x11D6]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-SSANGSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D6,
 },
 [0x11D7]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D7,
 },
 [0x11D8]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-KHIEUKH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D8,
 },
 [0x11D9]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-YEORINHIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D9,
 },
 [0x11DA]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DA,
 },
 [0x11DB]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DB,
 },
 [0x11DC]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DC,
 },
 [0x11DD]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DD,
 },
 [0x11DE]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-SSANGSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DE,
 },
 [0x11DF]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DF,
 },
 [0x11E0]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-CHIEUCH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E0,
 },
 [0x11E1]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E1,
 },
 [0x11E2]={
  category="lo",
  description="HANGUL JONGSEONG KAPYEOUNMIEUM",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E2,
 },
 [0x11E3]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E3,
 },
 [0x11E4]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP-PHIEUPH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E4,
 },
 [0x11E5]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E5,
 },
 [0x11E6]={
  category="lo",
  description="HANGUL JONGSEONG KAPYEOUNPIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E6,
 },
 [0x11E7]={
  category="lo",
  description="HANGUL JONGSEONG SIOS-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E7,
 },
 [0x11E8]={
  category="lo",
  description="HANGUL JONGSEONG SIOS-TIKEUT",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E8,
 },
 [0x11E9]={
  category="lo",
  description="HANGUL JONGSEONG SIOS-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E9,
 },
 [0x11EA]={
  category="lo",
  description="HANGUL JONGSEONG SIOS-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EA,
 },
 [0x11EB]={
  category="lo",
  description="HANGUL JONGSEONG PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EB,
 },
 [0x11EC]={
  category="lo",
  description="HANGUL JONGSEONG IEUNG-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EC,
 },
 [0x11ED]={
  category="lo",
  description="HANGUL JONGSEONG IEUNG-SSANGKIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11ED,
 },
 [0x11EE]={
  category="lo",
  description="HANGUL JONGSEONG SSANGIEUNG",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EE,
 },
 [0x11EF]={
  category="lo",
  description="HANGUL JONGSEONG IEUNG-KHIEUKH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EF,
 },
 [0x11F0]={
  category="lo",
  description="HANGUL JONGSEONG YESIEUNG",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F0,
 },
 [0x11F1]={
  category="lo",
  description="HANGUL JONGSEONG YESIEUNG-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F1,
 },
 [0x11F2]={
  category="lo",
  description="HANGUL JONGSEONG YESIEUNG-PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F2,
 },
 [0x11F3]={
  category="lo",
  description="HANGUL JONGSEONG PHIEUPH-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F3,
 },
 [0x11F4]={
  category="lo",
  description="HANGUL JONGSEONG KAPYEOUNPHIEUPH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F4,
 },
 [0x11F5]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH-NIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F5,
 },
 [0x11F6]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F6,
 },
 [0x11F7]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH-MIEUM",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F7,
 },
 [0x11F8]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F8,
 },
 [0x11F9]={
  category="lo",
  description="HANGUL JONGSEONG YEORINHIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F9,
 },
 [0x11FA]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-NIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FA,
 },
 [0x11FB]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FB,
 },
 [0x11FC]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-CHIEUCH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FC,
 },
 [0x11FD]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-KHIEUKH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FD,
 },
 [0x11FE]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FE,
 },
 [0x11FF]={
  category="lo",
  description="HANGUL JONGSEONG SSANGNIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FF,
 },
 [0x1200]={
  category="lo",
  description="ETHIOPIC SYLLABLE HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1200,
 },
 [0x1201]={
  category="lo",
  description="ETHIOPIC SYLLABLE HU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1201,
 },
 [0x1202]={
  category="lo",
  description="ETHIOPIC SYLLABLE HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1202,
 },
 [0x1203]={
  category="lo",
  description="ETHIOPIC SYLLABLE HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1203,
 },
 [0x1204]={
  category="lo",
  description="ETHIOPIC SYLLABLE HEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1204,
 },
 [0x1205]={
  category="lo",
  description="ETHIOPIC SYLLABLE HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1205,
 },
 [0x1206]={
  category="lo",
  description="ETHIOPIC SYLLABLE HO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1206,
 },
 [0x1207]={
  category="lo",
  description="ETHIOPIC SYLLABLE HOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1207,
 },
 [0x1208]={
  category="lo",
  description="ETHIOPIC SYLLABLE LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1208,
 },
 [0x1209]={
  category="lo",
  description="ETHIOPIC SYLLABLE LU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1209,
 },
 [0x120A]={
  category="lo",
  description="ETHIOPIC SYLLABLE LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x120A,
 },
 [0x120B]={
  category="lo",
  description="ETHIOPIC SYLLABLE LAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x120B,
 },
 [0x120C]={
  category="lo",
  description="ETHIOPIC SYLLABLE LEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x120C,
 },
 [0x120D]={
  category="lo",
  description="ETHIOPIC SYLLABLE LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x120D,
 },
 [0x120E]={
  category="lo",
  description="ETHIOPIC SYLLABLE LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x120E,
 },
 [0x120F]={
  category="lo",
  description="ETHIOPIC SYLLABLE LWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x120F,
 },
 [0x1210]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1210,
 },
 [0x1211]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1211,
 },
 [0x1212]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1212,
 },
 [0x1213]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1213,
 },
 [0x1214]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1214,
 },
 [0x1215]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1215,
 },
 [0x1216]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1216,
 },
 [0x1217]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1217,
 },
 [0x1218]={
  category="lo",
  description="ETHIOPIC SYLLABLE MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1218,
 },
 [0x1219]={
  category="lo",
  description="ETHIOPIC SYLLABLE MU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1219,
 },
 [0x121A]={
  category="lo",
  description="ETHIOPIC SYLLABLE MI",
  direction="l",
  linebreak="al",
  unicodeslot=0x121A,
 },
 [0x121B]={
  category="lo",
  description="ETHIOPIC SYLLABLE MAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x121B,
 },
 [0x121C]={
  category="lo",
  description="ETHIOPIC SYLLABLE MEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x121C,
 },
 [0x121D]={
  category="lo",
  description="ETHIOPIC SYLLABLE ME",
  direction="l",
  linebreak="al",
  unicodeslot=0x121D,
 },
 [0x121E]={
  category="lo",
  description="ETHIOPIC SYLLABLE MO",
  direction="l",
  linebreak="al",
  unicodeslot=0x121E,
 },
 [0x121F]={
  category="lo",
  description="ETHIOPIC SYLLABLE MWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x121F,
 },
 [0x1220]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1220,
 },
 [0x1221]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1221,
 },
 [0x1222]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1222,
 },
 [0x1223]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1223,
 },
 [0x1224]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1224,
 },
 [0x1225]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1225,
 },
 [0x1226]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1226,
 },
 [0x1227]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1227,
 },
 [0x1228]={
  category="lo",
  description="ETHIOPIC SYLLABLE RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1228,
 },
 [0x1229]={
  category="lo",
  description="ETHIOPIC SYLLABLE RU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1229,
 },
 [0x122A]={
  category="lo",
  description="ETHIOPIC SYLLABLE RI",
  direction="l",
  linebreak="al",
  unicodeslot=0x122A,
 },
 [0x122B]={
  category="lo",
  description="ETHIOPIC SYLLABLE RAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x122B,
 },
 [0x122C]={
  category="lo",
  description="ETHIOPIC SYLLABLE REE",
  direction="l",
  linebreak="al",
  unicodeslot=0x122C,
 },
 [0x122D]={
  category="lo",
  description="ETHIOPIC SYLLABLE RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x122D,
 },
 [0x122E]={
  category="lo",
  description="ETHIOPIC SYLLABLE RO",
  direction="l",
  linebreak="al",
  unicodeslot=0x122E,
 },
 [0x122F]={
  category="lo",
  description="ETHIOPIC SYLLABLE RWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x122F,
 },
 [0x1230]={
  category="lo",
  description="ETHIOPIC SYLLABLE SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1230,
 },
 [0x1231]={
  category="lo",
  description="ETHIOPIC SYLLABLE SU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1231,
 },
 [0x1232]={
  category="lo",
  description="ETHIOPIC SYLLABLE SI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1232,
 },
 [0x1233]={
  category="lo",
  description="ETHIOPIC SYLLABLE SAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1233,
 },
 [0x1234]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1234,
 },
 [0x1235]={
  category="lo",
  description="ETHIOPIC SYLLABLE SE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1235,
 },
 [0x1236]={
  category="lo",
  description="ETHIOPIC SYLLABLE SO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1236,
 },
 [0x1237]={
  category="lo",
  description="ETHIOPIC SYLLABLE SWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1237,
 },
 [0x1238]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1238,
 },
 [0x1239]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1239,
 },
 [0x123A]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x123A,
 },
 [0x123B]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x123B,
 },
 [0x123C]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x123C,
 },
 [0x123D]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x123D,
 },
 [0x123E]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x123E,
 },
 [0x123F]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x123F,
 },
 [0x1240]={
  category="lo",
  description="ETHIOPIC SYLLABLE QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1240,
 },
 [0x1241]={
  category="lo",
  description="ETHIOPIC SYLLABLE QU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1241,
 },
 [0x1242]={
  category="lo",
  description="ETHIOPIC SYLLABLE QI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1242,
 },
 [0x1243]={
  category="lo",
  description="ETHIOPIC SYLLABLE QAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1243,
 },
 [0x1244]={
  category="lo",
  description="ETHIOPIC SYLLABLE QEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1244,
 },
 [0x1245]={
  category="lo",
  description="ETHIOPIC SYLLABLE QE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1245,
 },
 [0x1246]={
  category="lo",
  description="ETHIOPIC SYLLABLE QO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1246,
 },
 [0x1247]={
  category="lo",
  description="ETHIOPIC SYLLABLE QOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1247,
 },
 [0x1248]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1248,
 },
 [0x124A]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x124A,
 },
 [0x124B]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x124B,
 },
 [0x124C]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x124C,
 },
 [0x124D]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x124D,
 },
 [0x1250]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1250,
 },
 [0x1251]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1251,
 },
 [0x1252]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1252,
 },
 [0x1253]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1253,
 },
 [0x1254]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1254,
 },
 [0x1255]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1255,
 },
 [0x1256]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1256,
 },
 [0x1258]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1258,
 },
 [0x125A]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x125A,
 },
 [0x125B]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x125B,
 },
 [0x125C]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x125C,
 },
 [0x125D]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x125D,
 },
 [0x1260]={
  category="lo",
  description="ETHIOPIC SYLLABLE BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1260,
 },
 [0x1261]={
  category="lo",
  description="ETHIOPIC SYLLABLE BU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1261,
 },
 [0x1262]={
  category="lo",
  description="ETHIOPIC SYLLABLE BI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1262,
 },
 [0x1263]={
  category="lo",
  description="ETHIOPIC SYLLABLE BAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1263,
 },
 [0x1264]={
  category="lo",
  description="ETHIOPIC SYLLABLE BEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1264,
 },
 [0x1265]={
  category="lo",
  description="ETHIOPIC SYLLABLE BE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1265,
 },
 [0x1266]={
  category="lo",
  description="ETHIOPIC SYLLABLE BO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1266,
 },
 [0x1267]={
  category="lo",
  description="ETHIOPIC SYLLABLE BWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1267,
 },
 [0x1268]={
  category="lo",
  description="ETHIOPIC SYLLABLE VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1268,
 },
 [0x1269]={
  category="lo",
  description="ETHIOPIC SYLLABLE VU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1269,
 },
 [0x126A]={
  category="lo",
  description="ETHIOPIC SYLLABLE VI",
  direction="l",
  linebreak="al",
  unicodeslot=0x126A,
 },
 [0x126B]={
  category="lo",
  description="ETHIOPIC SYLLABLE VAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x126B,
 },
 [0x126C]={
  category="lo",
  description="ETHIOPIC SYLLABLE VEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x126C,
 },
 [0x126D]={
  category="lo",
  description="ETHIOPIC SYLLABLE VE",
  direction="l",
  linebreak="al",
  unicodeslot=0x126D,
 },
 [0x126E]={
  category="lo",
  description="ETHIOPIC SYLLABLE VO",
  direction="l",
  linebreak="al",
  unicodeslot=0x126E,
 },
 [0x126F]={
  category="lo",
  description="ETHIOPIC SYLLABLE VWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x126F,
 },
 [0x1270]={
  category="lo",
  description="ETHIOPIC SYLLABLE TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1270,
 },
 [0x1271]={
  category="lo",
  description="ETHIOPIC SYLLABLE TU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1271,
 },
 [0x1272]={
  category="lo",
  description="ETHIOPIC SYLLABLE TI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1272,
 },
 [0x1273]={
  category="lo",
  description="ETHIOPIC SYLLABLE TAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1273,
 },
 [0x1274]={
  category="lo",
  description="ETHIOPIC SYLLABLE TEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1274,
 },
 [0x1275]={
  category="lo",
  description="ETHIOPIC SYLLABLE TE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1275,
 },
 [0x1276]={
  category="lo",
  description="ETHIOPIC SYLLABLE TO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1276,
 },
 [0x1277]={
  category="lo",
  description="ETHIOPIC SYLLABLE TWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1277,
 },
 [0x1278]={
  category="lo",
  description="ETHIOPIC SYLLABLE CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1278,
 },
 [0x1279]={
  category="lo",
  description="ETHIOPIC SYLLABLE CU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1279,
 },
 [0x127A]={
  category="lo",
  description="ETHIOPIC SYLLABLE CI",
  direction="l",
  linebreak="al",
  unicodeslot=0x127A,
 },
 [0x127B]={
  category="lo",
  description="ETHIOPIC SYLLABLE CAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x127B,
 },
 [0x127C]={
  category="lo",
  description="ETHIOPIC SYLLABLE CEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x127C,
 },
 [0x127D]={
  category="lo",
  description="ETHIOPIC SYLLABLE CE",
  direction="l",
  linebreak="al",
  unicodeslot=0x127D,
 },
 [0x127E]={
  category="lo",
  description="ETHIOPIC SYLLABLE CO",
  direction="l",
  linebreak="al",
  unicodeslot=0x127E,
 },
 [0x127F]={
  category="lo",
  description="ETHIOPIC SYLLABLE CWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x127F,
 },
 [0x1280]={
  category="lo",
  description="ETHIOPIC SYLLABLE XA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1280,
 },
 [0x1281]={
  category="lo",
  description="ETHIOPIC SYLLABLE XU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1281,
 },
 [0x1282]={
  category="lo",
  description="ETHIOPIC SYLLABLE XI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1282,
 },
 [0x1283]={
  category="lo",
  description="ETHIOPIC SYLLABLE XAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1283,
 },
 [0x1284]={
  category="lo",
  description="ETHIOPIC SYLLABLE XEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1284,
 },
 [0x1285]={
  category="lo",
  description="ETHIOPIC SYLLABLE XE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1285,
 },
 [0x1286]={
  category="lo",
  description="ETHIOPIC SYLLABLE XO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1286,
 },
 [0x1287]={
  category="lo",
  description="ETHIOPIC SYLLABLE XOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1287,
 },
 [0x1288]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1288,
 },
 [0x128A]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x128A,
 },
 [0x128B]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x128B,
 },
 [0x128C]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x128C,
 },
 [0x128D]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x128D,
 },
 [0x1290]={
  category="lo",
  description="ETHIOPIC SYLLABLE NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1290,
 },
 [0x1291]={
  category="lo",
  description="ETHIOPIC SYLLABLE NU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1291,
 },
 [0x1292]={
  category="lo",
  description="ETHIOPIC SYLLABLE NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1292,
 },
 [0x1293]={
  category="lo",
  description="ETHIOPIC SYLLABLE NAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1293,
 },
 [0x1294]={
  category="lo",
  description="ETHIOPIC SYLLABLE NEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1294,
 },
 [0x1295]={
  category="lo",
  description="ETHIOPIC SYLLABLE NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1295,
 },
 [0x1296]={
  category="lo",
  description="ETHIOPIC SYLLABLE NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1296,
 },
 [0x1297]={
  category="lo",
  description="ETHIOPIC SYLLABLE NWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1297,
 },
 [0x1298]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1298,
 },
 [0x1299]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1299,
 },
 [0x129A]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYI",
  direction="l",
  linebreak="al",
  unicodeslot=0x129A,
 },
 [0x129B]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x129B,
 },
 [0x129C]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x129C,
 },
 [0x129D]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYE",
  direction="l",
  linebreak="al",
  unicodeslot=0x129D,
 },
 [0x129E]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYO",
  direction="l",
  linebreak="al",
  unicodeslot=0x129E,
 },
 [0x129F]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x129F,
 },
 [0x12A0]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL A",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A0,
 },
 [0x12A1]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL U",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A1,
 },
 [0x12A2]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL I",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A2,
 },
 [0x12A3]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A3,
 },
 [0x12A4]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A4,
 },
 [0x12A5]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL E",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A5,
 },
 [0x12A6]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL O",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A6,
 },
 [0x12A7]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A7,
 },
 [0x12A8]={
  category="lo",
  description="ETHIOPIC SYLLABLE KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A8,
 },
 [0x12A9]={
  category="lo",
  description="ETHIOPIC SYLLABLE KU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A9,
 },
 [0x12AA]={
  category="lo",
  description="ETHIOPIC SYLLABLE KI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AA,
 },
 [0x12AB]={
  category="lo",
  description="ETHIOPIC SYLLABLE KAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AB,
 },
 [0x12AC]={
  category="lo",
  description="ETHIOPIC SYLLABLE KEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AC,
 },
 [0x12AD]={
  category="lo",
  description="ETHIOPIC SYLLABLE KE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AD,
 },
 [0x12AE]={
  category="lo",
  description="ETHIOPIC SYLLABLE KO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AE,
 },
 [0x12AF]={
  category="lo",
  description="ETHIOPIC SYLLABLE KOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AF,
 },
 [0x12B0]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B0,
 },
 [0x12B2]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B2,
 },
 [0x12B3]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B3,
 },
 [0x12B4]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B4,
 },
 [0x12B5]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B5,
 },
 [0x12B8]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B8,
 },
 [0x12B9]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B9,
 },
 [0x12BA]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BA,
 },
 [0x12BB]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BB,
 },
 [0x12BC]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BC,
 },
 [0x12BD]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BD,
 },
 [0x12BE]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BE,
 },
 [0x12C0]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C0,
 },
 [0x12C2]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C2,
 },
 [0x12C3]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C3,
 },
 [0x12C4]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C4,
 },
 [0x12C5]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C5,
 },
 [0x12C8]={
  category="lo",
  description="ETHIOPIC SYLLABLE WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C8,
 },
 [0x12C9]={
  category="lo",
  description="ETHIOPIC SYLLABLE WU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C9,
 },
 [0x12CA]={
  category="lo",
  description="ETHIOPIC SYLLABLE WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CA,
 },
 [0x12CB]={
  category="lo",
  description="ETHIOPIC SYLLABLE WAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CB,
 },
 [0x12CC]={
  category="lo",
  description="ETHIOPIC SYLLABLE WEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CC,
 },
 [0x12CD]={
  category="lo",
  description="ETHIOPIC SYLLABLE WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CD,
 },
 [0x12CE]={
  category="lo",
  description="ETHIOPIC SYLLABLE WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CE,
 },
 [0x12CF]={
  category="lo",
  description="ETHIOPIC SYLLABLE WOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CF,
 },
 [0x12D0]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL A",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D0,
 },
 [0x12D1]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL U",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D1,
 },
 [0x12D2]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL I",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D2,
 },
 [0x12D3]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D3,
 },
 [0x12D4]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D4,
 },
 [0x12D5]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL E",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D5,
 },
 [0x12D6]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL O",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D6,
 },
 [0x12D8]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D8,
 },
 [0x12D9]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D9,
 },
 [0x12DA]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DA,
 },
 [0x12DB]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DB,
 },
 [0x12DC]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DC,
 },
 [0x12DD]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DD,
 },
 [0x12DE]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DE,
 },
 [0x12DF]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DF,
 },
 [0x12E0]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E0,
 },
 [0x12E1]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E1,
 },
 [0x12E2]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E2,
 },
 [0x12E3]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E3,
 },
 [0x12E4]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E4,
 },
 [0x12E5]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E5,
 },
 [0x12E6]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E6,
 },
 [0x12E7]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E7,
 },
 [0x12E8]={
  category="lo",
  description="ETHIOPIC SYLLABLE YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E8,
 },
 [0x12E9]={
  category="lo",
  description="ETHIOPIC SYLLABLE YU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E9,
 },
 [0x12EA]={
  category="lo",
  description="ETHIOPIC SYLLABLE YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EA,
 },
 [0x12EB]={
  category="lo",
  description="ETHIOPIC SYLLABLE YAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EB,
 },
 [0x12EC]={
  category="lo",
  description="ETHIOPIC SYLLABLE YEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EC,
 },
 [0x12ED]={
  category="lo",
  description="ETHIOPIC SYLLABLE YE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12ED,
 },
 [0x12EE]={
  category="lo",
  description="ETHIOPIC SYLLABLE YO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EE,
 },
 [0x12EF]={
  category="lo",
  description="ETHIOPIC SYLLABLE YOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EF,
 },
 [0x12F0]={
  category="lo",
  description="ETHIOPIC SYLLABLE DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F0,
 },
 [0x12F1]={
  category="lo",
  description="ETHIOPIC SYLLABLE DU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F1,
 },
 [0x12F2]={
  category="lo",
  description="ETHIOPIC SYLLABLE DI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F2,
 },
 [0x12F3]={
  category="lo",
  description="ETHIOPIC SYLLABLE DAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F3,
 },
 [0x12F4]={
  category="lo",
  description="ETHIOPIC SYLLABLE DEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F4,
 },
 [0x12F5]={
  category="lo",
  description="ETHIOPIC SYLLABLE DE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F5,
 },
 [0x12F6]={
  category="lo",
  description="ETHIOPIC SYLLABLE DO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F6,
 },
 [0x12F7]={
  category="lo",
  description="ETHIOPIC SYLLABLE DWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F7,
 },
 [0x12F8]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F8,
 },
 [0x12F9]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F9,
 },
 [0x12FA]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FA,
 },
 [0x12FB]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FB,
 },
 [0x12FC]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FC,
 },
 [0x12FD]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FD,
 },
 [0x12FE]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FE,
 },
 [0x12FF]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FF,
 },
 [0x1300]={
  category="lo",
  description="ETHIOPIC SYLLABLE JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1300,
 },
 [0x1301]={
  category="lo",
  description="ETHIOPIC SYLLABLE JU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1301,
 },
 [0x1302]={
  category="lo",
  description="ETHIOPIC SYLLABLE JI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1302,
 },
 [0x1303]={
  category="lo",
  description="ETHIOPIC SYLLABLE JAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1303,
 },
 [0x1304]={
  category="lo",
  description="ETHIOPIC SYLLABLE JEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1304,
 },
 [0x1305]={
  category="lo",
  description="ETHIOPIC SYLLABLE JE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1305,
 },
 [0x1306]={
  category="lo",
  description="ETHIOPIC SYLLABLE JO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1306,
 },
 [0x1307]={
  category="lo",
  description="ETHIOPIC SYLLABLE JWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1307,
 },
 [0x1308]={
  category="lo",
  description="ETHIOPIC SYLLABLE GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1308,
 },
 [0x1309]={
  category="lo",
  description="ETHIOPIC SYLLABLE GU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1309,
 },
 [0x130A]={
  category="lo",
  description="ETHIOPIC SYLLABLE GI",
  direction="l",
  linebreak="al",
  unicodeslot=0x130A,
 },
 [0x130B]={
  category="lo",
  description="ETHIOPIC SYLLABLE GAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x130B,
 },
 [0x130C]={
  category="lo",
  description="ETHIOPIC SYLLABLE GEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x130C,
 },
 [0x130D]={
  category="lo",
  description="ETHIOPIC SYLLABLE GE",
  direction="l",
  linebreak="al",
  unicodeslot=0x130D,
 },
 [0x130E]={
  category="lo",
  description="ETHIOPIC SYLLABLE GO",
  direction="l",
  linebreak="al",
  unicodeslot=0x130E,
 },
 [0x130F]={
  category="lo",
  description="ETHIOPIC SYLLABLE GOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x130F,
 },
 [0x1310]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1310,
 },
 [0x1312]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1312,
 },
 [0x1313]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1313,
 },
 [0x1314]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1314,
 },
 [0x1315]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1315,
 },
 [0x1318]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1318,
 },
 [0x1319]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1319,
 },
 [0x131A]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGI",
  direction="l",
  linebreak="al",
  unicodeslot=0x131A,
 },
 [0x131B]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x131B,
 },
 [0x131C]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x131C,
 },
 [0x131D]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGE",
  direction="l",
  linebreak="al",
  unicodeslot=0x131D,
 },
 [0x131E]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGO",
  direction="l",
  linebreak="al",
  unicodeslot=0x131E,
 },
 [0x131F]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x131F,
 },
 [0x1320]={
  category="lo",
  description="ETHIOPIC SYLLABLE THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1320,
 },
 [0x1321]={
  category="lo",
  description="ETHIOPIC SYLLABLE THU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1321,
 },
 [0x1322]={
  category="lo",
  description="ETHIOPIC SYLLABLE THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1322,
 },
 [0x1323]={
  category="lo",
  description="ETHIOPIC SYLLABLE THAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1323,
 },
 [0x1324]={
  category="lo",
  description="ETHIOPIC SYLLABLE THEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1324,
 },
 [0x1325]={
  category="lo",
  description="ETHIOPIC SYLLABLE THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1325,
 },
 [0x1326]={
  category="lo",
  description="ETHIOPIC SYLLABLE THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1326,
 },
 [0x1327]={
  category="lo",
  description="ETHIOPIC SYLLABLE THWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1327,
 },
 [0x1328]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1328,
 },
 [0x1329]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1329,
 },
 [0x132A]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x132A,
 },
 [0x132B]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x132B,
 },
 [0x132C]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x132C,
 },
 [0x132D]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x132D,
 },
 [0x132E]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x132E,
 },
 [0x132F]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x132F,
 },
 [0x1330]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1330,
 },
 [0x1331]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1331,
 },
 [0x1332]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1332,
 },
 [0x1333]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1333,
 },
 [0x1334]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1334,
 },
 [0x1335]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1335,
 },
 [0x1336]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1336,
 },
 [0x1337]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1337,
 },
 [0x1338]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1338,
 },
 [0x1339]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1339,
 },
 [0x133A]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSI",
  direction="l",
  linebreak="al",
  unicodeslot=0x133A,
 },
 [0x133B]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x133B,
 },
 [0x133C]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x133C,
 },
 [0x133D]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSE",
  direction="l",
  linebreak="al",
  unicodeslot=0x133D,
 },
 [0x133E]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSO",
  direction="l",
  linebreak="al",
  unicodeslot=0x133E,
 },
 [0x133F]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x133F,
 },
 [0x1340]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1340,
 },
 [0x1341]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1341,
 },
 [0x1342]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1342,
 },
 [0x1343]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1343,
 },
 [0x1344]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1344,
 },
 [0x1345]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1345,
 },
 [0x1346]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1346,
 },
 [0x1347]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1347,
 },
 [0x1348]={
  category="lo",
  description="ETHIOPIC SYLLABLE FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1348,
 },
 [0x1349]={
  category="lo",
  description="ETHIOPIC SYLLABLE FU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1349,
 },
 [0x134A]={
  category="lo",
  description="ETHIOPIC SYLLABLE FI",
  direction="l",
  linebreak="al",
  unicodeslot=0x134A,
 },
 [0x134B]={
  category="lo",
  description="ETHIOPIC SYLLABLE FAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x134B,
 },
 [0x134C]={
  category="lo",
  description="ETHIOPIC SYLLABLE FEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x134C,
 },
 [0x134D]={
  category="lo",
  description="ETHIOPIC SYLLABLE FE",
  direction="l",
  linebreak="al",
  unicodeslot=0x134D,
 },
 [0x134E]={
  category="lo",
  description="ETHIOPIC SYLLABLE FO",
  direction="l",
  linebreak="al",
  unicodeslot=0x134E,
 },
 [0x134F]={
  category="lo",
  description="ETHIOPIC SYLLABLE FWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x134F,
 },
 [0x1350]={
  category="lo",
  description="ETHIOPIC SYLLABLE PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1350,
 },
 [0x1351]={
  category="lo",
  description="ETHIOPIC SYLLABLE PU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1351,
 },
 [0x1352]={
  category="lo",
  description="ETHIOPIC SYLLABLE PI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1352,
 },
 [0x1353]={
  category="lo",
  description="ETHIOPIC SYLLABLE PAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1353,
 },
 [0x1354]={
  category="lo",
  description="ETHIOPIC SYLLABLE PEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1354,
 },
 [0x1355]={
  category="lo",
  description="ETHIOPIC SYLLABLE PE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1355,
 },
 [0x1356]={
  category="lo",
  description="ETHIOPIC SYLLABLE PO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1356,
 },
 [0x1357]={
  category="lo",
  description="ETHIOPIC SYLLABLE PWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1357,
 },
 [0x1358]={
  category="lo",
  description="ETHIOPIC SYLLABLE RYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1358,
 },
 [0x1359]={
  category="lo",
  description="ETHIOPIC SYLLABLE MYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1359,
 },
 [0x135A]={
  category="lo",
  description="ETHIOPIC SYLLABLE FYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x135A,
 },
 [0x135D]={
  category="mn",
  combining=0xE6,
  description="ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x135D,
 },
 [0x135E]={
  category="mn",
  combining=0xE6,
  description="ETHIOPIC COMBINING VOWEL LENGTH MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x135E,
 },
 [0x135F]={
  category="mn",
  combining=0xE6,
  description="ETHIOPIC COMBINING GEMINATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x135F,
 },
 [0x1360]={
  category="so",
  description="ETHIOPIC SECTION MARK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1360,
 },
 [0x1361]={
  category="po",
  description="ETHIOPIC WORDSPACE",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1361,
 },
 [0x1362]={
  category="po",
  description="ETHIOPIC FULL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x1362,
 },
 [0x1363]={
  category="po",
  description="ETHIOPIC COMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1363,
 },
 [0x1364]={
  category="po",
  description="ETHIOPIC SEMICOLON",
  direction="l",
  linebreak="al",
  unicodeslot=0x1364,
 },
 [0x1365]={
  category="po",
  description="ETHIOPIC COLON",
  direction="l",
  linebreak="al",
  unicodeslot=0x1365,
 },
 [0x1366]={
  category="po",
  description="ETHIOPIC PREFACE COLON",
  direction="l",
  linebreak="al",
  unicodeslot=0x1366,
 },
 [0x1367]={
  category="po",
  description="ETHIOPIC QUESTION MARK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1367,
 },
 [0x1368]={
  category="po",
  description="ETHIOPIC PARAGRAPH SEPARATOR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1368,
 },
 [0x1369]={
  category="no",
  description="ETHIOPIC DIGIT ONE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1369,
 },
 [0x136A]={
  category="no",
  description="ETHIOPIC DIGIT TWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x136A,
 },
 [0x136B]={
  category="no",
  description="ETHIOPIC DIGIT THREE",
  direction="l",
  linebreak="al",
  unicodeslot=0x136B,
 },
 [0x136C]={
  category="no",
  description="ETHIOPIC DIGIT FOUR",
  direction="l",
  linebreak="al",
  unicodeslot=0x136C,
 },
 [0x136D]={
  category="no",
  description="ETHIOPIC DIGIT FIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x136D,
 },
 [0x136E]={
  category="no",
  description="ETHIOPIC DIGIT SIX",
  direction="l",
  linebreak="al",
  unicodeslot=0x136E,
 },
 [0x136F]={
  category="no",
  description="ETHIOPIC DIGIT SEVEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x136F,
 },
 [0x1370]={
  category="no",
  description="ETHIOPIC DIGIT EIGHT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1370,
 },
 [0x1371]={
  category="no",
  description="ETHIOPIC DIGIT NINE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1371,
 },
 [0x1372]={
  category="no",
  description="ETHIOPIC NUMBER TEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1372,
 },
 [0x1373]={
  category="no",
  description="ETHIOPIC NUMBER TWENTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1373,
 },
 [0x1374]={
  category="no",
  description="ETHIOPIC NUMBER THIRTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1374,
 },
 [0x1375]={
  category="no",
  description="ETHIOPIC NUMBER FORTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1375,
 },
 [0x1376]={
  category="no",
  description="ETHIOPIC NUMBER FIFTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1376,
 },
 [0x1377]={
  category="no",
  description="ETHIOPIC NUMBER SIXTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1377,
 },
 [0x1378]={
  category="no",
  description="ETHIOPIC NUMBER SEVENTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1378,
 },
 [0x1379]={
  category="no",
  description="ETHIOPIC NUMBER EIGHTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1379,
 },
 [0x137A]={
  category="no",
  description="ETHIOPIC NUMBER NINETY",
  direction="l",
  linebreak="al",
  unicodeslot=0x137A,
 },
 [0x137B]={
  category="no",
  description="ETHIOPIC NUMBER HUNDRED",
  direction="l",
  linebreak="al",
  unicodeslot=0x137B,
 },
 [0x137C]={
  category="no",
  description="ETHIOPIC NUMBER TEN THOUSAND",
  direction="l",
  linebreak="al",
  unicodeslot=0x137C,
 },
 [0x1380]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEBATBEIT MWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1380,
 },
 [0x1381]={
  category="lo",
  description="ETHIOPIC SYLLABLE MWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1381,
 },
 [0x1382]={
  category="lo",
  description="ETHIOPIC SYLLABLE MWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1382,
 },
 [0x1383]={
  category="lo",
  description="ETHIOPIC SYLLABLE MWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1383,
 },
 [0x1384]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEBATBEIT BWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1384,
 },
 [0x1385]={
  category="lo",
  description="ETHIOPIC SYLLABLE BWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1385,
 },
 [0x1386]={
  category="lo",
  description="ETHIOPIC SYLLABLE BWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1386,
 },
 [0x1387]={
  category="lo",
  description="ETHIOPIC SYLLABLE BWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1387,
 },
 [0x1388]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEBATBEIT FWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1388,
 },
 [0x1389]={
  category="lo",
  description="ETHIOPIC SYLLABLE FWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1389,
 },
 [0x138A]={
  category="lo",
  description="ETHIOPIC SYLLABLE FWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x138A,
 },
 [0x138B]={
  category="lo",
  description="ETHIOPIC SYLLABLE FWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x138B,
 },
 [0x138C]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEBATBEIT PWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x138C,
 },
 [0x138D]={
  category="lo",
  description="ETHIOPIC SYLLABLE PWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x138D,
 },
 [0x138E]={
  category="lo",
  description="ETHIOPIC SYLLABLE PWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x138E,
 },
 [0x138F]={
  category="lo",
  description="ETHIOPIC SYLLABLE PWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x138F,
 },
 [0x1390]={
  category="so",
  description="ETHIOPIC TONAL MARK YIZET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1390,
 },
 [0x1391]={
  category="so",
  description="ETHIOPIC TONAL MARK DERET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1391,
 },
 [0x1392]={
  category="so",
  description="ETHIOPIC TONAL MARK RIKRIK",
  direction="on",
  linebreak="al",
  unicodeslot=0x1392,
 },
 [0x1393]={
  category="so",
  description="ETHIOPIC TONAL MARK SHORT RIKRIK",
  direction="on",
  linebreak="al",
  unicodeslot=0x1393,
 },
 [0x1394]={
  category="so",
  description="ETHIOPIC TONAL MARK DIFAT",
  direction="on",
  linebreak="al",
  unicodeslot=0x1394,
 },
 [0x1395]={
  category="so",
  description="ETHIOPIC TONAL MARK KENAT",
  direction="on",
  linebreak="al",
  unicodeslot=0x1395,
 },
 [0x1396]={
  category="so",
  description="ETHIOPIC TONAL MARK CHIRET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1396,
 },
 [0x1397]={
  category="so",
  description="ETHIOPIC TONAL MARK HIDET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1397,
 },
 [0x1398]={
  category="so",
  description="ETHIOPIC TONAL MARK DERET-HIDET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1398,
 },
 [0x1399]={
  category="so",
  description="ETHIOPIC TONAL MARK KURT",
  direction="on",
  linebreak="al",
  unicodeslot=0x1399,
 },
 [0x13A0]={
  category="lo",
  description="CHEROKEE LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A0,
 },
 [0x13A1]={
  category="lo",
  description="CHEROKEE LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A1,
 },
 [0x13A2]={
  category="lo",
  description="CHEROKEE LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A2,
 },
 [0x13A3]={
  category="lo",
  description="CHEROKEE LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A3,
 },
 [0x13A4]={
  category="lo",
  description="CHEROKEE LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A4,
 },
 [0x13A5]={
  category="lo",
  description="CHEROKEE LETTER V",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A5,
 },
 [0x13A6]={
  category="lo",
  description="CHEROKEE LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A6,
 },
 [0x13A7]={
  category="lo",
  description="CHEROKEE LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A7,
 },
 [0x13A8]={
  category="lo",
  description="CHEROKEE LETTER GE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A8,
 },
 [0x13A9]={
  category="lo",
  description="CHEROKEE LETTER GI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A9,
 },
 [0x13AA]={
  category="lo",
  description="CHEROKEE LETTER GO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AA,
 },
 [0x13AB]={
  category="lo",
  description="CHEROKEE LETTER GU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AB,
 },
 [0x13AC]={
  category="lo",
  description="CHEROKEE LETTER GV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AC,
 },
 [0x13AD]={
  category="lo",
  description="CHEROKEE LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AD,
 },
 [0x13AE]={
  category="lo",
  description="CHEROKEE LETTER HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AE,
 },
 [0x13AF]={
  category="lo",
  description="CHEROKEE LETTER HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AF,
 },
 [0x13B0]={
  category="lo",
  description="CHEROKEE LETTER HO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B0,
 },
 [0x13B1]={
  category="lo",
  description="CHEROKEE LETTER HU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B1,
 },
 [0x13B2]={
  category="lo",
  description="CHEROKEE LETTER HV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B2,
 },
 [0x13B3]={
  category="lo",
  description="CHEROKEE LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B3,
 },
 [0x13B4]={
  category="lo",
  description="CHEROKEE LETTER LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B4,
 },
 [0x13B5]={
  category="lo",
  description="CHEROKEE LETTER LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B5,
 },
 [0x13B6]={
  category="lo",
  description="CHEROKEE LETTER LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B6,
 },
 [0x13B7]={
  category="lo",
  description="CHEROKEE LETTER LU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B7,
 },
 [0x13B8]={
  category="lo",
  description="CHEROKEE LETTER LV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B8,
 },
 [0x13B9]={
  category="lo",
  description="CHEROKEE LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B9,
 },
 [0x13BA]={
  category="lo",
  description="CHEROKEE LETTER ME",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BA,
 },
 [0x13BB]={
  category="lo",
  description="CHEROKEE LETTER MI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BB,
 },
 [0x13BC]={
  category="lo",
  description="CHEROKEE LETTER MO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BC,
 },
 [0x13BD]={
  category="lo",
  description="CHEROKEE LETTER MU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BD,
 },
 [0x13BE]={
  category="lo",
  description="CHEROKEE LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BE,
 },
 [0x13BF]={
  category="lo",
  description="CHEROKEE LETTER HNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BF,
 },
 [0x13C0]={
  category="lo",
  description="CHEROKEE LETTER NAH",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C0,
 },
 [0x13C1]={
  category="lo",
  description="CHEROKEE LETTER NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C1,
 },
 [0x13C2]={
  category="lo",
  description="CHEROKEE LETTER NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C2,
 },
 [0x13C3]={
  category="lo",
  description="CHEROKEE LETTER NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C3,
 },
 [0x13C4]={
  category="lo",
  description="CHEROKEE LETTER NU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C4,
 },
 [0x13C5]={
  category="lo",
  description="CHEROKEE LETTER NV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C5,
 },
 [0x13C6]={
  category="lo",
  description="CHEROKEE LETTER QUA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C6,
 },
 [0x13C7]={
  category="lo",
  description="CHEROKEE LETTER QUE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C7,
 },
 [0x13C8]={
  category="lo",
  description="CHEROKEE LETTER QUI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C8,
 },
 [0x13C9]={
  category="lo",
  description="CHEROKEE LETTER QUO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C9,
 },
 [0x13CA]={
  category="lo",
  description="CHEROKEE LETTER QUU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CA,
 },
 [0x13CB]={
  category="lo",
  description="CHEROKEE LETTER QUV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CB,
 },
 [0x13CC]={
  category="lo",
  description="CHEROKEE LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CC,
 },
 [0x13CD]={
  category="lo",
  description="CHEROKEE LETTER S",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CD,
 },
 [0x13CE]={
  category="lo",
  description="CHEROKEE LETTER SE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CE,
 },
 [0x13CF]={
  category="lo",
  description="CHEROKEE LETTER SI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CF,
 },
 [0x13D0]={
  category="lo",
  description="CHEROKEE LETTER SO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D0,
 },
 [0x13D1]={
  category="lo",
  description="CHEROKEE LETTER SU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D1,
 },
 [0x13D2]={
  category="lo",
  description="CHEROKEE LETTER SV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D2,
 },
 [0x13D3]={
  category="lo",
  description="CHEROKEE LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D3,
 },
 [0x13D4]={
  category="lo",
  description="CHEROKEE LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D4,
 },
 [0x13D5]={
  category="lo",
  description="CHEROKEE LETTER DE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D5,
 },
 [0x13D6]={
  category="lo",
  description="CHEROKEE LETTER TE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D6,
 },
 [0x13D7]={
  category="lo",
  description="CHEROKEE LETTER DI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D7,
 },
 [0x13D8]={
  category="lo",
  description="CHEROKEE LETTER TI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D8,
 },
 [0x13D9]={
  category="lo",
  description="CHEROKEE LETTER DO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D9,
 },
 [0x13DA]={
  category="lo",
  description="CHEROKEE LETTER DU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DA,
 },
 [0x13DB]={
  category="lo",
  description="CHEROKEE LETTER DV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DB,
 },
 [0x13DC]={
  category="lo",
  description="CHEROKEE LETTER DLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DC,
 },
 [0x13DD]={
  category="lo",
  description="CHEROKEE LETTER TLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DD,
 },
 [0x13DE]={
  category="lo",
  description="CHEROKEE LETTER TLE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DE,
 },
 [0x13DF]={
  category="lo",
  description="CHEROKEE LETTER TLI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DF,
 },
 [0x13E0]={
  category="lo",
  description="CHEROKEE LETTER TLO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E0,
 },
 [0x13E1]={
  category="lo",
  description="CHEROKEE LETTER TLU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E1,
 },
 [0x13E2]={
  category="lo",
  description="CHEROKEE LETTER TLV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E2,
 },
 [0x13E3]={
  category="lo",
  description="CHEROKEE LETTER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E3,
 },
 [0x13E4]={
  category="lo",
  description="CHEROKEE LETTER TSE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E4,
 },
 [0x13E5]={
  category="lo",
  description="CHEROKEE LETTER TSI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E5,
 },
 [0x13E6]={
  category="lo",
  description="CHEROKEE LETTER TSO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E6,
 },
 [0x13E7]={
  category="lo",
  description="CHEROKEE LETTER TSU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E7,
 },
 [0x13E8]={
  category="lo",
  description="CHEROKEE LETTER TSV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E8,
 },
 [0x13E9]={
  category="lo",
  description="CHEROKEE LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E9,
 },
 [0x13EA]={
  category="lo",
  description="CHEROKEE LETTER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EA,
 },
 [0x13EB]={
  category="lo",
  description="CHEROKEE LETTER WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EB,
 },
 [0x13EC]={
  category="lo",
  description="CHEROKEE LETTER WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EC,
 },
 [0x13ED]={
  category="lo",
  description="CHEROKEE LETTER WU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13ED,
 },
 [0x13EE]={
  category="lo",
  description="CHEROKEE LETTER WV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EE,
 },
 [0x13EF]={
  category="lo",
  description="CHEROKEE LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EF,
 },
 [0x13F0]={
  category="lo",
  description="CHEROKEE LETTER YE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F0,
 },
 [0x13F1]={
  category="lo",
  description="CHEROKEE LETTER YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F1,
 },
 [0x13F2]={
  category="lo",
  description="CHEROKEE LETTER YO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F2,
 },
 [0x13F3]={
  category="lo",
  description="CHEROKEE LETTER YU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F3,
 },
 [0x13F4]={
  category="lo",
  description="CHEROKEE LETTER YV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F4,
 },
 [0x13F5]={
  category="lu",
  description="CHEROKEE LETTER MV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F5,
 },
 [0x13F8]={
  category="ll",
  description="CHEROKEE SMALL LETTER YE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F8,
 },
 [0x13F9]={
  category="ll",
  description="CHEROKEE SMALL LETTER YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F9,
 },
 [0x13FA]={
  category="ll",
  description="CHEROKEE SMALL LETTER YO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13FA,
 },
 [0x13FB]={
  category="ll",
  description="CHEROKEE SMALL LETTER YU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13FB,
 },
 [0x13FC]={
  category="ll",
  description="CHEROKEE SMALL LETTER YV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13FC,
 },
 [0x13FD]={
  category="ll",
  description="CHEROKEE SMALL LETTER MV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13FD,
 },
 [0x1400]={
  category="pd",
  description="CANADIAN SYLLABICS HYPHEN",
  direction="on",
  linebreak="ba",
  unicodeslot=0x1400,
 },
 [0x1401]={
  category="lo",
  description="CANADIAN SYLLABICS E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1401,
 },
 [0x1402]={
  category="lo",
  description="CANADIAN SYLLABICS AAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1402,
 },
 [0x1403]={
  category="lo",
  description="CANADIAN SYLLABICS I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1403,
 },
 [0x1404]={
  category="lo",
  description="CANADIAN SYLLABICS II",
  direction="l",
  linebreak="al",
  unicodeslot=0x1404,
 },
 [0x1405]={
  category="lo",
  description="CANADIAN SYLLABICS O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1405,
 },
 [0x1406]={
  category="lo",
  description="CANADIAN SYLLABICS OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1406,
 },
 [0x1407]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1407,
 },
 [0x1408]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1408,
 },
 [0x1409]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1409,
 },
 [0x140A]={
  category="lo",
  description="CANADIAN SYLLABICS A",
  direction="l",
  linebreak="al",
  unicodeslot=0x140A,
 },
 [0x140B]={
  category="lo",
  description="CANADIAN SYLLABICS AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x140B,
 },
 [0x140C]={
  category="lo",
  description="CANADIAN SYLLABICS WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x140C,
 },
 [0x140D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x140D,
 },
 [0x140E]={
  category="lo",
  description="CANADIAN SYLLABICS WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x140E,
 },
 [0x140F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x140F,
 },
 [0x1410]={
  category="lo",
  description="CANADIAN SYLLABICS WII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1410,
 },
 [0x1411]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1411,
 },
 [0x1412]={
  category="lo",
  description="CANADIAN SYLLABICS WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1412,
 },
 [0x1413]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1413,
 },
 [0x1414]={
  category="lo",
  description="CANADIAN SYLLABICS WOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1414,
 },
 [0x1415]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1415,
 },
 [0x1416]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI WOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1416,
 },
 [0x1417]={
  category="lo",
  description="CANADIAN SYLLABICS WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1417,
 },
 [0x1418]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1418,
 },
 [0x1419]={
  category="lo",
  description="CANADIAN SYLLABICS WAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1419,
 },
 [0x141A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x141A,
 },
 [0x141B]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI WAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x141B,
 },
 [0x141C]={
  category="lo",
  description="CANADIAN SYLLABICS AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x141C,
 },
 [0x141D]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE W",
  direction="l",
  linebreak="al",
  unicodeslot=0x141D,
 },
 [0x141E]={
  category="lo",
  description="CANADIAN SYLLABICS GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x141E,
 },
 [0x141F]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL ACUTE",
  direction="l",
  linebreak="al",
  unicodeslot=0x141F,
 },
 [0x1420]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL GRAVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1420,
 },
 [0x1421]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL BOTTOM HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1421,
 },
 [0x1422]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL TOP HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1422,
 },
 [0x1423]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL RIGHT HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1423,
 },
 [0x1424]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1424,
 },
 [0x1425]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL DOUBLE ACUTE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1425,
 },
 [0x1426]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES",
  direction="l",
  linebreak="al",
  unicodeslot=0x1426,
 },
 [0x1427]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL MIDDLE DOT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1427,
 },
 [0x1428]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1428,
 },
 [0x1429]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL PLUS",
  direction="l",
  linebreak="al",
  unicodeslot=0x1429,
 },
 [0x142A]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL DOWN TACK",
  direction="l",
  linebreak="al",
  unicodeslot=0x142A,
 },
 [0x142B]={
  category="lo",
  description="CANADIAN SYLLABICS EN",
  direction="l",
  linebreak="al",
  unicodeslot=0x142B,
 },
 [0x142C]={
  category="lo",
  description="CANADIAN SYLLABICS IN",
  direction="l",
  linebreak="al",
  unicodeslot=0x142C,
 },
 [0x142D]={
  category="lo",
  description="CANADIAN SYLLABICS ON",
  direction="l",
  linebreak="al",
  unicodeslot=0x142D,
 },
 [0x142E]={
  category="lo",
  description="CANADIAN SYLLABICS AN",
  direction="l",
  linebreak="al",
  unicodeslot=0x142E,
 },
 [0x142F]={
  category="lo",
  description="CANADIAN SYLLABICS PE",
  direction="l",
  linebreak="al",
  unicodeslot=0x142F,
 },
 [0x1430]={
  category="lo",
  description="CANADIAN SYLLABICS PAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1430,
 },
 [0x1431]={
  category="lo",
  description="CANADIAN SYLLABICS PI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1431,
 },
 [0x1432]={
  category="lo",
  description="CANADIAN SYLLABICS PII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1432,
 },
 [0x1433]={
  category="lo",
  description="CANADIAN SYLLABICS PO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1433,
 },
 [0x1434]={
  category="lo",
  description="CANADIAN SYLLABICS POO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1434,
 },
 [0x1435]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE POO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1435,
 },
 [0x1436]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1436,
 },
 [0x1437]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1437,
 },
 [0x1438]={
  category="lo",
  description="CANADIAN SYLLABICS PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1438,
 },
 [0x1439]={
  category="lo",
  description="CANADIAN SYLLABICS PAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1439,
 },
 [0x143A]={
  category="lo",
  description="CANADIAN SYLLABICS PWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x143A,
 },
 [0x143B]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x143B,
 },
 [0x143C]={
  category="lo",
  description="CANADIAN SYLLABICS PWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x143C,
 },
 [0x143D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x143D,
 },
 [0x143E]={
  category="lo",
  description="CANADIAN SYLLABICS PWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x143E,
 },
 [0x143F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x143F,
 },
 [0x1440]={
  category="lo",
  description="CANADIAN SYLLABICS PWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1440,
 },
 [0x1441]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1441,
 },
 [0x1442]={
  category="lo",
  description="CANADIAN SYLLABICS PWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1442,
 },
 [0x1443]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1443,
 },
 [0x1444]={
  category="lo",
  description="CANADIAN SYLLABICS PWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1444,
 },
 [0x1445]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1445,
 },
 [0x1446]={
  category="lo",
  description="CANADIAN SYLLABICS PWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1446,
 },
 [0x1447]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1447,
 },
 [0x1448]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE PWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1448,
 },
 [0x1449]={
  category="lo",
  description="CANADIAN SYLLABICS P",
  direction="l",
  linebreak="al",
  unicodeslot=0x1449,
 },
 [0x144A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE P",
  direction="l",
  linebreak="al",
  unicodeslot=0x144A,
 },
 [0x144B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER H",
  direction="l",
  linebreak="al",
  unicodeslot=0x144B,
 },
 [0x144C]={
  category="lo",
  description="CANADIAN SYLLABICS TE",
  direction="l",
  linebreak="al",
  unicodeslot=0x144C,
 },
 [0x144D]={
  category="lo",
  description="CANADIAN SYLLABICS TAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x144D,
 },
 [0x144E]={
  category="lo",
  description="CANADIAN SYLLABICS TI",
  direction="l",
  linebreak="al",
  unicodeslot=0x144E,
 },
 [0x144F]={
  category="lo",
  description="CANADIAN SYLLABICS TII",
  direction="l",
  linebreak="al",
  unicodeslot=0x144F,
 },
 [0x1450]={
  category="lo",
  description="CANADIAN SYLLABICS TO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1450,
 },
 [0x1451]={
  category="lo",
  description="CANADIAN SYLLABICS TOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1451,
 },
 [0x1452]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE TOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1452,
 },
 [0x1453]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1453,
 },
 [0x1454]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1454,
 },
 [0x1455]={
  category="lo",
  description="CANADIAN SYLLABICS TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1455,
 },
 [0x1456]={
  category="lo",
  description="CANADIAN SYLLABICS TAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1456,
 },
 [0x1457]={
  category="lo",
  description="CANADIAN SYLLABICS TWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1457,
 },
 [0x1458]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1458,
 },
 [0x1459]={
  category="lo",
  description="CANADIAN SYLLABICS TWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1459,
 },
 [0x145A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x145A,
 },
 [0x145B]={
  category="lo",
  description="CANADIAN SYLLABICS TWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x145B,
 },
 [0x145C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x145C,
 },
 [0x145D]={
  category="lo",
  description="CANADIAN SYLLABICS TWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x145D,
 },
 [0x145E]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x145E,
 },
 [0x145F]={
  category="lo",
  description="CANADIAN SYLLABICS TWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x145F,
 },
 [0x1460]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1460,
 },
 [0x1461]={
  category="lo",
  description="CANADIAN SYLLABICS TWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1461,
 },
 [0x1462]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1462,
 },
 [0x1463]={
  category="lo",
  description="CANADIAN SYLLABICS TWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1463,
 },
 [0x1464]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1464,
 },
 [0x1465]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI TWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1465,
 },
 [0x1466]={
  category="lo",
  description="CANADIAN SYLLABICS T",
  direction="l",
  linebreak="al",
  unicodeslot=0x1466,
 },
 [0x1467]={
  category="lo",
  description="CANADIAN SYLLABICS TTE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1467,
 },
 [0x1468]={
  category="lo",
  description="CANADIAN SYLLABICS TTI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1468,
 },
 [0x1469]={
  category="lo",
  description="CANADIAN SYLLABICS TTO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1469,
 },
 [0x146A]={
  category="lo",
  description="CANADIAN SYLLABICS TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x146A,
 },
 [0x146B]={
  category="lo",
  description="CANADIAN SYLLABICS KE",
  direction="l",
  linebreak="al",
  unicodeslot=0x146B,
 },
 [0x146C]={
  category="lo",
  description="CANADIAN SYLLABICS KAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x146C,
 },
 [0x146D]={
  category="lo",
  description="CANADIAN SYLLABICS KI",
  direction="l",
  linebreak="al",
  unicodeslot=0x146D,
 },
 [0x146E]={
  category="lo",
  description="CANADIAN SYLLABICS KII",
  direction="l",
  linebreak="al",
  unicodeslot=0x146E,
 },
 [0x146F]={
  category="lo",
  description="CANADIAN SYLLABICS KO",
  direction="l",
  linebreak="al",
  unicodeslot=0x146F,
 },
 [0x1470]={
  category="lo",
  description="CANADIAN SYLLABICS KOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1470,
 },
 [0x1471]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE KOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1471,
 },
 [0x1472]={
  category="lo",
  description="CANADIAN SYLLABICS KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1472,
 },
 [0x1473]={
  category="lo",
  description="CANADIAN SYLLABICS KAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1473,
 },
 [0x1474]={
  category="lo",
  description="CANADIAN SYLLABICS KWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1474,
 },
 [0x1475]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1475,
 },
 [0x1476]={
  category="lo",
  description="CANADIAN SYLLABICS KWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1476,
 },
 [0x1477]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1477,
 },
 [0x1478]={
  category="lo",
  description="CANADIAN SYLLABICS KWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1478,
 },
 [0x1479]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1479,
 },
 [0x147A]={
  category="lo",
  description="CANADIAN SYLLABICS KWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x147A,
 },
 [0x147B]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x147B,
 },
 [0x147C]={
  category="lo",
  description="CANADIAN SYLLABICS KWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x147C,
 },
 [0x147D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x147D,
 },
 [0x147E]={
  category="lo",
  description="CANADIAN SYLLABICS KWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x147E,
 },
 [0x147F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x147F,
 },
 [0x1480]={
  category="lo",
  description="CANADIAN SYLLABICS KWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1480,
 },
 [0x1481]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1481,
 },
 [0x1482]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI KWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1482,
 },
 [0x1483]={
  category="lo",
  description="CANADIAN SYLLABICS K",
  direction="l",
  linebreak="al",
  unicodeslot=0x1483,
 },
 [0x1484]={
  category="lo",
  description="CANADIAN SYLLABICS KW",
  direction="l",
  linebreak="al",
  unicodeslot=0x1484,
 },
 [0x1485]={
  category="lo",
  description="CANADIAN SYLLABICS SOUTH-SLAVEY KEH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1485,
 },
 [0x1486]={
  category="lo",
  description="CANADIAN SYLLABICS SOUTH-SLAVEY KIH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1486,
 },
 [0x1487]={
  category="lo",
  description="CANADIAN SYLLABICS SOUTH-SLAVEY KOH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1487,
 },
 [0x1488]={
  category="lo",
  description="CANADIAN SYLLABICS SOUTH-SLAVEY KAH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1488,
 },
 [0x1489]={
  category="lo",
  description="CANADIAN SYLLABICS CE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1489,
 },
 [0x148A]={
  category="lo",
  description="CANADIAN SYLLABICS CAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x148A,
 },
 [0x148B]={
  category="lo",
  description="CANADIAN SYLLABICS CI",
  direction="l",
  linebreak="al",
  unicodeslot=0x148B,
 },
 [0x148C]={
  category="lo",
  description="CANADIAN SYLLABICS CII",
  direction="l",
  linebreak="al",
  unicodeslot=0x148C,
 },
 [0x148D]={
  category="lo",
  description="CANADIAN SYLLABICS CO",
  direction="l",
  linebreak="al",
  unicodeslot=0x148D,
 },
 [0x148E]={
  category="lo",
  description="CANADIAN SYLLABICS COO",
  direction="l",
  linebreak="al",
  unicodeslot=0x148E,
 },
 [0x148F]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE COO",
  direction="l",
  linebreak="al",
  unicodeslot=0x148F,
 },
 [0x1490]={
  category="lo",
  description="CANADIAN SYLLABICS CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1490,
 },
 [0x1491]={
  category="lo",
  description="CANADIAN SYLLABICS CAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1491,
 },
 [0x1492]={
  category="lo",
  description="CANADIAN SYLLABICS CWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1492,
 },
 [0x1493]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1493,
 },
 [0x1494]={
  category="lo",
  description="CANADIAN SYLLABICS CWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1494,
 },
 [0x1495]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1495,
 },
 [0x1496]={
  category="lo",
  description="CANADIAN SYLLABICS CWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1496,
 },
 [0x1497]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1497,
 },
 [0x1498]={
  category="lo",
  description="CANADIAN SYLLABICS CWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1498,
 },
 [0x1499]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1499,
 },
 [0x149A]={
  category="lo",
  description="CANADIAN SYLLABICS CWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x149A,
 },
 [0x149B]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x149B,
 },
 [0x149C]={
  category="lo",
  description="CANADIAN SYLLABICS CWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x149C,
 },
 [0x149D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x149D,
 },
 [0x149E]={
  category="lo",
  description="CANADIAN SYLLABICS CWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x149E,
 },
 [0x149F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x149F,
 },
 [0x14A0]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI CWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A0,
 },
 [0x14A1]={
  category="lo",
  description="CANADIAN SYLLABICS C",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A1,
 },
 [0x14A2]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A2,
 },
 [0x14A3]={
  category="lo",
  description="CANADIAN SYLLABICS ME",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A3,
 },
 [0x14A4]={
  category="lo",
  description="CANADIAN SYLLABICS MAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A4,
 },
 [0x14A5]={
  category="lo",
  description="CANADIAN SYLLABICS MI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A5,
 },
 [0x14A6]={
  category="lo",
  description="CANADIAN SYLLABICS MII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A6,
 },
 [0x14A7]={
  category="lo",
  description="CANADIAN SYLLABICS MO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A7,
 },
 [0x14A8]={
  category="lo",
  description="CANADIAN SYLLABICS MOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A8,
 },
 [0x14A9]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE MOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A9,
 },
 [0x14AA]={
  category="lo",
  description="CANADIAN SYLLABICS MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AA,
 },
 [0x14AB]={
  category="lo",
  description="CANADIAN SYLLABICS MAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AB,
 },
 [0x14AC]={
  category="lo",
  description="CANADIAN SYLLABICS MWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AC,
 },
 [0x14AD]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AD,
 },
 [0x14AE]={
  category="lo",
  description="CANADIAN SYLLABICS MWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AE,
 },
 [0x14AF]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AF,
 },
 [0x14B0]={
  category="lo",
  description="CANADIAN SYLLABICS MWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B0,
 },
 [0x14B1]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B1,
 },
 [0x14B2]={
  category="lo",
  description="CANADIAN SYLLABICS MWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B2,
 },
 [0x14B3]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B3,
 },
 [0x14B4]={
  category="lo",
  description="CANADIAN SYLLABICS MWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B4,
 },
 [0x14B5]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B5,
 },
 [0x14B6]={
  category="lo",
  description="CANADIAN SYLLABICS MWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B6,
 },
 [0x14B7]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B7,
 },
 [0x14B8]={
  category="lo",
  description="CANADIAN SYLLABICS MWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B8,
 },
 [0x14B9]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B9,
 },
 [0x14BA]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI MWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BA,
 },
 [0x14BB]={
  category="lo",
  description="CANADIAN SYLLABICS M",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BB,
 },
 [0x14BC]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE M",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BC,
 },
 [0x14BD]={
  category="lo",
  description="CANADIAN SYLLABICS MH",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BD,
 },
 [0x14BE]={
  category="lo",
  description="CANADIAN SYLLABICS ATHAPASCAN M",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BE,
 },
 [0x14BF]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI M",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BF,
 },
 [0x14C0]={
  category="lo",
  description="CANADIAN SYLLABICS NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C0,
 },
 [0x14C1]={
  category="lo",
  description="CANADIAN SYLLABICS NAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C1,
 },
 [0x14C2]={
  category="lo",
  description="CANADIAN SYLLABICS NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C2,
 },
 [0x14C3]={
  category="lo",
  description="CANADIAN SYLLABICS NII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C3,
 },
 [0x14C4]={
  category="lo",
  description="CANADIAN SYLLABICS NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C4,
 },
 [0x14C5]={
  category="lo",
  description="CANADIAN SYLLABICS NOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C5,
 },
 [0x14C6]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE NOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C6,
 },
 [0x14C7]={
  category="lo",
  description="CANADIAN SYLLABICS NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C7,
 },
 [0x14C8]={
  category="lo",
  description="CANADIAN SYLLABICS NAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C8,
 },
 [0x14C9]={
  category="lo",
  description="CANADIAN SYLLABICS NWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C9,
 },
 [0x14CA]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE NWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CA,
 },
 [0x14CB]={
  category="lo",
  description="CANADIAN SYLLABICS NWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CB,
 },
 [0x14CC]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE NWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CC,
 },
 [0x14CD]={
  category="lo",
  description="CANADIAN SYLLABICS NWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CD,
 },
 [0x14CE]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE NWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CE,
 },
 [0x14CF]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI NWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CF,
 },
 [0x14D0]={
  category="lo",
  description="CANADIAN SYLLABICS N",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D0,
 },
 [0x14D1]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NG",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D1,
 },
 [0x14D2]={
  category="lo",
  description="CANADIAN SYLLABICS NH",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D2,
 },
 [0x14D3]={
  category="lo",
  description="CANADIAN SYLLABICS LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D3,
 },
 [0x14D4]={
  category="lo",
  description="CANADIAN SYLLABICS LAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D4,
 },
 [0x14D5]={
  category="lo",
  description="CANADIAN SYLLABICS LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D5,
 },
 [0x14D6]={
  category="lo",
  description="CANADIAN SYLLABICS LII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D6,
 },
 [0x14D7]={
  category="lo",
  description="CANADIAN SYLLABICS LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D7,
 },
 [0x14D8]={
  category="lo",
  description="CANADIAN SYLLABICS LOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D8,
 },
 [0x14D9]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE LOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D9,
 },
 [0x14DA]={
  category="lo",
  description="CANADIAN SYLLABICS LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DA,
 },
 [0x14DB]={
  category="lo",
  description="CANADIAN SYLLABICS LAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DB,
 },
 [0x14DC]={
  category="lo",
  description="CANADIAN SYLLABICS LWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DC,
 },
 [0x14DD]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DD,
 },
 [0x14DE]={
  category="lo",
  description="CANADIAN SYLLABICS LWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DE,
 },
 [0x14DF]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DF,
 },
 [0x14E0]={
  category="lo",
  description="CANADIAN SYLLABICS LWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E0,
 },
 [0x14E1]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E1,
 },
 [0x14E2]={
  category="lo",
  description="CANADIAN SYLLABICS LWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E2,
 },
 [0x14E3]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E3,
 },
 [0x14E4]={
  category="lo",
  description="CANADIAN SYLLABICS LWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E4,
 },
 [0x14E5]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E5,
 },
 [0x14E6]={
  category="lo",
  description="CANADIAN SYLLABICS LWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E6,
 },
 [0x14E7]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E7,
 },
 [0x14E8]={
  category="lo",
  description="CANADIAN SYLLABICS LWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E8,
 },
 [0x14E9]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E9,
 },
 [0x14EA]={
  category="lo",
  description="CANADIAN SYLLABICS L",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EA,
 },
 [0x14EB]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE L",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EB,
 },
 [0x14EC]={
  category="lo",
  description="CANADIAN SYLLABICS MEDIAL L",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EC,
 },
 [0x14ED]={
  category="lo",
  description="CANADIAN SYLLABICS SE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14ED,
 },
 [0x14EE]={
  category="lo",
  description="CANADIAN SYLLABICS SAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EE,
 },
 [0x14EF]={
  category="lo",
  description="CANADIAN SYLLABICS SI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EF,
 },
 [0x14F0]={
  category="lo",
  description="CANADIAN SYLLABICS SII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F0,
 },
 [0x14F1]={
  category="lo",
  description="CANADIAN SYLLABICS SO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F1,
 },
 [0x14F2]={
  category="lo",
  description="CANADIAN SYLLABICS SOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F2,
 },
 [0x14F3]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE SOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F3,
 },
 [0x14F4]={
  category="lo",
  description="CANADIAN SYLLABICS SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F4,
 },
 [0x14F5]={
  category="lo",
  description="CANADIAN SYLLABICS SAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F5,
 },
 [0x14F6]={
  category="lo",
  description="CANADIAN SYLLABICS SWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F6,
 },
 [0x14F7]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F7,
 },
 [0x14F8]={
  category="lo",
  description="CANADIAN SYLLABICS SWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F8,
 },
 [0x14F9]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F9,
 },
 [0x14FA]={
  category="lo",
  description="CANADIAN SYLLABICS SWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FA,
 },
 [0x14FB]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FB,
 },
 [0x14FC]={
  category="lo",
  description="CANADIAN SYLLABICS SWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FC,
 },
 [0x14FD]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FD,
 },
 [0x14FE]={
  category="lo",
  description="CANADIAN SYLLABICS SWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FE,
 },
 [0x14FF]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FF,
 },
 [0x1500]={
  category="lo",
  description="CANADIAN SYLLABICS SWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1500,
 },
 [0x1501]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1501,
 },
 [0x1502]={
  category="lo",
  description="CANADIAN SYLLABICS SWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1502,
 },
 [0x1503]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1503,
 },
 [0x1504]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1504,
 },
 [0x1505]={
  category="lo",
  description="CANADIAN SYLLABICS S",
  direction="l",
  linebreak="al",
  unicodeslot=0x1505,
 },
 [0x1506]={
  category="lo",
  description="CANADIAN SYLLABICS ATHAPASCAN S",
  direction="l",
  linebreak="al",
  unicodeslot=0x1506,
 },
 [0x1507]={
  category="lo",
  description="CANADIAN SYLLABICS SW",
  direction="l",
  linebreak="al",
  unicodeslot=0x1507,
 },
 [0x1508]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT S",
  direction="l",
  linebreak="al",
  unicodeslot=0x1508,
 },
 [0x1509]={
  category="lo",
  description="CANADIAN SYLLABICS MOOSE-CREE SK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1509,
 },
 [0x150A]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SKW",
  direction="l",
  linebreak="al",
  unicodeslot=0x150A,
 },
 [0x150B]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI S-W",
  direction="l",
  linebreak="al",
  unicodeslot=0x150B,
 },
 [0x150C]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SPWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x150C,
 },
 [0x150D]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI STWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x150D,
 },
 [0x150E]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SKWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x150E,
 },
 [0x150F]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SCWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x150F,
 },
 [0x1510]={
  category="lo",
  description="CANADIAN SYLLABICS SHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1510,
 },
 [0x1511]={
  category="lo",
  description="CANADIAN SYLLABICS SHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1511,
 },
 [0x1512]={
  category="lo",
  description="CANADIAN SYLLABICS SHII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1512,
 },
 [0x1513]={
  category="lo",
  description="CANADIAN SYLLABICS SHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1513,
 },
 [0x1514]={
  category="lo",
  description="CANADIAN SYLLABICS SHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1514,
 },
 [0x1515]={
  category="lo",
  description="CANADIAN SYLLABICS SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1515,
 },
 [0x1516]={
  category="lo",
  description="CANADIAN SYLLABICS SHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1516,
 },
 [0x1517]={
  category="lo",
  description="CANADIAN SYLLABICS SHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1517,
 },
 [0x1518]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1518,
 },
 [0x1519]={
  category="lo",
  description="CANADIAN SYLLABICS SHWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1519,
 },
 [0x151A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x151A,
 },
 [0x151B]={
  category="lo",
  description="CANADIAN SYLLABICS SHWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x151B,
 },
 [0x151C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x151C,
 },
 [0x151D]={
  category="lo",
  description="CANADIAN SYLLABICS SHWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x151D,
 },
 [0x151E]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x151E,
 },
 [0x151F]={
  category="lo",
  description="CANADIAN SYLLABICS SHWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x151F,
 },
 [0x1520]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1520,
 },
 [0x1521]={
  category="lo",
  description="CANADIAN SYLLABICS SHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1521,
 },
 [0x1522]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1522,
 },
 [0x1523]={
  category="lo",
  description="CANADIAN SYLLABICS SHWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1523,
 },
 [0x1524]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1524,
 },
 [0x1525]={
  category="lo",
  description="CANADIAN SYLLABICS SH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1525,
 },
 [0x1526]={
  category="lo",
  description="CANADIAN SYLLABICS YE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1526,
 },
 [0x1527]={
  category="lo",
  description="CANADIAN SYLLABICS YAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1527,
 },
 [0x1528]={
  category="lo",
  description="CANADIAN SYLLABICS YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1528,
 },
 [0x1529]={
  category="lo",
  description="CANADIAN SYLLABICS YII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1529,
 },
 [0x152A]={
  category="lo",
  description="CANADIAN SYLLABICS YO",
  direction="l",
  linebreak="al",
  unicodeslot=0x152A,
 },
 [0x152B]={
  category="lo",
  description="CANADIAN SYLLABICS YOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x152B,
 },
 [0x152C]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE YOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x152C,
 },
 [0x152D]={
  category="lo",
  description="CANADIAN SYLLABICS YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x152D,
 },
 [0x152E]={
  category="lo",
  description="CANADIAN SYLLABICS YAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x152E,
 },
 [0x152F]={
  category="lo",
  description="CANADIAN SYLLABICS YWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x152F,
 },
 [0x1530]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1530,
 },
 [0x1531]={
  category="lo",
  description="CANADIAN SYLLABICS YWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1531,
 },
 [0x1532]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1532,
 },
 [0x1533]={
  category="lo",
  description="CANADIAN SYLLABICS YWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1533,
 },
 [0x1534]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1534,
 },
 [0x1535]={
  category="lo",
  description="CANADIAN SYLLABICS YWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1535,
 },
 [0x1536]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1536,
 },
 [0x1537]={
  category="lo",
  description="CANADIAN SYLLABICS YWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1537,
 },
 [0x1538]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1538,
 },
 [0x1539]={
  category="lo",
  description="CANADIAN SYLLABICS YWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1539,
 },
 [0x153A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x153A,
 },
 [0x153B]={
  category="lo",
  description="CANADIAN SYLLABICS YWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x153B,
 },
 [0x153C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x153C,
 },
 [0x153D]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI YWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x153D,
 },
 [0x153E]={
  category="lo",
  description="CANADIAN SYLLABICS Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x153E,
 },
 [0x153F]={
  category="lo",
  description="CANADIAN SYLLABICS BIBLE-CREE Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x153F,
 },
 [0x1540]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x1540,
 },
 [0x1541]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1541,
 },
 [0x1542]={
  category="lo",
  description="CANADIAN SYLLABICS RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1542,
 },
 [0x1543]={
  category="lo",
  description="CANADIAN SYLLABICS R-CREE RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1543,
 },
 [0x1544]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1544,
 },
 [0x1545]={
  category="lo",
  description="CANADIAN SYLLABICS RAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1545,
 },
 [0x1546]={
  category="lo",
  description="CANADIAN SYLLABICS RI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1546,
 },
 [0x1547]={
  category="lo",
  description="CANADIAN SYLLABICS RII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1547,
 },
 [0x1548]={
  category="lo",
  description="CANADIAN SYLLABICS RO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1548,
 },
 [0x1549]={
  category="lo",
  description="CANADIAN SYLLABICS ROO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1549,
 },
 [0x154A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x154A,
 },
 [0x154B]={
  category="lo",
  description="CANADIAN SYLLABICS RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154B,
 },
 [0x154C]={
  category="lo",
  description="CANADIAN SYLLABICS RAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154C,
 },
 [0x154D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154D,
 },
 [0x154E]={
  category="lo",
  description="CANADIAN SYLLABICS RWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154E,
 },
 [0x154F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154F,
 },
 [0x1550]={
  category="lo",
  description="CANADIAN SYLLABICS R",
  direction="l",
  linebreak="al",
  unicodeslot=0x1550,
 },
 [0x1551]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE R",
  direction="l",
  linebreak="al",
  unicodeslot=0x1551,
 },
 [0x1552]={
  category="lo",
  description="CANADIAN SYLLABICS MEDIAL R",
  direction="l",
  linebreak="al",
  unicodeslot=0x1552,
 },
 [0x1553]={
  category="lo",
  description="CANADIAN SYLLABICS FE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1553,
 },
 [0x1554]={
  category="lo",
  description="CANADIAN SYLLABICS FAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1554,
 },
 [0x1555]={
  category="lo",
  description="CANADIAN SYLLABICS FI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1555,
 },
 [0x1556]={
  category="lo",
  description="CANADIAN SYLLABICS FII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1556,
 },
 [0x1557]={
  category="lo",
  description="CANADIAN SYLLABICS FO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1557,
 },
 [0x1558]={
  category="lo",
  description="CANADIAN SYLLABICS FOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1558,
 },
 [0x1559]={
  category="lo",
  description="CANADIAN SYLLABICS FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1559,
 },
 [0x155A]={
  category="lo",
  description="CANADIAN SYLLABICS FAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x155A,
 },
 [0x155B]={
  category="lo",
  description="CANADIAN SYLLABICS FWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x155B,
 },
 [0x155C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE FWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x155C,
 },
 [0x155D]={
  category="lo",
  description="CANADIAN SYLLABICS F",
  direction="l",
  linebreak="al",
  unicodeslot=0x155D,
 },
 [0x155E]={
  category="lo",
  description="CANADIAN SYLLABICS THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x155E,
 },
 [0x155F]={
  category="lo",
  description="CANADIAN SYLLABICS N-CREE THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x155F,
 },
 [0x1560]={
  category="lo",
  description="CANADIAN SYLLABICS THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1560,
 },
 [0x1561]={
  category="lo",
  description="CANADIAN SYLLABICS N-CREE THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1561,
 },
 [0x1562]={
  category="lo",
  description="CANADIAN SYLLABICS THII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1562,
 },
 [0x1563]={
  category="lo",
  description="CANADIAN SYLLABICS N-CREE THII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1563,
 },
 [0x1564]={
  category="lo",
  description="CANADIAN SYLLABICS THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1564,
 },
 [0x1565]={
  category="lo",
  description="CANADIAN SYLLABICS THOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1565,
 },
 [0x1566]={
  category="lo",
  description="CANADIAN SYLLABICS THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1566,
 },
 [0x1567]={
  category="lo",
  description="CANADIAN SYLLABICS THAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1567,
 },
 [0x1568]={
  category="lo",
  description="CANADIAN SYLLABICS THWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1568,
 },
 [0x1569]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE THWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1569,
 },
 [0x156A]={
  category="lo",
  description="CANADIAN SYLLABICS TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x156A,
 },
 [0x156B]={
  category="lo",
  description="CANADIAN SYLLABICS TTHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x156B,
 },
 [0x156C]={
  category="lo",
  description="CANADIAN SYLLABICS TTHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x156C,
 },
 [0x156D]={
  category="lo",
  description="CANADIAN SYLLABICS TTHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x156D,
 },
 [0x156E]={
  category="lo",
  description="CANADIAN SYLLABICS TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x156E,
 },
 [0x156F]={
  category="lo",
  description="CANADIAN SYLLABICS TTH",
  direction="l",
  linebreak="al",
  unicodeslot=0x156F,
 },
 [0x1570]={
  category="lo",
  description="CANADIAN SYLLABICS TYE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1570,
 },
 [0x1571]={
  category="lo",
  description="CANADIAN SYLLABICS TYI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1571,
 },
 [0x1572]={
  category="lo",
  description="CANADIAN SYLLABICS TYO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1572,
 },
 [0x1573]={
  category="lo",
  description="CANADIAN SYLLABICS TYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1573,
 },
 [0x1574]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1574,
 },
 [0x1575]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1575,
 },
 [0x1576]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1576,
 },
 [0x1577]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1577,
 },
 [0x1578]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1578,
 },
 [0x1579]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1579,
 },
 [0x157A]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x157A,
 },
 [0x157B]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK H",
  direction="l",
  linebreak="al",
  unicodeslot=0x157B,
 },
 [0x157C]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVUT H",
  direction="l",
  linebreak="al",
  unicodeslot=0x157C,
 },
 [0x157D]={
  category="lo",
  description="CANADIAN SYLLABICS HK",
  direction="l",
  linebreak="al",
  unicodeslot=0x157D,
 },
 [0x157E]={
  category="lo",
  description="CANADIAN SYLLABICS QAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x157E,
 },
 [0x157F]={
  category="lo",
  description="CANADIAN SYLLABICS QI",
  direction="l",
  linebreak="al",
  unicodeslot=0x157F,
 },
 [0x1580]={
  category="lo",
  description="CANADIAN SYLLABICS QII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1580,
 },
 [0x1581]={
  category="lo",
  description="CANADIAN SYLLABICS QO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1581,
 },
 [0x1582]={
  category="lo",
  description="CANADIAN SYLLABICS QOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1582,
 },
 [0x1583]={
  category="lo",
  description="CANADIAN SYLLABICS QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1583,
 },
 [0x1584]={
  category="lo",
  description="CANADIAN SYLLABICS QAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1584,
 },
 [0x1585]={
  category="lo",
  description="CANADIAN SYLLABICS Q",
  direction="l",
  linebreak="al",
  unicodeslot=0x1585,
 },
 [0x1586]={
  category="lo",
  description="CANADIAN SYLLABICS TLHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1586,
 },
 [0x1587]={
  category="lo",
  description="CANADIAN SYLLABICS TLHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1587,
 },
 [0x1588]={
  category="lo",
  description="CANADIAN SYLLABICS TLHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1588,
 },
 [0x1589]={
  category="lo",
  description="CANADIAN SYLLABICS TLHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1589,
 },
 [0x158A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x158A,
 },
 [0x158B]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RI",
  direction="l",
  linebreak="al",
  unicodeslot=0x158B,
 },
 [0x158C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RO",
  direction="l",
  linebreak="al",
  unicodeslot=0x158C,
 },
 [0x158D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x158D,
 },
 [0x158E]={
  category="lo",
  description="CANADIAN SYLLABICS NGAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x158E,
 },
 [0x158F]={
  category="lo",
  description="CANADIAN SYLLABICS NGI",
  direction="l",
  linebreak="al",
  unicodeslot=0x158F,
 },
 [0x1590]={
  category="lo",
  description="CANADIAN SYLLABICS NGII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1590,
 },
 [0x1591]={
  category="lo",
  description="CANADIAN SYLLABICS NGO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1591,
 },
 [0x1592]={
  category="lo",
  description="CANADIAN SYLLABICS NGOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1592,
 },
 [0x1593]={
  category="lo",
  description="CANADIAN SYLLABICS NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1593,
 },
 [0x1594]={
  category="lo",
  description="CANADIAN SYLLABICS NGAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1594,
 },
 [0x1595]={
  category="lo",
  description="CANADIAN SYLLABICS NG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1595,
 },
 [0x1596]={
  category="lo",
  description="CANADIAN SYLLABICS NNG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1596,
 },
 [0x1597]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1597,
 },
 [0x1598]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1598,
 },
 [0x1599]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1599,
 },
 [0x159A]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x159A,
 },
 [0x159B]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x159B,
 },
 [0x159C]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x159C,
 },
 [0x159D]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x159D,
 },
 [0x159E]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x159E,
 },
 [0x159F]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x159F,
 },
 [0x15A0]={
  category="lo",
  description="CANADIAN SYLLABICS LHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A0,
 },
 [0x15A1]={
  category="lo",
  description="CANADIAN SYLLABICS LHII",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A1,
 },
 [0x15A2]={
  category="lo",
  description="CANADIAN SYLLABICS LHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A2,
 },
 [0x15A3]={
  category="lo",
  description="CANADIAN SYLLABICS LHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A3,
 },
 [0x15A4]={
  category="lo",
  description="CANADIAN SYLLABICS LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A4,
 },
 [0x15A5]={
  category="lo",
  description="CANADIAN SYLLABICS LHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A5,
 },
 [0x15A6]={
  category="lo",
  description="CANADIAN SYLLABICS LH",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A6,
 },
 [0x15A7]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A7,
 },
 [0x15A8]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A8,
 },
 [0x15A9]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THII",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A9,
 },
 [0x15AA]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AA,
 },
 [0x15AB]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AB,
 },
 [0x15AC]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AC,
 },
 [0x15AD]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AD,
 },
 [0x15AE]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AE,
 },
 [0x15AF]={
  category="lo",
  description="CANADIAN SYLLABICS AIVILIK B",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AF,
 },
 [0x15B0]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT E",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B0,
 },
 [0x15B1]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT I",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B1,
 },
 [0x15B2]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT O",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B2,
 },
 [0x15B3]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT A",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B3,
 },
 [0x15B4]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B4,
 },
 [0x15B5]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B5,
 },
 [0x15B6]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B6,
 },
 [0x15B7]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B7,
 },
 [0x15B8]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B8,
 },
 [0x15B9]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B9,
 },
 [0x15BA]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BA,
 },
 [0x15BB]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BB,
 },
 [0x15BC]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT KE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BC,
 },
 [0x15BD]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT KI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BD,
 },
 [0x15BE]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT KO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BE,
 },
 [0x15BF]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BF,
 },
 [0x15C0]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C0,
 },
 [0x15C1]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C1,
 },
 [0x15C2]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C2,
 },
 [0x15C3]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C3,
 },
 [0x15C4]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C4,
 },
 [0x15C5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C5,
 },
 [0x15C6]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C6,
 },
 [0x15C7]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C7,
 },
 [0x15C8]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C8,
 },
 [0x15C9]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C9,
 },
 [0x15CA]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CA,
 },
 [0x15CB]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CB,
 },
 [0x15CC]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CC,
 },
 [0x15CD]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER REE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CD,
 },
 [0x15CE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CE,
 },
 [0x15CF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CF,
 },
 [0x15D0]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D0,
 },
 [0x15D1]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D1,
 },
 [0x15D2]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D2,
 },
 [0x15D3]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D3,
 },
 [0x15D4]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D4,
 },
 [0x15D5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D5,
 },
 [0x15D6]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D6,
 },
 [0x15D7]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D7,
 },
 [0x15D8]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D8,
 },
 [0x15D9]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D9,
 },
 [0x15DA]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DA,
 },
 [0x15DB]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DB,
 },
 [0x15DC]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DC,
 },
 [0x15DD]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DD,
 },
 [0x15DE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DE,
 },
 [0x15DF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DF,
 },
 [0x15E0]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E0,
 },
 [0x15E1]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E1,
 },
 [0x15E2]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E2,
 },
 [0x15E3]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E3,
 },
 [0x15E4]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E4,
 },
 [0x15E5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E5,
 },
 [0x15E6]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E6,
 },
 [0x15E7]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E7,
 },
 [0x15E8]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E8,
 },
 [0x15E9]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E9,
 },
 [0x15EA]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EA,
 },
 [0x15EB]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EB,
 },
 [0x15EC]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EC,
 },
 [0x15ED]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15ED,
 },
 [0x15EE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER P",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EE,
 },
 [0x15EF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EF,
 },
 [0x15F0]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F0,
 },
 [0x15F1]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F1,
 },
 [0x15F2]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F2,
 },
 [0x15F3]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F3,
 },
 [0x15F4]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F4,
 },
 [0x15F5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F5,
 },
 [0x15F6]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F6,
 },
 [0x15F7]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F7,
 },
 [0x15F8]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F8,
 },
 [0x15F9]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F9,
 },
 [0x15FA]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FA,
 },
 [0x15FB]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FB,
 },
 [0x15FC]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FC,
 },
 [0x15FD]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FD,
 },
 [0x15FE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FE,
 },
 [0x15FF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FF,
 },
 [0x1600]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1600,
 },
 [0x1601]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1601,
 },
 [0x1602]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1602,
 },
 [0x1603]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1603,
 },
 [0x1604]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1604,
 },
 [0x1605]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1605,
 },
 [0x1606]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1606,
 },
 [0x1607]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1607,
 },
 [0x1608]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1608,
 },
 [0x1609]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1609,
 },
 [0x160A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ME",
  direction="l",
  linebreak="al",
  unicodeslot=0x160A,
 },
 [0x160B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x160B,
 },
 [0x160C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MI",
  direction="l",
  linebreak="al",
  unicodeslot=0x160C,
 },
 [0x160D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x160D,
 },
 [0x160E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YU",
  direction="l",
  linebreak="al",
  unicodeslot=0x160E,
 },
 [0x160F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YO",
  direction="l",
  linebreak="al",
  unicodeslot=0x160F,
 },
 [0x1610]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1610,
 },
 [0x1611]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1611,
 },
 [0x1612]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1612,
 },
 [0x1613]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1613,
 },
 [0x1614]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1614,
 },
 [0x1615]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI JU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1615,
 },
 [0x1616]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1616,
 },
 [0x1617]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1617,
 },
 [0x1618]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1618,
 },
 [0x1619]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1619,
 },
 [0x161A]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI JI",
  direction="l",
  linebreak="al",
  unicodeslot=0x161A,
 },
 [0x161B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x161B,
 },
 [0x161C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJU",
  direction="l",
  linebreak="al",
  unicodeslot=0x161C,
 },
 [0x161D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJO",
  direction="l",
  linebreak="al",
  unicodeslot=0x161D,
 },
 [0x161E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJE",
  direction="l",
  linebreak="al",
  unicodeslot=0x161E,
 },
 [0x161F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x161F,
 },
 [0x1620]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1620,
 },
 [0x1621]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1621,
 },
 [0x1622]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1622,
 },
 [0x1623]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1623,
 },
 [0x1624]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1624,
 },
 [0x1625]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1625,
 },
 [0x1626]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1626,
 },
 [0x1627]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1627,
 },
 [0x1628]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1628,
 },
 [0x1629]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1629,
 },
 [0x162A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLE",
  direction="l",
  linebreak="al",
  unicodeslot=0x162A,
 },
 [0x162B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x162B,
 },
 [0x162C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLI",
  direction="l",
  linebreak="al",
  unicodeslot=0x162C,
 },
 [0x162D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x162D,
 },
 [0x162E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x162E,
 },
 [0x162F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x162F,
 },
 [0x1630]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1630,
 },
 [0x1631]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1631,
 },
 [0x1632]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1632,
 },
 [0x1633]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1633,
 },
 [0x1634]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1634,
 },
 [0x1635]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1635,
 },
 [0x1636]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1636,
 },
 [0x1637]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1637,
 },
 [0x1638]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1638,
 },
 [0x1639]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1639,
 },
 [0x163A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLU",
  direction="l",
  linebreak="al",
  unicodeslot=0x163A,
 },
 [0x163B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLO",
  direction="l",
  linebreak="al",
  unicodeslot=0x163B,
 },
 [0x163C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLE",
  direction="l",
  linebreak="al",
  unicodeslot=0x163C,
 },
 [0x163D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x163D,
 },
 [0x163E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLI",
  direction="l",
  linebreak="al",
  unicodeslot=0x163E,
 },
 [0x163F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x163F,
 },
 [0x1640]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1640,
 },
 [0x1641]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1641,
 },
 [0x1642]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1642,
 },
 [0x1643]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1643,
 },
 [0x1644]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1644,
 },
 [0x1645]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1645,
 },
 [0x1646]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER Z",
  direction="l",
  linebreak="al",
  unicodeslot=0x1646,
 },
 [0x1647]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER INITIAL Z",
  direction="l",
  linebreak="al",
  unicodeslot=0x1647,
 },
 [0x1648]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1648,
 },
 [0x1649]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1649,
 },
 [0x164A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x164A,
 },
 [0x164B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x164B,
 },
 [0x164C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x164C,
 },
 [0x164D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x164D,
 },
 [0x164E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SU",
  direction="l",
  linebreak="al",
  unicodeslot=0x164E,
 },
 [0x164F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SO",
  direction="l",
  linebreak="al",
  unicodeslot=0x164F,
 },
 [0x1650]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1650,
 },
 [0x1651]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1651,
 },
 [0x1652]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1652,
 },
 [0x1653]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1653,
 },
 [0x1654]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1654,
 },
 [0x1655]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1655,
 },
 [0x1656]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1656,
 },
 [0x1657]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1657,
 },
 [0x1658]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1658,
 },
 [0x1659]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1659,
 },
 [0x165A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SH",
  direction="l",
  linebreak="al",
  unicodeslot=0x165A,
 },
 [0x165B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSU",
  direction="l",
  linebreak="al",
  unicodeslot=0x165B,
 },
 [0x165C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSO",
  direction="l",
  linebreak="al",
  unicodeslot=0x165C,
 },
 [0x165D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSE",
  direction="l",
  linebreak="al",
  unicodeslot=0x165D,
 },
 [0x165E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x165E,
 },
 [0x165F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSI",
  direction="l",
  linebreak="al",
  unicodeslot=0x165F,
 },
 [0x1660]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1660,
 },
 [0x1661]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1661,
 },
 [0x1662]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1662,
 },
 [0x1663]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1663,
 },
 [0x1664]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1664,
 },
 [0x1665]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1665,
 },
 [0x1666]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1666,
 },
 [0x1667]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1667,
 },
 [0x1668]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1668,
 },
 [0x1669]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1669,
 },
 [0x166A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x166A,
 },
 [0x166B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSI",
  direction="l",
  linebreak="al",
  unicodeslot=0x166B,
 },
 [0x166C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x166C,
 },
 [0x166D]={
  category="po",
  description="CANADIAN SYLLABICS CHI SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x166D,
 },
 [0x166E]={
  category="po",
  description="CANADIAN SYLLABICS FULL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x166E,
 },
 [0x166F]={
  category="lo",
  description="CANADIAN SYLLABICS QAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x166F,
 },
 [0x1670]={
  category="lo",
  description="CANADIAN SYLLABICS NGAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1670,
 },
 [0x1671]={
  category="lo",
  description="CANADIAN SYLLABICS NNGI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1671,
 },
 [0x1672]={
  category="lo",
  description="CANADIAN SYLLABICS NNGII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1672,
 },
 [0x1673]={
  category="lo",
  description="CANADIAN SYLLABICS NNGO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1673,
 },
 [0x1674]={
  category="lo",
  description="CANADIAN SYLLABICS NNGOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1674,
 },
 [0x1675]={
  category="lo",
  description="CANADIAN SYLLABICS NNGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1675,
 },
 [0x1676]={
  category="lo",
  description="CANADIAN SYLLABICS NNGAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1676,
 },
 [0x1677]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1677,
 },
 [0x1678]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1678,
 },
 [0x1679]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1679,
 },
 [0x167A]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x167A,
 },
 [0x167B]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x167B,
 },
 [0x167C]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x167C,
 },
 [0x167D]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x167D,
 },
 [0x167E]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE FINAL TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x167E,
 },
 [0x167F]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT W",
  direction="l",
  linebreak="al",
  unicodeslot=0x167F,
 },
 [0x1680]={
  category="zs",
  description="OGHAM SPACE MARK",
  direction="ws",
  linebreak="ba",
  unicodeslot=0x1680,
 },
 [0x1681]={
  category="lo",
  description="OGHAM LETTER BEITH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1681,
 },
 [0x1682]={
  category="lo",
  description="OGHAM LETTER LUIS",
  direction="l",
  linebreak="al",
  unicodeslot=0x1682,
 },
 [0x1683]={
  category="lo",
  description="OGHAM LETTER FEARN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1683,
 },
 [0x1684]={
  category="lo",
  description="OGHAM LETTER SAIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1684,
 },
 [0x1685]={
  category="lo",
  description="OGHAM LETTER NION",
  direction="l",
  linebreak="al",
  unicodeslot=0x1685,
 },
 [0x1686]={
  category="lo",
  description="OGHAM LETTER UATH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1686,
 },
 [0x1687]={
  category="lo",
  description="OGHAM LETTER DAIR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1687,
 },
 [0x1688]={
  category="lo",
  description="OGHAM LETTER TINNE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1688,
 },
 [0x1689]={
  category="lo",
  description="OGHAM LETTER COLL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1689,
 },
 [0x168A]={
  category="lo",
  description="OGHAM LETTER CEIRT",
  direction="l",
  linebreak="al",
  unicodeslot=0x168A,
 },
 [0x168B]={
  category="lo",
  description="OGHAM LETTER MUIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x168B,
 },
 [0x168C]={
  category="lo",
  description="OGHAM LETTER GORT",
  direction="l",
  linebreak="al",
  unicodeslot=0x168C,
 },
 [0x168D]={
  category="lo",
  description="OGHAM LETTER NGEADAL",
  direction="l",
  linebreak="al",
  unicodeslot=0x168D,
 },
 [0x168E]={
  category="lo",
  description="OGHAM LETTER STRAIF",
  direction="l",
  linebreak="al",
  unicodeslot=0x168E,
 },
 [0x168F]={
  category="lo",
  description="OGHAM LETTER RUIS",
  direction="l",
  linebreak="al",
  unicodeslot=0x168F,
 },
 [0x1690]={
  category="lo",
  description="OGHAM LETTER AILM",
  direction="l",
  linebreak="al",
  unicodeslot=0x1690,
 },
 [0x1691]={
  category="lo",
  description="OGHAM LETTER ONN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1691,
 },
 [0x1692]={
  category="lo",
  description="OGHAM LETTER UR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1692,
 },
 [0x1693]={
  category="lo",
  description="OGHAM LETTER EADHADH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1693,
 },
 [0x1694]={
  category="lo",
  description="OGHAM LETTER IODHADH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1694,
 },
 [0x1695]={
  category="lo",
  description="OGHAM LETTER EABHADH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1695,
 },
 [0x1696]={
  category="lo",
  description="OGHAM LETTER OR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1696,
 },
 [0x1697]={
  category="lo",
  description="OGHAM LETTER UILLEANN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1697,
 },
 [0x1698]={
  category="lo",
  description="OGHAM LETTER IFIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1698,
 },
 [0x1699]={
  category="lo",
  description="OGHAM LETTER EAMHANCHOLL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1699,
 },
 [0x169A]={
  category="lo",
  description="OGHAM LETTER PEITH",
  direction="l",
  linebreak="al",
  unicodeslot=0x169A,
 },
 [0x169B]={
  category="ps",
  description="OGHAM FEATHER MARK",
  direction="on",
  linebreak="op",
  mirror=0x169C,
  unicodeslot=0x169B,
 },
 [0x169C]={
  category="pe",
  description="OGHAM REVERSED FEATHER MARK",
  direction="on",
  linebreak="cl",
  mirror=0x169B,
  unicodeslot=0x169C,
 },
 [0x16A0]={
  category="lo",
  description="RUNIC LETTER FEHU FEOH FE F",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A0,
 },
 [0x16A1]={
  category="lo",
  description="RUNIC LETTER V",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A1,
 },
 [0x16A2]={
  category="lo",
  description="RUNIC LETTER URUZ UR U",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A2,
 },
 [0x16A3]={
  category="lo",
  description="RUNIC LETTER YR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A3,
 },
 [0x16A4]={
  category="lo",
  description="RUNIC LETTER Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A4,
 },
 [0x16A5]={
  category="lo",
  description="RUNIC LETTER W",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A5,
 },
 [0x16A6]={
  category="lo",
  description="RUNIC LETTER THURISAZ THURS THORN",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A6,
 },
 [0x16A7]={
  category="lo",
  description="RUNIC LETTER ETH",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A7,
 },
 [0x16A8]={
  category="lo",
  description="RUNIC LETTER ANSUZ A",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A8,
 },
 [0x16A9]={
  category="lo",
  description="RUNIC LETTER OS O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A9,
 },
 [0x16AA]={
  category="lo",
  description="RUNIC LETTER AC A",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AA,
 },
 [0x16AB]={
  category="lo",
  description="RUNIC LETTER AESC",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AB,
 },
 [0x16AC]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-OSS O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AC,
 },
 [0x16AD]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-OSS O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AD,
 },
 [0x16AE]={
  category="lo",
  description="RUNIC LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AE,
 },
 [0x16AF]={
  category="lo",
  description="RUNIC LETTER OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AF,
 },
 [0x16B0]={
  category="lo",
  description="RUNIC LETTER ON",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B0,
 },
 [0x16B1]={
  category="lo",
  description="RUNIC LETTER RAIDO RAD REID R",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B1,
 },
 [0x16B2]={
  category="lo",
  description="RUNIC LETTER KAUNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B2,
 },
 [0x16B3]={
  category="lo",
  description="RUNIC LETTER CEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B3,
 },
 [0x16B4]={
  category="lo",
  description="RUNIC LETTER KAUN K",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B4,
 },
 [0x16B5]={
  category="lo",
  description="RUNIC LETTER G",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B5,
 },
 [0x16B6]={
  category="lo",
  description="RUNIC LETTER ENG",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B6,
 },
 [0x16B7]={
  category="lo",
  description="RUNIC LETTER GEBO GYFU G",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B7,
 },
 [0x16B8]={
  category="lo",
  description="RUNIC LETTER GAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B8,
 },
 [0x16B9]={
  category="lo",
  description="RUNIC LETTER WUNJO WYNN W",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B9,
 },
 [0x16BA]={
  category="lo",
  description="RUNIC LETTER HAGLAZ H",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BA,
 },
 [0x16BB]={
  category="lo",
  description="RUNIC LETTER HAEGL H",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BB,
 },
 [0x16BC]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-HAGALL H",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BC,
 },
 [0x16BD]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-HAGALL H",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BD,
 },
 [0x16BE]={
  category="lo",
  description="RUNIC LETTER NAUDIZ NYD NAUD N",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BE,
 },
 [0x16BF]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-NAUD N",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BF,
 },
 [0x16C0]={
  category="lo",
  description="RUNIC LETTER DOTTED-N",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C0,
 },
 [0x16C1]={
  category="lo",
  description="RUNIC LETTER ISAZ IS ISS I",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C1,
 },
 [0x16C2]={
  category="lo",
  description="RUNIC LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C2,
 },
 [0x16C3]={
  category="lo",
  description="RUNIC LETTER JERAN J",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C3,
 },
 [0x16C4]={
  category="lo",
  description="RUNIC LETTER GER",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C4,
 },
 [0x16C5]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-AR AE",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C5,
 },
 [0x16C6]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-AR A",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C6,
 },
 [0x16C7]={
  category="lo",
  description="RUNIC LETTER IWAZ EOH",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C7,
 },
 [0x16C8]={
  category="lo",
  description="RUNIC LETTER PERTHO PEORTH P",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C8,
 },
 [0x16C9]={
  category="lo",
  description="RUNIC LETTER ALGIZ EOLHX",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C9,
 },
 [0x16CA]={
  category="lo",
  description="RUNIC LETTER SOWILO S",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CA,
 },
 [0x16CB]={
  category="lo",
  description="RUNIC LETTER SIGEL LONG-BRANCH-SOL S",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CB,
 },
 [0x16CC]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-SOL S",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CC,
 },
 [0x16CD]={
  category="lo",
  description="RUNIC LETTER C",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CD,
 },
 [0x16CE]={
  category="lo",
  description="RUNIC LETTER Z",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CE,
 },
 [0x16CF]={
  category="lo",
  description="RUNIC LETTER TIWAZ TIR TYR T",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CF,
 },
 [0x16D0]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-TYR T",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D0,
 },
 [0x16D1]={
  category="lo",
  description="RUNIC LETTER D",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D1,
 },
 [0x16D2]={
  category="lo",
  description="RUNIC LETTER BERKANAN BEORC BJARKAN B",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D2,
 },
 [0x16D3]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-BJARKAN B",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D3,
 },
 [0x16D4]={
  category="lo",
  description="RUNIC LETTER DOTTED-P",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D4,
 },
 [0x16D5]={
  category="lo",
  description="RUNIC LETTER OPEN-P",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D5,
 },
 [0x16D6]={
  category="lo",
  description="RUNIC LETTER EHWAZ EH E",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D6,
 },
 [0x16D7]={
  category="lo",
  description="RUNIC LETTER MANNAZ MAN M",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D7,
 },
 [0x16D8]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-MADR M",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D8,
 },
 [0x16D9]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-MADR M",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D9,
 },
 [0x16DA]={
  category="lo",
  description="RUNIC LETTER LAUKAZ LAGU LOGR L",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DA,
 },
 [0x16DB]={
  category="lo",
  description="RUNIC LETTER DOTTED-L",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DB,
 },
 [0x16DC]={
  category="lo",
  description="RUNIC LETTER INGWAZ",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DC,
 },
 [0x16DD]={
  category="lo",
  description="RUNIC LETTER ING",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DD,
 },
 [0x16DE]={
  category="lo",
  description="RUNIC LETTER DAGAZ DAEG D",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DE,
 },
 [0x16DF]={
  category="lo",
  description="RUNIC LETTER OTHALAN ETHEL O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DF,
 },
 [0x16E0]={
  category="lo",
  description="RUNIC LETTER EAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E0,
 },
 [0x16E1]={
  category="lo",
  description="RUNIC LETTER IOR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E1,
 },
 [0x16E2]={
  category="lo",
  description="RUNIC LETTER CWEORTH",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E2,
 },
 [0x16E3]={
  category="lo",
  description="RUNIC LETTER CALC",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E3,
 },
 [0x16E4]={
  category="lo",
  description="RUNIC LETTER CEALC",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E4,
 },
 [0x16E5]={
  category="lo",
  description="RUNIC LETTER STAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E5,
 },
 [0x16E6]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-YR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E6,
 },
 [0x16E7]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-YR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E7,
 },
 [0x16E8]={
  category="lo",
  description="RUNIC LETTER ICELANDIC-YR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E8,
 },
 [0x16E9]={
  category="lo",
  description="RUNIC LETTER Q",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E9,
 },
 [0x16EA]={
  category="lo",
  description="RUNIC LETTER X",
  direction="l",
  linebreak="al",
  unicodeslot=0x16EA,
 },
 [0x16EB]={
  category="po",
  description="RUNIC SINGLE PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x16EB,
 },
 [0x16EC]={
  category="po",
  description="RUNIC MULTIPLE PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x16EC,
 },
 [0x16ED]={
  category="po",
  description="RUNIC CROSS PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x16ED,
 },
 [0x16EE]={
  category="nl",
  description="RUNIC ARLAUG SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x16EE,
 },
 [0x16EF]={
  category="nl",
  description="RUNIC TVIMADUR SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x16EF,
 },
 [0x16F0]={
  category="nl",
  description="RUNIC BELGTHOR SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F0,
 },
 [0x16F1]={
  category="lo",
  description="RUNIC LETTER K",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F1,
 },
 [0x16F2]={
  category="lo",
  description="RUNIC LETTER SH",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F2,
 },
 [0x16F3]={
  category="lo",
  description="RUNIC LETTER OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F3,
 },
 [0x16F4]={
  category="lo",
  description="RUNIC LETTER FRANKS CASKET OS",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F4,
 },
 [0x16F5]={
  category="lo",
  description="RUNIC LETTER FRANKS CASKET IS",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F5,
 },
 [0x16F6]={
  category="lo",
  description="RUNIC LETTER FRANKS CASKET EH",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F6,
 },
 [0x16F7]={
  category="lo",
  description="RUNIC LETTER FRANKS CASKET AC",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F7,
 },
 [0x16F8]={
  category="lo",
  description="RUNIC LETTER FRANKS CASKET AESC",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F8,
 },
 [0x1700]={
  category="lo",
  description="TAGALOG LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1700,
 },
 [0x1701]={
  category="lo",
  description="TAGALOG LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1701,
 },
 [0x1702]={
  category="lo",
  description="TAGALOG LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1702,
 },
 [0x1703]={
  category="lo",
  description="TAGALOG LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1703,
 },
 [0x1704]={
  category="lo",
  description="TAGALOG LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1704,
 },
 [0x1705]={
  category="lo",
  description="TAGALOG LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1705,
 },
 [0x1706]={
  category="lo",
  description="TAGALOG LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1706,
 },
 [0x1707]={
  category="lo",
  description="TAGALOG LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1707,
 },
 [0x1708]={
  category="lo",
  description="TAGALOG LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1708,
 },
 [0x1709]={
  category="lo",
  description="TAGALOG LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1709,
 },
 [0x170A]={
  category="lo",
  description="TAGALOG LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170A,
 },
 [0x170B]={
  category="lo",
  description="TAGALOG LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170B,
 },
 [0x170C]={
  category="lo",
  description="TAGALOG LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170C,
 },
 [0x170E]={
  category="lo",
  description="TAGALOG LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170E,
 },
 [0x170F]={
  category="lo",
  description="TAGALOG LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170F,
 },
 [0x1710]={
  category="lo",
  description="TAGALOG LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1710,
 },
 [0x1711]={
  category="lo",
  description="TAGALOG LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1711,
 },
 [0x1712]={
  category="mn",
  description="TAGALOG VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1712,
 },
 [0x1713]={
  category="mn",
  description="TAGALOG VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1713,
 },
 [0x1714]={
  category="mn",
  combining=0x9,
  description="TAGALOG SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1714,
 },
 [0x1720]={
  category="lo",
  description="HANUNOO LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1720,
 },
 [0x1721]={
  category="lo",
  description="HANUNOO LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1721,
 },
 [0x1722]={
  category="lo",
  description="HANUNOO LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1722,
 },
 [0x1723]={
  category="lo",
  description="HANUNOO LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1723,
 },
 [0x1724]={
  category="lo",
  description="HANUNOO LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1724,
 },
 [0x1725]={
  category="lo",
  description="HANUNOO LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1725,
 },
 [0x1726]={
  category="lo",
  description="HANUNOO LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1726,
 },
 [0x1727]={
  category="lo",
  description="HANUNOO LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1727,
 },
 [0x1728]={
  category="lo",
  description="HANUNOO LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1728,
 },
 [0x1729]={
  category="lo",
  description="HANUNOO LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1729,
 },
 [0x172A]={
  category="lo",
  description="HANUNOO LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172A,
 },
 [0x172B]={
  category="lo",
  description="HANUNOO LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172B,
 },
 [0x172C]={
  category="lo",
  description="HANUNOO LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172C,
 },
 [0x172D]={
  category="lo",
  description="HANUNOO LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172D,
 },
 [0x172E]={
  category="lo",
  description="HANUNOO LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172E,
 },
 [0x172F]={
  category="lo",
  description="HANUNOO LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172F,
 },
 [0x1730]={
  category="lo",
  description="HANUNOO LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1730,
 },
 [0x1731]={
  category="lo",
  description="HANUNOO LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1731,
 },
 [0x1732]={
  category="mn",
  description="HANUNOO VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1732,
 },
 [0x1733]={
  category="mn",
  description="HANUNOO VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1733,
 },
 [0x1734]={
  category="mn",
  combining=0x9,
  description="HANUNOO SIGN PAMUDPOD",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1734,
 },
 [0x1735]={
  category="po",
  description="PHILIPPINE SINGLE PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1735,
 },
 [0x1736]={
  category="po",
  description="PHILIPPINE DOUBLE PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1736,
 },
 [0x1740]={
  category="lo",
  description="BUHID LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1740,
 },
 [0x1741]={
  category="lo",
  description="BUHID LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1741,
 },
 [0x1742]={
  category="lo",
  description="BUHID LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1742,
 },
 [0x1743]={
  category="lo",
  description="BUHID LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1743,
 },
 [0x1744]={
  category="lo",
  description="BUHID LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1744,
 },
 [0x1745]={
  category="lo",
  description="BUHID LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1745,
 },
 [0x1746]={
  category="lo",
  description="BUHID LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1746,
 },
 [0x1747]={
  category="lo",
  description="BUHID LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1747,
 },
 [0x1748]={
  category="lo",
  description="BUHID LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1748,
 },
 [0x1749]={
  category="lo",
  description="BUHID LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1749,
 },
 [0x174A]={
  category="lo",
  description="BUHID LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174A,
 },
 [0x174B]={
  category="lo",
  description="BUHID LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174B,
 },
 [0x174C]={
  category="lo",
  description="BUHID LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174C,
 },
 [0x174D]={
  category="lo",
  description="BUHID LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174D,
 },
 [0x174E]={
  category="lo",
  description="BUHID LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174E,
 },
 [0x174F]={
  category="lo",
  description="BUHID LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174F,
 },
 [0x1750]={
  category="lo",
  description="BUHID LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1750,
 },
 [0x1751]={
  category="lo",
  description="BUHID LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1751,
 },
 [0x1752]={
  category="mn",
  description="BUHID VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1752,
 },
 [0x1753]={
  category="mn",
  description="BUHID VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1753,
 },
 [0x1760]={
  category="lo",
  description="TAGBANWA LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1760,
 },
 [0x1761]={
  category="lo",
  description="TAGBANWA LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1761,
 },
 [0x1762]={
  category="lo",
  description="TAGBANWA LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1762,
 },
 [0x1763]={
  category="lo",
  description="TAGBANWA LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1763,
 },
 [0x1764]={
  category="lo",
  description="TAGBANWA LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1764,
 },
 [0x1765]={
  category="lo",
  description="TAGBANWA LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1765,
 },
 [0x1766]={
  category="lo",
  description="TAGBANWA LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1766,
 },
 [0x1767]={
  category="lo",
  description="TAGBANWA LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1767,
 },
 [0x1768]={
  category="lo",
  description="TAGBANWA LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1768,
 },
 [0x1769]={
  category="lo",
  description="TAGBANWA LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1769,
 },
 [0x176A]={
  category="lo",
  description="TAGBANWA LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176A,
 },
 [0x176B]={
  category="lo",
  description="TAGBANWA LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176B,
 },
 [0x176C]={
  category="lo",
  description="TAGBANWA LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176C,
 },
 [0x176E]={
  category="lo",
  description="TAGBANWA LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176E,
 },
 [0x176F]={
  category="lo",
  description="TAGBANWA LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176F,
 },
 [0x1770]={
  category="lo",
  description="TAGBANWA LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1770,
 },
 [0x1772]={
  category="mn",
  description="TAGBANWA VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1772,
 },
 [0x1773]={
  category="mn",
  description="TAGBANWA VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1773,
 },
 [0x1780]={
  category="lo",
  description="KHMER LETTER KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1780,
 },
 [0x1781]={
  category="lo",
  description="KHMER LETTER KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1781,
 },
 [0x1782]={
  category="lo",
  description="KHMER LETTER KO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1782,
 },
 [0x1783]={
  category="lo",
  description="KHMER LETTER KHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1783,
 },
 [0x1784]={
  category="lo",
  description="KHMER LETTER NGO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1784,
 },
 [0x1785]={
  category="lo",
  description="KHMER LETTER CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1785,
 },
 [0x1786]={
  category="lo",
  description="KHMER LETTER CHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1786,
 },
 [0x1787]={
  category="lo",
  description="KHMER LETTER CO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1787,
 },
 [0x1788]={
  category="lo",
  description="KHMER LETTER CHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1788,
 },
 [0x1789]={
  category="lo",
  description="KHMER LETTER NYO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1789,
 },
 [0x178A]={
  category="lo",
  description="KHMER LETTER DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178A,
 },
 [0x178B]={
  category="lo",
  description="KHMER LETTER TTHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178B,
 },
 [0x178C]={
  category="lo",
  description="KHMER LETTER DO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178C,
 },
 [0x178D]={
  category="lo",
  description="KHMER LETTER TTHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178D,
 },
 [0x178E]={
  category="lo",
  description="KHMER LETTER NNO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178E,
 },
 [0x178F]={
  category="lo",
  description="KHMER LETTER TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178F,
 },
 [0x1790]={
  category="lo",
  description="KHMER LETTER THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1790,
 },
 [0x1791]={
  category="lo",
  description="KHMER LETTER TO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1791,
 },
 [0x1792]={
  category="lo",
  description="KHMER LETTER THO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1792,
 },
 [0x1793]={
  category="lo",
  description="KHMER LETTER NO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1793,
 },
 [0x1794]={
  category="lo",
  description="KHMER LETTER BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1794,
 },
 [0x1795]={
  category="lo",
  description="KHMER LETTER PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1795,
 },
 [0x1796]={
  category="lo",
  description="KHMER LETTER PO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1796,
 },
 [0x1797]={
  category="lo",
  description="KHMER LETTER PHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1797,
 },
 [0x1798]={
  category="lo",
  description="KHMER LETTER MO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1798,
 },
 [0x1799]={
  category="lo",
  description="KHMER LETTER YO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1799,
 },
 [0x179A]={
  category="lo",
  description="KHMER LETTER RO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179A,
 },
 [0x179B]={
  category="lo",
  description="KHMER LETTER LO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179B,
 },
 [0x179C]={
  category="lo",
  description="KHMER LETTER VO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179C,
 },
 [0x179D]={
  category="lo",
  description="KHMER LETTER SHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179D,
 },
 [0x179E]={
  category="lo",
  description="KHMER LETTER SSO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179E,
 },
 [0x179F]={
  category="lo",
  description="KHMER LETTER SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179F,
 },
 [0x17A0]={
  category="lo",
  description="KHMER LETTER HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A0,
 },
 [0x17A1]={
  category="lo",
  description="KHMER LETTER LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A1,
 },
 [0x17A2]={
  category="lo",
  description="KHMER LETTER QA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A2,
 },
 [0x17A3]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QAQ",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A3,
 },
 [0x17A4]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QAA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A4,
 },
 [0x17A5]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A5,
 },
 [0x17A6]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QII",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A6,
 },
 [0x17A7]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A7,
 },
 [0x17A8]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QUK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A8,
 },
 [0x17A9]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QUU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A9,
 },
 [0x17AA]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QUUV",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AA,
 },
 [0x17AB]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL RY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AB,
 },
 [0x17AC]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL RYY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AC,
 },
 [0x17AD]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL LY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AD,
 },
 [0x17AE]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL LYY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AE,
 },
 [0x17AF]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AF,
 },
 [0x17B0]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B0,
 },
 [0x17B1]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QOO TYPE ONE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B1,
 },
 [0x17B2]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QOO TYPE TWO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B2,
 },
 [0x17B3]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QAU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B3,
 },
 [0x17B4]={
  category="cf",
  description="KHMER VOWEL INHERENT AQ",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17B4,
 },
 [0x17B5]={
  category="cf",
  description="KHMER VOWEL INHERENT AA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17B5,
 },
 [0x17B6]={
  category="mc",
  description="KHMER VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B6,
 },
 [0x17B7]={
  category="mn",
  description="KHMER VOWEL SIGN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17B7,
 },
 [0x17B8]={
  category="mn",
  description="KHMER VOWEL SIGN II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17B8,
 },
 [0x17B9]={
  category="mn",
  description="KHMER VOWEL SIGN Y",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17B9,
 },
 [0x17BA]={
  category="mn",
  description="KHMER VOWEL SIGN YY",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17BA,
 },
 [0x17BB]={
  category="mn",
  description="KHMER VOWEL SIGN U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17BB,
 },
 [0x17BC]={
  category="mn",
  description="KHMER VOWEL SIGN UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17BC,
 },
 [0x17BD]={
  category="mn",
  description="KHMER VOWEL SIGN UA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17BD,
 },
 [0x17BE]={
  category="mc",
  description="KHMER VOWEL SIGN OE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17BE,
 },
 [0x17BF]={
  category="mc",
  description="KHMER VOWEL SIGN YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17BF,
 },
 [0x17C0]={
  category="mc",
  description="KHMER VOWEL SIGN IE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C0,
 },
 [0x17C1]={
  category="mc",
  description="KHMER VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C1,
 },
 [0x17C2]={
  category="mc",
  description="KHMER VOWEL SIGN AE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C2,
 },
 [0x17C3]={
  category="mc",
  description="KHMER VOWEL SIGN AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C3,
 },
 [0x17C4]={
  category="mc",
  description="KHMER VOWEL SIGN OO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C4,
 },
 [0x17C5]={
  category="mc",
  description="KHMER VOWEL SIGN AU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C5,
 },
 [0x17C6]={
  category="mn",
  description="KHMER SIGN NIKAHIT",
  direction="nsm",
  linebreak="sa",
  synonyms={ "khmer anusvara", "khmer srak am" },
  unicodeslot=0x17C6,
 },
 [0x17C7]={
  category="mc",
  description="KHMER SIGN REAHMUK",
  direction="l",
  linebreak="sa",
  synonyms={ "khmer srak ah", "khmer visarga" },
  unicodeslot=0x17C7,
 },
 [0x17C8]={
  category="mc",
  description="KHMER SIGN YUUKALEAPINTU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C8,
 },
 [0x17C9]={
  category="mn",
  description="KHMER SIGN MUUSIKATOAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17C9,
 },
 [0x17CA]={
  category="mn",
  description="KHMER SIGN TRIISAP",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CA,
 },
 [0x17CB]={
  category="mn",
  description="KHMER SIGN BANTOC",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CB,
 },
 [0x17CC]={
  category="mn",
  description="KHMER SIGN ROBAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CC,
 },
 [0x17CD]={
  category="mn",
  description="KHMER SIGN TOANDAKHIAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CD,
 },
 [0x17CE]={
  category="mn",
  description="KHMER SIGN KAKABAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CE,
 },
 [0x17CF]={
  category="mn",
  description="KHMER SIGN AHSDA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CF,
 },
 [0x17D0]={
  category="mn",
  description="KHMER SIGN SAMYOK SANNYA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17D0,
 },
 [0x17D1]={
  category="mn",
  description="KHMER SIGN VIRIAM",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17D1,
 },
 [0x17D2]={
  category="mn",
  combining=0x9,
  description="KHMER SIGN COENG",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17D2,
 },
 [0x17D3]={
  category="mn",
  description="KHMER SIGN BATHAMASAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17D3,
 },
 [0x17D4]={
  category="po",
  description="KHMER SIGN KHAN",
  direction="l",
  linebreak="ba",
  unicodeslot=0x17D4,
 },
 [0x17D5]={
  category="po",
  description="KHMER SIGN BARIYOOSAN",
  direction="l",
  linebreak="ba",
  unicodeslot=0x17D5,
 },
 [0x17D6]={
  category="po",
  description="KHMER SIGN CAMNUC PII KUUH",
  direction="l",
  linebreak="ns",
  unicodeslot=0x17D6,
 },
 [0x17D7]={
  category="lm",
  description="KHMER SIGN LEK TOO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17D7,
 },
 [0x17D8]={
  category="po",
  description="KHMER SIGN BEYYAL",
  direction="l",
  linebreak="ba",
  unicodeslot=0x17D8,
 },
 [0x17D9]={
  category="po",
  description="KHMER SIGN PHNAEK MUAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x17D9,
 },
 [0x17DA]={
  category="po",
  description="KHMER SIGN KOOMUUT",
  direction="l",
  linebreak="ba",
  unicodeslot=0x17DA,
 },
 [0x17DB]={
  category="sc",
  description="KHMER CURRENCY SYMBOL RIEL",
  direction="et",
  linebreak="pr",
  unicodeslot=0x17DB,
 },
 [0x17DC]={
  category="lo",
  description="KHMER SIGN AVAKRAHASANYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17DC,
 },
 [0x17DD]={
  category="mn",
  combining=0xE6,
  description="KHMER SIGN ATTHACAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17DD,
 },
 [0x17E0]={
  category="nd",
  description="KHMER DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E0,
 },
 [0x17E1]={
  category="nd",
  description="KHMER DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E1,
 },
 [0x17E2]={
  category="nd",
  description="KHMER DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E2,
 },
 [0x17E3]={
  category="nd",
  description="KHMER DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E3,
 },
 [0x17E4]={
  category="nd",
  description="KHMER DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E4,
 },
 [0x17E5]={
  category="nd",
  description="KHMER DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E5,
 },
 [0x17E6]={
  category="nd",
  description="KHMER DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E6,
 },
 [0x17E7]={
  category="nd",
  description="KHMER DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E7,
 },
 [0x17E8]={
  category="nd",
  description="KHMER DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E8,
 },
 [0x17E9]={
  category="nd",
  description="KHMER DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E9,
 },
 [0x17F0]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK SON",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F0,
 },
 [0x17F1]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK MUOY",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F1,
 },
 [0x17F2]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PII",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F2,
 },
 [0x17F3]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK BEI",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F3,
 },
 [0x17F4]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK BUON",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F4,
 },
 [0x17F5]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F5,
 },
 [0x17F6]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM-MUOY",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F6,
 },
 [0x17F7]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM-PII",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F7,
 },
 [0x17F8]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM-BEI",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F8,
 },
 [0x17F9]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM-BUON",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F9,
 },
 [0x1800]={
  category="po",
  description="MONGOLIAN BIRGA",
  direction="on",
  linebreak="al",
  unicodeslot=0x1800,
 },
 [0x1801]={
  category="po",
  description="MONGOLIAN ELLIPSIS",
  direction="on",
  linebreak="al",
  unicodeslot=0x1801,
 },
 [0x1802]={
  category="po",
  description="MONGOLIAN COMMA",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1802,
 },
 [0x1803]={
  category="po",
  description="MONGOLIAN FULL STOP",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1803,
 },
 [0x1804]={
  category="po",
  description="MONGOLIAN COLON",
  direction="on",
  linebreak="ba",
  unicodeslot=0x1804,
 },
 [0x1805]={
  category="po",
  description="MONGOLIAN FOUR DOTS",
  direction="on",
  linebreak="ba",
  unicodeslot=0x1805,
 },
 [0x1806]={
  arabic="u",
  category="pd",
  description="MONGOLIAN TODO SOFT HYPHEN",
  direction="on",
  linebreak="bb",
  unicodeslot=0x1806,
 },
 [0x1807]={
  arabic="d",
  category="po",
  description="MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER",
  direction="on",
  linebreak="al",
  unicodeslot=0x1807,
 },
 [0x1808]={
  category="po",
  description="MONGOLIAN MANCHU COMMA",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1808,
 },
 [0x1809]={
  category="po",
  description="MONGOLIAN MANCHU FULL STOP",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1809,
 },
 [0x180A]={
  arabic="c",
  category="po",
  description="MONGOLIAN NIRUGU",
  direction="on",
  linebreak="al",
  unicodeslot=0x180A,
 },
 [0x180B]={
  category="mn",
  description="MONGOLIAN FREE VARIATION SELECTOR ONE",
  direction="nsm",
  linebreak="cm",
  synonyms={ "fvs1" },
  unicodeslot=0x180B,
 },
 [0x180C]={
  category="mn",
  description="MONGOLIAN FREE VARIATION SELECTOR TWO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x180C,
 },
 [0x180D]={
  category="mn",
  description="MONGOLIAN FREE VARIATION SELECTOR THREE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x180D,
 },
 [0x180E]={
  arabic="u",
  category="zs",
  description="MONGOLIAN VOWEL SEPARATOR",
  direction="bn",
  linebreak="gl",
  unicodeslot=0x180E,
 },
 [0x1810]={
  category="nd",
  description="MONGOLIAN DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1810,
 },
 [0x1811]={
  category="nd",
  description="MONGOLIAN DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1811,
 },
 [0x1812]={
  category="nd",
  description="MONGOLIAN DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1812,
 },
 [0x1813]={
  category="nd",
  description="MONGOLIAN DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1813,
 },
 [0x1814]={
  category="nd",
  description="MONGOLIAN DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1814,
 },
 [0x1815]={
  category="nd",
  description="MONGOLIAN DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1815,
 },
 [0x1816]={
  category="nd",
  description="MONGOLIAN DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1816,
 },
 [0x1817]={
  category="nd",
  description="MONGOLIAN DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1817,
 },
 [0x1818]={
  category="nd",
  description="MONGOLIAN DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1818,
 },
 [0x1819]={
  category="nd",
  description="MONGOLIAN DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1819,
 },
 [0x1820]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1820,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1821]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1821,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1822]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1822,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1823]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1823,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1824]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1824,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1825]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1825,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1826]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER UE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1826,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1827]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1827,
 },
 [0x1828]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1828,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="separate form",
  },
 },
 [0x1829]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1829,
 },
 [0x182A]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182A,
  variants={
   [0x180B]="alternative form",
  },
 },
 [0x182B]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182B,
 },
 [0x182C]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182C,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="fourth form",
  },
 },
 [0x182D]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182D,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="feminine form",
  },
 },
 [0x182E]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182E,
 },
 [0x182F]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182F,
 },
 [0x1830]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1830,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1831]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1831,
 },
 [0x1832]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1832,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1833]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1833,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1834]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1834,
 },
 [0x1835]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1835,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1836]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1836,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1837]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1837,
 },
 [0x1838]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1838,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1839]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1839,
 },
 [0x183A]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183A,
 },
 [0x183B]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183B,
 },
 [0x183C]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183C,
 },
 [0x183D]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183D,
 },
 [0x183E]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183E,
 },
 [0x183F]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ZRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183F,
 },
 [0x1840]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1840,
 },
 [0x1841]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ZHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1841,
 },
 [0x1842]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER CHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1842,
 },
 [0x1843]={
  arabic="d",
  category="lm",
  description="MONGOLIAN LETTER TODO LONG VOWEL SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1843,
 },
 [0x1844]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1844,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1845]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1845,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1846]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1846,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1847]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1847,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1848]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1848,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1849]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO UE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1849,
  variants={
   [0x180B]="second form",
  },
 },
 [0x184A]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO ANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x184A,
 },
 [0x184B]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184B,
 },
 [0x184C]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184C,
 },
 [0x184D]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184D,
  variants={
   [0x180B]="feminine form",
  },
 },
 [0x184E]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184E,
  variants={
   [0x180B]="second form",
  },
 },
 [0x184F]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184F,
 },
 [0x1850]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1850,
 },
 [0x1851]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1851,
 },
 [0x1852]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1852,
 },
 [0x1853]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1853,
 },
 [0x1854]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1854,
 },
 [0x1855]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1855,
 },
 [0x1856]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1856,
 },
 [0x1857]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1857,
 },
 [0x1858]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO GAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1858,
 },
 [0x1859]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1859,
 },
 [0x185A]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO JIA",
  direction="l",
  linebreak="al",
  unicodeslot=0x185A,
 },
 [0x185B]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO NIA",
  direction="l",
  linebreak="al",
  unicodeslot=0x185B,
 },
 [0x185C]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO DZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x185C,
 },
 [0x185D]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE E",
  direction="l",
  linebreak="al",
  unicodeslot=0x185D,
  variants={
   [0x180B]="second form",
  },
 },
 [0x185E]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE I",
  direction="l",
  linebreak="al",
  unicodeslot=0x185E,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x185F]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE IY",
  direction="l",
  linebreak="al",
  unicodeslot=0x185F,
 },
 [0x1860]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE UE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1860,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1861]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1861,
 },
 [0x1862]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE ANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1862,
 },
 [0x1863]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1863,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1864]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1864,
 },
 [0x1865]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1865,
 },
 [0x1866]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1866,
 },
 [0x1867]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1867,
 },
 [0x1868]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1868,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1869]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1869,
  variants={
   [0x180B]="second form",
  },
 },
 [0x186A]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186A,
 },
 [0x186B]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186B,
 },
 [0x186C]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE GAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186C,
 },
 [0x186D]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186D,
 },
 [0x186E]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186E,
 },
 [0x186F]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186F,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1870]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE RAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1870,
 },
 [0x1871]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1871,
 },
 [0x1872]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER SIBE ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1872,
 },
 [0x1873]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1873,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="fourth form",
  },
 },
 [0x1874]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1874,
  variants={
   [0x180B]="second form",
   [0x180C]="feminine first medial form",
   [0x180D]="feminine second medial form",
  },
 },
 [0x1875]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1875,
 },
 [0x1876]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1876,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1877]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1877,
 },
 [0x1880]={
  arabic="u",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI ANUSVARA ONE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1880,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1881]={
  arabic="u",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI VISARGA ONE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1881,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1882]={
  arabic="u",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI DAMARU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1882,
 },
 [0x1883]={
  arabic="u",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI UBADAMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1883,
 },
 [0x1884]={
  arabic="u",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI INVERTED UBADAMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1884,
 },
 [0x1885]={
  arabic="t",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI BALUDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1885,
 },
 [0x1886]={
  arabic="t",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI THREE BALUDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1886,
 },
 [0x1887]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1887,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="fourth form",
  },
 },
 [0x1888]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1888,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1889]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1889,
 },
 [0x188A]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188A,
  variants={
   [0x180B]="second form",
  },
 },
 [0x188B]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188B,
 },
 [0x188C]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188C,
 },
 [0x188D]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188D,
 },
 [0x188E]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188E,
 },
 [0x188F]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188F,
 },
 [0x1890]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1890,
 },
 [0x1891]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1891,
 },
 [0x1892]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1892,
 },
 [0x1893]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1893,
 },
 [0x1894]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1894,
 },
 [0x1895]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1895,
 },
 [0x1896]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1896,
 },
 [0x1897]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI AH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1897,
 },
 [0x1898]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO ALI GALI TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1898,
 },
 [0x1899]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER TODO ALI GALI ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1899,
 },
 [0x189A]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189A,
 },
 [0x189B]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189B,
 },
 [0x189C]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189C,
 },
 [0x189D]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189D,
 },
 [0x189E]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189E,
 },
 [0x189F]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189F,
 },
 [0x18A0]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A0,
 },
 [0x18A1]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A1,
 },
 [0x18A2]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A2,
 },
 [0x18A3]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI CYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A3,
 },
 [0x18A4]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A4,
 },
 [0x18A5]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A5,
 },
 [0x18A6]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI HALF U",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A6,
 },
 [0x18A7]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER ALI GALI HALF YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A7,
 },
 [0x18A8]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A8,
 },
 [0x18A9]={
  category="mn",
  combining=0xE4,
  description="MONGOLIAN LETTER ALI GALI DAGALGA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x18A9,
 },
 [0x18AA]={
  arabic="d",
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18AA,
 },
 [0x18B0]={
  category="lo",
  description="CANADIAN SYLLABICS OY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B0,
 },
 [0x18B1]={
  category="lo",
  description="CANADIAN SYLLABICS AY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B1,
 },
 [0x18B2]={
  category="lo",
  description="CANADIAN SYLLABICS AAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B2,
 },
 [0x18B3]={
  category="lo",
  description="CANADIAN SYLLABICS WAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B3,
 },
 [0x18B4]={
  category="lo",
  description="CANADIAN SYLLABICS POY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B4,
 },
 [0x18B5]={
  category="lo",
  description="CANADIAN SYLLABICS PAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B5,
 },
 [0x18B6]={
  category="lo",
  description="CANADIAN SYLLABICS PWOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B6,
 },
 [0x18B7]={
  category="lo",
  description="CANADIAN SYLLABICS TAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B7,
 },
 [0x18B8]={
  category="lo",
  description="CANADIAN SYLLABICS KAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B8,
 },
 [0x18B9]={
  category="lo",
  description="CANADIAN SYLLABICS KWAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B9,
 },
 [0x18BA]={
  category="lo",
  description="CANADIAN SYLLABICS MAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BA,
 },
 [0x18BB]={
  category="lo",
  description="CANADIAN SYLLABICS NOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BB,
 },
 [0x18BC]={
  category="lo",
  description="CANADIAN SYLLABICS NAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BC,
 },
 [0x18BD]={
  category="lo",
  description="CANADIAN SYLLABICS LAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BD,
 },
 [0x18BE]={
  category="lo",
  description="CANADIAN SYLLABICS SOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BE,
 },
 [0x18BF]={
  category="lo",
  description="CANADIAN SYLLABICS SAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BF,
 },
 [0x18C0]={
  category="lo",
  description="CANADIAN SYLLABICS SHOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C0,
 },
 [0x18C1]={
  category="lo",
  description="CANADIAN SYLLABICS SHAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C1,
 },
 [0x18C2]={
  category="lo",
  description="CANADIAN SYLLABICS SHWOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C2,
 },
 [0x18C3]={
  category="lo",
  description="CANADIAN SYLLABICS YOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C3,
 },
 [0x18C4]={
  category="lo",
  description="CANADIAN SYLLABICS YAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C4,
 },
 [0x18C5]={
  category="lo",
  description="CANADIAN SYLLABICS RAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C5,
 },
 [0x18C6]={
  category="lo",
  description="CANADIAN SYLLABICS NWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C6,
 },
 [0x18C7]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY NWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C7,
 },
 [0x18C8]={
  category="lo",
  description="CANADIAN SYLLABICS NWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C8,
 },
 [0x18C9]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY NWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C9,
 },
 [0x18CA]={
  category="lo",
  description="CANADIAN SYLLABICS NWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CA,
 },
 [0x18CB]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY NWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CB,
 },
 [0x18CC]={
  category="lo",
  description="CANADIAN SYLLABICS NWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CC,
 },
 [0x18CD]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY NWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CD,
 },
 [0x18CE]={
  category="lo",
  description="CANADIAN SYLLABICS RWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CE,
 },
 [0x18CF]={
  category="lo",
  description="CANADIAN SYLLABICS RWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CF,
 },
 [0x18D0]={
  category="lo",
  description="CANADIAN SYLLABICS RWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D0,
 },
 [0x18D1]={
  category="lo",
  description="CANADIAN SYLLABICS RWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D1,
 },
 [0x18D2]={
  category="lo",
  description="CANADIAN SYLLABICS RWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D2,
 },
 [0x18D3]={
  category="lo",
  description="CANADIAN SYLLABICS RWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D3,
 },
 [0x18D4]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY P",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D4,
 },
 [0x18D5]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY T",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D5,
 },
 [0x18D6]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY K",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D6,
 },
 [0x18D7]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY C",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D7,
 },
 [0x18D8]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY M",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D8,
 },
 [0x18D9]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY N",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D9,
 },
 [0x18DA]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY S",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DA,
 },
 [0x18DB]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY SH",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DB,
 },
 [0x18DC]={
  category="lo",
  description="CANADIAN SYLLABICS EASTERN W",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DC,
 },
 [0x18DD]={
  category="lo",
  description="CANADIAN SYLLABICS WESTERN W",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DD,
 },
 [0x18DE]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL SMALL RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DE,
 },
 [0x18DF]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL RAISED DOT",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DF,
 },
 [0x18E0]={
  category="lo",
  description="CANADIAN SYLLABICS R-CREE RWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E0,
 },
 [0x18E1]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E1,
 },
 [0x18E2]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E2,
 },
 [0x18E3]={
  category="lo",
  description="CANADIAN SYLLABICS THWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E3,
 },
 [0x18E4]={
  category="lo",
  description="CANADIAN SYLLABICS THWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E4,
 },
 [0x18E5]={
  category="lo",
  description="CANADIAN SYLLABICS TTHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E5,
 },
 [0x18E6]={
  category="lo",
  description="CANADIAN SYLLABICS TTHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E6,
 },
 [0x18E7]={
  category="lo",
  description="CANADIAN SYLLABICS TTHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E7,
 },
 [0x18E8]={
  category="lo",
  description="CANADIAN SYLLABICS TLHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E8,
 },
 [0x18E9]={
  category="lo",
  description="CANADIAN SYLLABICS TLHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E9,
 },
 [0x18EA]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EA,
 },
 [0x18EB]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EB,
 },
 [0x18EC]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EC,
 },
 [0x18ED]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GWU",
  direction="l",
  linebreak="al",
  unicodeslot=0x18ED,
 },
 [0x18EE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DENE GEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EE,
 },
 [0x18EF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EF,
 },
 [0x18F0]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F0,
 },
 [0x18F1]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI JUU",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F1,
 },
 [0x18F2]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F2,
 },
 [0x18F3]={
  category="lo",
  description="CANADIAN SYLLABICS BEAVER DENE L",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F3,
 },
 [0x18F4]={
  category="lo",
  description="CANADIAN SYLLABICS BEAVER DENE R",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F4,
 },
 [0x18F5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DENTAL S",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F5,
 },
 [0x1900]={
  category="lo",
  description="LIMBU VOWEL-CARRIER LETTER",
  direction="l",
  linebreak="al",
  unicodeslot=0x1900,
 },
 [0x1901]={
  category="lo",
  description="LIMBU LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1901,
 },
 [0x1902]={
  category="lo",
  description="LIMBU LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1902,
 },
 [0x1903]={
  category="lo",
  description="LIMBU LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1903,
 },
 [0x1904]={
  category="lo",
  description="LIMBU LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1904,
 },
 [0x1905]={
  category="lo",
  description="LIMBU LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1905,
 },
 [0x1906]={
  category="lo",
  description="LIMBU LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1906,
 },
 [0x1907]={
  category="lo",
  description="LIMBU LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1907,
 },
 [0x1908]={
  category="lo",
  description="LIMBU LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1908,
 },
 [0x1909]={
  category="lo",
  description="LIMBU LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1909,
 },
 [0x190A]={
  category="lo",
  description="LIMBU LETTER YAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x190A,
 },
 [0x190B]={
  category="lo",
  description="LIMBU LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190B,
 },
 [0x190C]={
  category="lo",
  description="LIMBU LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190C,
 },
 [0x190D]={
  category="lo",
  description="LIMBU LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190D,
 },
 [0x190E]={
  category="lo",
  description="LIMBU LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190E,
 },
 [0x190F]={
  category="lo",
  description="LIMBU LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190F,
 },
 [0x1910]={
  category="lo",
  description="LIMBU LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1910,
 },
 [0x1911]={
  category="lo",
  description="LIMBU LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1911,
 },
 [0x1912]={
  category="lo",
  description="LIMBU LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1912,
 },
 [0x1913]={
  category="lo",
  description="LIMBU LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1913,
 },
 [0x1914]={
  category="lo",
  description="LIMBU LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1914,
 },
 [0x1915]={
  category="lo",
  description="LIMBU LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1915,
 },
 [0x1916]={
  category="lo",
  description="LIMBU LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1916,
 },
 [0x1917]={
  category="lo",
  description="LIMBU LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1917,
 },
 [0x1918]={
  category="lo",
  description="LIMBU LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1918,
 },
 [0x1919]={
  category="lo",
  description="LIMBU LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1919,
 },
 [0x191A]={
  category="lo",
  description="LIMBU LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x191A,
 },
 [0x191B]={
  category="lo",
  description="LIMBU LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x191B,
 },
 [0x191C]={
  category="lo",
  description="LIMBU LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x191C,
 },
 [0x191D]={
  category="lo",
  description="LIMBU LETTER GYAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x191D,
 },
 [0x191E]={
  category="lo",
  description="LIMBU LETTER TRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x191E,
 },
 [0x1920]={
  category="mn",
  description="LIMBU VOWEL SIGN A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1920,
 },
 [0x1921]={
  category="mn",
  description="LIMBU VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1921,
 },
 [0x1922]={
  category="mn",
  description="LIMBU VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1922,
 },
 [0x1923]={
  category="mc",
  description="LIMBU VOWEL SIGN EE",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1923,
 },
 [0x1924]={
  category="mc",
  description="LIMBU VOWEL SIGN AI",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1924,
 },
 [0x1925]={
  category="mc",
  description="LIMBU VOWEL SIGN OO",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1925,
 },
 [0x1926]={
  category="mc",
  description="LIMBU VOWEL SIGN AU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1926,
 },
 [0x1927]={
  category="mn",
  description="LIMBU VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1927,
 },
 [0x1928]={
  category="mn",
  description="LIMBU VOWEL SIGN O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1928,
 },
 [0x1929]={
  category="mc",
  description="LIMBU SUBJOINED LETTER YA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1929,
 },
 [0x192A]={
  category="mc",
  description="LIMBU SUBJOINED LETTER RA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x192A,
 },
 [0x192B]={
  category="mc",
  description="LIMBU SUBJOINED LETTER WA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x192B,
 },
 [0x1930]={
  category="mc",
  description="LIMBU SMALL LETTER KA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1930,
 },
 [0x1931]={
  category="mc",
  description="LIMBU SMALL LETTER NGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1931,
 },
 [0x1932]={
  category="mn",
  description="LIMBU SMALL LETTER ANUSVARA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1932,
 },
 [0x1933]={
  category="mc",
  description="LIMBU SMALL LETTER TA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1933,
 },
 [0x1934]={
  category="mc",
  description="LIMBU SMALL LETTER NA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1934,
 },
 [0x1935]={
  category="mc",
  description="LIMBU SMALL LETTER PA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1935,
 },
 [0x1936]={
  category="mc",
  description="LIMBU SMALL LETTER MA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1936,
 },
 [0x1937]={
  category="mc",
  description="LIMBU SMALL LETTER RA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1937,
 },
 [0x1938]={
  category="mc",
  description="LIMBU SMALL LETTER LA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1938,
 },
 [0x1939]={
  category="mn",
  combining=0xDE,
  description="LIMBU SIGN MUKPHRENG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1939,
 },
 [0x193A]={
  category="mn",
  combining=0xE6,
  description="LIMBU SIGN KEMPHRENG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x193A,
 },
 [0x193B]={
  category="mn",
  combining=0xDC,
  description="LIMBU SIGN SA-I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x193B,
 },
 [0x1940]={
  category="so",
  description="LIMBU SIGN LOO",
  direction="on",
  linebreak="al",
  unicodeslot=0x1940,
 },
 [0x1944]={
  category="po",
  description="LIMBU EXCLAMATION MARK",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1944,
 },
 [0x1945]={
  category="po",
  description="LIMBU QUESTION MARK",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1945,
 },
 [0x1946]={
  category="nd",
  description="LIMBU DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1946,
 },
 [0x1947]={
  category="nd",
  description="LIMBU DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1947,
 },
 [0x1948]={
  category="nd",
  description="LIMBU DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1948,
 },
 [0x1949]={
  category="nd",
  description="LIMBU DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1949,
 },
 [0x194A]={
  category="nd",
  description="LIMBU DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194A,
 },
 [0x194B]={
  category="nd",
  description="LIMBU DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194B,
 },
 [0x194C]={
  category="nd",
  description="LIMBU DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194C,
 },
 [0x194D]={
  category="nd",
  description="LIMBU DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194D,
 },
 [0x194E]={
  category="nd",
  description="LIMBU DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194E,
 },
 [0x194F]={
  category="nd",
  description="LIMBU DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194F,
 },
 [0x1950]={
  category="lo",
  description="TAI LE LETTER KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1950,
 },
 [0x1951]={
  category="lo",
  description="TAI LE LETTER XA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1951,
 },
 [0x1952]={
  category="lo",
  description="TAI LE LETTER NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1952,
 },
 [0x1953]={
  category="lo",
  description="TAI LE LETTER TSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1953,
 },
 [0x1954]={
  category="lo",
  description="TAI LE LETTER SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1954,
 },
 [0x1955]={
  category="lo",
  description="TAI LE LETTER YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1955,
 },
 [0x1956]={
  category="lo",
  description="TAI LE LETTER TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1956,
 },
 [0x1957]={
  category="lo",
  description="TAI LE LETTER THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1957,
 },
 [0x1958]={
  category="lo",
  description="TAI LE LETTER LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1958,
 },
 [0x1959]={
  category="lo",
  description="TAI LE LETTER PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1959,
 },
 [0x195A]={
  category="lo",
  description="TAI LE LETTER PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195A,
 },
 [0x195B]={
  category="lo",
  description="TAI LE LETTER MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195B,
 },
 [0x195C]={
  category="lo",
  description="TAI LE LETTER FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195C,
 },
 [0x195D]={
  category="lo",
  description="TAI LE LETTER VA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195D,
 },
 [0x195E]={
  category="lo",
  description="TAI LE LETTER HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195E,
 },
 [0x195F]={
  category="lo",
  description="TAI LE LETTER QA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195F,
 },
 [0x1960]={
  category="lo",
  description="TAI LE LETTER KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1960,
 },
 [0x1961]={
  category="lo",
  description="TAI LE LETTER TSHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1961,
 },
 [0x1962]={
  category="lo",
  description="TAI LE LETTER NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1962,
 },
 [0x1963]={
  category="lo",
  description="TAI LE LETTER A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1963,
 },
 [0x1964]={
  category="lo",
  description="TAI LE LETTER I",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1964,
 },
 [0x1965]={
  category="lo",
  description="TAI LE LETTER EE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1965,
 },
 [0x1966]={
  category="lo",
  description="TAI LE LETTER EH",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1966,
 },
 [0x1967]={
  category="lo",
  description="TAI LE LETTER U",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1967,
 },
 [0x1968]={
  category="lo",
  description="TAI LE LETTER OO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1968,
 },
 [0x1969]={
  category="lo",
  description="TAI LE LETTER O",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1969,
 },
 [0x196A]={
  category="lo",
  description="TAI LE LETTER UE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x196A,
 },
 [0x196B]={
  category="lo",
  description="TAI LE LETTER E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x196B,
 },
 [0x196C]={
  category="lo",
  description="TAI LE LETTER AUE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x196C,
 },
 [0x196D]={
  category="lo",
  description="TAI LE LETTER AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x196D,
 },
 [0x1970]={
  category="lo",
  description="TAI LE LETTER TONE-0x0002",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1970,
 },
 [0x1971]={
  category="lo",
  description="TAI LE LETTER TONE-0x0003",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1971,
 },
 [0x1972]={
  category="lo",
  description="TAI LE LETTER TONE-0x0004",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1972,
 },
 [0x1973]={
  category="lo",
  description="TAI LE LETTER TONE-0x0005",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1973,
 },
 [0x1974]={
  category="lo",
  description="TAI LE LETTER TONE-0x0006",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1974,
 },
 [0x1980]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH QA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1980,
 },
 [0x1981]={
  category="lo",
  description="NEW TAI LUE LETTER LOW QA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1981,
 },
 [0x1982]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1982,
 },
 [0x1983]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH XA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1983,
 },
 [0x1984]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1984,
 },
 [0x1985]={
  category="lo",
  description="NEW TAI LUE LETTER LOW KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1985,
 },
 [0x1986]={
  category="lo",
  description="NEW TAI LUE LETTER LOW XA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1986,
 },
 [0x1987]={
  category="lo",
  description="NEW TAI LUE LETTER LOW NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1987,
 },
 [0x1988]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH TSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1988,
 },
 [0x1989]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1989,
 },
 [0x198A]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198A,
 },
 [0x198B]={
  category="lo",
  description="NEW TAI LUE LETTER LOW TSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198B,
 },
 [0x198C]={
  category="lo",
  description="NEW TAI LUE LETTER LOW SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198C,
 },
 [0x198D]={
  category="lo",
  description="NEW TAI LUE LETTER LOW YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198D,
 },
 [0x198E]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198E,
 },
 [0x198F]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198F,
 },
 [0x1990]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1990,
 },
 [0x1991]={
  category="lo",
  description="NEW TAI LUE LETTER LOW TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1991,
 },
 [0x1992]={
  category="lo",
  description="NEW TAI LUE LETTER LOW THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1992,
 },
 [0x1993]={
  category="lo",
  description="NEW TAI LUE LETTER LOW NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1993,
 },
 [0x1994]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1994,
 },
 [0x1995]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1995,
 },
 [0x1996]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1996,
 },
 [0x1997]={
  category="lo",
  description="NEW TAI LUE LETTER LOW PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1997,
 },
 [0x1998]={
  category="lo",
  description="NEW TAI LUE LETTER LOW PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1998,
 },
 [0x1999]={
  category="lo",
  description="NEW TAI LUE LETTER LOW MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1999,
 },
 [0x199A]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199A,
 },
 [0x199B]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH VA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199B,
 },
 [0x199C]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199C,
 },
 [0x199D]={
  category="lo",
  description="NEW TAI LUE LETTER LOW FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199D,
 },
 [0x199E]={
  category="lo",
  description="NEW TAI LUE LETTER LOW VA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199E,
 },
 [0x199F]={
  category="lo",
  description="NEW TAI LUE LETTER LOW LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199F,
 },
 [0x19A0]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A0,
 },
 [0x19A1]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A1,
 },
 [0x19A2]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A2,
 },
 [0x19A3]={
  category="lo",
  description="NEW TAI LUE LETTER LOW HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A3,
 },
 [0x19A4]={
  category="lo",
  description="NEW TAI LUE LETTER LOW DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A4,
 },
 [0x19A5]={
  category="lo",
  description="NEW TAI LUE LETTER LOW BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A5,
 },
 [0x19A6]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH KVA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A6,
 },
 [0x19A7]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH XVA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A7,
 },
 [0x19A8]={
  category="lo",
  description="NEW TAI LUE LETTER LOW KVA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A8,
 },
 [0x19A9]={
  category="lo",
  description="NEW TAI LUE LETTER LOW XVA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A9,
 },
 [0x19AA]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH SUA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19AA,
 },
 [0x19AB]={
  category="lo",
  description="NEW TAI LUE LETTER LOW SUA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19AB,
 },
 [0x19B0]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN VOWEL SHORTENER",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B0,
 },
 [0x19B1]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B1,
 },
 [0x19B2]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN II",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B2,
 },
 [0x19B3]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN U",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B3,
 },
 [0x19B4]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN UU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B4,
 },
 [0x19B5]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B5,
 },
 [0x19B6]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN AE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B6,
 },
 [0x19B7]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN O",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B7,
 },
 [0x19B8]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN OA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B8,
 },
 [0x19B9]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN UE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B9,
 },
 [0x19BA]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN AY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BA,
 },
 [0x19BB]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN AAY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BB,
 },
 [0x19BC]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN UY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BC,
 },
 [0x19BD]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN OY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BD,
 },
 [0x19BE]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN OAY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BE,
 },
 [0x19BF]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN UEY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BF,
 },
 [0x19C0]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN IY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C0,
 },
 [0x19C1]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL V",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C1,
 },
 [0x19C2]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL NG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C2,
 },
 [0x19C3]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL N",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C3,
 },
 [0x19C4]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL M",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C4,
 },
 [0x19C5]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL K",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C5,
 },
 [0x19C6]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL D",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C6,
 },
 [0x19C7]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL B",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C7,
 },
 [0x19C8]={
  category="mc",
  description="NEW TAI LUE TONE MARK-0x0001",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C8,
 },
 [0x19C9]={
  category="mc",
  description="NEW TAI LUE TONE MARK-0x0002",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C9,
 },
 [0x19D0]={
  category="nd",
  description="NEW TAI LUE DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D0,
 },
 [0x19D1]={
  category="nd",
  description="NEW TAI LUE DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D1,
 },
 [0x19D2]={
  category="nd",
  description="NEW TAI LUE DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D2,
 },
 [0x19D3]={
  category="nd",
  description="NEW TAI LUE DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D3,
 },
 [0x19D4]={
  category="nd",
  description="NEW TAI LUE DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D4,
 },
 [0x19D5]={
  category="nd",
  description="NEW TAI LUE DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D5,
 },
 [0x19D6]={
  category="nd",
  description="NEW TAI LUE DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D6,
 },
 [0x19D7]={
  category="nd",
  description="NEW TAI LUE DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D7,
 },
 [0x19D8]={
  category="nd",
  description="NEW TAI LUE DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D8,
 },
 [0x19D9]={
  category="nd",
  description="NEW TAI LUE DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D9,
 },
 [0x19DA]={
  category="no",
  description="NEW TAI LUE THAM DIGIT ONE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19DA,
 },
 [0x19DE]={
  category="po",
  description="NEW TAI LUE SIGN LAE",
  direction="on",
  linebreak="sa",
  unicodeslot=0x19DE,
 },
 [0x19DF]={
  category="po",
  description="NEW TAI LUE SIGN LAEV",
  direction="on",
  linebreak="sa",
  unicodeslot=0x19DF,
 },
 [0x19E0]={
  category="so",
  description="KHMER SYMBOL PATHAMASAT",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E0,
 },
 [0x19E1]={
  category="so",
  description="KHMER SYMBOL MUOY KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E1,
 },
 [0x19E2]={
  category="so",
  description="KHMER SYMBOL PII KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E2,
 },
 [0x19E3]={
  category="so",
  description="KHMER SYMBOL BEI KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E3,
 },
 [0x19E4]={
  category="so",
  description="KHMER SYMBOL BUON KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E4,
 },
 [0x19E5]={
  category="so",
  description="KHMER SYMBOL PRAM KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E5,
 },
 [0x19E6]={
  category="so",
  description="KHMER SYMBOL PRAM-MUOY KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E6,
 },
 [0x19E7]={
  category="so",
  description="KHMER SYMBOL PRAM-PII KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E7,
 },
 [0x19E8]={
  category="so",
  description="KHMER SYMBOL PRAM-BEI KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E8,
 },
 [0x19E9]={
  category="so",
  description="KHMER SYMBOL PRAM-BUON KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E9,
 },
 [0x19EA]={
  category="so",
  description="KHMER SYMBOL DAP KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EA,
 },
 [0x19EB]={
  category="so",
  description="KHMER SYMBOL DAP-MUOY KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EB,
 },
 [0x19EC]={
  category="so",
  description="KHMER SYMBOL DAP-PII KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EC,
 },
 [0x19ED]={
  category="so",
  description="KHMER SYMBOL DAP-BEI KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19ED,
 },
 [0x19EE]={
  category="so",
  description="KHMER SYMBOL DAP-BUON KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EE,
 },
 [0x19EF]={
  category="so",
  description="KHMER SYMBOL DAP-PRAM KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EF,
 },
 [0x19F0]={
  category="so",
  description="KHMER SYMBOL TUTEYASAT",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F0,
 },
 [0x19F1]={
  category="so",
  description="KHMER SYMBOL MUOY ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F1,
 },
 [0x19F2]={
  category="so",
  description="KHMER SYMBOL PII ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F2,
 },
 [0x19F3]={
  category="so",
  description="KHMER SYMBOL BEI ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F3,
 },
 [0x19F4]={
  category="so",
  description="KHMER SYMBOL BUON ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F4,
 },
 [0x19F5]={
  category="so",
  description="KHMER SYMBOL PRAM ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F5,
 },
 [0x19F6]={
  category="so",
  description="KHMER SYMBOL PRAM-MUOY ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F6,
 },
 [0x19F7]={
  category="so",
  description="KHMER SYMBOL PRAM-PII ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F7,
 },
 [0x19F8]={
  category="so",
  description="KHMER SYMBOL PRAM-BEI ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F8,
 },
 [0x19F9]={
  category="so",
  description="KHMER SYMBOL PRAM-BUON ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F9,
 },
 [0x19FA]={
  category="so",
  description="KHMER SYMBOL DAP ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FA,
 },
 [0x19FB]={
  category="so",
  description="KHMER SYMBOL DAP-MUOY ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FB,
 },
 [0x19FC]={
  category="so",
  description="KHMER SYMBOL DAP-PII ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FC,
 },
 [0x19FD]={
  category="so",
  description="KHMER SYMBOL DAP-BEI ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FD,
 },
 [0x19FE]={
  category="so",
  description="KHMER SYMBOL DAP-BUON ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FE,
 },
 [0x19FF]={
  category="so",
  description="KHMER SYMBOL DAP-PRAM ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FF,
 },
 [0x1A00]={
  category="lo",
  description="BUGINESE LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A00,
 },
 [0x1A01]={
  category="lo",
  description="BUGINESE LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A01,
 },
 [0x1A02]={
  category="lo",
  description="BUGINESE LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A02,
 },
 [0x1A03]={
  category="lo",
  description="BUGINESE LETTER NGKA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A03,
 },
 [0x1A04]={
  category="lo",
  description="BUGINESE LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A04,
 },
 [0x1A05]={
  category="lo",
  description="BUGINESE LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A05,
 },
 [0x1A06]={
  category="lo",
  description="BUGINESE LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A06,
 },
 [0x1A07]={
  category="lo",
  description="BUGINESE LETTER MPA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A07,
 },
 [0x1A08]={
  category="lo",
  description="BUGINESE LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A08,
 },
 [0x1A09]={
  category="lo",
  description="BUGINESE LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A09,
 },
 [0x1A0A]={
  category="lo",
  description="BUGINESE LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0A,
 },
 [0x1A0B]={
  category="lo",
  description="BUGINESE LETTER NRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0B,
 },
 [0x1A0C]={
  category="lo",
  description="BUGINESE LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0C,
 },
 [0x1A0D]={
  category="lo",
  description="BUGINESE LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0D,
 },
 [0x1A0E]={
  category="lo",
  description="BUGINESE LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0E,
 },
 [0x1A0F]={
  category="lo",
  description="BUGINESE LETTER NYCA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0F,
 },
 [0x1A10]={
  category="lo",
  description="BUGINESE LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A10,
 },
 [0x1A11]={
  category="lo",
  description="BUGINESE LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A11,
 },
 [0x1A12]={
  category="lo",
  description="BUGINESE LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A12,
 },
 [0x1A13]={
  category="lo",
  description="BUGINESE LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A13,
 },
 [0x1A14]={
  category="lo",
  description="BUGINESE LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A14,
 },
 [0x1A15]={
  category="lo",
  description="BUGINESE LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A15,
 },
 [0x1A16]={
  category="lo",
  description="BUGINESE LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A16,
 },
 [0x1A17]={
  category="mn",
  combining=0xE6,
  description="BUGINESE VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1A17,
 },
 [0x1A18]={
  category="mn",
  combining=0xDC,
  description="BUGINESE VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1A18,
 },
 [0x1A19]={
  category="mc",
  description="BUGINESE VOWEL SIGN E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1A19,
 },
 [0x1A1A]={
  category="mc",
  description="BUGINESE VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1A1A,
 },
 [0x1A1B]={
  category="mc",
  description="BUGINESE VOWEL SIGN AE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1A1B,
 },
 [0x1A1E]={
  category="po",
  description="BUGINESE PALLAWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A1E,
 },
 [0x1A1F]={
  category="po",
  description="BUGINESE END OF SECTION",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A1F,
 },
 [0x1A20]={
  category="lo",
  description="TAI THAM LETTER HIGH KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A20,
 },
 [0x1A21]={
  category="lo",
  description="TAI THAM LETTER HIGH KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A21,
 },
 [0x1A22]={
  category="lo",
  description="TAI THAM LETTER HIGH KXA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A22,
 },
 [0x1A23]={
  category="lo",
  description="TAI THAM LETTER LOW KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A23,
 },
 [0x1A24]={
  category="lo",
  description="TAI THAM LETTER LOW KXA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A24,
 },
 [0x1A25]={
  category="lo",
  description="TAI THAM LETTER LOW KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A25,
 },
 [0x1A26]={
  category="lo",
  description="TAI THAM LETTER NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A26,
 },
 [0x1A27]={
  category="lo",
  description="TAI THAM LETTER HIGH CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A27,
 },
 [0x1A28]={
  category="lo",
  description="TAI THAM LETTER HIGH CHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A28,
 },
 [0x1A29]={
  category="lo",
  description="TAI THAM LETTER LOW CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A29,
 },
 [0x1A2A]={
  category="lo",
  description="TAI THAM LETTER LOW SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2A,
 },
 [0x1A2B]={
  category="lo",
  description="TAI THAM LETTER LOW CHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2B,
 },
 [0x1A2C]={
  category="lo",
  description="TAI THAM LETTER NYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2C,
 },
 [0x1A2D]={
  category="lo",
  description="TAI THAM LETTER RATA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2D,
 },
 [0x1A2E]={
  category="lo",
  description="TAI THAM LETTER HIGH RATHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2E,
 },
 [0x1A2F]={
  category="lo",
  description="TAI THAM LETTER DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2F,
 },
 [0x1A30]={
  category="lo",
  description="TAI THAM LETTER LOW RATHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A30,
 },
 [0x1A31]={
  category="lo",
  description="TAI THAM LETTER RANA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A31,
 },
 [0x1A32]={
  category="lo",
  description="TAI THAM LETTER HIGH TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A32,
 },
 [0x1A33]={
  category="lo",
  description="TAI THAM LETTER HIGH THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A33,
 },
 [0x1A34]={
  category="lo",
  description="TAI THAM LETTER LOW TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A34,
 },
 [0x1A35]={
  category="lo",
  description="TAI THAM LETTER LOW THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A35,
 },
 [0x1A36]={
  category="lo",
  description="TAI THAM LETTER NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A36,
 },
 [0x1A37]={
  category="lo",
  description="TAI THAM LETTER BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A37,
 },
 [0x1A38]={
  category="lo",
  description="TAI THAM LETTER HIGH PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A38,
 },
 [0x1A39]={
  category="lo",
  description="TAI THAM LETTER HIGH PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A39,
 },
 [0x1A3A]={
  category="lo",
  description="TAI THAM LETTER HIGH FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3A,
 },
 [0x1A3B]={
  category="lo",
  description="TAI THAM LETTER LOW PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3B,
 },
 [0x1A3C]={
  category="lo",
  description="TAI THAM LETTER LOW FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3C,
 },
 [0x1A3D]={
  category="lo",
  description="TAI THAM LETTER LOW PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3D,
 },
 [0x1A3E]={
  category="lo",
  description="TAI THAM LETTER MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3E,
 },
 [0x1A3F]={
  category="lo",
  description="TAI THAM LETTER LOW YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3F,
 },
 [0x1A40]={
  category="lo",
  description="TAI THAM LETTER HIGH YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A40,
 },
 [0x1A41]={
  category="lo",
  description="TAI THAM LETTER RA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A41,
 },
 [0x1A42]={
  category="lo",
  description="TAI THAM LETTER RUE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A42,
 },
 [0x1A43]={
  category="lo",
  description="TAI THAM LETTER LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A43,
 },
 [0x1A44]={
  category="lo",
  description="TAI THAM LETTER LUE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A44,
 },
 [0x1A45]={
  category="lo",
  description="TAI THAM LETTER WA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A45,
 },
 [0x1A46]={
  category="lo",
  description="TAI THAM LETTER HIGH SHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A46,
 },
 [0x1A47]={
  category="lo",
  description="TAI THAM LETTER HIGH SSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A47,
 },
 [0x1A48]={
  category="lo",
  description="TAI THAM LETTER HIGH SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A48,
 },
 [0x1A49]={
  category="lo",
  description="TAI THAM LETTER HIGH HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A49,
 },
 [0x1A4A]={
  category="lo",
  description="TAI THAM LETTER LLA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4A,
 },
 [0x1A4B]={
  category="lo",
  description="TAI THAM LETTER A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4B,
 },
 [0x1A4C]={
  category="lo",
  description="TAI THAM LETTER LOW HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4C,
 },
 [0x1A4D]={
  category="lo",
  description="TAI THAM LETTER I",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4D,
 },
 [0x1A4E]={
  category="lo",
  description="TAI THAM LETTER II",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4E,
 },
 [0x1A4F]={
  category="lo",
  description="TAI THAM LETTER U",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4F,
 },
 [0x1A50]={
  category="lo",
  description="TAI THAM LETTER UU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A50,
 },
 [0x1A51]={
  category="lo",
  description="TAI THAM LETTER EE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A51,
 },
 [0x1A52]={
  category="lo",
  description="TAI THAM LETTER OO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A52,
 },
 [0x1A53]={
  category="lo",
  description="TAI THAM LETTER LAE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A53,
 },
 [0x1A54]={
  category="lo",
  description="TAI THAM LETTER GREAT SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A54,
 },
 [0x1A55]={
  category="mc",
  description="TAI THAM CONSONANT SIGN MEDIAL RA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A55,
 },
 [0x1A56]={
  category="mn",
  description="TAI THAM CONSONANT SIGN MEDIAL LA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A56,
 },
 [0x1A57]={
  category="mc",
  description="TAI THAM CONSONANT SIGN LA TANG LAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A57,
 },
 [0x1A58]={
  category="mn",
  description="TAI THAM SIGN MAI KANG LAI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A58,
 },
 [0x1A59]={
  category="mn",
  description="TAI THAM CONSONANT SIGN FINAL NGA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A59,
 },
 [0x1A5A]={
  category="mn",
  description="TAI THAM CONSONANT SIGN LOW PA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5A,
 },
 [0x1A5B]={
  category="mn",
  description="TAI THAM CONSONANT SIGN HIGH RATHA OR LOW PA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5B,
 },
 [0x1A5C]={
  category="mn",
  description="TAI THAM CONSONANT SIGN MA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5C,
 },
 [0x1A5D]={
  category="mn",
  description="TAI THAM CONSONANT SIGN BA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5D,
 },
 [0x1A5E]={
  category="mn",
  description="TAI THAM CONSONANT SIGN SA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5E,
 },
 [0x1A60]={
  category="mn",
  combining=0x9,
  description="TAI THAM SIGN SAKOT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A60,
 },
 [0x1A61]={
  category="mc",
  description="TAI THAM VOWEL SIGN A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A61,
 },
 [0x1A62]={
  category="mn",
  description="TAI THAM VOWEL SIGN MAI SAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A62,
 },
 [0x1A63]={
  category="mc",
  description="TAI THAM VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A63,
 },
 [0x1A64]={
  category="mc",
  description="TAI THAM VOWEL SIGN TALL AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A64,
 },
 [0x1A65]={
  category="mn",
  description="TAI THAM VOWEL SIGN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A65,
 },
 [0x1A66]={
  category="mn",
  description="TAI THAM VOWEL SIGN II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A66,
 },
 [0x1A67]={
  category="mn",
  description="TAI THAM VOWEL SIGN UE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A67,
 },
 [0x1A68]={
  category="mn",
  description="TAI THAM VOWEL SIGN UUE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A68,
 },
 [0x1A69]={
  category="mn",
  description="TAI THAM VOWEL SIGN U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A69,
 },
 [0x1A6A]={
  category="mn",
  description="TAI THAM VOWEL SIGN UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A6A,
 },
 [0x1A6B]={
  category="mn",
  description="TAI THAM VOWEL SIGN O",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A6B,
 },
 [0x1A6C]={
  category="mn",
  description="TAI THAM VOWEL SIGN OA BELOW",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A6C,
 },
 [0x1A6D]={
  category="mc",
  description="TAI THAM VOWEL SIGN OY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A6D,
 },
 [0x1A6E]={
  category="mc",
  description="TAI THAM VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A6E,
 },
 [0x1A6F]={
  category="mc",
  description="TAI THAM VOWEL SIGN AE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A6F,
 },
 [0x1A70]={
  category="mc",
  description="TAI THAM VOWEL SIGN OO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A70,
 },
 [0x1A71]={
  category="mc",
  description="TAI THAM VOWEL SIGN AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A71,
 },
 [0x1A72]={
  category="mc",
  description="TAI THAM VOWEL SIGN THAM AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A72,
 },
 [0x1A73]={
  category="mn",
  description="TAI THAM VOWEL SIGN OA ABOVE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A73,
 },
 [0x1A74]={
  category="mn",
  description="TAI THAM SIGN MAI KANG",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A74,
 },
 [0x1A75]={
  category="mn",
  combining=0xE6,
  description="TAI THAM SIGN TONE-1",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A75,
 },
 [0x1A76]={
  category="mn",
  combining=0xE6,
  description="TAI THAM SIGN TONE-2",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A76,
 },
 [0x1A77]={
  category="mn",
  combining=0xE6,
  description="TAI THAM SIGN KHUEN TONE-3",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A77,
 },
 [0x1A78]={
  category="mn",
  combining=0xE6,
  description="TAI THAM SIGN KHUEN TONE-4",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A78,
 },
 [0x1A79]={
  category="mn",
  combining=0xE6,
  description="TAI THAM SIGN KHUEN TONE-5",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A79,
 },
 [0x1A7A]={
  category="mn",
  combining=0xE6,
  description="TAI THAM SIGN RA HAAM",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A7A,
 },
 [0x1A7B]={
  category="mn",
  combining=0xE6,
  description="TAI THAM SIGN MAI SAM",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A7B,
 },
 [0x1A7C]={
  category="mn",
  combining=0xE6,
  description="TAI THAM SIGN KHUEN-LUE KARAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A7C,
 },
 [0x1A7F]={
  category="mn",
  combining=0xDC,
  description="TAI THAM COMBINING CRYPTOGRAMMIC DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1A7F,
 },
 [0x1A80]={
  category="nd",
  description="TAI THAM HORA DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A80,
 },
 [0x1A81]={
  category="nd",
  description="TAI THAM HORA DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A81,
 },
 [0x1A82]={
  category="nd",
  description="TAI THAM HORA DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A82,
 },
 [0x1A83]={
  category="nd",
  description="TAI THAM HORA DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A83,
 },
 [0x1A84]={
  category="nd",
  description="TAI THAM HORA DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A84,
 },
 [0x1A85]={
  category="nd",
  description="TAI THAM HORA DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A85,
 },
 [0x1A86]={
  category="nd",
  description="TAI THAM HORA DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A86,
 },
 [0x1A87]={
  category="nd",
  description="TAI THAM HORA DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A87,
 },
 [0x1A88]={
  category="nd",
  description="TAI THAM HORA DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A88,
 },
 [0x1A89]={
  category="nd",
  description="TAI THAM HORA DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A89,
 },
 [0x1A90]={
  category="nd",
  description="TAI THAM THAM DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A90,
 },
 [0x1A91]={
  category="nd",
  description="TAI THAM THAM DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A91,
 },
 [0x1A92]={
  category="nd",
  description="TAI THAM THAM DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A92,
 },
 [0x1A93]={
  category="nd",
  description="TAI THAM THAM DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A93,
 },
 [0x1A94]={
  category="nd",
  description="TAI THAM THAM DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A94,
 },
 [0x1A95]={
  category="nd",
  description="TAI THAM THAM DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A95,
 },
 [0x1A96]={
  category="nd",
  description="TAI THAM THAM DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A96,
 },
 [0x1A97]={
  category="nd",
  description="TAI THAM THAM DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A97,
 },
 [0x1A98]={
  category="nd",
  description="TAI THAM THAM DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A98,
 },
 [0x1A99]={
  category="nd",
  description="TAI THAM THAM DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A99,
 },
 [0x1AA0]={
  category="po",
  description="TAI THAM SIGN WIANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA0,
 },
 [0x1AA1]={
  category="po",
  description="TAI THAM SIGN WIANGWAAK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA1,
 },
 [0x1AA2]={
  category="po",
  description="TAI THAM SIGN SAWAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA2,
 },
 [0x1AA3]={
  category="po",
  description="TAI THAM SIGN KEOW",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA3,
 },
 [0x1AA4]={
  category="po",
  description="TAI THAM SIGN HOY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA4,
 },
 [0x1AA5]={
  category="po",
  description="TAI THAM SIGN DOKMAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA5,
 },
 [0x1AA6]={
  category="po",
  description="TAI THAM SIGN REVERSED ROTATED RANA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA6,
 },
 [0x1AA7]={
  category="lm",
  description="TAI THAM SIGN MAI YAMOK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA7,
 },
 [0x1AA8]={
  category="po",
  description="TAI THAM SIGN KAAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA8,
 },
 [0x1AA9]={
  category="po",
  description="TAI THAM SIGN KAANKUU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA9,
 },
 [0x1AAA]={
  category="po",
  description="TAI THAM SIGN SATKAAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AAA,
 },
 [0x1AAB]={
  category="po",
  description="TAI THAM SIGN SATKAANKUU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AAB,
 },
 [0x1AAC]={
  category="po",
  description="TAI THAM SIGN HANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AAC,
 },
 [0x1AAD]={
  category="po",
  description="TAI THAM SIGN CAANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AAD,
 },
 [0x1AB0]={
  category="mn",
  combining=0xE6,
  description="COMBINING DOUBLED CIRCUMFLEX ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB0,
 },
 [0x1AB1]={
  category="mn",
  combining=0xE6,
  description="COMBINING DIAERESIS-RING",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB1,
 },
 [0x1AB2]={
  category="mn",
  combining=0xE6,
  description="COMBINING INFINITY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB2,
 },
 [0x1AB3]={
  category="mn",
  combining=0xE6,
  description="COMBINING DOWNWARDS ARROW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB3,
 },
 [0x1AB4]={
  category="mn",
  combining=0xE6,
  description="COMBINING TRIPLE DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB4,
 },
 [0x1AB5]={
  category="mn",
  combining=0xDC,
  description="COMBINING X-X BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB5,
 },
 [0x1AB6]={
  category="mn",
  combining=0xDC,
  description="COMBINING WIGGLY LINE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB6,
 },
 [0x1AB7]={
  category="mn",
  combining=0xDC,
  description="COMBINING OPEN MARK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB7,
 },
 [0x1AB8]={
  category="mn",
  combining=0xDC,
  description="COMBINING DOUBLE OPEN MARK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB8,
 },
 [0x1AB9]={
  category="mn",
  combining=0xDC,
  description="COMBINING LIGHT CENTRALIZATION STROKE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1AB9,
 },
 [0x1ABA]={
  category="mn",
  combining=0xDC,
  description="COMBINING STRONG CENTRALIZATION STROKE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1ABA,
 },
 [0x1ABB]={
  category="mn",
  combining=0xE6,
  description="COMBINING PARENTHESES ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1ABB,
 },
 [0x1ABC]={
  category="mn",
  combining=0xE6,
  description="COMBINING DOUBLE PARENTHESES ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1ABC,
 },
 [0x1ABD]={
  category="mn",
  combining=0xDC,
  description="COMBINING PARENTHESES BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1ABD,
 },
 [0x1ABE]={
  category="me",
  description="COMBINING PARENTHESES OVERLAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1ABE,
 },
 [0x1B00]={
  category="mn",
  description="BALINESE SIGN ULU RICEM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B00,
 },
 [0x1B01]={
  category="mn",
  description="BALINESE SIGN ULU CANDRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B01,
 },
 [0x1B02]={
  category="mn",
  description="BALINESE SIGN CECEK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B02,
 },
 [0x1B03]={
  category="mn",
  description="BALINESE SIGN SURANG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B03,
 },
 [0x1B04]={
  category="mc",
  description="BALINESE SIGN BISAH",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B04,
 },
 [0x1B05]={
  category="lo",
  description="BALINESE LETTER AKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B05,
 },
 [0x1B06]={
  category="lo",
  description="BALINESE LETTER AKARA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B05, 0x1B35 },
  unicodeslot=0x1B06,
 },
 [0x1B07]={
  category="lo",
  description="BALINESE LETTER IKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B07,
 },
 [0x1B08]={
  category="lo",
  description="BALINESE LETTER IKARA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B07, 0x1B35 },
  unicodeslot=0x1B08,
 },
 [0x1B09]={
  category="lo",
  description="BALINESE LETTER UKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B09,
 },
 [0x1B0A]={
  category="lo",
  description="BALINESE LETTER UKARA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B09, 0x1B35 },
  unicodeslot=0x1B0A,
 },
 [0x1B0B]={
  category="lo",
  description="BALINESE LETTER RA REPA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B0B,
 },
 [0x1B0C]={
  category="lo",
  description="BALINESE LETTER RA REPA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B0B, 0x1B35 },
  unicodeslot=0x1B0C,
 },
 [0x1B0D]={
  category="lo",
  description="BALINESE LETTER LA LENGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B0D,
 },
 [0x1B0E]={
  category="lo",
  description="BALINESE LETTER LA LENGA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B0D, 0x1B35 },
  unicodeslot=0x1B0E,
 },
 [0x1B0F]={
  category="lo",
  description="BALINESE LETTER EKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B0F,
 },
 [0x1B10]={
  category="lo",
  description="BALINESE LETTER AIKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B10,
 },
 [0x1B11]={
  category="lo",
  description="BALINESE LETTER OKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B11,
 },
 [0x1B12]={
  category="lo",
  description="BALINESE LETTER OKARA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B11, 0x1B35 },
  unicodeslot=0x1B12,
 },
 [0x1B13]={
  category="lo",
  description="BALINESE LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B13,
 },
 [0x1B14]={
  category="lo",
  description="BALINESE LETTER KA MAHAPRANA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B14,
 },
 [0x1B15]={
  category="lo",
  description="BALINESE LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B15,
 },
 [0x1B16]={
  category="lo",
  description="BALINESE LETTER GA GORA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B16,
 },
 [0x1B17]={
  category="lo",
  description="BALINESE LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B17,
 },
 [0x1B18]={
  category="lo",
  description="BALINESE LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B18,
 },
 [0x1B19]={
  category="lo",
  description="BALINESE LETTER CA LACA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B19,
 },
 [0x1B1A]={
  category="lo",
  description="BALINESE LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1A,
 },
 [0x1B1B]={
  category="lo",
  description="BALINESE LETTER JA JERA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1B,
 },
 [0x1B1C]={
  category="lo",
  description="BALINESE LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1C,
 },
 [0x1B1D]={
  category="lo",
  description="BALINESE LETTER TA LATIK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1D,
 },
 [0x1B1E]={
  category="lo",
  description="BALINESE LETTER TA MURDA MAHAPRANA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1E,
 },
 [0x1B1F]={
  category="lo",
  description="BALINESE LETTER DA MURDA ALPAPRANA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1F,
 },
 [0x1B20]={
  category="lo",
  description="BALINESE LETTER DA MURDA MAHAPRANA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B20,
 },
 [0x1B21]={
  category="lo",
  description="BALINESE LETTER NA RAMBAT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B21,
 },
 [0x1B22]={
  category="lo",
  description="BALINESE LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B22,
 },
 [0x1B23]={
  category="lo",
  description="BALINESE LETTER TA TAWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B23,
 },
 [0x1B24]={
  category="lo",
  description="BALINESE LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B24,
 },
 [0x1B25]={
  category="lo",
  description="BALINESE LETTER DA MADU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B25,
 },
 [0x1B26]={
  category="lo",
  description="BALINESE LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B26,
 },
 [0x1B27]={
  category="lo",
  description="BALINESE LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B27,
 },
 [0x1B28]={
  category="lo",
  description="BALINESE LETTER PA KAPAL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B28,
 },
 [0x1B29]={
  category="lo",
  description="BALINESE LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B29,
 },
 [0x1B2A]={
  category="lo",
  description="BALINESE LETTER BA KEMBANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2A,
 },
 [0x1B2B]={
  category="lo",
  description="BALINESE LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2B,
 },
 [0x1B2C]={
  category="lo",
  description="BALINESE LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2C,
 },
 [0x1B2D]={
  category="lo",
  description="BALINESE LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2D,
 },
 [0x1B2E]={
  category="lo",
  description="BALINESE LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2E,
 },
 [0x1B2F]={
  category="lo",
  description="BALINESE LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2F,
 },
 [0x1B30]={
  category="lo",
  description="BALINESE LETTER SA SAGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B30,
 },
 [0x1B31]={
  category="lo",
  description="BALINESE LETTER SA SAPA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B31,
 },
 [0x1B32]={
  category="lo",
  description="BALINESE LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B32,
 },
 [0x1B33]={
  category="lo",
  description="BALINESE LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B33,
 },
 [0x1B34]={
  category="mn",
  combining=0x7,
  description="BALINESE SIGN REREKAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B34,
 },
 [0x1B35]={
  category="mc",
  description="BALINESE VOWEL SIGN TEDUNG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B35,
 },
 [0x1B36]={
  category="mn",
  description="BALINESE VOWEL SIGN ULU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B36,
 },
 [0x1B37]={
  category="mn",
  description="BALINESE VOWEL SIGN ULU SARI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B37,
 },
 [0x1B38]={
  category="mn",
  description="BALINESE VOWEL SIGN SUKU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B38,
 },
 [0x1B39]={
  category="mn",
  description="BALINESE VOWEL SIGN SUKU ILUT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B39,
 },
 [0x1B3A]={
  category="mn",
  description="BALINESE VOWEL SIGN RA REPA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B3A,
 },
 [0x1B3B]={
  category="mc",
  description="BALINESE VOWEL SIGN RA REPA TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B3A, 0x1B35 },
  unicodeslot=0x1B3B,
 },
 [0x1B3C]={
  category="mn",
  description="BALINESE VOWEL SIGN LA LENGA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B3C,
 },
 [0x1B3D]={
  category="mc",
  description="BALINESE VOWEL SIGN LA LENGA TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B3C, 0x1B35 },
  unicodeslot=0x1B3D,
 },
 [0x1B3E]={
  category="mc",
  description="BALINESE VOWEL SIGN TALING",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B3E,
 },
 [0x1B3F]={
  category="mc",
  description="BALINESE VOWEL SIGN TALING REPA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B3F,
 },
 [0x1B40]={
  category="mc",
  description="BALINESE VOWEL SIGN TALING TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B3E, 0x1B35 },
  unicodeslot=0x1B40,
 },
 [0x1B41]={
  category="mc",
  description="BALINESE VOWEL SIGN TALING REPA TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B3F, 0x1B35 },
  unicodeslot=0x1B41,
 },
 [0x1B42]={
  category="mn",
  description="BALINESE VOWEL SIGN PEPET",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B42,
 },
 [0x1B43]={
  category="mc",
  description="BALINESE VOWEL SIGN PEPET TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B42, 0x1B35 },
  unicodeslot=0x1B43,
 },
 [0x1B44]={
  category="mc",
  combining=0x9,
  description="BALINESE ADEG ADEG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B44,
 },
 [0x1B45]={
  category="lo",
  description="BALINESE LETTER KAF SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B45,
 },
 [0x1B46]={
  category="lo",
  description="BALINESE LETTER KHOT SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B46,
 },
 [0x1B47]={
  category="lo",
  description="BALINESE LETTER TZIR SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B47,
 },
 [0x1B48]={
  category="lo",
  description="BALINESE LETTER EF SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B48,
 },
 [0x1B49]={
  category="lo",
  description="BALINESE LETTER VE SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B49,
 },
 [0x1B4A]={
  category="lo",
  description="BALINESE LETTER ZAL SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B4A,
 },
 [0x1B4B]={
  category="lo",
  description="BALINESE LETTER ASYURA SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B4B,
 },
 [0x1B50]={
  category="nd",
  description="BALINESE DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B50,
 },
 [0x1B51]={
  category="nd",
  description="BALINESE DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B51,
 },
 [0x1B52]={
  category="nd",
  description="BALINESE DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B52,
 },
 [0x1B53]={
  category="nd",
  description="BALINESE DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B53,
 },
 [0x1B54]={
  category="nd",
  description="BALINESE DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B54,
 },
 [0x1B55]={
  category="nd",
  description="BALINESE DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B55,
 },
 [0x1B56]={
  category="nd",
  description="BALINESE DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B56,
 },
 [0x1B57]={
  category="nd",
  description="BALINESE DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B57,
 },
 [0x1B58]={
  category="nd",
  description="BALINESE DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B58,
 },
 [0x1B59]={
  category="nd",
  description="BALINESE DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B59,
 },
 [0x1B5A]={
  category="po",
  description="BALINESE PANTI",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5A,
 },
 [0x1B5B]={
  category="po",
  description="BALINESE PAMADA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5B,
 },
 [0x1B5C]={
  category="po",
  description="BALINESE WINDU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B5C,
 },
 [0x1B5D]={
  category="po",
  description="BALINESE CARIK PAMUNGKAH",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5D,
 },
 [0x1B5E]={
  category="po",
  description="BALINESE CARIK SIKI",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5E,
 },
 [0x1B5F]={
  category="po",
  description="BALINESE CARIK PAREREN",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5F,
 },
 [0x1B60]={
  category="po",
  description="BALINESE PAMENENG",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B60,
 },
 [0x1B61]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DONG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B61,
 },
 [0x1B62]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DENG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B62,
 },
 [0x1B63]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DUNG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B63,
 },
 [0x1B64]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B64,
 },
 [0x1B65]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DANG SURANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B65,
 },
 [0x1B66]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B66,
 },
 [0x1B67]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DAENG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B67,
 },
 [0x1B68]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DEUNG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B68,
 },
 [0x1B69]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DAING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B69,
 },
 [0x1B6A]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DANG GEDE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B6A,
 },
 [0x1B6B]={
  category="mn",
  combining=0xE6,
  description="BALINESE MUSICAL SYMBOL COMBINING TEGEH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6B,
 },
 [0x1B6C]={
  category="mn",
  combining=0xDC,
  description="BALINESE MUSICAL SYMBOL COMBINING ENDEP",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6C,
 },
 [0x1B6D]={
  category="mn",
  combining=0xE6,
  description="BALINESE MUSICAL SYMBOL COMBINING KEMPUL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6D,
 },
 [0x1B6E]={
  category="mn",
  combining=0xE6,
  description="BALINESE MUSICAL SYMBOL COMBINING KEMPLI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6E,
 },
 [0x1B6F]={
  category="mn",
  combining=0xE6,
  description="BALINESE MUSICAL SYMBOL COMBINING JEGOGAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6F,
 },
 [0x1B70]={
  category="mn",
  combining=0xE6,
  description="BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B70,
 },
 [0x1B71]={
  category="mn",
  combining=0xE6,
  description="BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B71,
 },
 [0x1B72]={
  category="mn",
  combining=0xE6,
  description="BALINESE MUSICAL SYMBOL COMBINING BENDE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B72,
 },
 [0x1B73]={
  category="mn",
  combining=0xE6,
  description="BALINESE MUSICAL SYMBOL COMBINING GONG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B73,
 },
 [0x1B74]={
  category="so",
  description="BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B74,
 },
 [0x1B75]={
  category="so",
  description="BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B75,
 },
 [0x1B76]={
  category="so",
  description="BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B76,
 },
 [0x1B77]={
  category="so",
  description="BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B77,
 },
 [0x1B78]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B78,
 },
 [0x1B79]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B79,
 },
 [0x1B7A]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B7A,
 },
 [0x1B7B]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B7B,
 },
 [0x1B7C]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B7C,
 },
 [0x1B80]={
  category="mn",
  description="SUNDANESE SIGN PANYECEK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B80,
 },
 [0x1B81]={
  category="mn",
  description="SUNDANESE SIGN PANGLAYAR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B81,
 },
 [0x1B82]={
  category="mc",
  description="SUNDANESE SIGN PANGWISAD",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B82,
 },
 [0x1B83]={
  category="lo",
  description="SUNDANESE LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B83,
 },
 [0x1B84]={
  category="lo",
  description="SUNDANESE LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B84,
 },
 [0x1B85]={
  category="lo",
  description="SUNDANESE LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B85,
 },
 [0x1B86]={
  category="lo",
  description="SUNDANESE LETTER AE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B86,
 },
 [0x1B87]={
  category="lo",
  description="SUNDANESE LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B87,
 },
 [0x1B88]={
  category="lo",
  description="SUNDANESE LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B88,
 },
 [0x1B89]={
  category="lo",
  description="SUNDANESE LETTER EU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B89,
 },
 [0x1B8A]={
  category="lo",
  description="SUNDANESE LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8A,
 },
 [0x1B8B]={
  category="lo",
  description="SUNDANESE LETTER QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8B,
 },
 [0x1B8C]={
  category="lo",
  description="SUNDANESE LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8C,
 },
 [0x1B8D]={
  category="lo",
  description="SUNDANESE LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8D,
 },
 [0x1B8E]={
  category="lo",
  description="SUNDANESE LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8E,
 },
 [0x1B8F]={
  category="lo",
  description="SUNDANESE LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8F,
 },
 [0x1B90]={
  category="lo",
  description="SUNDANESE LETTER ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B90,
 },
 [0x1B91]={
  category="lo",
  description="SUNDANESE LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B91,
 },
 [0x1B92]={
  category="lo",
  description="SUNDANESE LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B92,
 },
 [0x1B93]={
  category="lo",
  description="SUNDANESE LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B93,
 },
 [0x1B94]={
  category="lo",
  description="SUNDANESE LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B94,
 },
 [0x1B95]={
  category="lo",
  description="SUNDANESE LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B95,
 },
 [0x1B96]={
  category="lo",
  description="SUNDANESE LETTER FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B96,
 },
 [0x1B97]={
  category="lo",
  description="SUNDANESE LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B97,
 },
 [0x1B98]={
  category="lo",
  description="SUNDANESE LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B98,
 },
 [0x1B99]={
  category="lo",
  description="SUNDANESE LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B99,
 },
 [0x1B9A]={
  category="lo",
  description="SUNDANESE LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9A,
 },
 [0x1B9B]={
  category="lo",
  description="SUNDANESE LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9B,
 },
 [0x1B9C]={
  category="lo",
  description="SUNDANESE LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9C,
 },
 [0x1B9D]={
  category="lo",
  description="SUNDANESE LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9D,
 },
 [0x1B9E]={
  category="lo",
  description="SUNDANESE LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9E,
 },
 [0x1B9F]={
  category="lo",
  description="SUNDANESE LETTER XA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9F,
 },
 [0x1BA0]={
  category="lo",
  description="SUNDANESE LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BA0,
 },
 [0x1BA1]={
  category="mc",
  description="SUNDANESE CONSONANT SIGN PAMINGKAL",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BA1,
 },
 [0x1BA2]={
  category="mn",
  description="SUNDANESE CONSONANT SIGN PANYAKRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA2,
 },
 [0x1BA3]={
  category="mn",
  description="SUNDANESE CONSONANT SIGN PANYIKU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA3,
 },
 [0x1BA4]={
  category="mn",
  description="SUNDANESE VOWEL SIGN PANGHULU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA4,
 },
 [0x1BA5]={
  category="mn",
  description="SUNDANESE VOWEL SIGN PANYUKU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA5,
 },
 [0x1BA6]={
  category="mc",
  description="SUNDANESE VOWEL SIGN PANAELAENG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BA6,
 },
 [0x1BA7]={
  category="mc",
  description="SUNDANESE VOWEL SIGN PANOLONG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BA7,
 },
 [0x1BA8]={
  category="mn",
  description="SUNDANESE VOWEL SIGN PAMEPET",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA8,
 },
 [0x1BA9]={
  category="mn",
  description="SUNDANESE VOWEL SIGN PANEULEUNG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA9,
 },
 [0x1BAA]={
  category="mc",
  combining=0x9,
  description="SUNDANESE SIGN PAMAAEH",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BAA,
 },
 [0x1BAB]={
  category="mn",
  combining=0x9,
  description="SUNDANESE SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BAB,
 },
 [0x1BAC]={
  category="mc",
  description="SUNDANESE CONSONANT SIGN PASANGAN MA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BAC,
 },
 [0x1BAD]={
  category="mc",
  description="SUNDANESE CONSONANT SIGN PASANGAN WA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BAD,
 },
 [0x1BAE]={
  category="lo",
  description="SUNDANESE LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BAE,
 },
 [0x1BAF]={
  category="lo",
  description="SUNDANESE LETTER SYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BAF,
 },
 [0x1BB0]={
  category="nd",
  description="SUNDANESE DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB0,
 },
 [0x1BB1]={
  category="nd",
  description="SUNDANESE DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB1,
 },
 [0x1BB2]={
  category="nd",
  description="SUNDANESE DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB2,
 },
 [0x1BB3]={
  category="nd",
  description="SUNDANESE DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB3,
 },
 [0x1BB4]={
  category="nd",
  description="SUNDANESE DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB4,
 },
 [0x1BB5]={
  category="nd",
  description="SUNDANESE DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB5,
 },
 [0x1BB6]={
  category="nd",
  description="SUNDANESE DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB6,
 },
 [0x1BB7]={
  category="nd",
  description="SUNDANESE DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB7,
 },
 [0x1BB8]={
  category="nd",
  description="SUNDANESE DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB8,
 },
 [0x1BB9]={
  category="nd",
  description="SUNDANESE DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB9,
 },
 [0x1BBA]={
  category="lo",
  description="SUNDANESE AVAGRAHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BBA,
 },
 [0x1BBB]={
  category="lo",
  description="SUNDANESE LETTER REU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BBB,
 },
 [0x1BBC]={
  category="lo",
  description="SUNDANESE LETTER LEU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BBC,
 },
 [0x1BBD]={
  category="lo",
  description="SUNDANESE LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BBD,
 },
 [0x1BBE]={
  category="lo",
  description="SUNDANESE LETTER FINAL K",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BBE,
 },
 [0x1BBF]={
  category="lo",
  description="SUNDANESE LETTER FINAL M",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BBF,
 },
 [0x1BC0]={
  category="lo",
  description="BATAK LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC0,
 },
 [0x1BC1]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC1,
 },
 [0x1BC2]={
  category="lo",
  description="BATAK LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC2,
 },
 [0x1BC3]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC3,
 },
 [0x1BC4]={
  category="lo",
  description="BATAK LETTER MANDAILING HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC4,
 },
 [0x1BC5]={
  category="lo",
  description="BATAK LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC5,
 },
 [0x1BC6]={
  category="lo",
  description="BATAK LETTER KARO BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC6,
 },
 [0x1BC7]={
  category="lo",
  description="BATAK LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC7,
 },
 [0x1BC8]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC8,
 },
 [0x1BC9]={
  category="lo",
  description="BATAK LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC9,
 },
 [0x1BCA]={
  category="lo",
  description="BATAK LETTER MANDAILING NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCA,
 },
 [0x1BCB]={
  category="lo",
  description="BATAK LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCB,
 },
 [0x1BCC]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCC,
 },
 [0x1BCD]={
  category="lo",
  description="BATAK LETTER PAKPAK WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCD,
 },
 [0x1BCE]={
  category="lo",
  description="BATAK LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCE,
 },
 [0x1BCF]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCF,
 },
 [0x1BD0]={
  category="lo",
  description="BATAK LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD0,
 },
 [0x1BD1]={
  category="lo",
  description="BATAK LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD1,
 },
 [0x1BD2]={
  category="lo",
  description="BATAK LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD2,
 },
 [0x1BD3]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD3,
 },
 [0x1BD4]={
  category="lo",
  description="BATAK LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD4,
 },
 [0x1BD5]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD5,
 },
 [0x1BD6]={
  category="lo",
  description="BATAK LETTER SOUTHERN TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD6,
 },
 [0x1BD7]={
  category="lo",
  description="BATAK LETTER NORTHERN TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD7,
 },
 [0x1BD8]={
  category="lo",
  description="BATAK LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD8,
 },
 [0x1BD9]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD9,
 },
 [0x1BDA]={
  category="lo",
  description="BATAK LETTER MANDAILING SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDA,
 },
 [0x1BDB]={
  category="lo",
  description="BATAK LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDB,
 },
 [0x1BDC]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDC,
 },
 [0x1BDD]={
  category="lo",
  description="BATAK LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDD,
 },
 [0x1BDE]={
  category="lo",
  description="BATAK LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDE,
 },
 [0x1BDF]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDF,
 },
 [0x1BE0]={
  category="lo",
  description="BATAK LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE0,
 },
 [0x1BE1]={
  category="lo",
  description="BATAK LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE1,
 },
 [0x1BE2]={
  category="lo",
  description="BATAK LETTER NDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE2,
 },
 [0x1BE3]={
  category="lo",
  description="BATAK LETTER MBA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE3,
 },
 [0x1BE4]={
  category="lo",
  description="BATAK LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE4,
 },
 [0x1BE5]={
  category="lo",
  description="BATAK LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE5,
 },
 [0x1BE6]={
  category="mn",
  combining=0x7,
  description="BATAK SIGN TOMPI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BE6,
 },
 [0x1BE7]={
  category="mc",
  description="BATAK VOWEL SIGN E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BE7,
 },
 [0x1BE8]={
  category="mn",
  description="BATAK VOWEL SIGN PAKPAK E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BE8,
 },
 [0x1BE9]={
  category="mn",
  description="BATAK VOWEL SIGN EE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BE9,
 },
 [0x1BEA]={
  category="mc",
  description="BATAK VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BEA,
 },
 [0x1BEB]={
  category="mc",
  description="BATAK VOWEL SIGN KARO I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BEB,
 },
 [0x1BEC]={
  category="mc",
  description="BATAK VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BEC,
 },
 [0x1BED]={
  category="mn",
  description="BATAK VOWEL SIGN KARO O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BED,
 },
 [0x1BEE]={
  category="mc",
  description="BATAK VOWEL SIGN U",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BEE,
 },
 [0x1BEF]={
  category="mn",
  description="BATAK VOWEL SIGN U FOR SIMALUNGUN SA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BEF,
 },
 [0x1BF0]={
  category="mn",
  description="BATAK CONSONANT SIGN NG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BF0,
 },
 [0x1BF1]={
  category="mn",
  description="BATAK CONSONANT SIGN H",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BF1,
 },
 [0x1BF2]={
  category="mc",
  combining=0x9,
  description="BATAK PANGOLAT",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BF2,
 },
 [0x1BF3]={
  category="mc",
  combining=0x9,
  description="BATAK PANONGONAN",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BF3,
 },
 [0x1BFC]={
  category="po",
  description="BATAK SYMBOL BINDU NA METEK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BFC,
 },
 [0x1BFD]={
  category="po",
  description="BATAK SYMBOL BINDU PINARBORAS",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BFD,
 },
 [0x1BFE]={
  category="po",
  description="BATAK SYMBOL BINDU JUDUL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BFE,
 },
 [0x1BFF]={
  category="po",
  description="BATAK SYMBOL BINDU PANGOLAT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BFF,
 },
 [0x1C00]={
  category="lo",
  description="LEPCHA LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C00,
 },
 [0x1C01]={
  category="lo",
  description="LEPCHA LETTER KLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C01,
 },
 [0x1C02]={
  category="lo",
  description="LEPCHA LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C02,
 },
 [0x1C03]={
  category="lo",
  description="LEPCHA LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C03,
 },
 [0x1C04]={
  category="lo",
  description="LEPCHA LETTER GLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C04,
 },
 [0x1C05]={
  category="lo",
  description="LEPCHA LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C05,
 },
 [0x1C06]={
  category="lo",
  description="LEPCHA LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C06,
 },
 [0x1C07]={
  category="lo",
  description="LEPCHA LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C07,
 },
 [0x1C08]={
  category="lo",
  description="LEPCHA LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C08,
 },
 [0x1C09]={
  category="lo",
  description="LEPCHA LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C09,
 },
 [0x1C0A]={
  category="lo",
  description="LEPCHA LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0A,
 },
 [0x1C0B]={
  category="lo",
  description="LEPCHA LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0B,
 },
 [0x1C0C]={
  category="lo",
  description="LEPCHA LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0C,
 },
 [0x1C0D]={
  category="lo",
  description="LEPCHA LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0D,
 },
 [0x1C0E]={
  category="lo",
  description="LEPCHA LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0E,
 },
 [0x1C0F]={
  category="lo",
  description="LEPCHA LETTER PLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0F,
 },
 [0x1C10]={
  category="lo",
  description="LEPCHA LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C10,
 },
 [0x1C11]={
  category="lo",
  description="LEPCHA LETTER FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C11,
 },
 [0x1C12]={
  category="lo",
  description="LEPCHA LETTER FLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C12,
 },
 [0x1C13]={
  category="lo",
  description="LEPCHA LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C13,
 },
 [0x1C14]={
  category="lo",
  description="LEPCHA LETTER BLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C14,
 },
 [0x1C15]={
  category="lo",
  description="LEPCHA LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C15,
 },
 [0x1C16]={
  category="lo",
  description="LEPCHA LETTER MLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C16,
 },
 [0x1C17]={
  category="lo",
  description="LEPCHA LETTER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C17,
 },
 [0x1C18]={
  category="lo",
  description="LEPCHA LETTER TSHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C18,
 },
 [0x1C19]={
  category="lo",
  description="LEPCHA LETTER DZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C19,
 },
 [0x1C1A]={
  category="lo",
  description="LEPCHA LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1A,
 },
 [0x1C1B]={
  category="lo",
  description="LEPCHA LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1B,
 },
 [0x1C1C]={
  category="lo",
  description="LEPCHA LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1C,
 },
 [0x1C1D]={
  category="lo",
  description="LEPCHA LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1D,
 },
 [0x1C1E]={
  category="lo",
  description="LEPCHA LETTER HLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1E,
 },
 [0x1C1F]={
  category="lo",
  description="LEPCHA LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1F,
 },
 [0x1C20]={
  category="lo",
  description="LEPCHA LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C20,
 },
 [0x1C21]={
  category="lo",
  description="LEPCHA LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C21,
 },
 [0x1C22]={
  category="lo",
  description="LEPCHA LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C22,
 },
 [0x1C23]={
  category="lo",
  description="LEPCHA LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C23,
 },
 [0x1C24]={
  category="mc",
  description="LEPCHA SUBJOINED LETTER YA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C24,
 },
 [0x1C25]={
  category="mc",
  description="LEPCHA SUBJOINED LETTER RA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C25,
 },
 [0x1C26]={
  category="mc",
  description="LEPCHA VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C26,
 },
 [0x1C27]={
  category="mc",
  description="LEPCHA VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C27,
 },
 [0x1C28]={
  category="mc",
  description="LEPCHA VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C28,
 },
 [0x1C29]={
  category="mc",
  description="LEPCHA VOWEL SIGN OO",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C29,
 },
 [0x1C2A]={
  category="mc",
  description="LEPCHA VOWEL SIGN U",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C2A,
 },
 [0x1C2B]={
  category="mc",
  description="LEPCHA VOWEL SIGN UU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C2B,
 },
 [0x1C2C]={
  category="mn",
  description="LEPCHA VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C2C,
 },
 [0x1C2D]={
  category="mn",
  description="LEPCHA CONSONANT SIGN K",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C2D,
 },
 [0x1C2E]={
  category="mn",
  description="LEPCHA CONSONANT SIGN M",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C2E,
 },
 [0x1C2F]={
  category="mn",
  description="LEPCHA CONSONANT SIGN L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C2F,
 },
 [0x1C30]={
  category="mn",
  description="LEPCHA CONSONANT SIGN N",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C30,
 },
 [0x1C31]={
  category="mn",
  description="LEPCHA CONSONANT SIGN P",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C31,
 },
 [0x1C32]={
  category="mn",
  description="LEPCHA CONSONANT SIGN R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C32,
 },
 [0x1C33]={
  category="mn",
  description="LEPCHA CONSONANT SIGN T",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C33,
 },
 [0x1C34]={
  category="mc",
  description="LEPCHA CONSONANT SIGN NYIN-DO",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C34,
 },
 [0x1C35]={
  category="mc",
  description="LEPCHA CONSONANT SIGN KANG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C35,
 },
 [0x1C36]={
  category="mn",
  description="LEPCHA SIGN RAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C36,
 },
 [0x1C37]={
  category="mn",
  combining=0x7,
  description="LEPCHA SIGN NUKTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C37,
 },
 [0x1C3B]={
  category="po",
  description="LEPCHA PUNCTUATION TA-ROL",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3B,
 },
 [0x1C3C]={
  category="po",
  description="LEPCHA PUNCTUATION NYET THYOOM TA-ROL",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3C,
 },
 [0x1C3D]={
  category="po",
  description="LEPCHA PUNCTUATION CER-WA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3D,
 },
 [0x1C3E]={
  category="po",
  description="LEPCHA PUNCTUATION TSHOOK CER-WA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3E,
 },
 [0x1C3F]={
  category="po",
  description="LEPCHA PUNCTUATION TSHOOK",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3F,
 },
 [0x1C40]={
  category="nd",
  description="LEPCHA DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C40,
 },
 [0x1C41]={
  category="nd",
  description="LEPCHA DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C41,
 },
 [0x1C42]={
  category="nd",
  description="LEPCHA DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C42,
 },
 [0x1C43]={
  category="nd",
  description="LEPCHA DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C43,
 },
 [0x1C44]={
  category="nd",
  description="LEPCHA DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C44,
 },
 [0x1C45]={
  category="nd",
  description="LEPCHA DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C45,
 },
 [0x1C46]={
  category="nd",
  description="LEPCHA DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C46,
 },
 [0x1C47]={
  category="nd",
  description="LEPCHA DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C47,
 },
 [0x1C48]={
  category="nd",
  description="LEPCHA DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C48,
 },
 [0x1C49]={
  category="nd",
  description="LEPCHA DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C49,
 },
 [0x1C4D]={
  category="lo",
  description="LEPCHA LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C4D,
 },
 [0x1C4E]={
  category="lo",
  description="LEPCHA LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C4E,
 },
 [0x1C4F]={
  category="lo",
  description="LEPCHA LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C4F,
 },
 [0x1C50]={
  category="nd",
  description="OL CHIKI DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C50,
 },
 [0x1C51]={
  category="nd",
  description="OL CHIKI DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C51,
 },
 [0x1C52]={
  category="nd",
  description="OL CHIKI DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C52,
 },
 [0x1C53]={
  category="nd",
  description="OL CHIKI DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C53,
 },
 [0x1C54]={
  category="nd",
  description="OL CHIKI DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C54,
 },
 [0x1C55]={
  category="nd",
  description="OL CHIKI DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C55,
 },
 [0x1C56]={
  category="nd",
  description="OL CHIKI DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C56,
 },
 [0x1C57]={
  category="nd",
  description="OL CHIKI DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C57,
 },
 [0x1C58]={
  category="nd",
  description="OL CHIKI DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C58,
 },
 [0x1C59]={
  category="nd",
  description="OL CHIKI DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C59,
 },
 [0x1C5A]={
  category="lo",
  description="OL CHIKI LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5A,
 },
 [0x1C5B]={
  category="lo",
  description="OL CHIKI LETTER AT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5B,
 },
 [0x1C5C]={
  category="lo",
  description="OL CHIKI LETTER AG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5C,
 },
 [0x1C5D]={
  category="lo",
  description="OL CHIKI LETTER ANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5D,
 },
 [0x1C5E]={
  category="lo",
  description="OL CHIKI LETTER AL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5E,
 },
 [0x1C5F]={
  category="lo",
  description="OL CHIKI LETTER LAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5F,
 },
 [0x1C60]={
  category="lo",
  description="OL CHIKI LETTER AAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C60,
 },
 [0x1C61]={
  category="lo",
  description="OL CHIKI LETTER AAJ",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C61,
 },
 [0x1C62]={
  category="lo",
  description="OL CHIKI LETTER AAM",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C62,
 },
 [0x1C63]={
  category="lo",
  description="OL CHIKI LETTER AAW",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C63,
 },
 [0x1C64]={
  category="lo",
  description="OL CHIKI LETTER LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C64,
 },
 [0x1C65]={
  category="lo",
  description="OL CHIKI LETTER IS",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C65,
 },
 [0x1C66]={
  category="lo",
  description="OL CHIKI LETTER IH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C66,
 },
 [0x1C67]={
  category="lo",
  description="OL CHIKI LETTER INY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C67,
 },
 [0x1C68]={
  category="lo",
  description="OL CHIKI LETTER IR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C68,
 },
 [0x1C69]={
  category="lo",
  description="OL CHIKI LETTER LU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C69,
 },
 [0x1C6A]={
  category="lo",
  description="OL CHIKI LETTER UC",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6A,
 },
 [0x1C6B]={
  category="lo",
  description="OL CHIKI LETTER UD",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6B,
 },
 [0x1C6C]={
  category="lo",
  description="OL CHIKI LETTER UNN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6C,
 },
 [0x1C6D]={
  category="lo",
  description="OL CHIKI LETTER UY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6D,
 },
 [0x1C6E]={
  category="lo",
  description="OL CHIKI LETTER LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6E,
 },
 [0x1C6F]={
  category="lo",
  description="OL C