/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server.system;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class Histogram19 {
    private static final String DIAGNOSTIC_COMMAND_MXBEAN_NAME = "com.sun.management:type=DiagnosticCommand";
    private static final String ALL_OBJECTS_OPTION = "-all";
    private static final String HISTOGRAM_COMMAND = "gcClassHistogram";
    private static MBeanServer mserver;
    private static ObjectName hotspotDiag;

    Histogram19() {
    }

    static boolean initialize() {
        boolean bl = false;
        try {
            mserver = ManagementFactory.getPlatformMBeanServer();
            hotspotDiag = new ObjectName(DIAGNOSTIC_COMMAND_MXBEAN_NAME);
            mserver.getObjectInstance(hotspotDiag);
            bl = true;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.err.println("Heap Histogram is not available");
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return bl;
    }

    static InputStream getRawHistogram() {
        try {
            Object object = mserver.invoke(hotspotDiag, HISTOGRAM_COMMAND, new Object[]{new String[]{ALL_OBJECTS_OPTION}}, new String[]{String[].class.getName()});
            if (object instanceof String) {
                return new ByteArrayInputStream(((String)object).getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            instanceNotFoundException.printStackTrace();
        }
        catch (MBeanException mBeanException) {
            mBeanException.printStackTrace();
        }
        catch (ReflectionException reflectionException) {
            reflectionException.printStackTrace();
        }
        return null;
    }
}

