/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.ui;

import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.heapviewer.HeapViewer;
import com.sun.tools.visualvm.heapviewer.ui.Bundle;
import com.sun.tools.visualvm.heapviewer.ui.UIThresholds;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

class HeapDumpInfoAction
extends AbstractAction {
    private final HeapViewer heapViewer;
    private static final String LINE_PREFIX = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String SUMMARY_SECTION_PREFIX = "<b><img border='0' align='bottom' src='nbresloc:/" + Icons.getResource((String)"GeneralIcons.Info") + "'>&nbsp;&nbsp;" + Bundle.HeapDumpInfoAction_SummaryString() + "</b><br><hr>";

    public HeapDumpInfoAction(HeapViewer heapViewer) {
        this.putValue("Name", Bundle.HeapDumpInfoAction_ActionName());
        this.putValue("ShortDescription", Bundle.HeapDumpInfoAction_ActionDescr());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Info"));
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Info"));
        this.heapViewer = heapViewer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HelpCtx helpCtx = new HelpCtx("SnapshotInfo.HelpCtx");
        DialogDescriptor dd = new DialogDescriptor((Object)HeapDumpInfoAction.infoComponent(this.heapViewer), Bundle.HeapDumpInfoAction_WindowCaption(), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
    }

    private static JComponent infoComponent(HeapViewer heapViewer) {
        HTMLTextArea text = new HTMLTextArea();
        text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        HeapDumpInfoAction.createInfo(text, heapViewer);
        ScrollableContainer textScroll = new ScrollableContainer((JComponent)text);
        textScroll.setPreferredSize(new Dimension(750, 400));
        return textScroll;
    }

    private static void createInfo(final HTMLTextArea text, final HeapViewer heapViewer) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                Heap heap = heapViewer.getFragments().get(0).getHeap();
                Properties sysprops = heap.getSystemProperties();
                return HeapDumpInfoAction.computeInfo(heapViewer) + "<br><br>" + HeapDumpInfoAction.computeEnvironment(heap, sysprops) + "<br><br>" + HeapDumpInfoAction.computeSystemProperties(sysprops);
            }

            @Override
            protected void done() {
                try {
                    text.setText((String)this.get());
                    text.setCaretPosition(0);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        worker.execute();
        try {
            worker.get(UIThresholds.VIEW_LOAD, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (TimeoutException ex) {
            text.setText(SUMMARY_SECTION_PREFIX + LINE_PREFIX + Bundle.HeapDumpInfoAction_ComputingInfo());
            text.setCaretPosition(0);
        }
    }

    private static String computeInfo(HeapViewer heapViewer) {
        File file = heapViewer.getFile();
        HeapSummary hsummary = heapViewer.getFragments().get(0).getHeap().getSummary();
        NumberFormat numberFormat = (NumberFormat)NumberFormat.getInstance().clone();
        numberFormat.setMaximumFractionDigits(1);
        String filename = LINE_PREFIX + Bundle.HeapDumpInfoAction_FileItemString(file != null && file.exists() ? file.getAbsolutePath() : Bundle.HeapDumpInfoAction_NotAvailableMsg());
        String filesize = LINE_PREFIX + Bundle.HeapDumpInfoAction_FileSizeItemString(file != null && file.exists() ? numberFormat.format((double)file.length() / 1048576.0) + " MB" : Bundle.HeapDumpInfoAction_NotAvailableMsg());
        String dateTaken = LINE_PREFIX + Bundle.HeapDumpInfoAction_DateTakenItemString(new Date(hsummary.getTime()).toString());
        return SUMMARY_SECTION_PREFIX + dateTaken + "<br>" + filename + "<br>" + filesize;
    }

    private static String computeEnvironment(Heap heap, Properties sysprops) {
        String sysinfoRes = Icons.getResource((String)"HeapWalkerIcons.SystemInfo");
        String header = "<b><img border='0' align='bottom' src='nbresloc:/" + sysinfoRes + "'>&nbsp;&nbsp;" + Bundle.HeapDumpInfoAction_EnvironmentString() + "</b><br><hr>";
        if (sysprops == null) {
            return header + LINE_PREFIX + Bundle.HeapDumpInfoAction_NotAvailableMsg();
        }
        HeapSummary hsummary = heap.getSummary();
        long startupTime = HeapDumpInfoAction.computeStartupTime(heap);
        String patchLevel = sysprops.getProperty("sun.os.patch.level", "");
        String os = LINE_PREFIX + Bundle.HeapDumpInfoAction_OsItemString(sysprops.getProperty("os.name", Bundle.HeapDumpInfoAction_NotAvailableMsg()), sysprops.getProperty("os.version", ""), "unknown".equals(patchLevel) ? "" : patchLevel);
        String arch = LINE_PREFIX + Bundle.HeapDumpInfoAction_ArchitectureItemString(sysprops.getProperty("os.arch", Bundle.HeapDumpInfoAction_NotAvailableMsg()), sysprops.getProperty("sun.arch.data.model", "?") + "bit");
        String jdk = LINE_PREFIX + Bundle.HeapDumpInfoAction_JavaHomeItemString(sysprops.getProperty("java.home", Bundle.HeapDumpInfoAction_NotAvailableMsg()));
        String version = LINE_PREFIX + Bundle.HeapDumpInfoAction_JavaVersionItemString(sysprops.getProperty("java.version", Bundle.HeapDumpInfoAction_NotAvailableMsg()));
        String jvm = LINE_PREFIX + Bundle.HeapDumpInfoAction_JvmItemString(sysprops.getProperty("java.vm.name", Bundle.HeapDumpInfoAction_NotAvailableMsg()), sysprops.getProperty("java.vm.version", ""), sysprops.getProperty("java.vm.info", ""));
        String vendor = LINE_PREFIX + Bundle.HeapDumpInfoAction_JavaVendorItemString(sysprops.getProperty("java.vendor", Bundle.HeapDumpInfoAction_NotAvailableMsg()));
        String uptimeInfo = LINE_PREFIX + Bundle.HeapDumpInfoAction_UpTimeItemString(startupTime >= 0L ? HeapDumpInfoAction.getTime(hsummary.getTime() - startupTime) : Bundle.HeapDumpInfoAction_NotAvailableMsg());
        return header + os + "<br>" + arch + "<br>" + jdk + "<br>" + version + "<br>" + jvm + "<br>" + vendor + "<br>" + uptimeInfo;
    }

    private static long computeStartupTime(Heap heap) {
        Long len;
        Instance runtimeImpl;
        JavaClass jmxFactoryClass = heap.getJavaClassByName("sun.management.ManagementFactoryHelper");
        if (jmxFactoryClass == null) {
            jmxFactoryClass = heap.getJavaClassByName("sun.management.ManagementFactory");
        }
        if (jmxFactoryClass != null && (runtimeImpl = (Instance)jmxFactoryClass.getValueOfStaticField("runtimeMBean")) != null && (len = (Long)runtimeImpl.getValueOfField("vmStartupTime")) != null) {
            return len;
        }
        return -1L;
    }

    private static String computeSystemProperties(Properties sysprops) {
        String propertiesRes = Icons.getResource((String)"HeapWalkerIcons.Properties");
        String header = "<b><img border='0' align='bottom' src='nbresloc:/" + propertiesRes + "'>&nbsp;&nbsp;" + Bundle.HeapDumpInfoAction_SystemPropertiesString() + "</b><br><hr>";
        if (sysprops == null) {
            return header + LINE_PREFIX + Bundle.HeapDumpInfoAction_NotAvailableMsg();
        }
        return header + HeapDumpInfoAction.formatSystemProperties(sysprops);
    }

    private static String formatSystemProperties(Properties properties) {
        StringBuilder text = new StringBuilder(200);
        ArrayList keys = new ArrayList();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            keys.add(en.nextElement());
        }
        Collections.sort(keys);
        for (String key : keys) {
            String val = properties.getProperty(key);
            if ("line.separator".equals(key) && val != null) {
                val = val.replace("\n", "\\n");
                val = val.replace("\r", "\\r");
            }
            text.append("<nobr>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>");
            text.append(key);
            text.append("</b>=");
            text.append(val);
            text.append("</nobr><br>");
        }
        return text.toString();
    }

    private static String getTime(long millis) {
        String sSeconds;
        long hours = millis / 3600000L;
        String sHours = hours == 0L ? "" : "" + hours;
        long minutes = (millis %= 3600000L) / 60000L;
        String sMinutes = hours > 0L && minutes < 10L ? "0" + minutes : "" + minutes;
        long seconds = (millis %= 60000L) / 1000L;
        String string = sSeconds = seconds < 10L ? "0" + seconds : "" + seconds;
        if (sHours.length() == 0) {
            return Bundle.HeapDumpInfoAction_FORMAT_ms(sMinutes, sSeconds);
        }
        return Bundle.HeapDumpInfoAction_FORMAT_hms(sHours, sMinutes, sSeconds);
    }
}

