/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import javax.annotation.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.CategorisedOutputEvent;
import org.gradle.internal.logging.events.operations.ProgressStartBuildOperationProgressDetails;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.OperationIdentifier;

public class ProgressStartEvent
extends CategorisedOutputEvent
implements ProgressStartBuildOperationProgressDetails {
    public static final String TASK_CATEGORY = "class org.gradle.internal.buildevents.TaskExecutionLogger";
    public static final String BUILD_OP_CATEGORY = "org.gradle.internal.logging.progress.ProgressLoggerFactory";
    private final OperationIdentifier progressOperationId;
    private final OperationIdentifier parentProgressOperationId;
    private final String description;
    @Nullable
    private final String loggingHeader;
    private final String status;
    private final int totalProgress;
    private final boolean buildOperationStart;
    @Nullable
    private final OperationIdentifier buildOperationId;
    private final BuildOperationCategory buildOperationCategory;

    public ProgressStartEvent(OperationIdentifier progressOperationId, @Nullable OperationIdentifier parentProgressOperationId, long timestamp, String category, String description, @Nullable String loggingHeader, String status, int totalProgress, boolean buildOperationStart, @Nullable OperationIdentifier buildOperationId, @Nullable BuildOperationCategory buildOperationCategory) {
        super(timestamp, category, LogLevel.LIFECYCLE);
        this.progressOperationId = progressOperationId;
        this.parentProgressOperationId = parentProgressOperationId;
        this.description = description;
        this.loggingHeader = loggingHeader;
        this.status = status;
        this.totalProgress = totalProgress;
        this.buildOperationStart = buildOperationStart;
        this.buildOperationId = buildOperationId;
        this.buildOperationCategory = buildOperationCategory == null ? BuildOperationCategory.UNCATEGORIZED : buildOperationCategory;
    }

    @Nullable
    public OperationIdentifier getParentProgressOperationId() {
        return this.parentProgressOperationId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getLoggingHeader() {
        return this.loggingHeader;
    }

    public String getStatus() {
        return this.status;
    }

    public int getTotalProgress() {
        return this.totalProgress;
    }

    public String toString() {
        return "ProgressStart (p:" + this.progressOperationId + " parent p:" + this.parentProgressOperationId + " b:" + this.buildOperationId + ") " + this.description;
    }

    public OperationIdentifier getProgressOperationId() {
        return this.progressOperationId;
    }

    public boolean isBuildOperationStart() {
        return this.buildOperationStart;
    }

    @Nullable
    public OperationIdentifier getBuildOperationId() {
        return this.buildOperationId;
    }

    public BuildOperationCategory getBuildOperationCategory() {
        return this.buildOperationCategory;
    }

    public ProgressStartEvent withParentProgressOperation(OperationIdentifier parentProgressOperationId) {
        return new ProgressStartEvent(this.progressOperationId, parentProgressOperationId, this.getTimestamp(), this.getCategory(), this.description, this.loggingHeader, this.status, this.totalProgress, this.buildOperationStart, this.buildOperationId, this.buildOperationCategory);
    }
}

