/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public class AbstractImageZoomInteractor
extends InteractorAdapter {
    protected boolean finished = true;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;

    @Override
    public boolean endInteraction() {
        return this.finished;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.finished) {
            JGVTComponent c = (JGVTComponent)e.getSource();
            c.setPaintingTransform(null);
            return;
        }
        this.finished = false;
        this.xStart = e.getX();
        this.yStart = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.finished = true;
        JGVTComponent c = (JGVTComponent)e.getSource();
        AffineTransform pt = c.getPaintingTransform();
        if (pt != null) {
            AffineTransform rt = (AffineTransform)c.getRenderingTransform().clone();
            rt.preConcatenate(pt);
            c.setRenderingTransform(rt);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        JGVTComponent c = (JGVTComponent)e.getSource();
        this.xCurrent = e.getX();
        this.yCurrent = e.getY();
        AffineTransform at = AffineTransform.getTranslateInstance(this.xStart, this.yStart);
        int dy = this.yCurrent - this.yStart;
        double s = dy < 0 ? ((dy -= 10) > -15 ? 1.0 : -15.0 / (double)dy) : ((dy += 10) < 15 ? 1.0 : (double)dy / 15.0);
        at.scale(s, s);
        at.translate(-this.xStart, -this.yStart);
        c.setPaintingTransform(at);
    }
}

