/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.data.LatLon;
import net.osmand.data.LocationPoint;
import net.osmand.data.PointDescription;
import net.osmand.plus.GeocodingLookupService;
import net.osmand.plus.OsmandSettings;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;

public class MapMarkersHelper {
    public static final int MAP_MARKERS_COLORS_COUNT = 7;
    private List<MapMarker> mapMarkers = new ArrayList<MapMarker>();
    private List<MapMarker> sortedMapMarkers = new ArrayList<MapMarker>();
    private List<MapMarker> mapMarkersHistory = new ArrayList<MapMarker>();
    private OsmandSettings settings;
    private List<MapMarkerChangedListener> listeners = new ArrayList<MapMarkerChangedListener>();
    private OsmWindow ctx;
    private boolean startFromMyLocation;

    public MapMarkersHelper(OsmWindow ctx) {
        this.ctx = ctx;
        this.settings = ctx.getSettings();
        this.startFromMyLocation = this.settings.ROUTE_MAP_MARKERS_START_MY_LOC.get();
        this.readFromSettings();
    }

    public boolean isStartFromMyLocation() {
        return this.startFromMyLocation;
    }

    public void setStartFromMyLocation(boolean startFromMyLocation) {
        this.startFromMyLocation = startFromMyLocation;
        this.settings.ROUTE_MAP_MARKERS_START_MY_LOC.set(startFromMyLocation);
    }

    private void readFromSettings() {
        MapMarker mapMarker;
        int i;
        this.mapMarkers.clear();
        this.mapMarkersHistory.clear();
        List<LatLon> ips = this.settings.getMapMarkersPoints();
        List<String> desc = this.settings.getMapMarkersPointDescriptions(ips.size());
        List<Integer> colors = this.settings.getMapMarkersColors(ips.size());
        List<Integer> positions = this.settings.getMapMarkersPositions(ips.size());
        List<Boolean> selections = this.settings.getMapMarkersSelections(ips.size());
        int colorIndex = 0;
        int pos = 0;
        for (i = 0; i < ips.size(); ++i) {
            if (colors.size() > i) {
                colorIndex = colors.get(i);
            }
            pos = positions.size() > i ? positions.get(i) : ++pos;
            mapMarker = new MapMarker(ips.get(i), PointDescription.deserializeFromString(desc.get(i), ips.get(i)), colorIndex, pos, selections.get(i), i);
            this.mapMarkers.add(mapMarker);
            this.lookupAddress(mapMarker, false);
        }
        this.updateSortedArray();
        ips = this.settings.getMapMarkersHistoryPoints();
        desc = this.settings.getMapMarkersHistoryPointDescriptions(ips.size());
        for (i = 0; i < ips.size(); ++i) {
            mapMarker = new MapMarker(ips.get(i), PointDescription.deserializeFromString(desc.get(i), ips.get(i)), 0, 0, false, i);
            mapMarker.history = true;
            this.mapMarkersHistory.add(mapMarker);
            this.lookupAddress(mapMarker, true);
        }
    }

    private void updateSortedArray() {
        this.sortedMapMarkers.clear();
        this.sortedMapMarkers.addAll(this.mapMarkers);
        Collections.sort(this.sortedMapMarkers, new Comparator<MapMarker>(){

            @Override
            public int compare(MapMarker lhs, MapMarker rhs) {
                return lhs.pos < rhs.pos ? -1 : (lhs.pos == rhs.pos ? 0 : 1);
            }
        });
    }

    public void normalizePositions() {
        int i = 0;
        while (i < this.sortedMapMarkers.size()) {
            MapMarker marker = this.sortedMapMarkers.get(i);
            marker.pos = i++;
        }
        this.saveMapMarkers(this.mapMarkers, null);
    }

    private void lookupAddress(final MapMarker mapMarker, final boolean history) {
        if (mapMarker != null && mapMarker.pointDescription.isSearchingAddress(this.ctx)) {
            this.cancelPointAddressRequests(mapMarker.point);
            GeocodingLookupService.AddressLookupRequest lookupRequest = new GeocodingLookupService.AddressLookupRequest(mapMarker.point, new GeocodingLookupService.OnAddressLookupResult(){

                @Override
                public void geocodingDone(String address) {
                    if (Algorithms.isEmpty(address)) {
                        mapMarker.pointDescription.setName(PointDescription.getAddressNotFoundStr(MapMarkersHelper.this.ctx));
                    } else {
                        mapMarker.pointDescription.setName(address);
                    }
                    if (history) {
                        MapMarkersHelper.this.settings.updateMapMarkerHistory(mapMarker.point.getLatitude(), mapMarker.point.getLongitude(), mapMarker.pointDescription, mapMarker.colorIndex);
                    } else {
                        MapMarkersHelper.this.settings.updateMapMarker(mapMarker.point.getLatitude(), mapMarker.point.getLongitude(), mapMarker.pointDescription, mapMarker.colorIndex, mapMarker.pos, mapMarker.selected);
                    }
                    MapMarkersHelper.this.updateMarker(mapMarker);
                }
            }, null);
            this.ctx.getGeocodingLookupService().lookupAddress(lookupRequest);
        }
    }

    public void removeMapMarker(int index) {
        this.settings.deleteMapMarker(index);
        MapMarker mapMarker = this.mapMarkers.remove(index);
        this.cancelPointAddressRequests(mapMarker.point);
        int ind = 0;
        for (MapMarker marker : this.mapMarkers) {
            marker.index = ind++;
        }
        this.updateSortedArray();
        this.refresh();
    }

    public List<MapMarker> getActiveMapMarkers() {
        return this.mapMarkers;
    }

    public MapMarker getFirstMapMarker() {
        if (this.mapMarkers.size() > 0) {
            return this.mapMarkers.get(0);
        }
        return null;
    }

    public List<MapMarker> getSortedMapMarkers() {
        return this.sortedMapMarkers;
    }

    public List<MapMarker> getMapMarkersHistory() {
        return this.mapMarkersHistory;
    }

    public List<MapMarker> getSelectedMarkers() {
        ArrayList<MapMarker> list = new ArrayList<MapMarker>();
        for (MapMarker m : this.mapMarkers) {
            if (!m.selected) continue;
            list.add(m);
        }
        return list;
    }

    public List<LatLon> getActiveMarkersLatLon() {
        ArrayList<LatLon> list = new ArrayList<LatLon>();
        for (MapMarker m : this.mapMarkers) {
            list.add(m.point);
        }
        return list;
    }

    public List<LatLon> getSelectedMarkersLatLon() {
        ArrayList<LatLon> list = new ArrayList<LatLon>();
        for (MapMarker m : this.mapMarkers) {
            if (!m.selected) continue;
            list.add(m.point);
        }
        return list;
    }

    public List<LatLon> getMarkersHistoryLatLon() {
        ArrayList<LatLon> list = new ArrayList<LatLon>();
        for (MapMarker m : this.mapMarkersHistory) {
            list.add(m.point);
        }
        return list;
    }

    public void reverseActiveMarkersOrder() {
        this.cancelAddressRequests();
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>(this.mapMarkers.size());
        for (int i = this.mapMarkers.size() - 1; i >= 0; --i) {
            MapMarker marker = this.mapMarkers.get(i);
            markers.add(marker);
        }
        this.mapMarkers = markers;
        this.saveMapMarkers(this.mapMarkers, null);
    }

    public void removeActiveMarkers() {
        this.cancelAddressRequests();
        for (int i = this.mapMarkers.size() - 1; i >= 0; --i) {
            MapMarker marker = this.mapMarkers.get(i);
            this.addMapMarkerHistory(marker);
        }
        this.settings.clearActiveMapMarkers();
        this.readFromSettings();
        this.refresh();
    }

    public void removeMarkersHistory() {
        this.cancelAddressRequests();
        this.settings.clearMapMarkersHistory();
        this.readFromSettings();
        this.refresh();
    }

    public void addMapMarker(LatLon point, PointDescription historyName) {
        ArrayList<LatLon> points = new ArrayList<LatLon>(1);
        ArrayList<PointDescription> historyNames = new ArrayList<PointDescription>(1);
        points.add(point);
        historyNames.add(historyName);
        this.addMapMarkers(points, historyNames);
    }

    public void addMapMarkers(List<LatLon> points, List<PointDescription> historyNames) {
        if (points.size() > 0) {
            int colorIndex = -1;
            double[] latitudes = new double[points.size()];
            double[] longitudes = new double[points.size()];
            ArrayList<PointDescription> pointDescriptions = new ArrayList<PointDescription>();
            int[] colorIndexes = new int[points.size()];
            int[] positions = new int[points.size()];
            boolean[] selections = new boolean[points.size()];
            int[] indexes = new int[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                LatLon point = points.get(i);
                PointDescription historyName = historyNames.get(i);
                PointDescription pointDescription = historyName == null ? new PointDescription("location", "") : historyName;
                if (pointDescription.isLocation() && Algorithms.isEmpty(pointDescription.getName())) {
                    pointDescription.setName(PointDescription.getSearchAddressStr(this.ctx));
                }
                colorIndex = colorIndex == -1 ? (this.sortedMapMarkers.size() > 0 ? (this.sortedMapMarkers.get((int)0).colorIndex + 1) % 7 : 0) : (colorIndex + 1) % 7;
                latitudes[i] = point.getLatitude();
                longitudes[i] = point.getLongitude();
                pointDescriptions.add(pointDescription);
                colorIndexes[i] = colorIndex;
                positions[i] = -1 - i;
                selections[i] = false;
                indexes[i] = 0;
            }
            this.settings.insertMapMarkers(latitudes, longitudes, pointDescriptions, colorIndexes, positions, selections, indexes);
            this.readFromSettings();
            this.normalizePositions();
        }
    }

    public void updateMapMarker(MapMarker marker, boolean refresh) {
        if (marker != null) {
            this.settings.updateMapMarker(marker.getLatitude(), marker.getLongitude(), marker.pointDescription, marker.colorIndex, marker.pos, marker.selected);
            if (refresh) {
                this.readFromSettings();
                this.refresh();
            }
        }
    }

    public void removeMapMarker(MapMarker marker) {
        if (marker != null) {
            this.settings.deleteMapMarker(marker.index);
            this.readFromSettings();
            this.refresh();
        }
    }

    public void addMapMarkerHistory(MapMarker marker) {
        if (marker != null) {
            this.settings.insertMapMarkerHistory(marker.getLatitude(), marker.getLongitude(), marker.pointDescription, marker.colorIndex, 0);
            this.readFromSettings();
            this.refresh();
        }
    }

    public void removeMapMarkerHistory(MapMarker marker) {
        if (marker != null) {
            this.settings.deleteMapMarkerHistory(marker.index);
            this.readFromSettings();
            this.refresh();
        }
    }

    public void saveMapMarkers(List<MapMarker> markers, List<MapMarker> markersHistory) {
        ArrayList<Integer> colors;
        ArrayList<String> names;
        ArrayList<LatLon> ls;
        if (markers != null) {
            ls = new ArrayList<LatLon>(markers.size());
            names = new ArrayList<String>(markers.size());
            colors = new ArrayList<Integer>(markers.size());
            ArrayList<Integer> positions = new ArrayList<Integer>(markers.size());
            ArrayList<Boolean> selections = new ArrayList<Boolean>(markers.size());
            for (MapMarker marker : markers) {
                ls.add(marker.point);
                names.add(PointDescription.serializeToString(marker.pointDescription));
                colors.add(marker.colorIndex);
                positions.add(marker.pos);
                selections.add(marker.selected);
            }
            this.settings.saveMapMarkers(ls, names, colors, positions, selections);
        }
        if (markersHistory != null) {
            ls = new ArrayList(markersHistory.size());
            names = new ArrayList(markersHistory.size());
            colors = new ArrayList(markersHistory.size());
            for (MapMarker marker : markersHistory) {
                ls.add(marker.point);
                names.add(PointDescription.serializeToString(marker.pointDescription));
                colors.add(marker.colorIndex);
            }
            this.settings.saveMapMarkersHistory(ls, names, colors);
        }
        if (markers != null || markersHistory != null) {
            this.readFromSettings();
            this.refresh();
        }
    }

    public void addListener(MapMarkerChangedListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(MapMarkerChangedListener l) {
        this.listeners.remove(l);
    }

    private void updateMarker(MapMarker marker) {
        for (MapMarkerChangedListener l : this.listeners) {
            l.onMapMarkerChanged(marker);
        }
    }

    private void updateMarkers() {
        for (MapMarkerChangedListener l : this.listeners) {
            l.onMapMarkersChanged();
        }
    }

    public void refresh() {
        this.updateMarkers();
    }

    private void cancelAddressRequests() {
        List<LatLon> list = this.getActiveMarkersLatLon();
        for (LatLon latLon : list) {
            this.cancelPointAddressRequests(latLon);
        }
        list = this.getMarkersHistoryLatLon();
        for (LatLon latLon : list) {
            this.cancelPointAddressRequests(latLon);
        }
    }

    private void cancelPointAddressRequests(LatLon latLon) {
        if (latLon != null) {
            this.ctx.getGeocodingLookupService().cancel(latLon);
        }
    }

    public static class MapMarker
    implements LocationPoint {
        public LatLon point;
        private PointDescription pointDescription;
        public int colorIndex;
        public int pos;
        public int index;
        public boolean history;
        public boolean selected;
        public int dist;

        public MapMarker(LatLon point, PointDescription name, int colorIndex, int pos, boolean selected, int index) {
            this.point = point;
            this.pointDescription = name;
            this.colorIndex = colorIndex;
            this.pos = pos;
            this.selected = selected;
            this.index = index;
        }

        @Override
        public PointDescription getPointDescription(OsmWindow ctx) {
            return new PointDescription("map_marker", ctx.getString(2081, ""), this.getOnlyName());
        }

        public PointDescription getOriginalPointDescription() {
            return this.pointDescription;
        }

        public String getOnlyName() {
            return this.pointDescription == null ? "" : this.pointDescription.getName();
        }

        @Override
        public double getLatitude() {
            return this.point.getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.point.getLongitude();
        }

        @Override
        public int getColor() {
            return 0;
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }

    public static interface MapMarkerChangedListener {
        public void onMapMarkerChanged(MapMarker var1);

        public void onMapMarkersChanged();
    }
}

