/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.data;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import net.osmand.PlatformUtil;
import net.osmand.plus.api.SQLiteAPI;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;
import org.sqlite.SQLiteConfig;

public class SQLiteImpl
implements SQLiteAPI {
    private static final Log log = PlatformUtil.getLog(SQLiteImpl.class);
    private OsmWindow mContext;

    public SQLiteImpl(OsmWindow pOsmWindow) {
        this.mContext = pOsmWindow;
    }

    @Override
    public SQLiteAPI.SQLiteConnection getOrCreateDatabase(String pName, boolean pReadOnly) {
        try {
            SQLiteConfig config = new SQLiteConfig();
            String file = this.getDatabaseFileName(pName);
            if (pReadOnly && new File(file).exists()) {
                config.setReadOnly(pReadOnly);
            }
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + file, config.toProperties());
            return new SQLiteConnectionWrapper(conn, pName);
        }
        catch (SQLException e) {
            log.error((Object)("SQLException:" + pName), (Throwable)e);
            return null;
        }
    }

    protected String getDatabaseFileName(String pName) {
        String file = OsmWindow.getAppPathName(pName) + ".db";
        return file;
    }

    @Override
    public SQLiteAPI.SQLiteConnection openByAbsolutePath(String pPath, boolean pReadOnly) {
        throw new IllegalArgumentException("Not implemented");
    }

    public static void main(String[] args) {
        SQLiteImpl impl = new SQLiteImpl(OsmWindow.getInstance());
        SQLiteAPI.SQLiteConnection conn = impl.getOrCreateDatabase("test", true);
        System.out.println("Version: " + conn.getVersion());
        conn.setVersion(17);
        conn.execSQL("create table if not exists 'bla' (name TEXT);");
        conn.execSQL("insert into 'bla' values ('testvalue');");
        SQLiteAPI.SQLiteCursor query = conn.rawQuery("SELECT name, name FROM bla ORDER BY name DESC", null);
        if (query.moveToFirst()) {
            do {
                String name = query.getString(1);
                System.out.println("Content:  " + name);
            } while (query.moveToNext());
        }
        query.close();
        conn.close();
    }

    @Override
    public boolean isDatabaseExistent(String pName) {
        String file = this.getDatabaseFileName(pName);
        return new File(file).exists();
    }

    public class SQLiteConnectionWrapper
    implements SQLiteAPI.SQLiteConnection {
        private Connection mConn;
        private String mName;

        public SQLiteConnectionWrapper(Connection pConn, String pName) {
            this.mConn = pConn;
            this.mName = pName;
        }

        @Override
        public void close() {
            try {
                this.mConn.close();
            }
            catch (SQLException e) {
                log.error((Object)"SQLException:", (Throwable)e);
            }
        }

        @Override
        public SQLiteAPI.SQLiteCursor rawQuery(String pSql, String[] pSelectionArgs) {
            if (pSelectionArgs != null && pSelectionArgs.length > 0) {
                throw new IllegalArgumentException("Not Implemented");
            }
            try {
                return new SQLiteCursorWrapper(this.mConn.createStatement().executeQuery(pSql));
            }
            catch (SQLException e) {
                log.error((Object)("SQLException:" + pSql), (Throwable)e);
                return null;
            }
        }

        @Override
        public void execSQL(String pQuery) {
            try {
                this.mConn.createStatement().executeUpdate(pQuery);
            }
            catch (SQLException e) {
                log.error((Object)("SQLException:" + pQuery), (Throwable)e);
            }
        }

        @Override
        public void execSQL(String pQuery, Object[] pObjects) {
            try {
                PreparedStatement prep = this.mConn.prepareStatement(pQuery);
                for (int i = 0; i < pObjects.length; ++i) {
                    Object object = pObjects[i];
                    prep.setObject(i + 1, object);
                }
                prep.execute();
            }
            catch (SQLException e) {
                log.error((Object)("SQLException:" + pQuery), (Throwable)e);
            }
        }

        @Override
        public SQLiteAPI.SQLiteStatement compileStatement(String pString) {
            throw new IllegalArgumentException("Not implemented");
        }

        @Override
        public void setVersion(int pNewVersion) {
            SQLiteImpl.this.mContext.getOffroadProperties().setProperty("version_" + this.mName, "" + pNewVersion);
        }

        @Override
        public int getVersion() {
            String key;
            Properties prop = SQLiteImpl.this.mContext.getOffroadProperties();
            if (prop.containsKey(key = "version_" + this.mName)) {
                return Integer.parseInt("" + prop.get(key));
            }
            return 0;
        }

        @Override
        public boolean isReadOnly() {
            try {
                return this.mConn.isReadOnly();
            }
            catch (SQLException e) {
                log.error((Object)"SQLException:", (Throwable)e);
                return true;
            }
        }

        @Override
        public boolean isDbLockedByOtherThreads() {
            return false;
        }

        @Override
        public boolean isClosed() {
            try {
                return this.mConn.isClosed();
            }
            catch (SQLException e) {
                log.error((Object)"SQLException:", (Throwable)e);
                return true;
            }
        }

        @Override
        public boolean isOpen() {
            return !this.isClosed();
        }
    }

    public class SQLiteCursorWrapper
    implements SQLiteAPI.SQLiteCursor {
        private ResultSet mResult;

        public SQLiteCursorWrapper(ResultSet pExecuteQuery) {
            this.mResult = pExecuteQuery;
        }

        @Override
        public String[] getColumnNames() {
            Object[] ret = null;
            try {
                ret = new String[this.mResult.getMetaData().getColumnCount()];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = this.mResult.getMetaData().getColumnLabel(i);
                }
                return ret;
            }
            catch (SQLException e) {
                log.error((Object)("SQLException:" + Arrays.toString(ret)), (Throwable)e);
                return null;
            }
        }

        @Override
        public boolean moveToFirst() {
            try {
                return this.mResult.next();
            }
            catch (SQLException e) {
                log.error((Object)"SQLException:", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean moveToNext() {
            try {
                return this.mResult.next();
            }
            catch (SQLException e) {
                log.error((Object)"SQLException:", (Throwable)e);
                return false;
            }
        }

        @Override
        public String getString(int pInd) {
            try {
                return this.mResult.getString(pInd + 1);
            }
            catch (SQLException e) {
                log.error((Object)("SQLException:" + pInd), (Throwable)e);
                return null;
            }
        }

        @Override
        public double getDouble(int pInd) {
            try {
                return this.mResult.getDouble(pInd + 1);
            }
            catch (SQLException e) {
                log.error((Object)("SQLException:" + pInd), (Throwable)e);
                return 0.0;
            }
        }

        @Override
        public long getLong(int pInd) {
            try {
                return this.mResult.getLong(pInd + 1);
            }
            catch (SQLException e) {
                log.error((Object)("SQLException:" + pInd), (Throwable)e);
                return 0L;
            }
        }

        @Override
        public int getInt(int pInd) {
            try {
                return this.mResult.getInt(pInd + 1);
            }
            catch (SQLException e) {
                log.error((Object)("SQLException:" + pInd), (Throwable)e);
                return 0;
            }
        }

        @Override
        public byte[] getBlob(int pInd) {
            try {
                return this.mResult.getBytes(pInd + 1);
            }
            catch (SQLException e) {
                log.error((Object)("SQLException:" + pInd), (Throwable)e);
                return null;
            }
        }

        @Override
        public void close() {
            try {
                this.mResult.close();
            }
            catch (SQLException e) {
                log.error((Object)"SQLException:", (Throwable)e);
            }
        }
    }
}

