// This file is generated by kconfig_compiler_kf5 from kopeteappearancesettings.kcfg.
// All changes you do to this file will be lost.
#ifndef KOPETE_APPEARANCESETTINGS_H
#define KOPETE_APPEARANCESETTINGS_H

#include <libkopete_export.h>

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

#include <kstandarddirs.h>
#include <kglobalsettings.h>
#include <kcolorscheme.h>
namespace Kopete {

class LIBKOPETE_EXPORT AppearanceSettings : public KConfigSkeleton
{
  Q_OBJECT
  public:
    class EnumContactListGroupSorting
    {
      public:
      enum type { Manual, Name, COUNT };
    };
    class EnumContactListMetaContactSorting
    {
      public:
      enum type { Manual, Name, Status, COUNT };
    };
    class EnumContactListIconMode
    {
      public:
      enum type { IconPic, IconPhoto, COUNT };
    };
    class EnumContactListResizeAnchor
    {
      public:
      enum type { Top, Bottom, COUNT };
    };

    static AppearanceSettings *self();
    ~AppearanceSettings();

    /**
      Set Enable emoticon support in Kopete.
    */
    static
    void setUseEmoticons( bool v )
    {
      if (v != self()->mUseEmoticons && !self()->isImmutable( QStringLiteral( "useEmoticons" ) )) {
        self()->mUseEmoticons = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
        self()->mSettingsChanged |= signalMessageOverridesChanged;
      }
    }

    /**
      Get Enable emoticon support in Kopete.
    */
    static
    bool useEmoticons()
    {
      return self()->mUseEmoticons;
    }

    /**
      Set Text color used when highlighting.
    */
    static
    void setHighlightForegroundColor( const QColor & v )
    {
      if (v != self()->mHighlightForegroundColor && !self()->isImmutable( QStringLiteral( "highlightForegroundColor" ) )) {
        self()->mHighlightForegroundColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Text color used when highlighting.
    */
    static
    QColor highlightForegroundColor()
    {
      return self()->mHighlightForegroundColor;
    }

    /**
      Set Background color used when highlighting.
    */
    static
    void setHighlightBackgroundColor( const QColor & v )
    {
      if (v != self()->mHighlightBackgroundColor && !self()->isImmutable( QStringLiteral( "highlightBackgroundColor" ) )) {
        self()->mHighlightBackgroundColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Background color used when highlighting.
    */
    static
    QColor highlightBackgroundColor()
    {
      return self()->mHighlightBackgroundColor;
    }

    /**
      Set Disable custom formatting set by users.
    */
    static
    void setChatFmtOverride( bool v )
    {
      if (v != self()->mChatFmtOverride && !self()->isImmutable( QStringLiteral( "chatFmtOverride" ) )) {
        self()->mChatFmtOverride = v;
        self()->mSettingsChanged |= signalMessageOverridesChanged;
      }
    }

    /**
      Get Disable custom formatting set by users.
    */
    static
    bool chatFmtOverride()
    {
      return self()->mChatFmtOverride;
    }

    /**
      Set Chat text color.
    */
    static
    void setChatTextColor( const QColor & v )
    {
      if (v != self()->mChatTextColor && !self()->isImmutable( QStringLiteral( "chatTextColor" ) )) {
        self()->mChatTextColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Chat text color.
    */
    static
    QColor chatTextColor()
    {
      return self()->mChatTextColor;
    }

    /**
      Set Chat background color.
    */
    static
    void setChatBackgroundColor( const QColor & v )
    {
      if (v != self()->mChatBackgroundColor && !self()->isImmutable( QStringLiteral( "chatBackgroundColor" ) )) {
        self()->mChatBackgroundColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Chat background color.
    */
    static
    QColor chatBackgroundColor()
    {
      return self()->mChatBackgroundColor;
    }

    /**
      Set Chat link color.
    */
    static
    void setChatLinkColor( const QColor & v )
    {
      if (v != self()->mChatLinkColor && !self()->isImmutable( QStringLiteral( "chatLinkColor" ) )) {
        self()->mChatLinkColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Chat link color.
    */
    static
    QColor chatLinkColor()
    {
      return self()->mChatLinkColor;
    }

    /**
      Set Whether using the system font for the chat window.
    */
    static
    void setChatFontSelection( int v )
    {
      if (v != self()->mChatFontSelection && !self()->isImmutable( QStringLiteral( "chatFontSelection" ) )) {
        self()->mChatFontSelection = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Whether using the system font for the chat window.
    */
    static
    int chatFontSelection()
    {
      return self()->mChatFontSelection;
    }

    /**
      Set Chat font.
    */
    static
    void setChatFont( const QFont & v )
    {
      if (v != self()->mChatFont && !self()->isImmutable( QStringLiteral( "chatFont" ) )) {
        self()->mChatFont = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Chat font.
    */
    static
    QFont chatFont()
    {
      return self()->mChatFont;
    }

    /**
      Set Color used to identify idle contacts.
    */
    static
    void setIdleContactColor( const QColor & v )
    {
      if (v != self()->mIdleContactColor && !self()->isImmutable( QStringLiteral( "idleContactColor" ) )) {
        self()->mIdleContactColor = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Color used to identify idle contacts.
    */
    static
    QColor idleContactColor()
    {
      return self()->mIdleContactColor;
    }

    /**
      Set Whether to use a different color for idle contacts.
    */
    static
    void setGreyIdleMetaContacts( bool v )
    {
      if (v != self()->mGreyIdleMetaContacts && !self()->isImmutable( QStringLiteral( "greyIdleMetaContacts" ) )) {
        self()->mGreyIdleMetaContacts = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Whether to use a different color for idle contacts.
    */
    static
    bool greyIdleMetaContacts()
    {
      return self()->mGreyIdleMetaContacts;
    }

    /**
      Set Contact properties that contact tooltip will show.
    */
    static
    void setToolTipContents( const QStringList & v )
    {
      if (!self()->isImmutable( QStringLiteral( "toolTipContents" ) ))
        self()->mToolTipContents = v;
    }

    /**
      Get Contact properties that contact tooltip will show.
    */
    static
    QStringList toolTipContents()
    {
      return self()->mToolTipContents;
    }

    /**
      Set Contact list group sorting
    */
    static
    void setContactListGroupSorting( int v )
    {
      if (v != self()->mContactListGroupSorting && !self()->isImmutable( QStringLiteral( "contactListGroupSorting" ) )) {
        self()->mContactListGroupSorting = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Contact list group sorting
    */
    static
    int contactListGroupSorting()
    {
      return self()->mContactListGroupSorting;
    }

    /**
      Set Contact list group sorting
    */
    static
    void setContactListMetaContactSorting( int v )
    {
      if (v != self()->mContactListMetaContactSorting && !self()->isImmutable( QStringLiteral( "contactListMetaContactSorting" ) )) {
        self()->mContactListMetaContactSorting = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Contact list group sorting
    */
    static
    int contactListMetaContactSorting()
    {
      return self()->mContactListMetaContactSorting;
    }

    /**
      Set Contact list icon display mode. Either the protocol icon or the contact photo.
    */
    static
    void setContactListIconMode( int v )
    {
      if (v != self()->mContactListIconMode && !self()->isImmutable( QStringLiteral( "contactListIconMode" ) )) {
        self()->mContactListIconMode = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Contact list icon display mode. Either the protocol icon or the contact photo.
    */
    static
    int contactListIconMode()
    {
      return self()->mContactListIconMode;
    }

    /**
      Set Enable borders on the contact's photo.
    */
    static
    void setContactListIconBorders( bool v )
    {
      if (v != self()->mContactListIconBorders && !self()->isImmutable( QStringLiteral( "contactListIconBorders" ) )) {
        self()->mContactListIconBorders = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Enable borders on the contact's photo.
    */
    static
    bool contactListIconBorders()
    {
      return self()->mContactListIconBorders;
    }

    /**
      Set Round contact photo corners.
    */
    static
    void setContactListIconRounded( bool v )
    {
      if (v != self()->mContactListIconRounded && !self()->isImmutable( QStringLiteral( "contactListIconRounded" ) )) {
        self()->mContactListIconRounded = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Round contact photo corners.
    */
    static
    bool contactListIconRounded()
    {
      return self()->mContactListIconRounded;
    }

    /**
      Set Show contact list as a tree view.
    */
    static
    void setContactListTreeView( bool v )
    {
      if (v != self()->mContactListTreeView && !self()->isImmutable( QStringLiteral( "contactListTreeView" ) )) {
        self()->mContactListTreeView = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Show contact list as a tree view.
    */
    static
    bool contactListTreeView()
    {
      return self()->mContactListTreeView;
    }

    /**
      Set Indent contacts if you do not show tree lines.
    */
    static
    void setContactListIndentContact( bool v )
    {
      if (v != self()->mContactListIndentContact && !self()->isImmutable( QStringLiteral( "contactListIndentContact" ) )) {
        self()->mContactListIndentContact = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Indent contacts if you do not show tree lines.
    */
    static
    bool contactListIndentContact()
    {
      return self()->mContactListIndentContact;
    }

    /**
      Set Hide the vertical scroll bar.
    */
    static
    void setContactListHideVerticalScrollBar( bool v )
    {
      if (v != self()->mContactListHideVerticalScrollBar && !self()->isImmutable( QStringLiteral( "contactListHideVerticalScrollBar" ) )) {
        self()->mContactListHideVerticalScrollBar = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Hide the vertical scroll bar.
    */
    static
    bool contactListHideVerticalScrollBar()
    {
      return self()->mContactListHideVerticalScrollBar;
    }

    /**
      Set Group contacts by group.
    */
    static
    void setGroupContactByGroup( bool v )
    {
      if (v != self()->mGroupContactByGroup && !self()->isImmutable( QStringLiteral( "groupContactByGroup" ) )) {
        self()->mGroupContactByGroup = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Group contacts by group.
    */
    static
    bool groupContactByGroup()
    {
      return self()->mGroupContactByGroup;
    }

    /**
      Set Use custom fonts for contact list.
    */
    static
    void setContactListUseCustomFont( bool v )
    {
      if (v != self()->mContactListUseCustomFont && !self()->isImmutable( QStringLiteral( "contactListUseCustomFont" ) )) {
        self()->mContactListUseCustomFont = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Use custom fonts for contact list.
    */
    static
    bool contactListUseCustomFont()
    {
      return self()->mContactListUseCustomFont;
    }

    /**
      Set Automatically resize the main window.
    */
    static
    void setContactListAutoResize( bool v )
    {
      if (v != self()->mContactListAutoResize && !self()->isImmutable( QStringLiteral( "contactListAutoResize" ) )) {
        self()->mContactListAutoResize = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Automatically resize the main window.
    */
    static
    bool contactListAutoResize()
    {
      return self()->mContactListAutoResize;
    }

    /**
      Set Corner at which to anchor main window when auto-resizing.
    */
    static
    void setContactListResizeAnchor( int v )
    {
      if (v != self()->mContactListResizeAnchor && !self()->isImmutable( QStringLiteral( "contactListResizeAnchor" ) )) {
        self()->mContactListResizeAnchor = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Corner at which to anchor main window when auto-resizing.
    */
    static
    int contactListResizeAnchor()
    {
      return self()->mContactListResizeAnchor;
    }

    /**
      Set Normal font for contact list
    */
    static
    void setContactListNormalFont( const QFont & v )
    {
      if (v != self()->mContactListNormalFont && !self()->isImmutable( QStringLiteral( "contactListNormalFont" ) )) {
        self()->mContactListNormalFont = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Normal font for contact list
    */
    static
    QFont contactListNormalFont()
    {
      return self()->mContactListNormalFont;
    }

    /**
      Set Small font for contact list (for status message)
    */
    static
    void setContactListSmallFont( const QFont & v )
    {
      if (v != self()->mContactListSmallFont && !self()->isImmutable( QStringLiteral( "contactListSmallFont" ) )) {
        self()->mContactListSmallFont = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Small font for contact list (for status message)
    */
    static
    QFont contactListSmallFont()
    {
      return self()->mContactListSmallFont;
    }

    /**
      Set Color for group name.
    */
    static
    void setGroupNameColor( const QColor & v )
    {
      if (v != self()->mGroupNameColor && !self()->isImmutable( QStringLiteral( "groupNameColor" ) )) {
        self()->mGroupNameColor = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Color for group name.
    */
    static
    QColor groupNameColor()
    {
      return self()->mGroupNameColor;
    }

    /**
      Set Animate contact list on contact list changes.
    */
    static
    void setContactListAnimateChange( bool v )
    {
      if (v != self()->mContactListAnimateChange && !self()->isImmutable( QStringLiteral( "contactListAnimateChange" ) )) {
        self()->mContactListAnimateChange = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Animate contact list on contact list changes.
    */
    static
    bool contactListAnimateChange()
    {
      return self()->mContactListAnimateChange;
    }

    /**
      Set Fade-in/Fade-out on contact status changes.
    */
    static
    void setContactListFading( bool v )
    {
      if (v != self()->mContactListFading && !self()->isImmutable( QStringLiteral( "contactListFading" ) )) {
        self()->mContactListFading = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Fade-in/Fade-out on contact status changes.
    */
    static
    bool contactListFading()
    {
      return self()->mContactListFading;
    }

    /**
      Set Fold-in/Fold-out on contact status changes.
    */
    static
    void setContactListFolding( bool v )
    {
      if (v != self()->mContactListFolding && !self()->isImmutable( QStringLiteral( "contactListFolding" ) )) {
        self()->mContactListFolding = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Fold-in/Fold-out on contact status changes.
    */
    static
    bool contactListFolding()
    {
      return self()->mContactListFolding;
    }

    /**
      Set Auto-hide contact list after a while.
    */
    static
    void setContactListAutoHide( bool v )
    {
      if (v != self()->mContactListAutoHide && !self()->isImmutable( QStringLiteral( "contactListAutoHide" ) )) {
        self()->mContactListAutoHide = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Auto-hide contact list after a while.
    */
    static
    bool contactListAutoHide()
    {
      return self()->mContactListAutoHide;
    }

    /**
      Set Auto-hide vertical scrollbar in contact list after a while.
    */
    static
    void setContactListAutoHideVScroll( bool v )
    {
      if (v != self()->mContactListAutoHideVScroll && !self()->isImmutable( QStringLiteral( "contactListAutoHideVScroll" ) )) {
        self()->mContactListAutoHideVScroll = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Auto-hide vertical scrollbar in contact list after a while.
    */
    static
    bool contactListAutoHideVScroll()
    {
      return self()->mContactListAutoHideVScroll;
    }

    /**
      Set Auto-hide timeout
    */
    static
    void setContactListAutoHideTimeout( uint v )
    {
      if (v != self()->mContactListAutoHideTimeout && !self()->isImmutable( QStringLiteral( "contactListAutoHideTimeout" ) )) {
        self()->mContactListAutoHideTimeout = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Auto-hide timeout
    */
    static
    uint contactListAutoHideTimeout()
    {
      return self()->mContactListAutoHideTimeout;
    }

    /**
      Set Show offline users in contact list.
    */
    static
    void setShowOfflineUsers( bool v )
    {
      if (v != self()->mShowOfflineUsers && !self()->isImmutable( QStringLiteral( "showOfflineUsers" ) )) {
        self()->mShowOfflineUsers = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Show offline users in contact list.
    */
    static
    bool showOfflineUsers()
    {
      return self()->mShowOfflineUsers;
    }

    /**
      Set Show empty groups in contact list.
    */
    static
    void setShowEmptyGroups( bool v )
    {
      if (v != self()->mShowEmptyGroups && !self()->isImmutable( QStringLiteral( "showEmptyGroups" ) )) {
        self()->mShowEmptyGroups = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Show empty groups in contact list.
    */
    static
    bool showEmptyGroups()
    {
      return self()->mShowEmptyGroups;
    }

    /**
      Set Show identities in status bar instead of accounts.
    */
    static
    void setShowIdentityIcons( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "showIdentityIcons" ) ))
        self()->mShowIdentityIcons = v;
    }

    /**
      Get Show identities in status bar instead of accounts.
    */
    static
    bool showIdentityIcons()
    {
      return self()->mShowIdentityIcons;
    }

    /**
      Set Show offline users in a separate group.
    */
    static
    void setShowOfflineGrouped( bool v )
    {
      if (v != self()->mShowOfflineGrouped && !self()->isImmutable( QStringLiteral( "showOfflineGrouped" ) )) {
        self()->mShowOfflineGrouped = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Show offline users in a separate group.
    */
    static
    bool showOfflineGrouped()
    {
      return self()->mShowOfflineGrouped;
    }


    enum {
      signalAppearanceChanged = 0x1,
      signalMessageOverridesChanged = 0x2,
      signalContactListAppearanceChanged = 0x4
    };

  Q_SIGNALS:
    /**
      Emitted when the font and colors settings have changed.
    */
    void appearanceChanged();

    /**
      Emitted when the message overrides settings have changed.
    */
    void messageOverridesChanged();

    /**
      Emitted when the contact list appearance has changed.
    */
    void contactListAppearanceChanged();

  private:
    void itemChanged(quint64 flags);

  protected:
    AppearanceSettings();
    friend class AppearanceSettingsHelper;

    bool usrSave() override;

    // Appearance
    bool mUseEmoticons;
    QColor mHighlightForegroundColor;
    QColor mHighlightBackgroundColor;
    bool mChatFmtOverride;
    QColor mChatTextColor;
    QColor mChatBackgroundColor;
    QColor mChatLinkColor;
    int mChatFontSelection;
    QFont mChatFont;
    QColor mIdleContactColor;
    bool mGreyIdleMetaContacts;
    QStringList mToolTipContents;

    // ContactList
    int mContactListGroupSorting;
    int mContactListMetaContactSorting;
    int mContactListIconMode;
    bool mContactListIconBorders;
    bool mContactListIconRounded;
    bool mContactListTreeView;
    bool mContactListIndentContact;
    bool mContactListHideVerticalScrollBar;
    bool mGroupContactByGroup;
    bool mContactListUseCustomFont;
    bool mContactListAutoResize;
    int mContactListResizeAnchor;
    QFont mContactListNormalFont;
    QFont mContactListSmallFont;
    QColor mGroupNameColor;
    bool mContactListAnimateChange;
    bool mContactListFading;
    bool mContactListFolding;
    bool mContactListAutoHide;
    bool mContactListAutoHideVScroll;
    uint mContactListAutoHideTimeout;
    bool mShowOfflineUsers;
    bool mShowEmptyGroups;
    bool mShowIdentityIcons;
    bool mShowOfflineGrouped;

  private:
    uint mSettingsChanged;
};

}

#endif

