// Copyright (c) 2019 Ultimaker B.V.
// Cura is released under the terms of the LGPLv3 or higher.

import QtQuick 2.10
import QtQuick.Controls 2.3

import UM 1.3 as UM
import Cura 1.1 as Cura


Cura.MachineAction
{
    UM.I18nCatalog { id: catalog; name: "cura"; }
    anchors.fill: parent

    Item
    {
        id: upgradeSelectionMachineAction
        anchors.fill: parent
        anchors.topMargin: UM.Theme.getSize("default_margin").width * 5
        anchors.leftMargin: UM.Theme.getSize("default_margin").width * 4

        Label
        {
            id: pageDescription
            anchors.top: parent.top
            anchors.topMargin: UM.Theme.getSize("default_margin").height
            width: parent.width
            wrapMode: Text.WordWrap
            text: catalog.i18nc("@label", "Please select any upgrades made to this Ultimaker 2.")
            font: UM.Theme.getFont("medium")
            color: UM.Theme.getColor("text")
            renderType: Text.NativeRendering
        }

        Cura.CheckBox
        {
            id: olssonBlockCheckBox
            anchors.top: pageDescription.bottom
            anchors.topMargin: UM.Theme.getSize("default_margin").height

            height: UM.Theme.getSize("setting_control").height

            text: catalog.i18nc("@label", "Olsson Block")
            checked: manager.hasVariants
            onClicked: manager.hasVariants = checked

            Connections
            {
                target: manager
                onHasVariantsChanged: olssonBlockCheckBox.checked = manager.hasVariants
            }
        }
    }
}
