/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.container.initialization;

import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.container.initialization.AbstractCoreComponentInitializationPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;

public class InitializeLoggerManagerPhase
extends AbstractCoreComponentInitializationPhase {
    @Override
    public void initializeCoreComponent(ContainerInitializationContext context) throws ContainerInitializationException {
        LoggerManager loggerManager = context.getContainer().getLoggerManager();
        if (loggerManager == null) {
            try {
                loggerManager = context.getContainer().lookup(LoggerManager.class);
            }
            catch (ComponentLookupException e) {
                ComponentDescriptor cd = new ComponentDescriptor();
                cd.setRole(LoggerManager.ROLE);
                cd.setRoleHint("default");
                cd.setImplementation(ConsoleLoggerManager.class.getName());
                try {
                    context.getContainer().addComponentDescriptor(cd);
                }
                catch (CycleDetectedInComponentGraphException cre) {
                    throw new ContainerInitializationException("Error setting up logging manager.", cre);
                }
                loggerManager = new ConsoleLoggerManager("info");
            }
            context.getContainer().setLoggerManager(loggerManager);
        }
        Logger logger = loggerManager.getLoggerForComponent(PlexusContainer.class.getName());
        context.getContainer().enableLogging(logger);
    }
}

