/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.initialization.ProjectAccessListener;

class TasksFromProjectDependencies
extends AbstractTaskDependency {
    private final String taskName;
    private final DependencySet dependencies;
    private final ProjectAccessListener projectAccessListener;

    public TasksFromProjectDependencies(String taskName, DependencySet dependencies, ProjectAccessListener projectAccessListener) {
        this.taskName = taskName;
        this.dependencies = dependencies;
        this.projectAccessListener = projectAccessListener;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.resolveProjectDependencies(context, (Set<ProjectDependency>)this.dependencies.withType(ProjectDependency.class));
    }

    void resolveProjectDependencies(TaskDependencyResolveContext context, Set<ProjectDependency> projectDependencies) {
        for (ProjectDependency projectDependency : projectDependencies) {
            this.projectAccessListener.beforeResolvingProjectDependency((ProjectInternal)projectDependency.getDependencyProject());
            Task nextTask = (Task)projectDependency.getDependencyProject().getTasks().findByName(this.taskName);
            if (nextTask == null) continue;
            context.add((Object)nextTask);
        }
    }

    public String getTaskName() {
        return this.taskName;
    }
}

