/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.internal.Try;

public class TransformationChain
implements Transformation {
    private final Transformation first;
    private final Transformation second;
    private final int stepsCount;

    public TransformationChain(Transformation first, Transformation second) {
        this.first = first;
        this.second = second;
        this.stepsCount = first.stepsCount() + second.stepsCount();
    }

    @Override
    public boolean endsWith(Transformation otherTransform) {
        int otherStepsCount = otherTransform.stepsCount();
        if (otherStepsCount > this.stepsCount) {
            return false;
        }
        if (otherStepsCount == 1) {
            return this.second == otherTransform;
        }
        TransformationChain otherChain = (TransformationChain)otherTransform;
        if (otherChain.second != this.second) {
            return false;
        }
        return this.first.endsWith(otherChain.first);
    }

    @Override
    public int stepsCount() {
        return this.stepsCount;
    }

    @Override
    public Try<TransformationSubject> transform(TransformationSubject subjectToTransform, ExecutionGraphDependenciesResolver dependenciesResolver) {
        return this.first.transform(subjectToTransform, dependenciesResolver).flatMap(intermediateSubject -> this.second.transform((TransformationSubject)intermediateSubject, dependenciesResolver));
    }

    @Override
    public boolean requiresDependencies() {
        return this.first.requiresDependencies() || this.second.requiresDependencies();
    }

    public String getDisplayName() {
        return this.first.getDisplayName() + " -> " + this.second.getDisplayName();
    }

    @Override
    public void visitTransformationSteps(Action<? super TransformationStep> action) {
        this.first.visitTransformationSteps(action);
        this.second.visitTransformationSteps(action);
    }
}

