/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.configuration.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.configuration.internal.BuildCacheServiceRegistration;
import org.gradle.caching.configuration.internal.DefaultBuildCacheServiceRegistration;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildCacheConfiguration
implements BuildCacheConfigurationInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildCacheConfiguration.class);
    private final Instantiator instantiator;
    private BuildCache local;
    private BuildCache remote;
    private final Set<BuildCacheServiceRegistration> registrations;

    public DefaultBuildCacheConfiguration(Instantiator instantiator, List<BuildCacheServiceRegistration> allBuiltInBuildCacheServices) {
        this.instantiator = instantiator;
        this.registrations = Sets.newHashSet(allBuiltInBuildCacheServices);
        this.local = DefaultBuildCacheConfiguration.createLocalCacheConfiguration(instantiator, DirectoryBuildCache.class, this.registrations);
    }

    public BuildCache getLocal() {
        return this.local;
    }

    public <T extends BuildCache> T local(Class<T> type) {
        return this.local(type, Actions.doNothing());
    }

    public <T extends BuildCache> T local(Class<T> type, Action<? super T> configuration) {
        if (!type.isInstance(this.local)) {
            if (this.local != null) {
                LOGGER.info("Replacing local build cache type {} with {}", (Object)this.local.getClass().getCanonicalName(), (Object)type.getCanonicalName());
            }
            this.local = DefaultBuildCacheConfiguration.createLocalCacheConfiguration(this.instantiator, type, this.registrations);
        }
        BuildCache configurationObject = (BuildCache)Cast.uncheckedCast((Object)this.local);
        configuration.execute((Object)configurationObject);
        return (T)configurationObject;
    }

    public void local(Action<? super BuildCache> configuration) {
        configuration.execute((Object)this.local);
    }

    public BuildCache getRemote() {
        return this.remote;
    }

    public <T extends BuildCache> T remote(Class<T> type) {
        return this.remote(type, Actions.doNothing());
    }

    public <T extends BuildCache> T remote(Class<T> type, Action<? super T> configuration) {
        if (!type.isInstance(this.remote)) {
            if (this.remote != null) {
                LOGGER.info("Replacing remote build cache type {} with {}", (Object)this.remote.getClass().getCanonicalName(), (Object)type.getCanonicalName());
            }
            this.remote = DefaultBuildCacheConfiguration.createRemoteCacheConfiguration(this.instantiator, type, this.registrations);
        }
        BuildCache configurationObject = (BuildCache)Cast.uncheckedCast((Object)this.remote);
        configuration.execute((Object)configurationObject);
        return (T)configurationObject;
    }

    public void remote(Action<? super BuildCache> configuration) {
        if (this.remote == null) {
            throw new IllegalStateException("A type for the remote build cache must be configured first.");
        }
        configuration.execute((Object)this.remote);
    }

    private static <T extends BuildCache> T createLocalCacheConfiguration(Instantiator instantiator, Class<T> type, Set<BuildCacheServiceRegistration> registrations) {
        T local = DefaultBuildCacheConfiguration.createBuildCacheConfiguration(instantiator, type, registrations);
        local.setPush(true);
        return local;
    }

    private static <T extends BuildCache> T createRemoteCacheConfiguration(Instantiator instantiator, Class<T> type, Set<BuildCacheServiceRegistration> registrations) {
        T remote = DefaultBuildCacheConfiguration.createBuildCacheConfiguration(instantiator, type, registrations);
        remote.setPush(false);
        return remote;
    }

    private static <T extends BuildCache> T createBuildCacheConfiguration(Instantiator instantiator, Class<T> type, Set<BuildCacheServiceRegistration> registrations) {
        DefaultBuildCacheConfiguration.getBuildCacheServiceFactoryType(type, registrations);
        return (T)((BuildCache)instantiator.newInstance(type, new Object[0]));
    }

    public <T extends BuildCache> void registerBuildCacheService(Class<T> configurationType, Class<? extends BuildCacheServiceFactory<? super T>> buildCacheServiceFactoryType) {
        Preconditions.checkNotNull(configurationType, (Object)"configurationType cannot be null.");
        Preconditions.checkNotNull(buildCacheServiceFactoryType, (Object)"buildCacheServiceFactoryType cannot be null.");
        this.registrations.add(new DefaultBuildCacheServiceRegistration(configurationType, buildCacheServiceFactoryType));
    }

    @Override
    public <T extends BuildCache> Class<? extends BuildCacheServiceFactory<T>> getBuildCacheServiceFactoryType(Class<T> configurationType) {
        return DefaultBuildCacheConfiguration.getBuildCacheServiceFactoryType(configurationType, this.registrations);
    }

    private static <T extends BuildCache> Class<? extends BuildCacheServiceFactory<T>> getBuildCacheServiceFactoryType(Class<T> configurationType, Set<BuildCacheServiceRegistration> registrations) {
        for (BuildCacheServiceRegistration registration : registrations) {
            Class<? extends BuildCache> registeredConfigurationType = registration.getConfigurationType();
            if (!registeredConfigurationType.isAssignableFrom(configurationType)) continue;
            Class<? extends BuildCacheServiceFactory<?>> buildCacheServiceFactoryType = registration.getFactoryType();
            LOGGER.debug("Found {} registered for {}", buildCacheServiceFactoryType, registeredConfigurationType);
            return (Class)Cast.uncheckedCast(buildCacheServiceFactoryType);
        }
        throw new GradleException("Build cache type '" + configurationType.getName() + "' has not been registered.");
    }
}

