/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.simpleframework.transport.Negotiation;
import org.simpleframework.transport.Negotiator;
import org.simpleframework.transport.SecureTransport;
import org.simpleframework.transport.Status;
import org.simpleframework.transport.Task;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.TransportException;

class Handshake
implements Negotiation {
    private final Negotiator negotiator;
    private final SocketChannel channel;
    private final Transport transport;
    private final ByteBuffer output;
    private final ByteBuffer input;
    private final ByteBuffer empty;
    private final SSLEngine engine;

    public Handshake(Transport transport, Negotiator negotiator) {
        this(transport, negotiator, 20480);
    }

    public Handshake(Transport transport, Negotiator negotiator, int size) {
        this.output = ByteBuffer.allocate(size);
        this.input = ByteBuffer.allocate(size);
        this.channel = transport.getChannel();
        this.engine = transport.getEngine();
        this.empty = ByteBuffer.allocate(0);
        this.negotiator = negotiator;
        this.transport = transport;
    }

    public SelectableChannel getChannel() {
        return this.channel;
    }

    public void run() {
        if (this.engine != null) {
            this.engine.setUseClientMode(false);
            this.input.flip();
        }
        this.begin();
    }

    public void cancel() {
        try {
            this.transport.close();
        }
        catch (Exception e) {
            return;
        }
    }

    private void begin() {
        try {
            this.resume();
        }
        catch (Exception e) {
            return;
        }
    }

    public void resume() throws IOException {
        Runnable task = this.process();
        if (task != null) {
            task.run();
        }
    }

    private Runnable process() throws IOException {
        Status require = this.exchange();
        if (require == Status.CLIENT) {
            return new Client(this);
        }
        if (require == Status.SERVER) {
            return new Server(this);
        }
        return new Done(this);
    }

    private Status exchange() throws IOException {
        SSLEngineResult.HandshakeStatus status = this.engine.getHandshakeStatus();
        switch (status) {
            case NEED_WRAP: {
                return this.write();
            }
            case NOT_HANDSHAKING: 
            case NEED_UNWRAP: {
                return this.read();
            }
        }
        return Status.DONE;
    }

    private Status read() throws IOException {
        return this.read(5);
    }

    private Status read(int count) throws IOException {
        while (count > 0) {
            SSLEngineResult result = this.engine.unwrap(this.input, this.output);
            SSLEngineResult.HandshakeStatus status = result.getHandshakeStatus();
            switch (status) {
                case NOT_HANDSHAKING: {
                    return Status.DONE;
                }
                case NEED_WRAP: {
                    return Status.SERVER;
                }
                case NEED_UNWRAP: 
                case FINISHED: {
                    return this.read(count - 1);
                }
                case NEED_TASK: {
                    this.execute();
                }
            }
        }
        return Status.CLIENT;
    }

    private Status write() throws IOException {
        return this.write(5);
    }

    private Status write(int count) throws IOException {
        while (count > 0) {
            SSLEngineResult result = this.engine.wrap(this.empty, this.output);
            SSLEngineResult.HandshakeStatus status = result.getHandshakeStatus();
            switch (status) {
                case NOT_HANDSHAKING: 
                case NEED_UNWRAP: 
                case FINISHED: {
                    return Status.SERVER;
                }
                case NEED_WRAP: {
                    return this.write(count - 1);
                }
                case NEED_TASK: {
                    this.execute();
                }
            }
        }
        return Status.SERVER;
    }

    private void execute() throws IOException {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
    }

    public boolean receive() throws IOException {
        int size;
        int count = this.input.capacity();
        if (count > 0) {
            this.input.compact();
        }
        if ((size = this.channel.read(this.input)) < 0) {
            throw new TransportException("Client closed connection");
        }
        if (count > 0) {
            this.input.flip();
        }
        return size > 0;
    }

    public boolean send() throws IOException {
        int size;
        int require = this.output.position();
        int count = 0;
        if (require > 0) {
            this.output.flip();
        }
        while (count < require && (size = this.channel.write(this.output)) > 0) {
            count += size;
        }
        if (require > 0) {
            this.output.compact();
        }
        return count == require;
    }

    public void commit() throws IOException {
        SecureTransport secure = new SecureTransport(this.transport, this.output, this.input);
        if (this.negotiator != null) {
            this.negotiator.process(secure);
        }
    }

    private class Server
    extends Task {
        public Server(Negotiation state) {
            super(state, Handshake.this.negotiator, 4);
        }

        protected boolean ready() throws IOException {
            return this.state.send();
        }
    }

    private class Client
    extends Task {
        public Client(Negotiation state) {
            super(state, Handshake.this.negotiator, 1);
        }

        protected boolean ready() throws IOException {
            return this.state.receive();
        }
    }

    private class Done
    extends Task {
        public Done(Negotiation state) {
            super(state, Handshake.this.negotiator, 1);
        }

        public void execute() throws IOException {
            this.state.commit();
        }
    }
}

