/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.collect.ImmutableCollection;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.Task;
import org.gradle.api.internal.changedetection.changes.ChangesOnlyIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.StatefulIncrementalTaskInputs;
import org.gradle.api.internal.project.taskfactory.StandardTaskAction;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.change.Change;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaMethod;

class IncrementalTaskAction
extends StandardTaskAction
implements ContextAwareTaskAction {
    private final Instantiator instantiator;
    private TaskExecutionContext context;

    public IncrementalTaskAction(Instantiator instantiator, Class<? extends Task> type, Method method) {
        super(type, method);
        this.instantiator = instantiator;
    }

    @Override
    public void contextualise(TaskExecutionContext context) {
        this.context = context;
    }

    @Override
    public void releaseContext() {
        this.context = null;
    }

    @Override
    protected void doExecute(final Task task, String methodName) {
        IncrementalTaskInputs incrementalInputs = this.context.getExecutionStateChanges().map(new Function<ExecutionStateChanges, StatefulIncrementalTaskInputs>(){

            @Override
            public StatefulIncrementalTaskInputs apply(ExecutionStateChanges changes) {
                return changes.isRebuildRequired() ? IncrementalTaskAction.this.createRebuildInputs(task) : IncrementalTaskAction.this.createIncrementalInputs(changes.getInputFilesChanges());
            }
        }).orElseGet(new Supplier<StatefulIncrementalTaskInputs>(){

            @Override
            public StatefulIncrementalTaskInputs get() {
                return IncrementalTaskAction.this.createRebuildInputs(task);
            }
        });
        this.context.setTaskExecutedIncrementally(incrementalInputs.isIncremental());
        JavaMethod.of((Object)task, Object.class, (String)methodName, (Class[])new Class[]{IncrementalTaskInputs.class}).invoke((Object)task, new Object[]{incrementalInputs});
    }

    private ChangesOnlyIncrementalTaskInputs createIncrementalInputs(Iterable<Change> inputFilesChanges) {
        return (ChangesOnlyIncrementalTaskInputs)this.instantiator.newInstance(ChangesOnlyIncrementalTaskInputs.class, new Object[]{inputFilesChanges});
    }

    private RebuildIncrementalTaskInputs createRebuildInputs(Task task) {
        ImmutableCollection currentInputs = this.context.getBeforeExecutionState().get().getInputFileProperties().values();
        return (RebuildIncrementalTaskInputs)this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{task, currentInputs});
    }
}

