/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.AbstractWorker;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerServer;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerFactory;

public class NoIsolationWorkerFactory
implements WorkerFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker workTracker;
    private final InstantiatorFactory instantiatorFactory;
    private Instantiator actionInstantiator;
    private WorkerExecutor workerExecutor;

    public NoIsolationWorkerFactory(BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker workTracker, InstantiatorFactory instantiatorFactory) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.workTracker = workTracker;
        this.instantiatorFactory = instantiatorFactory;
    }

    public void setWorkerExecutor(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        DefaultServiceRegistry services = new DefaultServiceRegistry();
        services.add(WorkerExecutor.class, (Object)workerExecutor);
        this.actionInstantiator = this.instantiatorFactory.inject((ServiceLookup)services);
    }

    @Override
    public Worker getWorker(DaemonForkOptions forkOptions) {
        final WorkerExecutor workerExecutor = this.workerExecutor;
        return new AbstractWorker(this.buildOperationExecutor){

            @Override
            public DefaultWorkResult execute(ActionExecutionSpec spec, BuildOperationRef parentBuildOperation) {
                return this.executeWrappedInBuildOperation(spec, parentBuildOperation, new AbstractWorker.Work(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public DefaultWorkResult execute(ActionExecutionSpec spec) {
                        DefaultWorkResult result;
                        try {
                            DefaultWorkerServer workerServer = new DefaultWorkerServer(NoIsolationWorkerFactory.this.actionInstantiator);
                            result = workerServer.execute(spec);
                        }
                        finally {
                            workerExecutor.await();
                        }
                        return result;
                    }
                });
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.NONE;
    }
}

