/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javaslang.collection.HashMap;
import javaslang.collection.Map;
import javaslang.collection.Traversable;

final class Collections {
    public static <T, C, R extends Iterable<T>> Map<C, R> groupBy(Traversable<T> collection, Function<? super T, ? extends C> classifier2, Function<? super Iterable<T>, R> mapper) {
        Objects.requireNonNull(collection, "collection is null");
        Objects.requireNonNull(classifier2, "classifier is null");
        Objects.requireNonNull(mapper, "mapper is null");
        java.util.HashMap<Object, Collection> mutableResults = new java.util.HashMap<Object, Collection>();
        for (Object value : collection) {
            C key = classifier2.apply(value);
            mutableResults.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
        Map results = HashMap.empty();
        for (Map.Entry entry : mutableResults.entrySet()) {
            results = results.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return results;
    }

    static boolean equals(Iterable<?> iterable1, Iterable<?> iterable2) {
        Iterator<?> iter1 = iterable1.iterator();
        Iterator<?> iter2 = iterable2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (Objects.equals(iter1.next(), iter2.next())) continue;
            return false;
        }
        return iter1.hasNext() == iter2.hasNext();
    }

    static int hash(Iterable<?> iterable) {
        int hashCode = 1;
        for (Object o : iterable) {
            hashCode = 31 * hashCode + Objects.hashCode(o);
        }
        return hashCode;
    }

    static <T, U, C extends Iterable<U>, R extends Traversable<U>> R scanLeft(Iterable<? extends T> elements, U zero, BiFunction<? super U, ? super T, ? extends U> operation, C cumulativeResult, BiFunction<C, U, C> combiner, Function<C, R> finisher) {
        U acc = zero;
        cumulativeResult = (Iterable)combiner.apply(cumulativeResult, acc);
        for (T a : elements) {
            acc = operation.apply(acc, a);
            cumulativeResult = (Iterable)combiner.apply(cumulativeResult, acc);
        }
        return (R)((Traversable)finisher.apply(cumulativeResult));
    }
}

