/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCodegen;
import org.jetbrains.kotlin.backend.jvm.JvmLower;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmBackend;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/JvmCodegen;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "Lorg/jetbrains/kotlin/backend/jvm/JvmLower;", "generateFile", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend"})
public final class JvmBackend {
    private final JvmLower lower;
    private final JvmCodegen codegen;
    @NotNull
    private final JvmBackendContext context;

    public final void generateFile(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        List extensions = IrGenerationExtension.Companion.getInstances(this.context.getState().getProject());
        Iterable $receiver$iv = extensions;
        for (Object element$iv : $receiver$iv) {
            IrGenerationExtension it = (IrGenerationExtension)element$iv;
            it.generate(irFile, this.context, this.context.getState().getBindingContext());
        }
        this.lower.lower(irFile);
        for (IrDeclaration loweredClass : irFile.getDeclarations()) {
            if (!(loweredClass instanceof IrClass)) {
                throw (Throwable)((Object)new AssertionError((Object)("File-level declaration should be IrClass after JvmLower, got: " + RenderIrElementKt.render(loweredClass))));
            }
            this.codegen.generateClass((IrClass)loweredClass);
        }
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public JvmBackend(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.lower = new JvmLower(this.context);
        this.codegen = new JvmCodegen(this.context);
    }
}

