/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.diff;

import gnu.trove.TIntIntHashMap;
import org.jetbrains.kotlin.com.intellij.util.IntIntFunction;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

class UniqueLCS {
    private final int[] myFirst;
    private final int[] mySecond;
    private final int myStart1;
    private final int myStart2;
    private final int myCount1;
    private final int myCount2;

    UniqueLCS(int[] first2, int[] second, int start1, int count1, int start2, int count2) {
        this.myFirst = first2;
        this.mySecond = second;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myCount1 = count1;
        this.myCount2 = count2;
    }

    public int[][] execute() {
        TIntIntHashMap map2 = new TIntIntHashMap(this.myCount1 + this.myCount2);
        int[] match2 = new int[this.myCount1];
        for (int i = 0; i < this.myCount1; ++i) {
            int index2 = this.myStart1 + i;
            int val = map2.get(this.myFirst[index2]);
            if (val == -1) continue;
            if (val == 0) {
                map2.put(this.myFirst[index2], i + 1);
                continue;
            }
            map2.put(this.myFirst[index2], -1);
        }
        int count2 = 0;
        for (int i = 0; i < this.myCount2; ++i) {
            int index3 = this.myStart2 + i;
            int val = map2.get(this.mySecond[index3]);
            if (val == 0 || val == -1) continue;
            if (match2[val - 1] == 0) {
                match2[val - 1] = i + 1;
                ++count2;
                continue;
            }
            match2[val - 1] = 0;
            map2.put(this.mySecond[index3], -1);
            --count2;
        }
        if (count2 == 0) {
            return null;
        }
        int[] sequence2 = new int[count2];
        int[] lastElement = new int[count2];
        int[] predecessor = new int[this.myCount1];
        int length = 0;
        for (int i = 0; i < this.myCount1; ++i) {
            int j;
            if (match2[i] == 0 || (j = UniqueLCS.binarySearch(sequence2, match2[i], length)) != length && match2[i] >= sequence2[j]) continue;
            sequence2[j] = match2[i];
            lastElement[j] = i;
            int n = predecessor[i] = j > 0 ? lastElement[j - 1] : -1;
            if (j != length) continue;
            ++length;
        }
        int[][] ret = new int[][]{new int[length], new int[length]};
        int i = length - 1;
        int curr = lastElement[length - 1];
        while (curr != -1) {
            ret[0][i] = curr;
            ret[1][i] = match2[curr] - 1;
            --i;
            curr = predecessor[curr];
        }
        return ret;
    }

    private static int binarySearch(final int[] sequence2, final int val, int length) {
        int i = ObjectUtils.binarySearch(0, length, new IntIntFunction(){

            @Override
            public int fun(int middle) {
                return sequence2[middle] <= val ? -1 : 1;
            }
        });
        int r = -i - 1;
        return r;
    }
}

