/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;

public class ResizeableMappedFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.ResizeableMappedFile");
    private long myLogicalSize;
    private long myLastWrittenLogicalSize;
    private final PagedFileStorage myStorage;
    private final int myInitialSize;
    private int myRoundFactor;

    public ResizeableMappedFile(@NotNull File file2, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(0);
        }
        this(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned, false);
    }

    public ResizeableMappedFile(@NotNull File file2, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(1);
        }
        this.myRoundFactor = 4096;
        this.myStorage = new PagedFileStorage(file2, lockContext, pageSize, valuesAreBufferAligned, nativeBytesOrder);
        this.myInitialSize = initialSize;
        this.myLastWrittenLogicalSize = this.myLogicalSize = this.readLength();
    }

    public long length() {
        return this.myLogicalSize;
    }

    private long realSize() {
        return this.myStorage.length();
    }

    void ensureSize(long pos) {
        this.myLogicalSize = Math.max(pos, this.myLogicalSize);
        this.expand(pos);
    }

    public void setRoundFactor(int roundFactor) {
        this.myRoundFactor = roundFactor;
    }

    private void expand(long max) {
        long suggestedSize;
        long realSize = this.realSize();
        if (max <= realSize) {
            return;
        }
        if (realSize == 0L) {
            suggestedSize = this.myInitialSize;
        } else {
            suggestedSize = Math.max(realSize + 1L, 2L);
            while (max > suggestedSize) {
                long newSuggestedSize = suggestedSize * 13L >> 3;
                if (newSuggestedSize >= Integer.MAX_VALUE) {
                    suggestedSize += suggestedSize / 5L;
                    continue;
                }
                suggestedSize = newSuggestedSize;
            }
            int roundFactor = this.myRoundFactor;
            if (suggestedSize % (long)roundFactor != 0L) {
                suggestedSize = (suggestedSize / (long)roundFactor + 1L) * (long)roundFactor;
            }
        }
        try {
            this.myStorage.resize(suggestedSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getLengthFile() {
        return new File(this.myStorage.getFile().getPath() + ".len");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLength(long len) {
        final File lengthFile = this.getLengthFile();
        FilterOutputStream stream2 = null;
        try {
            stream2 = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<DataOutputStream, IOException>(){
                boolean parentWasCreated;

                @Override
                @Nullable
                public DataOutputStream execute(boolean lastAttempt) throws IOException {
                    try {
                        return new DataOutputStream(new FileOutputStream(lengthFile));
                    }
                    catch (FileNotFoundException ex) {
                        File parentFile = lengthFile.getParentFile();
                        if (!parentFile.exists()) {
                            if (!this.parentWasCreated) {
                                parentFile.mkdirs();
                                this.parentWasCreated = true;
                            } else {
                                throw new IOException("Parent file still doesn't exist:" + lengthFile);
                            }
                        }
                        if (!lastAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
            if (stream2 != null) {
                ((java.io.DataOutputStream)stream2).writeLong(len);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        finally {
            if (stream2 != null) {
                try {
                    stream2.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    public boolean isDirty() {
        return this.myStorage.isDirty();
    }

    public void force() {
        if (this.isDirty() && this.myLastWrittenLogicalSize != this.myLogicalSize) {
            this.writeLength(this.myLogicalSize);
            this.myLastWrittenLogicalSize = this.myLogicalSize;
        }
        this.myStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLength() {
        File lengthFile = this.getLengthFile();
        FilterInputStream stream2 = null;
        try {
            stream2 = new DataInputStream(new FileInputStream(lengthFile));
            long l = ((DataInputStream)stream2).readLong();
            return l;
        }
        catch (FileNotFoundException ignore) {
            long l = 0L;
            return l;
        }
        catch (IOException e) {
            long realSize = this.realSize();
            this.writeLength(realSize);
            long l = realSize;
            return l;
        }
        finally {
            if (stream2 != null) {
                try {
                    stream2.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    public int getInt(long index2) {
        return this.myStorage.getInt(index2);
    }

    public void putInt(long index2, int value) {
        this.ensureSize(index2 + 4L);
        this.myStorage.putInt(index2, value);
    }

    public long getLong(long index2) {
        return this.myStorage.getLong(index2);
    }

    public void putLong(long index2, long value) {
        this.ensureSize(index2 + 8L);
        this.myStorage.putLong(index2, value);
    }

    public byte get(long index2) {
        return this.myStorage.get(index2);
    }

    public void get(long index2, byte[] dst, int offset2, int length) {
        this.myStorage.get(index2, dst, offset2, length);
    }

    public void put(long index2, byte[] src, int offset2, int length) {
        this.ensureSize(index2 + (long)length);
        this.myStorage.put(index2, src, offset2, length);
    }

    public void close() {
        try {
            this.force();
        }
        finally {
            this.myStorage.close();
        }
    }

    @NotNull
    public PagedFileStorage getPagedFileStorage() {
        PagedFileStorage pagedFileStorage = this.myStorage;
        if (pagedFileStorage == null) {
            ResizeableMappedFile.$$$reportNull$$$0(2);
        }
        return pagedFileStorage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/ResizeableMappedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/ResizeableMappedFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPagedFileStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

