/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.expressions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012\u001a0\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0007*\u0002H\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u0016H\u0086\b\u00a2\u0006\u0002\u0010\u0017\u001a2\u0010\u0018\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0007*\u0002H\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0016H\u0086\b\u00a2\u0006\u0002\u0010\u0017\u001a8\u0010\u0019\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0007*\u0002H\u00142\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001aH\u0086\b\u00a2\u0006\u0002\u0010\u001b\u001a7\u0010\u001c\u001a\u00020\u0006*\u00020\u00072\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\u0016H\u0086\b\u001a\u001c\u0010 \u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\u0010\u001a\u0012\u0010\"\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006#"}, d2={"typeParametersCount", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getTypeParametersCount", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)I", "copyTypeArgumentsFrom", "", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "other", "getTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrType;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getTypeArgumentOrDefault", "Lorg/jetbrains/kotlin/types/KotlinType;", "getValueArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "mapTypeParameters", "T", "transform", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "mapValueParameters", "mapValueParametersIndexed", "Lkotlin/Function2;", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "putTypeArguments", "typeArguments", "", "toIrType", "putValueArgument", "valueArgument", "removeValueArgument", "ir.tree"})
public final class IrMemberAccessExpressionKt {
    @Nullable
    public static final IrType getTypeArgument(@NotNull IrMemberAccessExpression $receiver, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
        return $receiver.getTypeArgument(typeParameterDescriptor.getIndex());
    }

    /*
     * WARNING - void declaration
     */
    public static final void copyTypeArgumentsFrom(@NotNull IrMemberAccessExpression $receiver, @NotNull IrMemberAccessExpression other) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int n2 = n = $receiver.getTypeArgumentsCount() == other.getTypeArgumentsCount() ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Mismatching type arguments: " + $receiver.getTypeArgumentsCount() + " vs " + other.getTypeArgumentsCount() + ' ';
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = 0;
        int n3 = $receiver.getTypeArgumentsCount();
        while (n < n3) {
            void i;
            $receiver.putTypeArgument((int)i, other.getTypeArgument((int)i));
            ++i;
        }
    }

    public static final void putTypeArguments(@NotNull IrMemberAccessExpression $receiver, @Nullable Map<TypeParameterDescriptor, ? extends KotlinType> typeArguments2, @NotNull Function1<? super KotlinType, ? extends IrType> toIrType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(toIrType, (String)"toIrType");
        if (typeArguments2 == null) {
            return;
        }
        Map<TypeParameterDescriptor, ? extends KotlinType> map2 = typeArguments2;
        Iterator<Map.Entry<TypeParameterDescriptor, ? extends KotlinType>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<TypeParameterDescriptor, ? extends KotlinType> entry;
            Map.Entry<TypeParameterDescriptor, ? extends KotlinType> entry2 = entry = iterator2.next();
            TypeParameterDescriptor typeParameter = entry2.getKey();
            entry2 = entry;
            KotlinType typeArgument = entry2.getValue();
            $receiver.putTypeArgument(typeParameter.getIndex(), (IrType)toIrType.invoke((Object)typeArgument));
        }
    }

    public static final int getTypeParametersCount(@NotNull CallableDescriptor $receiver) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        CallableDescriptor callableDescriptor = $receiver;
        if (callableDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor2 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"correspondingProperty");
            n = propertyDescriptor2.getTypeParameters().size();
        } else {
            n = $receiver.getTypeParameters().size();
        }
        return n;
    }

    @NotNull
    public static final KotlinType getTypeArgumentOrDefault(@NotNull IrMemberAccessExpression $receiver, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
        Object object = IrMemberAccessExpressionKt.getTypeArgument($receiver, typeParameterDescriptor);
        if (object == null || (object = IrTypesKt.toKotlinType((IrType)object)) == null) {
            SimpleType simpleType2 = typeParameterDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"typeParameterDescriptor.defaultType");
            object = simpleType2;
        }
        return object;
    }

    @Nullable
    public static final IrExpression getValueArgument(@NotNull IrMemberAccessExpression $receiver, @NotNull ValueParameterDescriptor valueParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)valueParameterDescriptor, (String)"valueParameterDescriptor");
        return $receiver.getValueArgument(valueParameterDescriptor.getIndex());
    }

    public static final void putValueArgument(@NotNull IrMemberAccessExpression $receiver, @NotNull ValueParameterDescriptor valueParameterDescriptor, @Nullable IrExpression valueArgument) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)valueParameterDescriptor, (String)"valueParameterDescriptor");
        $receiver.putValueArgument(valueParameterDescriptor.getIndex(), valueArgument);
    }

    public static final void removeValueArgument(@NotNull IrMemberAccessExpression $receiver, @NotNull ValueParameterDescriptor valueParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)valueParameterDescriptor, (String)"valueParameterDescriptor");
        $receiver.removeValueArgument(valueParameterDescriptor.getIndex());
    }

    @NotNull
    public static final <T extends IrMemberAccessExpression> T mapTypeParameters(@NotNull T $receiver, @NotNull Function1<? super TypeParameterDescriptor, ? extends IrType> transform2) {
        T t;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(transform2, (String)"transform");
        T $receiver2 = t = $receiver;
        List<TypeParameterDescriptor> list2 = $receiver2.getDescriptor().getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.typeParameters");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            TypeParameterDescriptor it;
            TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"it");
            $receiver2.putTypeArgument(typeParameterDescriptor.getIndex(), (IrType)transform2.invoke((Object)it));
        }
        return t;
    }

    @NotNull
    public static final <T extends IrMemberAccessExpression> T mapValueParameters(@NotNull T $receiver, @NotNull Function1<? super ValueParameterDescriptor, ? extends IrExpression> transform2) {
        T t;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(transform2, (String)"transform");
        T $receiver2 = t = $receiver;
        List<ValueParameterDescriptor> list2 = $receiver2.getDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            int n = it.getIndex();
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
            $receiver2.putValueArgument(n, (IrExpression)transform2.invoke((Object)valueParameterDescriptor));
        }
        return t;
    }

    @NotNull
    public static final <T extends IrMemberAccessExpression> T mapValueParametersIndexed(@NotNull T $receiver, @NotNull Function2<? super Integer, ? super ValueParameterDescriptor, ? extends IrExpression> transform2) {
        T t;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(transform2, (String)"transform");
        T $receiver2 = t = $receiver;
        List<ValueParameterDescriptor> list2 = $receiver2.getDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            int n = it.getIndex();
            Integer n2 = it.getIndex();
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
            $receiver2.putValueArgument(n, (IrExpression)transform2.invoke((Object)n2, (Object)valueParameterDescriptor));
        }
        return t;
    }
}

