/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.impl.IrTypeBaseKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementVisitor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u001a\f\u0010\b\u001a\u00020\u0004*\u00020\tH\u0000\u001a\f\u0010\n\u001a\u00020\u0004*\u00020\u000bH\u0000\u001a\n\u0010\f\u001a\u00020\u0004*\u00020\r\u001a\n\u0010\f\u001a\u00020\u0004*\u00020\u000e\u001a\f\u0010\f\u001a\u00020\u0004*\u00020\u000fH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0004*\u00020\tH\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000bH\u0000\u001a\f\u0010\u0013\u001a\u00020\u0004*\u00020\tH\u0000\u001a\f\u0010\u0014\u001a\u00020\u0004*\u00020\u0015H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0004*\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"DECLARATION_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "REFERENCE_RENDERER", "renderTypeAnnotations", "", "annotations", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "name", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ref", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "render", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "renderDeclared", "renderDescriptor", "descriptor", "renderOriginIfNonTrivial", "renderTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "renderTypeInner", "ir.tree"})
public final class RenderIrElementKt {
    private static final DescriptorRenderer DECLARATION_RENDERER = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)DECLARATION_RENDERER.1.INSTANCE));
    private static final DescriptorRenderer REFERENCE_RENDERER = DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES;

    @NotNull
    public static final String render(@NotNull IrElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return (String)$receiver.accept(new RenderIrElementVisitor(), null);
    }

    @NotNull
    public static final String name(@NotNull IrDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getDescriptor().getName().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.name.toString()");
        return string;
    }

    @NotNull
    public static final String renderDescriptor(@NotNull DescriptorRenderer $receiver, @NotNull DeclarationDescriptor descriptor2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof ReceiverParameterDescriptor) {
            StringBuilder stringBuilder = new StringBuilder().append("this@");
            DeclarationDescriptor declarationDescriptor = ((ReceiverParameterDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            string = stringBuilder.append(declarationDescriptor.getName()).append(": ").append(((ReceiverParameterDescriptor)descriptor2).getType()).toString();
        } else {
            string = $receiver.render(descriptor2);
        }
        return string;
    }

    @NotNull
    public static final String renderDeclared(@NotNull IrDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return RenderIrElementKt.renderDescriptor(DECLARATION_RENDERER, $receiver.getDescriptor());
    }

    @NotNull
    public static final String ref(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        DeclarationDescriptor declarationDescriptor = $receiver.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"this.original");
        return RenderIrElementKt.renderDescriptor(REFERENCE_RENDERER, declarationDescriptor);
    }

    @NotNull
    public static final String render(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return DECLARATION_RENDERER.renderType($receiver);
    }

    @NotNull
    public static final String renderOriginIfNonTrivial(@NotNull IrDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Intrinsics.areEqual((Object)$receiver.getOrigin(), (Object)IrDeclarationOrigin.DEFINED.INSTANCE) ^ true ? $receiver.getOrigin().toString() + " " : "";
    }

    @NotNull
    public static final String renderTypeInner(@NotNull IrType $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        IrType irType = $receiver;
        if (irType instanceof IrDynamicType) {
            object = "dynamic";
        } else if (irType instanceof IrErrorType) {
            object = "ERROR";
        } else if (irType instanceof IrSimpleType) {
            StringBuilder stringBuilder;
            StringBuilder $receiver2 = stringBuilder = new StringBuilder();
            $receiver2.append(DECLARATION_RENDERER.renderClassifierName(((IrSimpleType)$receiver).getClassifier().getDescriptor()));
            Collection collection = ((IrSimpleType)$receiver).getArguments();
            if (!collection.isEmpty()) {
                collection = renderTypeInner.1.1.INSTANCE;
                CharSequence charSequence = null;
                int n = 0;
                CharSequence charSequence2 = ", ";
                CharSequence charSequence3 = ">";
                CharSequence charSequence4 = "<";
                $receiver2.append(CollectionsKt.joinToString$default((Iterable)((IrSimpleType)$receiver).getArguments(), (CharSequence)charSequence2, (CharSequence)charSequence4, (CharSequence)charSequence3, (int)n, charSequence, (Function1)collection, (int)24, null));
            }
            if (((IrSimpleType)$receiver).getHasQuestionMark()) {
                $receiver2.append('?');
            }
            String string = stringBuilder.toString();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            Object object2;
            Object it;
            object = IrTypeBaseKt.getOriginalKotlinType($receiver);
            if (object == null || (object = DECLARATION_RENDERER.renderType((KotlinType)(it = (object2 = object)))) == null) {
                object = "IrType without originalKotlinType: " + $receiver;
            }
        }
        return object;
    }

    private static final String renderTypeArgument(@NotNull IrTypeArgument $receiver) {
        String string;
        IrTypeArgument irTypeArgument = $receiver;
        if (irTypeArgument instanceof IrStarProjection) {
            string = "*";
        } else if (irTypeArgument instanceof IrTypeProjection) {
            StringBuilder stringBuilder;
            StringBuilder $receiver2 = stringBuilder = new StringBuilder();
            $receiver2.append(((IrTypeProjection)$receiver).getVariance().getLabel());
            if (((IrTypeProjection)$receiver).getVariance() != Variance.INVARIANT) {
                $receiver2.append(' ');
            }
            $receiver2.append(RenderIrElementKt.render(((IrTypeProjection)$receiver).getType()));
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string = "IrTypeArgument[" + $receiver + ']';
        }
        return string;
    }

    @NotNull
    public static final String renderTypeAnnotations(@NotNull List<? extends IrCall> annotations2) {
        String string;
        Intrinsics.checkParameterIsNotNull(annotations2, (String)"annotations");
        if (annotations2.isEmpty()) {
            string = "";
        } else {
            Function1 function1 = renderTypeAnnotations.1.INSTANCE;
            CharSequence charSequence = null;
            int n = 0;
            CharSequence charSequence2 = " ";
            CharSequence charSequence3 = " ";
            CharSequence charSequence4 = "";
            string = CollectionsKt.joinToString$default((Iterable)annotations2, (CharSequence)charSequence2, (CharSequence)charSequence4, (CharSequence)charSequence3, (int)n, charSequence, (Function1)function1, (int)24, null);
        }
        return string;
    }

    @NotNull
    public static final String render(@NotNull IrType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return RenderIrElementKt.renderTypeAnnotations($receiver.getAnnotations()) + RenderIrElementKt.renderTypeInner($receiver);
    }

    public static final /* synthetic */ String access$renderTypeArgument(IrTypeArgument $receiver) {
        return RenderIrElementKt.renderTypeArgument($receiver);
    }
}

