/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return Path.class.isAssignableFrom(type);
    }

    public Path fromString(String str) {
        try {
            URI uri = new URI(str);
            if (uri.getScheme() == null) {
                return Paths.get(str, new String[0]);
            }
            return Paths.get(uri);
        }
        catch (URISyntaxException e) {
            return Paths.get(str, new String[0]);
        }
    }

    public String toString(Object obj) {
        Path path = (Path)obj;
        if (path.getFileSystem() == FileSystems.getDefault()) {
            String localPath = path.toString();
            if (File.separatorChar != '/') {
                return localPath.replace(File.separatorChar, '/');
            }
            return localPath;
        }
        return path.toUri().toString();
    }
}

