/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.lib.profiler.results.locks.AbstractLockDataFrameProcessor;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public class CPUSamplingDataFrameProcessor
extends AbstractLockDataFrameProcessor {
    private String currentThreadName;
    private String currentThreadClassName;
    private long currentTimestamp;
    private Map<Integer, ThreadInfo> currentThreadsDump;
    private Map<Integer, ThreadInfo> lastThreadsDump;
    private List<ThreadDump> threadDumps = new ArrayList<ThreadDump>();
    private MethodNameFormatter formatter = MethodNameFormatterFactory.getDefault(new DefaultMethodNameFormatter(4)).getFormatter();
    private StackTraceSnapshotBuilder builder;

    @Override
    public void doProcessDataFrame(ByteBuffer byteBuffer) {
        JMethodIdTable jMethodIdTable = JMethodIdTable.getDefault();
        this.threadDumps = new ArrayList<ThreadDump>();
        block14: while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            switch (by) {
                case 31: {
                    this.currentThreadsDump = new HashMap<Integer, ThreadInfo>();
                    this.currentTimestamp = CPUSamplingDataFrameProcessor.getTimeStamp(byteBuffer);
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block14;
                    LOGGER.finest("Thread dump start: Timestamps:" + this.currentTimestamp);
                    continue block14;
                }
                case 11: {
                    char c = byteBuffer.getChar();
                    String string = CPUSamplingDataFrameProcessor.getString(byteBuffer);
                    String string2 = CPUSamplingDataFrameProcessor.getString(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Creating new thread: tId=" + c + " name=" + string);
                    }
                    this.currentThreadId = c;
                    this.currentThreadName = string;
                    this.currentThreadClassName = string2;
                    this.fireNewThread(c, string, string2);
                    continue block14;
                }
                case 13: {
                    this.currentThreadId = byteBuffer.getChar();
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block14;
                    LOGGER.log(Level.FINEST, "Change current thread , tId={0}", this.currentThreadId);
                    continue block14;
                }
                case 33: {
                    char c = byteBuffer.getChar();
                    Integer n = c;
                    ThreadInfo threadInfo = this.lastThreadsDump.get(n);
                    assert (threadInfo != null);
                    this.currentThreadsDump.put(n, threadInfo);
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block14;
                    LOGGER.finest("Thread info identical: tId:" + c);
                    continue block14;
                }
                case 34: {
                    int n;
                    char c = byteBuffer.getChar();
                    byte by2 = byteBuffer.get();
                    int n2 = byteBuffer.getChar();
                    int[] nArray = new int[n2];
                    for (n = 0; n < n2; ++n) {
                        nArray[n] = byteBuffer.getInt();
                        jMethodIdTable.checkMethodId(nArray[n]);
                    }
                    ThreadInfo threadInfo = this.currentThreadId == c ? new ThreadInfo(this.currentThreadName, c, by2, nArray) : new ThreadInfo(null, c, by2, nArray);
                    this.currentThreadsDump.put(Integer.valueOf(c), threadInfo);
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block14;
                    LOGGER.finest("Thread info: tId:" + c + " state:" + by2 + " mIds:" + Arrays.toString(nArray));
                    continue block14;
                }
                case 32: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Thread dump end");
                    }
                    this.lastThreadsDump = this.currentThreadsDump;
                    this.threadDumps.add(new ThreadDump(this.currentTimestamp, this.currentThreadsDump));
                    continue block14;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    this.builder.reset();
                    continue block14;
                }
                case 28: {
                    int n = byteBuffer.getInt();
                    String string = CPUSamplingDataFrameProcessor.getString(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new monitor , monitorId={0} , className={1}", new Object[]{Integer.toHexString(n), string});
                    }
                    this.fireNewMonitor(n, string);
                    continue block14;
                }
                case 22: 
                case 23: {
                    int n;
                    long l = CPUSamplingDataFrameProcessor.getTimeStamp(byteBuffer);
                    long l2 = -1L;
                    int n3 = byteBuffer.getInt();
                    if (by == 22) {
                        n = byteBuffer.getInt();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Monitor entry , tId={0} , monitorId={1} , ownerId={2}", new Object[]{this.currentThreadId, Integer.toHexString(n3), n});
                        }
                        this.fireMonitorEntry(this.currentThreadId, l, l2, n3, n);
                    }
                    if (by != 23) continue block14;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Monitor exit , tId={0} , monitorId={1}", new Object[]{this.currentThreadId, Integer.toHexString(n3)});
                    }
                    this.fireMonitorExit(this.currentThreadId, l, l2, n3);
                    continue block14;
                }
                case 5: {
                    long l;
                    long l3 = CPUSamplingDataFrameProcessor.getTimeStamp(byteBuffer);
                    long l4 = l = this.collectingTwoTimeStamps ? CPUSamplingDataFrameProcessor.getTimeStamp(byteBuffer) : 0L;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Adjust time , tId={0}", this.currentThreadId);
                    }
                    this.fireAdjustTime(this.currentThreadId, l3, l);
                    continue block14;
                }
            }
            LOGGER.log(Level.SEVERE, "*** Profiler Engine: internal error: got unknown event type in CPUSamplingDataFrameProcessor: {0} at {1}", new Object[]{(int)by, byteBuffer.position()});
        }
        try {
            jMethodIdTable.getNamesForMethodIds(this.client);
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            ProfilerLogger.log(targetAppOrVMTerminated.getMessage());
            return;
        }
        this.processCollectedDumps(jMethodIdTable, this.threadDumps);
        this.threadDumps.clear();
    }

    @Override
    public void startup(ProfilerClient profilerClient) {
        final CPUCallGraphBuilder[] cPUCallGraphBuilderArray = new CPUCallGraphBuilder[1];
        super.startup(profilerClient);
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                if (profilingResultListener instanceof CPUCallGraphBuilder) {
                    cPUCallGraphBuilderArray[0] = (CPUCallGraphBuilder)profilingResultListener;
                }
            }
        });
        this.builder = new StackTraceSnapshotBuilder(cPUCallGraphBuilderArray[0], profilerClient.getSettings().getInstrumentationFilter(), profilerClient.getStatus());
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.builder = null;
    }

    private static Thread.State getThreadState(int n) {
        switch (n) {
            case -1: {
                return Thread.State.TERMINATED;
            }
            case 0: {
                return Thread.State.TERMINATED;
            }
            case 1: {
                return Thread.State.RUNNABLE;
            }
            case 2: {
                return Thread.State.TIMED_WAITING;
            }
            case 3: {
                return Thread.State.BLOCKED;
            }
            case 4: 
            case 5: {
                return Thread.State.WAITING;
            }
        }
        return Thread.State.TERMINATED;
    }

    private void processCollectedDumps(JMethodIdTable jMethodIdTable, List<ThreadDump> list) {
        HashMap<Integer, StackTraceElement> hashMap = new HashMap<Integer, StackTraceElement>();
        InstrumentationFilter instrumentationFilter = this.builder.getFilter();
        for (ThreadDump threadDump : list) {
            StackTraceSnapshotBuilder.SampledThreadInfo[] sampledThreadInfoArray = new StackTraceSnapshotBuilder.SampledThreadInfo[threadDump.threadDumps.length];
            int n = 0;
            for (ThreadInfo threadInfo : threadDump.threadDumps) {
                int[] nArray = threadInfo.methodsIds;
                StackTraceElement[] stackTraceElementArray = new StackTraceElement[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    int n2 = nArray[i];
                    StackTraceElement stackTraceElement = (StackTraceElement)hashMap.get(n2);
                    if (stackTraceElement == null) {
                        JMethodIdTable.JMethodIdTableEntry jMethodIdTableEntry = jMethodIdTable.getEntry(n2);
                        String string = this.formatter.formatMethodName(jMethodIdTableEntry.className, jMethodIdTableEntry.methodName, jMethodIdTableEntry.methodSig).toFormatted();
                        String string2 = jMethodIdTableEntry.className.replace('/', '.');
                        String string3 = string + '|' + jMethodIdTableEntry.methodSig;
                        stackTraceElement = new StackTraceElement(string2, string3, null, jMethodIdTableEntry.isNative ? -2 : -1);
                        hashMap.put(n2, stackTraceElement);
                    }
                    stackTraceElementArray[i] = stackTraceElement;
                }
                sampledThreadInfoArray[n++] = new StackTraceSnapshotBuilder.SampledThreadInfo(threadInfo.threadName, threadInfo.threadId, threadInfo.state, stackTraceElementArray, instrumentationFilter);
            }
            this.builder.addStacktrace(sampledThreadInfoArray, threadDump.timestamp);
        }
    }

    private static final class ThreadDump {
        private long timestamp;
        private ThreadInfo[] threadDumps;

        ThreadDump(long l, Map<Integer, ThreadInfo> map) {
            this.timestamp = l;
            this.threadDumps = map.values().toArray(new ThreadInfo[0]);
        }
    }

    private static final class ThreadInfo {
        private int[] methodsIds;
        private Thread.State state;
        private String threadName;
        private long threadId;

        ThreadInfo(String string, long l, byte by, int[] nArray) {
            this.threadName = string;
            this.threadId = l;
            this.state = CPUSamplingDataFrameProcessor.getThreadState(by);
            this.methodsIds = nArray;
        }
    }
}

