/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.AddStatement;
import com.mysql.cj.api.xdevapi.BaseSession;
import com.mysql.cj.api.xdevapi.Collection;
import com.mysql.cj.api.xdevapi.CreateCollectionIndexStatement;
import com.mysql.cj.api.xdevapi.DatabaseObject;
import com.mysql.cj.api.xdevapi.DropCollectionIndexStatement;
import com.mysql.cj.api.xdevapi.FindStatement;
import com.mysql.cj.api.xdevapi.ModifyStatement;
import com.mysql.cj.api.xdevapi.RemoveStatement;
import com.mysql.cj.api.xdevapi.Schema;
import com.mysql.cj.core.exceptions.AssertionFailedException;
import com.mysql.cj.core.exceptions.FeatureNotAvailableException;
import com.mysql.cj.x.core.MysqlxSession;
import com.mysql.cj.xdevapi.AddStatementImpl;
import com.mysql.cj.xdevapi.CreateCollectionIndexStatementImpl;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DropCollectionIndexStatementImpl;
import com.mysql.cj.xdevapi.ExprUnparser;
import com.mysql.cj.xdevapi.FindStatementImpl;
import com.mysql.cj.xdevapi.JsonParser;
import com.mysql.cj.xdevapi.ModifyStatementImpl;
import com.mysql.cj.xdevapi.RemoveStatementImpl;
import com.mysql.cj.xdevapi.SchemaImpl;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;

public class CollectionImpl
implements Collection {
    private MysqlxSession mysqlxSession;
    private SchemaImpl schema;
    private String name;

    CollectionImpl(MysqlxSession mysqlxSession, SchemaImpl schema, String name) {
        this.mysqlxSession = mysqlxSession;
        this.schema = schema;
        this.name = name;
    }

    @Override
    public BaseSession getSession() {
        return this.schema.getSession();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseObject.DbObjectStatus existsInDatabase() {
        if (this.mysqlxSession.tableExists(this.schema.getName(), this.name)) {
            return DatabaseObject.DbObjectStatus.EXISTS;
        }
        return DatabaseObject.DbObjectStatus.NOT_EXISTS;
    }

    @Override
    public AddStatement add(Map<String, ?> doc) {
        throw new FeatureNotAvailableException("TODO: ");
    }

    @Override
    public AddStatement add(String ... jsonString) {
        try {
            DbDoc[] docs = new DbDoc[jsonString.length];
            for (int i = 0; i < jsonString.length; ++i) {
                docs[i] = JsonParser.parseDoc(new StringReader(jsonString[i]));
            }
            return this.add(docs);
        }
        catch (IOException ex) {
            throw AssertionFailedException.shouldNotHappen(ex);
        }
    }

    @Override
    public AddStatement add(DbDoc doc) {
        return new AddStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, doc);
    }

    @Override
    public AddStatement add(DbDoc ... docs) {
        return new AddStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, docs);
    }

    @Override
    public FindStatement find() {
        return this.find(null);
    }

    @Override
    public FindStatement find(String searchCondition) {
        return new FindStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, searchCondition);
    }

    @Override
    public ModifyStatement modify() {
        return this.modify(null);
    }

    @Override
    public ModifyStatement modify(String searchCondition) {
        return new ModifyStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, searchCondition);
    }

    @Override
    public RemoveStatement remove() {
        return this.remove(null);
    }

    @Override
    public RemoveStatement remove(String searchCondition) {
        return new RemoveStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, searchCondition);
    }

    @Override
    public CreateCollectionIndexStatement createIndex(String indexName, boolean isUnique) {
        return new CreateCollectionIndexStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, indexName, isUnique);
    }

    @Override
    public DropCollectionIndexStatement dropIndex(String indexName) {
        return new DropCollectionIndexStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, indexName);
    }

    @Override
    public long count() {
        return this.mysqlxSession.tableCount(this.schema.getName(), this.name);
    }

    @Override
    public DbDoc newDoc() {
        return new DbDoc();
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == CollectionImpl.class && ((CollectionImpl)other).schema.equals(this.schema) && ((CollectionImpl)other).mysqlxSession == this.mysqlxSession && this.name.equals(((CollectionImpl)other).name);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Collection(");
        sb.append(ExprUnparser.quoteIdentifier(this.schema.getName()));
        sb.append(".");
        sb.append(ExprUnparser.quoteIdentifier(this.name));
        sb.append(")");
        return sb.toString();
    }
}

