/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredObjectPropertyAxiomGenerator;

public class InferredObjectPropertyCharacteristicAxiomGenerator
extends InferredObjectPropertyAxiomGenerator<OWLObjectPropertyCharacteristicAxiom> {
    @Override
    protected void addAxioms(OWLObjectProperty entity, OWLReasoner reasoner, @Nonnull OWLDataFactory df, Set<OWLObjectPropertyCharacteristicAxiom> result, Set<OWLObjectPropertyExpression> nonSimpleProperties) {
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLSymmetricObjectPropertyAxiom(entity), reasoner, result);
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLReflexiveObjectPropertyAxiom(entity), reasoner, result);
        if (this.simple(nonSimpleProperties, entity)) {
            InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLFunctionalObjectPropertyAxiom(entity), reasoner, result);
            InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLInverseFunctionalObjectPropertyAxiom(entity), reasoner, result);
            InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLAsymmetricObjectPropertyAxiom(entity), reasoner, result);
            InferredObjectPropertyCharacteristicAxiomGenerator.addTransitiveAxiomIfEntailed(entity, reasoner, df, result);
            InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLIrreflexiveObjectPropertyAxiom(entity), reasoner, result);
        }
    }

    protected static void addTransitiveAxiomIfEntailed(@Nonnull OWLObjectProperty p, OWLReasoner r, OWLDataFactory df, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        OWLTransitiveObjectPropertyAxiom axiom = df.getOWLTransitiveObjectPropertyAxiom(p);
        if (r.isEntailmentCheckingSupported(axiom.getAxiomType()) && r.isEntailed(axiom) && !InferredObjectPropertyCharacteristicAxiomGenerator.triviallyTransitiveCheck(p, r, df)) {
            result.add(axiom);
        }
    }

    private static boolean triviallyTransitiveCheck(@Nonnull OWLObjectProperty property, OWLReasoner reasoner, OWLDataFactory df) {
        OWLObjectSomeValuesFrom chain = df.getOWLObjectSomeValuesFrom(property, df.getOWLObjectSomeValuesFrom(property, df.getOWLThing()));
        return !reasoner.isSatisfiable(chain);
    }

    protected static void addIfEntailed(OWLObjectPropertyCharacteristicAxiom axiom, OWLReasoner reasoner, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        if (reasoner.isEntailmentCheckingSupported(axiom.getAxiomType()) && reasoner.isEntailed(axiom)) {
            result.add(axiom);
        }
    }

    @Override
    public String getLabel() {
        return "Object property characteristics";
    }
}

