/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharFormatter;

class CppCharFormatter
implements CharFormatter {
    CppCharFormatter() {
    }

    @Override
    public String escapeChar(int n, boolean bl) {
        switch (n) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return "\\'";
            }
            case 34: {
                return "\\\"";
            }
        }
        if (n < 32 || n > 126) {
            if (n > 255) {
                Object object = Integer.toString(n, 16);
                while (((String)object).length() < 4) {
                    object = "0" + (String)object;
                }
                return "\\u" + (String)object;
            }
            return "\\" + Integer.toString(n, 8);
        }
        return String.valueOf((char)n);
    }

    @Override
    public String escapeString(String string) {
        Object object = new String();
        for (int i = 0; i < string.length(); ++i) {
            object = (String)object + this.escapeChar(string.charAt(i), false);
        }
        return object;
    }

    @Override
    public String literalChar(int n) {
        String string = "0x" + Integer.toString(n, 16);
        if (n >= 0 && n <= 126) {
            string = string + " /* '" + this.escapeChar(n, true) + "' */ ";
        }
        return string;
    }

    @Override
    public String literalString(String string) {
        return "\"" + this.escapeString(string) + "\"";
    }
}

