/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import org.testng.IClass;
import org.testng.IModuleFactory;
import org.testng.ITestContext;
import org.testng.TestClass;
import org.testng.annotations.Guice;
import org.testng.collections.Lists;
import org.testng.internal.ClassImpl;
import org.testng.internal.annotations.AnnotationHelper;

class GuiceHelper {
    private final ITestContext context;

    GuiceHelper(ITestContext iTestContext) {
        this.context = iTestContext;
    }

    Injector getInjector(IClass iClass) {
        Guice guice = AnnotationHelper.findAnnotationSuperClasses(Guice.class, iClass.getRealClass());
        if (guice == null) {
            return null;
        }
        if (iClass instanceof TestClass) {
            iClass = ((TestClass)iClass).getIClass();
        }
        if (!(iClass instanceof ClassImpl)) {
            return null;
        }
        Guice guice2 = guice;
        Injector injector = ((ClassImpl)iClass).getParentInjector();
        List<Module> list = Lists.newArrayList(this.getModules(guice2, injector, iClass.getRealClass()));
        Injector injector2 = this.context.getInjector(list);
        if (injector2 == null) {
            injector2 = injector.createChildInjector(list);
            this.context.addInjector(list, injector2);
        }
        return injector2;
    }

    private List<Module> getModules(Guice guice, Injector injector, Class<?> clazz) {
        IModuleFactory iModuleFactory;
        Module module;
        List<Module> list = Lists.newArrayList();
        for (Class<? extends Module> clazz2 : guice.modules()) {
            List<Module> list2 = this.context.getGuiceModules(clazz2);
            if (list2 != null && !list2.isEmpty()) {
                list.addAll(list2);
                continue;
            }
            Module module2 = (Module)injector.getInstance(clazz2);
            list.add(module2);
            this.context.getGuiceModules(clazz2).add(module2);
        }
        Class<? extends IModuleFactory> clazz3 = guice.moduleFactory();
        if (clazz3 != IModuleFactory.class && (module = (iModuleFactory = (IModuleFactory)injector.getInstance(clazz3)).createModule(this.context, clazz)) != null) {
            list.add(module);
        }
        return list;
    }
}

