/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Graph;

public class Tarjan<T> {
    int m_index = 0;
    private Stack<T> m_s;
    Map<T, Integer> m_indices = Maps.newHashMap();
    Map<T, Integer> m_lowlinks = Maps.newHashMap();
    private List<T> m_cycle;

    public Tarjan(Graph<T> graph, T t) {
        this.m_s = new Stack();
        this.run(graph, t);
    }

    private void run(Graph<T> graph, T t) {
        this.m_indices.put(t, this.m_index);
        this.m_lowlinks.put(t, this.m_index);
        ++this.m_index;
        this.m_s.push(t);
        for (T t2 : graph.getPredecessors(t)) {
            if (!this.m_indices.containsKey(t2)) {
                this.run(graph, t2);
                int n = Math.min(this.m_lowlinks.get(t), this.m_lowlinks.get(t2));
                this.m_lowlinks.put(t, n);
                continue;
            }
            if (!this.m_s.contains(t2)) continue;
            this.m_lowlinks.put(t, Math.min(this.m_lowlinks.get(t), this.m_indices.get(t2)));
        }
        if (Objects.equals(this.m_lowlinks.get(t), this.m_indices.get(t))) {
            Iterator<T> iterator;
            this.m_cycle = Lists.newArrayList();
            do {
                iterator = this.m_s.pop();
                this.m_cycle.add(iterator);
            } while (!iterator.equals(t));
        }
    }

    public List<T> getCycle() {
        return this.m_cycle;
    }
}

