/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import gnu.trove.list.array.TIntArrayList;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.osmand.Location;
import net.osmand.data.LatLon;
import net.osmand.data.PointDescription;
import net.osmand.data.QuadRect;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.render.OsmandRenderer;
import net.osmand.plus.render.RenderingIcons;
import net.osmand.plus.routing.RouteCalculationResult;
import net.osmand.plus.routing.RouteDirectionInfo;
import net.osmand.plus.routing.RoutingHelper;
import net.osmand.plus.views.OsmandMapLayer;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.ui.ColorUtils;
import net.sourceforge.offroad.ui.IContextMenuProvider;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.PorterDuffMultiplyFilter;

public class RouteLayer
extends OsmandMapLayer
implements IContextMenuProvider {
    private OsmBitmapPanel view;
    private final RoutingHelper helper;
    private List<Location> points = new ArrayList<Location>();
    private List<Location> actionPoints = new ArrayList<Location>();
    private BasicStroke paint;
    private BasicStroke actionPaint;
    private BasicStroke paint2;
    private boolean isPaint2;
    private BasicStroke shadowPaint;
    private boolean isShadowPaint;
    private BasicStroke paint_1;
    private boolean isPaint_1;
    private BasicStroke paintIcon;
    private BasicStroke paintIconAction;
    private Graphics2D gpaint;
    private Graphics2D gactionPaint;
    private Graphics2D gpaint2;
    private Graphics2D gshadowPaint;
    private Graphics2D gpaint_1;
    private Graphics2D gpaintIcon;
    private Graphics2D gpaintIconAction;
    private int cachedHash;
    private Path2D path;
    private BufferedImage coloredArrowUp;
    private BufferedImage actionArrow;
    private OsmandRenderer osmandRenderer;

    public RouteLayer(RoutingHelper helper) {
        this.helper = helper;
    }

    private void initUI() {
        this.paint = new BasicStroke(0.0f, 1, 1, 0.0f);
        this.actionArrow = this.readImage("map_action_arrow", this.view);
        this.actionPaint = new BasicStroke(7.0f * this.view.getScaleCoefficient(), 0, 1, 0.0f);
        this.path = new Path2D.Double();
        this.paintIcon = new BasicStroke(3.0f);
        this.paintIconAction = new BasicStroke();
    }

    @Override
    public void initLayer(OsmBitmapPanel view) {
        this.view = view;
        this.osmandRenderer = view.getContext().getResourceManager().getRenderer().getRenderer();
        this.initUI();
    }

    public void updateLayerStyle() {
        this.cachedHash = -1;
    }

    private void updatePaints(Graphics2D pGraphics2d, OsmandMapLayer.DrawSettings nightMode, RotatedTileBox tileBox) {
        boolean isNight;
        RenderingRulesStorage rrs = this.view.getContext().getRenderingRulesStorage();
        int hsh = this.calculateHash(rrs, isNight = nightMode != null && nightMode.isNightMode(), tileBox.getMapDensity());
        if (hsh != this.cachedHash && rrs != null) {
            RenderingRuleSearchRequest req = new RenderingRuleSearchRequest(rrs);
            req.setBooleanFilter(rrs.PROPS.R_NIGHT_MODE, isNight);
            this.gpaint = this.view.createGraphics(pGraphics2d);
            this.gactionPaint = this.view.createGraphics(pGraphics2d);
            this.gpaintIcon = this.view.createGraphics(pGraphics2d);
            this.gpaintIcon.setColor(Color.black);
            this.gpaintIconAction = this.view.createGraphics(pGraphics2d);
            this.gpaint2 = this.view.createGraphics(pGraphics2d);
            this.gpaint_1 = this.view.createGraphics(pGraphics2d);
            this.gshadowPaint = this.view.createGraphics(pGraphics2d);
            if (req.searchRenderingAttribute("route")) {
                BasicStroke bstroke;
                OsmandRenderer.RenderingContext rc = new OsmandRenderer.RenderingContext();
                rc.setDensityValue((float)tileBox.getMapDensity());
                this.gpaint.setStroke(this.paint);
                this.osmandRenderer.updatePaint(req, this.gpaint, 0, false, rc);
                Stroke stroke = this.gpaint.getStroke();
                if (stroke instanceof BasicStroke && (bstroke = (BasicStroke)stroke).getLineWidth() == 0.0f) {
                    this.gpaint.setStroke(this.deriveStroke(stroke, 12.0f * this.view.getDensity()));
                }
                this.gactionPaint.setStroke(this.actionPaint);
                this.osmandRenderer.updatePaint(req, this.gactionPaint, 2, false, rc);
                Color color2 = this.gactionPaint.getColor();
                this.gpaintIconAction.setComposite(new PorterDuffMultiplyFilter(color2));
                this.isPaint2 = this.osmandRenderer.updatePaint(req, this.gpaint2, 1, false, rc);
                this.isPaint_1 = this.osmandRenderer.updatePaint(req, this.gpaint_1, -1, false, rc);
                this.isShadowPaint = req.isSpecified(rrs.PROPS.R_SHADOW_RADIUS);
                if (this.isShadowPaint) {
                    this.gshadowPaint.setComposite(AlphaComposite.getInstance(5));
                    this.gshadowPaint.setColor(ColorUtils.create(req.getIntPropertyValue(rrs.PROPS.R_SHADOW_COLOR)));
                    this.gshadowPaint.setStroke(this.deriveStroke(this.gshadowPaint.getStroke(), 12.0f * this.view.getDensity()));
                    if (stroke instanceof BasicStroke) {
                        BasicStroke bstroke2 = (BasicStroke)stroke;
                        this.gshadowPaint.setStroke(this.deriveStroke(this.gshadowPaint.getStroke(), bstroke2.getLineWidth() + 2.0f * rc.getComplexValue(req, rrs.PROPS.R_SHADOW_RADIUS)));
                    }
                }
            } else {
                System.err.println("Rendering attribute route is not found !");
                this.gpaint.setStroke(this.deriveStroke(this.gpaint.getStroke(), 12.0f * this.view.getDensity()));
            }
            this.gactionPaint.setStroke(this.deriveStroke(this.gactionPaint.getStroke(), 7.0f * this.view.getScaleCoefficient()));
        }
    }

    public Stroke deriveStroke(Stroke pStroke, float newWidth) {
        if (pStroke instanceof BasicStroke) {
            BasicStroke bstroke = (BasicStroke)pStroke;
            return new BasicStroke(newWidth, bstroke.getEndCap(), bstroke.getLineJoin(), bstroke.getMiterLimit(), bstroke.getDashArray(), bstroke.getDashPhase());
        }
        return pStroke;
    }

    private int calculateHash(Object ... o) {
        return Arrays.hashCode(o);
    }

    @Override
    public void onPrepareBufferImage(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
        this.path.reset();
        if (this.isRouteReady()) {
            RotatedTileBox cp;
            this.updatePaints(canvas, settings, tileBox);
            if (this.coloredArrowUp == null) {
                BufferedImage originalArrowUp;
                this.coloredArrowUp = originalArrowUp = RenderingIcons.getIcon("arrow", true);
            }
            int w = tileBox.getPixWidth();
            int h = tileBox.getPixHeight();
            Location lastProjection = this.helper.getLastProjection();
            if (lastProjection != null && tileBox.containsLatLon(lastProjection.getLatitude(), lastProjection.getLongitude())) {
                cp = tileBox.copy();
                cp.increasePixelDimensions(w / 2, h);
            } else {
                cp = tileBox;
            }
            QuadRect latlonRect = cp.getLatLonBounds();
            double topLatitude = latlonRect.top;
            double leftLongitude = latlonRect.left;
            double bottomLatitude = latlonRect.bottom;
            double rightLongitude = latlonRect.right;
            double lat = topLatitude - bottomLatitude + 0.1;
            double lon = rightLongitude - leftLongitude + 0.1;
            this.drawLocations(tileBox, canvas, topLatitude + lat, leftLongitude - lon, bottomLatitude - lat, rightLongitude + lon);
            this.gpaint.dispose();
            this.gpaint = null;
            this.gactionPaint.dispose();
            this.gactionPaint = null;
            this.gpaintIconAction.dispose();
            this.gpaintIconAction = null;
            this.gpaintIcon.dispose();
            this.gpaintIcon = null;
            this.gpaint2.dispose();
            this.gpaint2 = null;
            this.gpaint_1.dispose();
            this.gpaint_1 = null;
            this.gshadowPaint.dispose();
            this.gshadowPaint = null;
        }
    }

    public boolean isRouteReady() {
        return this.helper.getFinalLocation() != null && this.helper.getRoute().isCalculated();
    }

    @Override
    public void onDraw(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawAction(RotatedTileBox tb, Graphics2D canvas) {
        if (this.actionPoints.size() > 0) {
            this.rotate(-tb.getRotate(), tb.getCenterPixelX(), tb.getCenterPixelY());
            try {
                Path2D.Double pth = new Path2D.Double();
                AffineTransform matrix = new AffineTransform();
                boolean first = true;
                int x = 0;
                int px = 0;
                int py = 0;
                int y = 0;
                for (int i = 0; i < this.actionPoints.size(); ++i) {
                    Location o = this.actionPoints.get(i);
                    if (o == null) {
                        first = true;
                        this.gactionPaint.draw(pth);
                        double angleRad = Math.atan2(y - py, x - px);
                        double angle = angleRad + 1.5707963267948966;
                        double distSegment = Math.sqrt((y - py) * (y - py) + (x - px) * (x - px));
                        if (distSegment == 0.0) continue;
                        float pdx = x - px;
                        float pdy = y - py;
                        matrix.setToTranslation((float)px + pdx - (float)(this.actionArrow.getWidth() / 2), (float)py + pdy);
                        matrix.rotate(angle, this.actionArrow.getWidth() / 2, 0.0);
                        matrix.translate(0.0, -this.actionArrow.getHeight() / 2);
                        this.gpaintIconAction.drawImage(this.actionArrow, matrix, null);
                        continue;
                    }
                    px = x;
                    py = y;
                    x = (int)tb.getPixXFromLatLon(o.getLatitude(), o.getLongitude());
                    y = (int)tb.getPixYFromLatLon(o.getLatitude(), o.getLongitude());
                    if (first) {
                        pth.reset();
                        ((Path2D)pth).moveTo(x, y);
                        first = false;
                        continue;
                    }
                    ((Path2D)pth).lineTo(x, y);
                }
            }
            finally {
                this.rotate(tb.getRotate(), tb.getCenterPixelX(), tb.getCenterPixelY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSegment(RotatedTileBox tb, Graphics2D canvas) {
        if (this.points.size() > 0) {
            this.rotate(-tb.getRotate(), tb.getCenterPixelX(), tb.getCenterPixelY());
            try {
                TIntArrayList tx = new TIntArrayList();
                TIntArrayList ty = new TIntArrayList();
                for (int i = 0; i < this.points.size(); ++i) {
                    Location o = this.points.get(i);
                    int x = (int)tb.getPixXFromLatLon(o.getLatitude(), o.getLongitude());
                    int y = (int)tb.getPixYFromLatLon(o.getLatitude(), o.getLongitude());
                    tx.add(x);
                    ty.add(y);
                }
                this.calculatePath(tb, tx, ty, this.path);
                if (this.isPaint_1) {
                    this.gpaint_1.draw(this.path);
                }
                if (this.isShadowPaint) {
                    this.gshadowPaint.draw(this.path);
                }
                this.gpaint.draw(this.path);
                if (this.isPaint2) {
                    this.gpaint2.draw(this.path);
                }
                if (tb.getZoomAnimation() == 0.0) {
                    TIntArrayList lst = new TIntArrayList(50);
                    this.calculateSplitPaths(tb, tx, ty, lst);
                    this.drawArrowsOverPath(canvas, lst, this.coloredArrowUp);
                }
            }
            finally {
                this.rotate(tb.getRotate(), tb.getCenterPixelX(), tb.getCenterPixelY());
            }
        }
    }

    private void rotate(float pRotate, int pCenterPixelX, int pCenterPixelY) {
        this.gpaint.rotate(pRotate, pCenterPixelX, pCenterPixelY);
        this.gactionPaint.rotate(pRotate, pCenterPixelX, pCenterPixelY);
        this.gpaintIconAction.rotate(pRotate, pCenterPixelX, pCenterPixelY);
        this.gpaintIcon.rotate(pRotate, pCenterPixelX, pCenterPixelY);
        this.gpaint2.rotate(pRotate, pCenterPixelX, pCenterPixelY);
        this.gpaint_1.rotate(pRotate, pCenterPixelX, pCenterPixelY);
        this.gshadowPaint.rotate(pRotate, pCenterPixelX, pCenterPixelY);
    }

    private void drawArrowsOverPath(Graphics2D canvas, TIntArrayList lst, BufferedImage arrow) {
        float pxStep = (float)arrow.getHeight() * 4.0f;
        AffineTransform matrix = new AffineTransform();
        float dist = 0.0f;
        for (int i = 0; i < lst.size(); i += 4) {
            int px = lst.get(i);
            int py = lst.get(i + 1);
            int x = lst.get(i + 2);
            int y = lst.get(i + 3);
            float angleRad = (float)Math.atan2(y - py, x - px);
            float angle = (float)((double)angleRad + 1.5707963267948966);
            float distSegment = (float)Math.sqrt((y - py) * (y - py) + (x - px) * (x - px));
            if (distSegment == 0.0f) continue;
            int len = (int)(distSegment / pxStep);
            if (len > 0) {
                float pdx = (x - px) / len;
                float pdy = (y - py) / len;
                for (int k = 1; k <= len; ++k) {
                    matrix.setToTranslation((float)px + (float)k * pdx - (float)(arrow.getWidth() / 2), (float)py + pdy * (float)k);
                    matrix.rotate(angle, arrow.getWidth() / 2, 0.0);
                    matrix.translate(0.0, -arrow.getHeight() / 2);
                    this.gpaintIcon.drawImage(arrow, matrix, null);
                    dist = 0.0f;
                }
                continue;
            }
            if (dist > pxStep) {
                matrix.setToTranslation(px + (x - px) / 2 - arrow.getWidth() / 2, py + (y - py) / 2);
                matrix.rotate(angle, arrow.getWidth() / 2, 0.0);
                matrix.translate(0.0, -arrow.getHeight() / 2);
                this.gpaintIcon.drawImage(arrow, matrix, null);
                dist = 0.0f;
                continue;
            }
            dist += distSegment;
        }
    }

    public void drawLocations(RotatedTileBox tb, Graphics2D canvas, double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude) {
        this.points.clear();
        this.actionPoints.clear();
        boolean previousVisible = false;
        Location lastProjection = this.helper.getLastProjection();
        if (lastProjection != null && leftLongitude <= lastProjection.getLongitude() && lastProjection.getLongitude() <= rightLongitude && bottomLatitude <= lastProjection.getLatitude() && lastProjection.getLatitude() <= topLatitude) {
            this.points.add(lastProjection);
            previousVisible = true;
        }
        List<Location> routeNodes = this.helper.getRoute().getRouteLocations();
        int cd = this.helper.getRoute().getCurrentRoute();
        List<RouteDirectionInfo> rd = this.helper.getRouteDirections();
        Iterator<RouteDirectionInfo> it = rd.iterator();
        for (int i = 0; i < routeNodes.size(); ++i) {
            Location ls = routeNodes.get(i);
            if (leftLongitude <= ls.getLongitude() && ls.getLongitude() <= rightLongitude && bottomLatitude <= ls.getLatitude() && ls.getLatitude() <= topLatitude) {
                this.points.add(ls);
                if (!previousVisible) {
                    if (i > 0) {
                        this.points.add(0, routeNodes.get(i - 1));
                    } else if (lastProjection != null) {
                        this.points.add(0, lastProjection);
                    }
                }
                previousVisible = true;
                continue;
            }
            if (!previousVisible) continue;
            this.points.add(ls);
            this.drawSegment(tb, canvas);
            previousVisible = false;
            this.points.clear();
        }
        this.drawSegment(tb, canvas);
        if (tb.getZoom() >= 14) {
            this.calculateActionPoints(topLatitude, leftLongitude, bottomLatitude, rightLongitude, lastProjection, routeNodes, cd, it, tb.getZoom());
            this.drawAction(tb, canvas);
        }
    }

    private void calculateActionPoints(double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, Location lastProjection, List<Location> routeNodes, int cd, Iterator<RouteDirectionInfo> it, int zoom) {
        RouteDirectionInfo nf = null;
        double DISTANCE_ACTION = 35.0;
        if (zoom >= 17) {
            DISTANCE_ACTION = 15.0;
        } else if (zoom == 15) {
            DISTANCE_ACTION = 70.0;
        } else if (zoom < 15) {
            DISTANCE_ACTION = 110.0;
        }
        double actionDist = 0.0;
        Location previousAction = null;
        this.actionPoints.clear();
        int prevFinishPoint = -1;
        for (int routePoint = 0; routePoint < routeNodes.size(); ++routePoint) {
            boolean visible;
            boolean action;
            int pnt;
            Location loc = routeNodes.get(routePoint);
            if (nf != null) {
                int n = pnt = nf.routeEndPointOffset == 0 ? nf.routePointOffset : nf.routeEndPointOffset;
                if (pnt < routePoint + cd) {
                    nf = null;
                }
            }
            while (nf == null && it.hasNext()) {
                nf = it.next();
                pnt = nf.routeEndPointOffset == 0 ? nf.routePointOffset : nf.routeEndPointOffset;
                if (pnt >= routePoint + cd) continue;
                nf = null;
            }
            boolean bl = action = nf != null && (nf.routePointOffset == routePoint + cd || nf.routePointOffset <= routePoint + cd && routePoint + cd <= nf.routeEndPointOffset);
            if (!action && previousAction == null) continue;
            boolean bl2 = visible = leftLongitude <= loc.getLongitude() && loc.getLongitude() <= rightLongitude && bottomLatitude <= loc.getLatitude() && loc.getLatitude() <= topLatitude;
            if (action && !visible && previousAction == null) continue;
            if (!action) {
                float dist = loc.distanceTo(previousAction);
                if ((actionDist += (double)dist) >= DISTANCE_ACTION) {
                    this.actionPoints.add(this.calculateProjection(1.0 - (actionDist - DISTANCE_ACTION) / (double)dist, previousAction, loc));
                    this.actionPoints.add(null);
                    prevFinishPoint = routePoint;
                    previousAction = null;
                    actionDist = 0.0;
                    continue;
                }
                this.actionPoints.add(loc);
                previousAction = loc;
                continue;
            }
            if (previousAction == null) {
                this.addPreviousToActionPoints(lastProjection, routeNodes, DISTANCE_ACTION, prevFinishPoint, routePoint, loc);
            }
            this.actionPoints.add(loc);
            previousAction = loc;
            prevFinishPoint = -1;
            actionDist = 0.0;
        }
        if (previousAction != null) {
            this.actionPoints.add(null);
        }
    }

    private void addPreviousToActionPoints(Location lastProjection, List<Location> routeNodes, double DISTANCE_ACTION, int prevFinishPoint, int routePoint, Location loc) {
        int ind = this.actionPoints.size();
        Location lprevious = loc;
        double dist = 0.0;
        for (int k = routePoint - 1; k >= -1; --k) {
            Location l = k == -1 ? lastProjection : routeNodes.get(k);
            float locDist = lprevious.distanceTo(l);
            if ((dist += (double)locDist) >= DISTANCE_ACTION) {
                if (!(locDist > 1.0f)) break;
                this.actionPoints.add(ind, this.calculateProjection(1.0 - (dist - DISTANCE_ACTION) / (double)locDist, lprevious, l));
                break;
            }
            this.actionPoints.add(ind, l);
            lprevious = l;
            if (prevFinishPoint != k) continue;
            if (ind < 2) break;
            this.actionPoints.remove(ind - 2);
            this.actionPoints.remove(ind - 2);
            break;
        }
    }

    private Location calculateProjection(double part, Location lp, Location l) {
        Location p = new Location(l);
        p.setLatitude(lp.getLatitude() + part * (l.getLatitude() - lp.getLatitude()));
        p.setLongitude(lp.getLongitude() + part * (l.getLongitude() - lp.getLongitude()));
        return p;
    }

    public RoutingHelper getHelper() {
        return this.helper;
    }

    public Path2D getPath() {
        return this.path;
    }

    @Override
    public void destroyLayer() {
    }

    @Override
    public boolean drawInScreenPixels() {
        return false;
    }

    @Override
    public boolean onLongPressEvent(Point2D point, RotatedTileBox tileBox) {
        return false;
    }

    @Override
    public boolean onSingleTap(Point2D point, RotatedTileBox tileBox) {
        return false;
    }

    @Override
    public String getObjectDescription(Object pO) {
        if (pO instanceof RouteCalculationResult) {
            RouteCalculationResult res = (RouteCalculationResult)pO;
            return res.getErrorMessage();
        }
        return null;
    }

    @Override
    public PointDescription getObjectName(Object pO) {
        if (pO instanceof RouteCalculationResult) {
            RouteCalculationResult res = (RouteCalculationResult)pO;
            return new PointDescription("wpt", res.getErrorMessage());
        }
        return null;
    }

    @Override
    public boolean disableSingleTap() {
        return false;
    }

    @Override
    public boolean disableLongPressOnMap() {
        return false;
    }

    @Override
    public boolean isObjectClickable(Object pO) {
        return pO instanceof RouteCalculationResult;
    }

    public void getRouteFromPoint(RotatedTileBox tb, Point2D point, List<? super RouteCalculationResult> res) {
        if (!this.isRouteReady()) {
            return;
        }
        double r = 15.0 * tb.getPixelDistanceInMeters();
        LatLon latLon = tb.getLatLonFromPixel(point.getX(), point.getY());
        RouteCalculationResult routeCalculationResult = this.helper.getRoute();
        List<Location> routeNodes = routeCalculationResult.getRouteLocations();
        LatLon last = null;
        for (Location l : routeNodes) {
            double distance;
            if (last != null && Math.abs(distance = MapUtils.getOrthogonalDistance(latLon, last, l.getLatLon())) < r) {
                res.add(routeCalculationResult);
                return;
            }
            last = l.getLatLon();
        }
    }

    @Override
    public void collectObjectsFromPoint(Point2D pPoint, RotatedTileBox pTileBox, List<Object> pRes) {
        this.getRouteFromPoint(pTileBox, pPoint, pRes);
    }

    @Override
    public LatLon getObjectLocation(Object pO) {
        return null;
    }
}

