/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.I18n;

public class UnclosedWays
extends Test {
    private static final UnclosedWaysCheck[] checks = new UnclosedWaysCheck[]{new UnclosedWaysCheck(1101, "natural", I18n.marktr("natural type {0}"), new HashSet<String>(Arrays.asList("arete", "bay", "cave", "cliff", "coastline", "gorge", "gully", "peak", "ridge", "saddle", "strait", "tree", "tree_row", "valley", "volcano"))), new UnclosedWaysCheck(1102, "landuse", I18n.marktr("landuse type {0}")), new UnclosedWaysCheck(1103, "amenities", I18n.marktr("amenities type {0}")), new UnclosedWaysCheck(1104, "sport", I18n.marktr("sport type {0}"), new HashSet<String>(Arrays.asList("water_slide", "climbing", "skiing", "toboggan", "bobsleigh"))), new UnclosedWaysCheck(1105, "tourism", I18n.marktr("tourism type {0}"), new HashSet<String>(Arrays.asList("attraction", "artwork"))), new UnclosedWaysCheck(1106, "shop", I18n.marktr("shop type {0}")), new UnclosedWaysCheck(1107, "leisure", I18n.marktr("leisure type {0}"), new HashSet<String>(Arrays.asList("track", "slipway"))), new UnclosedWaysCheck(1108, "waterway", I18n.marktr("waterway type {0}"), new HashSet<String>(Arrays.asList("riverbank")), false), new UnclosedWaysCheck(1109, "boundary", I18n.marktr("boundary type {0}")), new UnclosedWaysCheck(1110, "area:highway", I18n.marktr("area:highway type {0}")), new UnclosedWaysBooleanCheck(1120, "building", I18n.marktr("building")), new UnclosedWaysBooleanCheck(1130, "area", I18n.marktr("area"))};

    public UnclosedWays() {
        super(I18n.tr("Unclosed Ways", new Object[0]), I18n.tr("This tests if ways which should be circular are closed.", new Object[0]));
    }

    public Set<String> getCheckedKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (UnclosedWaysCheck c : checks) {
            keys.add(c.key);
        }
        return keys;
    }

    @Override
    public void visit(Way w) {
        if (!w.isUsable() || w.isArea()) {
            return;
        }
        for (OsmPrimitive parent : w.getReferrers()) {
            if (!(parent instanceof Relation) || !((Relation)parent).isMultipolygon()) continue;
            return;
        }
        for (UnclosedWaysCheck c : checks) {
            TestError error = c.getTestError(w, this);
            if (error == null) continue;
            this.errors.add(error);
            return;
        }
        if (ElemStyles.hasOnlyAreaElements(w) && !w.getNodes().isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1131).message(I18n.tr("Unclosed way", new Object[0]), I18n.marktr("Area style way is not closed"), new Object()).primitives(w).highlight(Arrays.asList(w.firstNode(), w.lastNode())).build());
        }
    }

    private static final class UnclosedWaysBooleanCheck
    extends UnclosedWaysCheck {
        UnclosedWaysBooleanCheck(int code, String key, String engMessage) {
            super(code, key, engMessage);
        }

        @Override
        protected boolean isValueErroneous(String value) {
            Boolean btest = OsmUtils.getOsmBoolean(value);
            return btest != null && btest != false || btest == null && value != null;
        }
    }

    private static class UnclosedWaysCheck {
        public final int code;
        public final String key;
        private final String engMessage;
        private final Set<String> specialValues;
        private final boolean ignore;

        UnclosedWaysCheck(int code, String key, String engMessage) {
            this(code, key, engMessage, Collections.emptySet());
        }

        UnclosedWaysCheck(int code, String key, String engMessage, Set<String> ignoredValues) {
            this(code, key, engMessage, ignoredValues, true);
        }

        UnclosedWaysCheck(int code, String key, String engMessage, Set<String> specialValues, boolean ignore) {
            this.code = code;
            this.key = key;
            this.engMessage = engMessage;
            this.specialValues = specialValues;
            this.ignore = ignore;
        }

        public final TestError getTestError(Way w, UnclosedWays test) {
            String value = w.get(this.key);
            if (this.isValueErroneous(value)) {
                Object[] objectArray;
                TestError.Builder builder = TestError.builder(test, Severity.WARNING, this.code);
                String string = I18n.tr("Unclosed way", new Object[0]);
                if (this.engMessage.contains("{0}")) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = value;
                } else {
                    objectArray = new Object[]{};
                }
                return builder.message(string, this.engMessage, objectArray).primitives(w).highlight(Arrays.asList(w.firstNode(), w.lastNode())).build();
            }
            return null;
        }

        protected boolean isValueErroneous(String value) {
            return value != null && this.ignore != this.specialValues.contains(value);
        }
    }
}

